#
# PySNMP MIB module FDDI-SMT73-MIB (http://pysnmp.sf.net)
# ASN.1 source http://mibs.snmplabs.com:80/asn1/FDDI-SMT73-MIB
# Produced by pysmi-0.0.7 at Sun Feb 14 00:12:32 2016
# On host bldfarm platform Linux version 4.1.13-100.fc21.x86_64 by user goose
# Using Python version 3.5.0 (default, Jan  5 2016, 17:11:52) 
#
( OctetString, Integer, ObjectIdentifier, ) = mibBuilder.importSymbols("ASN1", "OctetString", "Integer", "ObjectIdentifier")
( NamedValues, ) = mibBuilder.importSymbols("ASN1-ENUMERATION", "NamedValues")
( ValueSizeConstraint, ConstraintsIntersection, ValueRangeConstraint, SingleValueConstraint, ConstraintsUnion, ) = mibBuilder.importSymbols("ASN1-REFINEMENT", "ValueSizeConstraint", "ConstraintsIntersection", "ValueRangeConstraint", "SingleValueConstraint", "ConstraintsUnion")
( NotificationGroup, ModuleCompliance, ) = mibBuilder.importSymbols("SNMPv2-CONF", "NotificationGroup", "ModuleCompliance")
( MibScalar, MibTable, MibTableRow, MibTableColumn, Integer32, Gauge32, Bits, Unsigned32, Counter64, TimeTicks, NotificationType, ModuleIdentity, ObjectIdentity, mib_2, MibIdentifier, iso, Counter32, IpAddress, ) = mibBuilder.importSymbols("SNMPv2-SMI", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "Integer32", "Gauge32", "Bits", "Unsigned32", "Counter64", "TimeTicks", "NotificationType", "ModuleIdentity", "ObjectIdentity", "mib-2", "MibIdentifier", "iso", "Counter32", "IpAddress")
( DisplayString, TextualConvention, ) = mibBuilder.importSymbols("SNMPv2-TC", "DisplayString", "TextualConvention")
transmission = MibIdentifier((1, 3, 6, 1, 2, 1, 10))
fddi = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 15))
fddimib = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 15, 73))
class FddiTimeNano(Integer32):
    subtypeSpec = Integer32.subtypeSpec+ValueRangeConstraint(0,2147483647)

class FddiTimeMilli(Integer32):
    subtypeSpec = Integer32.subtypeSpec+ValueRangeConstraint(0,2147483647)

class FddiResourceId(Integer32):
    subtypeSpec = Integer32.subtypeSpec+ValueRangeConstraint(0,65535)

class FddiSMTStationIdType(OctetString):
    subtypeSpec = OctetString.subtypeSpec+ValueSizeConstraint(8,8)
    fixedLength = 8

class FddiMACLongAddressType(OctetString):
    subtypeSpec = OctetString.subtypeSpec+ValueSizeConstraint(6,6)
    fixedLength = 6

fddimibSMT = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 15, 73, 1))
fddimibMAC = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 15, 73, 2))
fddimibMACCounters = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 15, 73, 3))
fddimibPATH = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 15, 73, 4))
fddimibPORT = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 15, 73, 5))
fddimibSMTNumber = MibScalar((1, 3, 6, 1, 2, 1, 10, 15, 73, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibSMTNumber.setDescription("The number of SMT implementations (regardless of \n                      their current state) on this network management \n                      application entity.  The value for this variable \n                      must remain constant at least from one re- \n                      initialization of the entity's network management \n                      system to the next re-initialization.")
fddimibSMTTable = MibTable((1, 3, 6, 1, 2, 1, 10, 15, 73, 1, 2), )
if mibBuilder.loadTexts: fddimibSMTTable.setDescription('A list of SMT entries.  The number of entries \n                      shall not exceed the value of fddimibSMTNumber.')
fddimibSMTEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 15, 73, 1, 2, 1), ).setIndexNames((0, "FDDI-SMT73-MIB", "fddimibSMTIndex"))
if mibBuilder.loadTexts: fddimibSMTEntry.setDescription('An SMT entry containing information common to a \n                      given SMT.')
fddimibSMTIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 1, 2, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibSMTIndex.setDescription("A unique value for each SMT.  The value for each \n                      SMT must remain constant at least from one re- \n                      initialization of the entity's network management \n                      system to the next re-initialization.")
fddimibSMTStationId = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 1, 2, 1, 2), FddiSMTStationIdType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibSMTStationId.setDescription('Used to uniquely identify an FDDI station.')
fddimibSMTOpVersionId = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 1, 2, 1, 3), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibSMTOpVersionId.setDescription('The version that this station is using for its \n                      operation (refer to ANSI 7.1.2.2). The value of \n                      this variable is 2 for this SMT revision.')
fddimibSMTHiVersionId = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 1, 2, 1, 4), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibSMTHiVersionId.setDescription('The highest version of SMT that this station \n                      supports (refer to ANSI 7.1.2.2).')
fddimibSMTLoVersionId = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 1, 2, 1, 5), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibSMTLoVersionId.setDescription('The lowest version of SMT that this station \n                      supports (refer to ANSI 7.1.2.2).')
fddimibSMTUserData = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 1, 2, 1, 6), OctetString().subtype(subtypeSpec=ValueSizeConstraint(32,32)).setFixedLength(32)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: fddimibSMTUserData.setDescription('This variable contains 32 octets of user defined \n                      information. The information shall be an ASCII \n                      string.')
fddimibSMTMIBVersionId = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 1, 2, 1, 7), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibSMTMIBVersionId.setDescription('The version of the FDDI MIB of this station.  The \n                      value of this variable is 1 for this SMT \n                      revision.')
fddimibSMTMACCts = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 1, 2, 1, 8), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibSMTMACCts.setDescription('The number of MACs in this station or \n                      concentrator.')
fddimibSMTNonMasterCts = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 1, 2, 1, 9), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,2))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibSMTNonMasterCts.setDescription('The value of this variable is the number of A, B, \n                      and S ports in this station or concentrator.')
fddimibSMTMasterCts = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 1, 2, 1, 10), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibSMTMasterCts.setDescription('The number of M Ports in a node. If the node is \n                      not a concentrator, the value of the variable is \n                      zero.')
fddimibSMTAvailablePaths = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 1, 2, 1, 11), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,7))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibSMTAvailablePaths.setDescription('A value that indicates the PATH types available \n                      in the station. \n \n                      The value is a sum.  This value initially takes \n                      the value zero, then for each type of PATH that \n                      this node has available, 2 raised to a power is \n                      added to the sum.  The powers are according to the \n                      following table: \n \n                               Path   Power \n                            Primary     0 \n                          Secondary     1 \n                              Local     2 \n \n                      For example, a station having Primary and Local \n                      PATHs available would have a value of 5 (2**0 + \n                      2**2).')
fddimibSMTConfigCapabilities = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 1, 2, 1, 12), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,3))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibSMTConfigCapabilities.setDescription("A value that indicates the configuration \n                      capabilities of a node. The 'Hold Available' bit \n                      indicates the support of the optional Hold \n                      Function, which is controlled by \n                      fddiSMTConfigPolicy.  The 'CF-Wrap-AB' bit \n                      indicates that the station has the capability of \n                      performing a wrap_ab (refer to ANSI SMT 9.7.2.2). \n \n                      The value is a sum.  This value initially takes \n                      the value zero, then for each of the configuration \n                      policies currently enforced on the node, 2 raised \n                      to a power is added to the sum.  The powers are \n                      according to the following table: \n \n                                 Policy   Power \n                          holdAvailable     0 \n                             CF-Wrap-AB     1 ")
fddimibSMTConfigPolicy = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 1, 2, 1, 13), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,1))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: fddimibSMTConfigPolicy.setDescription("A value that indicates the configuration policies \n                      currently desired in a node.  'Hold' is one of the \n                      terms used for the Hold Flag, an optional ECM flag \n                      used to enable the optional Hold policy. \n \n                      The value is a sum.  This value initially takes \n                      the value zero, then for each of the configuration \n                      policies currently enforced on the node, 2 raised \n                      to a power is added to the sum.  The powers are \n                      according to the following table: \n \n                                     Policy   Power \n                          configurationhold     0 ")
fddimibSMTConnectionPolicy = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 1, 2, 1, 14), Integer32().subtype(subtypeSpec=ValueRangeConstraint(32768,65535))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: fddimibSMTConnectionPolicy.setDescription("A value representing the connection policies in \n                      effect in a node. A station sets the corresponding \n                      bit for each of the connection types that it \n                      rejects. The letter designations, X and Y, in the \n                      'rejectX-Y' names have the following significance: \n                      X represents the PC-Type of the local PORT and Y \n                      represents the PC_Type of the adjacent PORT \n                      (PC_Neighbor). The evaluation of Connection- \n                      Policy (PC-Type, PC-Neighbor) is done to determine \n                      the setting of T- Val(3) in the PC-Signalling \n                      sequence (refer to ANSI 9.6.3). Note that Bit 15, \n                      (rejectM-M), is always set and cannot be cleared. \n \n                      The value is a sum.  This value initially takes \n                      the value zero, then for each of the connection \n                      policies currently enforced on the node, 2 raised \n                      to a power is added to the sum.  The powers are \n                      according to the following table: \n \n                             Policy   Power \n                          rejectA-A     0 \n                          rejectA-B     1 \n                          rejectA-S     2 \n                          rejectA-M     3 \n                          rejectB-A     4 \n                          rejectB-B     5 \n                          rejectB-S     6 \n                          rejectB-M     7 \n                          rejectS-A     8 \n                          rejectS-B     9 \n                          rejectS-S     10 \n                          rejectS-M     11 \n                          rejectM-A     12 \n                          rejectM-B     13 \n                          rejectM-S     14 \n                          rejectM-M     15 ")
fddimibSMTTNotify = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 1, 2, 1, 15), Integer32().subtype(subtypeSpec=ValueRangeConstraint(2,30))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: fddimibSMTTNotify.setDescription('The timer, expressed in seconds, used in the \n                      Neighbor Notification protocol. It has a range of \n                      2 seconds to 30 seconds, and its default value is \n                      30 seconds (refer to ANSI SMT 8.2).')
fddimibSMTStatRptPolicy = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 1, 2, 1, 16), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2,))).clone(namedValues=NamedValues(("true", 1), ("false", 2),))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: fddimibSMTStatRptPolicy.setDescription('If true, indicates that the node will generate \n                      Status Reporting Frames for its implemented events \n                      and conditions. It has an initial value of true. \n                      This variable determines the value of the \n                      SR_Enable Flag (refer to ANSI SMT 8.3.2.1).')
fddimibSMTTraceMaxExpiration = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 1, 2, 1, 17), FddiTimeMilli()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: fddimibSMTTraceMaxExpiration.setDescription('Reference Trace_Max (refer to ANSI SMT \n                      9.4.4.2.2).')
fddimibSMTBypassPresent = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 1, 2, 1, 18), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2,))).clone(namedValues=NamedValues(("true", 1), ("false", 2),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibSMTBypassPresent.setDescription('A flag indicating if the station has a bypass on \n                      its AB port pair.')
fddimibSMTECMState = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 1, 2, 1, 19), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5, 6, 7, 8,))).clone(namedValues=NamedValues(("ec0", 1), ("ec1", 2), ("ec2", 3), ("ec3", 4), ("ec4", 5), ("ec5", 6), ("ec6", 7), ("ec7", 8),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibSMTECMState.setDescription('Indicates the current state of the ECM state \n                      machine (refer to ANSI SMT 9.5.2).')
fddimibSMTCFState = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 1, 2, 1, 20), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13,))).clone(namedValues=NamedValues(("cf0", 1), ("cf1", 2), ("cf2", 3), ("cf3", 4), ("cf4", 5), ("cf5", 6), ("cf6", 7), ("cf7", 8), ("cf8", 9), ("cf9", 10), ("cf10", 11), ("cf11", 12), ("cf12", 13),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibSMTCFState.setDescription('The attachment configuration for the station or \n                      concentrator (refer to ANSI SMT 9.7.2.2).')
fddimibSMTRemoteDisconnectFlag = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 1, 2, 1, 21), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2,))).clone(namedValues=NamedValues(("true", 1), ("false", 2),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibSMTRemoteDisconnectFlag.setDescription('A flag indicating that the station was remotely \n                      disconnected from the network as a result of \n                      receiving an fddiSMTAction, disconnect (refer to \n                      ANSI SMT 6.4.5.3) in a Parameter Management Frame. \n                      A station requires a Connect Action to rejoin and \n                      clear the flag (refer to ANSI SMT 6.4.5.2).')
fddimibSMTStationStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 1, 2, 1, 22), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3,))).clone(namedValues=NamedValues(("concatenated", 1), ("separated", 2), ("thru", 3),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibSMTStationStatus.setDescription('The current status of the primary and secondary \n                      paths within this station.')
fddimibSMTPeerWrapFlag = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 1, 2, 1, 23), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2,))).clone(namedValues=NamedValues(("true", 1), ("false", 2),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibSMTPeerWrapFlag.setDescription('This variable assumes the value of the \n                      PeerWrapFlag in CFM (refer to ANSI SMT \n                      9.7.2.4.4).')
fddimibSMTTimeStamp = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 1, 2, 1, 24), FddiTimeMilli()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibSMTTimeStamp.setDescription('This variable assumes the value of TimeStamp \n                      (refer to ANSI SMT 8.3.2.1).')
fddimibSMTTransitionTimeStamp = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 1, 2, 1, 25), FddiTimeMilli()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibSMTTransitionTimeStamp.setDescription('This variable assumes the value of \n                      TransitionTimeStamp (refer to ANSI SMT 8.3.2.1).')
fddimibSMTStationAction = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 1, 2, 1, 26), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5, 6, 7, 8,))).clone(namedValues=NamedValues(("other", 1), ("connect", 2), ("disconnect", 3), ("path-Test", 4), ("self-Test", 5), ("disable-a", 6), ("disable-b", 7), ("disable-m", 8),))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: fddimibSMTStationAction.setDescription("This object, when read, always returns a value of \n                      other(1).  The behavior of setting this variable \n                      to each of the acceptable values is as follows: \n \n                           other(1): Results in an appropriate error. \n                           connect(2): Generates a Connect signal to ECM \n                                to begin a connection sequence. See ANSI \n                                Ref 9.4.2. \n                           disconnect(3): Generates a Disconnect signal \n                                to ECM. see ANSI Ref 9.4.2. \n                           path-Test(4): Initiates a station Path_Test. \n                                The Path_Test variable (see ANSI Ref \n                                9.4.1) is set to 'Testing'. The results \n                                of this action are not specified in this \n                                standard. \n                           self-Test(5): Initiates a station Self_Test. \n                                The results of this action are not \n                                specified in this standard. \n                           disable-a(6): Causes a PC_Disable on the A \n                                port if the A port mode is peer. \n                           disable-b(7): Causes a PC_Disable on the B \n                                port if the B port mode is peer. \n                           disable-m(8): Causes a PC_Disable on all M \n                                ports. \n \n                      Attempts to set this object to all other values \n                      results in an appropriate error.  The result of \n                      setting this variable to path-Test(4) or self- \n                      Test(5) is implementation-specific.")
fddimibMACNumber = MibScalar((1, 3, 6, 1, 2, 1, 10, 15, 73, 2, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibMACNumber.setDescription("The total number of MAC implementations (across \n                      all SMTs) on this network management application \n                      entity.  The value for this variable must remain \n                      constant at least from one re-initialization of \n                      the entity's network management system to the next \n                      re-initialization.")
fddimibMACTable = MibTable((1, 3, 6, 1, 2, 1, 10, 15, 73, 2, 2), )
if mibBuilder.loadTexts: fddimibMACTable.setDescription('A list of MAC entries.  The number of entries \n                      shall not exceed the value of fddimibMACNumber.')
fddimibMACEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 15, 73, 2, 2, 1), ).setIndexNames((0, "FDDI-SMT73-MIB", "fddimibMACSMTIndex"), (0, "FDDI-SMT73-MIB", "fddimibMACIndex"))
if mibBuilder.loadTexts: fddimibMACEntry.setDescription('A MAC entry containing information common to a \n                      given MAC.')
fddimibMACSMTIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 2, 2, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibMACSMTIndex.setDescription('The value of the SMT index associated with this \n                      MAC.')
fddimibMACIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 2, 2, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibMACIndex.setDescription('Index variable for uniquely identifying the MAC \n                      object instances, which is the same as the \n                      corresponding resource index in SMT.')
fddimibMACIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 2, 2, 1, 3), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibMACIfIndex.setDescription('The value of the MIB-II ifIndex corresponding to \n                      this MAC.  If none is applicable, 0 is returned.')
fddimibMACFrameStatusFunctions = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 2, 2, 1, 4), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,7))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibMACFrameStatusFunctions.setDescription("Indicates the MAC's optional Frame Status \n                      processing functions. \n \n                      The value is a sum.  This value initially takes \n                      the value zero, then for each function present, 2 \n                      raised to a power is added to the sum.  The powers \n                      are according to the following table: \n \n                           function   Power \n                       fs-repeating     0 \n                         fs-setting     1 \n                        fs-clearing     2 ")
fddimibMACTMaxCapability = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 2, 2, 1, 5), FddiTimeNano()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibMACTMaxCapability.setDescription('Indicates the maximum time value of fddiMACTMax \n                      that this MAC can support.')
fddimibMACTVXCapability = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 2, 2, 1, 6), FddiTimeNano()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibMACTVXCapability.setDescription('Indicates the maximum time value of \n                      fddiMACTvxValue that this MAC can support.')
fddimibMACAvailablePaths = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 2, 2, 1, 7), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,7))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibMACAvailablePaths.setDescription('Indicates the paths available for this MAC (refer \n                      to ANSI SMT 9.7.7). \n \n                      The value is a sum.  This value initially takes \n                      the value zero, then for each type of PATH that \n                      this MAC has available, 2 raised to a power is \n                      added to the sum.  The powers are according to the \n                      following table: \n \n                               Path   Power \n                            Primary     0 \n                          Secondary     1 \n                              Local     2 ')
fddimibMACCurrentPath = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 2, 2, 1, 8), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5, 6,))).clone(namedValues=NamedValues(("isolated", 1), ("local", 2), ("secondary", 3), ("primary", 4), ("concatenated", 5), ("thru", 6),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibMACCurrentPath.setDescription('Indicates the Path into which this MAC is \n                      currently inserted (refer to ANSI 9.7.7).')
fddimibMACUpstreamNbr = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 2, 2, 1, 9), FddiMACLongAddressType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibMACUpstreamNbr.setDescription("The MAC's upstream neighbor's long individual MAC \n                      address. It has an initial value of the SMT- \n                      Unknown-MAC Address and is only modified as \n                      specified by the Neighbor Information Frame \n                      protocol (refer to ANSI SMT 7.2.1 and 8.2).")
fddimibMACDownstreamNbr = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 2, 2, 1, 10), FddiMACLongAddressType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibMACDownstreamNbr.setDescription("The MAC's downstream neighbor's long individual \n                      MAC address. It has an initial value of the SMT- \n                      Unknown-MAC Address and is only modified as \n                      specified by the Neighbor Information Frame \n                      protocol (refer to ANSI SMT 7.2.1 and 8.2).")
fddimibMACOldUpstreamNbr = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 2, 2, 1, 11), FddiMACLongAddressType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibMACOldUpstreamNbr.setDescription("The previous value of the MAC's upstream \n                      neighbor's long individual MAC address. It has an \n                      initial value of the SMT-Unknown- MAC Address and \n                      is only modified as specified by the Neighbor \n                      Information Frame protocol (refer to ANSI SMT \n                      7.2.1 and 8.2).")
fddimibMACOldDownstreamNbr = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 2, 2, 1, 12), FddiMACLongAddressType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibMACOldDownstreamNbr.setDescription("The previous value of the MAC's downstream \n                      neighbor's long individual MAC address. It has an \n                      initial value of the SMT- Unknown-MAC Address and \n                      is only modified as specified by the Neighbor \n                      Information Frame protocol (refer to ANSI SMT \n                      7.2.1 and 8.2).")
fddimibMACDupAddressTest = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 2, 2, 1, 13), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3,))).clone(namedValues=NamedValues(("none", 1), ("pass", 2), ("fail", 3),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibMACDupAddressTest.setDescription('The Duplicate Address Test flag, Dup_Addr_Test \n                      (refer to ANSI 8.2).')
fddimibMACRequestedPaths = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 2, 2, 1, 14), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,255))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: fddimibMACRequestedPaths.setDescription('List of permitted Paths which specifies the \n                      Path(s) into which the MAC may be inserted (refer \n                      to ansi SMT 9.7). \n \n                      The value is a sum which represents the individual \n                      paths that are desired.  This value initially \n                      takes the value zero, then for each type of PATH \n                      that this node is, 2 raised to a power is added to \n                      the sum.  The powers are according to the \n                      following table: \n \n                                         Path   Power \n                                        local     0 \n                          secondary-alternate     1 \n                            primary-alternate     2 \n                       concatenated-alternate     3 \n                          secondary-preferred     4 \n                            primary-preferred     5 \n                       concatenated-preferred     6 \n                                         thru     7 ')
fddimibMACDownstreamPORTType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 2, 2, 1, 15), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5,))).clone(namedValues=NamedValues(("a", 1), ("b", 2), ("s", 3), ("m", 4), ("none", 5),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibMACDownstreamPORTType.setDescription('Indicates the PC-Type of the first port that is \n                      downstream of this MAC (the exit port).')
fddimibMACSMTAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 2, 2, 1, 16), FddiMACLongAddressType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibMACSMTAddress.setDescription('The 48-bit individual address of the MAC used for \n                      SMT frames.')
fddimibMACTReq = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 2, 2, 1, 17), FddiTimeNano()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibMACTReq.setDescription('This variable is the T_Req_value passed to the \n                      MAC.  Without having detected a duplicate, the \n                      time value of this variable shall assume the \n                      maximum supported time value which is less than or \n                      equal to the time value of fddiPATHMaxT-Req.  When \n                      a MAC has an address detected as a duplicate, it \n                      may use a time value for this variable greater \n                      than the time value of fddiPATHTMaxLowerBound.  A \n                      station shall cause claim when the new T_Req may \n                      cause the value of T_Neg to change in the claim \n                      process, (i.e., time value new T_Req < T_Neg, or \n                      old T_Req = T_Neg).')
fddimibMACTNeg = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 2, 2, 1, 18), FddiTimeNano()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibMACTNeg.setDescription('It is reported as a FddiTimeNano number.')
fddimibMACTMax = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 2, 2, 1, 19), FddiTimeNano()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibMACTMax.setDescription('This variable is the T_Max_value passed to the \n                      MAC.  The time value of this variable shall assume \n                      the minimum suported time value which is greater \n                      than or equal to the time value of fddiPATHT- \n                      MaxLowerBound')
fddimibMACTvxValue = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 2, 2, 1, 20), FddiTimeNano()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibMACTvxValue.setDescription('This variable is the TVX_value passed to the MAC. \n                      The time value of this variable shall assume the \n                      minimum suported time value which is greater than \n                      or equal to the time value of \n                      fddiPATHTVXLowerBound.')
fddimibMACFrameCts = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 2, 2, 1, 21), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibMACFrameCts.setDescription('A count of the number of frames received by this \n                      MAC (refer to ANSI MAC 7.5.1).')
fddimibMACCopiedCts = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 2, 2, 1, 22), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibMACCopiedCts.setDescription("A count that should as closely as possible match \n                      the number of frames addressed to (A bit set) and \n                      successfully copied into the station's receive \n                      buffers (C bit set) by this MAC (refer to ANSI MAC \n                      7.5). Note that this count does not include MAC \n                      frames.")
fddimibMACTransmitCts = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 2, 2, 1, 23), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibMACTransmitCts.setDescription('A count that should as closely as possible match \n                      the number of frames transmitted by this MAC \n                      (refer to ANSI MAC 7.5).  Note that this count \n                      does not include MAC frames.')
fddimibMACErrorCts = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 2, 2, 1, 24), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibMACErrorCts.setDescription('A count of the number of frames that were \n                      detected in error by this MAC that had not been \n                      detected in error by another MAC (refer to ANSI \n                      MAC 7.5.2).')
fddimibMACLostCts = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 2, 2, 1, 25), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibMACLostCts.setDescription('A count of the number of instances that this MAC \n                      detected a format error during frame reception \n                      such that the frame was stripped (refer to ANSI \n                      MAC 7.5.3).')
fddimibMACFrameErrorThreshold = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 2, 2, 1, 26), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,65535))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: fddimibMACFrameErrorThreshold.setDescription('A threshold for determining when a MAC Condition \n                      report (see ANSI 8.3.1.1) shall be generated. \n                      Stations not supporting variable thresholds shall \n                      have a value of 0 and a range of (0..0).')
fddimibMACFrameErrorRatio = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 2, 2, 1, 27), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibMACFrameErrorRatio.setDescription('This variable is the value of the ratio, \n \n                       ((delta fddiMACLostCts + delta fddiMACErrorCts) / \n                       (delta fddiMACFrameCts + delta fddiMACLostCts )) \n                       * 2**16 ')
fddimibMACRMTState = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 2, 2, 1, 28), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5, 6, 7, 8,))).clone(namedValues=NamedValues(("rm0", 1), ("rm1", 2), ("rm2", 3), ("rm3", 4), ("rm4", 5), ("rm5", 6), ("rm6", 7), ("rm7", 8),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibMACRMTState.setDescription('Indicates the current state of the RMT State \n                      Machine (refer to ANSI 10.3.2).')
fddimibMACDaFlag = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 2, 2, 1, 29), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2,))).clone(namedValues=NamedValues(("true", 1), ("false", 2),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibMACDaFlag.setDescription('The RMT flag Duplicate Address Flag, DA_Flag \n                      (refer to ANSI 10.2.1.2).')
fddimibMACUnaDaFlag = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 2, 2, 1, 30), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2,))).clone(namedValues=NamedValues(("true", 1), ("false", 2),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibMACUnaDaFlag.setDescription('A flag, UNDA_Flag (refer to ANSI 8.2.2.1), set \n                      when the upstream neighbor reports a duplicate \n                      address condition. Cleared when the condition \n                      clears.')
fddimibMACFrameErrorFlag = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 2, 2, 1, 31), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2,))).clone(namedValues=NamedValues(("true", 1), ("false", 2),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibMACFrameErrorFlag.setDescription('Indicates the MAC Frame Error Condition is \n                      present when set. Cleared when the condition \n                      clears and on station initialization.')
fddimibMACMAUnitdataAvailable = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 2, 2, 1, 32), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2,))).clone(namedValues=NamedValues(("true", 1), ("false", 2),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibMACMAUnitdataAvailable.setDescription('This variable shall take on the value of the \n                      MAC_Avail flag defined in RMT.')
fddimibMACHardwarePresent = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 2, 2, 1, 33), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2,))).clone(namedValues=NamedValues(("true", 1), ("false", 2),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibMACHardwarePresent.setDescription('This variable indicates the presence of \n                      underlying hardware support for this MAC object. \n                      If the value of this object is false(2), the \n                      reporting of the objects in this entry may be \n                      handled in an implementation-specific manner.')
fddimibMACMAUnitdataEnable = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 2, 2, 1, 34), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2,))).clone(namedValues=NamedValues(("true", 1), ("false", 2),))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: fddimibMACMAUnitdataEnable.setDescription('This variable determines the value of the \n                      MA_UNITDATA_Enable flag in RMT.  The default and \n                      initial value of this flag is true(1).')
fddimibMACCountersTable = MibTable((1, 3, 6, 1, 2, 1, 10, 15, 73, 3, 1), )
if mibBuilder.loadTexts: fddimibMACCountersTable.setDescription('A list of MAC Counters entries.  The number of \n                      entries shall not exceed the value of \n                      fddimibMACNumber.')
fddimibMACCountersEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 15, 73, 3, 1, 1), ).setIndexNames((0, "FDDI-SMT73-MIB", "fddimibMACSMTIndex"), (0, "FDDI-SMT73-MIB", "fddimibMACIndex"))
if mibBuilder.loadTexts: fddimibMACCountersEntry.setDescription('A MAC Counters entry containing information \n                      common to a given MAC.')
fddimibMACTokenCts = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 3, 1, 1, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibMACTokenCts.setDescription('A count that should as closely as possible match \n                      the number of times the station has received a \n                      token (total of non-restricted and restricted) on \n                      this MAC (see ANSI MAC 7.4). This count is \n                      valuable for determination of network load.')
fddimibMACTvxExpiredCts = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 3, 1, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibMACTvxExpiredCts.setDescription('A count that should as closely as possible match \n                      the number of times that TVX has expired.')
fddimibMACNotCopiedCts = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 3, 1, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibMACNotCopiedCts.setDescription('A count that should as closely as possible match \n                      the number of frames that were addressed to this \n                      MAC but were not copied into its receive buffers \n                      (see ANSI MAC 7.5). For example, this might occur \n                      due to local buffer congestion. Because of \n                      implementation considerations, this count may not \n                      match the actual number of frames not copied. It \n                      is not a requirement that this count be exact. \n                      Note that this count does not include MAC frames.')
fddimibMACLateCts = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 3, 1, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibMACLateCts.setDescription('A count that should as closely as possible match \n                      the number of TRT expirations since this MAC was \n                      reset or a token was received (refer to ANSI MAC \n                      7.4.5).')
fddimibMACRingOpCts = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 3, 1, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibMACRingOpCts.setDescription("The count of the number of times the ring has \n                      entered the 'Ring_Operational' state from the \n                      'Ring Not Operational' state.  This count is \n                      updated when a SM_MA_STATUS.Indication of a change \n                      in the Ring_Operational status occurs (refer to \n                      ANSI 6.1.4). Because of implementation \n                      considerations, this count may be less than the \n                      actual RingOp_Ct. It is not a requirement that \n                      this count be exact.")
fddimibMACNotCopiedRatio = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 3, 1, 1, 6), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibMACNotCopiedRatio.setDescription('This variable is the value of the ratio: \n \n                       (delta fddiMACNotCopiedCts / \n                       (delta fddiMACCopiedCts + \n                         delta fddiMACNotCopiedCts )) * 2**16 ')
fddimibMACNotCopiedFlag = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 3, 1, 1, 7), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2,))).clone(namedValues=NamedValues(("true", 1), ("false", 2),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibMACNotCopiedFlag.setDescription('Indicates that the Not Copied condition is \n                      present when read as true(1).  Set to false(2) \n                      when the condition clears and on station \n                      initialization.')
fddimibMACNotCopiedThreshold = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 3, 1, 1, 8), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,65535))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: fddimibMACNotCopiedThreshold.setDescription('A threshold for determining when a MAC condition \n                      report shall be generated.  Stations not \n                      supporting variable thresholds shall have a value \n                      of 0 and a range of (0..0).')
fddimibPATHNumber = MibScalar((1, 3, 6, 1, 2, 1, 10, 15, 73, 4, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibPATHNumber.setDescription("The total number of PATHs possible (across all \n                      SMTs) on this network management application \n                      entity.  The value for this variable must remain \n                      constant at least from one re-initialization of \n                      the entity's network management system to the next \n                      re-initialization.")
fddimibPATHTable = MibTable((1, 3, 6, 1, 2, 1, 10, 15, 73, 4, 2), )
if mibBuilder.loadTexts: fddimibPATHTable.setDescription('A list of PATH entries.  The number of entries \n                      shall not exceed the value of fddimibPATHNumber.')
fddimibPATHEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 15, 73, 4, 2, 1), ).setIndexNames((0, "FDDI-SMT73-MIB", "fddimibPATHSMTIndex"), (0, "FDDI-SMT73-MIB", "fddimibPATHIndex"))
if mibBuilder.loadTexts: fddimibPATHEntry.setDescription('A PATH entry containing information common to a \n                      given PATH.')
fddimibPATHSMTIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 4, 2, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibPATHSMTIndex.setDescription('The value of the SMT index associated with this \n                      PATH.')
fddimibPATHIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 4, 2, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibPATHIndex.setDescription('Index variable for uniquely identifying the \n                      primary, secondary and local PATH object \n                      instances. Local PATH object instances are \n                      represented with integer values 3 to 255.')
fddimibPATHTVXLowerBound = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 4, 2, 1, 3), FddiTimeNano()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: fddimibPATHTVXLowerBound.setDescription('Specifies the minimum time value of \n                      fddiMACTvxValue that shall be used by any MAC that \n                      is configured in this path. The operational value \n                      of fddiMACTvxValue is managed by settting this \n                      variable.  This variable has the time value range \n                      of: \n \n                      0 < fddimibPATHTVXLowerBound < fddimibPATHMaxTReq \n                      Changes to this variable shall either satisfy the \n                      time value relationship: \n \n                      fddimibPATHTVXLowerBound <= \n                      fddimibMACTVXCapability \n \n                      of each of the MACs currently on the path, or be \n                      considered out of range.  The initial value of \n                      fddimibPATHTVXLowerBound shall be 2500 nsec (2.5 \n                      ms).')
fddimibPATHTMaxLowerBound = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 4, 2, 1, 4), FddiTimeNano()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: fddimibPATHTMaxLowerBound.setDescription('Specifies the minimum time value of fddiMACTMax \n                      that shall be used by any MAC that is configured \n                      in this path.  The operational value of \n                      fddiMACTMax is managed by setting this variable. \n                      This variable has the time value range of: \n \n                      fddimibPATHMaxTReq <= fddimibPATHTMaxLowerBound \n \n                      and an absolute time value range of: \n \n                      10000nsec (10 msec) <= fddimibPATHTMaxLowerBound \n \n                      Changes to this variable shall either satisfy the \n                      time value relationship: \n \n                      fddimibPATHTMaxLowerBound < \n                      fddimibMACTMaxCapability \n \n                      of each of the MACs currently on the path, or be \n                      considered out of range.  The initial value of \n                      fddimibPATHTMaxLowerBound shall be 165000 nsec \n                      (165 msec).')
fddimibPATHMaxTReq = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 4, 2, 1, 5), FddiTimeNano()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: fddimibPATHMaxTReq.setDescription('Specifies the maximum time value of fddiMACT-Req \n                      that shall be used by any MAC that is configured \n                      in this path.  The operational value of fddiMACT- \n                      Req is managed by setting this variable.  This \n                      variable has the time value range of: \n \n                      fddimibPATHTVXLowerBound < fddimibPATHMaxTReq <= \n                                               fddimibPATHTMaxLowerBound. \n \n                      The default value of fddimibPATHMaxTReq is 165000 \n                      nsec (165 msec).')
fddimibPATHConfigTable = MibTable((1, 3, 6, 1, 2, 1, 10, 15, 73, 4, 3), )
if mibBuilder.loadTexts: fddimibPATHConfigTable.setDescription('A table of Path configuration entries.  This \n                      table lists all the resources that may be in this \n                      Path.')
fddimibPATHConfigEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 15, 73, 4, 3, 1), ).setIndexNames((0, "FDDI-SMT73-MIB", "fddimibPATHConfigSMTIndex"), (0, "FDDI-SMT73-MIB", "fddimibPATHConfigPATHIndex"), (0, "FDDI-SMT73-MIB", "fddimibPATHConfigTokenOrder"))
if mibBuilder.loadTexts: fddimibPATHConfigEntry.setDescription('A collection of objects containing information \n                      for a given PATH Configuration entry.')
fddimibPATHConfigSMTIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 4, 3, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibPATHConfigSMTIndex.setDescription('The value of the SMT index associated with this \n                      configuration entry.')
fddimibPATHConfigPATHIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 4, 3, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibPATHConfigPATHIndex.setDescription('The value of the PATH resource index associated \n                      with this configuration entry.')
fddimibPATHConfigTokenOrder = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 4, 3, 1, 3), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibPATHConfigTokenOrder.setDescription('An object associated with Token order for this \n                      entry.  Thus if the token passes resources a, b, c \n                      and d, in that order, then the value of this \n                      object for these resources would be 1, 2, 3 and 4 \n                      respectively.')
fddimibPATHConfigResourceType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 4, 3, 1, 4), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(2, 4,))).clone(namedValues=NamedValues(("mac", 2), ("port", 4),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibPATHConfigResourceType.setDescription('The type of resource associated with this \n                      configuration entry.')
fddimibPATHConfigResourceIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 4, 3, 1, 5), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibPATHConfigResourceIndex.setDescription('The value of the SMT resource index used to refer \n                      to the instance of this MAC or Port resource.')
fddimibPATHConfigCurrentPath = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 4, 3, 1, 6), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5, 6,))).clone(namedValues=NamedValues(("isolated", 1), ("local", 2), ("secondary", 3), ("primary", 4), ("concatenated", 5), ("thru", 6),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibPATHConfigCurrentPath.setDescription('The current insertion status for this resource on \n                      this Path.')
fddimibPORTNumber = MibScalar((1, 3, 6, 1, 2, 1, 10, 15, 73, 5, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibPORTNumber.setDescription("The total number of PORT implementations (across \n                      all SMTs) on this network management application \n                      entity.  The value for this variable must remain \n                      constant at least from one re-initialization of \n                      the entity's network management system to the next \n                      re-initialization.")
fddimibPORTTable = MibTable((1, 3, 6, 1, 2, 1, 10, 15, 73, 5, 2), )
if mibBuilder.loadTexts: fddimibPORTTable.setDescription('A list of PORT entries.  The number of entries \n                      shall not exceed the value of fddimibPORTNumber.')
fddimibPORTEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 15, 73, 5, 2, 1), ).setIndexNames((0, "FDDI-SMT73-MIB", "fddimibPORTSMTIndex"), (0, "FDDI-SMT73-MIB", "fddimibPORTIndex"))
if mibBuilder.loadTexts: fddimibPORTEntry.setDescription('A PORT entry containing information common to a \n                      given PORT.')
fddimibPORTSMTIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 5, 2, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibPORTSMTIndex.setDescription('The value of the SMT index associated with this \n                      PORT.')
fddimibPORTIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 5, 2, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibPORTIndex.setDescription("A unique value for each PORT within a given SMT, \n                      which is the same as the corresponding resource \n                      index in SMT.  The value for each PORT must remain \n                      constant at least from one re-initialization of \n                      the entity's network management system to the next \n                      re-initialization.")
fddimibPORTMyType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 5, 2, 1, 3), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5,))).clone(namedValues=NamedValues(("a", 1), ("b", 2), ("s", 3), ("m", 4), ("none", 5),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibPORTMyType.setDescription("The value of the PORT's PC_Type (refer to ANSI \n                      9.4.1, and 9.6.3.2).")
fddimibPORTNeighborType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 5, 2, 1, 4), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5,))).clone(namedValues=NamedValues(("a", 1), ("b", 2), ("s", 3), ("m", 4), ("none", 5),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibPORTNeighborType.setDescription('The type of the remote PORT as determined in PCM. \n                      This variable has an initial value of none, and is \n                      only modified in PC_RCode(3)_Actions (refer to \n                      ANSI SMT 9.6.3.2).')
fddimibPORTConnectionPolicies = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 5, 2, 1, 5), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,3))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: fddimibPORTConnectionPolicies.setDescription("A value representing the PORT's connection \n                      policies desired in the node. The value of pc- \n                      mac-lct is a term used in the PC_MAC_LCT Flag (see \n                      9.4.3.2).  The value of pc-mac-loop is a term used \n                      in the PC_MAC_Loop Flag. \n \n                      The value is a sum.  This value initially takes \n                      the value zero, then for each PORT policy, 2 \n                      raised to a power is added to the sum.  The powers \n                      are according to the following table: \n \n                                    Policy   Power \n                                pc-mac-lct     0 \n                               pc-mac-loop     1 ")
fddimibPORTMACIndicated = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 5, 2, 1, 6), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4,))).clone(namedValues=NamedValues(("tVal9FalseRVal9False", 1), ("tVal9FalseRVal9True", 2), ("tVal9TrueRVal9False", 3), ("tVal9TrueRVal9True", 4),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibPORTMACIndicated.setDescription('The indications (T_Val(9), R_Val(9)) in PC- \n                      Signalling, of the intent to place a MAC in the \n                      output token path to a PORT (refer to ANSI SMT \n                      9.6.3.2.).')
fddimibPORTCurrentPath = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 5, 2, 1, 7), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5, 6,))).clone(namedValues=NamedValues(("ce0", 1), ("ce1", 2), ("ce2", 3), ("ce3", 4), ("ce4", 5), ("ce5", 6),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibPORTCurrentPath.setDescription('Indicates the Path(s) into which this PORT is \n                      currently inserted.')
fddimibPORTRequestedPaths = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 5, 2, 1, 8), OctetString().subtype(subtypeSpec=ValueSizeConstraint(3,3)).setFixedLength(3)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: fddimibPORTRequestedPaths.setDescription("This variable is a list of permitted Paths where \n                      each list element defines the Port's permitted \n                      Paths.  The first octet corresponds to 'none', the \n                      second octet to 'tree', and the third octet to \n                      'peer'.")
fddimibPORTMACPlacement = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 5, 2, 1, 9), FddiResourceId()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibPORTMACPlacement.setDescription('Indicates the MAC, if any, whose transmit path \n                      exits the station via this PORT. The value shall \n                      be zero if there is no MAC associated with the \n                      PORT. Otherwise, the MACIndex of the MAC will be \n                      the value of the variable.')
fddimibPORTAvailablePaths = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 5, 2, 1, 10), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,7))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibPORTAvailablePaths.setDescription('Indicates the Paths which are available to this \n                      Port. In the absence of faults, the A and B Ports \n                      will always have both the Primary and Secondary \n                      Paths available. \n \n                      The value is a sum.  This value initially takes \n                      the value zero, then for each type of PATH that \n                      this port has available, 2 raised to a power is \n                      added to the sum.  The powers are according to the \n                      following table: \n \n                               Path   Power \n                            Primary     0 \n                          Secondary     1 \n                              Local     2 ')
fddimibPORTPMDClass = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 5, 2, 1, 11), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5, 6, 7, 8,))).clone(namedValues=NamedValues(("multimode", 1), ("single-mode1", 2), ("single-mode2", 3), ("sonet", 4), ("low-cost-fiber", 5), ("twisted-pair", 6), ("unknown", 7), ("unspecified", 8),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibPORTPMDClass.setDescription('This variable indicates the type of PMD entity \n                      associated with this port.')
fddimibPORTConnectionCapabilities = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 5, 2, 1, 12), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,3))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibPORTConnectionCapabilities.setDescription('A value that indicates the connection \n                      capabilities of the port. The pc-mac-lct bit \n                      indicates that the station has the capability of \n                      setting the PC_MAC_LCT Flag. The pc-mac-loop bit \n                      indicates that the station has the capability of \n                      setting the PC_MAC_Loop Flag (refer to ANSI \n                      9.4.3.2). \n \n                      The value is a sum.  This value initially takes \n                      the value zero, then for each capability that this \n                      port has, 2 raised to a power is added to the sum. \n                      The powers are according to the following table: \n \n                         capability   Power \n                         pc-mac-lct     0 \n                        pc-mac-loop     1 ')
fddimibPORTBSFlag = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 5, 2, 1, 13), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2,))).clone(namedValues=NamedValues(("true", 1), ("false", 2),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibPORTBSFlag.setDescription('This variable assumes the value of the BS_Flag \n                      (refer to ANSI SMT 9.4.3.3).')
fddimibPORTLCTFailCts = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 5, 2, 1, 14), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibPORTLCTFailCts.setDescription('The count of the consecutive times the link \n                      confidence test (LCT) has failed during connection \n                      management (refer to ANSI 9.4.1).')
fddimibPORTLerEstimate = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 5, 2, 1, 15), Integer32().subtype(subtypeSpec=ValueRangeConstraint(4,15))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibPORTLerEstimate.setDescription('A long term average link error rate. It ranges \n                      from 10**-4 to 10**-15 and is reported as the \n                      absolute value of the base 10 logarithm (refer to \n                      ANSI SMT 9.4.7.5.).')
fddimibPORTLemRejectCts = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 5, 2, 1, 16), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibPORTLemRejectCts.setDescription('A link error monitoring count of the times that a \n                      link has been rejected.')
fddimibPORTLemCts = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 5, 2, 1, 17), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibPORTLemCts.setDescription('The aggregate link error monitor error count, set \n                      to zero only on station initialization.')
fddimibPORTLerCutoff = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 5, 2, 1, 18), Integer32().subtype(subtypeSpec=ValueRangeConstraint(4,15))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: fddimibPORTLerCutoff.setDescription('The link error rate estimate at which a link \n                      connection will be broken. It ranges from 10**-4 \n                      to 10**-15 and is reported as the absolute value \n                      of the base 10 logarithm (default of 7).')
fddimibPORTLerAlarm = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 5, 2, 1, 19), Integer32().subtype(subtypeSpec=ValueRangeConstraint(4,15))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: fddimibPORTLerAlarm.setDescription('The link error rate estimate at which a link \n                      connection will generate an alarm. It ranges from \n                      10**-4 to 10**-15 and is reported as the absolute \n                      value of the base 10 logarithm of the estimate \n                      (default of 8).')
fddimibPORTConnectState = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 5, 2, 1, 20), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4,))).clone(namedValues=NamedValues(("disabled", 1), ("connecting", 2), ("standby", 3), ("active", 4),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibPORTConnectState.setDescription('An indication of the connect state of this PORT \n                      and is equal to the value of Connect_State (refer \n                      to ANSI 9.4.1)')
fddimibPORTPCMState = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 5, 2, 1, 21), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5, 6, 7, 8, 9, 10,))).clone(namedValues=NamedValues(("pc0", 1), ("pc1", 2), ("pc2", 3), ("pc3", 4), ("pc4", 5), ("pc5", 6), ("pc6", 7), ("pc7", 8), ("pc8", 9), ("pc9", 10),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibPORTPCMState.setDescription("The state of this Port's PCM state machine refer \n                      to ANSI SMT 9.6.2).")
fddimibPORTPCWithhold = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 5, 2, 1, 22), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4,))).clone(namedValues=NamedValues(("none", 1), ("m-m", 2), ("otherincompatible", 3), ("pathnotavailable", 4),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibPORTPCWithhold.setDescription('The value of PC_Withhold (refer to ANSI SMT \n                      9.4.1).')
fddimibPORTLerFlag = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 5, 2, 1, 23), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2,))).clone(namedValues=NamedValues(("true", 1), ("false", 2),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibPORTLerFlag.setDescription('The condition becomes active when the value of \n                      fddiPORTLerEstimate is less than or equal to \n                      fddiPORTLerAlarm. This will be reported with the \n                      Status Report Frames (SRF) (refer to ANSI SMT \n                       7.2.7 and 8.3).')
fddimibPORTHardwarePresent = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 5, 2, 1, 24), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2,))).clone(namedValues=NamedValues(("true", 1), ("false", 2),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fddimibPORTHardwarePresent.setDescription('This variable indicates the presence of \n                      underlying hardware support for this Port object. \n                      If the value of this object is false(2), the \n                      reporting of the objects in this entry may be \n                      handled in an implementation-specific manner.')
fddimibPORTAction = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 73, 5, 2, 1, 25), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5, 6,))).clone(namedValues=NamedValues(("other", 1), ("maintPORT", 2), ("enablePORT", 3), ("disablePORT", 4), ("startPORT", 5), ("stopPORT", 6),))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: fddimibPORTAction.setDescription("Causes a Control signal to be generated with a \n                      control_action of 'Signal' and the 'variable' \n                      parameter set with the appropriate value (i.e., \n                      PC_Maint, PC_Enable, PC_Disable, PC_Start, or \n                      PC_Stop) (refer to ANSI 9.4.2).")
mibBuilder.exportSymbols("FDDI-SMT73-MIB", fddimibPATHConfigSMTIndex=fddimibPATHConfigSMTIndex, fddimibMACAvailablePaths=fddimibMACAvailablePaths, fddimibSMTTransitionTimeStamp=fddimibSMTTransitionTimeStamp, fddimibPORTHardwarePresent=fddimibPORTHardwarePresent, fddimibMACRequestedPaths=fddimibMACRequestedPaths, fddimibPATHConfigTable=fddimibPATHConfigTable, fddimibMACMAUnitdataAvailable=fddimibMACMAUnitdataAvailable, fddimibMACFrameStatusFunctions=fddimibMACFrameStatusFunctions, fddimibSMTConfigCapabilities=fddimibSMTConfigCapabilities, fddimibMACNumber=fddimibMACNumber, fddimibMACSMTIndex=fddimibMACSMTIndex, fddimibSMTECMState=fddimibSMTECMState, FddiResourceId=FddiResourceId, fddimibPATHSMTIndex=fddimibPATHSMTIndex, fddimibMACTMaxCapability=fddimibMACTMaxCapability, fddimibMAC=fddimibMAC, fddimibPORTLemRejectCts=fddimibPORTLemRejectCts, fddimibMACSMTAddress=fddimibMACSMTAddress, fddimibMACRMTState=fddimibMACRMTState, fddimibPORTEntry=fddimibPORTEntry, fddimibSMTTNotify=fddimibSMTTNotify, fddimibPORTLerAlarm=fddimibPORTLerAlarm, FddiTimeNano=FddiTimeNano, fddimibMACFrameErrorRatio=fddimibMACFrameErrorRatio, fddimibPORTSMTIndex=fddimibPORTSMTIndex, fddimibSMTStationAction=fddimibSMTStationAction, fddimibMACCopiedCts=fddimibMACCopiedCts, fddimibSMTNumber=fddimibSMTNumber, fddimib=fddimib, FddiMACLongAddressType=FddiMACLongAddressType, fddimibSMTLoVersionId=fddimibSMTLoVersionId, fddimibMACTransmitCts=fddimibMACTransmitCts, fddimibMACHardwarePresent=fddimibMACHardwarePresent, fddimibSMTBypassPresent=fddimibSMTBypassPresent, fddimibPORTIndex=fddimibPORTIndex, fddimibSMTTable=fddimibSMTTable, fddimibMACDownstreamNbr=fddimibMACDownstreamNbr, fddimibSMTOpVersionId=fddimibSMTOpVersionId, fddimibPORTConnectionCapabilities=fddimibPORTConnectionCapabilities, fddimibPATHConfigResourceIndex=fddimibPATHConfigResourceIndex, fddimibPORTCurrentPath=fddimibPORTCurrentPath, fddimibMACIndex=fddimibMACIndex, fddimibMACOldDownstreamNbr=fddimibMACOldDownstreamNbr, fddimibSMTTraceMaxExpiration=fddimibSMTTraceMaxExpiration, fddimibPORTPCWithhold=fddimibPORTPCWithhold, fddimibPORTTable=fddimibPORTTable, fddimibMACNotCopiedFlag=fddimibMACNotCopiedFlag, FddiSMTStationIdType=FddiSMTStationIdType, fddimibMACTvxValue=fddimibMACTvxValue, fddimibSMTRemoteDisconnectFlag=fddimibSMTRemoteDisconnectFlag, fddimibMACTokenCts=fddimibMACTokenCts, fddimibMACCountersTable=fddimibMACCountersTable, fddimibPORTNumber=fddimibPORTNumber, fddimibMACNotCopiedCts=fddimibMACNotCopiedCts, fddimibPORTConnectState=fddimibPORTConnectState, fddimibPORTAction=fddimibPORTAction, fddimibSMTStationStatus=fddimibSMTStationStatus, fddimibPORTNeighborType=fddimibPORTNeighborType, fddimibPORTLerEstimate=fddimibPORTLerEstimate, fddimibPORTPMDClass=fddimibPORTPMDClass, fddimibMACTVXCapability=fddimibMACTVXCapability, FddiTimeMilli=FddiTimeMilli, fddimibPATHTVXLowerBound=fddimibPATHTVXLowerBound, fddimibSMTHiVersionId=fddimibSMTHiVersionId, fddimibMACTReq=fddimibMACTReq, fddimibPATHNumber=fddimibPATHNumber, fddimibSMTUserData=fddimibSMTUserData, fddimibMACFrameCts=fddimibMACFrameCts, fddimibPATHConfigTokenOrder=fddimibPATHConfigTokenOrder, transmission=transmission, fddimibMACLostCts=fddimibMACLostCts, fddimibMACFrameErrorThreshold=fddimibMACFrameErrorThreshold, fddimibSMTConnectionPolicy=fddimibSMTConnectionPolicy, fddimibMACErrorCts=fddimibMACErrorCts, fddimibPORT=fddimibPORT, fddimibPORTLCTFailCts=fddimibPORTLCTFailCts, fddi=fddi, fddimibPORTMACPlacement=fddimibPORTMACPlacement, fddimibSMTEntry=fddimibSMTEntry, fddimibPORTLerFlag=fddimibPORTLerFlag, fddimibPORTLemCts=fddimibPORTLemCts, fddimibMACIfIndex=fddimibMACIfIndex, fddimibSMTCFState=fddimibSMTCFState, fddimibPATHConfigEntry=fddimibPATHConfigEntry, fddimibPORTAvailablePaths=fddimibPORTAvailablePaths, fddimibPATHTMaxLowerBound=fddimibPATHTMaxLowerBound, fddimibPORTMyType=fddimibPORTMyType, fddimibMACTvxExpiredCts=fddimibMACTvxExpiredCts, fddimibPATHConfigCurrentPath=fddimibPATHConfigCurrentPath, fddimibSMTIndex=fddimibSMTIndex, fddimibPATHConfigResourceType=fddimibPATHConfigResourceType, fddimibSMTPeerWrapFlag=fddimibSMTPeerWrapFlag, fddimibSMTStationId=fddimibSMTStationId, fddimibPATH=fddimibPATH, fddimibMACDownstreamPORTType=fddimibMACDownstreamPORTType, fddimibMACOldUpstreamNbr=fddimibMACOldUpstreamNbr, fddimibPORTRequestedPaths=fddimibPORTRequestedPaths, fddimibSMT=fddimibSMT, fddimibMACFrameErrorFlag=fddimibMACFrameErrorFlag, fddimibPATHConfigPATHIndex=fddimibPATHConfigPATHIndex, fddimibPATHMaxTReq=fddimibPATHMaxTReq, fddimibMACUnaDaFlag=fddimibMACUnaDaFlag, fddimibPORTBSFlag=fddimibPORTBSFlag, fddimibPORTConnectionPolicies=fddimibPORTConnectionPolicies, fddimibMACCurrentPath=fddimibMACCurrentPath, fddimibMACRingOpCts=fddimibMACRingOpCts, fddimibSMTMACCts=fddimibSMTMACCts, fddimibSMTTimeStamp=fddimibSMTTimeStamp, fddimibMACNotCopiedRatio=fddimibMACNotCopiedRatio, fddimibMACDupAddressTest=fddimibMACDupAddressTest, fddimibPORTLerCutoff=fddimibPORTLerCutoff, fddimibSMTConfigPolicy=fddimibSMTConfigPolicy, fddimibMACTMax=fddimibMACTMax, fddimibPATHIndex=fddimibPATHIndex, fddimibMACLateCts=fddimibMACLateCts, fddimibSMTNonMasterCts=fddimibSMTNonMasterCts, fddimibMACCountersEntry=fddimibMACCountersEntry, fddimibMACUpstreamNbr=fddimibMACUpstreamNbr, fddimibPATHEntry=fddimibPATHEntry, fddimibPATHTable=fddimibPATHTable, fddimibMACMAUnitdataEnable=fddimibMACMAUnitdataEnable, fddimibPORTPCMState=fddimibPORTPCMState, fddimibMACTNeg=fddimibMACTNeg, fddimibSMTMIBVersionId=fddimibSMTMIBVersionId, fddimibSMTMasterCts=fddimibSMTMasterCts, fddimibSMTStatRptPolicy=fddimibSMTStatRptPolicy, fddimibPORTMACIndicated=fddimibPORTMACIndicated, fddimibMACNotCopiedThreshold=fddimibMACNotCopiedThreshold, fddimibMACCounters=fddimibMACCounters, fddimibSMTAvailablePaths=fddimibSMTAvailablePaths, fddimibMACEntry=fddimibMACEntry, fddimibMACDaFlag=fddimibMACDaFlag, fddimibMACTable=fddimibMACTable)
