# MusicBrainz Picard

![Github Actions Status](https://github.com/metabrainz/picard/workflows/Run%20tests/badge.svg)
[![Codacy Grade](https://img.shields.io/codacy/grade/4dcabf0a13ed4b27b3a381ce9ba96ecc/master.svg?style=flat-square&label=Codacy)](https://app.codacy.com/gh/metabrainz/picard)

[MusicBrainz Picard](https://picard.musicbrainz.org) is a cross-platform (Linux, macOS, Windows) audio tagging application. It is the official [MusicBrainz](https://musicbrainz.org) tagger.

Picard supports the majority of audio file formats, is capable of using audio fingerprints ([AcoustIDs](https://musicbrainz.org/doc/AcoustID)), performing CD lookups and [disc ID](https://musicbrainz.org/doc/Disc_ID) submissions, and it has excellent Unicode support. Additionally, there are several plugins available that extend Picard's features.

When tagging files, Picard uses an album-oriented approach. This approach allows it to utilize the MusicBrainz data as effectively as possible and correctly tag your music. For more information, [see the illustrated quick start guide to tagging](https://picard.musicbrainz.org/quick-start/) and the [documentation](https://picard-docs.musicbrainz.org/).


## Features

- **Multiple formats:** Picard supports all popular music formats,
  including MP3, FLAC, OGG, M4A, WMA, WAV, and more.
- **AcoustID:** Picard uses [AcoustID](https://musicbrainz.org/doc/AcoustID)
  audio fingerprints, allowing files to be identified by the actual
  music, even if they have no metadata.
- **Comprehensive database:** Picard uses the open and
  community-maintained [MusicBrainz database](https://musicbrainz.org)
  to provide accurate information about millions of music releases.
- **CD lookups:** Picard can lookup entire music CDs with a click.
- **Plugin support:** If you need a particular feature, you can choose
  from a selection of [available plugins](https://picard.musicbrainz.org/plugins/) or
  [write your own](https://picard-docs.musicbrainz.org/en/extending/plugins.html).
- **Scripting:** A flexible and powerful, yet easy to learn, scripting language
  allows you to exactly specify how your music files will be named and how the
  tags will look like.
- **Cover Art:** Picard can find and download the correct cover art for your albums.
- **Open Source:** Picard is licensed under the
  [GNU General Public License 2.0](COPYING.txt)
  or later, and is hosted on GitHub where it is actively
  developed.


## Installation

Binary downloads are available on the [Picard download page](https://picard.musicbrainz.org/downloads/).

[INSTALL.md has instructions on building this codebase.](INSTALL.md)


## Support and issue reporting

Please report all bugs and feature requests in the [MusicBrainz issue tracker](https://tickets.metabrainz.org/browse/PICARD). If you need support in using Picard please read the [documentation](https://picard-docs.musicbrainz.org/) first and have a look at the [MusicBrainz community forums](https://community.metabrainz.org/c/picard).


## Trivia

Picard is named after [Captain Jean-Luc Picard](https://en.wikipedia.org/wiki/Jean-Luc_Picard) from the TV series [Star Trek: The Next Generation](https://en.wikipedia.org/wiki/Star_Trek:_The_Next_Generation).
