/*
 * IPv6 counters from procfs (/proc/net/snmp6)
 *
 * Copyright (c) 2015 Red Hat.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 */

#include "linux_table.h"

enum {
    _PM_IP6_INRECEIVES,
    _PM_IP6_INHDRERRORS,
    _PM_IP6_INTOOBIGERRORS,
    _PM_IP6_INNOROUTES,
    _PM_IP6_INADDRERRORS,
    _PM_IP6_INUNKNOWNPROTOS,
    _PM_IP6_INTRUNCATEDPKTS,
    _PM_IP6_INDISCARDS,
    _PM_IP6_INDELIVERS,
    _PM_IP6_OUTFORWDATAGRAMS,
    _PM_IP6_OUTREQUESTS,
    _PM_IP6_OUTDISCARDS,
    _PM_IP6_OUTNOROUTES,
    _PM_IP6_REASMTIMEOUT,
    _PM_IP6_REASMREQDS,
    _PM_IP6_REASMOKS,
    _PM_IP6_REASMFAILS,
    _PM_IP6_FRAGOKS,
    _PM_IP6_FRAGFAILS,
    _PM_IP6_FRAGCREATES,
    _PM_IP6_INMCASTPKTS,
    _PM_IP6_OUTMCASTPKTS,
    _PM_IP6_INOCTETS,
    _PM_IP6_OUTOCTETS,
    _PM_IP6_INMCASTOCTETS,
    _PM_IP6_OUTMCASTOCTETS,
    _PM_IP6_INBCASTOCTETS,
    _PM_IP6_OUTBCASTOCTETS,
    _PM_IP6_INNOECTPKTS,
    _PM_IP6_INECT1PKTS,
    _PM_IP6_INECT0PKTS,
    _PM_IP6_INCEPKTS,
    _PM_ICMP6_INMSGS,
    _PM_ICMP6_INERRORS,
    _PM_ICMP6_OUTMSGS,
    _PM_ICMP6_OUTERRORS,
    _PM_ICMP6_INCSUMERRORS,
    _PM_ICMP6_INDESTUNREACHS,
    _PM_ICMP6_INPKTTOOBIGS,
    _PM_ICMP6_INTIMEEXCDS,
    _PM_ICMP6_INPARMPROBLEMS,
    _PM_ICMP6_INECHOS,
    _PM_ICMP6_INECHOREPLIES,
    _PM_ICMP6_INGROUPMEMBQUERIES,
    _PM_ICMP6_INGROUPMEMBRESPONSES,
    _PM_ICMP6_INGROUPMEMBREDUCTIONS,
    _PM_ICMP6_INROUTERSOLICITS,
    _PM_ICMP6_INROUTERADVERTISEMENTS,
    _PM_ICMP6_INNEIGHBORSOLICITS,
    _PM_ICMP6_INNEIGHBORADVERTISEMENTS,
    _PM_ICMP6_INREDIRECTS,
    _PM_ICMP6_INMLDV2REPORTS,
    _PM_ICMP6_OUTDESTUNREACHS,
    _PM_ICMP6_OUTPKTTOOBIGS,
    _PM_ICMP6_OUTTIMEEXCDS,
    _PM_ICMP6_OUTPARMPROBLEMS,
    _PM_ICMP6_OUTECHOS,
    _PM_ICMP6_OUTECHOREPLIES,
    _PM_ICMP6_OUTGROUPMEMBQUERIES,
    _PM_ICMP6_OUTGROUPMEMBRESPONSES,
    _PM_ICMP6_OUTGROUPMEMBREDUCTIONS,
    _PM_ICMP6_OUTROUTERSOLICITS,
    _PM_ICMP6_OUTROUTERADVERTISEMENTS,
    _PM_ICMP6_OUTNEIGHBORSOLICITS,
    _PM_ICMP6_OUTNEIGHBORADVERTISEMENTS,
    _PM_ICMP6_OUTREDIRECTS,
    _PM_ICMP6_OUTMLDV2REPORTS,
    _PM_UDP6_INDATAGRAMS,
    _PM_UDP6_NOPORTS,
    _PM_UDP6_INERRORS,
    _PM_UDP6_OUTDATAGRAMS,
    _PM_UDP6_RCVBUFERRORS,
    _PM_UDP6_SNDBUFERRORS,
    _PM_UDP6_INCSUMERRORS,
    _PM_UDP6_IGNOREDMULTI,
    _PM_UDPLITE6_INDATAGRAMS,
    _PM_UDPLITE6_NOPORTS,
    _PM_UDPLITE6_INERRORS,
    _PM_UDPLITE6_OUTDATAGRAMS,
    _PM_UDPLITE6_RCVBUFERRORS,
    _PM_UDPLITE6_SNDBUFERRORS,
    _PM_UDPLITE6_INCSUMERRORS,

    _PM_SNMP6_METRIC_COUNT
};

typedef struct linux_table proc_net_snmp6_t;
extern int refresh_proc_net_snmp6(proc_net_snmp6_t *);
extern proc_net_snmp6_t _pm_proc_net_snmp6[];
