from typing import Any, Callable, Collection, List, Optional, Set, Type
from .config import FAIL_REASON, SyncObjConf
from .node import Node
from .transport import Transport
__all__ = ['FAIL_REASON', 'SyncObj', 'SyncObjConf', 'replicated']
class SyncObj:
    def __init__(self, selfNode: Optional[str], otherNodes: Collection[str], conf: SyncObjConf=..., consumers=..., nodeClass=..., transport=..., transportClass: Type[Transport]=...) -> None: ...
    def destroy(self) -> None: ...
    def doTick(self, timeToWait: float = 0.0) -> None: ...
    def isNodeConnected(self, node: Node) -> bool: ...
    @property
    def selfNode(self) -> Node: ...
    @property
    def otherNodes(self) -> Set[Node]: ...
    @property
    def raftLastApplied(self) -> int: ...
    @property
    def raftCommitIndex(self) -> int: ...
    @property
    def conf(self) -> SyncObjConf: ...
    def _getLeader(self) -> Optional[Node]: ...
    def _isLeader(self) -> bool: ...
    def _onTick(self, timeToWait: float = 0.0) -> None: ...
def replicated(*decArgs: Any, **decKwargs: Any) -> Callable[..., Any]: ...
