if(NOT CUDAToolkit_ROOT)
  if(NOT CUDA_ROOT)
    set(CUDA_ROOT $ENV{CUDA_ROOT})
  endif()
  if(CUDA_ROOT)
    set(CUDAToolkit_ROOT ${CUDA_ROOT})
  endif()
endif()

set(TPL_CUDA_LIBRARIES "")
if(KOKKOS_ENABLE_COMPILE_AS_CMAKE_LANGUAGE)
  set(TPL_CUDA_LIBRARIES CUDA::cuda_driver)
else()
  set(TPL_CUDA_LIBRARIES CUDA::cuda_driver CUDA::cudart)
endif()

find_package(CUDAToolkit REQUIRED)
kokkos_create_imported_tpl(CUDA INTERFACE LINK_LIBRARIES ${TPL_CUDA_LIBRARIES})
kokkos_export_cmake_tpl(CUDAToolkit REQUIRED)
