/* Duplicate a wide string.
   Copyright (C) 1999, 2011-2025 Free Software Foundation, Inc.
   Written by Bruno Haible <bruno@clisp.org>, 1999.

   This file is free software: you can redistribute it and/or modify
   it under the terms of the GNU Lesser General Public License as
   published by the Free Software Foundation, either version 3 of the
   License, or (at your option) any later version.

   This file is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public License
   along with this program.  If not, see <https://www.gnu.org/licenses/>.  */

wchar_t *
wcsdup (const wchar_t *s)
{
  size_t n = wcslen (s) + 1;
  wchar_t *copy = (wchar_t *) malloc (n * sizeof (wchar_t));
  if (copy != NULL)
    return wmemcpy (copy, s, n);
  else
    /* The glibc documentation does not say that errno should be set to ENOMEM
       here.  */
    return NULL;
}
