# Distributed under the OSI-approved BSD 3-Clause License.  See accompanying
# file LICENSE.rst or https://cmake.org/licensing for details.

function(cmake_parse_compiler_architecture_id triple arch_id_var)
  # Sync with:
  #   Help/variable/CMAKE_LANG_COMPILER_ARCHITECTURE_ID.rst
  #   Modules/CMakeCompilerABI.h
  #   Modules/CMakeFortranCompilerABI.F
  #   Modules/CMakeFortranCompilerABI.F90
  if(_dumpmachine_triple MATCHES "^(aarch64|arm64)-apple-")
    set(ARCHITECTURE_ID "arm64")
  elseif(_dumpmachine_triple MATCHES "^(aarch64|arm64)_32-apple-")
    set(ARCHITECTURE_ID "arm64_32")
  elseif(_dumpmachine_triple MATCHES "^(aarch64|arm64)e-apple-")
    set(ARCHITECTURE_ID "arm64e")
  elseif(_dumpmachine_triple MATCHES "^(armv7k|armv7s)-apple-")
    set(ARCHITECTURE_ID "${CMAKE_MATCH_1}")
  elseif(_dumpmachine_triple MATCHES "^(aarch64|arm64)-")
    set(ARCHITECTURE_ID "aarch64")
  elseif(_dumpmachine_triple MATCHES "^(armv[5-7])[^-]*-")
    set(ARCHITECTURE_ID "${CMAKE_MATCH_1}")
  elseif(_dumpmachine_triple MATCHES "^alpha[^-]*-")
    set(ARCHITECTURE_ID "alpha")
  elseif(_dumpmachine_triple MATCHES "^(x86_64|amd64)-")
    set(ARCHITECTURE_ID "x86_64")
  elseif(_dumpmachine_triple MATCHES "^(i[3-6]86)-")
    set(ARCHITECTURE_ID "${CMAKE_MATCH_1}")
  elseif(_dumpmachine_triple MATCHES "^ia64-")
    set(ARCHITECTURE_ID "ia64")
  elseif(_dumpmachine_triple MATCHES "^loongarch64-")
    set(ARCHITECTURE_ID "loongarch64")
  elseif(_dumpmachine_triple MATCHES "^loongarch(32)?-")
    set(ARCHITECTURE_ID "loongarch32")
  elseif(_dumpmachine_triple MATCHES "^m68k-")
    set(ARCHITECTURE_ID "m68k")
  elseif(_dumpmachine_triple MATCHES "^mingw32$") # MinGW/MSYS 1.0: http://mingw.osdn.io/
    set(ARCHITECTURE_ID "i386")
  elseif(_dumpmachine_triple MATCHES "^mips[^-]*64[^-]*el-")
    set(ARCHITECTURE_ID "mips64el")
  elseif(_dumpmachine_triple MATCHES "^mips[^-]*64[^-]*-")
    set(ARCHITECTURE_ID "mips64")
  elseif(_dumpmachine_triple MATCHES "^mips[^-]*el[^-]*-")
    set(ARCHITECTURE_ID "mipsel")
  elseif(_dumpmachine_triple MATCHES "^mips[^-]*-")
    set(ARCHITECTURE_ID "mips")
  elseif(_dumpmachine_triple MATCHES "^riscv64-")
    set(ARCHITECTURE_ID "riscv64")
  elseif(_dumpmachine_triple MATCHES "^riscv32-")
    set(ARCHITECTURE_ID "riscv32")
  elseif(_dumpmachine_triple MATCHES "^sunway-")
    set(ARCHITECTURE_ID "sw_64")
  elseif(_dumpmachine_triple MATCHES "^s390x-")
    set(ARCHITECTURE_ID "s390x")
  elseif(_dumpmachine_triple MATCHES "^s390-")
    set(ARCHITECTURE_ID "s390")
  elseif(_dumpmachine_triple MATCHES "^(sparcv9|sparc64)-")
    set(ARCHITECTURE_ID "sparcv9")
  elseif(_dumpmachine_triple MATCHES "^sparc-")
    set(ARCHITECTURE_ID "sparc")
  elseif(_dumpmachine_triple MATCHES "^(hppa64|parisc64)-")
    set(ARCHITECTURE_ID "parisc64")
  elseif(_dumpmachine_triple MATCHES "^(hppa[0-9.]*|parisc)-")
    set(ARCHITECTURE_ID "parisc")
  elseif(_dumpmachine_triple MATCHES "^(powerpc64le|ppc64le)-")
    set(ARCHITECTURE_ID "ppc64le")
  elseif(_dumpmachine_triple MATCHES "^(powerpc64|ppc64)-")
    set(ARCHITECTURE_ID "ppc64")
  elseif(_dumpmachine_triple MATCHES "^(powerpcle|ppcle)-")
    set(ARCHITECTURE_ID "ppcle")
  elseif(_dumpmachine_triple MATCHES "^(powerpc|ppc)-")
    set(ARCHITECTURE_ID "ppc")
  else()
    set(ARCHITECTURE_ID "")
  endif()
  set("${arch_id_var}" "${ARCHITECTURE_ID}" PARENT_SCOPE)
endfunction()
