; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs -mtriple=powerpc64le-unknown-linux-gnu \
; RUN:   -mcpu=pwr10 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr \
; RUN:   < %s | FileCheck %s --check-prefixes=CHECK,CHECK-P10
; RUN: llc -verify-machineinstrs -mtriple=powerpc64-unknown-linux-gnu \
; RUN:   -mcpu=pwr10 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr \
; RUN:   < %s | FileCheck %s --check-prefixes=CHECK,CHECK-P10
; RUN: llc -verify-machineinstrs -mtriple=powerpc64le-unknown-linux-gnu \
; RUN:   -mcpu=pwr9 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr \
; RUN:   < %s | FileCheck %s --check-prefixes=CHECK,CHECK-PREP10
; RUN: llc -verify-machineinstrs -mtriple=powerpc64-unknown-linux-gnu \
; RUN:   -mcpu=pwr9 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr \
; RUN:   < %s | FileCheck %s --check-prefixes=CHECK,CHECK-PREP10
; RUN: llc -verify-machineinstrs -mtriple=powerpc64le-unknown-linux-gnu \
; RUN:   -mcpu=pwr8 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr \
; RUN:   < %s | FileCheck %s --check-prefixes=CHECK,CHECK-PREP10
; RUN: llc -verify-machineinstrs -mtriple=powerpc64-unknown-linux-gnu \
; RUN:   -mcpu=pwr8 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr \
; RUN:   < %s | FileCheck %s --check-prefixes=CHECK,CHECK-PREP10

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local signext i32 @ld_0_int32_t_uint8_t(i64 %ptr) {
; CHECK-LABEL: ld_0_int32_t_uint8_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lbz r3, 0(r3)
; CHECK-NEXT:    blr
entry:
  %0 = inttoptr i64 %ptr to ptr
  %1 = load atomic i8, ptr %0 monotonic, align 1
  %conv = zext i8 %1 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local signext i32 @ld_align16_int32_t_uint8_t(ptr nocapture readonly %ptr) {
; CHECK-LABEL: ld_align16_int32_t_uint8_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lbz r3, 8(r3)
; CHECK-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 8
  %0 = load atomic i8, ptr %add.ptr monotonic, align 1
  %conv = zext i8 %0 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local signext i32 @ld_align32_int32_t_uint8_t(ptr nocapture readonly %ptr) {
; CHECK-P10-LABEL: ld_align32_int32_t_uint8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    plbz r3, 99999000(r3), 0
; CHECK-P10-NEXT:    clrldi r3, r3, 32
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_align32_int32_t_uint8_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 1525
; CHECK-PREP10-NEXT:    ori r4, r4, 56600
; CHECK-PREP10-NEXT:    lbzx r3, r3, r4
; CHECK-PREP10-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 99999000
  %0 = load atomic i8, ptr %add.ptr monotonic, align 1
  %conv = zext i8 %0 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local signext i32 @ld_align64_int32_t_uint8_t(ptr nocapture readonly %ptr) {
; CHECK-P10-LABEL: ld_align64_int32_t_uint8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    lbzx r3, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_align64_int32_t_uint8_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    lbzx r3, r3, r4
; CHECK-PREP10-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 1000000000000
  %0 = load atomic i8, ptr %add.ptr monotonic, align 1
  %conv = zext i8 %0 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local signext i32 @ld_reg_int32_t_uint8_t(ptr nocapture readonly %ptr, i64 %off) {
; CHECK-LABEL: ld_reg_int32_t_uint8_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lbzx r3, r3, r4
; CHECK-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 %off
  %0 = load atomic i8, ptr %add.ptr monotonic, align 1
  %conv = zext i8 %0 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local signext i32 @ld_or_int32_t_uint8_t(i64 %ptr, i8 zeroext %off) {
; CHECK-LABEL: ld_or_int32_t_uint8_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    or r3, r4, r3
; CHECK-NEXT:    lbz r3, 0(r3)
; CHECK-NEXT:    blr
entry:
  %conv = zext i8 %off to i64
  %or = or i64 %conv, %ptr
  %0 = inttoptr i64 %or to ptr
  %1 = load atomic i8, ptr %0 monotonic, align 1
  %conv1 = zext i8 %1 to i32
  ret i32 %conv1
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local signext i32 @ld_not_disjoint16_int32_t_uint8_t(i64 %ptr) {
; CHECK-LABEL: ld_not_disjoint16_int32_t_uint8_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 6
; CHECK-NEXT:    lbz r3, 0(r3)
; CHECK-NEXT:    blr
entry:
  %or = or i64 %ptr, 6
  %0 = inttoptr i64 %or to ptr
  %1 = load atomic i8, ptr %0 monotonic, align 1
  %conv = zext i8 %1 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local signext i32 @ld_disjoint_align16_int32_t_uint8_t(i64 %ptr) {
; CHECK-LABEL: ld_disjoint_align16_int32_t_uint8_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rldicr r3, r3, 0, 51
; CHECK-NEXT:    lbz r3, 24(r3)
; CHECK-NEXT:    blr
entry:
  %and = and i64 %ptr, -4096
  %or = or i64 %and, 24
  %0 = inttoptr i64 %or to ptr
  %1 = load atomic i8, ptr %0 monotonic, align 8
  %conv = zext i8 %1 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local signext i32 @ld_not_disjoint32_int32_t_uint8_t(i64 %ptr) {
; CHECK-LABEL: ld_not_disjoint32_int32_t_uint8_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 34463
; CHECK-NEXT:    oris r3, r3, 1
; CHECK-NEXT:    lbz r3, 0(r3)
; CHECK-NEXT:    blr
entry:
  %or = or i64 %ptr, 99999
  %0 = inttoptr i64 %or to ptr
  %1 = load atomic i8, ptr %0 monotonic, align 1
  %conv = zext i8 %1 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local signext i32 @ld_disjoint_align32_int32_t_uint8_t(i64 %ptr) {
; CHECK-P10-LABEL: ld_disjoint_align32_int32_t_uint8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    lis r4, -15264
; CHECK-P10-NEXT:    and r3, r3, r4
; CHECK-P10-NEXT:    plbz r3, 999990000(r3), 0
; CHECK-P10-NEXT:    clrldi r3, r3, 32
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_disjoint_align32_int32_t_uint8_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, -15264
; CHECK-PREP10-NEXT:    and r3, r3, r4
; CHECK-PREP10-NEXT:    lis r4, 15258
; CHECK-PREP10-NEXT:    ori r4, r4, 41712
; CHECK-PREP10-NEXT:    lbzx r3, r3, r4
; CHECK-PREP10-NEXT:    blr
entry:
  %and = and i64 %ptr, -1000341504
  %or = or i64 %and, 999990000
  %0 = inttoptr i64 %or to ptr
  %1 = load atomic i8, ptr %0 monotonic, align 16
  %conv = zext i8 %1 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local signext i32 @ld_not_disjoint64_int32_t_uint8_t(i64 %ptr) {
; CHECK-P10-LABEL: ld_not_disjoint64_int32_t_uint8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 232
; CHECK-P10-NEXT:    pli r5, 3567587329
; CHECK-P10-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-NEXT:    or r3, r3, r5
; CHECK-P10-NEXT:    lbz r3, 0(r3)
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_not_disjoint64_int32_t_uint8_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    li r4, 29
; CHECK-PREP10-NEXT:    rldic r4, r4, 35, 24
; CHECK-PREP10-NEXT:    oris r4, r4, 54437
; CHECK-PREP10-NEXT:    ori r4, r4, 4097
; CHECK-PREP10-NEXT:    or r3, r3, r4
; CHECK-PREP10-NEXT:    lbz r3, 0(r3)
; CHECK-PREP10-NEXT:    blr
entry:
  %or = or i64 %ptr, 1000000000001
  %0 = inttoptr i64 %or to ptr
  %1 = load atomic i8, ptr %0 monotonic, align 1
  %conv = zext i8 %1 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local signext i32 @ld_disjoint_align64_int32_t_uint8_t(i64 %ptr) {
; CHECK-P10-LABEL: ld_disjoint_align64_int32_t_uint8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    lbzx r3, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_disjoint_align64_int32_t_uint8_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    lbzx r3, r3, r4
; CHECK-PREP10-NEXT:    blr
entry:
  %and = and i64 %ptr, -1099511627776
  %or = or i64 %and, 1000000000000
  %0 = inttoptr i64 %or to ptr
  %1 = load atomic i8, ptr %0 monotonic, align 4096
  %conv = zext i8 %1 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local signext i32 @ld_cst_align16_int32_t_uint8_t() {
; CHECK-LABEL: ld_cst_align16_int32_t_uint8_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lbz r3, 4080(0)
; CHECK-NEXT:    blr
entry:
  %0 = load atomic i8, ptr inttoptr (i64 4080 to ptr) monotonic, align 16
  %conv = zext i8 %0 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local signext i32 @ld_cst_align32_int32_t_uint8_t() {
; CHECK-LABEL: ld_cst_align32_int32_t_uint8_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lis r3, 153
; CHECK-NEXT:    lbz r3, -27108(r3)
; CHECK-NEXT:    blr
entry:
  %0 = load atomic i8, ptr inttoptr (i64 9999900 to ptr) monotonic, align 4
  %conv = zext i8 %0 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local signext i32 @ld_cst_align64_int32_t_uint8_t() {
; CHECK-P10-LABEL: ld_cst_align64_int32_t_uint8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r3, 244140625
; CHECK-P10-NEXT:    rldic r3, r3, 12, 24
; CHECK-P10-NEXT:    lbz r3, 0(r3)
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_cst_align64_int32_t_uint8_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r3, 3725
; CHECK-PREP10-NEXT:    ori r3, r3, 19025
; CHECK-PREP10-NEXT:    rldic r3, r3, 12, 24
; CHECK-PREP10-NEXT:    lbz r3, 0(r3)
; CHECK-PREP10-NEXT:    blr
entry:
  %0 = load atomic i8, ptr inttoptr (i64 1000000000000 to ptr) monotonic, align 4096
  %conv = zext i8 %0 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local signext i32 @ld_0_int32_t_int8_t(i64 %ptr) {
; CHECK-LABEL: ld_0_int32_t_int8_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lbz r3, 0(r3)
; CHECK-NEXT:    extsb r3, r3
; CHECK-NEXT:    blr
entry:
  %0 = inttoptr i64 %ptr to ptr
  %1 = load atomic i8, ptr %0 monotonic, align 1
  %conv = sext i8 %1 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local signext i32 @ld_align16_int32_t_int8_t(ptr nocapture readonly %ptr) {
; CHECK-LABEL: ld_align16_int32_t_int8_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lbz r3, 8(r3)
; CHECK-NEXT:    extsb r3, r3
; CHECK-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 8
  %0 = load atomic i8, ptr %add.ptr monotonic, align 1
  %conv = sext i8 %0 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local signext i32 @ld_align32_int32_t_int8_t(ptr nocapture readonly %ptr) {
; CHECK-P10-LABEL: ld_align32_int32_t_int8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    plbz r3, 99999000(r3), 0
; CHECK-P10-NEXT:    extsb r3, r3
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_align32_int32_t_int8_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 1525
; CHECK-PREP10-NEXT:    ori r4, r4, 56600
; CHECK-PREP10-NEXT:    lbzx r3, r3, r4
; CHECK-PREP10-NEXT:    extsb r3, r3
; CHECK-PREP10-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 99999000
  %0 = load atomic i8, ptr %add.ptr monotonic, align 1
  %conv = sext i8 %0 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local signext i32 @ld_align64_int32_t_int8_t(ptr nocapture readonly %ptr) {
; CHECK-P10-LABEL: ld_align64_int32_t_int8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    lbzx r3, r3, r4
; CHECK-P10-NEXT:    extsb r3, r3
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_align64_int32_t_int8_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    lbzx r3, r3, r4
; CHECK-PREP10-NEXT:    extsb r3, r3
; CHECK-PREP10-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 1000000000000
  %0 = load atomic i8, ptr %add.ptr monotonic, align 1
  %conv = sext i8 %0 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local signext i32 @ld_reg_int32_t_int8_t(ptr nocapture readonly %ptr, i64 %off) {
; CHECK-LABEL: ld_reg_int32_t_int8_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lbzx r3, r3, r4
; CHECK-NEXT:    extsb r3, r3
; CHECK-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 %off
  %0 = load atomic i8, ptr %add.ptr monotonic, align 1
  %conv = sext i8 %0 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local signext i32 @ld_or_int32_t_int8_t(i64 %ptr, i8 zeroext %off) {
; CHECK-LABEL: ld_or_int32_t_int8_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    or r3, r4, r3
; CHECK-NEXT:    lbz r3, 0(r3)
; CHECK-NEXT:    extsb r3, r3
; CHECK-NEXT:    blr
entry:
  %conv = zext i8 %off to i64
  %or = or i64 %conv, %ptr
  %0 = inttoptr i64 %or to ptr
  %1 = load atomic i8, ptr %0 monotonic, align 1
  %conv1 = sext i8 %1 to i32
  ret i32 %conv1
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local signext i32 @ld_not_disjoint16_int32_t_int8_t(i64 %ptr) {
; CHECK-LABEL: ld_not_disjoint16_int32_t_int8_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 6
; CHECK-NEXT:    lbz r3, 0(r3)
; CHECK-NEXT:    extsb r3, r3
; CHECK-NEXT:    blr
entry:
  %or = or i64 %ptr, 6
  %0 = inttoptr i64 %or to ptr
  %1 = load atomic i8, ptr %0 monotonic, align 1
  %conv = sext i8 %1 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local signext i32 @ld_disjoint_align16_int32_t_int8_t(i64 %ptr) {
; CHECK-LABEL: ld_disjoint_align16_int32_t_int8_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rldicr r3, r3, 0, 51
; CHECK-NEXT:    lbz r3, 24(r3)
; CHECK-NEXT:    extsb r3, r3
; CHECK-NEXT:    blr
entry:
  %and = and i64 %ptr, -4096
  %or = or i64 %and, 24
  %0 = inttoptr i64 %or to ptr
  %1 = load atomic i8, ptr %0 monotonic, align 8
  %conv = sext i8 %1 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local signext i32 @ld_not_disjoint32_int32_t_int8_t(i64 %ptr) {
; CHECK-LABEL: ld_not_disjoint32_int32_t_int8_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 34463
; CHECK-NEXT:    oris r3, r3, 1
; CHECK-NEXT:    lbz r3, 0(r3)
; CHECK-NEXT:    extsb r3, r3
; CHECK-NEXT:    blr
entry:
  %or = or i64 %ptr, 99999
  %0 = inttoptr i64 %or to ptr
  %1 = load atomic i8, ptr %0 monotonic, align 1
  %conv = sext i8 %1 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local signext i32 @ld_disjoint_align32_int32_t_int8_t(i64 %ptr) {
; CHECK-P10-LABEL: ld_disjoint_align32_int32_t_int8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    lis r4, -15264
; CHECK-P10-NEXT:    and r3, r3, r4
; CHECK-P10-NEXT:    plbz r3, 999990000(r3), 0
; CHECK-P10-NEXT:    extsb r3, r3
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_disjoint_align32_int32_t_int8_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, -15264
; CHECK-PREP10-NEXT:    and r3, r3, r4
; CHECK-PREP10-NEXT:    lis r4, 15258
; CHECK-PREP10-NEXT:    ori r4, r4, 41712
; CHECK-PREP10-NEXT:    lbzx r3, r3, r4
; CHECK-PREP10-NEXT:    extsb r3, r3
; CHECK-PREP10-NEXT:    blr
entry:
  %and = and i64 %ptr, -1000341504
  %or = or i64 %and, 999990000
  %0 = inttoptr i64 %or to ptr
  %1 = load atomic i8, ptr %0 monotonic, align 16
  %conv = sext i8 %1 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local signext i32 @ld_not_disjoint64_int32_t_int8_t(i64 %ptr) {
; CHECK-P10-LABEL: ld_not_disjoint64_int32_t_int8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 232
; CHECK-P10-NEXT:    pli r5, 3567587329
; CHECK-P10-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-NEXT:    or r3, r3, r5
; CHECK-P10-NEXT:    lbz r3, 0(r3)
; CHECK-P10-NEXT:    extsb r3, r3
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_not_disjoint64_int32_t_int8_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    li r4, 29
; CHECK-PREP10-NEXT:    rldic r4, r4, 35, 24
; CHECK-PREP10-NEXT:    oris r4, r4, 54437
; CHECK-PREP10-NEXT:    ori r4, r4, 4097
; CHECK-PREP10-NEXT:    or r3, r3, r4
; CHECK-PREP10-NEXT:    lbz r3, 0(r3)
; CHECK-PREP10-NEXT:    extsb r3, r3
; CHECK-PREP10-NEXT:    blr
entry:
  %or = or i64 %ptr, 1000000000001
  %0 = inttoptr i64 %or to ptr
  %1 = load atomic i8, ptr %0 monotonic, align 1
  %conv = sext i8 %1 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local signext i32 @ld_disjoint_align64_int32_t_int8_t(i64 %ptr) {
; CHECK-P10-LABEL: ld_disjoint_align64_int32_t_int8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    lbzx r3, r3, r4
; CHECK-P10-NEXT:    extsb r3, r3
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_disjoint_align64_int32_t_int8_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    lbzx r3, r3, r4
; CHECK-PREP10-NEXT:    extsb r3, r3
; CHECK-PREP10-NEXT:    blr
entry:
  %and = and i64 %ptr, -1099511627776
  %or = or i64 %and, 1000000000000
  %0 = inttoptr i64 %or to ptr
  %1 = load atomic i8, ptr %0 monotonic, align 4096
  %conv = sext i8 %1 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local signext i32 @ld_cst_align16_int32_t_int8_t() {
; CHECK-LABEL: ld_cst_align16_int32_t_int8_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lbz r3, 4080(0)
; CHECK-NEXT:    extsb r3, r3
; CHECK-NEXT:    blr
entry:
  %0 = load atomic i8, ptr inttoptr (i64 4080 to ptr) monotonic, align 16
  %conv = sext i8 %0 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local signext i32 @ld_cst_align32_int32_t_int8_t() {
; CHECK-LABEL: ld_cst_align32_int32_t_int8_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lis r3, 153
; CHECK-NEXT:    lbz r3, -27108(r3)
; CHECK-NEXT:    extsb r3, r3
; CHECK-NEXT:    blr
entry:
  %0 = load atomic i8, ptr inttoptr (i64 9999900 to ptr) monotonic, align 4
  %conv = sext i8 %0 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local signext i32 @ld_cst_align64_int32_t_int8_t() {
; CHECK-P10-LABEL: ld_cst_align64_int32_t_int8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r3, 244140625
; CHECK-P10-NEXT:    rldic r3, r3, 12, 24
; CHECK-P10-NEXT:    lbz r3, 0(r3)
; CHECK-P10-NEXT:    extsb r3, r3
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_cst_align64_int32_t_int8_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r3, 3725
; CHECK-PREP10-NEXT:    ori r3, r3, 19025
; CHECK-PREP10-NEXT:    rldic r3, r3, 12, 24
; CHECK-PREP10-NEXT:    lbz r3, 0(r3)
; CHECK-PREP10-NEXT:    extsb r3, r3
; CHECK-PREP10-NEXT:    blr
entry:
  %0 = load atomic i8, ptr inttoptr (i64 1000000000000 to ptr) monotonic, align 4096
  %conv = sext i8 %0 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local signext i32 @ld_0_int32_t_uint16_t(i64 %ptr) {
; CHECK-LABEL: ld_0_int32_t_uint16_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lhz r3, 0(r3)
; CHECK-NEXT:    blr
entry:
  %0 = inttoptr i64 %ptr to ptr
  %1 = load atomic i16, ptr %0 monotonic, align 2
  %conv = zext i16 %1 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local signext i32 @ld_align16_int32_t_uint16_t(ptr nocapture readonly %ptr) {
; CHECK-LABEL: ld_align16_int32_t_uint16_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lhz r3, 8(r3)
; CHECK-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 8
  %0 = load atomic i16, ptr %add.ptr monotonic, align 2
  %conv = zext i16 %0 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local signext i32 @ld_align32_int32_t_uint16_t(ptr nocapture readonly %ptr) {
; CHECK-P10-LABEL: ld_align32_int32_t_uint16_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    plhz r3, 99999000(r3), 0
; CHECK-P10-NEXT:    clrldi r3, r3, 32
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_align32_int32_t_uint16_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 1525
; CHECK-PREP10-NEXT:    ori r4, r4, 56600
; CHECK-PREP10-NEXT:    lhzx r3, r3, r4
; CHECK-PREP10-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 99999000
  %0 = load atomic i16, ptr %add.ptr monotonic, align 2
  %conv = zext i16 %0 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local signext i32 @ld_align64_int32_t_uint16_t(ptr nocapture readonly %ptr) {
; CHECK-P10-LABEL: ld_align64_int32_t_uint16_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    lhzx r3, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_align64_int32_t_uint16_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    lhzx r3, r3, r4
; CHECK-PREP10-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 1000000000000
  %0 = load atomic i16, ptr %add.ptr monotonic, align 2
  %conv = zext i16 %0 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local signext i32 @ld_reg_int32_t_uint16_t(ptr nocapture readonly %ptr, i64 %off) {
; CHECK-LABEL: ld_reg_int32_t_uint16_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lhzx r3, r3, r4
; CHECK-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 %off
  %0 = load atomic i16, ptr %add.ptr monotonic, align 2
  %conv = zext i16 %0 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local signext i32 @ld_or_int32_t_uint16_t(i64 %ptr, i8 zeroext %off) {
; CHECK-LABEL: ld_or_int32_t_uint16_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    or r3, r4, r3
; CHECK-NEXT:    lhz r3, 0(r3)
; CHECK-NEXT:    blr
entry:
  %conv = zext i8 %off to i64
  %or = or i64 %conv, %ptr
  %0 = inttoptr i64 %or to ptr
  %1 = load atomic i16, ptr %0 monotonic, align 2
  %conv1 = zext i16 %1 to i32
  ret i32 %conv1
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local signext i32 @ld_not_disjoint16_int32_t_uint16_t(i64 %ptr) {
; CHECK-LABEL: ld_not_disjoint16_int32_t_uint16_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 6
; CHECK-NEXT:    lhz r3, 0(r3)
; CHECK-NEXT:    blr
entry:
  %or = or i64 %ptr, 6
  %0 = inttoptr i64 %or to ptr
  %1 = load atomic i16, ptr %0 monotonic, align 2
  %conv = zext i16 %1 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local signext i32 @ld_disjoint_align16_int32_t_uint16_t(i64 %ptr) {
; CHECK-LABEL: ld_disjoint_align16_int32_t_uint16_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rldicr r3, r3, 0, 51
; CHECK-NEXT:    lhz r3, 24(r3)
; CHECK-NEXT:    blr
entry:
  %and = and i64 %ptr, -4096
  %or = or i64 %and, 24
  %0 = inttoptr i64 %or to ptr
  %1 = load atomic i16, ptr %0 monotonic, align 8
  %conv = zext i16 %1 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local signext i32 @ld_not_disjoint32_int32_t_uint16_t(i64 %ptr) {
; CHECK-LABEL: ld_not_disjoint32_int32_t_uint16_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 34463
; CHECK-NEXT:    oris r3, r3, 1
; CHECK-NEXT:    lhz r3, 0(r3)
; CHECK-NEXT:    blr
entry:
  %or = or i64 %ptr, 99999
  %0 = inttoptr i64 %or to ptr
  %1 = load atomic i16, ptr %0 monotonic, align 2
  %conv = zext i16 %1 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local signext i32 @ld_disjoint_align32_int32_t_uint16_t(i64 %ptr) {
; CHECK-P10-LABEL: ld_disjoint_align32_int32_t_uint16_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    lis r4, -15264
; CHECK-P10-NEXT:    and r3, r3, r4
; CHECK-P10-NEXT:    plhz r3, 999990000(r3), 0
; CHECK-P10-NEXT:    clrldi r3, r3, 32
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_disjoint_align32_int32_t_uint16_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, -15264
; CHECK-PREP10-NEXT:    and r3, r3, r4
; CHECK-PREP10-NEXT:    lis r4, 15258
; CHECK-PREP10-NEXT:    ori r4, r4, 41712
; CHECK-PREP10-NEXT:    lhzx r3, r3, r4
; CHECK-PREP10-NEXT:    blr
entry:
  %and = and i64 %ptr, -1000341504
  %or = or i64 %and, 999990000
  %0 = inttoptr i64 %or to ptr
  %1 = load atomic i16, ptr %0 monotonic, align 16
  %conv = zext i16 %1 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local signext i32 @ld_not_disjoint64_int32_t_uint16_t(i64 %ptr) {
; CHECK-P10-LABEL: ld_not_disjoint64_int32_t_uint16_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 232
; CHECK-P10-NEXT:    pli r5, 3567587329
; CHECK-P10-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-NEXT:    or r3, r3, r5
; CHECK-P10-NEXT:    lhz r3, 0(r3)
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_not_disjoint64_int32_t_uint16_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    li r4, 29
; CHECK-PREP10-NEXT:    rldic r4, r4, 35, 24
; CHECK-PREP10-NEXT:    oris r4, r4, 54437
; CHECK-PREP10-NEXT:    ori r4, r4, 4097
; CHECK-PREP10-NEXT:    or r3, r3, r4
; CHECK-PREP10-NEXT:    lhz r3, 0(r3)
; CHECK-PREP10-NEXT:    blr
entry:
  %or = or i64 %ptr, 1000000000001
  %0 = inttoptr i64 %or to ptr
  %1 = load atomic i16, ptr %0 monotonic, align 2
  %conv = zext i16 %1 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local signext i32 @ld_disjoint_align64_int32_t_uint16_t(i64 %ptr) {
; CHECK-P10-LABEL: ld_disjoint_align64_int32_t_uint16_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    lhzx r3, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_disjoint_align64_int32_t_uint16_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    lhzx r3, r3, r4
; CHECK-PREP10-NEXT:    blr
entry:
  %and = and i64 %ptr, -1099511627776
  %or = or i64 %and, 1000000000000
  %0 = inttoptr i64 %or to ptr
  %1 = load atomic i16, ptr %0 monotonic, align 4096
  %conv = zext i16 %1 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local signext i32 @ld_cst_align16_int32_t_uint16_t() {
; CHECK-LABEL: ld_cst_align16_int32_t_uint16_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lhz r3, 4080(0)
; CHECK-NEXT:    blr
entry:
  %0 = load atomic i16, ptr inttoptr (i64 4080 to ptr) monotonic, align 16
  %conv = zext i16 %0 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local signext i32 @ld_cst_align32_int32_t_uint16_t() {
; CHECK-LABEL: ld_cst_align32_int32_t_uint16_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lis r3, 153
; CHECK-NEXT:    lhz r3, -27108(r3)
; CHECK-NEXT:    blr
entry:
  %0 = load atomic i16, ptr inttoptr (i64 9999900 to ptr) monotonic, align 4
  %conv = zext i16 %0 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local signext i32 @ld_cst_align64_int32_t_uint16_t() {
; CHECK-P10-LABEL: ld_cst_align64_int32_t_uint16_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r3, 244140625
; CHECK-P10-NEXT:    rldic r3, r3, 12, 24
; CHECK-P10-NEXT:    lhz r3, 0(r3)
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_cst_align64_int32_t_uint16_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r3, 3725
; CHECK-PREP10-NEXT:    ori r3, r3, 19025
; CHECK-PREP10-NEXT:    rldic r3, r3, 12, 24
; CHECK-PREP10-NEXT:    lhz r3, 0(r3)
; CHECK-PREP10-NEXT:    blr
entry:
  %0 = load atomic i16, ptr inttoptr (i64 1000000000000 to ptr) monotonic, align 4096
  %conv = zext i16 %0 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local signext i32 @ld_0_int32_t_int16_t(i64 %ptr) {
; CHECK-LABEL: ld_0_int32_t_int16_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lhz r3, 0(r3)
; CHECK-NEXT:    extsh r3, r3
; CHECK-NEXT:    blr
entry:
  %0 = inttoptr i64 %ptr to ptr
  %1 = load atomic i16, ptr %0 monotonic, align 2
  %conv = sext i16 %1 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local signext i32 @ld_align16_int32_t_int16_t(ptr nocapture readonly %ptr) {
; CHECK-LABEL: ld_align16_int32_t_int16_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lhz r3, 8(r3)
; CHECK-NEXT:    extsh r3, r3
; CHECK-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 8
  %0 = load atomic i16, ptr %add.ptr monotonic, align 2
  %conv = sext i16 %0 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local signext i32 @ld_align32_int32_t_int16_t(ptr nocapture readonly %ptr) {
; CHECK-P10-LABEL: ld_align32_int32_t_int16_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    plhz r3, 99999000(r3), 0
; CHECK-P10-NEXT:    extsh r3, r3
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_align32_int32_t_int16_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 1525
; CHECK-PREP10-NEXT:    ori r4, r4, 56600
; CHECK-PREP10-NEXT:    lhzx r3, r3, r4
; CHECK-PREP10-NEXT:    extsh r3, r3
; CHECK-PREP10-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 99999000
  %0 = load atomic i16, ptr %add.ptr monotonic, align 2
  %conv = sext i16 %0 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local signext i32 @ld_align64_int32_t_int16_t(ptr nocapture readonly %ptr) {
; CHECK-P10-LABEL: ld_align64_int32_t_int16_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    lhzx r3, r3, r4
; CHECK-P10-NEXT:    extsh r3, r3
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_align64_int32_t_int16_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    lhzx r3, r3, r4
; CHECK-PREP10-NEXT:    extsh r3, r3
; CHECK-PREP10-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 1000000000000
  %0 = load atomic i16, ptr %add.ptr monotonic, align 2
  %conv = sext i16 %0 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local signext i32 @ld_reg_int32_t_int16_t(ptr nocapture readonly %ptr, i64 %off) {
; CHECK-LABEL: ld_reg_int32_t_int16_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lhzx r3, r3, r4
; CHECK-NEXT:    extsh r3, r3
; CHECK-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 %off
  %0 = load atomic i16, ptr %add.ptr monotonic, align 2
  %conv = sext i16 %0 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local signext i32 @ld_or_int32_t_int16_t(i64 %ptr, i8 zeroext %off) {
; CHECK-LABEL: ld_or_int32_t_int16_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    or r3, r4, r3
; CHECK-NEXT:    lhz r3, 0(r3)
; CHECK-NEXT:    extsh r3, r3
; CHECK-NEXT:    blr
entry:
  %conv = zext i8 %off to i64
  %or = or i64 %conv, %ptr
  %0 = inttoptr i64 %or to ptr
  %1 = load atomic i16, ptr %0 monotonic, align 2
  %conv1 = sext i16 %1 to i32
  ret i32 %conv1
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local signext i32 @ld_not_disjoint16_int32_t_int16_t(i64 %ptr) {
; CHECK-LABEL: ld_not_disjoint16_int32_t_int16_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 6
; CHECK-NEXT:    lhz r3, 0(r3)
; CHECK-NEXT:    extsh r3, r3
; CHECK-NEXT:    blr
entry:
  %or = or i64 %ptr, 6
  %0 = inttoptr i64 %or to ptr
  %1 = load atomic i16, ptr %0 monotonic, align 2
  %conv = sext i16 %1 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local signext i32 @ld_disjoint_align16_int32_t_int16_t(i64 %ptr) {
; CHECK-LABEL: ld_disjoint_align16_int32_t_int16_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rldicr r3, r3, 0, 51
; CHECK-NEXT:    lhz r3, 24(r3)
; CHECK-NEXT:    extsh r3, r3
; CHECK-NEXT:    blr
entry:
  %and = and i64 %ptr, -4096
  %or = or i64 %and, 24
  %0 = inttoptr i64 %or to ptr
  %1 = load atomic i16, ptr %0 monotonic, align 8
  %conv = sext i16 %1 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local signext i32 @ld_not_disjoint32_int32_t_int16_t(i64 %ptr) {
; CHECK-LABEL: ld_not_disjoint32_int32_t_int16_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 34463
; CHECK-NEXT:    oris r3, r3, 1
; CHECK-NEXT:    lhz r3, 0(r3)
; CHECK-NEXT:    extsh r3, r3
; CHECK-NEXT:    blr
entry:
  %or = or i64 %ptr, 99999
  %0 = inttoptr i64 %or to ptr
  %1 = load atomic i16, ptr %0 monotonic, align 2
  %conv = sext i16 %1 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local signext i32 @ld_disjoint_align32_int32_t_int16_t(i64 %ptr) {
; CHECK-P10-LABEL: ld_disjoint_align32_int32_t_int16_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    lis r4, -15264
; CHECK-P10-NEXT:    and r3, r3, r4
; CHECK-P10-NEXT:    plhz r3, 999990000(r3), 0
; CHECK-P10-NEXT:    extsh r3, r3
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_disjoint_align32_int32_t_int16_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, -15264
; CHECK-PREP10-NEXT:    and r3, r3, r4
; CHECK-PREP10-NEXT:    lis r4, 15258
; CHECK-PREP10-NEXT:    ori r4, r4, 41712
; CHECK-PREP10-NEXT:    lhzx r3, r3, r4
; CHECK-PREP10-NEXT:    extsh r3, r3
; CHECK-PREP10-NEXT:    blr
entry:
  %and = and i64 %ptr, -1000341504
  %or = or i64 %and, 999990000
  %0 = inttoptr i64 %or to ptr
  %1 = load atomic i16, ptr %0 monotonic, align 16
  %conv = sext i16 %1 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local signext i32 @ld_not_disjoint64_int32_t_int16_t(i64 %ptr) {
; CHECK-P10-LABEL: ld_not_disjoint64_int32_t_int16_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 232
; CHECK-P10-NEXT:    pli r5, 3567587329
; CHECK-P10-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-NEXT:    or r3, r3, r5
; CHECK-P10-NEXT:    lhz r3, 0(r3)
; CHECK-P10-NEXT:    extsh r3, r3
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_not_disjoint64_int32_t_int16_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    li r4, 29
; CHECK-PREP10-NEXT:    rldic r4, r4, 35, 24
; CHECK-PREP10-NEXT:    oris r4, r4, 54437
; CHECK-PREP10-NEXT:    ori r4, r4, 4097
; CHECK-PREP10-NEXT:    or r3, r3, r4
; CHECK-PREP10-NEXT:    lhz r3, 0(r3)
; CHECK-PREP10-NEXT:    extsh r3, r3
; CHECK-PREP10-NEXT:    blr
entry:
  %or = or i64 %ptr, 1000000000001
  %0 = inttoptr i64 %or to ptr
  %1 = load atomic i16, ptr %0 monotonic, align 2
  %conv = sext i16 %1 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local signext i32 @ld_disjoint_align64_int32_t_int16_t(i64 %ptr) {
; CHECK-P10-LABEL: ld_disjoint_align64_int32_t_int16_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    lhzx r3, r3, r4
; CHECK-P10-NEXT:    extsh r3, r3
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_disjoint_align64_int32_t_int16_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    lhzx r3, r3, r4
; CHECK-PREP10-NEXT:    extsh r3, r3
; CHECK-PREP10-NEXT:    blr
entry:
  %and = and i64 %ptr, -1099511627776
  %or = or i64 %and, 1000000000000
  %0 = inttoptr i64 %or to ptr
  %1 = load atomic i16, ptr %0 monotonic, align 4096
  %conv = sext i16 %1 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local signext i32 @ld_cst_align16_int32_t_int16_t() {
; CHECK-LABEL: ld_cst_align16_int32_t_int16_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lhz r3, 4080(0)
; CHECK-NEXT:    extsh r3, r3
; CHECK-NEXT:    blr
entry:
  %0 = load atomic i16, ptr inttoptr (i64 4080 to ptr) monotonic, align 16
  %conv = sext i16 %0 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local signext i32 @ld_cst_align32_int32_t_int16_t() {
; CHECK-LABEL: ld_cst_align32_int32_t_int16_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lis r3, 153
; CHECK-NEXT:    lhz r3, -27108(r3)
; CHECK-NEXT:    extsh r3, r3
; CHECK-NEXT:    blr
entry:
  %0 = load atomic i16, ptr inttoptr (i64 9999900 to ptr) monotonic, align 4
  %conv = sext i16 %0 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local signext i32 @ld_cst_align64_int32_t_int16_t() {
; CHECK-P10-LABEL: ld_cst_align64_int32_t_int16_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r3, 244140625
; CHECK-P10-NEXT:    rldic r3, r3, 12, 24
; CHECK-P10-NEXT:    lhz r3, 0(r3)
; CHECK-P10-NEXT:    extsh r3, r3
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_cst_align64_int32_t_int16_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r3, 3725
; CHECK-PREP10-NEXT:    ori r3, r3, 19025
; CHECK-PREP10-NEXT:    rldic r3, r3, 12, 24
; CHECK-PREP10-NEXT:    lhz r3, 0(r3)
; CHECK-PREP10-NEXT:    extsh r3, r3
; CHECK-PREP10-NEXT:    blr
entry:
  %0 = load atomic i16, ptr inttoptr (i64 1000000000000 to ptr) monotonic, align 4096
  %conv = sext i16 %0 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local signext i32 @ld_0_int32_t_uint32_t(i64 %ptr) {
; CHECK-LABEL: ld_0_int32_t_uint32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lwa r3, 0(r3)
; CHECK-NEXT:    blr
entry:
  %0 = inttoptr i64 %ptr to ptr
  %1 = load atomic i32, ptr %0 monotonic, align 4
  ret i32 %1
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local signext i32 @ld_align16_int32_t_uint32_t(ptr nocapture readonly %ptr) {
; CHECK-LABEL: ld_align16_int32_t_uint32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lwa r3, 8(r3)
; CHECK-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 8
  %0 = load atomic i32, ptr %add.ptr monotonic, align 4
  ret i32 %0
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local signext i32 @ld_align32_int32_t_uint32_t(ptr nocapture readonly %ptr) {
; CHECK-P10-LABEL: ld_align32_int32_t_uint32_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    plwz r3, 99999000(r3), 0
; CHECK-P10-NEXT:    extsw r3, r3
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_align32_int32_t_uint32_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 1525
; CHECK-PREP10-NEXT:    ori r4, r4, 56600
; CHECK-PREP10-NEXT:    lwax r3, r3, r4
; CHECK-PREP10-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 99999000
  %0 = load atomic i32, ptr %add.ptr monotonic, align 4
  ret i32 %0
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local signext i32 @ld_align64_int32_t_uint32_t(ptr nocapture readonly %ptr) {
; CHECK-P10-LABEL: ld_align64_int32_t_uint32_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    lwax r3, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_align64_int32_t_uint32_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    lwax r3, r3, r4
; CHECK-PREP10-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 1000000000000
  %0 = load atomic i32, ptr %add.ptr monotonic, align 4
  ret i32 %0
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local signext i32 @ld_reg_int32_t_uint32_t(ptr nocapture readonly %ptr, i64 %off) {
; CHECK-LABEL: ld_reg_int32_t_uint32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lwax r3, r3, r4
; CHECK-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 %off
  %0 = load atomic i32, ptr %add.ptr monotonic, align 4
  ret i32 %0
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local signext i32 @ld_or_int32_t_uint32_t(i64 %ptr, i8 zeroext %off) {
; CHECK-LABEL: ld_or_int32_t_uint32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    or r3, r4, r3
; CHECK-NEXT:    lwa r3, 0(r3)
; CHECK-NEXT:    blr
entry:
  %conv = zext i8 %off to i64
  %or = or i64 %conv, %ptr
  %0 = inttoptr i64 %or to ptr
  %1 = load atomic i32, ptr %0 monotonic, align 4
  ret i32 %1
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local signext i32 @ld_not_disjoint16_int32_t_uint32_t(i64 %ptr) {
; CHECK-LABEL: ld_not_disjoint16_int32_t_uint32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 6
; CHECK-NEXT:    lwa r3, 0(r3)
; CHECK-NEXT:    blr
entry:
  %or = or i64 %ptr, 6
  %0 = inttoptr i64 %or to ptr
  %1 = load atomic i32, ptr %0 monotonic, align 4
  ret i32 %1
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local signext i32 @ld_disjoint_align16_int32_t_uint32_t(i64 %ptr) {
; CHECK-LABEL: ld_disjoint_align16_int32_t_uint32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rldicr r3, r3, 0, 51
; CHECK-NEXT:    lwa r3, 24(r3)
; CHECK-NEXT:    blr
entry:
  %and = and i64 %ptr, -4096
  %or = or i64 %and, 24
  %0 = inttoptr i64 %or to ptr
  %1 = load atomic i32, ptr %0 monotonic, align 8
  ret i32 %1
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local signext i32 @ld_not_disjoint32_int32_t_uint32_t(i64 %ptr) {
; CHECK-LABEL: ld_not_disjoint32_int32_t_uint32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 34463
; CHECK-NEXT:    oris r3, r3, 1
; CHECK-NEXT:    lwa r3, 0(r3)
; CHECK-NEXT:    blr
entry:
  %or = or i64 %ptr, 99999
  %0 = inttoptr i64 %or to ptr
  %1 = load atomic i32, ptr %0 monotonic, align 4
  ret i32 %1
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local signext i32 @ld_disjoint_align32_int32_t_uint32_t(i64 %ptr) {
; CHECK-P10-LABEL: ld_disjoint_align32_int32_t_uint32_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    lis r4, -15264
; CHECK-P10-NEXT:    and r3, r3, r4
; CHECK-P10-NEXT:    plwz r3, 999990000(r3), 0
; CHECK-P10-NEXT:    extsw r3, r3
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_disjoint_align32_int32_t_uint32_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, -15264
; CHECK-PREP10-NEXT:    and r3, r3, r4
; CHECK-PREP10-NEXT:    lis r4, 15258
; CHECK-PREP10-NEXT:    ori r4, r4, 41712
; CHECK-PREP10-NEXT:    lwax r3, r3, r4
; CHECK-PREP10-NEXT:    blr
entry:
  %and = and i64 %ptr, -1000341504
  %or = or i64 %and, 999990000
  %0 = inttoptr i64 %or to ptr
  %1 = load atomic i32, ptr %0 monotonic, align 16
  ret i32 %1
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local signext i32 @ld_not_disjoint64_int32_t_uint32_t(i64 %ptr) {
; CHECK-P10-LABEL: ld_not_disjoint64_int32_t_uint32_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 232
; CHECK-P10-NEXT:    pli r5, 3567587329
; CHECK-P10-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-NEXT:    or r3, r3, r5
; CHECK-P10-NEXT:    lwa r3, 0(r3)
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_not_disjoint64_int32_t_uint32_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    li r4, 29
; CHECK-PREP10-NEXT:    rldic r4, r4, 35, 24
; CHECK-PREP10-NEXT:    oris r4, r4, 54437
; CHECK-PREP10-NEXT:    ori r4, r4, 4097
; CHECK-PREP10-NEXT:    or r3, r3, r4
; CHECK-PREP10-NEXT:    lwa r3, 0(r3)
; CHECK-PREP10-NEXT:    blr
entry:
  %or = or i64 %ptr, 1000000000001
  %0 = inttoptr i64 %or to ptr
  %1 = load atomic i32, ptr %0 monotonic, align 4
  ret i32 %1
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local signext i32 @ld_disjoint_align64_int32_t_uint32_t(i64 %ptr) {
; CHECK-P10-LABEL: ld_disjoint_align64_int32_t_uint32_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    lwax r3, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_disjoint_align64_int32_t_uint32_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    lwax r3, r3, r4
; CHECK-PREP10-NEXT:    blr
entry:
  %and = and i64 %ptr, -1099511627776
  %or = or i64 %and, 1000000000000
  %0 = inttoptr i64 %or to ptr
  %1 = load atomic i32, ptr %0 monotonic, align 4096
  ret i32 %1
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local signext i32 @ld_cst_align16_int32_t_uint32_t() {
; CHECK-LABEL: ld_cst_align16_int32_t_uint32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lwa r3, 4080(0)
; CHECK-NEXT:    blr
entry:
  %0 = load atomic i32, ptr inttoptr (i64 4080 to ptr) monotonic, align 16
  ret i32 %0
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local signext i32 @ld_cst_align32_int32_t_uint32_t() {
; CHECK-LABEL: ld_cst_align32_int32_t_uint32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lis r3, 153
; CHECK-NEXT:    lwa r3, -27108(r3)
; CHECK-NEXT:    blr
entry:
  %0 = load atomic i32, ptr inttoptr (i64 9999900 to ptr) monotonic, align 4
  ret i32 %0
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local signext i32 @ld_cst_align64_int32_t_uint32_t() {
; CHECK-P10-LABEL: ld_cst_align64_int32_t_uint32_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r3, 244140625
; CHECK-P10-NEXT:    rldic r3, r3, 12, 24
; CHECK-P10-NEXT:    lwa r3, 0(r3)
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_cst_align64_int32_t_uint32_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r3, 3725
; CHECK-PREP10-NEXT:    ori r3, r3, 19025
; CHECK-PREP10-NEXT:    rldic r3, r3, 12, 24
; CHECK-PREP10-NEXT:    lwa r3, 0(r3)
; CHECK-PREP10-NEXT:    blr
entry:
  %0 = load atomic i32, ptr inttoptr (i64 1000000000000 to ptr) monotonic, align 4096
  ret i32 %0
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local signext i32 @ld_0_int32_t_uint64_t(i64 %ptr) {
; CHECK-LABEL: ld_0_int32_t_uint64_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ld r3, 0(r3)
; CHECK-NEXT:    extsw r3, r3
; CHECK-NEXT:    blr
entry:
  %0 = inttoptr i64 %ptr to ptr
  %1 = load atomic i64, ptr %0 monotonic, align 8
  %conv = trunc i64 %1 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local signext i32 @ld_align16_int32_t_uint64_t(ptr nocapture readonly %ptr) {
; CHECK-LABEL: ld_align16_int32_t_uint64_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ld r3, 8(r3)
; CHECK-NEXT:    extsw r3, r3
; CHECK-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 8
  %0 = load atomic i64, ptr %add.ptr monotonic, align 8
  %conv = trunc i64 %0 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local signext i32 @ld_align32_int32_t_uint64_t(ptr nocapture readonly %ptr) {
; CHECK-P10-LABEL: ld_align32_int32_t_uint64_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pld r3, 99999000(r3), 0
; CHECK-P10-NEXT:    extsw r3, r3
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_align32_int32_t_uint64_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 1525
; CHECK-PREP10-NEXT:    ori r4, r4, 56600
; CHECK-PREP10-NEXT:    ldx r3, r3, r4
; CHECK-PREP10-NEXT:    extsw r3, r3
; CHECK-PREP10-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 99999000
  %0 = load atomic i64, ptr %add.ptr monotonic, align 8
  %conv = trunc i64 %0 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local signext i32 @ld_align64_int32_t_uint64_t(ptr nocapture readonly %ptr) {
; CHECK-P10-LABEL: ld_align64_int32_t_uint64_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    ldx r3, r3, r4
; CHECK-P10-NEXT:    extsw r3, r3
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_align64_int32_t_uint64_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    ldx r3, r3, r4
; CHECK-PREP10-NEXT:    extsw r3, r3
; CHECK-PREP10-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 1000000000000
  %0 = load atomic i64, ptr %add.ptr monotonic, align 8
  %conv = trunc i64 %0 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local signext i32 @ld_reg_int32_t_uint64_t(ptr nocapture readonly %ptr, i64 %off) {
; CHECK-LABEL: ld_reg_int32_t_uint64_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ldx r3, r3, r4
; CHECK-NEXT:    extsw r3, r3
; CHECK-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 %off
  %0 = load atomic i64, ptr %add.ptr monotonic, align 8
  %conv = trunc i64 %0 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local signext i32 @ld_or_int32_t_uint64_t(i64 %ptr, i8 zeroext %off) {
; CHECK-LABEL: ld_or_int32_t_uint64_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    or r3, r4, r3
; CHECK-NEXT:    ld r3, 0(r3)
; CHECK-NEXT:    extsw r3, r3
; CHECK-NEXT:    blr
entry:
  %conv = zext i8 %off to i64
  %or = or i64 %conv, %ptr
  %0 = inttoptr i64 %or to ptr
  %1 = load atomic i64, ptr %0 monotonic, align 8
  %conv1 = trunc i64 %1 to i32
  ret i32 %conv1
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local signext i32 @ld_not_disjoint16_int32_t_uint64_t(i64 %ptr) {
; CHECK-LABEL: ld_not_disjoint16_int32_t_uint64_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 6
; CHECK-NEXT:    ld r3, 0(r3)
; CHECK-NEXT:    extsw r3, r3
; CHECK-NEXT:    blr
entry:
  %or = or i64 %ptr, 6
  %0 = inttoptr i64 %or to ptr
  %1 = load atomic i64, ptr %0 monotonic, align 8
  %conv = trunc i64 %1 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local signext i32 @ld_disjoint_align16_int32_t_uint64_t(i64 %ptr) {
; CHECK-LABEL: ld_disjoint_align16_int32_t_uint64_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rldicr r3, r3, 0, 51
; CHECK-NEXT:    ld r3, 24(r3)
; CHECK-NEXT:    extsw r3, r3
; CHECK-NEXT:    blr
entry:
  %and = and i64 %ptr, -4096
  %or = or i64 %and, 24
  %0 = inttoptr i64 %or to ptr
  %1 = load atomic i64, ptr %0 monotonic, align 8
  %conv = trunc i64 %1 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local signext i32 @ld_not_disjoint32_int32_t_uint64_t(i64 %ptr) {
; CHECK-LABEL: ld_not_disjoint32_int32_t_uint64_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 34463
; CHECK-NEXT:    oris r3, r3, 1
; CHECK-NEXT:    ld r3, 0(r3)
; CHECK-NEXT:    extsw r3, r3
; CHECK-NEXT:    blr
entry:
  %or = or i64 %ptr, 99999
  %0 = inttoptr i64 %or to ptr
  %1 = load atomic i64, ptr %0 monotonic, align 8
  %conv = trunc i64 %1 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local signext i32 @ld_disjoint_align32_int32_t_uint64_t(i64 %ptr) {
; CHECK-P10-LABEL: ld_disjoint_align32_int32_t_uint64_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    lis r4, -15264
; CHECK-P10-NEXT:    and r3, r3, r4
; CHECK-P10-NEXT:    pld r3, 999990000(r3), 0
; CHECK-P10-NEXT:    extsw r3, r3
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_disjoint_align32_int32_t_uint64_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, -15264
; CHECK-PREP10-NEXT:    and r3, r3, r4
; CHECK-PREP10-NEXT:    lis r4, 15258
; CHECK-PREP10-NEXT:    ori r4, r4, 41712
; CHECK-PREP10-NEXT:    ldx r3, r3, r4
; CHECK-PREP10-NEXT:    extsw r3, r3
; CHECK-PREP10-NEXT:    blr
entry:
  %and = and i64 %ptr, -1000341504
  %or = or i64 %and, 999990000
  %0 = inttoptr i64 %or to ptr
  %1 = load atomic i64, ptr %0 monotonic, align 16
  %conv = trunc i64 %1 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local signext i32 @ld_not_disjoint64_int32_t_uint64_t(i64 %ptr) {
; CHECK-P10-LABEL: ld_not_disjoint64_int32_t_uint64_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 232
; CHECK-P10-NEXT:    pli r5, 3567587329
; CHECK-P10-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-NEXT:    or r3, r3, r5
; CHECK-P10-NEXT:    ld r3, 0(r3)
; CHECK-P10-NEXT:    extsw r3, r3
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_not_disjoint64_int32_t_uint64_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    li r4, 29
; CHECK-PREP10-NEXT:    rldic r4, r4, 35, 24
; CHECK-PREP10-NEXT:    oris r4, r4, 54437
; CHECK-PREP10-NEXT:    ori r4, r4, 4097
; CHECK-PREP10-NEXT:    or r3, r3, r4
; CHECK-PREP10-NEXT:    ld r3, 0(r3)
; CHECK-PREP10-NEXT:    extsw r3, r3
; CHECK-PREP10-NEXT:    blr
entry:
  %or = or i64 %ptr, 1000000000001
  %0 = inttoptr i64 %or to ptr
  %1 = load atomic i64, ptr %0 monotonic, align 8
  %conv = trunc i64 %1 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local signext i32 @ld_disjoint_align64_int32_t_uint64_t(i64 %ptr) {
; CHECK-P10-LABEL: ld_disjoint_align64_int32_t_uint64_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    ldx r3, r3, r4
; CHECK-P10-NEXT:    extsw r3, r3
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_disjoint_align64_int32_t_uint64_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    ldx r3, r3, r4
; CHECK-PREP10-NEXT:    extsw r3, r3
; CHECK-PREP10-NEXT:    blr
entry:
  %and = and i64 %ptr, -1099511627776
  %or = or i64 %and, 1000000000000
  %0 = inttoptr i64 %or to ptr
  %1 = load atomic i64, ptr %0 monotonic, align 4096
  %conv = trunc i64 %1 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local signext i32 @ld_cst_align16_int32_t_uint64_t() {
; CHECK-LABEL: ld_cst_align16_int32_t_uint64_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ld r3, 4080(0)
; CHECK-NEXT:    extsw r3, r3
; CHECK-NEXT:    blr
entry:
  %0 = load atomic i64, ptr inttoptr (i64 4080 to ptr) monotonic, align 16
  %conv = trunc i64 %0 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local signext i32 @ld_cst_align32_int32_t_uint64_t() {
; CHECK-LABEL: ld_cst_align32_int32_t_uint64_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lis r3, 153
; CHECK-NEXT:    ld r3, -27108(r3)
; CHECK-NEXT:    extsw r3, r3
; CHECK-NEXT:    blr
entry:
  %0 = load atomic i64, ptr inttoptr (i64 9999900 to ptr) monotonic, align 8
  %conv = trunc i64 %0 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local signext i32 @ld_cst_align64_int32_t_uint64_t() {
; CHECK-P10-LABEL: ld_cst_align64_int32_t_uint64_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r3, 244140625
; CHECK-P10-NEXT:    rldic r3, r3, 12, 24
; CHECK-P10-NEXT:    ld r3, 0(r3)
; CHECK-P10-NEXT:    extsw r3, r3
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_cst_align64_int32_t_uint64_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r3, 3725
; CHECK-PREP10-NEXT:    ori r3, r3, 19025
; CHECK-PREP10-NEXT:    rldic r3, r3, 12, 24
; CHECK-PREP10-NEXT:    ld r3, 0(r3)
; CHECK-PREP10-NEXT:    extsw r3, r3
; CHECK-PREP10-NEXT:    blr
entry:
  %0 = load atomic i64, ptr inttoptr (i64 1000000000000 to ptr) monotonic, align 4096
  %conv = trunc i64 %0 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local zeroext i32 @ld_0_uint32_t_uint8_t(i64 %ptr) {
; CHECK-LABEL: ld_0_uint32_t_uint8_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lbz r3, 0(r3)
; CHECK-NEXT:    blr
entry:
  %0 = inttoptr i64 %ptr to ptr
  %1 = load atomic i8, ptr %0 monotonic, align 1
  %conv = zext i8 %1 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local zeroext i32 @ld_align16_uint32_t_uint8_t(ptr nocapture readonly %ptr) {
; CHECK-LABEL: ld_align16_uint32_t_uint8_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lbz r3, 8(r3)
; CHECK-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 8
  %0 = load atomic i8, ptr %add.ptr monotonic, align 1
  %conv = zext i8 %0 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local zeroext i32 @ld_align32_uint32_t_uint8_t(ptr nocapture readonly %ptr) {
; CHECK-P10-LABEL: ld_align32_uint32_t_uint8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    plbz r3, 99999000(r3), 0
; CHECK-P10-NEXT:    clrldi r3, r3, 32
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_align32_uint32_t_uint8_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 1525
; CHECK-PREP10-NEXT:    ori r4, r4, 56600
; CHECK-PREP10-NEXT:    lbzx r3, r3, r4
; CHECK-PREP10-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 99999000
  %0 = load atomic i8, ptr %add.ptr monotonic, align 1
  %conv = zext i8 %0 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local zeroext i32 @ld_align64_uint32_t_uint8_t(ptr nocapture readonly %ptr) {
; CHECK-P10-LABEL: ld_align64_uint32_t_uint8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    lbzx r3, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_align64_uint32_t_uint8_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    lbzx r3, r3, r4
; CHECK-PREP10-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 1000000000000
  %0 = load atomic i8, ptr %add.ptr monotonic, align 1
  %conv = zext i8 %0 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local zeroext i32 @ld_reg_uint32_t_uint8_t(ptr nocapture readonly %ptr, i64 %off) {
; CHECK-LABEL: ld_reg_uint32_t_uint8_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lbzx r3, r3, r4
; CHECK-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 %off
  %0 = load atomic i8, ptr %add.ptr monotonic, align 1
  %conv = zext i8 %0 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local zeroext i32 @ld_or_uint32_t_uint8_t(i64 %ptr, i8 zeroext %off) {
; CHECK-LABEL: ld_or_uint32_t_uint8_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    or r3, r4, r3
; CHECK-NEXT:    lbz r3, 0(r3)
; CHECK-NEXT:    blr
entry:
  %conv = zext i8 %off to i64
  %or = or i64 %conv, %ptr
  %0 = inttoptr i64 %or to ptr
  %1 = load atomic i8, ptr %0 monotonic, align 1
  %conv1 = zext i8 %1 to i32
  ret i32 %conv1
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local zeroext i32 @ld_not_disjoint16_uint32_t_uint8_t(i64 %ptr) {
; CHECK-LABEL: ld_not_disjoint16_uint32_t_uint8_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 6
; CHECK-NEXT:    lbz r3, 0(r3)
; CHECK-NEXT:    blr
entry:
  %or = or i64 %ptr, 6
  %0 = inttoptr i64 %or to ptr
  %1 = load atomic i8, ptr %0 monotonic, align 1
  %conv = zext i8 %1 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local zeroext i32 @ld_disjoint_align16_uint32_t_uint8_t(i64 %ptr) {
; CHECK-LABEL: ld_disjoint_align16_uint32_t_uint8_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rldicr r3, r3, 0, 51
; CHECK-NEXT:    lbz r3, 24(r3)
; CHECK-NEXT:    blr
entry:
  %and = and i64 %ptr, -4096
  %or = or i64 %and, 24
  %0 = inttoptr i64 %or to ptr
  %1 = load atomic i8, ptr %0 monotonic, align 8
  %conv = zext i8 %1 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local zeroext i32 @ld_not_disjoint32_uint32_t_uint8_t(i64 %ptr) {
; CHECK-LABEL: ld_not_disjoint32_uint32_t_uint8_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 34463
; CHECK-NEXT:    oris r3, r3, 1
; CHECK-NEXT:    lbz r3, 0(r3)
; CHECK-NEXT:    blr
entry:
  %or = or i64 %ptr, 99999
  %0 = inttoptr i64 %or to ptr
  %1 = load atomic i8, ptr %0 monotonic, align 1
  %conv = zext i8 %1 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local zeroext i32 @ld_disjoint_align32_uint32_t_uint8_t(i64 %ptr) {
; CHECK-P10-LABEL: ld_disjoint_align32_uint32_t_uint8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    lis r4, -15264
; CHECK-P10-NEXT:    and r3, r3, r4
; CHECK-P10-NEXT:    plbz r3, 999990000(r3), 0
; CHECK-P10-NEXT:    clrldi r3, r3, 32
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_disjoint_align32_uint32_t_uint8_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, -15264
; CHECK-PREP10-NEXT:    and r3, r3, r4
; CHECK-PREP10-NEXT:    lis r4, 15258
; CHECK-PREP10-NEXT:    ori r4, r4, 41712
; CHECK-PREP10-NEXT:    lbzx r3, r3, r4
; CHECK-PREP10-NEXT:    blr
entry:
  %and = and i64 %ptr, -1000341504
  %or = or i64 %and, 999990000
  %0 = inttoptr i64 %or to ptr
  %1 = load atomic i8, ptr %0 monotonic, align 16
  %conv = zext i8 %1 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local zeroext i32 @ld_not_disjoint64_uint32_t_uint8_t(i64 %ptr) {
; CHECK-P10-LABEL: ld_not_disjoint64_uint32_t_uint8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 232
; CHECK-P10-NEXT:    pli r5, 3567587329
; CHECK-P10-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-NEXT:    or r3, r3, r5
; CHECK-P10-NEXT:    lbz r3, 0(r3)
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_not_disjoint64_uint32_t_uint8_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    li r4, 29
; CHECK-PREP10-NEXT:    rldic r4, r4, 35, 24
; CHECK-PREP10-NEXT:    oris r4, r4, 54437
; CHECK-PREP10-NEXT:    ori r4, r4, 4097
; CHECK-PREP10-NEXT:    or r3, r3, r4
; CHECK-PREP10-NEXT:    lbz r3, 0(r3)
; CHECK-PREP10-NEXT:    blr
entry:
  %or = or i64 %ptr, 1000000000001
  %0 = inttoptr i64 %or to ptr
  %1 = load atomic i8, ptr %0 monotonic, align 1
  %conv = zext i8 %1 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local zeroext i32 @ld_disjoint_align64_uint32_t_uint8_t(i64 %ptr) {
; CHECK-P10-LABEL: ld_disjoint_align64_uint32_t_uint8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    lbzx r3, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_disjoint_align64_uint32_t_uint8_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    lbzx r3, r3, r4
; CHECK-PREP10-NEXT:    blr
entry:
  %and = and i64 %ptr, -1099511627776
  %or = or i64 %and, 1000000000000
  %0 = inttoptr i64 %or to ptr
  %1 = load atomic i8, ptr %0 monotonic, align 4096
  %conv = zext i8 %1 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local zeroext i32 @ld_cst_align16_uint32_t_uint8_t() {
; CHECK-LABEL: ld_cst_align16_uint32_t_uint8_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lbz r3, 4080(0)
; CHECK-NEXT:    blr
entry:
  %0 = load atomic i8, ptr inttoptr (i64 4080 to ptr) monotonic, align 16
  %conv = zext i8 %0 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local zeroext i32 @ld_cst_align32_uint32_t_uint8_t() {
; CHECK-LABEL: ld_cst_align32_uint32_t_uint8_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lis r3, 153
; CHECK-NEXT:    lbz r3, -27108(r3)
; CHECK-NEXT:    blr
entry:
  %0 = load atomic i8, ptr inttoptr (i64 9999900 to ptr) monotonic, align 4
  %conv = zext i8 %0 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local zeroext i32 @ld_cst_align64_uint32_t_uint8_t() {
; CHECK-P10-LABEL: ld_cst_align64_uint32_t_uint8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r3, 244140625
; CHECK-P10-NEXT:    rldic r3, r3, 12, 24
; CHECK-P10-NEXT:    lbz r3, 0(r3)
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_cst_align64_uint32_t_uint8_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r3, 3725
; CHECK-PREP10-NEXT:    ori r3, r3, 19025
; CHECK-PREP10-NEXT:    rldic r3, r3, 12, 24
; CHECK-PREP10-NEXT:    lbz r3, 0(r3)
; CHECK-PREP10-NEXT:    blr
entry:
  %0 = load atomic i8, ptr inttoptr (i64 1000000000000 to ptr) monotonic, align 4096
  %conv = zext i8 %0 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local zeroext i32 @ld_0_uint32_t_int8_t(i64 %ptr) {
; CHECK-LABEL: ld_0_uint32_t_int8_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lbz r3, 0(r3)
; CHECK-NEXT:    extsb r3, r3
; CHECK-NEXT:    clrldi r3, r3, 32
; CHECK-NEXT:    blr
entry:
  %0 = inttoptr i64 %ptr to ptr
  %1 = load atomic i8, ptr %0 monotonic, align 1
  %conv = sext i8 %1 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local zeroext i32 @ld_align16_uint32_t_int8_t(ptr nocapture readonly %ptr) {
; CHECK-LABEL: ld_align16_uint32_t_int8_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lbz r3, 8(r3)
; CHECK-NEXT:    extsb r3, r3
; CHECK-NEXT:    clrldi r3, r3, 32
; CHECK-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 8
  %0 = load atomic i8, ptr %add.ptr monotonic, align 1
  %conv = sext i8 %0 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local zeroext i32 @ld_align32_uint32_t_int8_t(ptr nocapture readonly %ptr) {
; CHECK-P10-LABEL: ld_align32_uint32_t_int8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    plbz r3, 99999000(r3), 0
; CHECK-P10-NEXT:    extsb r3, r3
; CHECK-P10-NEXT:    clrldi r3, r3, 32
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_align32_uint32_t_int8_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 1525
; CHECK-PREP10-NEXT:    ori r4, r4, 56600
; CHECK-PREP10-NEXT:    lbzx r3, r3, r4
; CHECK-PREP10-NEXT:    extsb r3, r3
; CHECK-PREP10-NEXT:    clrldi r3, r3, 32
; CHECK-PREP10-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 99999000
  %0 = load atomic i8, ptr %add.ptr monotonic, align 1
  %conv = sext i8 %0 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local zeroext i32 @ld_align64_uint32_t_int8_t(ptr nocapture readonly %ptr) {
; CHECK-P10-LABEL: ld_align64_uint32_t_int8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    lbzx r3, r3, r4
; CHECK-P10-NEXT:    extsb r3, r3
; CHECK-P10-NEXT:    clrldi r3, r3, 32
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_align64_uint32_t_int8_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    lbzx r3, r3, r4
; CHECK-PREP10-NEXT:    extsb r3, r3
; CHECK-PREP10-NEXT:    clrldi r3, r3, 32
; CHECK-PREP10-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 1000000000000
  %0 = load atomic i8, ptr %add.ptr monotonic, align 1
  %conv = sext i8 %0 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local zeroext i32 @ld_reg_uint32_t_int8_t(ptr nocapture readonly %ptr, i64 %off) {
; CHECK-LABEL: ld_reg_uint32_t_int8_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lbzx r3, r3, r4
; CHECK-NEXT:    extsb r3, r3
; CHECK-NEXT:    clrldi r3, r3, 32
; CHECK-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 %off
  %0 = load atomic i8, ptr %add.ptr monotonic, align 1
  %conv = sext i8 %0 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local zeroext i32 @ld_or_uint32_t_int8_t(i64 %ptr, i8 zeroext %off) {
; CHECK-LABEL: ld_or_uint32_t_int8_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    or r3, r4, r3
; CHECK-NEXT:    lbz r3, 0(r3)
; CHECK-NEXT:    extsb r3, r3
; CHECK-NEXT:    clrldi r3, r3, 32
; CHECK-NEXT:    blr
entry:
  %conv = zext i8 %off to i64
  %or = or i64 %conv, %ptr
  %0 = inttoptr i64 %or to ptr
  %1 = load atomic i8, ptr %0 monotonic, align 1
  %conv1 = sext i8 %1 to i32
  ret i32 %conv1
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local zeroext i32 @ld_not_disjoint16_uint32_t_int8_t(i64 %ptr) {
; CHECK-LABEL: ld_not_disjoint16_uint32_t_int8_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 6
; CHECK-NEXT:    lbz r3, 0(r3)
; CHECK-NEXT:    extsb r3, r3
; CHECK-NEXT:    clrldi r3, r3, 32
; CHECK-NEXT:    blr
entry:
  %or = or i64 %ptr, 6
  %0 = inttoptr i64 %or to ptr
  %1 = load atomic i8, ptr %0 monotonic, align 1
  %conv = sext i8 %1 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local zeroext i32 @ld_disjoint_align16_uint32_t_int8_t(i64 %ptr) {
; CHECK-LABEL: ld_disjoint_align16_uint32_t_int8_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rldicr r3, r3, 0, 51
; CHECK-NEXT:    lbz r3, 24(r3)
; CHECK-NEXT:    extsb r3, r3
; CHECK-NEXT:    clrldi r3, r3, 32
; CHECK-NEXT:    blr
entry:
  %and = and i64 %ptr, -4096
  %or = or i64 %and, 24
  %0 = inttoptr i64 %or to ptr
  %1 = load atomic i8, ptr %0 monotonic, align 8
  %conv = sext i8 %1 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local zeroext i32 @ld_not_disjoint32_uint32_t_int8_t(i64 %ptr) {
; CHECK-LABEL: ld_not_disjoint32_uint32_t_int8_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 34463
; CHECK-NEXT:    oris r3, r3, 1
; CHECK-NEXT:    lbz r3, 0(r3)
; CHECK-NEXT:    extsb r3, r3
; CHECK-NEXT:    clrldi r3, r3, 32
; CHECK-NEXT:    blr
entry:
  %or = or i64 %ptr, 99999
  %0 = inttoptr i64 %or to ptr
  %1 = load atomic i8, ptr %0 monotonic, align 1
  %conv = sext i8 %1 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local zeroext i32 @ld_disjoint_align32_uint32_t_int8_t(i64 %ptr) {
; CHECK-P10-LABEL: ld_disjoint_align32_uint32_t_int8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    lis r4, -15264
; CHECK-P10-NEXT:    and r3, r3, r4
; CHECK-P10-NEXT:    plbz r3, 999990000(r3), 0
; CHECK-P10-NEXT:    extsb r3, r3
; CHECK-P10-NEXT:    clrldi r3, r3, 32
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_disjoint_align32_uint32_t_int8_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, -15264
; CHECK-PREP10-NEXT:    and r3, r3, r4
; CHECK-PREP10-NEXT:    lis r4, 15258
; CHECK-PREP10-NEXT:    ori r4, r4, 41712
; CHECK-PREP10-NEXT:    lbzx r3, r3, r4
; CHECK-PREP10-NEXT:    extsb r3, r3
; CHECK-PREP10-NEXT:    clrldi r3, r3, 32
; CHECK-PREP10-NEXT:    blr
entry:
  %and = and i64 %ptr, -1000341504
  %or = or i64 %and, 999990000
  %0 = inttoptr i64 %or to ptr
  %1 = load atomic i8, ptr %0 monotonic, align 16
  %conv = sext i8 %1 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local zeroext i32 @ld_not_disjoint64_uint32_t_int8_t(i64 %ptr) {
; CHECK-P10-LABEL: ld_not_disjoint64_uint32_t_int8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 232
; CHECK-P10-NEXT:    pli r5, 3567587329
; CHECK-P10-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-NEXT:    or r3, r3, r5
; CHECK-P10-NEXT:    lbz r3, 0(r3)
; CHECK-P10-NEXT:    extsb r3, r3
; CHECK-P10-NEXT:    clrldi r3, r3, 32
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_not_disjoint64_uint32_t_int8_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    li r4, 29
; CHECK-PREP10-NEXT:    rldic r4, r4, 35, 24
; CHECK-PREP10-NEXT:    oris r4, r4, 54437
; CHECK-PREP10-NEXT:    ori r4, r4, 4097
; CHECK-PREP10-NEXT:    or r3, r3, r4
; CHECK-PREP10-NEXT:    lbz r3, 0(r3)
; CHECK-PREP10-NEXT:    extsb r3, r3
; CHECK-PREP10-NEXT:    clrldi r3, r3, 32
; CHECK-PREP10-NEXT:    blr
entry:
  %or = or i64 %ptr, 1000000000001
  %0 = inttoptr i64 %or to ptr
  %1 = load atomic i8, ptr %0 monotonic, align 1
  %conv = sext i8 %1 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local zeroext i32 @ld_disjoint_align64_uint32_t_int8_t(i64 %ptr) {
; CHECK-P10-LABEL: ld_disjoint_align64_uint32_t_int8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    lbzx r3, r3, r4
; CHECK-P10-NEXT:    extsb r3, r3
; CHECK-P10-NEXT:    clrldi r3, r3, 32
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_disjoint_align64_uint32_t_int8_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    lbzx r3, r3, r4
; CHECK-PREP10-NEXT:    extsb r3, r3
; CHECK-PREP10-NEXT:    clrldi r3, r3, 32
; CHECK-PREP10-NEXT:    blr
entry:
  %and = and i64 %ptr, -1099511627776
  %or = or i64 %and, 1000000000000
  %0 = inttoptr i64 %or to ptr
  %1 = load atomic i8, ptr %0 monotonic, align 4096
  %conv = sext i8 %1 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local zeroext i32 @ld_cst_align16_uint32_t_int8_t() {
; CHECK-LABEL: ld_cst_align16_uint32_t_int8_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lbz r3, 4080(0)
; CHECK-NEXT:    extsb r3, r3
; CHECK-NEXT:    clrldi r3, r3, 32
; CHECK-NEXT:    blr
entry:
  %0 = load atomic i8, ptr inttoptr (i64 4080 to ptr) monotonic, align 16
  %conv = sext i8 %0 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local zeroext i32 @ld_cst_align32_uint32_t_int8_t() {
; CHECK-LABEL: ld_cst_align32_uint32_t_int8_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lis r3, 153
; CHECK-NEXT:    lbz r3, -27108(r3)
; CHECK-NEXT:    extsb r3, r3
; CHECK-NEXT:    clrldi r3, r3, 32
; CHECK-NEXT:    blr
entry:
  %0 = load atomic i8, ptr inttoptr (i64 9999900 to ptr) monotonic, align 4
  %conv = sext i8 %0 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local zeroext i32 @ld_cst_align64_uint32_t_int8_t() {
; CHECK-P10-LABEL: ld_cst_align64_uint32_t_int8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r3, 244140625
; CHECK-P10-NEXT:    rldic r3, r3, 12, 24
; CHECK-P10-NEXT:    lbz r3, 0(r3)
; CHECK-P10-NEXT:    extsb r3, r3
; CHECK-P10-NEXT:    clrldi r3, r3, 32
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_cst_align64_uint32_t_int8_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r3, 3725
; CHECK-PREP10-NEXT:    ori r3, r3, 19025
; CHECK-PREP10-NEXT:    rldic r3, r3, 12, 24
; CHECK-PREP10-NEXT:    lbz r3, 0(r3)
; CHECK-PREP10-NEXT:    extsb r3, r3
; CHECK-PREP10-NEXT:    clrldi r3, r3, 32
; CHECK-PREP10-NEXT:    blr
entry:
  %0 = load atomic i8, ptr inttoptr (i64 1000000000000 to ptr) monotonic, align 4096
  %conv = sext i8 %0 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local zeroext i32 @ld_0_uint32_t_uint16_t(i64 %ptr) {
; CHECK-LABEL: ld_0_uint32_t_uint16_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lhz r3, 0(r3)
; CHECK-NEXT:    blr
entry:
  %0 = inttoptr i64 %ptr to ptr
  %1 = load atomic i16, ptr %0 monotonic, align 2
  %conv = zext i16 %1 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local zeroext i32 @ld_align16_uint32_t_uint16_t(ptr nocapture readonly %ptr) {
; CHECK-LABEL: ld_align16_uint32_t_uint16_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lhz r3, 8(r3)
; CHECK-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 8
  %0 = load atomic i16, ptr %add.ptr monotonic, align 2
  %conv = zext i16 %0 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local zeroext i32 @ld_align32_uint32_t_uint16_t(ptr nocapture readonly %ptr) {
; CHECK-P10-LABEL: ld_align32_uint32_t_uint16_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    plhz r3, 99999000(r3), 0
; CHECK-P10-NEXT:    clrldi r3, r3, 32
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_align32_uint32_t_uint16_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 1525
; CHECK-PREP10-NEXT:    ori r4, r4, 56600
; CHECK-PREP10-NEXT:    lhzx r3, r3, r4
; CHECK-PREP10-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 99999000
  %0 = load atomic i16, ptr %add.ptr monotonic, align 2
  %conv = zext i16 %0 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local zeroext i32 @ld_align64_uint32_t_uint16_t(ptr nocapture readonly %ptr) {
; CHECK-P10-LABEL: ld_align64_uint32_t_uint16_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    lhzx r3, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_align64_uint32_t_uint16_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    lhzx r3, r3, r4
; CHECK-PREP10-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 1000000000000
  %0 = load atomic i16, ptr %add.ptr monotonic, align 2
  %conv = zext i16 %0 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local zeroext i32 @ld_reg_uint32_t_uint16_t(ptr nocapture readonly %ptr, i64 %off) {
; CHECK-LABEL: ld_reg_uint32_t_uint16_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lhzx r3, r3, r4
; CHECK-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 %off
  %0 = load atomic i16, ptr %add.ptr monotonic, align 2
  %conv = zext i16 %0 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local zeroext i32 @ld_or_uint32_t_uint16_t(i64 %ptr, i8 zeroext %off) {
; CHECK-LABEL: ld_or_uint32_t_uint16_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    or r3, r4, r3
; CHECK-NEXT:    lhz r3, 0(r3)
; CHECK-NEXT:    blr
entry:
  %conv = zext i8 %off to i64
  %or = or i64 %conv, %ptr
  %0 = inttoptr i64 %or to ptr
  %1 = load atomic i16, ptr %0 monotonic, align 2
  %conv1 = zext i16 %1 to i32
  ret i32 %conv1
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local zeroext i32 @ld_not_disjoint16_uint32_t_uint16_t(i64 %ptr) {
; CHECK-LABEL: ld_not_disjoint16_uint32_t_uint16_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 6
; CHECK-NEXT:    lhz r3, 0(r3)
; CHECK-NEXT:    blr
entry:
  %or = or i64 %ptr, 6
  %0 = inttoptr i64 %or to ptr
  %1 = load atomic i16, ptr %0 monotonic, align 2
  %conv = zext i16 %1 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local zeroext i32 @ld_disjoint_align16_uint32_t_uint16_t(i64 %ptr) {
; CHECK-LABEL: ld_disjoint_align16_uint32_t_uint16_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rldicr r3, r3, 0, 51
; CHECK-NEXT:    lhz r3, 24(r3)
; CHECK-NEXT:    blr
entry:
  %and = and i64 %ptr, -4096
  %or = or i64 %and, 24
  %0 = inttoptr i64 %or to ptr
  %1 = load atomic i16, ptr %0 monotonic, align 8
  %conv = zext i16 %1 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local zeroext i32 @ld_not_disjoint32_uint32_t_uint16_t(i64 %ptr) {
; CHECK-LABEL: ld_not_disjoint32_uint32_t_uint16_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 34463
; CHECK-NEXT:    oris r3, r3, 1
; CHECK-NEXT:    lhz r3, 0(r3)
; CHECK-NEXT:    blr
entry:
  %or = or i64 %ptr, 99999
  %0 = inttoptr i64 %or to ptr
  %1 = load atomic i16, ptr %0 monotonic, align 2
  %conv = zext i16 %1 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local zeroext i32 @ld_disjoint_align32_uint32_t_uint16_t(i64 %ptr) {
; CHECK-P10-LABEL: ld_disjoint_align32_uint32_t_uint16_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    lis r4, -15264
; CHECK-P10-NEXT:    and r3, r3, r4
; CHECK-P10-NEXT:    plhz r3, 999990000(r3), 0
; CHECK-P10-NEXT:    clrldi r3, r3, 32
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_disjoint_align32_uint32_t_uint16_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, -15264
; CHECK-PREP10-NEXT:    and r3, r3, r4
; CHECK-PREP10-NEXT:    lis r4, 15258
; CHECK-PREP10-NEXT:    ori r4, r4, 41712
; CHECK-PREP10-NEXT:    lhzx r3, r3, r4
; CHECK-PREP10-NEXT:    blr
entry:
  %and = and i64 %ptr, -1000341504
  %or = or i64 %and, 999990000
  %0 = inttoptr i64 %or to ptr
  %1 = load atomic i16, ptr %0 monotonic, align 16
  %conv = zext i16 %1 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local zeroext i32 @ld_not_disjoint64_uint32_t_uint16_t(i64 %ptr) {
; CHECK-P10-LABEL: ld_not_disjoint64_uint32_t_uint16_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 232
; CHECK-P10-NEXT:    pli r5, 3567587329
; CHECK-P10-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-NEXT:    or r3, r3, r5
; CHECK-P10-NEXT:    lhz r3, 0(r3)
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_not_disjoint64_uint32_t_uint16_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    li r4, 29
; CHECK-PREP10-NEXT:    rldic r4, r4, 35, 24
; CHECK-PREP10-NEXT:    oris r4, r4, 54437
; CHECK-PREP10-NEXT:    ori r4, r4, 4097
; CHECK-PREP10-NEXT:    or r3, r3, r4
; CHECK-PREP10-NEXT:    lhz r3, 0(r3)
; CHECK-PREP10-NEXT:    blr
entry:
  %or = or i64 %ptr, 1000000000001
  %0 = inttoptr i64 %or to ptr
  %1 = load atomic i16, ptr %0 monotonic, align 2
  %conv = zext i16 %1 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local zeroext i32 @ld_disjoint_align64_uint32_t_uint16_t(i64 %ptr) {
; CHECK-P10-LABEL: ld_disjoint_align64_uint32_t_uint16_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    lhzx r3, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_disjoint_align64_uint32_t_uint16_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    lhzx r3, r3, r4
; CHECK-PREP10-NEXT:    blr
entry:
  %and = and i64 %ptr, -1099511627776
  %or = or i64 %and, 1000000000000
  %0 = inttoptr i64 %or to ptr
  %1 = load atomic i16, ptr %0 monotonic, align 4096
  %conv = zext i16 %1 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local zeroext i32 @ld_cst_align16_uint32_t_uint16_t() {
; CHECK-LABEL: ld_cst_align16_uint32_t_uint16_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lhz r3, 4080(0)
; CHECK-NEXT:    blr
entry:
  %0 = load atomic i16, ptr inttoptr (i64 4080 to ptr) monotonic, align 16
  %conv = zext i16 %0 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local zeroext i32 @ld_cst_align32_uint32_t_uint16_t() {
; CHECK-LABEL: ld_cst_align32_uint32_t_uint16_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lis r3, 153
; CHECK-NEXT:    lhz r3, -27108(r3)
; CHECK-NEXT:    blr
entry:
  %0 = load atomic i16, ptr inttoptr (i64 9999900 to ptr) monotonic, align 4
  %conv = zext i16 %0 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local zeroext i32 @ld_cst_align64_uint32_t_uint16_t() {
; CHECK-P10-LABEL: ld_cst_align64_uint32_t_uint16_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r3, 244140625
; CHECK-P10-NEXT:    rldic r3, r3, 12, 24
; CHECK-P10-NEXT:    lhz r3, 0(r3)
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_cst_align64_uint32_t_uint16_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r3, 3725
; CHECK-PREP10-NEXT:    ori r3, r3, 19025
; CHECK-PREP10-NEXT:    rldic r3, r3, 12, 24
; CHECK-PREP10-NEXT:    lhz r3, 0(r3)
; CHECK-PREP10-NEXT:    blr
entry:
  %0 = load atomic i16, ptr inttoptr (i64 1000000000000 to ptr) monotonic, align 4096
  %conv = zext i16 %0 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local zeroext i32 @ld_0_uint32_t_int16_t(i64 %ptr) {
; CHECK-LABEL: ld_0_uint32_t_int16_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lha r3, 0(r3)
; CHECK-NEXT:    clrldi r3, r3, 32
; CHECK-NEXT:    blr
entry:
  %0 = inttoptr i64 %ptr to ptr
  %1 = load atomic i16, ptr %0 monotonic, align 2
  %conv = sext i16 %1 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local zeroext i32 @ld_align16_uint32_t_int16_t(ptr nocapture readonly %ptr) {
; CHECK-LABEL: ld_align16_uint32_t_int16_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lha r3, 8(r3)
; CHECK-NEXT:    clrldi r3, r3, 32
; CHECK-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 8
  %0 = load atomic i16, ptr %add.ptr monotonic, align 2
  %conv = sext i16 %0 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local zeroext i32 @ld_align32_uint32_t_int16_t(ptr nocapture readonly %ptr) {
; CHECK-P10-LABEL: ld_align32_uint32_t_int16_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    plhz r3, 99999000(r3), 0
; CHECK-P10-NEXT:    extsh r3, r3
; CHECK-P10-NEXT:    clrldi r3, r3, 32
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_align32_uint32_t_int16_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 1525
; CHECK-PREP10-NEXT:    ori r4, r4, 56600
; CHECK-PREP10-NEXT:    lhax r3, r3, r4
; CHECK-PREP10-NEXT:    clrldi r3, r3, 32
; CHECK-PREP10-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 99999000
  %0 = load atomic i16, ptr %add.ptr monotonic, align 2
  %conv = sext i16 %0 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local zeroext i32 @ld_align64_uint32_t_int16_t(ptr nocapture readonly %ptr) {
; CHECK-P10-LABEL: ld_align64_uint32_t_int16_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    lhax r3, r3, r4
; CHECK-P10-NEXT:    clrldi r3, r3, 32
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_align64_uint32_t_int16_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    lhax r3, r3, r4
; CHECK-PREP10-NEXT:    clrldi r3, r3, 32
; CHECK-PREP10-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 1000000000000
  %0 = load atomic i16, ptr %add.ptr monotonic, align 2
  %conv = sext i16 %0 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local zeroext i32 @ld_reg_uint32_t_int16_t(ptr nocapture readonly %ptr, i64 %off) {
; CHECK-LABEL: ld_reg_uint32_t_int16_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lhax r3, r3, r4
; CHECK-NEXT:    clrldi r3, r3, 32
; CHECK-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 %off
  %0 = load atomic i16, ptr %add.ptr monotonic, align 2
  %conv = sext i16 %0 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local zeroext i32 @ld_or_uint32_t_int16_t(i64 %ptr, i8 zeroext %off) {
; CHECK-LABEL: ld_or_uint32_t_int16_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    or r3, r4, r3
; CHECK-NEXT:    lha r3, 0(r3)
; CHECK-NEXT:    clrldi r3, r3, 32
; CHECK-NEXT:    blr
entry:
  %conv = zext i8 %off to i64
  %or = or i64 %conv, %ptr
  %0 = inttoptr i64 %or to ptr
  %1 = load atomic i16, ptr %0 monotonic, align 2
  %conv1 = sext i16 %1 to i32
  ret i32 %conv1
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local zeroext i32 @ld_not_disjoint16_uint32_t_int16_t(i64 %ptr) {
; CHECK-LABEL: ld_not_disjoint16_uint32_t_int16_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 6
; CHECK-NEXT:    lha r3, 0(r3)
; CHECK-NEXT:    clrldi r3, r3, 32
; CHECK-NEXT:    blr
entry:
  %or = or i64 %ptr, 6
  %0 = inttoptr i64 %or to ptr
  %1 = load atomic i16, ptr %0 monotonic, align 2
  %conv = sext i16 %1 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local zeroext i32 @ld_disjoint_align16_uint32_t_int16_t(i64 %ptr) {
; CHECK-LABEL: ld_disjoint_align16_uint32_t_int16_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rldicr r3, r3, 0, 51
; CHECK-NEXT:    lha r3, 24(r3)
; CHECK-NEXT:    clrldi r3, r3, 32
; CHECK-NEXT:    blr
entry:
  %and = and i64 %ptr, -4096
  %or = or i64 %and, 24
  %0 = inttoptr i64 %or to ptr
  %1 = load atomic i16, ptr %0 monotonic, align 8
  %conv = sext i16 %1 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local zeroext i32 @ld_not_disjoint32_uint32_t_int16_t(i64 %ptr) {
; CHECK-LABEL: ld_not_disjoint32_uint32_t_int16_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 34463
; CHECK-NEXT:    oris r3, r3, 1
; CHECK-NEXT:    lha r3, 0(r3)
; CHECK-NEXT:    clrldi r3, r3, 32
; CHECK-NEXT:    blr
entry:
  %or = or i64 %ptr, 99999
  %0 = inttoptr i64 %or to ptr
  %1 = load atomic i16, ptr %0 monotonic, align 2
  %conv = sext i16 %1 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local zeroext i32 @ld_disjoint_align32_uint32_t_int16_t(i64 %ptr) {
; CHECK-P10-LABEL: ld_disjoint_align32_uint32_t_int16_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    lis r4, -15264
; CHECK-P10-NEXT:    and r3, r3, r4
; CHECK-P10-NEXT:    plhz r3, 999990000(r3), 0
; CHECK-P10-NEXT:    extsh r3, r3
; CHECK-P10-NEXT:    clrldi r3, r3, 32
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_disjoint_align32_uint32_t_int16_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, -15264
; CHECK-PREP10-NEXT:    and r3, r3, r4
; CHECK-PREP10-NEXT:    lis r4, 15258
; CHECK-PREP10-NEXT:    ori r4, r4, 41712
; CHECK-PREP10-NEXT:    lhax r3, r3, r4
; CHECK-PREP10-NEXT:    clrldi r3, r3, 32
; CHECK-PREP10-NEXT:    blr
entry:
  %and = and i64 %ptr, -1000341504
  %or = or i64 %and, 999990000
  %0 = inttoptr i64 %or to ptr
  %1 = load atomic i16, ptr %0 monotonic, align 16
  %conv = sext i16 %1 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local zeroext i32 @ld_not_disjoint64_uint32_t_int16_t(i64 %ptr) {
; CHECK-P10-LABEL: ld_not_disjoint64_uint32_t_int16_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 232
; CHECK-P10-NEXT:    pli r5, 3567587329
; CHECK-P10-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-NEXT:    or r3, r3, r5
; CHECK-P10-NEXT:    lha r3, 0(r3)
; CHECK-P10-NEXT:    clrldi r3, r3, 32
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_not_disjoint64_uint32_t_int16_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    li r4, 29
; CHECK-PREP10-NEXT:    rldic r4, r4, 35, 24
; CHECK-PREP10-NEXT:    oris r4, r4, 54437
; CHECK-PREP10-NEXT:    ori r4, r4, 4097
; CHECK-PREP10-NEXT:    or r3, r3, r4
; CHECK-PREP10-NEXT:    lha r3, 0(r3)
; CHECK-PREP10-NEXT:    clrldi r3, r3, 32
; CHECK-PREP10-NEXT:    blr
entry:
  %or = or i64 %ptr, 1000000000001
  %0 = inttoptr i64 %or to ptr
  %1 = load atomic i16, ptr %0 monotonic, align 2
  %conv = sext i16 %1 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local zeroext i32 @ld_disjoint_align64_uint32_t_int16_t(i64 %ptr) {
; CHECK-P10-LABEL: ld_disjoint_align64_uint32_t_int16_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    lhax r3, r3, r4
; CHECK-P10-NEXT:    clrldi r3, r3, 32
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_disjoint_align64_uint32_t_int16_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    lhax r3, r3, r4
; CHECK-PREP10-NEXT:    clrldi r3, r3, 32
; CHECK-PREP10-NEXT:    blr
entry:
  %and = and i64 %ptr, -1099511627776
  %or = or i64 %and, 1000000000000
  %0 = inttoptr i64 %or to ptr
  %1 = load atomic i16, ptr %0 monotonic, align 4096
  %conv = sext i16 %1 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local zeroext i32 @ld_cst_align16_uint32_t_int16_t() {
; CHECK-LABEL: ld_cst_align16_uint32_t_int16_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lha r3, 4080(0)
; CHECK-NEXT:    clrldi r3, r3, 32
; CHECK-NEXT:    blr
entry:
  %0 = load atomic i16, ptr inttoptr (i64 4080 to ptr) monotonic, align 16
  %conv = sext i16 %0 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local zeroext i32 @ld_cst_align32_uint32_t_int16_t() {
; CHECK-LABEL: ld_cst_align32_uint32_t_int16_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lis r3, 153
; CHECK-NEXT:    lha r3, -27108(r3)
; CHECK-NEXT:    clrldi r3, r3, 32
; CHECK-NEXT:    blr
entry:
  %0 = load atomic i16, ptr inttoptr (i64 9999900 to ptr) monotonic, align 4
  %conv = sext i16 %0 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local zeroext i32 @ld_cst_align64_uint32_t_int16_t() {
; CHECK-P10-LABEL: ld_cst_align64_uint32_t_int16_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r3, 244140625
; CHECK-P10-NEXT:    rldic r3, r3, 12, 24
; CHECK-P10-NEXT:    lha r3, 0(r3)
; CHECK-P10-NEXT:    clrldi r3, r3, 32
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_cst_align64_uint32_t_int16_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r3, 3725
; CHECK-PREP10-NEXT:    ori r3, r3, 19025
; CHECK-PREP10-NEXT:    rldic r3, r3, 12, 24
; CHECK-PREP10-NEXT:    lha r3, 0(r3)
; CHECK-PREP10-NEXT:    clrldi r3, r3, 32
; CHECK-PREP10-NEXT:    blr
entry:
  %0 = load atomic i16, ptr inttoptr (i64 1000000000000 to ptr) monotonic, align 4096
  %conv = sext i16 %0 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local zeroext i32 @ld_0_uint32_t_uint32_t(i64 %ptr) {
; CHECK-LABEL: ld_0_uint32_t_uint32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lwz r3, 0(r3)
; CHECK-NEXT:    blr
entry:
  %0 = inttoptr i64 %ptr to ptr
  %1 = load atomic i32, ptr %0 monotonic, align 4
  ret i32 %1
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local zeroext i32 @ld_align16_uint32_t_uint32_t(ptr nocapture readonly %ptr) {
; CHECK-LABEL: ld_align16_uint32_t_uint32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lwz r3, 8(r3)
; CHECK-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 8
  %0 = load atomic i32, ptr %add.ptr monotonic, align 4
  ret i32 %0
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local zeroext i32 @ld_align32_uint32_t_uint32_t(ptr nocapture readonly %ptr) {
; CHECK-P10-LABEL: ld_align32_uint32_t_uint32_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    plwz r3, 99999000(r3), 0
; CHECK-P10-NEXT:    clrldi r3, r3, 32
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_align32_uint32_t_uint32_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 1525
; CHECK-PREP10-NEXT:    ori r4, r4, 56600
; CHECK-PREP10-NEXT:    lwzx r3, r3, r4
; CHECK-PREP10-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 99999000
  %0 = load atomic i32, ptr %add.ptr monotonic, align 4
  ret i32 %0
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local zeroext i32 @ld_align64_uint32_t_uint32_t(ptr nocapture readonly %ptr) {
; CHECK-P10-LABEL: ld_align64_uint32_t_uint32_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    lwzx r3, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_align64_uint32_t_uint32_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    lwzx r3, r3, r4
; CHECK-PREP10-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 1000000000000
  %0 = load atomic i32, ptr %add.ptr monotonic, align 4
  ret i32 %0
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local zeroext i32 @ld_reg_uint32_t_uint32_t(ptr nocapture readonly %ptr, i64 %off) {
; CHECK-LABEL: ld_reg_uint32_t_uint32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lwzx r3, r3, r4
; CHECK-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 %off
  %0 = load atomic i32, ptr %add.ptr monotonic, align 4
  ret i32 %0
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local zeroext i32 @ld_or_uint32_t_uint32_t(i64 %ptr, i8 zeroext %off) {
; CHECK-LABEL: ld_or_uint32_t_uint32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    or r3, r4, r3
; CHECK-NEXT:    lwz r3, 0(r3)
; CHECK-NEXT:    blr
entry:
  %conv = zext i8 %off to i64
  %or = or i64 %conv, %ptr
  %0 = inttoptr i64 %or to ptr
  %1 = load atomic i32, ptr %0 monotonic, align 4
  ret i32 %1
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local zeroext i32 @ld_not_disjoint16_uint32_t_uint32_t(i64 %ptr) {
; CHECK-LABEL: ld_not_disjoint16_uint32_t_uint32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 6
; CHECK-NEXT:    lwz r3, 0(r3)
; CHECK-NEXT:    blr
entry:
  %or = or i64 %ptr, 6
  %0 = inttoptr i64 %or to ptr
  %1 = load atomic i32, ptr %0 monotonic, align 4
  ret i32 %1
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local zeroext i32 @ld_disjoint_align16_uint32_t_uint32_t(i64 %ptr) {
; CHECK-LABEL: ld_disjoint_align16_uint32_t_uint32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rldicr r3, r3, 0, 51
; CHECK-NEXT:    lwz r3, 24(r3)
; CHECK-NEXT:    blr
entry:
  %and = and i64 %ptr, -4096
  %or = or i64 %and, 24
  %0 = inttoptr i64 %or to ptr
  %1 = load atomic i32, ptr %0 monotonic, align 8
  ret i32 %1
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local zeroext i32 @ld_not_disjoint32_uint32_t_uint32_t(i64 %ptr) {
; CHECK-LABEL: ld_not_disjoint32_uint32_t_uint32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 34463
; CHECK-NEXT:    oris r3, r3, 1
; CHECK-NEXT:    lwz r3, 0(r3)
; CHECK-NEXT:    blr
entry:
  %or = or i64 %ptr, 99999
  %0 = inttoptr i64 %or to ptr
  %1 = load atomic i32, ptr %0 monotonic, align 4
  ret i32 %1
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local zeroext i32 @ld_disjoint_align32_uint32_t_uint32_t(i64 %ptr) {
; CHECK-P10-LABEL: ld_disjoint_align32_uint32_t_uint32_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    lis r4, -15264
; CHECK-P10-NEXT:    and r3, r3, r4
; CHECK-P10-NEXT:    plwz r3, 999990000(r3), 0
; CHECK-P10-NEXT:    clrldi r3, r3, 32
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_disjoint_align32_uint32_t_uint32_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, -15264
; CHECK-PREP10-NEXT:    and r3, r3, r4
; CHECK-PREP10-NEXT:    lis r4, 15258
; CHECK-PREP10-NEXT:    ori r4, r4, 41712
; CHECK-PREP10-NEXT:    lwzx r3, r3, r4
; CHECK-PREP10-NEXT:    blr
entry:
  %and = and i64 %ptr, -1000341504
  %or = or i64 %and, 999990000
  %0 = inttoptr i64 %or to ptr
  %1 = load atomic i32, ptr %0 monotonic, align 16
  ret i32 %1
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local zeroext i32 @ld_not_disjoint64_uint32_t_uint32_t(i64 %ptr) {
; CHECK-P10-LABEL: ld_not_disjoint64_uint32_t_uint32_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 232
; CHECK-P10-NEXT:    pli r5, 3567587329
; CHECK-P10-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-NEXT:    or r3, r3, r5
; CHECK-P10-NEXT:    lwz r3, 0(r3)
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_not_disjoint64_uint32_t_uint32_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    li r4, 29
; CHECK-PREP10-NEXT:    rldic r4, r4, 35, 24
; CHECK-PREP10-NEXT:    oris r4, r4, 54437
; CHECK-PREP10-NEXT:    ori r4, r4, 4097
; CHECK-PREP10-NEXT:    or r3, r3, r4
; CHECK-PREP10-NEXT:    lwz r3, 0(r3)
; CHECK-PREP10-NEXT:    blr
entry:
  %or = or i64 %ptr, 1000000000001
  %0 = inttoptr i64 %or to ptr
  %1 = load atomic i32, ptr %0 monotonic, align 4
  ret i32 %1
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local zeroext i32 @ld_disjoint_align64_uint32_t_uint32_t(i64 %ptr) {
; CHECK-P10-LABEL: ld_disjoint_align64_uint32_t_uint32_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    lwzx r3, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_disjoint_align64_uint32_t_uint32_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    lwzx r3, r3, r4
; CHECK-PREP10-NEXT:    blr
entry:
  %and = and i64 %ptr, -1099511627776
  %or = or i64 %and, 1000000000000
  %0 = inttoptr i64 %or to ptr
  %1 = load atomic i32, ptr %0 monotonic, align 4096
  ret i32 %1
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local zeroext i32 @ld_cst_align16_uint32_t_uint32_t() {
; CHECK-LABEL: ld_cst_align16_uint32_t_uint32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lwz r3, 4080(0)
; CHECK-NEXT:    blr
entry:
  %0 = load atomic i32, ptr inttoptr (i64 4080 to ptr) monotonic, align 16
  ret i32 %0
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local zeroext i32 @ld_cst_align32_uint32_t_uint32_t() {
; CHECK-LABEL: ld_cst_align32_uint32_t_uint32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lis r3, 153
; CHECK-NEXT:    lwz r3, -27108(r3)
; CHECK-NEXT:    blr
entry:
  %0 = load atomic i32, ptr inttoptr (i64 9999900 to ptr) monotonic, align 4
  ret i32 %0
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local zeroext i32 @ld_cst_align64_uint32_t_uint32_t() {
; CHECK-P10-LABEL: ld_cst_align64_uint32_t_uint32_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r3, 244140625
; CHECK-P10-NEXT:    rldic r3, r3, 12, 24
; CHECK-P10-NEXT:    lwz r3, 0(r3)
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_cst_align64_uint32_t_uint32_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r3, 3725
; CHECK-PREP10-NEXT:    ori r3, r3, 19025
; CHECK-PREP10-NEXT:    rldic r3, r3, 12, 24
; CHECK-PREP10-NEXT:    lwz r3, 0(r3)
; CHECK-PREP10-NEXT:    blr
entry:
  %0 = load atomic i32, ptr inttoptr (i64 1000000000000 to ptr) monotonic, align 4096
  ret i32 %0
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local zeroext i32 @ld_0_uint32_t_uint64_t(i64 %ptr) {
; CHECK-LABEL: ld_0_uint32_t_uint64_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ld r3, 0(r3)
; CHECK-NEXT:    clrldi r3, r3, 32
; CHECK-NEXT:    blr
entry:
  %0 = inttoptr i64 %ptr to ptr
  %1 = load atomic i64, ptr %0 monotonic, align 8
  %conv = trunc i64 %1 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local zeroext i32 @ld_align16_uint32_t_uint64_t(ptr nocapture readonly %ptr) {
; CHECK-LABEL: ld_align16_uint32_t_uint64_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ld r3, 8(r3)
; CHECK-NEXT:    clrldi r3, r3, 32
; CHECK-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 8
  %0 = load atomic i64, ptr %add.ptr monotonic, align 8
  %conv = trunc i64 %0 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local zeroext i32 @ld_align32_uint32_t_uint64_t(ptr nocapture readonly %ptr) {
; CHECK-P10-LABEL: ld_align32_uint32_t_uint64_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pld r3, 99999000(r3), 0
; CHECK-P10-NEXT:    clrldi r3, r3, 32
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_align32_uint32_t_uint64_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 1525
; CHECK-PREP10-NEXT:    ori r4, r4, 56600
; CHECK-PREP10-NEXT:    ldx r3, r3, r4
; CHECK-PREP10-NEXT:    clrldi r3, r3, 32
; CHECK-PREP10-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 99999000
  %0 = load atomic i64, ptr %add.ptr monotonic, align 8
  %conv = trunc i64 %0 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local zeroext i32 @ld_align64_uint32_t_uint64_t(ptr nocapture readonly %ptr) {
; CHECK-P10-LABEL: ld_align64_uint32_t_uint64_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    ldx r3, r3, r4
; CHECK-P10-NEXT:    clrldi r3, r3, 32
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_align64_uint32_t_uint64_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    ldx r3, r3, r4
; CHECK-PREP10-NEXT:    clrldi r3, r3, 32
; CHECK-PREP10-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 1000000000000
  %0 = load atomic i64, ptr %add.ptr monotonic, align 8
  %conv = trunc i64 %0 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local zeroext i32 @ld_reg_uint32_t_uint64_t(ptr nocapture readonly %ptr, i64 %off) {
; CHECK-LABEL: ld_reg_uint32_t_uint64_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ldx r3, r3, r4
; CHECK-NEXT:    clrldi r3, r3, 32
; CHECK-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 %off
  %0 = load atomic i64, ptr %add.ptr monotonic, align 8
  %conv = trunc i64 %0 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local zeroext i32 @ld_or_uint32_t_uint64_t(i64 %ptr, i8 zeroext %off) {
; CHECK-LABEL: ld_or_uint32_t_uint64_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    or r3, r4, r3
; CHECK-NEXT:    ld r3, 0(r3)
; CHECK-NEXT:    clrldi r3, r3, 32
; CHECK-NEXT:    blr
entry:
  %conv = zext i8 %off to i64
  %or = or i64 %conv, %ptr
  %0 = inttoptr i64 %or to ptr
  %1 = load atomic i64, ptr %0 monotonic, align 8
  %conv1 = trunc i64 %1 to i32
  ret i32 %conv1
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local zeroext i32 @ld_not_disjoint16_uint32_t_uint64_t(i64 %ptr) {
; CHECK-LABEL: ld_not_disjoint16_uint32_t_uint64_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 6
; CHECK-NEXT:    ld r3, 0(r3)
; CHECK-NEXT:    clrldi r3, r3, 32
; CHECK-NEXT:    blr
entry:
  %or = or i64 %ptr, 6
  %0 = inttoptr i64 %or to ptr
  %1 = load atomic i64, ptr %0 monotonic, align 8
  %conv = trunc i64 %1 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local zeroext i32 @ld_disjoint_align16_uint32_t_uint64_t(i64 %ptr) {
; CHECK-LABEL: ld_disjoint_align16_uint32_t_uint64_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rldicr r3, r3, 0, 51
; CHECK-NEXT:    ld r3, 24(r3)
; CHECK-NEXT:    clrldi r3, r3, 32
; CHECK-NEXT:    blr
entry:
  %and = and i64 %ptr, -4096
  %or = or i64 %and, 24
  %0 = inttoptr i64 %or to ptr
  %1 = load atomic i64, ptr %0 monotonic, align 8
  %conv = trunc i64 %1 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local zeroext i32 @ld_not_disjoint32_uint32_t_uint64_t(i64 %ptr) {
; CHECK-LABEL: ld_not_disjoint32_uint32_t_uint64_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 34463
; CHECK-NEXT:    oris r3, r3, 1
; CHECK-NEXT:    ld r3, 0(r3)
; CHECK-NEXT:    clrldi r3, r3, 32
; CHECK-NEXT:    blr
entry:
  %or = or i64 %ptr, 99999
  %0 = inttoptr i64 %or to ptr
  %1 = load atomic i64, ptr %0 monotonic, align 8
  %conv = trunc i64 %1 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local zeroext i32 @ld_disjoint_align32_uint32_t_uint64_t(i64 %ptr) {
; CHECK-P10-LABEL: ld_disjoint_align32_uint32_t_uint64_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    lis r4, -15264
; CHECK-P10-NEXT:    and r3, r3, r4
; CHECK-P10-NEXT:    pld r3, 999990000(r3), 0
; CHECK-P10-NEXT:    clrldi r3, r3, 32
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_disjoint_align32_uint32_t_uint64_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, -15264
; CHECK-PREP10-NEXT:    and r3, r3, r4
; CHECK-PREP10-NEXT:    lis r4, 15258
; CHECK-PREP10-NEXT:    ori r4, r4, 41712
; CHECK-PREP10-NEXT:    ldx r3, r3, r4
; CHECK-PREP10-NEXT:    clrldi r3, r3, 32
; CHECK-PREP10-NEXT:    blr
entry:
  %and = and i64 %ptr, -1000341504
  %or = or i64 %and, 999990000
  %0 = inttoptr i64 %or to ptr
  %1 = load atomic i64, ptr %0 monotonic, align 16
  %conv = trunc i64 %1 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local zeroext i32 @ld_not_disjoint64_uint32_t_uint64_t(i64 %ptr) {
; CHECK-P10-LABEL: ld_not_disjoint64_uint32_t_uint64_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 232
; CHECK-P10-NEXT:    pli r5, 3567587329
; CHECK-P10-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-NEXT:    or r3, r3, r5
; CHECK-P10-NEXT:    ld r3, 0(r3)
; CHECK-P10-NEXT:    clrldi r3, r3, 32
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_not_disjoint64_uint32_t_uint64_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    li r4, 29
; CHECK-PREP10-NEXT:    rldic r4, r4, 35, 24
; CHECK-PREP10-NEXT:    oris r4, r4, 54437
; CHECK-PREP10-NEXT:    ori r4, r4, 4097
; CHECK-PREP10-NEXT:    or r3, r3, r4
; CHECK-PREP10-NEXT:    ld r3, 0(r3)
; CHECK-PREP10-NEXT:    clrldi r3, r3, 32
; CHECK-PREP10-NEXT:    blr
entry:
  %or = or i64 %ptr, 1000000000001
  %0 = inttoptr i64 %or to ptr
  %1 = load atomic i64, ptr %0 monotonic, align 8
  %conv = trunc i64 %1 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local zeroext i32 @ld_disjoint_align64_uint32_t_uint64_t(i64 %ptr) {
; CHECK-P10-LABEL: ld_disjoint_align64_uint32_t_uint64_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    ldx r3, r3, r4
; CHECK-P10-NEXT:    clrldi r3, r3, 32
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_disjoint_align64_uint32_t_uint64_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    ldx r3, r3, r4
; CHECK-PREP10-NEXT:    clrldi r3, r3, 32
; CHECK-PREP10-NEXT:    blr
entry:
  %and = and i64 %ptr, -1099511627776
  %or = or i64 %and, 1000000000000
  %0 = inttoptr i64 %or to ptr
  %1 = load atomic i64, ptr %0 monotonic, align 4096
  %conv = trunc i64 %1 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local zeroext i32 @ld_cst_align16_uint32_t_uint64_t() {
; CHECK-LABEL: ld_cst_align16_uint32_t_uint64_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ld r3, 4080(0)
; CHECK-NEXT:    clrldi r3, r3, 32
; CHECK-NEXT:    blr
entry:
  %0 = load atomic i64, ptr inttoptr (i64 4080 to ptr) monotonic, align 16
  %conv = trunc i64 %0 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local zeroext i32 @ld_cst_align32_uint32_t_uint64_t() {
; CHECK-LABEL: ld_cst_align32_uint32_t_uint64_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lis r3, 153
; CHECK-NEXT:    ld r3, -27108(r3)
; CHECK-NEXT:    clrldi r3, r3, 32
; CHECK-NEXT:    blr
entry:
  %0 = load atomic i64, ptr inttoptr (i64 9999900 to ptr) monotonic, align 8
  %conv = trunc i64 %0 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local zeroext i32 @ld_cst_align64_uint32_t_uint64_t() {
; CHECK-P10-LABEL: ld_cst_align64_uint32_t_uint64_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r3, 244140625
; CHECK-P10-NEXT:    rldic r3, r3, 12, 24
; CHECK-P10-NEXT:    ld r3, 0(r3)
; CHECK-P10-NEXT:    clrldi r3, r3, 32
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_cst_align64_uint32_t_uint64_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r3, 3725
; CHECK-PREP10-NEXT:    ori r3, r3, 19025
; CHECK-PREP10-NEXT:    rldic r3, r3, 12, 24
; CHECK-PREP10-NEXT:    ld r3, 0(r3)
; CHECK-PREP10-NEXT:    clrldi r3, r3, 32
; CHECK-PREP10-NEXT:    blr
entry:
  %0 = load atomic i64, ptr inttoptr (i64 1000000000000 to ptr) monotonic, align 4096
  %conv = trunc i64 %0 to i32
  ret i32 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @st_0_uint32_t_uint8_t(i64 %ptr, i32 zeroext %str) {
; CHECK-LABEL: st_0_uint32_t_uint8_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    stb r4, 0(r3)
; CHECK-NEXT:    blr
entry:
  %0 = inttoptr i64 %ptr to ptr
  %conv = trunc i32 %str to i8
  store atomic i8 %conv, ptr %0 monotonic, align 1
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @st_align16_uint32_t_uint8_t(ptr nocapture %ptr, i32 zeroext %str) {
; CHECK-LABEL: st_align16_uint32_t_uint8_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    stb r4, 8(r3)
; CHECK-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 8
  %conv = trunc i32 %str to i8
  store atomic i8 %conv, ptr %add.ptr monotonic, align 1
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @st_align32_uint32_t_uint8_t(ptr nocapture %ptr, i32 zeroext %str) {
; CHECK-P10-LABEL: st_align32_uint32_t_uint8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pstb r4, 99999000(r3), 0
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_align32_uint32_t_uint8_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r5, 1525
; CHECK-PREP10-NEXT:    ori r5, r5, 56600
; CHECK-PREP10-NEXT:    stbx r4, r3, r5
; CHECK-PREP10-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 99999000
  %conv = trunc i32 %str to i8
  store atomic i8 %conv, ptr %add.ptr monotonic, align 1
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @st_align64_uint32_t_uint8_t(ptr nocapture %ptr, i32 zeroext %str) {
; CHECK-P10-LABEL: st_align64_uint32_t_uint8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r5, 244140625
; CHECK-P10-NEXT:    rldic r5, r5, 12, 24
; CHECK-P10-NEXT:    stbx r4, r3, r5
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_align64_uint32_t_uint8_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r5, 3725
; CHECK-PREP10-NEXT:    ori r5, r5, 19025
; CHECK-PREP10-NEXT:    rldic r5, r5, 12, 24
; CHECK-PREP10-NEXT:    stbx r4, r3, r5
; CHECK-PREP10-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 1000000000000
  %conv = trunc i32 %str to i8
  store atomic i8 %conv, ptr %add.ptr monotonic, align 1
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @st_reg_uint32_t_uint8_t(ptr nocapture %ptr, i64 %off, i32 zeroext %str) {
; CHECK-LABEL: st_reg_uint32_t_uint8_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    stbx r5, r3, r4
; CHECK-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 %off
  %conv = trunc i32 %str to i8
  store atomic i8 %conv, ptr %add.ptr monotonic, align 1
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @st_or1_uint32_t_uint8_t(i64 %ptr, i8 zeroext %off, i32 zeroext %str) {
; CHECK-LABEL: st_or1_uint32_t_uint8_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    or r3, r4, r3
; CHECK-NEXT:    stb r5, 0(r3)
; CHECK-NEXT:    blr
entry:
  %conv = zext i8 %off to i64
  %or = or i64 %conv, %ptr
  %0 = inttoptr i64 %or to ptr
  %conv1 = trunc i32 %str to i8
  store atomic i8 %conv1, ptr %0 monotonic, align 1
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @st_not_disjoint16_uint32_t_uint8_t(i64 %ptr, i32 zeroext %str) {
; CHECK-LABEL: st_not_disjoint16_uint32_t_uint8_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 6
; CHECK-NEXT:    stb r4, 0(r3)
; CHECK-NEXT:    blr
entry:
  %or = or i64 %ptr, 6
  %0 = inttoptr i64 %or to ptr
  %conv = trunc i32 %str to i8
  store atomic i8 %conv, ptr %0 monotonic, align 1
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @st_disjoint_align16_uint32_t_uint8_t(i64 %ptr, i32 zeroext %str) {
; CHECK-LABEL: st_disjoint_align16_uint32_t_uint8_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rldicr r3, r3, 0, 51
; CHECK-NEXT:    stb r4, 24(r3)
; CHECK-NEXT:    blr
entry:
  %and = and i64 %ptr, -4096
  %or = or i64 %and, 24
  %0 = inttoptr i64 %or to ptr
  %conv = trunc i32 %str to i8
  store atomic i8 %conv, ptr %0 monotonic, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @st_not_disjoint32_uint32_t_uint8_t(i64 %ptr, i32 zeroext %str) {
; CHECK-LABEL: st_not_disjoint32_uint32_t_uint8_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 34463
; CHECK-NEXT:    oris r3, r3, 1
; CHECK-NEXT:    stb r4, 0(r3)
; CHECK-NEXT:    blr
entry:
  %or = or i64 %ptr, 99999
  %0 = inttoptr i64 %or to ptr
  %conv = trunc i32 %str to i8
  store atomic i8 %conv, ptr %0 monotonic, align 1
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @st_disjoint_align32_uint32_t_uint8_t(i64 %ptr, i32 zeroext %str) {
; CHECK-P10-LABEL: st_disjoint_align32_uint32_t_uint8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    lis r5, -15264
; CHECK-P10-NEXT:    and r3, r3, r5
; CHECK-P10-NEXT:    pstb r4, 999990000(r3), 0
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_disjoint_align32_uint32_t_uint8_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r5, -15264
; CHECK-PREP10-NEXT:    and r3, r3, r5
; CHECK-PREP10-NEXT:    lis r5, 15258
; CHECK-PREP10-NEXT:    ori r5, r5, 41712
; CHECK-PREP10-NEXT:    stbx r4, r3, r5
; CHECK-PREP10-NEXT:    blr
entry:
  %and = and i64 %ptr, -1000341504
  %or = or i64 %and, 999990000
  %0 = inttoptr i64 %or to ptr
  %conv = trunc i32 %str to i8
  store atomic i8 %conv, ptr %0 monotonic, align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @st_not_disjoint64_uint32_t_uint8_t(i64 %ptr, i32 zeroext %str) {
; CHECK-P10-LABEL: st_not_disjoint64_uint32_t_uint8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r5, 232
; CHECK-P10-NEXT:    pli r6, 3567587329
; CHECK-P10-NEXT:    rldimi r6, r5, 32, 0
; CHECK-P10-NEXT:    or r3, r3, r6
; CHECK-P10-NEXT:    stb r4, 0(r3)
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_not_disjoint64_uint32_t_uint8_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    li r5, 29
; CHECK-PREP10-NEXT:    rldic r5, r5, 35, 24
; CHECK-PREP10-NEXT:    oris r5, r5, 54437
; CHECK-PREP10-NEXT:    ori r5, r5, 4097
; CHECK-PREP10-NEXT:    or r3, r3, r5
; CHECK-PREP10-NEXT:    stb r4, 0(r3)
; CHECK-PREP10-NEXT:    blr
entry:
  %or = or i64 %ptr, 1000000000001
  %0 = inttoptr i64 %or to ptr
  %conv = trunc i32 %str to i8
  store atomic i8 %conv, ptr %0 monotonic, align 1
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @st_disjoint_align64_uint32_t_uint8_t(i64 %ptr, i32 zeroext %str) {
; CHECK-P10-LABEL: st_disjoint_align64_uint32_t_uint8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r5, 244140625
; CHECK-P10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-NEXT:    rldic r5, r5, 12, 24
; CHECK-P10-NEXT:    stbx r4, r3, r5
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_disjoint_align64_uint32_t_uint8_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r5, 3725
; CHECK-PREP10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-PREP10-NEXT:    ori r5, r5, 19025
; CHECK-PREP10-NEXT:    rldic r5, r5, 12, 24
; CHECK-PREP10-NEXT:    stbx r4, r3, r5
; CHECK-PREP10-NEXT:    blr
entry:
  %and = and i64 %ptr, -1099511627776
  %or = or i64 %and, 1000000000000
  %0 = inttoptr i64 %or to ptr
  %conv = trunc i32 %str to i8
  store atomic i8 %conv, ptr %0 monotonic, align 4096
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @st_cst_align16_uint32_t_uint8_t(i32 zeroext %str) {
; CHECK-LABEL: st_cst_align16_uint32_t_uint8_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    stb r3, 4080(0)
; CHECK-NEXT:    blr
entry:
  %conv = trunc i32 %str to i8
  store atomic i8 %conv, ptr inttoptr (i64 4080 to ptr) monotonic, align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @st_cst_align32_uint32_t_uint8_t(i32 zeroext %str) {
; CHECK-LABEL: st_cst_align32_uint32_t_uint8_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lis r4, 153
; CHECK-NEXT:    stb r3, -27108(r4)
; CHECK-NEXT:    blr
entry:
  %conv = trunc i32 %str to i8
  store atomic i8 %conv, ptr inttoptr (i64 9999900 to ptr) monotonic, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @st_cst_align64_uint32_t_uint8_t(i32 zeroext %str) {
; CHECK-P10-LABEL: st_cst_align64_uint32_t_uint8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    stb r3, 0(r4)
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_cst_align64_uint32_t_uint8_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    stb r3, 0(r4)
; CHECK-PREP10-NEXT:    blr
entry:
  %conv = trunc i32 %str to i8
  store atomic i8 %conv, ptr inttoptr (i64 1000000000000 to ptr) monotonic, align 4096
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @st_0_uint32_t_uint16_t(i64 %ptr, i32 zeroext %str) {
; CHECK-LABEL: st_0_uint32_t_uint16_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sth r4, 0(r3)
; CHECK-NEXT:    blr
entry:
  %0 = inttoptr i64 %ptr to ptr
  %conv = trunc i32 %str to i16
  store atomic i16 %conv, ptr %0 monotonic, align 2
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @st_align16_uint32_t_uint16_t(ptr nocapture %ptr, i32 zeroext %str) {
; CHECK-LABEL: st_align16_uint32_t_uint16_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sth r4, 8(r3)
; CHECK-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 8
  %conv = trunc i32 %str to i16
  store atomic i16 %conv, ptr %add.ptr monotonic, align 2
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @st_align32_uint32_t_uint16_t(ptr nocapture %ptr, i32 zeroext %str) {
; CHECK-P10-LABEL: st_align32_uint32_t_uint16_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    psth r4, 99999000(r3), 0
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_align32_uint32_t_uint16_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r5, 1525
; CHECK-PREP10-NEXT:    ori r5, r5, 56600
; CHECK-PREP10-NEXT:    sthx r4, r3, r5
; CHECK-PREP10-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 99999000
  %conv = trunc i32 %str to i16
  store atomic i16 %conv, ptr %add.ptr monotonic, align 2
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @st_align64_uint32_t_uint16_t(ptr nocapture %ptr, i32 zeroext %str) {
; CHECK-P10-LABEL: st_align64_uint32_t_uint16_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r5, 244140625
; CHECK-P10-NEXT:    rldic r5, r5, 12, 24
; CHECK-P10-NEXT:    sthx r4, r3, r5
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_align64_uint32_t_uint16_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r5, 3725
; CHECK-PREP10-NEXT:    ori r5, r5, 19025
; CHECK-PREP10-NEXT:    rldic r5, r5, 12, 24
; CHECK-PREP10-NEXT:    sthx r4, r3, r5
; CHECK-PREP10-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 1000000000000
  %conv = trunc i32 %str to i16
  store atomic i16 %conv, ptr %add.ptr monotonic, align 2
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @st_reg_uint32_t_uint16_t(ptr nocapture %ptr, i64 %off, i32 zeroext %str) {
; CHECK-LABEL: st_reg_uint32_t_uint16_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sthx r5, r3, r4
; CHECK-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 %off
  %conv = trunc i32 %str to i16
  store atomic i16 %conv, ptr %add.ptr monotonic, align 2
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @st_or1_uint32_t_uint16_t(i64 %ptr, i8 zeroext %off, i32 zeroext %str) {
; CHECK-LABEL: st_or1_uint32_t_uint16_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    or r3, r4, r3
; CHECK-NEXT:    sth r5, 0(r3)
; CHECK-NEXT:    blr
entry:
  %conv = zext i8 %off to i64
  %or = or i64 %conv, %ptr
  %0 = inttoptr i64 %or to ptr
  %conv1 = trunc i32 %str to i16
  store atomic i16 %conv1, ptr %0 monotonic, align 2
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @st_not_disjoint16_uint32_t_uint16_t(i64 %ptr, i32 zeroext %str) {
; CHECK-LABEL: st_not_disjoint16_uint32_t_uint16_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 6
; CHECK-NEXT:    sth r4, 0(r3)
; CHECK-NEXT:    blr
entry:
  %or = or i64 %ptr, 6
  %0 = inttoptr i64 %or to ptr
  %conv = trunc i32 %str to i16
  store atomic i16 %conv, ptr %0 monotonic, align 2
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @st_disjoint_align16_uint32_t_uint16_t(i64 %ptr, i32 zeroext %str) {
; CHECK-LABEL: st_disjoint_align16_uint32_t_uint16_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rldicr r3, r3, 0, 51
; CHECK-NEXT:    sth r4, 24(r3)
; CHECK-NEXT:    blr
entry:
  %and = and i64 %ptr, -4096
  %or = or i64 %and, 24
  %0 = inttoptr i64 %or to ptr
  %conv = trunc i32 %str to i16
  store atomic i16 %conv, ptr %0 monotonic, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @st_not_disjoint32_uint32_t_uint16_t(i64 %ptr, i32 zeroext %str) {
; CHECK-LABEL: st_not_disjoint32_uint32_t_uint16_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 34463
; CHECK-NEXT:    oris r3, r3, 1
; CHECK-NEXT:    sth r4, 0(r3)
; CHECK-NEXT:    blr
entry:
  %or = or i64 %ptr, 99999
  %0 = inttoptr i64 %or to ptr
  %conv = trunc i32 %str to i16
  store atomic i16 %conv, ptr %0 monotonic, align 2
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @st_disjoint_align32_uint32_t_uint16_t(i64 %ptr, i32 zeroext %str) {
; CHECK-P10-LABEL: st_disjoint_align32_uint32_t_uint16_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    lis r5, -15264
; CHECK-P10-NEXT:    and r3, r3, r5
; CHECK-P10-NEXT:    psth r4, 999990000(r3), 0
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_disjoint_align32_uint32_t_uint16_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r5, -15264
; CHECK-PREP10-NEXT:    and r3, r3, r5
; CHECK-PREP10-NEXT:    lis r5, 15258
; CHECK-PREP10-NEXT:    ori r5, r5, 41712
; CHECK-PREP10-NEXT:    sthx r4, r3, r5
; CHECK-PREP10-NEXT:    blr
entry:
  %and = and i64 %ptr, -1000341504
  %or = or i64 %and, 999990000
  %0 = inttoptr i64 %or to ptr
  %conv = trunc i32 %str to i16
  store atomic i16 %conv, ptr %0 monotonic, align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @st_not_disjoint64_uint32_t_uint16_t(i64 %ptr, i32 zeroext %str) {
; CHECK-P10-LABEL: st_not_disjoint64_uint32_t_uint16_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r5, 232
; CHECK-P10-NEXT:    pli r6, 3567587329
; CHECK-P10-NEXT:    rldimi r6, r5, 32, 0
; CHECK-P10-NEXT:    or r3, r3, r6
; CHECK-P10-NEXT:    sth r4, 0(r3)
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_not_disjoint64_uint32_t_uint16_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    li r5, 29
; CHECK-PREP10-NEXT:    rldic r5, r5, 35, 24
; CHECK-PREP10-NEXT:    oris r5, r5, 54437
; CHECK-PREP10-NEXT:    ori r5, r5, 4097
; CHECK-PREP10-NEXT:    or r3, r3, r5
; CHECK-PREP10-NEXT:    sth r4, 0(r3)
; CHECK-PREP10-NEXT:    blr
entry:
  %or = or i64 %ptr, 1000000000001
  %0 = inttoptr i64 %or to ptr
  %conv = trunc i32 %str to i16
  store atomic i16 %conv, ptr %0 monotonic, align 2
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @st_disjoint_align64_uint32_t_uint16_t(i64 %ptr, i32 zeroext %str) {
; CHECK-P10-LABEL: st_disjoint_align64_uint32_t_uint16_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r5, 244140625
; CHECK-P10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-NEXT:    rldic r5, r5, 12, 24
; CHECK-P10-NEXT:    sthx r4, r3, r5
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_disjoint_align64_uint32_t_uint16_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r5, 3725
; CHECK-PREP10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-PREP10-NEXT:    ori r5, r5, 19025
; CHECK-PREP10-NEXT:    rldic r5, r5, 12, 24
; CHECK-PREP10-NEXT:    sthx r4, r3, r5
; CHECK-PREP10-NEXT:    blr
entry:
  %and = and i64 %ptr, -1099511627776
  %or = or i64 %and, 1000000000000
  %0 = inttoptr i64 %or to ptr
  %conv = trunc i32 %str to i16
  store atomic i16 %conv, ptr %0 monotonic, align 4096
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @st_cst_align16_uint32_t_uint16_t(i32 zeroext %str) {
; CHECK-LABEL: st_cst_align16_uint32_t_uint16_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sth r3, 4080(0)
; CHECK-NEXT:    blr
entry:
  %conv = trunc i32 %str to i16
  store atomic i16 %conv, ptr inttoptr (i64 4080 to ptr) monotonic, align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @st_cst_align32_uint32_t_uint16_t(i32 zeroext %str) {
; CHECK-LABEL: st_cst_align32_uint32_t_uint16_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lis r4, 153
; CHECK-NEXT:    sth r3, -27108(r4)
; CHECK-NEXT:    blr
entry:
  %conv = trunc i32 %str to i16
  store atomic i16 %conv, ptr inttoptr (i64 9999900 to ptr) monotonic, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @st_cst_align64_uint32_t_uint16_t(i32 zeroext %str) {
; CHECK-P10-LABEL: st_cst_align64_uint32_t_uint16_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    sth r3, 0(r4)
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_cst_align64_uint32_t_uint16_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    sth r3, 0(r4)
; CHECK-PREP10-NEXT:    blr
entry:
  %conv = trunc i32 %str to i16
  store atomic i16 %conv, ptr inttoptr (i64 1000000000000 to ptr) monotonic, align 4096
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @st_0_uint32_t_uint32_t(i64 %ptr, i32 zeroext %str) {
; CHECK-LABEL: st_0_uint32_t_uint32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    stw r4, 0(r3)
; CHECK-NEXT:    blr
entry:
  %0 = inttoptr i64 %ptr to ptr
  store atomic i32 %str, ptr %0 monotonic, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @st_align16_uint32_t_uint32_t(ptr nocapture %ptr, i32 zeroext %str) {
; CHECK-LABEL: st_align16_uint32_t_uint32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    stw r4, 8(r3)
; CHECK-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 8
  store atomic i32 %str, ptr %add.ptr monotonic, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @st_align32_uint32_t_uint32_t(ptr nocapture %ptr, i32 zeroext %str) {
; CHECK-P10-LABEL: st_align32_uint32_t_uint32_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pstw r4, 99999000(r3), 0
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_align32_uint32_t_uint32_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r5, 1525
; CHECK-PREP10-NEXT:    ori r5, r5, 56600
; CHECK-PREP10-NEXT:    stwx r4, r3, r5
; CHECK-PREP10-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 99999000
  store atomic i32 %str, ptr %add.ptr monotonic, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @st_align64_uint32_t_uint32_t(ptr nocapture %ptr, i32 zeroext %str) {
; CHECK-P10-LABEL: st_align64_uint32_t_uint32_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r5, 244140625
; CHECK-P10-NEXT:    rldic r5, r5, 12, 24
; CHECK-P10-NEXT:    stwx r4, r3, r5
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_align64_uint32_t_uint32_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r5, 3725
; CHECK-PREP10-NEXT:    ori r5, r5, 19025
; CHECK-PREP10-NEXT:    rldic r5, r5, 12, 24
; CHECK-PREP10-NEXT:    stwx r4, r3, r5
; CHECK-PREP10-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 1000000000000
  store atomic i32 %str, ptr %add.ptr monotonic, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @st_reg_uint32_t_uint32_t(ptr nocapture %ptr, i64 %off, i32 zeroext %str) {
; CHECK-LABEL: st_reg_uint32_t_uint32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    stwx r5, r3, r4
; CHECK-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 %off
  store atomic i32 %str, ptr %add.ptr monotonic, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @st_or1_uint32_t_uint32_t(i64 %ptr, i8 zeroext %off, i32 zeroext %str) {
; CHECK-LABEL: st_or1_uint32_t_uint32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    or r3, r4, r3
; CHECK-NEXT:    stw r5, 0(r3)
; CHECK-NEXT:    blr
entry:
  %conv = zext i8 %off to i64
  %or = or i64 %conv, %ptr
  %0 = inttoptr i64 %or to ptr
  store atomic i32 %str, ptr %0 monotonic, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @st_not_disjoint16_uint32_t_uint32_t(i64 %ptr, i32 zeroext %str) {
; CHECK-LABEL: st_not_disjoint16_uint32_t_uint32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 6
; CHECK-NEXT:    stw r4, 0(r3)
; CHECK-NEXT:    blr
entry:
  %or = or i64 %ptr, 6
  %0 = inttoptr i64 %or to ptr
  store atomic i32 %str, ptr %0 monotonic, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @st_disjoint_align16_uint32_t_uint32_t(i64 %ptr, i32 zeroext %str) {
; CHECK-LABEL: st_disjoint_align16_uint32_t_uint32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rldicr r3, r3, 0, 51
; CHECK-NEXT:    stw r4, 24(r3)
; CHECK-NEXT:    blr
entry:
  %and = and i64 %ptr, -4096
  %or = or i64 %and, 24
  %0 = inttoptr i64 %or to ptr
  store atomic i32 %str, ptr %0 monotonic, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @st_not_disjoint32_uint32_t_uint32_t(i64 %ptr, i32 zeroext %str) {
; CHECK-LABEL: st_not_disjoint32_uint32_t_uint32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 34463
; CHECK-NEXT:    oris r3, r3, 1
; CHECK-NEXT:    stw r4, 0(r3)
; CHECK-NEXT:    blr
entry:
  %or = or i64 %ptr, 99999
  %0 = inttoptr i64 %or to ptr
  store atomic i32 %str, ptr %0 monotonic, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @st_disjoint_align32_uint32_t_uint32_t(i64 %ptr, i32 zeroext %str) {
; CHECK-P10-LABEL: st_disjoint_align32_uint32_t_uint32_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    lis r5, -15264
; CHECK-P10-NEXT:    and r3, r3, r5
; CHECK-P10-NEXT:    pstw r4, 999990000(r3), 0
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_disjoint_align32_uint32_t_uint32_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r5, -15264
; CHECK-PREP10-NEXT:    and r3, r3, r5
; CHECK-PREP10-NEXT:    lis r5, 15258
; CHECK-PREP10-NEXT:    ori r5, r5, 41712
; CHECK-PREP10-NEXT:    stwx r4, r3, r5
; CHECK-PREP10-NEXT:    blr
entry:
  %and = and i64 %ptr, -1000341504
  %or = or i64 %and, 999990000
  %0 = inttoptr i64 %or to ptr
  store atomic i32 %str, ptr %0 monotonic, align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @st_not_disjoint64_uint32_t_uint32_t(i64 %ptr, i32 zeroext %str) {
; CHECK-P10-LABEL: st_not_disjoint64_uint32_t_uint32_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r5, 232
; CHECK-P10-NEXT:    pli r6, 3567587329
; CHECK-P10-NEXT:    rldimi r6, r5, 32, 0
; CHECK-P10-NEXT:    or r3, r3, r6
; CHECK-P10-NEXT:    stw r4, 0(r3)
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_not_disjoint64_uint32_t_uint32_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    li r5, 29
; CHECK-PREP10-NEXT:    rldic r5, r5, 35, 24
; CHECK-PREP10-NEXT:    oris r5, r5, 54437
; CHECK-PREP10-NEXT:    ori r5, r5, 4097
; CHECK-PREP10-NEXT:    or r3, r3, r5
; CHECK-PREP10-NEXT:    stw r4, 0(r3)
; CHECK-PREP10-NEXT:    blr
entry:
  %or = or i64 %ptr, 1000000000001
  %0 = inttoptr i64 %or to ptr
  store atomic i32 %str, ptr %0 monotonic, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @st_disjoint_align64_uint32_t_uint32_t(i64 %ptr, i32 zeroext %str) {
; CHECK-P10-LABEL: st_disjoint_align64_uint32_t_uint32_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r5, 244140625
; CHECK-P10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-NEXT:    rldic r5, r5, 12, 24
; CHECK-P10-NEXT:    stwx r4, r3, r5
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_disjoint_align64_uint32_t_uint32_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r5, 3725
; CHECK-PREP10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-PREP10-NEXT:    ori r5, r5, 19025
; CHECK-PREP10-NEXT:    rldic r5, r5, 12, 24
; CHECK-PREP10-NEXT:    stwx r4, r3, r5
; CHECK-PREP10-NEXT:    blr
entry:
  %and = and i64 %ptr, -1099511627776
  %or = or i64 %and, 1000000000000
  %0 = inttoptr i64 %or to ptr
  store atomic i32 %str, ptr %0 monotonic, align 4096
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @st_cst_align16_uint32_t_uint32_t(i32 zeroext %str) {
; CHECK-LABEL: st_cst_align16_uint32_t_uint32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    stw r3, 4080(0)
; CHECK-NEXT:    blr
entry:
  store atomic i32 %str, ptr inttoptr (i64 4080 to ptr) monotonic, align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @st_cst_align32_uint32_t_uint32_t(i32 zeroext %str) {
; CHECK-LABEL: st_cst_align32_uint32_t_uint32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lis r4, 153
; CHECK-NEXT:    stw r3, -27108(r4)
; CHECK-NEXT:    blr
entry:
  store atomic i32 %str, ptr inttoptr (i64 9999900 to ptr) monotonic, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @st_cst_align64_uint32_t_uint32_t(i32 zeroext %str) {
; CHECK-P10-LABEL: st_cst_align64_uint32_t_uint32_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    stw r3, 0(r4)
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_cst_align64_uint32_t_uint32_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    stw r3, 0(r4)
; CHECK-PREP10-NEXT:    blr
entry:
  store atomic i32 %str, ptr inttoptr (i64 1000000000000 to ptr) monotonic, align 4096
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @st_0_uint32_t_uint64_t(i64 %ptr, i32 zeroext %str) {
; CHECK-LABEL: st_0_uint32_t_uint64_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    std r4, 0(r3)
; CHECK-NEXT:    blr
entry:
  %0 = inttoptr i64 %ptr to ptr
  %conv = zext i32 %str to i64
  store atomic i64 %conv, ptr %0 monotonic, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @st_align16_uint32_t_uint64_t(ptr nocapture %ptr, i32 zeroext %str) {
; CHECK-LABEL: st_align16_uint32_t_uint64_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    std r4, 8(r3)
; CHECK-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 8
  %conv = zext i32 %str to i64
  store atomic i64 %conv, ptr %add.ptr monotonic, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @st_align32_uint32_t_uint64_t(ptr nocapture %ptr, i32 zeroext %str) {
; CHECK-P10-LABEL: st_align32_uint32_t_uint64_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pstd r4, 99999000(r3), 0
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_align32_uint32_t_uint64_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r5, 1525
; CHECK-PREP10-NEXT:    ori r5, r5, 56600
; CHECK-PREP10-NEXT:    stdx r4, r3, r5
; CHECK-PREP10-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 99999000
  %conv = zext i32 %str to i64
  store atomic i64 %conv, ptr %add.ptr monotonic, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @st_align64_uint32_t_uint64_t(ptr nocapture %ptr, i32 zeroext %str) {
; CHECK-P10-LABEL: st_align64_uint32_t_uint64_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r5, 244140625
; CHECK-P10-NEXT:    rldic r5, r5, 12, 24
; CHECK-P10-NEXT:    stdx r4, r3, r5
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_align64_uint32_t_uint64_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r5, 3725
; CHECK-PREP10-NEXT:    ori r5, r5, 19025
; CHECK-PREP10-NEXT:    rldic r5, r5, 12, 24
; CHECK-PREP10-NEXT:    stdx r4, r3, r5
; CHECK-PREP10-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 1000000000000
  %conv = zext i32 %str to i64
  store atomic i64 %conv, ptr %add.ptr monotonic, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @st_reg_uint32_t_uint64_t(ptr nocapture %ptr, i64 %off, i32 zeroext %str) {
; CHECK-LABEL: st_reg_uint32_t_uint64_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    stdx r5, r3, r4
; CHECK-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 %off
  %conv = zext i32 %str to i64
  store atomic i64 %conv, ptr %add.ptr monotonic, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @st_or1_uint32_t_uint64_t(i64 %ptr, i8 zeroext %off, i32 zeroext %str) {
; CHECK-LABEL: st_or1_uint32_t_uint64_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    or r3, r4, r3
; CHECK-NEXT:    std r5, 0(r3)
; CHECK-NEXT:    blr
entry:
  %conv = zext i8 %off to i64
  %or = or i64 %conv, %ptr
  %0 = inttoptr i64 %or to ptr
  %conv1 = zext i32 %str to i64
  store atomic i64 %conv1, ptr %0 monotonic, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @st_not_disjoint16_uint32_t_uint64_t(i64 %ptr, i32 zeroext %str) {
; CHECK-LABEL: st_not_disjoint16_uint32_t_uint64_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 6
; CHECK-NEXT:    std r4, 0(r3)
; CHECK-NEXT:    blr
entry:
  %or = or i64 %ptr, 6
  %0 = inttoptr i64 %or to ptr
  %conv = zext i32 %str to i64
  store atomic i64 %conv, ptr %0 monotonic, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @st_disjoint_align16_uint32_t_uint64_t(i64 %ptr, i32 zeroext %str) {
; CHECK-LABEL: st_disjoint_align16_uint32_t_uint64_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rldicr r3, r3, 0, 51
; CHECK-NEXT:    std r4, 24(r3)
; CHECK-NEXT:    blr
entry:
  %and = and i64 %ptr, -4096
  %or = or i64 %and, 24
  %0 = inttoptr i64 %or to ptr
  %conv = zext i32 %str to i64
  store atomic i64 %conv, ptr %0 monotonic, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @st_not_disjoint32_uint32_t_uint64_t(i64 %ptr, i32 zeroext %str) {
; CHECK-LABEL: st_not_disjoint32_uint32_t_uint64_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 34463
; CHECK-NEXT:    oris r3, r3, 1
; CHECK-NEXT:    std r4, 0(r3)
; CHECK-NEXT:    blr
entry:
  %or = or i64 %ptr, 99999
  %0 = inttoptr i64 %or to ptr
  %conv = zext i32 %str to i64
  store atomic i64 %conv, ptr %0 monotonic, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @st_disjoint_align32_uint32_t_uint64_t(i64 %ptr, i32 zeroext %str) {
; CHECK-P10-LABEL: st_disjoint_align32_uint32_t_uint64_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    lis r5, -15264
; CHECK-P10-NEXT:    and r3, r3, r5
; CHECK-P10-NEXT:    pstd r4, 999990000(r3), 0
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_disjoint_align32_uint32_t_uint64_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r5, -15264
; CHECK-PREP10-NEXT:    and r3, r3, r5
; CHECK-PREP10-NEXT:    lis r5, 15258
; CHECK-PREP10-NEXT:    ori r5, r5, 41712
; CHECK-PREP10-NEXT:    stdx r4, r3, r5
; CHECK-PREP10-NEXT:    blr
entry:
  %and = and i64 %ptr, -1000341504
  %or = or i64 %and, 999990000
  %0 = inttoptr i64 %or to ptr
  %conv = zext i32 %str to i64
  store atomic i64 %conv, ptr %0 monotonic, align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @st_not_disjoint64_uint32_t_uint64_t(i64 %ptr, i32 zeroext %str) {
; CHECK-P10-LABEL: st_not_disjoint64_uint32_t_uint64_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r5, 232
; CHECK-P10-NEXT:    pli r6, 3567587329
; CHECK-P10-NEXT:    rldimi r6, r5, 32, 0
; CHECK-P10-NEXT:    or r3, r3, r6
; CHECK-P10-NEXT:    std r4, 0(r3)
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_not_disjoint64_uint32_t_uint64_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    li r5, 29
; CHECK-PREP10-NEXT:    rldic r5, r5, 35, 24
; CHECK-PREP10-NEXT:    oris r5, r5, 54437
; CHECK-PREP10-NEXT:    ori r5, r5, 4097
; CHECK-PREP10-NEXT:    or r3, r3, r5
; CHECK-PREP10-NEXT:    std r4, 0(r3)
; CHECK-PREP10-NEXT:    blr
entry:
  %or = or i64 %ptr, 1000000000001
  %0 = inttoptr i64 %or to ptr
  %conv = zext i32 %str to i64
  store atomic i64 %conv, ptr %0 monotonic, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @st_disjoint_align64_uint32_t_uint64_t(i64 %ptr, i32 zeroext %str) {
; CHECK-P10-LABEL: st_disjoint_align64_uint32_t_uint64_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r5, 244140625
; CHECK-P10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-NEXT:    rldic r5, r5, 12, 24
; CHECK-P10-NEXT:    stdx r4, r3, r5
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_disjoint_align64_uint32_t_uint64_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r5, 3725
; CHECK-PREP10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-PREP10-NEXT:    ori r5, r5, 19025
; CHECK-PREP10-NEXT:    rldic r5, r5, 12, 24
; CHECK-PREP10-NEXT:    stdx r4, r3, r5
; CHECK-PREP10-NEXT:    blr
entry:
  %and = and i64 %ptr, -1099511627776
  %or = or i64 %and, 1000000000000
  %0 = inttoptr i64 %or to ptr
  %conv = zext i32 %str to i64
  store atomic i64 %conv, ptr %0 monotonic, align 4096
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @st_cst_align16_uint32_t_uint64_t(i32 zeroext %str) {
; CHECK-LABEL: st_cst_align16_uint32_t_uint64_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    std r3, 4080(0)
; CHECK-NEXT:    blr
entry:
  %conv = zext i32 %str to i64
  store atomic i64 %conv, ptr inttoptr (i64 4080 to ptr) monotonic, align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @st_cst_align32_uint32_t_uint64_t(i32 zeroext %str) {
; CHECK-LABEL: st_cst_align32_uint32_t_uint64_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lis r4, 153
; CHECK-NEXT:    std r3, -27108(r4)
; CHECK-NEXT:    blr
entry:
  %conv = zext i32 %str to i64
  store atomic i64 %conv, ptr inttoptr (i64 9999900 to ptr) monotonic, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @st_cst_align64_uint32_t_uint64_t(i32 zeroext %str) {
; CHECK-P10-LABEL: st_cst_align64_uint32_t_uint64_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    std r3, 0(r4)
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_cst_align64_uint32_t_uint64_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    std r3, 0(r4)
; CHECK-PREP10-NEXT:    blr
entry:
  %conv = zext i32 %str to i64
  store atomic i64 %conv, ptr inttoptr (i64 1000000000000 to ptr) monotonic, align 4096
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @st_0_int32_t_uint64_t(i64 %ptr, i32 signext %str) {
; CHECK-LABEL: st_0_int32_t_uint64_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    std r4, 0(r3)
; CHECK-NEXT:    blr
entry:
  %0 = inttoptr i64 %ptr to ptr
  %conv = sext i32 %str to i64
  store atomic i64 %conv, ptr %0 monotonic, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @st_align16_int32_t_uint64_t(ptr nocapture %ptr, i32 signext %str) {
; CHECK-LABEL: st_align16_int32_t_uint64_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    std r4, 8(r3)
; CHECK-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 8
  %conv = sext i32 %str to i64
  store atomic i64 %conv, ptr %add.ptr monotonic, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @st_align32_int32_t_uint64_t(ptr nocapture %ptr, i32 signext %str) {
; CHECK-P10-LABEL: st_align32_int32_t_uint64_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pstd r4, 99999000(r3), 0
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_align32_int32_t_uint64_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r5, 1525
; CHECK-PREP10-NEXT:    ori r5, r5, 56600
; CHECK-PREP10-NEXT:    stdx r4, r3, r5
; CHECK-PREP10-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 99999000
  %conv = sext i32 %str to i64
  store atomic i64 %conv, ptr %add.ptr monotonic, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @st_align64_int32_t_uint64_t(ptr nocapture %ptr, i32 signext %str) {
; CHECK-P10-LABEL: st_align64_int32_t_uint64_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r5, 244140625
; CHECK-P10-NEXT:    rldic r5, r5, 12, 24
; CHECK-P10-NEXT:    stdx r4, r3, r5
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_align64_int32_t_uint64_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r5, 3725
; CHECK-PREP10-NEXT:    ori r5, r5, 19025
; CHECK-PREP10-NEXT:    rldic r5, r5, 12, 24
; CHECK-PREP10-NEXT:    stdx r4, r3, r5
; CHECK-PREP10-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 1000000000000
  %conv = sext i32 %str to i64
  store atomic i64 %conv, ptr %add.ptr monotonic, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @st_reg_int32_t_uint64_t(ptr nocapture %ptr, i64 %off, i32 signext %str) {
; CHECK-LABEL: st_reg_int32_t_uint64_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    stdx r5, r3, r4
; CHECK-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 %off
  %conv = sext i32 %str to i64
  store atomic i64 %conv, ptr %add.ptr monotonic, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @st_or1_int32_t_uint64_t(i64 %ptr, i8 zeroext %off, i32 signext %str) {
; CHECK-LABEL: st_or1_int32_t_uint64_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    or r3, r4, r3
; CHECK-NEXT:    std r5, 0(r3)
; CHECK-NEXT:    blr
entry:
  %conv = zext i8 %off to i64
  %or = or i64 %conv, %ptr
  %0 = inttoptr i64 %or to ptr
  %conv1 = sext i32 %str to i64
  store atomic i64 %conv1, ptr %0 monotonic, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @st_not_disjoint16_int32_t_uint64_t(i64 %ptr, i32 signext %str) {
; CHECK-LABEL: st_not_disjoint16_int32_t_uint64_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 6
; CHECK-NEXT:    std r4, 0(r3)
; CHECK-NEXT:    blr
entry:
  %or = or i64 %ptr, 6
  %0 = inttoptr i64 %or to ptr
  %conv = sext i32 %str to i64
  store atomic i64 %conv, ptr %0 monotonic, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @st_disjoint_align16_int32_t_uint64_t(i64 %ptr, i32 signext %str) {
; CHECK-LABEL: st_disjoint_align16_int32_t_uint64_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rldicr r3, r3, 0, 51
; CHECK-NEXT:    std r4, 24(r3)
; CHECK-NEXT:    blr
entry:
  %and = and i64 %ptr, -4096
  %or = or i64 %and, 24
  %0 = inttoptr i64 %or to ptr
  %conv = sext i32 %str to i64
  store atomic i64 %conv, ptr %0 monotonic, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @st_not_disjoint32_int32_t_uint64_t(i64 %ptr, i32 signext %str) {
; CHECK-LABEL: st_not_disjoint32_int32_t_uint64_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 34463
; CHECK-NEXT:    oris r3, r3, 1
; CHECK-NEXT:    std r4, 0(r3)
; CHECK-NEXT:    blr
entry:
  %or = or i64 %ptr, 99999
  %0 = inttoptr i64 %or to ptr
  %conv = sext i32 %str to i64
  store atomic i64 %conv, ptr %0 monotonic, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @st_disjoint_align32_int32_t_uint64_t(i64 %ptr, i32 signext %str) {
; CHECK-P10-LABEL: st_disjoint_align32_int32_t_uint64_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    lis r5, -15264
; CHECK-P10-NEXT:    and r3, r3, r5
; CHECK-P10-NEXT:    pstd r4, 999990000(r3), 0
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_disjoint_align32_int32_t_uint64_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r5, -15264
; CHECK-PREP10-NEXT:    and r3, r3, r5
; CHECK-PREP10-NEXT:    lis r5, 15258
; CHECK-PREP10-NEXT:    ori r5, r5, 41712
; CHECK-PREP10-NEXT:    stdx r4, r3, r5
; CHECK-PREP10-NEXT:    blr
entry:
  %and = and i64 %ptr, -1000341504
  %or = or i64 %and, 999990000
  %0 = inttoptr i64 %or to ptr
  %conv = sext i32 %str to i64
  store atomic i64 %conv, ptr %0 monotonic, align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @st_not_disjoint64_int32_t_uint64_t(i64 %ptr, i32 signext %str) {
; CHECK-P10-LABEL: st_not_disjoint64_int32_t_uint64_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r5, 232
; CHECK-P10-NEXT:    pli r6, 3567587329
; CHECK-P10-NEXT:    rldimi r6, r5, 32, 0
; CHECK-P10-NEXT:    or r3, r3, r6
; CHECK-P10-NEXT:    std r4, 0(r3)
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_not_disjoint64_int32_t_uint64_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    li r5, 29
; CHECK-PREP10-NEXT:    rldic r5, r5, 35, 24
; CHECK-PREP10-NEXT:    oris r5, r5, 54437
; CHECK-PREP10-NEXT:    ori r5, r5, 4097
; CHECK-PREP10-NEXT:    or r3, r3, r5
; CHECK-PREP10-NEXT:    std r4, 0(r3)
; CHECK-PREP10-NEXT:    blr
entry:
  %or = or i64 %ptr, 1000000000001
  %0 = inttoptr i64 %or to ptr
  %conv = sext i32 %str to i64
  store atomic i64 %conv, ptr %0 monotonic, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @st_disjoint_align64_int32_t_uint64_t(i64 %ptr, i32 signext %str) {
; CHECK-P10-LABEL: st_disjoint_align64_int32_t_uint64_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r5, 244140625
; CHECK-P10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-NEXT:    rldic r5, r5, 12, 24
; CHECK-P10-NEXT:    stdx r4, r3, r5
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_disjoint_align64_int32_t_uint64_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r5, 3725
; CHECK-PREP10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-PREP10-NEXT:    ori r5, r5, 19025
; CHECK-PREP10-NEXT:    rldic r5, r5, 12, 24
; CHECK-PREP10-NEXT:    stdx r4, r3, r5
; CHECK-PREP10-NEXT:    blr
entry:
  %and = and i64 %ptr, -1099511627776
  %or = or i64 %and, 1000000000000
  %0 = inttoptr i64 %or to ptr
  %conv = sext i32 %str to i64
  store atomic i64 %conv, ptr %0 monotonic, align 4096
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @st_cst_align16_int32_t_uint64_t(i32 signext %str) {
; CHECK-LABEL: st_cst_align16_int32_t_uint64_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    std r3, 4080(0)
; CHECK-NEXT:    blr
entry:
  %conv = sext i32 %str to i64
  store atomic i64 %conv, ptr inttoptr (i64 4080 to ptr) monotonic, align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @st_cst_align32_int32_t_uint64_t(i32 signext %str) {
; CHECK-LABEL: st_cst_align32_int32_t_uint64_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lis r4, 153
; CHECK-NEXT:    std r3, -27108(r4)
; CHECK-NEXT:    blr
entry:
  %conv = sext i32 %str to i64
  store atomic i64 %conv, ptr inttoptr (i64 9999900 to ptr) monotonic, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @st_cst_align64_int32_t_uint64_t(i32 signext %str) {
; CHECK-P10-LABEL: st_cst_align64_int32_t_uint64_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    std r3, 0(r4)
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_cst_align64_int32_t_uint64_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    std r3, 0(r4)
; CHECK-PREP10-NEXT:    blr
entry:
  %conv = sext i32 %str to i64
  store atomic i64 %conv, ptr inttoptr (i64 1000000000000 to ptr) monotonic, align 4096
  ret void
}
