/*
 * Copyright (C) 2008 The Guava Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.google.common.collect;
public class ForwardingSortedMapImplementsMapTest_gwt extends com.google.gwt.junit.client.GWTTestCase {
@Override public String getModuleName() {
  return "com.google.common.collect.testModule";
}
public void testClear() throws Exception {
  com.google.common.collect.ForwardingSortedMapImplementsMapTest testCase = new com.google.common.collect.ForwardingSortedMapImplementsMapTest();
  testCase.testClear();
}

public void testContainsKey() throws Exception {
  com.google.common.collect.ForwardingSortedMapImplementsMapTest testCase = new com.google.common.collect.ForwardingSortedMapImplementsMapTest();
  testCase.testContainsKey();
}

public void testContainsValue() throws Exception {
  com.google.common.collect.ForwardingSortedMapImplementsMapTest testCase = new com.google.common.collect.ForwardingSortedMapImplementsMapTest();
  testCase.testContainsValue();
}

public void testEntrySet() throws Exception {
  com.google.common.collect.ForwardingSortedMapImplementsMapTest testCase = new com.google.common.collect.ForwardingSortedMapImplementsMapTest();
  testCase.testEntrySet();
}

public void testEntrySetAddAndAddAll() throws Exception {
  com.google.common.collect.ForwardingSortedMapImplementsMapTest testCase = new com.google.common.collect.ForwardingSortedMapImplementsMapTest();
  testCase.testEntrySetAddAndAddAll();
}

public void testEntrySetClear() throws Exception {
  com.google.common.collect.ForwardingSortedMapImplementsMapTest testCase = new com.google.common.collect.ForwardingSortedMapImplementsMapTest();
  testCase.testEntrySetClear();
}

public void testEntrySetContainsEntryIncompatibleKey() throws Exception {
  com.google.common.collect.ForwardingSortedMapImplementsMapTest testCase = new com.google.common.collect.ForwardingSortedMapImplementsMapTest();
  testCase.testEntrySetContainsEntryIncompatibleKey();
}

public void testEntrySetContainsEntryNullKeyMissing() throws Exception {
  com.google.common.collect.ForwardingSortedMapImplementsMapTest testCase = new com.google.common.collect.ForwardingSortedMapImplementsMapTest();
  testCase.testEntrySetContainsEntryNullKeyMissing();
}

public void testEntrySetContainsEntryNullKeyPresent() throws Exception {
  com.google.common.collect.ForwardingSortedMapImplementsMapTest testCase = new com.google.common.collect.ForwardingSortedMapImplementsMapTest();
  testCase.testEntrySetContainsEntryNullKeyPresent();
}

public void testEntrySetForEmptyMap() throws Exception {
  com.google.common.collect.ForwardingSortedMapImplementsMapTest testCase = new com.google.common.collect.ForwardingSortedMapImplementsMapTest();
  testCase.testEntrySetForEmptyMap();
}

public void testEntrySetIteratorRemove() throws Exception {
  com.google.common.collect.ForwardingSortedMapImplementsMapTest testCase = new com.google.common.collect.ForwardingSortedMapImplementsMapTest();
  testCase.testEntrySetIteratorRemove();
}

public void testEntrySetRemove() throws Exception {
  com.google.common.collect.ForwardingSortedMapImplementsMapTest testCase = new com.google.common.collect.ForwardingSortedMapImplementsMapTest();
  testCase.testEntrySetRemove();
}

public void testEntrySetRemoveAll() throws Exception {
  com.google.common.collect.ForwardingSortedMapImplementsMapTest testCase = new com.google.common.collect.ForwardingSortedMapImplementsMapTest();
  testCase.testEntrySetRemoveAll();
}

public void testEntrySetRemoveAllNullFromEmpty() throws Exception {
  com.google.common.collect.ForwardingSortedMapImplementsMapTest testCase = new com.google.common.collect.ForwardingSortedMapImplementsMapTest();
  testCase.testEntrySetRemoveAllNullFromEmpty();
}

public void testEntrySetRemoveDifferentValue() throws Exception {
  com.google.common.collect.ForwardingSortedMapImplementsMapTest testCase = new com.google.common.collect.ForwardingSortedMapImplementsMapTest();
  testCase.testEntrySetRemoveDifferentValue();
}

public void testEntrySetRemoveMissingKey() throws Exception {
  com.google.common.collect.ForwardingSortedMapImplementsMapTest testCase = new com.google.common.collect.ForwardingSortedMapImplementsMapTest();
  testCase.testEntrySetRemoveMissingKey();
}

public void testEntrySetRemoveNullKeyMissing() throws Exception {
  com.google.common.collect.ForwardingSortedMapImplementsMapTest testCase = new com.google.common.collect.ForwardingSortedMapImplementsMapTest();
  testCase.testEntrySetRemoveNullKeyMissing();
}

public void testEntrySetRemoveNullKeyPresent() throws Exception {
  com.google.common.collect.ForwardingSortedMapImplementsMapTest testCase = new com.google.common.collect.ForwardingSortedMapImplementsMapTest();
  testCase.testEntrySetRemoveNullKeyPresent();
}

public void testEntrySetRetainAll() throws Exception {
  com.google.common.collect.ForwardingSortedMapImplementsMapTest testCase = new com.google.common.collect.ForwardingSortedMapImplementsMapTest();
  testCase.testEntrySetRetainAll();
}

public void testEntrySetRetainAllNullFromEmpty() throws Exception {
  com.google.common.collect.ForwardingSortedMapImplementsMapTest testCase = new com.google.common.collect.ForwardingSortedMapImplementsMapTest();
  testCase.testEntrySetRetainAllNullFromEmpty();
}

public void testEntrySetSetValue() throws Exception {
  com.google.common.collect.ForwardingSortedMapImplementsMapTest testCase = new com.google.common.collect.ForwardingSortedMapImplementsMapTest();
  testCase.testEntrySetSetValue();
}

public void testEntrySetSetValueSameValue() throws Exception {
  com.google.common.collect.ForwardingSortedMapImplementsMapTest testCase = new com.google.common.collect.ForwardingSortedMapImplementsMapTest();
  testCase.testEntrySetSetValueSameValue();
}

public void testEqualsForEmptyMap() throws Exception {
  com.google.common.collect.ForwardingSortedMapImplementsMapTest testCase = new com.google.common.collect.ForwardingSortedMapImplementsMapTest();
  testCase.testEqualsForEmptyMap();
}

public void testEqualsForEqualMap() throws Exception {
  com.google.common.collect.ForwardingSortedMapImplementsMapTest testCase = new com.google.common.collect.ForwardingSortedMapImplementsMapTest();
  testCase.testEqualsForEqualMap();
}

public void testEqualsForLargerMap() throws Exception {
  com.google.common.collect.ForwardingSortedMapImplementsMapTest testCase = new com.google.common.collect.ForwardingSortedMapImplementsMapTest();
  testCase.testEqualsForLargerMap();
}

public void testEqualsForSmallerMap() throws Exception {
  com.google.common.collect.ForwardingSortedMapImplementsMapTest testCase = new com.google.common.collect.ForwardingSortedMapImplementsMapTest();
  testCase.testEqualsForSmallerMap();
}

public void testGet() throws Exception {
  com.google.common.collect.ForwardingSortedMapImplementsMapTest testCase = new com.google.common.collect.ForwardingSortedMapImplementsMapTest();
  testCase.testGet();
}

public void testGetForEmptyMap() throws Exception {
  com.google.common.collect.ForwardingSortedMapImplementsMapTest testCase = new com.google.common.collect.ForwardingSortedMapImplementsMapTest();
  testCase.testGetForEmptyMap();
}

public void testGetNull() throws Exception {
  com.google.common.collect.ForwardingSortedMapImplementsMapTest testCase = new com.google.common.collect.ForwardingSortedMapImplementsMapTest();
  testCase.testGetNull();
}

public void testHashCode() throws Exception {
  com.google.common.collect.ForwardingSortedMapImplementsMapTest testCase = new com.google.common.collect.ForwardingSortedMapImplementsMapTest();
  testCase.testHashCode();
}

public void testHashCodeForEmptyMap() throws Exception {
  com.google.common.collect.ForwardingSortedMapImplementsMapTest testCase = new com.google.common.collect.ForwardingSortedMapImplementsMapTest();
  testCase.testHashCodeForEmptyMap();
}

public void testKeySetClear() throws Exception {
  com.google.common.collect.ForwardingSortedMapImplementsMapTest testCase = new com.google.common.collect.ForwardingSortedMapImplementsMapTest();
  testCase.testKeySetClear();
}

public void testKeySetRemove() throws Exception {
  com.google.common.collect.ForwardingSortedMapImplementsMapTest testCase = new com.google.common.collect.ForwardingSortedMapImplementsMapTest();
  testCase.testKeySetRemove();
}

public void testKeySetRemoveAll() throws Exception {
  com.google.common.collect.ForwardingSortedMapImplementsMapTest testCase = new com.google.common.collect.ForwardingSortedMapImplementsMapTest();
  testCase.testKeySetRemoveAll();
}

public void testKeySetRemoveAllNullFromEmpty() throws Exception {
  com.google.common.collect.ForwardingSortedMapImplementsMapTest testCase = new com.google.common.collect.ForwardingSortedMapImplementsMapTest();
  testCase.testKeySetRemoveAllNullFromEmpty();
}

public void testKeySetRetainAll() throws Exception {
  com.google.common.collect.ForwardingSortedMapImplementsMapTest testCase = new com.google.common.collect.ForwardingSortedMapImplementsMapTest();
  testCase.testKeySetRetainAll();
}

public void testKeySetRetainAllNullFromEmpty() throws Exception {
  com.google.common.collect.ForwardingSortedMapImplementsMapTest testCase = new com.google.common.collect.ForwardingSortedMapImplementsMapTest();
  testCase.testKeySetRetainAllNullFromEmpty();
}

public void testPutAllExistingKey() throws Exception {
  com.google.common.collect.ForwardingSortedMapImplementsMapTest testCase = new com.google.common.collect.ForwardingSortedMapImplementsMapTest();
  testCase.testPutAllExistingKey();
}

public void testPutAllNewKey() throws Exception {
  com.google.common.collect.ForwardingSortedMapImplementsMapTest testCase = new com.google.common.collect.ForwardingSortedMapImplementsMapTest();
  testCase.testPutAllNewKey();
}

public void testPutExistingKey() throws Exception {
  com.google.common.collect.ForwardingSortedMapImplementsMapTest testCase = new com.google.common.collect.ForwardingSortedMapImplementsMapTest();
  testCase.testPutExistingKey();
}

public void testPutNewKey() throws Exception {
  com.google.common.collect.ForwardingSortedMapImplementsMapTest testCase = new com.google.common.collect.ForwardingSortedMapImplementsMapTest();
  testCase.testPutNewKey();
}

public void testPutNullKey() throws Exception {
  com.google.common.collect.ForwardingSortedMapImplementsMapTest testCase = new com.google.common.collect.ForwardingSortedMapImplementsMapTest();
  testCase.testPutNullKey();
}

public void testPutNullValue() throws Exception {
  com.google.common.collect.ForwardingSortedMapImplementsMapTest testCase = new com.google.common.collect.ForwardingSortedMapImplementsMapTest();
  testCase.testPutNullValue();
}

public void testPutNullValueForExistingKey() throws Exception {
  com.google.common.collect.ForwardingSortedMapImplementsMapTest testCase = new com.google.common.collect.ForwardingSortedMapImplementsMapTest();
  testCase.testPutNullValueForExistingKey();
}

public void testRemove() throws Exception {
  com.google.common.collect.ForwardingSortedMapImplementsMapTest testCase = new com.google.common.collect.ForwardingSortedMapImplementsMapTest();
  testCase.testRemove();
}

public void testRemoveMissingKey() throws Exception {
  com.google.common.collect.ForwardingSortedMapImplementsMapTest testCase = new com.google.common.collect.ForwardingSortedMapImplementsMapTest();
  testCase.testRemoveMissingKey();
}

public void testSize() throws Exception {
  com.google.common.collect.ForwardingSortedMapImplementsMapTest testCase = new com.google.common.collect.ForwardingSortedMapImplementsMapTest();
  testCase.testSize();
}

public void testTailMapClearThrough() throws Exception {
  com.google.common.collect.ForwardingSortedMapImplementsMapTest testCase = new com.google.common.collect.ForwardingSortedMapImplementsMapTest();
  testCase.testTailMapClearThrough();
}

public void testTailMapRemoveThrough() throws Exception {
  com.google.common.collect.ForwardingSortedMapImplementsMapTest testCase = new com.google.common.collect.ForwardingSortedMapImplementsMapTest();
  testCase.testTailMapRemoveThrough();
}

public void testTailMapWriteThrough() throws Exception {
  com.google.common.collect.ForwardingSortedMapImplementsMapTest testCase = new com.google.common.collect.ForwardingSortedMapImplementsMapTest();
  testCase.testTailMapWriteThrough();
}

public void testValues() throws Exception {
  com.google.common.collect.ForwardingSortedMapImplementsMapTest testCase = new com.google.common.collect.ForwardingSortedMapImplementsMapTest();
  testCase.testValues();
}

public void testValuesClear() throws Exception {
  com.google.common.collect.ForwardingSortedMapImplementsMapTest testCase = new com.google.common.collect.ForwardingSortedMapImplementsMapTest();
  testCase.testValuesClear();
}

public void testValuesIteratorRemove() throws Exception {
  com.google.common.collect.ForwardingSortedMapImplementsMapTest testCase = new com.google.common.collect.ForwardingSortedMapImplementsMapTest();
  testCase.testValuesIteratorRemove();
}

public void testValuesRemove() throws Exception {
  com.google.common.collect.ForwardingSortedMapImplementsMapTest testCase = new com.google.common.collect.ForwardingSortedMapImplementsMapTest();
  testCase.testValuesRemove();
}

public void testValuesRemoveAll() throws Exception {
  com.google.common.collect.ForwardingSortedMapImplementsMapTest testCase = new com.google.common.collect.ForwardingSortedMapImplementsMapTest();
  testCase.testValuesRemoveAll();
}

public void testValuesRemoveAllNullFromEmpty() throws Exception {
  com.google.common.collect.ForwardingSortedMapImplementsMapTest testCase = new com.google.common.collect.ForwardingSortedMapImplementsMapTest();
  testCase.testValuesRemoveAllNullFromEmpty();
}

public void testValuesRemoveMissing() throws Exception {
  com.google.common.collect.ForwardingSortedMapImplementsMapTest testCase = new com.google.common.collect.ForwardingSortedMapImplementsMapTest();
  testCase.testValuesRemoveMissing();
}

public void testValuesRetainAll() throws Exception {
  com.google.common.collect.ForwardingSortedMapImplementsMapTest testCase = new com.google.common.collect.ForwardingSortedMapImplementsMapTest();
  testCase.testValuesRetainAll();
}

public void testValuesRetainAllNullFromEmpty() throws Exception {
  com.google.common.collect.ForwardingSortedMapImplementsMapTest testCase = new com.google.common.collect.ForwardingSortedMapImplementsMapTest();
  testCase.testValuesRetainAllNullFromEmpty();
}
}
