//
// Copyright (c) 2015-2022 MinIO, Inc.
//
// This file is part of MinIO Object Storage stack
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as
// published by the Free Software Foundation, either version 3 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.
//

// Code generated by "stringer -type=blockID -trimprefix=block"; DO NOT EDIT.

package estream

import "strconv"

func _() {
	// An "invalid array index" compiler error signifies that the constant values have changed.
	// Re-run the stringer command to generate them again.
	var x [1]struct{}
	_ = x[blockPlainKey-1]
	_ = x[blockEncryptedKey-2]
	_ = x[blockEncStream-3]
	_ = x[blockPlainStream-4]
	_ = x[blockDatablock-5]
	_ = x[blockEOS-6]
	_ = x[blockEOF-7]
	_ = x[blockError-8]
}

const _blockID_name = "PlainKeyEncryptedKeyEncStreamPlainStreamDatablockEOSEOFError"

var _blockID_index = [...]uint8{0, 8, 20, 29, 40, 49, 52, 55, 60}

func (i blockID) String() string {
	i -= 1
	if i < 0 || i >= blockID(len(_blockID_index)-1) {
		return "blockID(" + strconv.FormatInt(int64(i+1), 10) + ")"
	}
	return _blockID_name[_blockID_index[i]:_blockID_index[i+1]]
}
