// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: quota/quota.proto

/*
	Package quota is a generated protocol buffer package.

	It is generated from these files:
		quota/quota.proto

	It has these top-level messages:
		QuotaInfo
		QuotaRequest
		QuotaStatus
*/
package quota

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import mesos "github.com/mesos/mesos-go/api/v1/lib"
import _ "github.com/gogo/protobuf/gogoproto"

import strings "strings"
import reflect "reflect"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

// TODO(joerg84): Add limits, i.e. upper bounds of resources that a
// role is allowed to use.
type QuotaInfo struct {
	// Quota is granted per role and not per framework, similar to
	// dynamic reservations.
	Role *string `protobuf:"bytes,1,opt,name=role" json:"role,omitempty"`
	// Principal which set the quota. Currently only operators can set quotas.
	Principal *string `protobuf:"bytes,2,opt,name=principal" json:"principal,omitempty"`
	// The guarantee that these resources are allocatable for the above role.
	// NOTE: `guarantee.role` should not specify any role except '*',
	// because quota does not reserve specific resources.
	Guarantee []mesos.Resource `protobuf:"bytes,3,rep,name=guarantee" json:"guarantee"`
}

func (m *QuotaInfo) Reset()                    { *m = QuotaInfo{} }
func (*QuotaInfo) ProtoMessage()               {}
func (*QuotaInfo) Descriptor() ([]byte, []int) { return fileDescriptorQuota, []int{0} }

func (m *QuotaInfo) GetRole() string {
	if m != nil && m.Role != nil {
		return *m.Role
	}
	return ""
}

func (m *QuotaInfo) GetPrincipal() string {
	if m != nil && m.Principal != nil {
		return *m.Principal
	}
	return ""
}

func (m *QuotaInfo) GetGuarantee() []mesos.Resource {
	if m != nil {
		return m.Guarantee
	}
	return nil
}

// *
// `QuotaRequest` provides a schema for set quota JSON requests.
type QuotaRequest struct {
	// Disables the capacity heuristic check if set to `true`.
	Force *bool `protobuf:"varint,1,opt,name=force,def=0" json:"force,omitempty"`
	// The role for which to set quota.
	Role *string `protobuf:"bytes,2,opt,name=role" json:"role,omitempty"`
	// The requested guarantee that these resources will be allocatable for
	// the above role.
	Guarantee []mesos.Resource `protobuf:"bytes,3,rep,name=guarantee" json:"guarantee"`
}

func (m *QuotaRequest) Reset()                    { *m = QuotaRequest{} }
func (*QuotaRequest) ProtoMessage()               {}
func (*QuotaRequest) Descriptor() ([]byte, []int) { return fileDescriptorQuota, []int{1} }

const Default_QuotaRequest_Force bool = false

func (m *QuotaRequest) GetForce() bool {
	if m != nil && m.Force != nil {
		return *m.Force
	}
	return Default_QuotaRequest_Force
}

func (m *QuotaRequest) GetRole() string {
	if m != nil && m.Role != nil {
		return *m.Role
	}
	return ""
}

func (m *QuotaRequest) GetGuarantee() []mesos.Resource {
	if m != nil {
		return m.Guarantee
	}
	return nil
}

// *
// `QuotaStatus` describes the internal representation for the /quota/status
// response.
type QuotaStatus struct {
	// Quotas which are currently set, i.e. known to the master.
	Infos []QuotaInfo `protobuf:"bytes,1,rep,name=infos" json:"infos"`
}

func (m *QuotaStatus) Reset()                    { *m = QuotaStatus{} }
func (*QuotaStatus) ProtoMessage()               {}
func (*QuotaStatus) Descriptor() ([]byte, []int) { return fileDescriptorQuota, []int{2} }

func (m *QuotaStatus) GetInfos() []QuotaInfo {
	if m != nil {
		return m.Infos
	}
	return nil
}

func init() {
	proto.RegisterType((*QuotaInfo)(nil), "mesos.quota.QuotaInfo")
	proto.RegisterType((*QuotaRequest)(nil), "mesos.quota.QuotaRequest")
	proto.RegisterType((*QuotaStatus)(nil), "mesos.quota.QuotaStatus")
}
func (this *QuotaInfo) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*QuotaInfo)
	if !ok {
		that2, ok := that.(QuotaInfo)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *QuotaInfo")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *QuotaInfo but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *QuotaInfo but is not nil && this == nil")
	}
	if this.Role != nil && that1.Role != nil {
		if *this.Role != *that1.Role {
			return fmt.Errorf("Role this(%v) Not Equal that(%v)", *this.Role, *that1.Role)
		}
	} else if this.Role != nil {
		return fmt.Errorf("this.Role == nil && that.Role != nil")
	} else if that1.Role != nil {
		return fmt.Errorf("Role this(%v) Not Equal that(%v)", this.Role, that1.Role)
	}
	if this.Principal != nil && that1.Principal != nil {
		if *this.Principal != *that1.Principal {
			return fmt.Errorf("Principal this(%v) Not Equal that(%v)", *this.Principal, *that1.Principal)
		}
	} else if this.Principal != nil {
		return fmt.Errorf("this.Principal == nil && that.Principal != nil")
	} else if that1.Principal != nil {
		return fmt.Errorf("Principal this(%v) Not Equal that(%v)", this.Principal, that1.Principal)
	}
	if len(this.Guarantee) != len(that1.Guarantee) {
		return fmt.Errorf("Guarantee this(%v) Not Equal that(%v)", len(this.Guarantee), len(that1.Guarantee))
	}
	for i := range this.Guarantee {
		if !this.Guarantee[i].Equal(&that1.Guarantee[i]) {
			return fmt.Errorf("Guarantee this[%v](%v) Not Equal that[%v](%v)", i, this.Guarantee[i], i, that1.Guarantee[i])
		}
	}
	return nil
}
func (this *QuotaInfo) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*QuotaInfo)
	if !ok {
		that2, ok := that.(QuotaInfo)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Role != nil && that1.Role != nil {
		if *this.Role != *that1.Role {
			return false
		}
	} else if this.Role != nil {
		return false
	} else if that1.Role != nil {
		return false
	}
	if this.Principal != nil && that1.Principal != nil {
		if *this.Principal != *that1.Principal {
			return false
		}
	} else if this.Principal != nil {
		return false
	} else if that1.Principal != nil {
		return false
	}
	if len(this.Guarantee) != len(that1.Guarantee) {
		return false
	}
	for i := range this.Guarantee {
		if !this.Guarantee[i].Equal(&that1.Guarantee[i]) {
			return false
		}
	}
	return true
}
func (this *QuotaRequest) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*QuotaRequest)
	if !ok {
		that2, ok := that.(QuotaRequest)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *QuotaRequest")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *QuotaRequest but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *QuotaRequest but is not nil && this == nil")
	}
	if this.Force != nil && that1.Force != nil {
		if *this.Force != *that1.Force {
			return fmt.Errorf("Force this(%v) Not Equal that(%v)", *this.Force, *that1.Force)
		}
	} else if this.Force != nil {
		return fmt.Errorf("this.Force == nil && that.Force != nil")
	} else if that1.Force != nil {
		return fmt.Errorf("Force this(%v) Not Equal that(%v)", this.Force, that1.Force)
	}
	if this.Role != nil && that1.Role != nil {
		if *this.Role != *that1.Role {
			return fmt.Errorf("Role this(%v) Not Equal that(%v)", *this.Role, *that1.Role)
		}
	} else if this.Role != nil {
		return fmt.Errorf("this.Role == nil && that.Role != nil")
	} else if that1.Role != nil {
		return fmt.Errorf("Role this(%v) Not Equal that(%v)", this.Role, that1.Role)
	}
	if len(this.Guarantee) != len(that1.Guarantee) {
		return fmt.Errorf("Guarantee this(%v) Not Equal that(%v)", len(this.Guarantee), len(that1.Guarantee))
	}
	for i := range this.Guarantee {
		if !this.Guarantee[i].Equal(&that1.Guarantee[i]) {
			return fmt.Errorf("Guarantee this[%v](%v) Not Equal that[%v](%v)", i, this.Guarantee[i], i, that1.Guarantee[i])
		}
	}
	return nil
}
func (this *QuotaRequest) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*QuotaRequest)
	if !ok {
		that2, ok := that.(QuotaRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Force != nil && that1.Force != nil {
		if *this.Force != *that1.Force {
			return false
		}
	} else if this.Force != nil {
		return false
	} else if that1.Force != nil {
		return false
	}
	if this.Role != nil && that1.Role != nil {
		if *this.Role != *that1.Role {
			return false
		}
	} else if this.Role != nil {
		return false
	} else if that1.Role != nil {
		return false
	}
	if len(this.Guarantee) != len(that1.Guarantee) {
		return false
	}
	for i := range this.Guarantee {
		if !this.Guarantee[i].Equal(&that1.Guarantee[i]) {
			return false
		}
	}
	return true
}
func (this *QuotaStatus) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*QuotaStatus)
	if !ok {
		that2, ok := that.(QuotaStatus)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *QuotaStatus")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *QuotaStatus but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *QuotaStatus but is not nil && this == nil")
	}
	if len(this.Infos) != len(that1.Infos) {
		return fmt.Errorf("Infos this(%v) Not Equal that(%v)", len(this.Infos), len(that1.Infos))
	}
	for i := range this.Infos {
		if !this.Infos[i].Equal(&that1.Infos[i]) {
			return fmt.Errorf("Infos this[%v](%v) Not Equal that[%v](%v)", i, this.Infos[i], i, that1.Infos[i])
		}
	}
	return nil
}
func (this *QuotaStatus) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*QuotaStatus)
	if !ok {
		that2, ok := that.(QuotaStatus)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if len(this.Infos) != len(that1.Infos) {
		return false
	}
	for i := range this.Infos {
		if !this.Infos[i].Equal(&that1.Infos[i]) {
			return false
		}
	}
	return true
}
func (this *QuotaInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&quota.QuotaInfo{")
	if this.Role != nil {
		s = append(s, "Role: "+valueToGoStringQuota(this.Role, "string")+",\n")
	}
	if this.Principal != nil {
		s = append(s, "Principal: "+valueToGoStringQuota(this.Principal, "string")+",\n")
	}
	if this.Guarantee != nil {
		s = append(s, "Guarantee: "+fmt.Sprintf("%#v", this.Guarantee)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *QuotaRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&quota.QuotaRequest{")
	if this.Force != nil {
		s = append(s, "Force: "+valueToGoStringQuota(this.Force, "bool")+",\n")
	}
	if this.Role != nil {
		s = append(s, "Role: "+valueToGoStringQuota(this.Role, "string")+",\n")
	}
	if this.Guarantee != nil {
		s = append(s, "Guarantee: "+fmt.Sprintf("%#v", this.Guarantee)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *QuotaStatus) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&quota.QuotaStatus{")
	if this.Infos != nil {
		s = append(s, "Infos: "+fmt.Sprintf("%#v", this.Infos)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func valueToGoStringQuota(v interface{}, typ string) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("func(v %v) *%v { return &v } ( %#v )", typ, typ, pv)
}
func (m *QuotaInfo) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *QuotaInfo) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Role != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintQuota(dAtA, i, uint64(len(*m.Role)))
		i += copy(dAtA[i:], *m.Role)
	}
	if m.Principal != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintQuota(dAtA, i, uint64(len(*m.Principal)))
		i += copy(dAtA[i:], *m.Principal)
	}
	if len(m.Guarantee) > 0 {
		for _, msg := range m.Guarantee {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintQuota(dAtA, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *QuotaRequest) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *QuotaRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Force != nil {
		dAtA[i] = 0x8
		i++
		if *m.Force {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.Role != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintQuota(dAtA, i, uint64(len(*m.Role)))
		i += copy(dAtA[i:], *m.Role)
	}
	if len(m.Guarantee) > 0 {
		for _, msg := range m.Guarantee {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintQuota(dAtA, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *QuotaStatus) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *QuotaStatus) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Infos) > 0 {
		for _, msg := range m.Infos {
			dAtA[i] = 0xa
			i++
			i = encodeVarintQuota(dAtA, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func encodeFixed64Quota(dAtA []byte, offset int, v uint64) int {
	dAtA[offset] = uint8(v)
	dAtA[offset+1] = uint8(v >> 8)
	dAtA[offset+2] = uint8(v >> 16)
	dAtA[offset+3] = uint8(v >> 24)
	dAtA[offset+4] = uint8(v >> 32)
	dAtA[offset+5] = uint8(v >> 40)
	dAtA[offset+6] = uint8(v >> 48)
	dAtA[offset+7] = uint8(v >> 56)
	return offset + 8
}
func encodeFixed32Quota(dAtA []byte, offset int, v uint32) int {
	dAtA[offset] = uint8(v)
	dAtA[offset+1] = uint8(v >> 8)
	dAtA[offset+2] = uint8(v >> 16)
	dAtA[offset+3] = uint8(v >> 24)
	return offset + 4
}
func encodeVarintQuota(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func NewPopulatedQuotaInfo(r randyQuota, easy bool) *QuotaInfo {
	this := &QuotaInfo{}
	if r.Intn(10) != 0 {
		v1 := string(randStringQuota(r))
		this.Role = &v1
	}
	if r.Intn(10) != 0 {
		v2 := string(randStringQuota(r))
		this.Principal = &v2
	}
	if r.Intn(10) != 0 {
		v3 := r.Intn(5)
		this.Guarantee = make([]mesos.Resource, v3)
		for i := 0; i < v3; i++ {
			v4 := mesos.NewPopulatedResource(r, easy)
			this.Guarantee[i] = *v4
		}
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedQuotaRequest(r randyQuota, easy bool) *QuotaRequest {
	this := &QuotaRequest{}
	if r.Intn(10) != 0 {
		v5 := bool(bool(r.Intn(2) == 0))
		this.Force = &v5
	}
	if r.Intn(10) != 0 {
		v6 := string(randStringQuota(r))
		this.Role = &v6
	}
	if r.Intn(10) != 0 {
		v7 := r.Intn(5)
		this.Guarantee = make([]mesos.Resource, v7)
		for i := 0; i < v7; i++ {
			v8 := mesos.NewPopulatedResource(r, easy)
			this.Guarantee[i] = *v8
		}
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedQuotaStatus(r randyQuota, easy bool) *QuotaStatus {
	this := &QuotaStatus{}
	if r.Intn(10) != 0 {
		v9 := r.Intn(5)
		this.Infos = make([]QuotaInfo, v9)
		for i := 0; i < v9; i++ {
			v10 := NewPopulatedQuotaInfo(r, easy)
			this.Infos[i] = *v10
		}
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

type randyQuota interface {
	Float32() float32
	Float64() float64
	Int63() int64
	Int31() int32
	Uint32() uint32
	Intn(n int) int
}

func randUTF8RuneQuota(r randyQuota) rune {
	ru := r.Intn(62)
	if ru < 10 {
		return rune(ru + 48)
	} else if ru < 36 {
		return rune(ru + 55)
	}
	return rune(ru + 61)
}
func randStringQuota(r randyQuota) string {
	v11 := r.Intn(100)
	tmps := make([]rune, v11)
	for i := 0; i < v11; i++ {
		tmps[i] = randUTF8RuneQuota(r)
	}
	return string(tmps)
}
func randUnrecognizedQuota(r randyQuota, maxFieldNumber int) (dAtA []byte) {
	l := r.Intn(5)
	for i := 0; i < l; i++ {
		wire := r.Intn(4)
		if wire == 3 {
			wire = 5
		}
		fieldNumber := maxFieldNumber + r.Intn(100)
		dAtA = randFieldQuota(dAtA, r, fieldNumber, wire)
	}
	return dAtA
}
func randFieldQuota(dAtA []byte, r randyQuota, fieldNumber int, wire int) []byte {
	key := uint32(fieldNumber)<<3 | uint32(wire)
	switch wire {
	case 0:
		dAtA = encodeVarintPopulateQuota(dAtA, uint64(key))
		v12 := r.Int63()
		if r.Intn(2) == 0 {
			v12 *= -1
		}
		dAtA = encodeVarintPopulateQuota(dAtA, uint64(v12))
	case 1:
		dAtA = encodeVarintPopulateQuota(dAtA, uint64(key))
		dAtA = append(dAtA, byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)))
	case 2:
		dAtA = encodeVarintPopulateQuota(dAtA, uint64(key))
		ll := r.Intn(100)
		dAtA = encodeVarintPopulateQuota(dAtA, uint64(ll))
		for j := 0; j < ll; j++ {
			dAtA = append(dAtA, byte(r.Intn(256)))
		}
	default:
		dAtA = encodeVarintPopulateQuota(dAtA, uint64(key))
		dAtA = append(dAtA, byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)))
	}
	return dAtA
}
func encodeVarintPopulateQuota(dAtA []byte, v uint64) []byte {
	for v >= 1<<7 {
		dAtA = append(dAtA, uint8(uint64(v)&0x7f|0x80))
		v >>= 7
	}
	dAtA = append(dAtA, uint8(v))
	return dAtA
}
func (m *QuotaInfo) ProtoSize() (n int) {
	var l int
	_ = l
	if m.Role != nil {
		l = len(*m.Role)
		n += 1 + l + sovQuota(uint64(l))
	}
	if m.Principal != nil {
		l = len(*m.Principal)
		n += 1 + l + sovQuota(uint64(l))
	}
	if len(m.Guarantee) > 0 {
		for _, e := range m.Guarantee {
			l = e.ProtoSize()
			n += 1 + l + sovQuota(uint64(l))
		}
	}
	return n
}

func (m *QuotaRequest) ProtoSize() (n int) {
	var l int
	_ = l
	if m.Force != nil {
		n += 2
	}
	if m.Role != nil {
		l = len(*m.Role)
		n += 1 + l + sovQuota(uint64(l))
	}
	if len(m.Guarantee) > 0 {
		for _, e := range m.Guarantee {
			l = e.ProtoSize()
			n += 1 + l + sovQuota(uint64(l))
		}
	}
	return n
}

func (m *QuotaStatus) ProtoSize() (n int) {
	var l int
	_ = l
	if len(m.Infos) > 0 {
		for _, e := range m.Infos {
			l = e.ProtoSize()
			n += 1 + l + sovQuota(uint64(l))
		}
	}
	return n
}

func sovQuota(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozQuota(x uint64) (n int) {
	return sovQuota(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *QuotaInfo) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&QuotaInfo{`,
		`Role:` + valueToStringQuota(this.Role) + `,`,
		`Principal:` + valueToStringQuota(this.Principal) + `,`,
		`Guarantee:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.Guarantee), "Resource", "mesos.Resource", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *QuotaRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&QuotaRequest{`,
		`Force:` + valueToStringQuota(this.Force) + `,`,
		`Role:` + valueToStringQuota(this.Role) + `,`,
		`Guarantee:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.Guarantee), "Resource", "mesos.Resource", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *QuotaStatus) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&QuotaStatus{`,
		`Infos:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.Infos), "QuotaInfo", "QuotaInfo", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringQuota(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *QuotaInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQuota
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: QuotaInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: QuotaInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Role", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuota
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthQuota
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Role = &s
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Principal", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuota
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthQuota
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Principal = &s
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Guarantee", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuota
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQuota
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Guarantee = append(m.Guarantee, mesos.Resource{})
			if err := m.Guarantee[len(m.Guarantee)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipQuota(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthQuota
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *QuotaRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQuota
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: QuotaRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: QuotaRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Force", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuota
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.Force = &b
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Role", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuota
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthQuota
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Role = &s
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Guarantee", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuota
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQuota
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Guarantee = append(m.Guarantee, mesos.Resource{})
			if err := m.Guarantee[len(m.Guarantee)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipQuota(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthQuota
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *QuotaStatus) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQuota
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: QuotaStatus: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: QuotaStatus: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Infos", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuota
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQuota
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Infos = append(m.Infos, QuotaInfo{})
			if err := m.Infos[len(m.Infos)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipQuota(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthQuota
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipQuota(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowQuota
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowQuota
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowQuota
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthQuota
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowQuota
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipQuota(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthQuota = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowQuota   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("quota/quota.proto", fileDescriptorQuota) }

var fileDescriptorQuota = []byte{
	// 331 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x90, 0xbd, 0x4e, 0xeb, 0x40,
	0x10, 0x85, 0x3d, 0x49, 0x2c, 0x5d, 0x6f, 0xae, 0x84, 0x70, 0x81, 0xac, 0x80, 0x86, 0x28, 0x55,
	0x9a, 0xd8, 0x10, 0x3a, 0x3a, 0x42, 0x45, 0x89, 0xe9, 0xe8, 0x1c, 0x6b, 0x6d, 0x2c, 0x39, 0x5e,
	0x67, 0x7f, 0xa8, 0x79, 0x04, 0x1e, 0x81, 0x92, 0x47, 0xa0, 0xa4, 0x4c, 0x99, 0x92, 0x0a, 0xe1,
	0x4d, 0x43, 0x99, 0x92, 0x12, 0xb1, 0x8b, 0x92, 0xd4, 0x34, 0xab, 0x99, 0x6f, 0xe7, 0xcc, 0x39,
	0x1a, 0xb2, 0x3f, 0x57, 0x4c, 0x26, 0x91, 0x79, 0xc3, 0x9a, 0x33, 0xc9, 0xfc, 0xee, 0x8c, 0x0a,
	0x26, 0x42, 0x83, 0x7a, 0x27, 0x79, 0x21, 0xef, 0xd4, 0x34, 0x4c, 0xd9, 0x2c, 0x32, 0xdc, 0xbe,
	0xa3, 0x9c, 0x45, 0x49, 0x5d, 0x44, 0xf7, 0xa7, 0x51, 0x59, 0x4c, 0x2d, 0xb3, 0xf2, 0xde, 0x68,
	0x47, 0x91, 0xb3, 0x9c, 0x45, 0x06, 0x4f, 0x55, 0x66, 0x3a, 0xd3, 0x98, 0xca, 0x8e, 0x0f, 0x38,
	0xf1, 0xae, 0x7f, 0x9c, 0xae, 0xaa, 0x8c, 0xf9, 0x3e, 0xe9, 0x70, 0x56, 0xd2, 0x00, 0xfa, 0x30,
	0xf4, 0x62, 0x53, 0xfb, 0x47, 0xc4, 0xab, 0x79, 0x51, 0xa5, 0x45, 0x9d, 0x94, 0x41, 0xcb, 0x7c,
	0x6c, 0x81, 0x7f, 0x46, 0xbc, 0x5c, 0x25, 0x3c, 0xa9, 0x24, 0xa5, 0x41, 0xbb, 0xdf, 0x1e, 0x76,
	0xc7, 0x7b, 0xa1, 0x8d, 0x13, 0x53, 0xc1, 0x14, 0x4f, 0xe9, 0xa4, 0xb3, 0x78, 0x3f, 0x76, 0xe2,
	0xed, 0xdc, 0x40, 0x92, 0xff, 0xc6, 0x33, 0xa6, 0x73, 0x45, 0x85, 0xf4, 0x0f, 0x89, 0x9b, 0x31,
	0x9e, 0x5a, 0xdf, 0x7f, 0xe7, 0x6e, 0x96, 0x94, 0x82, 0xc6, 0x96, 0x6d, 0x32, 0xb5, 0x76, 0x32,
	0xfd, 0xc9, 0xf5, 0x82, 0x74, 0x8d, 0xeb, 0x8d, 0x4c, 0xa4, 0x12, 0xfe, 0x98, 0xb8, 0x45, 0x95,
	0x31, 0x11, 0x80, 0xd1, 0x1f, 0x84, 0x3b, 0x67, 0x0f, 0x37, 0x27, 0xf9, 0x5d, 0x63, 0x47, 0x27,
	0x97, 0xcb, 0x06, 0x9d, 0xb7, 0x06, 0x9d, 0x8f, 0x06, 0x61, 0xdd, 0x20, 0x7c, 0x35, 0x08, 0x0f,
	0x1a, 0xe1, 0x59, 0x23, 0xbc, 0x68, 0x84, 0x57, 0x8d, 0xb0, 0xd0, 0x08, 0x4b, 0x8d, 0xf0, 0xa9,
	0xd1, 0x59, 0x6b, 0x84, 0xc7, 0x15, 0x3a, 0x4f, 0x2b, 0x84, 0x5b, 0xd7, 0xec, 0xfe, 0x0e, 0x00,
	0x00, 0xff, 0xff, 0xf0, 0x55, 0x30, 0x8e, 0xf3, 0x01, 0x00, 0x00,
}
