// Code generated by smithy-go-codegen DO NOT EDIT.

package macie2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/macie2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Changes the configuration settings and status of automated sensitive data
// discovery for an organization or standalone account.
func (c *Client) UpdateAutomatedDiscoveryConfiguration(ctx context.Context, params *UpdateAutomatedDiscoveryConfigurationInput, optFns ...func(*Options)) (*UpdateAutomatedDiscoveryConfigurationOutput, error) {
	if params == nil {
		params = &UpdateAutomatedDiscoveryConfigurationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateAutomatedDiscoveryConfiguration", params, optFns, c.addOperationUpdateAutomatedDiscoveryConfigurationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateAutomatedDiscoveryConfigurationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateAutomatedDiscoveryConfigurationInput struct {

	// The new status of automated sensitive data discovery for the organization or
	// account. Valid values are: ENABLED, start or resume all automated sensitive data
	// discovery activities; and, DISABLED, stop performing all automated sensitive
	// data discovery activities.
	//
	// If you specify DISABLED for an administrator account, you also disable
	// automated sensitive data discovery for all member accounts in the organization.
	//
	// This member is required.
	Status types.AutomatedDiscoveryStatus

	// Specifies whether to automatically enable automated sensitive data discovery
	// for accounts in the organization. Valid values are: ALL (default), enable it for
	// all existing accounts and new member accounts; NEW, enable it only for new
	// member accounts; and, NONE, don't enable it for any accounts.
	//
	// If you specify NEW or NONE, automated sensitive data discovery continues to be
	// enabled for any existing accounts that it's currently enabled for. To enable or
	// disable it for individual member accounts, specify NEW or NONE, and then enable
	// or disable it for each account by using the
	// BatchUpdateAutomatedDiscoveryAccounts operation.
	AutoEnableOrganizationMembers types.AutoEnableMode

	noSmithyDocumentSerde
}

type UpdateAutomatedDiscoveryConfigurationOutput struct {
	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateAutomatedDiscoveryConfigurationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdateAutomatedDiscoveryConfiguration{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdateAutomatedDiscoveryConfiguration{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateAutomatedDiscoveryConfiguration"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateAutomatedDiscoveryConfigurationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateAutomatedDiscoveryConfiguration(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateAutomatedDiscoveryConfiguration(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateAutomatedDiscoveryConfiguration",
	}
}
