// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	"fmt"
	smithy "github.com/aws/smithy-go"
)

// You aren't authorized to perform the action. Use the Amazon Resource Name (ARN)
// of an authorized user or IAM role to perform the operation.
type AccessDeniedException struct {
	Message *string

	Code *string

	noSmithyDocumentSerde
}

func (e *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *AccessDeniedException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *AccessDeniedException) ErrorCode() string             { return "AccessDeniedException" }
func (e *AccessDeniedException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Amazon Textract isn't able to read the document. For more information on the
// document limits in Amazon Textract, see limits.
type BadDocumentException struct {
	Message *string

	Code *string

	noSmithyDocumentSerde
}

func (e *BadDocumentException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *BadDocumentException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *BadDocumentException) ErrorCode() string             { return "BadDocumentException" }
func (e *BadDocumentException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The document can't be processed because it's too large. The maximum document
// size for synchronous operations 10 MB. The maximum document size for
// asynchronous operations is 500 MB for PDF files.
type DocumentTooLargeException struct {
	Message *string

	Code *string

	noSmithyDocumentSerde
}

func (e *DocumentTooLargeException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DocumentTooLargeException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DocumentTooLargeException) ErrorCode() string             { return "DocumentTooLargeException" }
func (e *DocumentTooLargeException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Indicates you have exceeded the maximum number of active human in the loop
// workflows available
type HumanLoopQuotaExceededException struct {
	Message *string

	ResourceType *string
	QuotaCode    *string
	ServiceCode  *string
	Code         *string

	noSmithyDocumentSerde
}

func (e *HumanLoopQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *HumanLoopQuotaExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *HumanLoopQuotaExceededException) ErrorCode() string {
	return "HumanLoopQuotaExceededException"
}
func (e *HumanLoopQuotaExceededException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// A ClientRequestToken input parameter was reused with an operation, but at least
// one of the other input parameters is different from the previous call to the
// operation.
type IdempotentParameterMismatchException struct {
	Message *string

	Code *string

	noSmithyDocumentSerde
}

func (e *IdempotentParameterMismatchException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *IdempotentParameterMismatchException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *IdempotentParameterMismatchException) ErrorCode() string {
	return "IdempotentParameterMismatchException"
}
func (e *IdempotentParameterMismatchException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// Amazon Textract experienced a service issue. Try your call again.
type InternalServerError struct {
	Message *string

	Code *string

	noSmithyDocumentSerde
}

func (e *InternalServerError) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InternalServerError) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InternalServerError) ErrorCode() string             { return "InternalServerError" }
func (e *InternalServerError) ErrorFault() smithy.ErrorFault { return smithy.FaultServer }

// An invalid job identifier was passed to GetDocumentAnalysis or to
// GetDocumentAnalysis.
type InvalidJobIdException struct {
	Message *string

	Code *string

	noSmithyDocumentSerde
}

func (e *InvalidJobIdException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidJobIdException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidJobIdException) ErrorCode() string             { return "InvalidJobIdException" }
func (e *InvalidJobIdException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Indicates you do not have decrypt permissions with the KMS key entered, or the
// KMS key was entered incorrectly.
type InvalidKMSKeyException struct {
	Message *string

	Code *string

	noSmithyDocumentSerde
}

func (e *InvalidKMSKeyException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidKMSKeyException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidKMSKeyException) ErrorCode() string             { return "InvalidKMSKeyException" }
func (e *InvalidKMSKeyException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// An input parameter violated a constraint. For example, in synchronous
// operations, an InvalidParameterException exception occurs when neither of the
// S3Object or Bytes values are supplied in the Document request parameter.
// Validate your parameter before calling the API operation again.
type InvalidParameterException struct {
	Message *string

	Code *string

	noSmithyDocumentSerde
}

func (e *InvalidParameterException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidParameterException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidParameterException) ErrorCode() string             { return "InvalidParameterException" }
func (e *InvalidParameterException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Amazon Textract is unable to access the S3 object that's specified in the
// request. for more information, Configure Access to Amazon S3
// (https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html) For
// troubleshooting information, see Troubleshooting Amazon S3
// (https://docs.aws.amazon.com/AmazonS3/latest/dev/troubleshooting.html)
type InvalidS3ObjectException struct {
	Message *string

	Code *string

	noSmithyDocumentSerde
}

func (e *InvalidS3ObjectException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidS3ObjectException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidS3ObjectException) ErrorCode() string             { return "InvalidS3ObjectException" }
func (e *InvalidS3ObjectException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// An Amazon Textract service limit was exceeded. For example, if you start too
// many asynchronous jobs concurrently, calls to start operations
// (StartDocumentTextDetection, for example) raise a LimitExceededException
// exception (HTTP status code: 400) until the number of concurrently running jobs
// is below the Amazon Textract service limit.
type LimitExceededException struct {
	Message *string

	Code *string

	noSmithyDocumentSerde
}

func (e *LimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *LimitExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *LimitExceededException) ErrorCode() string             { return "LimitExceededException" }
func (e *LimitExceededException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The number of requests exceeded your throughput limit. If you want to increase
// this limit, contact Amazon Textract.
type ProvisionedThroughputExceededException struct {
	Message *string

	Code *string

	noSmithyDocumentSerde
}

func (e *ProvisionedThroughputExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ProvisionedThroughputExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ProvisionedThroughputExceededException) ErrorCode() string {
	return "ProvisionedThroughputExceededException"
}
func (e *ProvisionedThroughputExceededException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// Amazon Textract is temporarily unable to process the request. Try your call
// again.
type ThrottlingException struct {
	Message *string

	Code *string

	noSmithyDocumentSerde
}

func (e *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ThrottlingException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ThrottlingException) ErrorCode() string             { return "ThrottlingException" }
func (e *ThrottlingException) ErrorFault() smithy.ErrorFault { return smithy.FaultServer }

// The format of the input document isn't supported. Documents for operations can
// be in PNG, JPEG, PDF, or TIFF format.
type UnsupportedDocumentException struct {
	Message *string

	Code *string

	noSmithyDocumentSerde
}

func (e *UnsupportedDocumentException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *UnsupportedDocumentException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *UnsupportedDocumentException) ErrorCode() string             { return "UnsupportedDocumentException" }
func (e *UnsupportedDocumentException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }
