/*****************************************************************
 * gmerlin - a general purpose multimedia framework and applications
 *
 * Copyright (c) 2001 - 2011 Members of the Gmerlin project
 * gmerlin-general@lists.sourceforge.net
 * http://gmerlin.sourceforge.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * *****************************************************************/

#include "nmjedit.h"
#include <gmerlin/utils.h>
#define LOG_DOMAIN "nmjedit.create"

#include <unistd.h>

static const char * create_commands[] =
  {
    "CREATE TABLE FAVOURITES (ID INTEGER PRIMARY KEY, TYPE TEXT, MEDIA_ID INTEGER, CUSTOM1 TEXT, CUSTOM2 TEXT, CUSTOM3 TEXT, CUSTOM4 TEXT, CUSTOM5 TEXT);",
    "CREATE TABLE DB_VERSION (ID INTEGER PRIMARY KEY, VERSION TEXT, CUSTOM1 TEXT, CUSTOM2 TEXT, CUSTOM3 TEXT, CUSTOM4 TEXT, CUSTOM5 TEXT)",
    "CREATE TABLE SCAN_DIRS (ID INTEGER PRIMARY KEY, DIRECTORY TEXT, NAME TEXT, SCAN_TIME TEXT, SIZE INTEGER, CATEGORY INTEGER, STATUS TEXT DEFAULT 0, SEQUENCE TEXT, CUSTOM1 TEXT, CUSTOM2 TEXT, CUSTOM3 TEXT, CUSTOM4 TEXT, CUSTOM5 TEXT);",
    "CREATE TABLE SCAN_SYSTEM (ID INTEGER PRIMARY KEY, TYPE TEXT, VALUE TEXT, CUSTOM1 TEXT, CUSTOM2 TEXT, CUSTOM3 TEXT, CUSTOM4 TEXT, CUSTOM5 TEXT);",
    "CREATE TABLE CONTENT_PROVIDERS ( ID INTEGER PRIMARY KEY, NAME TEXT, DESCRIPTION TEXT, CREATE_TIME TEXT, CUSTOM1 TEXT, CUSTOM2 TEXT, CUSTOM3 TEXT, CUSTOM4 TEXT, CUSTOM5 TEXT);",
    "CREATE TABLE SONGS (ID INTEGER PRIMARY KEY, TITLE TEXT, SEARCH_TITLE TEXT, PATH TEXT, SCAN_DIRS_ID INTEGER, FOLDERS_ID INTEGER, RUNTIME TEXT, FORMAT TEXT, LYRIC TEXT, RATING INTEGER DEFAULT 0, HASH TEXT, SIZE INTEGER, PLAY_COUNT INTEGER DEFAULT 0, BIT_RATE TEXT, TRACK_POSITION INTEGER, RELEASE_DATE TEXT DEFAULT '9999-01-01', CREATE_TIME TEXT, UPDATE_STATE TEXT, FILE_STATUS TEXT, CUSTOM1 TEXT, CUSTOM2 TEXT, CUSTOM3 TEXT, CUSTOM4 TEXT, CUSTOM5 TEXT);",
    "CREATE TABLE SONG_ALBUMS (ID INTEGER PRIMARY KEY, TITLE TEXT, LANGUAGE TEXT, SEARCH_TITLE TEXT, TOTAL_ITEM TEXT DEFAULT 0, RELEASE_DATE TEXT DEFAULT '9999-01-01', UPDATE_STATE TEXT, CUSTOM1 TEXT, CUSTOM2 TEXT, CUSTOM3 TEXT, CUSTOM4 TEXT, CUSTOM5 TEXT);",
    "CREATE TABLE SONG_ALBUMS_SONGS (ID INTEGER PRIMARY KEY, ALBUMS_ID INTEGER , SONGS_ID INTEGER, SEQUENCE INTEGER, CUSTOM1 TEXT, CUSTOM2 TEXT, CUSTOM3 TEXT, CUSTOM4 TEXT, CUSTOM5 TEXT);",
    "CREATE TABLE SONG_FOLDERS (ID INTEGER PRIMARY KEY, FOLDER TEXT, TOTAL_ITEM TEXT DEFAULT 0, PATH TEXT, CUSTOM1 TEXT, CUSTOM2 TEXT, CUSTOM3 TEXT, CUSTOM4 TEXT, CUSTOM5 TEXT);",
    "CREATE TABLE SONG_GENRES_SONGS (ID INTEGER PRIMARY KEY, SONGS_ID INTEGER, GENRES_ID INTEGER, CUSTOM1 TEXT, CUSTOM2 TEXT, CUSTOM3 TEXT, CUSTOM4 TEXT, CUSTOM5 TEXT);",
    "CREATE TABLE SONG_GENRES (ID INTEGER PRIMARY KEY, NAME TEXT, DESCRIPTION TEXT, CUSTOM1 TEXT, CUSTOM2 TEXT, CUSTOM3 TEXT, CUSTOM4 TEXT, CUSTOM5 TEXT);",
    "CREATE TABLE SONG_GENRES_SONG_ALBUMS (ID INTEGER PRIMARY KEY, ALBUMS_ID INTEGER, GENRES_ID INTEGER, CUSTOM1 TEXT, CUSTOM2 TEXT, CUSTOM3 TEXT, CUSTOM4 TEXT, CUSTOM5 TEXT);",
    "CREATE TABLE SONG_GROUPS_SONG_ALBUMS (ID INTEGER PRIMARY KEY, GROUPS_ID INTEGER, ALBUMS_ID INTEGER, CUSTOM1 TEXT, CUSTOM2 TEXT, CUSTOM3 TEXT, CUSTOM4 TEXT, CUSTOM5 TEXT);",
    "CREATE TABLE SONG_GROUPS (ID INTEGER PRIMARY KEY, NAME TEXT, LANGUAGE TEXT, CUSTOM1 TEXT, CUSTOM2 TEXT, CUSTOM3 TEXT, CUSTOM4 TEXT, CUSTOM5 TEXT);",
    "CREATE TABLE SONG_PLS (ID INTEGER PRIMARY KEY, NAME TEXT, PATH TEXT, FORMAT TEXT, SCAN_DIRS_ID INTEGER, SIZE INTEGER, TOTAL_ITEM TEXT DEFAULT 0, CREATE_TIME TEXT, UPDATE_STATE TEXT, CUSTOM1 TEXT, CUSTOM2 TEXT, CUSTOM3 TEXT, CUSTOM4 TEXT, CUSTOM5 TEXT);",
    "CREATE TABLE SONG_PLS_ITEM (ID INTEGER PRIMARY KEY, PLS_ID INTEGER , SONGS_ID INTEGER , SEQUENCE INTEGER, CUSTOM1 TEXT, CUSTOM2 TEXT, CUSTOM3 TEXT, CUSTOM4 TEXT, CUSTOM5 TEXT);",
    "CREATE TABLE SONG_LAST_OPEN (ID INTEGER PRIMARY KEY, SONGS_ID INTEGER , CREATE_TIME TEXT, CUSTOM1 TEXT, CUSTOM2 TEXT, CUSTOM3 TEXT, CUSTOM4 TEXT, CUSTOM5 TEXT);",
    "CREATE TABLE SONG_PERSONS_SONGS (ID INTEGER PRIMARY KEY, PERSONS_ID INTEGER, SONGS_ID INTEGER, PERSON_TYPE TEXT, CUSTOM1 TEXT, CUSTOM2 TEXT, CUSTOM3 TEXT, CUSTOM4 TEXT, CUSTOM5 TEXT);",
    "CREATE TABLE SONG_PERSONS_SONG_ALBUMS (ID INTEGER PRIMARY KEY, PERSONS_ID INTEGER , ALBUMS_ID INTEGER, PERSON_TYPE TEXT, CUSTOM1 TEXT, CUSTOM2 TEXT, CUSTOM3 TEXT, CUSTOM4 TEXT, CUSTOM5 TEXT);",
    "CREATE TABLE SONG_PERSONS (ID INTEGER PRIMARY KEY, NAME TEXT , POSTER TEXT, THUMBNAIL TEXT, BIOGRAPHY TEXT, CUSTOM1 TEXT, CUSTOM2 TEXT, CUSTOM3 TEXT, CUSTOM4 TEXT, CUSTOM5 TEXT);",
    "CREATE TABLE SONG_ALBUM_POSTERS (ID INTEGER PRIMARY KEY, POSTER TEXT, POSTER_HASH TEXT, THUMBNAIL TEXT, THUMBNAIL_HASH TEXT, TYPE TEXT, CREATE_TIME TEXT, MODIFY_TIME TEXT, CUSTOM1 TEXT, CUSTOM2 TEXT, CUSTOM3 TEXT, CUSTOM4 TEXT, CUSTOM5 TEXT);",
    "CREATE TABLE PHOTOS (ID INTEGER PRIMARY KEY, TITLE TEXT , SEARCH_TITLE TEXT , PATH TEXT, SCAN_DIRS_ID INTEGER, THUMBNAIL TEXT, PREVIEW TEXT, FORMAT TEXT, WIDTH TEXT, HEIGHT TEXT, CAPTURE_TIME TEXT DEFAULT '9999-01-01', F_NUMBER TEXT, SHUTTLE_SPEED TEXT, FOCAL_LENGTH TEXT, ISO_SPEED TEXT, FLASH TEXT, MODEL TEXT, SIZE INTEGER, CREATE_TIME TEXT, UPDATE_STATE TEXT, FILE_STATUS TEXT, CUSTOM1 TEXT, CUSTOM2 TEXT, CUSTOM3 TEXT, CUSTOM4 TEXT, CUSTOM5 TEXT);",
    "CREATE TABLE PHOTO_ALBUMS (ID INTEGER PRIMARY KEY, TITLE TEXT, SEARCH_TITLE TEXT, PATH TEXT, TOTAL_ITEM INTEGER, CREATE_TIME TEXT, CUSTOM1 TEXT, CUSTOM2 TEXT, CUSTOM3 TEXT, CUSTOM4 TEXT, CUSTOM5 TEXT);",
    "CREATE TABLE PHOTO_ALBUMS_PHOTOS (ID INTEGER PRIMARY KEY, PHOTO_ALBUMS_ID INTEGER , PHOTOS_ID INTEGER, SEQUENCE INTEGER, CUSTOM1 TEXT, CUSTOM2 TEXT, CUSTOM3 TEXT, CUSTOM4 TEXT, CUSTOM5 TEXT);",
    "CREATE TABLE PHOTO_DATE (ID INTEGER PRIMARY KEY, CAPTURE_TIME TEXT , TOTAL_ITEM INTEGER, CUSTOM1 TEXT, CUSTOM2 TEXT, CUSTOM3 TEXT, CUSTOM4 TEXT, CUSTOM5 TEXT);",
    "CREATE TABLE PHOTO_LAST_OPEN (ID INTEGER PRIMARY KEY, PHOTOS_ID INTEGER , CREATE_TIME TEXT, CUSTOM1 TEXT, CUSTOM2 TEXT, CUSTOM3 TEXT, CUSTOM4 TEXT, CUSTOM5 TEXT);",
    "CREATE TABLE VIDEOS (ID INTEGER PRIMARY KEY, PATH TEXT, FILE_TYPE TEXT, SCAN_DIRS_ID INTEGER, CREATE_TIME TEXT, UPDATE_STATE TEXT, FILE_STATUS TEXT, HASH TEXT, SIZE INTEGER, THREE_D INTEGER DEFAULT 0, RESOLUTION TEXT, PLAY_COUNT INTEGER DEFAULT 0, CUSTOM1 TEXT, CUSTOM2 TEXT, CUSTOM3 TEXT, CUSTOM4 TEXT, CUSTOM5 TEXT);",
    "CREATE TABLE SHOWS (ID INTEGER PRIMARY KEY, TITLE TEXT , SEARCH_TITLE TEXT , LAST_PLAY_ITEM TEXT, TOTAL_ITEM INTEGER DEFAULT 0, YEAR TEXT DEFAULT '9999', RELEASE_DATE TEXT DEFAULT '9999-01-01', POSTERS_ID INTEGER, RATING INTEGER DEFAULT 0, RESOLUTION TEXT, PARENTAL_CONTROL TEXT, RUNTIME INTEGER DEFAULT 0, CREATE_TIME TEXT, TTID TEXT, UPDATE_STATE TEXT, TITLE_TYPE TEXT, CONTENT_ID INTEGER, CONTENT_TTID INTEGER, THREE_D INTEGER DEFAULT 0, CUSTOM1 TEXT, CUSTOM2 TEXT, CUSTOM3 TEXT, CUSTOM4 TEXT, CUSTOM5 TEXT);",
    "CREATE TABLE VIDEO_SUBTITLES ( ID INTEGER PRIMARY KEY, VIDEOS_ID INTEGER, FILE_NAME TEXT , LANGUAGE TEXT, SIZE INTEGER, CREATE_TIME TEXT, TYPE TEXT, CUSTOM1 TEXT, CUSTOM2 TEXT, CUSTOM3 TEXT, CUSTOM4 TEXT, CUSTOM5 TEXT);",
    "CREATE TABLE SHOW_GROUPS_SHOWS ( ID INTEGER PRIMARY KEY, GROUPS_ID INTEGER , SHOWS_ID INTEGER, TITLE_TYPE TEXT, CUSTOM1 TEXT, CUSTOM2 TEXT, CUSTOM3 TEXT, CUSTOM4 TEXT, CUSTOM5 TEXT);",
    "CREATE TABLE SHOW_GROUPS (ID INTEGER PRIMARY KEY, NAME TEXT , GROUP_TYPE TEXT, LANGUAGE TEXT, CUSTOM1 TEXT, CUSTOM2 TEXT, CUSTOM3 TEXT, CUSTOM4 TEXT, CUSTOM5 TEXT);",
    "CREATE TABLE EPISODES ( ID INTEGER PRIMARY KEY, EPISODE_ID INTEGER, SERIES_ID INTEGER, SEASON_ID INTEGER, SEASON INTEGER, EPISODE INTEGER, CUSTOM1 TEXT, CUSTOM2 TEXT, CUSTOM3 TEXT, CUSTOM4 TEXT, CUSTOM5 TEXT);",
    "CREATE TABLE SYNOPSISES ( ID INTEGER PRIMARY KEY, SUMMARY TEXT, TAGLINE TEXT, CUSTOM1 TEXT, CUSTOM2 TEXT, CUSTOM3 TEXT, CUSTOM4 TEXT, CUSTOM5 TEXT);",
    "CREATE TABLE SHOWS_PERSONS ( ID INTEGER PRIMARY KEY, PERSONS_ID INTEGER, SHOWS_ID INTEGER, PERSON_TYPE TEXT, CUSTOM1 TEXT, CUSTOM2 TEXT, CUSTOM3 TEXT, CUSTOM4 TEXT, CUSTOM5 TEXT);",
    "CREATE TABLE VIDEO_PERSONS ( ID INTEGER PRIMARY KEY, NAME TEXT, POSTER TEXT, THUMBNAIL TEXT, BIOGRAPHY TEXT, CUSTOM1 TEXT, CUSTOM2 TEXT, CUSTOM3 TEXT, CUSTOM4 TEXT, CUSTOM5 TEXT);",
    "CREATE TABLE SHOWS_GENRES ( ID INTEGER PRIMARY KEY, GENRES_ID INTEGER , SHOWS_ID INTEGER, CUSTOM1 TEXT, CUSTOM2 TEXT, CUSTOM3 TEXT, CUSTOM4 TEXT, CUSTOM5 TEXT);",
    "CREATE TABLE VIDEO_GENRES ( ID INTEGER PRIMARY KEY, NAME TEXT , DESCRIPTION TEXT, CUSTOM1 TEXT, CUSTOM2 TEXT, CUSTOM3 TEXT, CUSTOM4 TEXT, CUSTOM5 TEXT);",
    "CREATE TABLE VIDEO_BOOKMARKS (ID INTEGER PRIMARY KEY, VIDEOS_ID INTEGER, TITLE TEXT, SEARCH_TITLE TEXT, BOOKMARK_TIME INTEGER, THUMBNAIL TEXT, TYPE TEXT, CUSTOM1 TEXT, CUSTOM2 TEXT, CUSTOM3 TEXT, CUSTOM4 TEXT, CUSTOM5 TEXT);",
    "CREATE TABLE VIDEO_POSTERS ( ID INTEGER PRIMARY KEY, POSTER TEXT , POSTER_HASH TEXT, THUMBNAIL TEXT, THUMBNAIL_HASH TEXT, WALLPAPER TEXT, TYPE TEXT, CREATE_TIME TEXT, MODIFY_TIME TEXT, CUSTOM1 TEXT, CUSTOM2 TEXT, CUSTOM3 TEXT, CUSTOM4 TEXT, CUSTOM5 TEXT);",
    "CREATE TABLE TV_LAST_OPEN (ID INTEGER PRIMARY KEY, VIDEOS_ID INTEGER, CREATE_TIME TEXT, CUSTOM1 TEXT, CUSTOM2 TEXT, CUSTOM3 TEXT, CUSTOM4 TEXT, CUSTOM5 TEXT);",
    "CREATE TABLE MOVIE_LAST_OPEN (ID INTEGER PRIMARY KEY, VIDEOS_ID INTEGER, CREATE_TIME TEXT, CUSTOM1 TEXT, CUSTOM2 TEXT, CUSTOM3 TEXT, CUSTOM4 TEXT, CUSTOM5 TEXT);",
    "CREATE TABLE KEYWORDS (ID INTEGER PRIMARY KEY, KEYWORD TEXT, DESCRIPTION TEXT, CUSTOM1 TEXT, CUSTOM2 TEXT, CUSTOM3 TEXT, CUSTOM4 TEXT, CUSTOM5 TEXT);",
    "CREATE TABLE SHOWS_KEYWORDS ( ID INTEGER PRIMARY KEY, KEYWORDS_ID INTEGER , SHOWS_ID INTEGER, CUSTOM1 TEXT, CUSTOM2 TEXT, CUSTOM3 TEXT, CUSTOM4 TEXT, CUSTOM5 TEXT);",
    "CREATE TABLE SHOWS_VIDEOS ( ID INTEGER PRIMARY KEY, SHOWS_ID INTEGER , VIDEOS_ID INTEGER, CUSTOM1 TEXT, CUSTOM2 TEXT, CUSTOM3 TEXT, CUSTOM4 TEXT, CUSTOM5 TEXT);",
    "CREATE TABLE VIDEO_PROPERTIES (ID INTEGER PRIMARY KEY, RUNTIME INTEGER DEFAULT 0, RESOLUTION TEXT, WIDTH TEXT, HEIGHT TEXT, ASPECT_RATIO TEXT, SYSTEM TEXT, VIDEO_CODEC TEXT, FPS TEXT, CUSTOM1 TEXT, CUSTOM2 TEXT, CUSTOM3 TEXT, CUSTOM4 TEXT, CUSTOM5 TEXT);",
    "CREATE INDEX IDX_VIDEOS_SCAN_DIRS_ID ON VIDEOS(SCAN_DIRS_ID ASC)",
    "CREATE INDEX IDX_SONGS_SCAN_DIRS_ID ON SONGS(SCAN_DIRS_ID ASC)",
    "CREATE INDEX IDX_PHOTOS_SCAN_DIRS_ID ON PHOTOS(SCAN_DIRS_ID ASC)",
    "CREATE INDEX IDX_SHOWS_CONTENT_TTID ON SHOWS(CONTENT_TTID ASC)",
    "CREATE INDEX IDX_SHOWS_TITLE ON SHOWS(TITLE ASC)",
    "CREATE INDEX IDX_SHOWS_SEARCH_TITLE ON SHOWS(SEARCH_TITLE ASC)",
    "CREATE INDEX IDX_SHOWS_YEAR ON SHOWS(YEAR ASC)",
    "CREATE INDEX IDX_SHOWS_RATING ON SHOWS(RATING ASC)",
    "CREATE INDEX IDX_SHOWS_PARENTAL_CONTROL ON SHOWS(PARENTAL_CONTROL ASC)",
    "CREATE INDEX IDX_VIDEO_SUBTITLES_VIDEOS_ID ON VIDEO_SUBTITLES(VIDEOS_ID ASC)",
    "CREATE INDEX IDX_SONGS_TITLE ON SONGS(TITLE ASC)",
    "CREATE INDEX IDX_SONGS_SEARCH_TITLE ON SONGS(SEARCH_TITLE ASC)",
    "CREATE INDEX IDX_SONGS_RATING ON SONGS(RATING ASC)",
    "CREATE INDEX IDX_SONGS_RELEASE_DATE ON SONGS(RELEASE_DATE ASC)",
    "CREATE INDEX IDX_SONG_ALBUMS_TITLE ON SONG_ALBUMS(TITLE ASC)",
    "CREATE INDEX IDX_SONG_ALBUMS_SEARCH_TITLE ON SONG_ALBUMS(SEARCH_TITLE ASC)",
    "CREATE INDEX IDX_SONG_ALBUMS_RELEASE_DATE ON SONG_ALBUMS(RELEASE_DATE ASC)",
    "CREATE INDEX IDX_SONG_ALBUM_SONGS_ALBUMS_ID ON SONG_ALBUMS_SONGS(ALBUMS_ID ASC)",
    "CREATE INDEX IDX_SONG_ALBUM_SONGS_SONGS_ID ON SONG_ALBUMS_SONGS(SONGS_ID ASC)",
    "CREATE INDEX IDX_SONG_GENRES_SONGS_GENRES_ID ON SONG_GENRES_SONGS(GENRES_ID ASC)",
    "CREATE INDEX IDX_SONG_GENRES_SONGS_SONGS_ID ON SONG_GENRES_SONGS(SONGS_ID ASC)",
    "CREATE INDEX IDX_SONG_GENRES_SONG_ALBUMS_ALBUMS_ID ON SONG_GENRES_SONG_ALBUMS(ALBUMS_ID ASC)",
    "CREATE INDEX IDX_SONG_GENRES_SONG_ALBUMS_GENRES_ID ON SONG_GENRES_SONG_ALBUMS(GENRES_ID ASC)",
    "CREATE INDEX IDX_SONG_GROUPS_SONG_ALBUMS_GROUPS_ID ON SONG_GROUPS_SONG_ALBUMS(GROUPS_ID ASC)",
    "CREATE INDEX IDX_SONG_GROUPS_SONG_ALBUMS_ALBUMS_ID ON SONG_GROUPS_SONG_ALBUMS(ALBUMS_ID ASC)",
    "CREATE INDEX IDX_SONG_PERSONS_SONGS_PERSONS_ID ON SONG_PERSONS_SONGS(PERSONS_ID ASC)",
    "CREATE INDEX IDX_SONG_PERSONS_SONGS_SONGS_ID ON SONG_PERSONS_SONGS(SONGS_ID ASC)",
    "CREATE INDEX IDX_SONG_PERSONS_SONG_ALBUMS_PERSONS_ID ON SONG_PERSONS_SONG_ALBUMS(PERSONS_ID ASC)",
    "CREATE INDEX IDX_SONG_PERSONS_SONG_ALBUMS_ALBUMS_ID ON SONG_PERSONS_SONG_ALBUMS(ALBUMS_ID ASC)",
    "CREATE INDEX IDX_PHOTOS_TITLE ON PHOTOS(TITLE ASC)",
    "CREATE INDEX IDX_PHOTOS_SEARCH_TITLE ON PHOTOS(SEARCH_TITLE ASC)",
    "CREATE INDEX IDX_PHOTO_DATE_CAPTURE_TIME ON PHOTO_DATE(CAPTURE_TIME ASC)",
    "CREATE INDEX IDX_PHOTO_ALBUMS_PHOTOS_PHOTO_ALBUMS_ID ON PHOTO_ALBUMS_PHOTOS(PHOTO_ALBUMS_ID ASC)",
    "CREATE INDEX IDX_PHOTO_ALBUMS_PHOTOS_PHOTOS_ID ON PHOTO_ALBUMS_PHOTOS(PHOTOS_ID ASC)",
    "CREATE UNIQUE INDEX UIDX_SHOWS_GENRES_GENRES_ID ON SHOWS_GENRES(SHOWS_ID ASC, GENRES_ID ASC)",
    "CREATE UNIQUE INDEX UIDX_SHOWS_PERSONS_PERSONS_ID ON SHOWS_PERSONS(PERSONS_ID ASC, SHOWS_ID ASC, PERSON_TYPE ASC)",
    "CREATE UNIQUE INDEX UIDX_EPISODES_ID ON EPISODES(EPISODE_ID ASC, SERIES_ID ASC, SEASON_ID ASC)",
    "CREATE UNIQUE INDEX UIDX_SONGS_PATH ON SONGS(PATH ASC)",
    "CREATE UNIQUE INDEX UIDX_PHOTOS_PATH ON PHOTOS(PATH ASC)",
    NULL,
  };

const char * directories[] =
  {
    "nmj_database",
    "nmj_database/media",
    "nmj_database/media/photo",
    "nmj_database/media/photo/preview",
    "nmj_database/media/photo/thumbnail",
    "nmj_database/media/video",
    "nmj_database/media/video/poster",
    "nmj_database/media/video/preview",
    "nmj_database/media/video/thumbnail",
    "nmj_database/media/music",
    "nmj_database/media/music/poster",
    "nmj_database/media/music/preview",
    "nmj_database/media/music/thumbnail",
    NULL,
  };

void bg_nmj_create_new()
  {
  int i;
  int result;
  sqlite3 * db;
  int64_t id;
  char * sql;
  
  if(!access("nmj_database", R_OK | W_OK))
    {
    fprintf(stderr, "Directory nmj_database already exists, delete it before recreating it\n");
    return;
    }
  
  i = 0;
  while(directories[i])
    {
    if(!bg_ensure_directory(directories[i]))
      return;
    i++;
    }

  /* Create database */

  result = sqlite3_open(DATABASE_FILE, &db);
  if(result)
    {
    fprintf(stderr, "Can't open database %s: %s\n",
            DATABASE_FILE, sqlite3_errmsg(db));
    sqlite3_close(db);
    return;
    }
  
  i = 0;
  while(create_commands[i])
    {
    if(!bg_sqlite_exec(db, create_commands[i], NULL, NULL))
      return;
    i++;
    }
  /* Set version number */
  if(!bg_sqlite_exec(db, "INSERT INTO DB_VERSION ( ID, VERSION ) VALUES ( 1, '"DATABASE_VERSION"' );",
                     NULL, NULL))
    return;

  /* Set SCAN_SYSTEM */
  if(!bg_sqlite_exec(db, "INSERT INTO SCAN_SYSTEM ( ID, TYPE, VALUE ) VALUES ( 1, 'RUNNING_STATUS', 0 );",
                     NULL, NULL))
    return;

  /* Create album groups */

  i = 0;
  while(bg_nmj_album_groups[i])
    {
    id = bg_nmj_get_next_id(db, "SONG_GROUPS");
    sql = sqlite3_mprintf("INSERT INTO SONG_GROUPS "
                          "( ID, NAME, LANGUAGE ) VALUES "
                          "( %"PRId64", %Q, 'EN' );",
                          id, bg_nmj_album_groups[i]);
    result = bg_sqlite_exec(db, sql, NULL, NULL);
    sqlite3_free(sql);
    if(!result)
      return;
    i++;
    }
  }
