=begin
#OpenBao API

#HTTP API that gives you full access to OpenBao. All API routes are prefixed with `/v1/`.

The version of the OpenAPI document: 2.0.0

Generated by: https://openapi-generator.tech
Generator version: 7.7.0

=end

require 'date'
require 'time'

module OpenbaoClient
  class PkiGenerateRootRequest
    # The requested Subject Alternative Names, if any, in a comma-delimited list. May contain both DNS names and email addresses.
    attr_accessor :alt_names

    # The requested common name; if you want more than one, specify the alternative names in the alt_names map. If not specified when signing, the common name will be taken from the CSR; other names must still be specified in alt_names or ip_sans.
    attr_accessor :common_name

    # If set, Country will be set to this value.
    attr_accessor :country

    # If true, the Common Name will not be included in DNS or Email Subject Alternate Names. Defaults to false (CN is included).
    attr_accessor :exclude_cn_from_sans

    # A comma-separated string or list of extended key usages. Valid values can be found at https://golang.org/pkg/crypto/x509/#ExtKeyUsage -- simply drop the \"ExtKeyUsage\" part of the name. To remove all key usages from being set, set this value to an empty list.
    attr_accessor :ext_key_usage

    # A comma-separated string or list of extended key usage oids.
    attr_accessor :ext_key_usage_oids

    # Format for returned data. Can be \"pem\", \"der\", or \"pem_bundle\". If \"pem_bundle\", any private key and issuing cert will be appended to the certificate pem. If \"der\", the value will be base64 encoded. Defaults to \"pem\".
    attr_accessor :format

    # The requested IP SANs, if any, in a comma-delimited list
    attr_accessor :ip_sans

    # Provide a name to the generated or existing issuer, the name must be unique across all issuers and not be the reserved value 'default'
    attr_accessor :issuer_name

    # The number of bits to use. Allowed values are 0 (universal default); with rsa key_type: 2048 (default), 3072, or 4096; with ec key_type: 224, 256 (default), 384, or 521; ignored with ed25519.
    attr_accessor :key_bits

    # Provide a name to the generated or existing key, the name must be unique across all keys and not be the reserved value 'default'
    attr_accessor :key_name

    # Reference to a existing key; either \"default\" for the configured default key, an identifier or the name assigned to the key.
    attr_accessor :key_ref

    # The type of key to use; defaults to RSA. \"rsa\" \"ec\" and \"ed25519\" are the only valid values.
    attr_accessor :key_type

    # A comma-separated string or list of key usages (not extended key usages). Valid values can be found at https://golang.org/pkg/crypto/x509/#KeyUsage -- simply drop the \"KeyUsage\" part of the name. To remove all key usages from being set, set this value to an empty list.
    attr_accessor :key_usage

    # If set, Locality will be set to this value.
    attr_accessor :locality

    # The maximum allowable path length
    attr_accessor :max_path_length

    # Set the not after field of the certificate with specified date value. The value format should be given in UTC format YYYY-MM-ddTHH:MM:SSZ
    attr_accessor :not_after

    # The duration before now which the certificate needs to be backdated by.
    attr_accessor :not_before_duration

    # If set, O (Organization) will be set to this value.
    attr_accessor :organization

    # Requested other SANs, in an array with the format <oid>;UTF8:<utf8 string value> for each entry.
    attr_accessor :other_sans

    # If set, OU (OrganizationalUnit) will be set to this value.
    attr_accessor :ou

    # Domains for which this certificate is allowed to sign or issue child certificates. If set, all DNS names (subject and alt) on child certs must be exact matches or subsets of the given domains (see https://tools.ietf.org/html/rfc5280#section-4.2.1.10).
    attr_accessor :permitted_dns_domains

    # If set, Postal Code will be set to this value.
    attr_accessor :postal_code

    # Format for the returned private key. Generally the default will be controlled by the \"format\" parameter as either base64-encoded DER or PEM-encoded DER. However, this can be set to \"pkcs8\" to have the returned private key contain base64-encoded pkcs8 or PEM-encoded pkcs8 instead. Defaults to \"der\".
    attr_accessor :private_key_format

    # If set, Province will be set to this value.
    attr_accessor :province

    # The Subject's requested serial number, if any. See RFC 4519 Section 2.31 'serialNumber' for a description of this field. If you want more than one, specify alternative names in the alt_names map using OID 2.5.4.5. This has no impact on the final certificate's Serial Number field.
    attr_accessor :serial_number

    # The number of bits to use in the signature algorithm; accepts 256 for SHA-2-256, 384 for SHA-2-384, and 512 for SHA-2-512. Defaults to 0 to automatically detect based on key length (SHA-2-256 for RSA keys, and matching the curve size for NIST P-Curves).
    attr_accessor :signature_bits

    # If set, Street Address will be set to this value.
    attr_accessor :street_address

    # The requested Time To Live for the certificate; sets the expiration date. If not specified the role default, backend default, or system default TTL is used, in that order. Cannot be larger than the mount max TTL. Note: this only has an effect when generating a CA cert or signing a CA cert, not when generating a CSR for an intermediate CA.
    attr_accessor :ttl

    # The requested URI SANs, if any, in a comma-delimited list.
    attr_accessor :uri_sans

    # Whether or not to use PSS signatures when using a RSA key-type issuer. Defaults to false.
    attr_accessor :use_pss

    class EnumAttributeValidator
      attr_reader :datatype
      attr_reader :allowable_values

      def initialize(datatype, allowable_values)
        @allowable_values = allowable_values.map do |value|
          case datatype.to_s
          when /Integer/i
            value.to_i
          when /Float/i
            value.to_f
          else
            value
          end
        end
      end

      def valid?(value)
        !value || allowable_values.include?(value)
      end
    end

    # Attribute mapping from ruby-style variable name to JSON key.
    def self.attribute_map
      {
        :'alt_names' => :'alt_names',
        :'common_name' => :'common_name',
        :'country' => :'country',
        :'exclude_cn_from_sans' => :'exclude_cn_from_sans',
        :'ext_key_usage' => :'ext_key_usage',
        :'ext_key_usage_oids' => :'ext_key_usage_oids',
        :'format' => :'format',
        :'ip_sans' => :'ip_sans',
        :'issuer_name' => :'issuer_name',
        :'key_bits' => :'key_bits',
        :'key_name' => :'key_name',
        :'key_ref' => :'key_ref',
        :'key_type' => :'key_type',
        :'key_usage' => :'key_usage',
        :'locality' => :'locality',
        :'max_path_length' => :'max_path_length',
        :'not_after' => :'not_after',
        :'not_before_duration' => :'not_before_duration',
        :'organization' => :'organization',
        :'other_sans' => :'other_sans',
        :'ou' => :'ou',
        :'permitted_dns_domains' => :'permitted_dns_domains',
        :'postal_code' => :'postal_code',
        :'private_key_format' => :'private_key_format',
        :'province' => :'province',
        :'serial_number' => :'serial_number',
        :'signature_bits' => :'signature_bits',
        :'street_address' => :'street_address',
        :'ttl' => :'ttl',
        :'uri_sans' => :'uri_sans',
        :'use_pss' => :'use_pss'
      }
    end

    # Returns all the JSON keys this model knows about
    def self.acceptable_attributes
      attribute_map.values
    end

    # Attribute type mapping.
    def self.openapi_types
      {
        :'alt_names' => :'String',
        :'common_name' => :'String',
        :'country' => :'Array<String>',
        :'exclude_cn_from_sans' => :'Boolean',
        :'ext_key_usage' => :'Array<String>',
        :'ext_key_usage_oids' => :'Array<String>',
        :'format' => :'String',
        :'ip_sans' => :'Array<String>',
        :'issuer_name' => :'String',
        :'key_bits' => :'Integer',
        :'key_name' => :'String',
        :'key_ref' => :'String',
        :'key_type' => :'String',
        :'key_usage' => :'Array<String>',
        :'locality' => :'Array<String>',
        :'max_path_length' => :'Integer',
        :'not_after' => :'String',
        :'not_before_duration' => :'Integer',
        :'organization' => :'Array<String>',
        :'other_sans' => :'Array<String>',
        :'ou' => :'Array<String>',
        :'permitted_dns_domains' => :'Array<String>',
        :'postal_code' => :'Array<String>',
        :'private_key_format' => :'String',
        :'province' => :'Array<String>',
        :'serial_number' => :'String',
        :'signature_bits' => :'Integer',
        :'street_address' => :'Array<String>',
        :'ttl' => :'Integer',
        :'uri_sans' => :'Array<String>',
        :'use_pss' => :'Boolean'
      }
    end

    # List of attributes with nullable: true
    def self.openapi_nullable
      Set.new([
      ])
    end

    # Initializes the object
    # @param [Hash] attributes Model attributes in the form of hash
    def initialize(attributes = {})
      if (!attributes.is_a?(Hash))
        fail ArgumentError, "The input argument (attributes) must be a hash in `OpenbaoClient::PkiGenerateRootRequest` initialize method"
      end

      # check to see if the attribute exists and convert string to symbol for hash key
      attributes = attributes.each_with_object({}) { |(k, v), h|
        if (!self.class.attribute_map.key?(k.to_sym))
          fail ArgumentError, "`#{k}` is not a valid attribute in `OpenbaoClient::PkiGenerateRootRequest`. Please check the name to make sure it's valid. List of attributes: " + self.class.attribute_map.keys.inspect
        end
        h[k.to_sym] = v
      }

      if attributes.key?(:'alt_names')
        self.alt_names = attributes[:'alt_names']
      end

      if attributes.key?(:'common_name')
        self.common_name = attributes[:'common_name']
      end

      if attributes.key?(:'country')
        if (value = attributes[:'country']).is_a?(Array)
          self.country = value
        end
      end

      if attributes.key?(:'exclude_cn_from_sans')
        self.exclude_cn_from_sans = attributes[:'exclude_cn_from_sans']
      else
        self.exclude_cn_from_sans = false
      end

      if attributes.key?(:'ext_key_usage')
        if (value = attributes[:'ext_key_usage']).is_a?(Array)
          self.ext_key_usage = value
        end
      end

      if attributes.key?(:'ext_key_usage_oids')
        if (value = attributes[:'ext_key_usage_oids']).is_a?(Array)
          self.ext_key_usage_oids = value
        end
      end

      if attributes.key?(:'format')
        self.format = attributes[:'format']
      else
        self.format = 'pem'
      end

      if attributes.key?(:'ip_sans')
        if (value = attributes[:'ip_sans']).is_a?(Array)
          self.ip_sans = value
        end
      end

      if attributes.key?(:'issuer_name')
        self.issuer_name = attributes[:'issuer_name']
      end

      if attributes.key?(:'key_bits')
        self.key_bits = attributes[:'key_bits']
      else
        self.key_bits = 0
      end

      if attributes.key?(:'key_name')
        self.key_name = attributes[:'key_name']
      end

      if attributes.key?(:'key_ref')
        self.key_ref = attributes[:'key_ref']
      else
        self.key_ref = 'default'
      end

      if attributes.key?(:'key_type')
        self.key_type = attributes[:'key_type']
      else
        self.key_type = 'rsa'
      end

      if attributes.key?(:'key_usage')
        if (value = attributes[:'key_usage']).is_a?(Array)
          self.key_usage = value
        end
      end

      if attributes.key?(:'locality')
        if (value = attributes[:'locality']).is_a?(Array)
          self.locality = value
        end
      end

      if attributes.key?(:'max_path_length')
        self.max_path_length = attributes[:'max_path_length']
      else
        self.max_path_length = -1
      end

      if attributes.key?(:'not_after')
        self.not_after = attributes[:'not_after']
      end

      if attributes.key?(:'not_before_duration')
        self.not_before_duration = attributes[:'not_before_duration']
      else
        self.not_before_duration = 30
      end

      if attributes.key?(:'organization')
        if (value = attributes[:'organization']).is_a?(Array)
          self.organization = value
        end
      end

      if attributes.key?(:'other_sans')
        if (value = attributes[:'other_sans']).is_a?(Array)
          self.other_sans = value
        end
      end

      if attributes.key?(:'ou')
        if (value = attributes[:'ou']).is_a?(Array)
          self.ou = value
        end
      end

      if attributes.key?(:'permitted_dns_domains')
        if (value = attributes[:'permitted_dns_domains']).is_a?(Array)
          self.permitted_dns_domains = value
        end
      end

      if attributes.key?(:'postal_code')
        if (value = attributes[:'postal_code']).is_a?(Array)
          self.postal_code = value
        end
      end

      if attributes.key?(:'private_key_format')
        self.private_key_format = attributes[:'private_key_format']
      else
        self.private_key_format = 'der'
      end

      if attributes.key?(:'province')
        if (value = attributes[:'province']).is_a?(Array)
          self.province = value
        end
      end

      if attributes.key?(:'serial_number')
        self.serial_number = attributes[:'serial_number']
      end

      if attributes.key?(:'signature_bits')
        self.signature_bits = attributes[:'signature_bits']
      else
        self.signature_bits = 0
      end

      if attributes.key?(:'street_address')
        if (value = attributes[:'street_address']).is_a?(Array)
          self.street_address = value
        end
      end

      if attributes.key?(:'ttl')
        self.ttl = attributes[:'ttl']
      end

      if attributes.key?(:'uri_sans')
        if (value = attributes[:'uri_sans']).is_a?(Array)
          self.uri_sans = value
        end
      end

      if attributes.key?(:'use_pss')
        self.use_pss = attributes[:'use_pss']
      else
        self.use_pss = false
      end
    end

    # Show invalid properties with the reasons. Usually used together with valid?
    # @return Array for valid properties with the reasons
    def list_invalid_properties
      warn '[DEPRECATED] the `list_invalid_properties` method is obsolete'
      invalid_properties = Array.new
      invalid_properties
    end

    # Check to see if the all the properties in the model are valid
    # @return true if the model is valid
    def valid?
      warn '[DEPRECATED] the `valid?` method is obsolete'
      format_validator = EnumAttributeValidator.new('String', ["pem", "der", "pem_bundle"])
      return false unless format_validator.valid?(@format)
      key_type_validator = EnumAttributeValidator.new('String', ["rsa", "ec", "ed25519"])
      return false unless key_type_validator.valid?(@key_type)
      private_key_format_validator = EnumAttributeValidator.new('String', ["", "der", "pem", "pkcs8"])
      return false unless private_key_format_validator.valid?(@private_key_format)
      true
    end

    # Custom attribute writer method checking allowed values (enum).
    # @param [Object] format Object to be assigned
    def format=(format)
      validator = EnumAttributeValidator.new('String', ["pem", "der", "pem_bundle"])
      unless validator.valid?(format)
        fail ArgumentError, "invalid value for \"format\", must be one of #{validator.allowable_values}."
      end
      @format = format
    end

    # Custom attribute writer method checking allowed values (enum).
    # @param [Object] key_type Object to be assigned
    def key_type=(key_type)
      validator = EnumAttributeValidator.new('String', ["rsa", "ec", "ed25519"])
      unless validator.valid?(key_type)
        fail ArgumentError, "invalid value for \"key_type\", must be one of #{validator.allowable_values}."
      end
      @key_type = key_type
    end

    # Custom attribute writer method checking allowed values (enum).
    # @param [Object] private_key_format Object to be assigned
    def private_key_format=(private_key_format)
      validator = EnumAttributeValidator.new('String', ["", "der", "pem", "pkcs8"])
      unless validator.valid?(private_key_format)
        fail ArgumentError, "invalid value for \"private_key_format\", must be one of #{validator.allowable_values}."
      end
      @private_key_format = private_key_format
    end

    # Checks equality by comparing each attribute.
    # @param [Object] Object to be compared
    def ==(o)
      return true if self.equal?(o)
      self.class == o.class &&
          alt_names == o.alt_names &&
          common_name == o.common_name &&
          country == o.country &&
          exclude_cn_from_sans == o.exclude_cn_from_sans &&
          ext_key_usage == o.ext_key_usage &&
          ext_key_usage_oids == o.ext_key_usage_oids &&
          format == o.format &&
          ip_sans == o.ip_sans &&
          issuer_name == o.issuer_name &&
          key_bits == o.key_bits &&
          key_name == o.key_name &&
          key_ref == o.key_ref &&
          key_type == o.key_type &&
          key_usage == o.key_usage &&
          locality == o.locality &&
          max_path_length == o.max_path_length &&
          not_after == o.not_after &&
          not_before_duration == o.not_before_duration &&
          organization == o.organization &&
          other_sans == o.other_sans &&
          ou == o.ou &&
          permitted_dns_domains == o.permitted_dns_domains &&
          postal_code == o.postal_code &&
          private_key_format == o.private_key_format &&
          province == o.province &&
          serial_number == o.serial_number &&
          signature_bits == o.signature_bits &&
          street_address == o.street_address &&
          ttl == o.ttl &&
          uri_sans == o.uri_sans &&
          use_pss == o.use_pss
    end

    # @see the `==` method
    # @param [Object] Object to be compared
    def eql?(o)
      self == o
    end

    # Calculates hash code according to all attributes.
    # @return [Integer] Hash code
    def hash
      [alt_names, common_name, country, exclude_cn_from_sans, ext_key_usage, ext_key_usage_oids, format, ip_sans, issuer_name, key_bits, key_name, key_ref, key_type, key_usage, locality, max_path_length, not_after, not_before_duration, organization, other_sans, ou, permitted_dns_domains, postal_code, private_key_format, province, serial_number, signature_bits, street_address, ttl, uri_sans, use_pss].hash
    end

    # Builds the object from hash
    # @param [Hash] attributes Model attributes in the form of hash
    # @return [Object] Returns the model itself
    def self.build_from_hash(attributes)
      return nil unless attributes.is_a?(Hash)
      attributes = attributes.transform_keys(&:to_sym)
      transformed_hash = {}
      openapi_types.each_pair do |key, type|
        if attributes.key?(attribute_map[key]) && attributes[attribute_map[key]].nil?
          transformed_hash["#{key}"] = nil
        elsif type =~ /\AArray<(.*)>/i
          # check to ensure the input is an array given that the attribute
          # is documented as an array but the input is not
          if attributes[attribute_map[key]].is_a?(Array)
            transformed_hash["#{key}"] = attributes[attribute_map[key]].map { |v| _deserialize($1, v) }
          end
        elsif !attributes[attribute_map[key]].nil?
          transformed_hash["#{key}"] = _deserialize(type, attributes[attribute_map[key]])
        end
      end
      new(transformed_hash)
    end

    # Deserializes the data based on type
    # @param string type Data type
    # @param string value Value to be deserialized
    # @return [Object] Deserialized data
    def self._deserialize(type, value)
      case type.to_sym
      when :Time
        Time.parse(value)
      when :Date
        Date.parse(value)
      when :String
        value.to_s
      when :Integer
        value.to_i
      when :Float
        value.to_f
      when :Boolean
        if value.to_s =~ /\A(true|t|yes|y|1)\z/i
          true
        else
          false
        end
      when :Object
        # generic object (usually a Hash), return directly
        value
      when /\AArray<(?<inner_type>.+)>\z/
        inner_type = Regexp.last_match[:inner_type]
        value.map { |v| _deserialize(inner_type, v) }
      when /\AHash<(?<k_type>.+?), (?<v_type>.+)>\z/
        k_type = Regexp.last_match[:k_type]
        v_type = Regexp.last_match[:v_type]
        {}.tap do |hash|
          value.each do |k, v|
            hash[_deserialize(k_type, k)] = _deserialize(v_type, v)
          end
        end
      else # model
        # models (e.g. Pet) or oneOf
        klass = OpenbaoClient.const_get(type)
        klass.respond_to?(:openapi_any_of) || klass.respond_to?(:openapi_one_of) ? klass.build(value) : klass.build_from_hash(value)
      end
    end

    # Returns the string representation of the object
    # @return [String] String presentation of the object
    def to_s
      to_hash.to_s
    end

    # to_body is an alias to to_hash (backward compatibility)
    # @return [Hash] Returns the object in the form of hash
    def to_body
      to_hash
    end

    # Returns the object in the form of hash
    # @return [Hash] Returns the object in the form of hash
    def to_hash
      hash = {}
      self.class.attribute_map.each_pair do |attr, param|
        value = self.send(attr)
        if value.nil?
          is_nullable = self.class.openapi_nullable.include?(attr)
          next if !is_nullable || (is_nullable && !instance_variable_defined?(:"@#{attr}"))
        end

        hash[param] = _to_hash(value)
      end
      hash
    end

    # Outputs non-array value in the form of hash
    # For object, use to_hash. Otherwise, just return the value
    # @param [Object] value Any valid value
    # @return [Hash] Returns the value in the form of hash
    def _to_hash(value)
      if value.is_a?(Array)
        value.compact.map { |v| _to_hash(v) }
      elsif value.is_a?(Hash)
        {}.tap do |hash|
          value.each { |k, v| hash[k] = _to_hash(v) }
        end
      elsif value.respond_to? :to_hash
        value.to_hash
      else
        value
      end
    end

  end

end
