//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armtrafficmanager

import "time"

// CheckTrafficManagerRelativeDNSNameAvailabilityParameters - Parameters supplied to check Traffic Manager name operation.
type CheckTrafficManagerRelativeDNSNameAvailabilityParameters struct {
	// The name of the resource.
	Name *string `json:"name,omitempty"`

	// The type of the resource.
	Type *string `json:"type,omitempty"`
}

// DNSConfig - Class containing DNS settings in a Traffic Manager profile.
type DNSConfig struct {
	// The relative DNS name provided by this Traffic Manager profile. This value is combined with the DNS domain name used by
	// Azure Traffic Manager to form the fully-qualified domain name (FQDN) of the
	// profile.
	RelativeName *string `json:"relativeName,omitempty"`

	// The DNS Time-To-Live (TTL), in seconds. This informs the local DNS resolvers and DNS clients how long to cache DNS responses
	// provided by this Traffic Manager profile.
	TTL *int64 `json:"ttl,omitempty"`

	// READ-ONLY; The fully-qualified domain name (FQDN) of the Traffic Manager profile. This is formed from the concatenation
	// of the RelativeName with the DNS domain used by Azure Traffic Manager.
	Fqdn *string `json:"fqdn,omitempty" azure:"ro"`
}

// DeleteOperationResult - The result of the request or operation.
type DeleteOperationResult struct {
	// READ-ONLY; The result of the operation or request.
	OperationResult *bool `json:"boolean,omitempty" azure:"ro"`
}

// Endpoint - Class representing a Traffic Manager endpoint.
type Endpoint struct {
	// Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{resourceName}
	ID *string `json:"id,omitempty"`

	// The name of the resource
	Name *string `json:"name,omitempty"`

	// The properties of the Traffic Manager endpoint.
	Properties *EndpointProperties `json:"properties,omitempty"`

	// The type of the resource. Ex- Microsoft.Network/trafficManagerProfiles.
	Type *string `json:"type,omitempty"`
}

// EndpointProperties - Class representing a Traffic Manager endpoint properties.
type EndpointProperties struct {
	// If Always Serve is enabled, probing for endpoint health will be disabled and endpoints will be included in the traffic
	// routing method.
	AlwaysServe *AlwaysServe `json:"alwaysServe,omitempty"`

	// List of custom headers.
	CustomHeaders []*EndpointPropertiesCustomHeadersItem `json:"customHeaders,omitempty"`

	// Specifies the location of the external or nested endpoints when using the 'Performance' traffic routing method.
	EndpointLocation *string `json:"endpointLocation,omitempty"`

	// The monitoring status of the endpoint.
	EndpointMonitorStatus *EndpointMonitorStatus `json:"endpointMonitorStatus,omitempty"`

	// The status of the endpoint. If the endpoint is Enabled, it is probed for endpoint health and is included in the traffic
	// routing method.
	EndpointStatus *EndpointStatus `json:"endpointStatus,omitempty"`

	// The list of countries/regions mapped to this endpoint when using the 'Geographic' traffic routing method. Please consult
	// Traffic Manager Geographic documentation for a full list of accepted values.
	GeoMapping []*string `json:"geoMapping,omitempty"`

	// The minimum number of endpoints that must be available in the child profile in order for the parent profile to be considered
	// available. Only applicable to endpoint of type 'NestedEndpoints'.
	MinChildEndpoints *int64 `json:"minChildEndpoints,omitempty"`

	// The minimum number of IPv4 (DNS record type A) endpoints that must be available in the child profile in order for the parent
	// profile to be considered available. Only applicable to endpoint of type
	// 'NestedEndpoints'.
	MinChildEndpointsIPv4 *int64 `json:"minChildEndpointsIPv4,omitempty"`

	// The minimum number of IPv6 (DNS record type AAAA) endpoints that must be available in the child profile in order for the
	// parent profile to be considered available. Only applicable to endpoint of type
	// 'NestedEndpoints'.
	MinChildEndpointsIPv6 *int64 `json:"minChildEndpointsIPv6,omitempty"`

	// The priority of this endpoint when using the 'Priority' traffic routing method. Possible values are from 1 to 1000, lower
	// values represent higher priority. This is an optional parameter. If specified,
	// it must be specified on all endpoints, and no two endpoints can share the same priority value.
	Priority *int64 `json:"priority,omitempty"`

	// The list of subnets, IP addresses, and/or address ranges mapped to this endpoint when using the 'Subnet' traffic routing
	// method. An empty list will match all ranges not covered by other endpoints.
	Subnets []*EndpointPropertiesSubnetsItem `json:"subnets,omitempty"`

	// The fully-qualified DNS name or IP address of the endpoint. Traffic Manager returns this value in DNS responses to direct
	// traffic to this endpoint.
	Target *string `json:"target,omitempty"`

	// The Azure Resource URI of the of the endpoint. Not applicable to endpoints of type 'ExternalEndpoints'.
	TargetResourceID *string `json:"targetResourceId,omitempty"`

	// The weight of this endpoint when using the 'Weighted' traffic routing method. Possible values are from 1 to 1000.
	Weight *int64 `json:"weight,omitempty"`
}

// EndpointPropertiesCustomHeadersItem - Custom header name and value.
type EndpointPropertiesCustomHeadersItem struct {
	// Header name.
	Name *string `json:"name,omitempty"`

	// Header value.
	Value *string `json:"value,omitempty"`
}

// EndpointPropertiesSubnetsItem - Subnet first address, scope, and/or last address.
type EndpointPropertiesSubnetsItem struct {
	// First address in the subnet.
	First *string `json:"first,omitempty"`

	// Last address in the subnet.
	Last *string `json:"last,omitempty"`

	// Block size (number of leading bits in the subnet mask).
	Scope *int32 `json:"scope,omitempty"`
}

// EndpointsClientCreateOrUpdateOptions contains the optional parameters for the EndpointsClient.CreateOrUpdate method.
type EndpointsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// EndpointsClientDeleteOptions contains the optional parameters for the EndpointsClient.Delete method.
type EndpointsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// EndpointsClientGetOptions contains the optional parameters for the EndpointsClient.Get method.
type EndpointsClientGetOptions struct {
	// placeholder for future optional parameters
}

// EndpointsClientUpdateOptions contains the optional parameters for the EndpointsClient.Update method.
type EndpointsClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// GeographicHierarchiesClientGetDefaultOptions contains the optional parameters for the GeographicHierarchiesClient.GetDefault
// method.
type GeographicHierarchiesClientGetDefaultOptions struct {
	// placeholder for future optional parameters
}

// GeographicHierarchy - Class representing the Geographic hierarchy used with the Geographic traffic routing method.
type GeographicHierarchy struct {
	// Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{resourceName}
	ID *string `json:"id,omitempty"`

	// The name of the resource
	Name *string `json:"name,omitempty"`

	// The properties of the Geographic Hierarchy resource.
	Properties *GeographicHierarchyProperties `json:"properties,omitempty"`

	// The type of the resource. Ex- Microsoft.Network/trafficManagerProfiles.
	Type *string `json:"type,omitempty"`
}

// GeographicHierarchyProperties - Class representing the properties of the Geographic hierarchy used with the Geographic
// traffic routing method.
type GeographicHierarchyProperties struct {
	// The region at the root of the hierarchy from all the regions in the hierarchy can be retrieved.
	GeographicHierarchy *Region `json:"geographicHierarchy,omitempty"`
}

// HeatMapClientGetOptions contains the optional parameters for the HeatMapClient.Get method.
type HeatMapClientGetOptions struct {
	// The bottom right latitude,longitude pair of the rectangular viewport to query for.
	BotRight []float64
	// The top left latitude,longitude pair of the rectangular viewport to query for.
	TopLeft []float64
}

// HeatMapEndpoint - Class which is a sparse representation of a Traffic Manager endpoint.
type HeatMapEndpoint struct {
	// A number uniquely identifying this endpoint in query experiences.
	EndpointID *int32 `json:"endpointId,omitempty"`

	// The ARM Resource ID of this Traffic Manager endpoint.
	ResourceID *string `json:"resourceId,omitempty"`
}

// HeatMapModel - Class representing a Traffic Manager HeatMap.
type HeatMapModel struct {
	// Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{resourceName}
	ID *string `json:"id,omitempty"`

	// The name of the resource
	Name *string `json:"name,omitempty"`

	// The properties of the Traffic Manager HeatMap.
	Properties *HeatMapProperties `json:"properties,omitempty"`

	// The type of the resource. Ex- Microsoft.Network/trafficManagerProfiles.
	Type *string `json:"type,omitempty"`
}

// HeatMapProperties - Class representing a Traffic Manager HeatMap properties.
type HeatMapProperties struct {
	// The ending of the time window for this HeatMap, exclusive.
	EndTime *time.Time `json:"endTime,omitempty"`

	// The endpoints used in this HeatMap calculation.
	Endpoints []*HeatMapEndpoint `json:"endpoints,omitempty"`

	// The beginning of the time window for this HeatMap, inclusive.
	StartTime *time.Time `json:"startTime,omitempty"`

	// The traffic flows produced in this HeatMap calculation.
	TrafficFlows []*TrafficFlow `json:"trafficFlows,omitempty"`
}

// MonitorConfig - Class containing endpoint monitoring settings in a Traffic Manager profile.
type MonitorConfig struct {
	// List of custom headers.
	CustomHeaders []*MonitorConfigCustomHeadersItem `json:"customHeaders,omitempty"`

	// List of expected status code ranges.
	ExpectedStatusCodeRanges []*MonitorConfigExpectedStatusCodeRangesItem `json:"expectedStatusCodeRanges,omitempty"`

	// The monitor interval for endpoints in this profile. This is the interval at which Traffic Manager will check the health
	// of each endpoint in this profile.
	IntervalInSeconds *int64 `json:"intervalInSeconds,omitempty"`

	// The path relative to the endpoint domain name used to probe for endpoint health.
	Path *string `json:"path,omitempty"`

	// The TCP port used to probe for endpoint health.
	Port *int64 `json:"port,omitempty"`

	// The profile-level monitoring status of the Traffic Manager profile.
	ProfileMonitorStatus *ProfileMonitorStatus `json:"profileMonitorStatus,omitempty"`

	// The protocol (HTTP, HTTPS or TCP) used to probe for endpoint health.
	Protocol *MonitorProtocol `json:"protocol,omitempty"`

	// The monitor timeout for endpoints in this profile. This is the time that Traffic Manager allows endpoints in this profile
	// to response to the health check.
	TimeoutInSeconds *int64 `json:"timeoutInSeconds,omitempty"`

	// The number of consecutive failed health check that Traffic Manager tolerates before declaring an endpoint in this profile
	// Degraded after the next failed health check.
	ToleratedNumberOfFailures *int64 `json:"toleratedNumberOfFailures,omitempty"`
}

// MonitorConfigCustomHeadersItem - Custom header name and value.
type MonitorConfigCustomHeadersItem struct {
	// Header name.
	Name *string `json:"name,omitempty"`

	// Header value.
	Value *string `json:"value,omitempty"`
}

// MonitorConfigExpectedStatusCodeRangesItem - Min and max value of a status code range.
type MonitorConfigExpectedStatusCodeRangesItem struct {
	// Max status code.
	Max *int32 `json:"max,omitempty"`

	// Min status code.
	Min *int32 `json:"min,omitempty"`
}

// NameAvailability - Class representing a Traffic Manager Name Availability response.
type NameAvailability struct {
	// Descriptive message that explains why the name is not available, when applicable.
	Message *string `json:"message,omitempty"`

	// The relative name.
	Name *string `json:"name,omitempty"`

	// Describes whether the relative name is available or not.
	NameAvailable *bool `json:"nameAvailable,omitempty"`

	// The reason why the name is not available, when applicable.
	Reason *string `json:"reason,omitempty"`

	// Traffic Manager profile resource type.
	Type *string `json:"type,omitempty"`
}

// Profile - Class representing a Traffic Manager profile.
type Profile struct {
	// Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{resourceName}
	ID *string `json:"id,omitempty"`

	// The Azure Region where the resource lives
	Location *string `json:"location,omitempty"`

	// The name of the resource
	Name *string `json:"name,omitempty"`

	// The properties of the Traffic Manager profile.
	Properties *ProfileProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// The type of the resource. Ex- Microsoft.Network/trafficManagerProfiles.
	Type *string `json:"type,omitempty"`
}

// ProfileListResult - The list Traffic Manager profiles operation response.
type ProfileListResult struct {
	// Gets the list of Traffic manager profiles.
	Value []*Profile `json:"value,omitempty"`
}

// ProfileProperties - Class representing the Traffic Manager profile properties.
type ProfileProperties struct {
	// The list of allowed endpoint record types.
	AllowedEndpointRecordTypes []*AllowedEndpointRecordType `json:"allowedEndpointRecordTypes,omitempty"`

	// The DNS settings of the Traffic Manager profile.
	DNSConfig *DNSConfig `json:"dnsConfig,omitempty"`

	// The list of endpoints in the Traffic Manager profile.
	Endpoints []*Endpoint `json:"endpoints,omitempty"`

	// Maximum number of endpoints to be returned for MultiValue routing type.
	MaxReturn *int64 `json:"maxReturn,omitempty"`

	// The endpoint monitoring settings of the Traffic Manager profile.
	MonitorConfig *MonitorConfig `json:"monitorConfig,omitempty"`

	// The status of the Traffic Manager profile.
	ProfileStatus *ProfileStatus `json:"profileStatus,omitempty"`

	// The traffic routing method of the Traffic Manager profile.
	TrafficRoutingMethod *TrafficRoutingMethod `json:"trafficRoutingMethod,omitempty"`

	// Indicates whether Traffic View is 'Enabled' or 'Disabled' for the Traffic Manager profile. Null, indicates 'Disabled'.
	// Enabling this feature will increase the cost of the Traffic Manage profile.
	TrafficViewEnrollmentStatus *TrafficViewEnrollmentStatus `json:"trafficViewEnrollmentStatus,omitempty"`
}

// ProfilesClientCheckTrafficManagerRelativeDNSNameAvailabilityOptions contains the optional parameters for the ProfilesClient.CheckTrafficManagerRelativeDNSNameAvailability
// method.
type ProfilesClientCheckTrafficManagerRelativeDNSNameAvailabilityOptions struct {
	// placeholder for future optional parameters
}

// ProfilesClientCreateOrUpdateOptions contains the optional parameters for the ProfilesClient.CreateOrUpdate method.
type ProfilesClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// ProfilesClientDeleteOptions contains the optional parameters for the ProfilesClient.Delete method.
type ProfilesClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ProfilesClientGetOptions contains the optional parameters for the ProfilesClient.Get method.
type ProfilesClientGetOptions struct {
	// placeholder for future optional parameters
}

// ProfilesClientListByResourceGroupOptions contains the optional parameters for the ProfilesClient.ListByResourceGroup method.
type ProfilesClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// ProfilesClientListBySubscriptionOptions contains the optional parameters for the ProfilesClient.ListBySubscription method.
type ProfilesClientListBySubscriptionOptions struct {
	// placeholder for future optional parameters
}

// ProfilesClientUpdateOptions contains the optional parameters for the ProfilesClient.Update method.
type ProfilesClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// ProxyResource - The resource model definition for a ARM proxy resource. It will have everything other than required location
// and tags
type ProxyResource struct {
	// Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{resourceName}
	ID *string `json:"id,omitempty"`

	// The name of the resource
	Name *string `json:"name,omitempty"`

	// The type of the resource. Ex- Microsoft.Network/trafficManagerProfiles.
	Type *string `json:"type,omitempty"`
}

// QueryExperience - Class representing a Traffic Manager HeatMap query experience properties.
type QueryExperience struct {
	// REQUIRED; The id of the endpoint from the 'endpoints' array which these queries were routed to.
	EndpointID *int32 `json:"endpointId,omitempty"`

	// REQUIRED; The number of queries originating from this location.
	QueryCount *int32 `json:"queryCount,omitempty"`

	// The latency experienced by queries originating from this location.
	Latency *float64 `json:"latency,omitempty"`
}

// Region - Class representing a region in the Geographic hierarchy used with the Geographic traffic routing method.
type Region struct {
	// The code of the region
	Code *string `json:"code,omitempty"`

	// The name of the region
	Name *string `json:"name,omitempty"`

	// The list of Regions grouped under this Region in the Geographic Hierarchy.
	Regions []*Region `json:"regions,omitempty"`
}

// Resource - The core properties of ARM resources
type Resource struct {
	// Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{resourceName}
	ID *string `json:"id,omitempty"`

	// The name of the resource
	Name *string `json:"name,omitempty"`

	// The type of the resource. Ex- Microsoft.Network/trafficManagerProfiles.
	Type *string `json:"type,omitempty"`
}

// TrackedResource - The resource model definition for a ARM tracked top level resource
type TrackedResource struct {
	// Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{resourceName}
	ID *string `json:"id,omitempty"`

	// The Azure Region where the resource lives
	Location *string `json:"location,omitempty"`

	// The name of the resource
	Name *string `json:"name,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// The type of the resource. Ex- Microsoft.Network/trafficManagerProfiles.
	Type *string `json:"type,omitempty"`
}

// TrafficFlow - Class representing a Traffic Manager HeatMap traffic flow properties.
type TrafficFlow struct {
	// The approximate latitude that these queries originated from.
	Latitude *float64 `json:"latitude,omitempty"`

	// The approximate longitude that these queries originated from.
	Longitude *float64 `json:"longitude,omitempty"`

	// The query experiences produced in this HeatMap calculation.
	QueryExperiences []*QueryExperience `json:"queryExperiences,omitempty"`

	// The IP address that this query experience originated from.
	SourceIP *string `json:"sourceIp,omitempty"`
}

// UserMetricsKeysClientCreateOrUpdateOptions contains the optional parameters for the UserMetricsKeysClient.CreateOrUpdate
// method.
type UserMetricsKeysClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// UserMetricsKeysClientDeleteOptions contains the optional parameters for the UserMetricsKeysClient.Delete method.
type UserMetricsKeysClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// UserMetricsKeysClientGetOptions contains the optional parameters for the UserMetricsKeysClient.Get method.
type UserMetricsKeysClientGetOptions struct {
	// placeholder for future optional parameters
}

// UserMetricsModel - Class representing Traffic Manager User Metrics.
type UserMetricsModel struct {
	// Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{resourceName}
	ID *string `json:"id,omitempty"`

	// The name of the resource
	Name *string `json:"name,omitempty"`

	// The properties of the Traffic Manager User Metrics.
	Properties *UserMetricsProperties `json:"properties,omitempty"`

	// The type of the resource. Ex- Microsoft.Network/trafficManagerProfiles.
	Type *string `json:"type,omitempty"`
}

// UserMetricsProperties - Class representing a Traffic Manager Real User Metrics key response.
type UserMetricsProperties struct {
	// The key returned by the User Metrics operation.
	Key *string `json:"key,omitempty"`
}
