//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armrecoveryservicesbackup

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
	"time"
)

// MarshalJSON implements the json.Marshaller interface for type AzureBackupGoalFeatureSupportRequest.
func (a AzureBackupGoalFeatureSupportRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["featureType"] = "AzureBackupGoals"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureBackupGoalFeatureSupportRequest.
func (a *AzureBackupGoalFeatureSupportRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "featureType":
			err = unpopulate(val, "FeatureType", &a.FeatureType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureBackupServerContainer.
func (a AzureBackupServerContainer) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "backupManagementType", a.BackupManagementType)
	populate(objectMap, "canReRegister", a.CanReRegister)
	populate(objectMap, "containerId", a.ContainerID)
	objectMap["containerType"] = ContainerTypeAzureBackupServerContainer
	populate(objectMap, "dpmAgentVersion", a.DpmAgentVersion)
	populate(objectMap, "dpmServers", a.DpmServers)
	populate(objectMap, "extendedInfo", a.ExtendedInfo)
	populate(objectMap, "friendlyName", a.FriendlyName)
	populate(objectMap, "healthStatus", a.HealthStatus)
	populate(objectMap, "protectableObjectType", a.ProtectableObjectType)
	populate(objectMap, "protectedItemCount", a.ProtectedItemCount)
	populate(objectMap, "protectionStatus", a.ProtectionStatus)
	populate(objectMap, "registrationStatus", a.RegistrationStatus)
	populate(objectMap, "upgradeAvailable", a.UpgradeAvailable)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureBackupServerContainer.
func (a *AzureBackupServerContainer) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupManagementType":
			err = unpopulate(val, "BackupManagementType", &a.BackupManagementType)
			delete(rawMsg, key)
		case "canReRegister":
			err = unpopulate(val, "CanReRegister", &a.CanReRegister)
			delete(rawMsg, key)
		case "containerId":
			err = unpopulate(val, "ContainerID", &a.ContainerID)
			delete(rawMsg, key)
		case "containerType":
			err = unpopulate(val, "ContainerType", &a.ContainerType)
			delete(rawMsg, key)
		case "dpmAgentVersion":
			err = unpopulate(val, "DpmAgentVersion", &a.DpmAgentVersion)
			delete(rawMsg, key)
		case "dpmServers":
			err = unpopulate(val, "DpmServers", &a.DpmServers)
			delete(rawMsg, key)
		case "extendedInfo":
			err = unpopulate(val, "ExtendedInfo", &a.ExtendedInfo)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &a.FriendlyName)
			delete(rawMsg, key)
		case "healthStatus":
			err = unpopulate(val, "HealthStatus", &a.HealthStatus)
			delete(rawMsg, key)
		case "protectableObjectType":
			err = unpopulate(val, "ProtectableObjectType", &a.ProtectableObjectType)
			delete(rawMsg, key)
		case "protectedItemCount":
			err = unpopulate(val, "ProtectedItemCount", &a.ProtectedItemCount)
			delete(rawMsg, key)
		case "protectionStatus":
			err = unpopulate(val, "ProtectionStatus", &a.ProtectionStatus)
			delete(rawMsg, key)
		case "registrationStatus":
			err = unpopulate(val, "RegistrationStatus", &a.RegistrationStatus)
			delete(rawMsg, key)
		case "upgradeAvailable":
			err = unpopulate(val, "UpgradeAvailable", &a.UpgradeAvailable)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureBackupServerEngine.
func (a AzureBackupServerEngine) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "azureBackupAgentVersion", a.AzureBackupAgentVersion)
	populate(objectMap, "backupEngineId", a.BackupEngineID)
	populate(objectMap, "backupEngineState", a.BackupEngineState)
	objectMap["backupEngineType"] = BackupEngineTypeAzureBackupServerEngine
	populate(objectMap, "backupManagementType", a.BackupManagementType)
	populate(objectMap, "canReRegister", a.CanReRegister)
	populate(objectMap, "dpmVersion", a.DpmVersion)
	populate(objectMap, "extendedInfo", a.ExtendedInfo)
	populate(objectMap, "friendlyName", a.FriendlyName)
	populate(objectMap, "healthStatus", a.HealthStatus)
	populate(objectMap, "isAzureBackupAgentUpgradeAvailable", a.IsAzureBackupAgentUpgradeAvailable)
	populate(objectMap, "isDpmUpgradeAvailable", a.IsDpmUpgradeAvailable)
	populate(objectMap, "registrationStatus", a.RegistrationStatus)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureBackupServerEngine.
func (a *AzureBackupServerEngine) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "azureBackupAgentVersion":
			err = unpopulate(val, "AzureBackupAgentVersion", &a.AzureBackupAgentVersion)
			delete(rawMsg, key)
		case "backupEngineId":
			err = unpopulate(val, "BackupEngineID", &a.BackupEngineID)
			delete(rawMsg, key)
		case "backupEngineState":
			err = unpopulate(val, "BackupEngineState", &a.BackupEngineState)
			delete(rawMsg, key)
		case "backupEngineType":
			err = unpopulate(val, "BackupEngineType", &a.BackupEngineType)
			delete(rawMsg, key)
		case "backupManagementType":
			err = unpopulate(val, "BackupManagementType", &a.BackupManagementType)
			delete(rawMsg, key)
		case "canReRegister":
			err = unpopulate(val, "CanReRegister", &a.CanReRegister)
			delete(rawMsg, key)
		case "dpmVersion":
			err = unpopulate(val, "DpmVersion", &a.DpmVersion)
			delete(rawMsg, key)
		case "extendedInfo":
			err = unpopulate(val, "ExtendedInfo", &a.ExtendedInfo)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &a.FriendlyName)
			delete(rawMsg, key)
		case "healthStatus":
			err = unpopulate(val, "HealthStatus", &a.HealthStatus)
			delete(rawMsg, key)
		case "isAzureBackupAgentUpgradeAvailable":
			err = unpopulate(val, "IsAzureBackupAgentUpgradeAvailable", &a.IsAzureBackupAgentUpgradeAvailable)
			delete(rawMsg, key)
		case "isDpmUpgradeAvailable":
			err = unpopulate(val, "IsDpmUpgradeAvailable", &a.IsDpmUpgradeAvailable)
			delete(rawMsg, key)
		case "registrationStatus":
			err = unpopulate(val, "RegistrationStatus", &a.RegistrationStatus)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureFileShareBackupRequest.
func (a AzureFileShareBackupRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["objectType"] = "AzureFileShareBackupRequest"
	populateTimeRFC3339(objectMap, "recoveryPointExpiryTimeInUTC", a.RecoveryPointExpiryTimeInUTC)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureFileShareBackupRequest.
func (a *AzureFileShareBackupRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "objectType":
			err = unpopulate(val, "ObjectType", &a.ObjectType)
			delete(rawMsg, key)
		case "recoveryPointExpiryTimeInUTC":
			err = unpopulateTimeRFC3339(val, "RecoveryPointExpiryTimeInUTC", &a.RecoveryPointExpiryTimeInUTC)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureFileShareProtectableItem.
func (a AzureFileShareProtectableItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "azureFileShareType", a.AzureFileShareType)
	populate(objectMap, "backupManagementType", a.BackupManagementType)
	populate(objectMap, "friendlyName", a.FriendlyName)
	populate(objectMap, "parentContainerFabricId", a.ParentContainerFabricID)
	populate(objectMap, "parentContainerFriendlyName", a.ParentContainerFriendlyName)
	objectMap["protectableItemType"] = "AzureFileShare"
	populate(objectMap, "protectionState", a.ProtectionState)
	populate(objectMap, "workloadType", a.WorkloadType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureFileShareProtectableItem.
func (a *AzureFileShareProtectableItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "azureFileShareType":
			err = unpopulate(val, "AzureFileShareType", &a.AzureFileShareType)
			delete(rawMsg, key)
		case "backupManagementType":
			err = unpopulate(val, "BackupManagementType", &a.BackupManagementType)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &a.FriendlyName)
			delete(rawMsg, key)
		case "parentContainerFabricId":
			err = unpopulate(val, "ParentContainerFabricID", &a.ParentContainerFabricID)
			delete(rawMsg, key)
		case "parentContainerFriendlyName":
			err = unpopulate(val, "ParentContainerFriendlyName", &a.ParentContainerFriendlyName)
			delete(rawMsg, key)
		case "protectableItemType":
			err = unpopulate(val, "ProtectableItemType", &a.ProtectableItemType)
			delete(rawMsg, key)
		case "protectionState":
			err = unpopulate(val, "ProtectionState", &a.ProtectionState)
			delete(rawMsg, key)
		case "workloadType":
			err = unpopulate(val, "WorkloadType", &a.WorkloadType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureFileShareProtectionPolicy.
func (a AzureFileShareProtectionPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["backupManagementType"] = "AzureStorage"
	populate(objectMap, "protectedItemsCount", a.ProtectedItemsCount)
	populate(objectMap, "resourceGuardOperationRequests", a.ResourceGuardOperationRequests)
	populate(objectMap, "retentionPolicy", a.RetentionPolicy)
	populate(objectMap, "schedulePolicy", a.SchedulePolicy)
	populate(objectMap, "timeZone", a.TimeZone)
	populate(objectMap, "workLoadType", a.WorkLoadType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureFileShareProtectionPolicy.
func (a *AzureFileShareProtectionPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupManagementType":
			err = unpopulate(val, "BackupManagementType", &a.BackupManagementType)
			delete(rawMsg, key)
		case "protectedItemsCount":
			err = unpopulate(val, "ProtectedItemsCount", &a.ProtectedItemsCount)
			delete(rawMsg, key)
		case "resourceGuardOperationRequests":
			err = unpopulate(val, "ResourceGuardOperationRequests", &a.ResourceGuardOperationRequests)
			delete(rawMsg, key)
		case "retentionPolicy":
			a.RetentionPolicy, err = unmarshalRetentionPolicyClassification(val)
			delete(rawMsg, key)
		case "schedulePolicy":
			a.SchedulePolicy, err = unmarshalSchedulePolicyClassification(val)
			delete(rawMsg, key)
		case "timeZone":
			err = unpopulate(val, "TimeZone", &a.TimeZone)
			delete(rawMsg, key)
		case "workLoadType":
			err = unpopulate(val, "WorkLoadType", &a.WorkLoadType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureFileShareProvisionILRRequest.
func (a AzureFileShareProvisionILRRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["objectType"] = "AzureFileShareProvisionILRRequest"
	populate(objectMap, "recoveryPointId", a.RecoveryPointID)
	populate(objectMap, "sourceResourceId", a.SourceResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureFileShareProvisionILRRequest.
func (a *AzureFileShareProvisionILRRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "objectType":
			err = unpopulate(val, "ObjectType", &a.ObjectType)
			delete(rawMsg, key)
		case "recoveryPointId":
			err = unpopulate(val, "RecoveryPointID", &a.RecoveryPointID)
			delete(rawMsg, key)
		case "sourceResourceId":
			err = unpopulate(val, "SourceResourceID", &a.SourceResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureFileShareRecoveryPoint.
func (a AzureFileShareRecoveryPoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "fileShareSnapshotUri", a.FileShareSnapshotURI)
	objectMap["objectType"] = "AzureFileShareRecoveryPoint"
	populate(objectMap, "recoveryPointSizeInGB", a.RecoveryPointSizeInGB)
	populateTimeRFC3339(objectMap, "recoveryPointTime", a.RecoveryPointTime)
	populate(objectMap, "recoveryPointType", a.RecoveryPointType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureFileShareRecoveryPoint.
func (a *AzureFileShareRecoveryPoint) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "fileShareSnapshotUri":
			err = unpopulate(val, "FileShareSnapshotURI", &a.FileShareSnapshotURI)
			delete(rawMsg, key)
		case "objectType":
			err = unpopulate(val, "ObjectType", &a.ObjectType)
			delete(rawMsg, key)
		case "recoveryPointSizeInGB":
			err = unpopulate(val, "RecoveryPointSizeInGB", &a.RecoveryPointSizeInGB)
			delete(rawMsg, key)
		case "recoveryPointTime":
			err = unpopulateTimeRFC3339(val, "RecoveryPointTime", &a.RecoveryPointTime)
			delete(rawMsg, key)
		case "recoveryPointType":
			err = unpopulate(val, "RecoveryPointType", &a.RecoveryPointType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureFileShareRestoreRequest.
func (a AzureFileShareRestoreRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "copyOptions", a.CopyOptions)
	objectMap["objectType"] = "AzureFileShareRestoreRequest"
	populate(objectMap, "recoveryType", a.RecoveryType)
	populate(objectMap, "restoreFileSpecs", a.RestoreFileSpecs)
	populate(objectMap, "restoreRequestType", a.RestoreRequestType)
	populate(objectMap, "sourceResourceId", a.SourceResourceID)
	populate(objectMap, "targetDetails", a.TargetDetails)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureFileShareRestoreRequest.
func (a *AzureFileShareRestoreRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "copyOptions":
			err = unpopulate(val, "CopyOptions", &a.CopyOptions)
			delete(rawMsg, key)
		case "objectType":
			err = unpopulate(val, "ObjectType", &a.ObjectType)
			delete(rawMsg, key)
		case "recoveryType":
			err = unpopulate(val, "RecoveryType", &a.RecoveryType)
			delete(rawMsg, key)
		case "restoreFileSpecs":
			err = unpopulate(val, "RestoreFileSpecs", &a.RestoreFileSpecs)
			delete(rawMsg, key)
		case "restoreRequestType":
			err = unpopulate(val, "RestoreRequestType", &a.RestoreRequestType)
			delete(rawMsg, key)
		case "sourceResourceId":
			err = unpopulate(val, "SourceResourceID", &a.SourceResourceID)
			delete(rawMsg, key)
		case "targetDetails":
			err = unpopulate(val, "TargetDetails", &a.TargetDetails)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureFileshareProtectedItem.
func (a AzureFileshareProtectedItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "backupManagementType", a.BackupManagementType)
	populate(objectMap, "backupSetName", a.BackupSetName)
	populate(objectMap, "containerName", a.ContainerName)
	populate(objectMap, "createMode", a.CreateMode)
	populateTimeRFC3339(objectMap, "deferredDeleteTimeInUTC", a.DeferredDeleteTimeInUTC)
	populate(objectMap, "deferredDeleteTimeRemaining", a.DeferredDeleteTimeRemaining)
	populate(objectMap, "extendedInfo", a.ExtendedInfo)
	populate(objectMap, "friendlyName", a.FriendlyName)
	populate(objectMap, "isArchiveEnabled", a.IsArchiveEnabled)
	populate(objectMap, "isDeferredDeleteScheduleUpcoming", a.IsDeferredDeleteScheduleUpcoming)
	populate(objectMap, "isRehydrate", a.IsRehydrate)
	populate(objectMap, "isScheduledForDeferredDelete", a.IsScheduledForDeferredDelete)
	populate(objectMap, "kpisHealths", a.KpisHealths)
	populate(objectMap, "lastBackupStatus", a.LastBackupStatus)
	populateTimeRFC3339(objectMap, "lastBackupTime", a.LastBackupTime)
	populateTimeRFC3339(objectMap, "lastRecoveryPoint", a.LastRecoveryPoint)
	populate(objectMap, "policyId", a.PolicyID)
	populate(objectMap, "policyName", a.PolicyName)
	objectMap["protectedItemType"] = "AzureFileShareProtectedItem"
	populate(objectMap, "protectionState", a.ProtectionState)
	populate(objectMap, "protectionStatus", a.ProtectionStatus)
	populate(objectMap, "resourceGuardOperationRequests", a.ResourceGuardOperationRequests)
	populate(objectMap, "sourceResourceId", a.SourceResourceID)
	populate(objectMap, "workloadType", a.WorkloadType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureFileshareProtectedItem.
func (a *AzureFileshareProtectedItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupManagementType":
			err = unpopulate(val, "BackupManagementType", &a.BackupManagementType)
			delete(rawMsg, key)
		case "backupSetName":
			err = unpopulate(val, "BackupSetName", &a.BackupSetName)
			delete(rawMsg, key)
		case "containerName":
			err = unpopulate(val, "ContainerName", &a.ContainerName)
			delete(rawMsg, key)
		case "createMode":
			err = unpopulate(val, "CreateMode", &a.CreateMode)
			delete(rawMsg, key)
		case "deferredDeleteTimeInUTC":
			err = unpopulateTimeRFC3339(val, "DeferredDeleteTimeInUTC", &a.DeferredDeleteTimeInUTC)
			delete(rawMsg, key)
		case "deferredDeleteTimeRemaining":
			err = unpopulate(val, "DeferredDeleteTimeRemaining", &a.DeferredDeleteTimeRemaining)
			delete(rawMsg, key)
		case "extendedInfo":
			err = unpopulate(val, "ExtendedInfo", &a.ExtendedInfo)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &a.FriendlyName)
			delete(rawMsg, key)
		case "isArchiveEnabled":
			err = unpopulate(val, "IsArchiveEnabled", &a.IsArchiveEnabled)
			delete(rawMsg, key)
		case "isDeferredDeleteScheduleUpcoming":
			err = unpopulate(val, "IsDeferredDeleteScheduleUpcoming", &a.IsDeferredDeleteScheduleUpcoming)
			delete(rawMsg, key)
		case "isRehydrate":
			err = unpopulate(val, "IsRehydrate", &a.IsRehydrate)
			delete(rawMsg, key)
		case "isScheduledForDeferredDelete":
			err = unpopulate(val, "IsScheduledForDeferredDelete", &a.IsScheduledForDeferredDelete)
			delete(rawMsg, key)
		case "kpisHealths":
			err = unpopulate(val, "KpisHealths", &a.KpisHealths)
			delete(rawMsg, key)
		case "lastBackupStatus":
			err = unpopulate(val, "LastBackupStatus", &a.LastBackupStatus)
			delete(rawMsg, key)
		case "lastBackupTime":
			err = unpopulateTimeRFC3339(val, "LastBackupTime", &a.LastBackupTime)
			delete(rawMsg, key)
		case "lastRecoveryPoint":
			err = unpopulateTimeRFC3339(val, "LastRecoveryPoint", &a.LastRecoveryPoint)
			delete(rawMsg, key)
		case "policyId":
			err = unpopulate(val, "PolicyID", &a.PolicyID)
			delete(rawMsg, key)
		case "policyName":
			err = unpopulate(val, "PolicyName", &a.PolicyName)
			delete(rawMsg, key)
		case "protectedItemType":
			err = unpopulate(val, "ProtectedItemType", &a.ProtectedItemType)
			delete(rawMsg, key)
		case "protectionState":
			err = unpopulate(val, "ProtectionState", &a.ProtectionState)
			delete(rawMsg, key)
		case "protectionStatus":
			err = unpopulate(val, "ProtectionStatus", &a.ProtectionStatus)
			delete(rawMsg, key)
		case "resourceGuardOperationRequests":
			err = unpopulate(val, "ResourceGuardOperationRequests", &a.ResourceGuardOperationRequests)
			delete(rawMsg, key)
		case "sourceResourceId":
			err = unpopulate(val, "SourceResourceID", &a.SourceResourceID)
			delete(rawMsg, key)
		case "workloadType":
			err = unpopulate(val, "WorkloadType", &a.WorkloadType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureFileshareProtectedItemExtendedInfo.
func (a AzureFileshareProtectedItemExtendedInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "oldestRecoveryPoint", a.OldestRecoveryPoint)
	populate(objectMap, "policyState", a.PolicyState)
	populate(objectMap, "recoveryPointCount", a.RecoveryPointCount)
	populate(objectMap, "resourceState", a.ResourceState)
	populateTimeRFC3339(objectMap, "resourceStateSyncTime", a.ResourceStateSyncTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureFileshareProtectedItemExtendedInfo.
func (a *AzureFileshareProtectedItemExtendedInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "oldestRecoveryPoint":
			err = unpopulateTimeRFC3339(val, "OldestRecoveryPoint", &a.OldestRecoveryPoint)
			delete(rawMsg, key)
		case "policyState":
			err = unpopulate(val, "PolicyState", &a.PolicyState)
			delete(rawMsg, key)
		case "recoveryPointCount":
			err = unpopulate(val, "RecoveryPointCount", &a.RecoveryPointCount)
			delete(rawMsg, key)
		case "resourceState":
			err = unpopulate(val, "ResourceState", &a.ResourceState)
			delete(rawMsg, key)
		case "resourceStateSyncTime":
			err = unpopulateTimeRFC3339(val, "ResourceStateSyncTime", &a.ResourceStateSyncTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureIaaSClassicComputeVMContainer.
func (a AzureIaaSClassicComputeVMContainer) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "backupManagementType", a.BackupManagementType)
	objectMap["containerType"] = ContainerTypeMicrosoftClassicComputeVirtualMachines
	populate(objectMap, "friendlyName", a.FriendlyName)
	populate(objectMap, "healthStatus", a.HealthStatus)
	populate(objectMap, "protectableObjectType", a.ProtectableObjectType)
	populate(objectMap, "registrationStatus", a.RegistrationStatus)
	populate(objectMap, "resourceGroup", a.ResourceGroup)
	populate(objectMap, "virtualMachineId", a.VirtualMachineID)
	populate(objectMap, "virtualMachineVersion", a.VirtualMachineVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureIaaSClassicComputeVMContainer.
func (a *AzureIaaSClassicComputeVMContainer) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupManagementType":
			err = unpopulate(val, "BackupManagementType", &a.BackupManagementType)
			delete(rawMsg, key)
		case "containerType":
			err = unpopulate(val, "ContainerType", &a.ContainerType)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &a.FriendlyName)
			delete(rawMsg, key)
		case "healthStatus":
			err = unpopulate(val, "HealthStatus", &a.HealthStatus)
			delete(rawMsg, key)
		case "protectableObjectType":
			err = unpopulate(val, "ProtectableObjectType", &a.ProtectableObjectType)
			delete(rawMsg, key)
		case "registrationStatus":
			err = unpopulate(val, "RegistrationStatus", &a.RegistrationStatus)
			delete(rawMsg, key)
		case "resourceGroup":
			err = unpopulate(val, "ResourceGroup", &a.ResourceGroup)
			delete(rawMsg, key)
		case "virtualMachineId":
			err = unpopulate(val, "VirtualMachineID", &a.VirtualMachineID)
			delete(rawMsg, key)
		case "virtualMachineVersion":
			err = unpopulate(val, "VirtualMachineVersion", &a.VirtualMachineVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureIaaSClassicComputeVMProtectableItem.
func (a AzureIaaSClassicComputeVMProtectableItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "backupManagementType", a.BackupManagementType)
	populate(objectMap, "friendlyName", a.FriendlyName)
	objectMap["protectableItemType"] = "Microsoft.ClassicCompute/virtualMachines"
	populate(objectMap, "protectionState", a.ProtectionState)
	populate(objectMap, "resourceGroup", a.ResourceGroup)
	populate(objectMap, "virtualMachineId", a.VirtualMachineID)
	populate(objectMap, "virtualMachineVersion", a.VirtualMachineVersion)
	populate(objectMap, "workloadType", a.WorkloadType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureIaaSClassicComputeVMProtectableItem.
func (a *AzureIaaSClassicComputeVMProtectableItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupManagementType":
			err = unpopulate(val, "BackupManagementType", &a.BackupManagementType)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &a.FriendlyName)
			delete(rawMsg, key)
		case "protectableItemType":
			err = unpopulate(val, "ProtectableItemType", &a.ProtectableItemType)
			delete(rawMsg, key)
		case "protectionState":
			err = unpopulate(val, "ProtectionState", &a.ProtectionState)
			delete(rawMsg, key)
		case "resourceGroup":
			err = unpopulate(val, "ResourceGroup", &a.ResourceGroup)
			delete(rawMsg, key)
		case "virtualMachineId":
			err = unpopulate(val, "VirtualMachineID", &a.VirtualMachineID)
			delete(rawMsg, key)
		case "virtualMachineVersion":
			err = unpopulate(val, "VirtualMachineVersion", &a.VirtualMachineVersion)
			delete(rawMsg, key)
		case "workloadType":
			err = unpopulate(val, "WorkloadType", &a.WorkloadType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureIaaSClassicComputeVMProtectedItem.
func (a AzureIaaSClassicComputeVMProtectedItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "backupManagementType", a.BackupManagementType)
	populate(objectMap, "backupSetName", a.BackupSetName)
	populate(objectMap, "containerName", a.ContainerName)
	populate(objectMap, "createMode", a.CreateMode)
	populateTimeRFC3339(objectMap, "deferredDeleteTimeInUTC", a.DeferredDeleteTimeInUTC)
	populate(objectMap, "deferredDeleteTimeRemaining", a.DeferredDeleteTimeRemaining)
	populate(objectMap, "extendedInfo", a.ExtendedInfo)
	populate(objectMap, "extendedProperties", a.ExtendedProperties)
	populate(objectMap, "friendlyName", a.FriendlyName)
	populate(objectMap, "healthDetails", a.HealthDetails)
	populate(objectMap, "healthStatus", a.HealthStatus)
	populate(objectMap, "isArchiveEnabled", a.IsArchiveEnabled)
	populate(objectMap, "isDeferredDeleteScheduleUpcoming", a.IsDeferredDeleteScheduleUpcoming)
	populate(objectMap, "isRehydrate", a.IsRehydrate)
	populate(objectMap, "isScheduledForDeferredDelete", a.IsScheduledForDeferredDelete)
	populate(objectMap, "kpisHealths", a.KpisHealths)
	populate(objectMap, "lastBackupStatus", a.LastBackupStatus)
	populateTimeRFC3339(objectMap, "lastBackupTime", a.LastBackupTime)
	populateTimeRFC3339(objectMap, "lastRecoveryPoint", a.LastRecoveryPoint)
	populate(objectMap, "policyId", a.PolicyID)
	populate(objectMap, "policyName", a.PolicyName)
	populate(objectMap, "protectedItemDataId", a.ProtectedItemDataID)
	objectMap["protectedItemType"] = "Microsoft.ClassicCompute/virtualMachines"
	populate(objectMap, "protectionState", a.ProtectionState)
	populate(objectMap, "protectionStatus", a.ProtectionStatus)
	populate(objectMap, "resourceGuardOperationRequests", a.ResourceGuardOperationRequests)
	populate(objectMap, "sourceResourceId", a.SourceResourceID)
	populate(objectMap, "virtualMachineId", a.VirtualMachineID)
	populate(objectMap, "workloadType", a.WorkloadType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureIaaSClassicComputeVMProtectedItem.
func (a *AzureIaaSClassicComputeVMProtectedItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupManagementType":
			err = unpopulate(val, "BackupManagementType", &a.BackupManagementType)
			delete(rawMsg, key)
		case "backupSetName":
			err = unpopulate(val, "BackupSetName", &a.BackupSetName)
			delete(rawMsg, key)
		case "containerName":
			err = unpopulate(val, "ContainerName", &a.ContainerName)
			delete(rawMsg, key)
		case "createMode":
			err = unpopulate(val, "CreateMode", &a.CreateMode)
			delete(rawMsg, key)
		case "deferredDeleteTimeInUTC":
			err = unpopulateTimeRFC3339(val, "DeferredDeleteTimeInUTC", &a.DeferredDeleteTimeInUTC)
			delete(rawMsg, key)
		case "deferredDeleteTimeRemaining":
			err = unpopulate(val, "DeferredDeleteTimeRemaining", &a.DeferredDeleteTimeRemaining)
			delete(rawMsg, key)
		case "extendedInfo":
			err = unpopulate(val, "ExtendedInfo", &a.ExtendedInfo)
			delete(rawMsg, key)
		case "extendedProperties":
			err = unpopulate(val, "ExtendedProperties", &a.ExtendedProperties)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &a.FriendlyName)
			delete(rawMsg, key)
		case "healthDetails":
			err = unpopulate(val, "HealthDetails", &a.HealthDetails)
			delete(rawMsg, key)
		case "healthStatus":
			err = unpopulate(val, "HealthStatus", &a.HealthStatus)
			delete(rawMsg, key)
		case "isArchiveEnabled":
			err = unpopulate(val, "IsArchiveEnabled", &a.IsArchiveEnabled)
			delete(rawMsg, key)
		case "isDeferredDeleteScheduleUpcoming":
			err = unpopulate(val, "IsDeferredDeleteScheduleUpcoming", &a.IsDeferredDeleteScheduleUpcoming)
			delete(rawMsg, key)
		case "isRehydrate":
			err = unpopulate(val, "IsRehydrate", &a.IsRehydrate)
			delete(rawMsg, key)
		case "isScheduledForDeferredDelete":
			err = unpopulate(val, "IsScheduledForDeferredDelete", &a.IsScheduledForDeferredDelete)
			delete(rawMsg, key)
		case "kpisHealths":
			err = unpopulate(val, "KpisHealths", &a.KpisHealths)
			delete(rawMsg, key)
		case "lastBackupStatus":
			err = unpopulate(val, "LastBackupStatus", &a.LastBackupStatus)
			delete(rawMsg, key)
		case "lastBackupTime":
			err = unpopulateTimeRFC3339(val, "LastBackupTime", &a.LastBackupTime)
			delete(rawMsg, key)
		case "lastRecoveryPoint":
			err = unpopulateTimeRFC3339(val, "LastRecoveryPoint", &a.LastRecoveryPoint)
			delete(rawMsg, key)
		case "policyId":
			err = unpopulate(val, "PolicyID", &a.PolicyID)
			delete(rawMsg, key)
		case "policyName":
			err = unpopulate(val, "PolicyName", &a.PolicyName)
			delete(rawMsg, key)
		case "protectedItemDataId":
			err = unpopulate(val, "ProtectedItemDataID", &a.ProtectedItemDataID)
			delete(rawMsg, key)
		case "protectedItemType":
			err = unpopulate(val, "ProtectedItemType", &a.ProtectedItemType)
			delete(rawMsg, key)
		case "protectionState":
			err = unpopulate(val, "ProtectionState", &a.ProtectionState)
			delete(rawMsg, key)
		case "protectionStatus":
			err = unpopulate(val, "ProtectionStatus", &a.ProtectionStatus)
			delete(rawMsg, key)
		case "resourceGuardOperationRequests":
			err = unpopulate(val, "ResourceGuardOperationRequests", &a.ResourceGuardOperationRequests)
			delete(rawMsg, key)
		case "sourceResourceId":
			err = unpopulate(val, "SourceResourceID", &a.SourceResourceID)
			delete(rawMsg, key)
		case "virtualMachineId":
			err = unpopulate(val, "VirtualMachineID", &a.VirtualMachineID)
			delete(rawMsg, key)
		case "workloadType":
			err = unpopulate(val, "WorkloadType", &a.WorkloadType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureIaaSComputeVMContainer.
func (a AzureIaaSComputeVMContainer) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "backupManagementType", a.BackupManagementType)
	objectMap["containerType"] = ContainerTypeMicrosoftComputeVirtualMachines
	populate(objectMap, "friendlyName", a.FriendlyName)
	populate(objectMap, "healthStatus", a.HealthStatus)
	populate(objectMap, "protectableObjectType", a.ProtectableObjectType)
	populate(objectMap, "registrationStatus", a.RegistrationStatus)
	populate(objectMap, "resourceGroup", a.ResourceGroup)
	populate(objectMap, "virtualMachineId", a.VirtualMachineID)
	populate(objectMap, "virtualMachineVersion", a.VirtualMachineVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureIaaSComputeVMContainer.
func (a *AzureIaaSComputeVMContainer) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupManagementType":
			err = unpopulate(val, "BackupManagementType", &a.BackupManagementType)
			delete(rawMsg, key)
		case "containerType":
			err = unpopulate(val, "ContainerType", &a.ContainerType)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &a.FriendlyName)
			delete(rawMsg, key)
		case "healthStatus":
			err = unpopulate(val, "HealthStatus", &a.HealthStatus)
			delete(rawMsg, key)
		case "protectableObjectType":
			err = unpopulate(val, "ProtectableObjectType", &a.ProtectableObjectType)
			delete(rawMsg, key)
		case "registrationStatus":
			err = unpopulate(val, "RegistrationStatus", &a.RegistrationStatus)
			delete(rawMsg, key)
		case "resourceGroup":
			err = unpopulate(val, "ResourceGroup", &a.ResourceGroup)
			delete(rawMsg, key)
		case "virtualMachineId":
			err = unpopulate(val, "VirtualMachineID", &a.VirtualMachineID)
			delete(rawMsg, key)
		case "virtualMachineVersion":
			err = unpopulate(val, "VirtualMachineVersion", &a.VirtualMachineVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureIaaSComputeVMProtectableItem.
func (a AzureIaaSComputeVMProtectableItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "backupManagementType", a.BackupManagementType)
	populate(objectMap, "friendlyName", a.FriendlyName)
	objectMap["protectableItemType"] = "Microsoft.Compute/virtualMachines"
	populate(objectMap, "protectionState", a.ProtectionState)
	populate(objectMap, "resourceGroup", a.ResourceGroup)
	populate(objectMap, "virtualMachineId", a.VirtualMachineID)
	populate(objectMap, "virtualMachineVersion", a.VirtualMachineVersion)
	populate(objectMap, "workloadType", a.WorkloadType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureIaaSComputeVMProtectableItem.
func (a *AzureIaaSComputeVMProtectableItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupManagementType":
			err = unpopulate(val, "BackupManagementType", &a.BackupManagementType)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &a.FriendlyName)
			delete(rawMsg, key)
		case "protectableItemType":
			err = unpopulate(val, "ProtectableItemType", &a.ProtectableItemType)
			delete(rawMsg, key)
		case "protectionState":
			err = unpopulate(val, "ProtectionState", &a.ProtectionState)
			delete(rawMsg, key)
		case "resourceGroup":
			err = unpopulate(val, "ResourceGroup", &a.ResourceGroup)
			delete(rawMsg, key)
		case "virtualMachineId":
			err = unpopulate(val, "VirtualMachineID", &a.VirtualMachineID)
			delete(rawMsg, key)
		case "virtualMachineVersion":
			err = unpopulate(val, "VirtualMachineVersion", &a.VirtualMachineVersion)
			delete(rawMsg, key)
		case "workloadType":
			err = unpopulate(val, "WorkloadType", &a.WorkloadType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureIaaSComputeVMProtectedItem.
func (a AzureIaaSComputeVMProtectedItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "backupManagementType", a.BackupManagementType)
	populate(objectMap, "backupSetName", a.BackupSetName)
	populate(objectMap, "containerName", a.ContainerName)
	populate(objectMap, "createMode", a.CreateMode)
	populateTimeRFC3339(objectMap, "deferredDeleteTimeInUTC", a.DeferredDeleteTimeInUTC)
	populate(objectMap, "deferredDeleteTimeRemaining", a.DeferredDeleteTimeRemaining)
	populate(objectMap, "extendedInfo", a.ExtendedInfo)
	populate(objectMap, "extendedProperties", a.ExtendedProperties)
	populate(objectMap, "friendlyName", a.FriendlyName)
	populate(objectMap, "healthDetails", a.HealthDetails)
	populate(objectMap, "healthStatus", a.HealthStatus)
	populate(objectMap, "isArchiveEnabled", a.IsArchiveEnabled)
	populate(objectMap, "isDeferredDeleteScheduleUpcoming", a.IsDeferredDeleteScheduleUpcoming)
	populate(objectMap, "isRehydrate", a.IsRehydrate)
	populate(objectMap, "isScheduledForDeferredDelete", a.IsScheduledForDeferredDelete)
	populate(objectMap, "kpisHealths", a.KpisHealths)
	populate(objectMap, "lastBackupStatus", a.LastBackupStatus)
	populateTimeRFC3339(objectMap, "lastBackupTime", a.LastBackupTime)
	populateTimeRFC3339(objectMap, "lastRecoveryPoint", a.LastRecoveryPoint)
	populate(objectMap, "policyId", a.PolicyID)
	populate(objectMap, "policyName", a.PolicyName)
	populate(objectMap, "protectedItemDataId", a.ProtectedItemDataID)
	objectMap["protectedItemType"] = "Microsoft.Compute/virtualMachines"
	populate(objectMap, "protectionState", a.ProtectionState)
	populate(objectMap, "protectionStatus", a.ProtectionStatus)
	populate(objectMap, "resourceGuardOperationRequests", a.ResourceGuardOperationRequests)
	populate(objectMap, "sourceResourceId", a.SourceResourceID)
	populate(objectMap, "virtualMachineId", a.VirtualMachineID)
	populate(objectMap, "workloadType", a.WorkloadType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureIaaSComputeVMProtectedItem.
func (a *AzureIaaSComputeVMProtectedItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupManagementType":
			err = unpopulate(val, "BackupManagementType", &a.BackupManagementType)
			delete(rawMsg, key)
		case "backupSetName":
			err = unpopulate(val, "BackupSetName", &a.BackupSetName)
			delete(rawMsg, key)
		case "containerName":
			err = unpopulate(val, "ContainerName", &a.ContainerName)
			delete(rawMsg, key)
		case "createMode":
			err = unpopulate(val, "CreateMode", &a.CreateMode)
			delete(rawMsg, key)
		case "deferredDeleteTimeInUTC":
			err = unpopulateTimeRFC3339(val, "DeferredDeleteTimeInUTC", &a.DeferredDeleteTimeInUTC)
			delete(rawMsg, key)
		case "deferredDeleteTimeRemaining":
			err = unpopulate(val, "DeferredDeleteTimeRemaining", &a.DeferredDeleteTimeRemaining)
			delete(rawMsg, key)
		case "extendedInfo":
			err = unpopulate(val, "ExtendedInfo", &a.ExtendedInfo)
			delete(rawMsg, key)
		case "extendedProperties":
			err = unpopulate(val, "ExtendedProperties", &a.ExtendedProperties)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &a.FriendlyName)
			delete(rawMsg, key)
		case "healthDetails":
			err = unpopulate(val, "HealthDetails", &a.HealthDetails)
			delete(rawMsg, key)
		case "healthStatus":
			err = unpopulate(val, "HealthStatus", &a.HealthStatus)
			delete(rawMsg, key)
		case "isArchiveEnabled":
			err = unpopulate(val, "IsArchiveEnabled", &a.IsArchiveEnabled)
			delete(rawMsg, key)
		case "isDeferredDeleteScheduleUpcoming":
			err = unpopulate(val, "IsDeferredDeleteScheduleUpcoming", &a.IsDeferredDeleteScheduleUpcoming)
			delete(rawMsg, key)
		case "isRehydrate":
			err = unpopulate(val, "IsRehydrate", &a.IsRehydrate)
			delete(rawMsg, key)
		case "isScheduledForDeferredDelete":
			err = unpopulate(val, "IsScheduledForDeferredDelete", &a.IsScheduledForDeferredDelete)
			delete(rawMsg, key)
		case "kpisHealths":
			err = unpopulate(val, "KpisHealths", &a.KpisHealths)
			delete(rawMsg, key)
		case "lastBackupStatus":
			err = unpopulate(val, "LastBackupStatus", &a.LastBackupStatus)
			delete(rawMsg, key)
		case "lastBackupTime":
			err = unpopulateTimeRFC3339(val, "LastBackupTime", &a.LastBackupTime)
			delete(rawMsg, key)
		case "lastRecoveryPoint":
			err = unpopulateTimeRFC3339(val, "LastRecoveryPoint", &a.LastRecoveryPoint)
			delete(rawMsg, key)
		case "policyId":
			err = unpopulate(val, "PolicyID", &a.PolicyID)
			delete(rawMsg, key)
		case "policyName":
			err = unpopulate(val, "PolicyName", &a.PolicyName)
			delete(rawMsg, key)
		case "protectedItemDataId":
			err = unpopulate(val, "ProtectedItemDataID", &a.ProtectedItemDataID)
			delete(rawMsg, key)
		case "protectedItemType":
			err = unpopulate(val, "ProtectedItemType", &a.ProtectedItemType)
			delete(rawMsg, key)
		case "protectionState":
			err = unpopulate(val, "ProtectionState", &a.ProtectionState)
			delete(rawMsg, key)
		case "protectionStatus":
			err = unpopulate(val, "ProtectionStatus", &a.ProtectionStatus)
			delete(rawMsg, key)
		case "resourceGuardOperationRequests":
			err = unpopulate(val, "ResourceGuardOperationRequests", &a.ResourceGuardOperationRequests)
			delete(rawMsg, key)
		case "sourceResourceId":
			err = unpopulate(val, "SourceResourceID", &a.SourceResourceID)
			delete(rawMsg, key)
		case "virtualMachineId":
			err = unpopulate(val, "VirtualMachineID", &a.VirtualMachineID)
			delete(rawMsg, key)
		case "workloadType":
			err = unpopulate(val, "WorkloadType", &a.WorkloadType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureIaaSVMErrorInfo.
func (a AzureIaaSVMErrorInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "errorCode", a.ErrorCode)
	populate(objectMap, "errorString", a.ErrorString)
	populate(objectMap, "errorTitle", a.ErrorTitle)
	populate(objectMap, "recommendations", a.Recommendations)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type AzureIaaSVMHealthDetails.
func (a AzureIaaSVMHealthDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "code", a.Code)
	populate(objectMap, "message", a.Message)
	populate(objectMap, "recommendations", a.Recommendations)
	populate(objectMap, "title", a.Title)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type AzureIaaSVMJob.
func (a AzureIaaSVMJob) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "actionsInfo", a.ActionsInfo)
	populate(objectMap, "activityId", a.ActivityID)
	populate(objectMap, "backupManagementType", a.BackupManagementType)
	populate(objectMap, "containerName", a.ContainerName)
	populate(objectMap, "duration", a.Duration)
	populateTimeRFC3339(objectMap, "endTime", a.EndTime)
	populate(objectMap, "entityFriendlyName", a.EntityFriendlyName)
	populate(objectMap, "errorDetails", a.ErrorDetails)
	populate(objectMap, "extendedInfo", a.ExtendedInfo)
	populate(objectMap, "isUserTriggered", a.IsUserTriggered)
	objectMap["jobType"] = "AzureIaaSVMJob"
	populate(objectMap, "operation", a.Operation)
	populateTimeRFC3339(objectMap, "startTime", a.StartTime)
	populate(objectMap, "status", a.Status)
	populate(objectMap, "virtualMachineVersion", a.VirtualMachineVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureIaaSVMJob.
func (a *AzureIaaSVMJob) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actionsInfo":
			err = unpopulate(val, "ActionsInfo", &a.ActionsInfo)
			delete(rawMsg, key)
		case "activityId":
			err = unpopulate(val, "ActivityID", &a.ActivityID)
			delete(rawMsg, key)
		case "backupManagementType":
			err = unpopulate(val, "BackupManagementType", &a.BackupManagementType)
			delete(rawMsg, key)
		case "containerName":
			err = unpopulate(val, "ContainerName", &a.ContainerName)
			delete(rawMsg, key)
		case "duration":
			err = unpopulate(val, "Duration", &a.Duration)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulateTimeRFC3339(val, "EndTime", &a.EndTime)
			delete(rawMsg, key)
		case "entityFriendlyName":
			err = unpopulate(val, "EntityFriendlyName", &a.EntityFriendlyName)
			delete(rawMsg, key)
		case "errorDetails":
			err = unpopulate(val, "ErrorDetails", &a.ErrorDetails)
			delete(rawMsg, key)
		case "extendedInfo":
			err = unpopulate(val, "ExtendedInfo", &a.ExtendedInfo)
			delete(rawMsg, key)
		case "isUserTriggered":
			err = unpopulate(val, "IsUserTriggered", &a.IsUserTriggered)
			delete(rawMsg, key)
		case "jobType":
			err = unpopulate(val, "JobType", &a.JobType)
			delete(rawMsg, key)
		case "operation":
			err = unpopulate(val, "Operation", &a.Operation)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &a.StartTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &a.Status)
			delete(rawMsg, key)
		case "virtualMachineVersion":
			err = unpopulate(val, "VirtualMachineVersion", &a.VirtualMachineVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureIaaSVMJobExtendedInfo.
func (a AzureIaaSVMJobExtendedInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "dynamicErrorMessage", a.DynamicErrorMessage)
	populate(objectMap, "estimatedRemainingDuration", a.EstimatedRemainingDuration)
	populate(objectMap, "internalPropertyBag", a.InternalPropertyBag)
	populate(objectMap, "progressPercentage", a.ProgressPercentage)
	populate(objectMap, "propertyBag", a.PropertyBag)
	populate(objectMap, "tasksList", a.TasksList)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type AzureIaaSVMJobTaskDetails.
func (a AzureIaaSVMJobTaskDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "duration", a.Duration)
	populateTimeRFC3339(objectMap, "endTime", a.EndTime)
	populate(objectMap, "instanceId", a.InstanceID)
	populate(objectMap, "progressPercentage", a.ProgressPercentage)
	populateTimeRFC3339(objectMap, "startTime", a.StartTime)
	populate(objectMap, "status", a.Status)
	populate(objectMap, "taskExecutionDetails", a.TaskExecutionDetails)
	populate(objectMap, "taskId", a.TaskID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureIaaSVMJobTaskDetails.
func (a *AzureIaaSVMJobTaskDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "duration":
			err = unpopulate(val, "Duration", &a.Duration)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulateTimeRFC3339(val, "EndTime", &a.EndTime)
			delete(rawMsg, key)
		case "instanceId":
			err = unpopulate(val, "InstanceID", &a.InstanceID)
			delete(rawMsg, key)
		case "progressPercentage":
			err = unpopulate(val, "ProgressPercentage", &a.ProgressPercentage)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &a.StartTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &a.Status)
			delete(rawMsg, key)
		case "taskExecutionDetails":
			err = unpopulate(val, "TaskExecutionDetails", &a.TaskExecutionDetails)
			delete(rawMsg, key)
		case "taskId":
			err = unpopulate(val, "TaskID", &a.TaskID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureIaaSVMJobV2.
func (a AzureIaaSVMJobV2) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "actionsInfo", a.ActionsInfo)
	populate(objectMap, "activityId", a.ActivityID)
	populate(objectMap, "backupManagementType", a.BackupManagementType)
	populate(objectMap, "containerName", a.ContainerName)
	populate(objectMap, "duration", a.Duration)
	populateTimeRFC3339(objectMap, "endTime", a.EndTime)
	populate(objectMap, "entityFriendlyName", a.EntityFriendlyName)
	populate(objectMap, "errorDetails", a.ErrorDetails)
	populate(objectMap, "extendedInfo", a.ExtendedInfo)
	objectMap["jobType"] = "AzureIaaSVMJobV2"
	populate(objectMap, "operation", a.Operation)
	populateTimeRFC3339(objectMap, "startTime", a.StartTime)
	populate(objectMap, "status", a.Status)
	populate(objectMap, "virtualMachineVersion", a.VirtualMachineVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureIaaSVMJobV2.
func (a *AzureIaaSVMJobV2) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actionsInfo":
			err = unpopulate(val, "ActionsInfo", &a.ActionsInfo)
			delete(rawMsg, key)
		case "activityId":
			err = unpopulate(val, "ActivityID", &a.ActivityID)
			delete(rawMsg, key)
		case "backupManagementType":
			err = unpopulate(val, "BackupManagementType", &a.BackupManagementType)
			delete(rawMsg, key)
		case "containerName":
			err = unpopulate(val, "ContainerName", &a.ContainerName)
			delete(rawMsg, key)
		case "duration":
			err = unpopulate(val, "Duration", &a.Duration)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulateTimeRFC3339(val, "EndTime", &a.EndTime)
			delete(rawMsg, key)
		case "entityFriendlyName":
			err = unpopulate(val, "EntityFriendlyName", &a.EntityFriendlyName)
			delete(rawMsg, key)
		case "errorDetails":
			err = unpopulate(val, "ErrorDetails", &a.ErrorDetails)
			delete(rawMsg, key)
		case "extendedInfo":
			err = unpopulate(val, "ExtendedInfo", &a.ExtendedInfo)
			delete(rawMsg, key)
		case "jobType":
			err = unpopulate(val, "JobType", &a.JobType)
			delete(rawMsg, key)
		case "operation":
			err = unpopulate(val, "Operation", &a.Operation)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &a.StartTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &a.Status)
			delete(rawMsg, key)
		case "virtualMachineVersion":
			err = unpopulate(val, "VirtualMachineVersion", &a.VirtualMachineVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureIaaSVMProtectedItem.
func (a AzureIaaSVMProtectedItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "backupManagementType", a.BackupManagementType)
	populate(objectMap, "backupSetName", a.BackupSetName)
	populate(objectMap, "containerName", a.ContainerName)
	populate(objectMap, "createMode", a.CreateMode)
	populateTimeRFC3339(objectMap, "deferredDeleteTimeInUTC", a.DeferredDeleteTimeInUTC)
	populate(objectMap, "deferredDeleteTimeRemaining", a.DeferredDeleteTimeRemaining)
	populate(objectMap, "extendedInfo", a.ExtendedInfo)
	populate(objectMap, "extendedProperties", a.ExtendedProperties)
	populate(objectMap, "friendlyName", a.FriendlyName)
	populate(objectMap, "healthDetails", a.HealthDetails)
	populate(objectMap, "healthStatus", a.HealthStatus)
	populate(objectMap, "isArchiveEnabled", a.IsArchiveEnabled)
	populate(objectMap, "isDeferredDeleteScheduleUpcoming", a.IsDeferredDeleteScheduleUpcoming)
	populate(objectMap, "isRehydrate", a.IsRehydrate)
	populate(objectMap, "isScheduledForDeferredDelete", a.IsScheduledForDeferredDelete)
	populate(objectMap, "kpisHealths", a.KpisHealths)
	populate(objectMap, "lastBackupStatus", a.LastBackupStatus)
	populateTimeRFC3339(objectMap, "lastBackupTime", a.LastBackupTime)
	populateTimeRFC3339(objectMap, "lastRecoveryPoint", a.LastRecoveryPoint)
	populate(objectMap, "policyId", a.PolicyID)
	populate(objectMap, "policyName", a.PolicyName)
	populate(objectMap, "protectedItemDataId", a.ProtectedItemDataID)
	objectMap["protectedItemType"] = "AzureIaaSVMProtectedItem"
	populate(objectMap, "protectionState", a.ProtectionState)
	populate(objectMap, "protectionStatus", a.ProtectionStatus)
	populate(objectMap, "resourceGuardOperationRequests", a.ResourceGuardOperationRequests)
	populate(objectMap, "sourceResourceId", a.SourceResourceID)
	populate(objectMap, "virtualMachineId", a.VirtualMachineID)
	populate(objectMap, "workloadType", a.WorkloadType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureIaaSVMProtectedItem.
func (a *AzureIaaSVMProtectedItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupManagementType":
			err = unpopulate(val, "BackupManagementType", &a.BackupManagementType)
			delete(rawMsg, key)
		case "backupSetName":
			err = unpopulate(val, "BackupSetName", &a.BackupSetName)
			delete(rawMsg, key)
		case "containerName":
			err = unpopulate(val, "ContainerName", &a.ContainerName)
			delete(rawMsg, key)
		case "createMode":
			err = unpopulate(val, "CreateMode", &a.CreateMode)
			delete(rawMsg, key)
		case "deferredDeleteTimeInUTC":
			err = unpopulateTimeRFC3339(val, "DeferredDeleteTimeInUTC", &a.DeferredDeleteTimeInUTC)
			delete(rawMsg, key)
		case "deferredDeleteTimeRemaining":
			err = unpopulate(val, "DeferredDeleteTimeRemaining", &a.DeferredDeleteTimeRemaining)
			delete(rawMsg, key)
		case "extendedInfo":
			err = unpopulate(val, "ExtendedInfo", &a.ExtendedInfo)
			delete(rawMsg, key)
		case "extendedProperties":
			err = unpopulate(val, "ExtendedProperties", &a.ExtendedProperties)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &a.FriendlyName)
			delete(rawMsg, key)
		case "healthDetails":
			err = unpopulate(val, "HealthDetails", &a.HealthDetails)
			delete(rawMsg, key)
		case "healthStatus":
			err = unpopulate(val, "HealthStatus", &a.HealthStatus)
			delete(rawMsg, key)
		case "isArchiveEnabled":
			err = unpopulate(val, "IsArchiveEnabled", &a.IsArchiveEnabled)
			delete(rawMsg, key)
		case "isDeferredDeleteScheduleUpcoming":
			err = unpopulate(val, "IsDeferredDeleteScheduleUpcoming", &a.IsDeferredDeleteScheduleUpcoming)
			delete(rawMsg, key)
		case "isRehydrate":
			err = unpopulate(val, "IsRehydrate", &a.IsRehydrate)
			delete(rawMsg, key)
		case "isScheduledForDeferredDelete":
			err = unpopulate(val, "IsScheduledForDeferredDelete", &a.IsScheduledForDeferredDelete)
			delete(rawMsg, key)
		case "kpisHealths":
			err = unpopulate(val, "KpisHealths", &a.KpisHealths)
			delete(rawMsg, key)
		case "lastBackupStatus":
			err = unpopulate(val, "LastBackupStatus", &a.LastBackupStatus)
			delete(rawMsg, key)
		case "lastBackupTime":
			err = unpopulateTimeRFC3339(val, "LastBackupTime", &a.LastBackupTime)
			delete(rawMsg, key)
		case "lastRecoveryPoint":
			err = unpopulateTimeRFC3339(val, "LastRecoveryPoint", &a.LastRecoveryPoint)
			delete(rawMsg, key)
		case "policyId":
			err = unpopulate(val, "PolicyID", &a.PolicyID)
			delete(rawMsg, key)
		case "policyName":
			err = unpopulate(val, "PolicyName", &a.PolicyName)
			delete(rawMsg, key)
		case "protectedItemDataId":
			err = unpopulate(val, "ProtectedItemDataID", &a.ProtectedItemDataID)
			delete(rawMsg, key)
		case "protectedItemType":
			err = unpopulate(val, "ProtectedItemType", &a.ProtectedItemType)
			delete(rawMsg, key)
		case "protectionState":
			err = unpopulate(val, "ProtectionState", &a.ProtectionState)
			delete(rawMsg, key)
		case "protectionStatus":
			err = unpopulate(val, "ProtectionStatus", &a.ProtectionStatus)
			delete(rawMsg, key)
		case "resourceGuardOperationRequests":
			err = unpopulate(val, "ResourceGuardOperationRequests", &a.ResourceGuardOperationRequests)
			delete(rawMsg, key)
		case "sourceResourceId":
			err = unpopulate(val, "SourceResourceID", &a.SourceResourceID)
			delete(rawMsg, key)
		case "virtualMachineId":
			err = unpopulate(val, "VirtualMachineID", &a.VirtualMachineID)
			delete(rawMsg, key)
		case "workloadType":
			err = unpopulate(val, "WorkloadType", &a.WorkloadType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureIaaSVMProtectedItemExtendedInfo.
func (a AzureIaaSVMProtectedItemExtendedInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "oldestRecoveryPoint", a.OldestRecoveryPoint)
	populate(objectMap, "policyInconsistent", a.PolicyInconsistent)
	populate(objectMap, "recoveryPointCount", a.RecoveryPointCount)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureIaaSVMProtectedItemExtendedInfo.
func (a *AzureIaaSVMProtectedItemExtendedInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "oldestRecoveryPoint":
			err = unpopulateTimeRFC3339(val, "OldestRecoveryPoint", &a.OldestRecoveryPoint)
			delete(rawMsg, key)
		case "policyInconsistent":
			err = unpopulate(val, "PolicyInconsistent", &a.PolicyInconsistent)
			delete(rawMsg, key)
		case "recoveryPointCount":
			err = unpopulate(val, "RecoveryPointCount", &a.RecoveryPointCount)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureIaaSVMProtectionPolicy.
func (a AzureIaaSVMProtectionPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["backupManagementType"] = "AzureIaasVM"
	populate(objectMap, "instantRPDetails", a.InstantRPDetails)
	populate(objectMap, "instantRpRetentionRangeInDays", a.InstantRpRetentionRangeInDays)
	populate(objectMap, "policyType", a.PolicyType)
	populate(objectMap, "protectedItemsCount", a.ProtectedItemsCount)
	populate(objectMap, "resourceGuardOperationRequests", a.ResourceGuardOperationRequests)
	populate(objectMap, "retentionPolicy", a.RetentionPolicy)
	populate(objectMap, "schedulePolicy", a.SchedulePolicy)
	populate(objectMap, "timeZone", a.TimeZone)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureIaaSVMProtectionPolicy.
func (a *AzureIaaSVMProtectionPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupManagementType":
			err = unpopulate(val, "BackupManagementType", &a.BackupManagementType)
			delete(rawMsg, key)
		case "instantRPDetails":
			err = unpopulate(val, "InstantRPDetails", &a.InstantRPDetails)
			delete(rawMsg, key)
		case "instantRpRetentionRangeInDays":
			err = unpopulate(val, "InstantRpRetentionRangeInDays", &a.InstantRpRetentionRangeInDays)
			delete(rawMsg, key)
		case "policyType":
			err = unpopulate(val, "PolicyType", &a.PolicyType)
			delete(rawMsg, key)
		case "protectedItemsCount":
			err = unpopulate(val, "ProtectedItemsCount", &a.ProtectedItemsCount)
			delete(rawMsg, key)
		case "resourceGuardOperationRequests":
			err = unpopulate(val, "ResourceGuardOperationRequests", &a.ResourceGuardOperationRequests)
			delete(rawMsg, key)
		case "retentionPolicy":
			a.RetentionPolicy, err = unmarshalRetentionPolicyClassification(val)
			delete(rawMsg, key)
		case "schedulePolicy":
			a.SchedulePolicy, err = unmarshalSchedulePolicyClassification(val)
			delete(rawMsg, key)
		case "timeZone":
			err = unpopulate(val, "TimeZone", &a.TimeZone)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureRecoveryServiceVaultProtectionIntent.
func (a AzureRecoveryServiceVaultProtectionIntent) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "backupManagementType", a.BackupManagementType)
	populate(objectMap, "itemId", a.ItemID)
	populate(objectMap, "policyId", a.PolicyID)
	objectMap["protectionIntentItemType"] = ProtectionIntentItemTypeRecoveryServiceVaultItem
	populate(objectMap, "protectionState", a.ProtectionState)
	populate(objectMap, "sourceResourceId", a.SourceResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureRecoveryServiceVaultProtectionIntent.
func (a *AzureRecoveryServiceVaultProtectionIntent) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupManagementType":
			err = unpopulate(val, "BackupManagementType", &a.BackupManagementType)
			delete(rawMsg, key)
		case "itemId":
			err = unpopulate(val, "ItemID", &a.ItemID)
			delete(rawMsg, key)
		case "policyId":
			err = unpopulate(val, "PolicyID", &a.PolicyID)
			delete(rawMsg, key)
		case "protectionIntentItemType":
			err = unpopulate(val, "ProtectionIntentItemType", &a.ProtectionIntentItemType)
			delete(rawMsg, key)
		case "protectionState":
			err = unpopulate(val, "ProtectionState", &a.ProtectionState)
			delete(rawMsg, key)
		case "sourceResourceId":
			err = unpopulate(val, "SourceResourceID", &a.SourceResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureResourceProtectionIntent.
func (a AzureResourceProtectionIntent) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "backupManagementType", a.BackupManagementType)
	populate(objectMap, "friendlyName", a.FriendlyName)
	populate(objectMap, "itemId", a.ItemID)
	populate(objectMap, "policyId", a.PolicyID)
	objectMap["protectionIntentItemType"] = ProtectionIntentItemTypeAzureResourceItem
	populate(objectMap, "protectionState", a.ProtectionState)
	populate(objectMap, "sourceResourceId", a.SourceResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureResourceProtectionIntent.
func (a *AzureResourceProtectionIntent) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupManagementType":
			err = unpopulate(val, "BackupManagementType", &a.BackupManagementType)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &a.FriendlyName)
			delete(rawMsg, key)
		case "itemId":
			err = unpopulate(val, "ItemID", &a.ItemID)
			delete(rawMsg, key)
		case "policyId":
			err = unpopulate(val, "PolicyID", &a.PolicyID)
			delete(rawMsg, key)
		case "protectionIntentItemType":
			err = unpopulate(val, "ProtectionIntentItemType", &a.ProtectionIntentItemType)
			delete(rawMsg, key)
		case "protectionState":
			err = unpopulate(val, "ProtectionState", &a.ProtectionState)
			delete(rawMsg, key)
		case "sourceResourceId":
			err = unpopulate(val, "SourceResourceID", &a.SourceResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureSQLAGWorkloadContainerProtectionContainer.
func (a AzureSQLAGWorkloadContainerProtectionContainer) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "backupManagementType", a.BackupManagementType)
	objectMap["containerType"] = ContainerTypeSQLAGWorkLoadContainer
	populate(objectMap, "extendedInfo", a.ExtendedInfo)
	populate(objectMap, "friendlyName", a.FriendlyName)
	populate(objectMap, "healthStatus", a.HealthStatus)
	populateTimeRFC3339(objectMap, "lastUpdatedTime", a.LastUpdatedTime)
	populate(objectMap, "operationType", a.OperationType)
	populate(objectMap, "protectableObjectType", a.ProtectableObjectType)
	populate(objectMap, "registrationStatus", a.RegistrationStatus)
	populate(objectMap, "sourceResourceId", a.SourceResourceID)
	populate(objectMap, "workloadType", a.WorkloadType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureSQLAGWorkloadContainerProtectionContainer.
func (a *AzureSQLAGWorkloadContainerProtectionContainer) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupManagementType":
			err = unpopulate(val, "BackupManagementType", &a.BackupManagementType)
			delete(rawMsg, key)
		case "containerType":
			err = unpopulate(val, "ContainerType", &a.ContainerType)
			delete(rawMsg, key)
		case "extendedInfo":
			err = unpopulate(val, "ExtendedInfo", &a.ExtendedInfo)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &a.FriendlyName)
			delete(rawMsg, key)
		case "healthStatus":
			err = unpopulate(val, "HealthStatus", &a.HealthStatus)
			delete(rawMsg, key)
		case "lastUpdatedTime":
			err = unpopulateTimeRFC3339(val, "LastUpdatedTime", &a.LastUpdatedTime)
			delete(rawMsg, key)
		case "operationType":
			err = unpopulate(val, "OperationType", &a.OperationType)
			delete(rawMsg, key)
		case "protectableObjectType":
			err = unpopulate(val, "ProtectableObjectType", &a.ProtectableObjectType)
			delete(rawMsg, key)
		case "registrationStatus":
			err = unpopulate(val, "RegistrationStatus", &a.RegistrationStatus)
			delete(rawMsg, key)
		case "sourceResourceId":
			err = unpopulate(val, "SourceResourceID", &a.SourceResourceID)
			delete(rawMsg, key)
		case "workloadType":
			err = unpopulate(val, "WorkloadType", &a.WorkloadType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureSQLContainer.
func (a AzureSQLContainer) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "backupManagementType", a.BackupManagementType)
	objectMap["containerType"] = ContainerTypeAzureSQLContainer
	populate(objectMap, "friendlyName", a.FriendlyName)
	populate(objectMap, "healthStatus", a.HealthStatus)
	populate(objectMap, "protectableObjectType", a.ProtectableObjectType)
	populate(objectMap, "registrationStatus", a.RegistrationStatus)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureSQLContainer.
func (a *AzureSQLContainer) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupManagementType":
			err = unpopulate(val, "BackupManagementType", &a.BackupManagementType)
			delete(rawMsg, key)
		case "containerType":
			err = unpopulate(val, "ContainerType", &a.ContainerType)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &a.FriendlyName)
			delete(rawMsg, key)
		case "healthStatus":
			err = unpopulate(val, "HealthStatus", &a.HealthStatus)
			delete(rawMsg, key)
		case "protectableObjectType":
			err = unpopulate(val, "ProtectableObjectType", &a.ProtectableObjectType)
			delete(rawMsg, key)
		case "registrationStatus":
			err = unpopulate(val, "RegistrationStatus", &a.RegistrationStatus)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureSQLProtectedItem.
func (a AzureSQLProtectedItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "backupManagementType", a.BackupManagementType)
	populate(objectMap, "backupSetName", a.BackupSetName)
	populate(objectMap, "containerName", a.ContainerName)
	populate(objectMap, "createMode", a.CreateMode)
	populateTimeRFC3339(objectMap, "deferredDeleteTimeInUTC", a.DeferredDeleteTimeInUTC)
	populate(objectMap, "deferredDeleteTimeRemaining", a.DeferredDeleteTimeRemaining)
	populate(objectMap, "extendedInfo", a.ExtendedInfo)
	populate(objectMap, "isArchiveEnabled", a.IsArchiveEnabled)
	populate(objectMap, "isDeferredDeleteScheduleUpcoming", a.IsDeferredDeleteScheduleUpcoming)
	populate(objectMap, "isRehydrate", a.IsRehydrate)
	populate(objectMap, "isScheduledForDeferredDelete", a.IsScheduledForDeferredDelete)
	populateTimeRFC3339(objectMap, "lastRecoveryPoint", a.LastRecoveryPoint)
	populate(objectMap, "policyId", a.PolicyID)
	populate(objectMap, "policyName", a.PolicyName)
	populate(objectMap, "protectedItemDataId", a.ProtectedItemDataID)
	objectMap["protectedItemType"] = "Microsoft.Sql/servers/databases"
	populate(objectMap, "protectionState", a.ProtectionState)
	populate(objectMap, "resourceGuardOperationRequests", a.ResourceGuardOperationRequests)
	populate(objectMap, "sourceResourceId", a.SourceResourceID)
	populate(objectMap, "workloadType", a.WorkloadType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureSQLProtectedItem.
func (a *AzureSQLProtectedItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupManagementType":
			err = unpopulate(val, "BackupManagementType", &a.BackupManagementType)
			delete(rawMsg, key)
		case "backupSetName":
			err = unpopulate(val, "BackupSetName", &a.BackupSetName)
			delete(rawMsg, key)
		case "containerName":
			err = unpopulate(val, "ContainerName", &a.ContainerName)
			delete(rawMsg, key)
		case "createMode":
			err = unpopulate(val, "CreateMode", &a.CreateMode)
			delete(rawMsg, key)
		case "deferredDeleteTimeInUTC":
			err = unpopulateTimeRFC3339(val, "DeferredDeleteTimeInUTC", &a.DeferredDeleteTimeInUTC)
			delete(rawMsg, key)
		case "deferredDeleteTimeRemaining":
			err = unpopulate(val, "DeferredDeleteTimeRemaining", &a.DeferredDeleteTimeRemaining)
			delete(rawMsg, key)
		case "extendedInfo":
			err = unpopulate(val, "ExtendedInfo", &a.ExtendedInfo)
			delete(rawMsg, key)
		case "isArchiveEnabled":
			err = unpopulate(val, "IsArchiveEnabled", &a.IsArchiveEnabled)
			delete(rawMsg, key)
		case "isDeferredDeleteScheduleUpcoming":
			err = unpopulate(val, "IsDeferredDeleteScheduleUpcoming", &a.IsDeferredDeleteScheduleUpcoming)
			delete(rawMsg, key)
		case "isRehydrate":
			err = unpopulate(val, "IsRehydrate", &a.IsRehydrate)
			delete(rawMsg, key)
		case "isScheduledForDeferredDelete":
			err = unpopulate(val, "IsScheduledForDeferredDelete", &a.IsScheduledForDeferredDelete)
			delete(rawMsg, key)
		case "lastRecoveryPoint":
			err = unpopulateTimeRFC3339(val, "LastRecoveryPoint", &a.LastRecoveryPoint)
			delete(rawMsg, key)
		case "policyId":
			err = unpopulate(val, "PolicyID", &a.PolicyID)
			delete(rawMsg, key)
		case "policyName":
			err = unpopulate(val, "PolicyName", &a.PolicyName)
			delete(rawMsg, key)
		case "protectedItemDataId":
			err = unpopulate(val, "ProtectedItemDataID", &a.ProtectedItemDataID)
			delete(rawMsg, key)
		case "protectedItemType":
			err = unpopulate(val, "ProtectedItemType", &a.ProtectedItemType)
			delete(rawMsg, key)
		case "protectionState":
			err = unpopulate(val, "ProtectionState", &a.ProtectionState)
			delete(rawMsg, key)
		case "resourceGuardOperationRequests":
			err = unpopulate(val, "ResourceGuardOperationRequests", &a.ResourceGuardOperationRequests)
			delete(rawMsg, key)
		case "sourceResourceId":
			err = unpopulate(val, "SourceResourceID", &a.SourceResourceID)
			delete(rawMsg, key)
		case "workloadType":
			err = unpopulate(val, "WorkloadType", &a.WorkloadType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureSQLProtectedItemExtendedInfo.
func (a AzureSQLProtectedItemExtendedInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "oldestRecoveryPoint", a.OldestRecoveryPoint)
	populate(objectMap, "policyState", a.PolicyState)
	populate(objectMap, "recoveryPointCount", a.RecoveryPointCount)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureSQLProtectedItemExtendedInfo.
func (a *AzureSQLProtectedItemExtendedInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "oldestRecoveryPoint":
			err = unpopulateTimeRFC3339(val, "OldestRecoveryPoint", &a.OldestRecoveryPoint)
			delete(rawMsg, key)
		case "policyState":
			err = unpopulate(val, "PolicyState", &a.PolicyState)
			delete(rawMsg, key)
		case "recoveryPointCount":
			err = unpopulate(val, "RecoveryPointCount", &a.RecoveryPointCount)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureSQLProtectionPolicy.
func (a AzureSQLProtectionPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["backupManagementType"] = "AzureSql"
	populate(objectMap, "protectedItemsCount", a.ProtectedItemsCount)
	populate(objectMap, "resourceGuardOperationRequests", a.ResourceGuardOperationRequests)
	populate(objectMap, "retentionPolicy", a.RetentionPolicy)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureSQLProtectionPolicy.
func (a *AzureSQLProtectionPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupManagementType":
			err = unpopulate(val, "BackupManagementType", &a.BackupManagementType)
			delete(rawMsg, key)
		case "protectedItemsCount":
			err = unpopulate(val, "ProtectedItemsCount", &a.ProtectedItemsCount)
			delete(rawMsg, key)
		case "resourceGuardOperationRequests":
			err = unpopulate(val, "ResourceGuardOperationRequests", &a.ResourceGuardOperationRequests)
			delete(rawMsg, key)
		case "retentionPolicy":
			a.RetentionPolicy, err = unmarshalRetentionPolicyClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureStorageContainer.
func (a AzureStorageContainer) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "acquireStorageAccountLock", a.AcquireStorageAccountLock)
	populate(objectMap, "backupManagementType", a.BackupManagementType)
	objectMap["containerType"] = ContainerTypeStorageContainer
	populate(objectMap, "friendlyName", a.FriendlyName)
	populate(objectMap, "healthStatus", a.HealthStatus)
	populate(objectMap, "protectableObjectType", a.ProtectableObjectType)
	populate(objectMap, "protectedItemCount", a.ProtectedItemCount)
	populate(objectMap, "registrationStatus", a.RegistrationStatus)
	populate(objectMap, "resourceGroup", a.ResourceGroup)
	populate(objectMap, "sourceResourceId", a.SourceResourceID)
	populate(objectMap, "storageAccountVersion", a.StorageAccountVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureStorageContainer.
func (a *AzureStorageContainer) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "acquireStorageAccountLock":
			err = unpopulate(val, "AcquireStorageAccountLock", &a.AcquireStorageAccountLock)
			delete(rawMsg, key)
		case "backupManagementType":
			err = unpopulate(val, "BackupManagementType", &a.BackupManagementType)
			delete(rawMsg, key)
		case "containerType":
			err = unpopulate(val, "ContainerType", &a.ContainerType)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &a.FriendlyName)
			delete(rawMsg, key)
		case "healthStatus":
			err = unpopulate(val, "HealthStatus", &a.HealthStatus)
			delete(rawMsg, key)
		case "protectableObjectType":
			err = unpopulate(val, "ProtectableObjectType", &a.ProtectableObjectType)
			delete(rawMsg, key)
		case "protectedItemCount":
			err = unpopulate(val, "ProtectedItemCount", &a.ProtectedItemCount)
			delete(rawMsg, key)
		case "registrationStatus":
			err = unpopulate(val, "RegistrationStatus", &a.RegistrationStatus)
			delete(rawMsg, key)
		case "resourceGroup":
			err = unpopulate(val, "ResourceGroup", &a.ResourceGroup)
			delete(rawMsg, key)
		case "sourceResourceId":
			err = unpopulate(val, "SourceResourceID", &a.SourceResourceID)
			delete(rawMsg, key)
		case "storageAccountVersion":
			err = unpopulate(val, "StorageAccountVersion", &a.StorageAccountVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureStorageErrorInfo.
func (a AzureStorageErrorInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "errorCode", a.ErrorCode)
	populate(objectMap, "errorString", a.ErrorString)
	populate(objectMap, "recommendations", a.Recommendations)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type AzureStorageJob.
func (a AzureStorageJob) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "actionsInfo", a.ActionsInfo)
	populate(objectMap, "activityId", a.ActivityID)
	populate(objectMap, "backupManagementType", a.BackupManagementType)
	populate(objectMap, "duration", a.Duration)
	populateTimeRFC3339(objectMap, "endTime", a.EndTime)
	populate(objectMap, "entityFriendlyName", a.EntityFriendlyName)
	populate(objectMap, "errorDetails", a.ErrorDetails)
	populate(objectMap, "extendedInfo", a.ExtendedInfo)
	populate(objectMap, "isUserTriggered", a.IsUserTriggered)
	objectMap["jobType"] = "AzureStorageJob"
	populate(objectMap, "operation", a.Operation)
	populateTimeRFC3339(objectMap, "startTime", a.StartTime)
	populate(objectMap, "status", a.Status)
	populate(objectMap, "storageAccountName", a.StorageAccountName)
	populate(objectMap, "storageAccountVersion", a.StorageAccountVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureStorageJob.
func (a *AzureStorageJob) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actionsInfo":
			err = unpopulate(val, "ActionsInfo", &a.ActionsInfo)
			delete(rawMsg, key)
		case "activityId":
			err = unpopulate(val, "ActivityID", &a.ActivityID)
			delete(rawMsg, key)
		case "backupManagementType":
			err = unpopulate(val, "BackupManagementType", &a.BackupManagementType)
			delete(rawMsg, key)
		case "duration":
			err = unpopulate(val, "Duration", &a.Duration)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulateTimeRFC3339(val, "EndTime", &a.EndTime)
			delete(rawMsg, key)
		case "entityFriendlyName":
			err = unpopulate(val, "EntityFriendlyName", &a.EntityFriendlyName)
			delete(rawMsg, key)
		case "errorDetails":
			err = unpopulate(val, "ErrorDetails", &a.ErrorDetails)
			delete(rawMsg, key)
		case "extendedInfo":
			err = unpopulate(val, "ExtendedInfo", &a.ExtendedInfo)
			delete(rawMsg, key)
		case "isUserTriggered":
			err = unpopulate(val, "IsUserTriggered", &a.IsUserTriggered)
			delete(rawMsg, key)
		case "jobType":
			err = unpopulate(val, "JobType", &a.JobType)
			delete(rawMsg, key)
		case "operation":
			err = unpopulate(val, "Operation", &a.Operation)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &a.StartTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &a.Status)
			delete(rawMsg, key)
		case "storageAccountName":
			err = unpopulate(val, "StorageAccountName", &a.StorageAccountName)
			delete(rawMsg, key)
		case "storageAccountVersion":
			err = unpopulate(val, "StorageAccountVersion", &a.StorageAccountVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureStorageJobExtendedInfo.
func (a AzureStorageJobExtendedInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "dynamicErrorMessage", a.DynamicErrorMessage)
	populate(objectMap, "propertyBag", a.PropertyBag)
	populate(objectMap, "tasksList", a.TasksList)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type AzureStorageProtectableContainer.
func (a AzureStorageProtectableContainer) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "backupManagementType", a.BackupManagementType)
	populate(objectMap, "containerId", a.ContainerID)
	populate(objectMap, "friendlyName", a.FriendlyName)
	populate(objectMap, "healthStatus", a.HealthStatus)
	objectMap["protectableContainerType"] = ContainerTypeStorageContainer
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureStorageProtectableContainer.
func (a *AzureStorageProtectableContainer) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupManagementType":
			err = unpopulate(val, "BackupManagementType", &a.BackupManagementType)
			delete(rawMsg, key)
		case "containerId":
			err = unpopulate(val, "ContainerID", &a.ContainerID)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &a.FriendlyName)
			delete(rawMsg, key)
		case "healthStatus":
			err = unpopulate(val, "HealthStatus", &a.HealthStatus)
			delete(rawMsg, key)
		case "protectableContainerType":
			err = unpopulate(val, "ProtectableContainerType", &a.ProtectableContainerType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureVMAppContainerProtectableContainer.
func (a AzureVMAppContainerProtectableContainer) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "backupManagementType", a.BackupManagementType)
	populate(objectMap, "containerId", a.ContainerID)
	populate(objectMap, "friendlyName", a.FriendlyName)
	populate(objectMap, "healthStatus", a.HealthStatus)
	objectMap["protectableContainerType"] = ContainerTypeVMAppContainer
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureVMAppContainerProtectableContainer.
func (a *AzureVMAppContainerProtectableContainer) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupManagementType":
			err = unpopulate(val, "BackupManagementType", &a.BackupManagementType)
			delete(rawMsg, key)
		case "containerId":
			err = unpopulate(val, "ContainerID", &a.ContainerID)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &a.FriendlyName)
			delete(rawMsg, key)
		case "healthStatus":
			err = unpopulate(val, "HealthStatus", &a.HealthStatus)
			delete(rawMsg, key)
		case "protectableContainerType":
			err = unpopulate(val, "ProtectableContainerType", &a.ProtectableContainerType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureVMAppContainerProtectionContainer.
func (a AzureVMAppContainerProtectionContainer) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "backupManagementType", a.BackupManagementType)
	objectMap["containerType"] = ContainerTypeVMAppContainer
	populate(objectMap, "extendedInfo", a.ExtendedInfo)
	populate(objectMap, "friendlyName", a.FriendlyName)
	populate(objectMap, "healthStatus", a.HealthStatus)
	populateTimeRFC3339(objectMap, "lastUpdatedTime", a.LastUpdatedTime)
	populate(objectMap, "operationType", a.OperationType)
	populate(objectMap, "protectableObjectType", a.ProtectableObjectType)
	populate(objectMap, "registrationStatus", a.RegistrationStatus)
	populate(objectMap, "sourceResourceId", a.SourceResourceID)
	populate(objectMap, "workloadType", a.WorkloadType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureVMAppContainerProtectionContainer.
func (a *AzureVMAppContainerProtectionContainer) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupManagementType":
			err = unpopulate(val, "BackupManagementType", &a.BackupManagementType)
			delete(rawMsg, key)
		case "containerType":
			err = unpopulate(val, "ContainerType", &a.ContainerType)
			delete(rawMsg, key)
		case "extendedInfo":
			err = unpopulate(val, "ExtendedInfo", &a.ExtendedInfo)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &a.FriendlyName)
			delete(rawMsg, key)
		case "healthStatus":
			err = unpopulate(val, "HealthStatus", &a.HealthStatus)
			delete(rawMsg, key)
		case "lastUpdatedTime":
			err = unpopulateTimeRFC3339(val, "LastUpdatedTime", &a.LastUpdatedTime)
			delete(rawMsg, key)
		case "operationType":
			err = unpopulate(val, "OperationType", &a.OperationType)
			delete(rawMsg, key)
		case "protectableObjectType":
			err = unpopulate(val, "ProtectableObjectType", &a.ProtectableObjectType)
			delete(rawMsg, key)
		case "registrationStatus":
			err = unpopulate(val, "RegistrationStatus", &a.RegistrationStatus)
			delete(rawMsg, key)
		case "sourceResourceId":
			err = unpopulate(val, "SourceResourceID", &a.SourceResourceID)
			delete(rawMsg, key)
		case "workloadType":
			err = unpopulate(val, "WorkloadType", &a.WorkloadType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureVMResourceFeatureSupportRequest.
func (a AzureVMResourceFeatureSupportRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["featureType"] = "AzureVMResourceBackup"
	populate(objectMap, "vmSku", a.VMSKU)
	populate(objectMap, "vmSize", a.VMSize)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureVMResourceFeatureSupportRequest.
func (a *AzureVMResourceFeatureSupportRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "featureType":
			err = unpopulate(val, "FeatureType", &a.FeatureType)
			delete(rawMsg, key)
		case "vmSku":
			err = unpopulate(val, "VMSKU", &a.VMSKU)
			delete(rawMsg, key)
		case "vmSize":
			err = unpopulate(val, "VMSize", &a.VMSize)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureVMWorkloadItem.
func (a AzureVMWorkloadItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "backupManagementType", a.BackupManagementType)
	populate(objectMap, "friendlyName", a.FriendlyName)
	populate(objectMap, "isAutoProtectable", a.IsAutoProtectable)
	populate(objectMap, "parentName", a.ParentName)
	populate(objectMap, "protectionState", a.ProtectionState)
	populate(objectMap, "serverName", a.ServerName)
	populate(objectMap, "subWorkloadItemCount", a.SubWorkloadItemCount)
	populate(objectMap, "subinquireditemcount", a.Subinquireditemcount)
	objectMap["workloadItemType"] = "AzureVmWorkloadItem"
	populate(objectMap, "workloadType", a.WorkloadType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureVMWorkloadItem.
func (a *AzureVMWorkloadItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupManagementType":
			err = unpopulate(val, "BackupManagementType", &a.BackupManagementType)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &a.FriendlyName)
			delete(rawMsg, key)
		case "isAutoProtectable":
			err = unpopulate(val, "IsAutoProtectable", &a.IsAutoProtectable)
			delete(rawMsg, key)
		case "parentName":
			err = unpopulate(val, "ParentName", &a.ParentName)
			delete(rawMsg, key)
		case "protectionState":
			err = unpopulate(val, "ProtectionState", &a.ProtectionState)
			delete(rawMsg, key)
		case "serverName":
			err = unpopulate(val, "ServerName", &a.ServerName)
			delete(rawMsg, key)
		case "subWorkloadItemCount":
			err = unpopulate(val, "SubWorkloadItemCount", &a.SubWorkloadItemCount)
			delete(rawMsg, key)
		case "subinquireditemcount":
			err = unpopulate(val, "Subinquireditemcount", &a.Subinquireditemcount)
			delete(rawMsg, key)
		case "workloadItemType":
			err = unpopulate(val, "WorkloadItemType", &a.WorkloadItemType)
			delete(rawMsg, key)
		case "workloadType":
			err = unpopulate(val, "WorkloadType", &a.WorkloadType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureVMWorkloadProtectableItem.
func (a AzureVMWorkloadProtectableItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "backupManagementType", a.BackupManagementType)
	populate(objectMap, "friendlyName", a.FriendlyName)
	populate(objectMap, "isAutoProtectable", a.IsAutoProtectable)
	populate(objectMap, "isAutoProtected", a.IsAutoProtected)
	populate(objectMap, "parentName", a.ParentName)
	populate(objectMap, "parentUniqueName", a.ParentUniqueName)
	populate(objectMap, "prebackupvalidation", a.Prebackupvalidation)
	objectMap["protectableItemType"] = "AzureVmWorkloadProtectableItem"
	populate(objectMap, "protectionState", a.ProtectionState)
	populate(objectMap, "serverName", a.ServerName)
	populate(objectMap, "subinquireditemcount", a.Subinquireditemcount)
	populate(objectMap, "subprotectableitemcount", a.Subprotectableitemcount)
	populate(objectMap, "workloadType", a.WorkloadType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureVMWorkloadProtectableItem.
func (a *AzureVMWorkloadProtectableItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupManagementType":
			err = unpopulate(val, "BackupManagementType", &a.BackupManagementType)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &a.FriendlyName)
			delete(rawMsg, key)
		case "isAutoProtectable":
			err = unpopulate(val, "IsAutoProtectable", &a.IsAutoProtectable)
			delete(rawMsg, key)
		case "isAutoProtected":
			err = unpopulate(val, "IsAutoProtected", &a.IsAutoProtected)
			delete(rawMsg, key)
		case "parentName":
			err = unpopulate(val, "ParentName", &a.ParentName)
			delete(rawMsg, key)
		case "parentUniqueName":
			err = unpopulate(val, "ParentUniqueName", &a.ParentUniqueName)
			delete(rawMsg, key)
		case "prebackupvalidation":
			err = unpopulate(val, "Prebackupvalidation", &a.Prebackupvalidation)
			delete(rawMsg, key)
		case "protectableItemType":
			err = unpopulate(val, "ProtectableItemType", &a.ProtectableItemType)
			delete(rawMsg, key)
		case "protectionState":
			err = unpopulate(val, "ProtectionState", &a.ProtectionState)
			delete(rawMsg, key)
		case "serverName":
			err = unpopulate(val, "ServerName", &a.ServerName)
			delete(rawMsg, key)
		case "subinquireditemcount":
			err = unpopulate(val, "Subinquireditemcount", &a.Subinquireditemcount)
			delete(rawMsg, key)
		case "subprotectableitemcount":
			err = unpopulate(val, "Subprotectableitemcount", &a.Subprotectableitemcount)
			delete(rawMsg, key)
		case "workloadType":
			err = unpopulate(val, "WorkloadType", &a.WorkloadType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureVMWorkloadProtectedItem.
func (a AzureVMWorkloadProtectedItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "backupManagementType", a.BackupManagementType)
	populate(objectMap, "backupSetName", a.BackupSetName)
	populate(objectMap, "containerName", a.ContainerName)
	populate(objectMap, "createMode", a.CreateMode)
	populateTimeRFC3339(objectMap, "deferredDeleteTimeInUTC", a.DeferredDeleteTimeInUTC)
	populate(objectMap, "deferredDeleteTimeRemaining", a.DeferredDeleteTimeRemaining)
	populate(objectMap, "extendedInfo", a.ExtendedInfo)
	populate(objectMap, "friendlyName", a.FriendlyName)
	populate(objectMap, "isArchiveEnabled", a.IsArchiveEnabled)
	populate(objectMap, "isDeferredDeleteScheduleUpcoming", a.IsDeferredDeleteScheduleUpcoming)
	populate(objectMap, "isRehydrate", a.IsRehydrate)
	populate(objectMap, "isScheduledForDeferredDelete", a.IsScheduledForDeferredDelete)
	populate(objectMap, "kpisHealths", a.KpisHealths)
	populate(objectMap, "lastBackupErrorDetail", a.LastBackupErrorDetail)
	populate(objectMap, "lastBackupStatus", a.LastBackupStatus)
	populateTimeRFC3339(objectMap, "lastBackupTime", a.LastBackupTime)
	populateTimeRFC3339(objectMap, "lastRecoveryPoint", a.LastRecoveryPoint)
	populate(objectMap, "parentName", a.ParentName)
	populate(objectMap, "parentType", a.ParentType)
	populate(objectMap, "policyId", a.PolicyID)
	populate(objectMap, "policyName", a.PolicyName)
	populate(objectMap, "protectedItemDataSourceId", a.ProtectedItemDataSourceID)
	populate(objectMap, "protectedItemHealthStatus", a.ProtectedItemHealthStatus)
	objectMap["protectedItemType"] = "AzureVmWorkloadProtectedItem"
	populate(objectMap, "protectionState", a.ProtectionState)
	populate(objectMap, "protectionStatus", a.ProtectionStatus)
	populate(objectMap, "resourceGuardOperationRequests", a.ResourceGuardOperationRequests)
	populate(objectMap, "serverName", a.ServerName)
	populate(objectMap, "sourceResourceId", a.SourceResourceID)
	populate(objectMap, "workloadType", a.WorkloadType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureVMWorkloadProtectedItem.
func (a *AzureVMWorkloadProtectedItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupManagementType":
			err = unpopulate(val, "BackupManagementType", &a.BackupManagementType)
			delete(rawMsg, key)
		case "backupSetName":
			err = unpopulate(val, "BackupSetName", &a.BackupSetName)
			delete(rawMsg, key)
		case "containerName":
			err = unpopulate(val, "ContainerName", &a.ContainerName)
			delete(rawMsg, key)
		case "createMode":
			err = unpopulate(val, "CreateMode", &a.CreateMode)
			delete(rawMsg, key)
		case "deferredDeleteTimeInUTC":
			err = unpopulateTimeRFC3339(val, "DeferredDeleteTimeInUTC", &a.DeferredDeleteTimeInUTC)
			delete(rawMsg, key)
		case "deferredDeleteTimeRemaining":
			err = unpopulate(val, "DeferredDeleteTimeRemaining", &a.DeferredDeleteTimeRemaining)
			delete(rawMsg, key)
		case "extendedInfo":
			err = unpopulate(val, "ExtendedInfo", &a.ExtendedInfo)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &a.FriendlyName)
			delete(rawMsg, key)
		case "isArchiveEnabled":
			err = unpopulate(val, "IsArchiveEnabled", &a.IsArchiveEnabled)
			delete(rawMsg, key)
		case "isDeferredDeleteScheduleUpcoming":
			err = unpopulate(val, "IsDeferredDeleteScheduleUpcoming", &a.IsDeferredDeleteScheduleUpcoming)
			delete(rawMsg, key)
		case "isRehydrate":
			err = unpopulate(val, "IsRehydrate", &a.IsRehydrate)
			delete(rawMsg, key)
		case "isScheduledForDeferredDelete":
			err = unpopulate(val, "IsScheduledForDeferredDelete", &a.IsScheduledForDeferredDelete)
			delete(rawMsg, key)
		case "kpisHealths":
			err = unpopulate(val, "KpisHealths", &a.KpisHealths)
			delete(rawMsg, key)
		case "lastBackupErrorDetail":
			err = unpopulate(val, "LastBackupErrorDetail", &a.LastBackupErrorDetail)
			delete(rawMsg, key)
		case "lastBackupStatus":
			err = unpopulate(val, "LastBackupStatus", &a.LastBackupStatus)
			delete(rawMsg, key)
		case "lastBackupTime":
			err = unpopulateTimeRFC3339(val, "LastBackupTime", &a.LastBackupTime)
			delete(rawMsg, key)
		case "lastRecoveryPoint":
			err = unpopulateTimeRFC3339(val, "LastRecoveryPoint", &a.LastRecoveryPoint)
			delete(rawMsg, key)
		case "parentName":
			err = unpopulate(val, "ParentName", &a.ParentName)
			delete(rawMsg, key)
		case "parentType":
			err = unpopulate(val, "ParentType", &a.ParentType)
			delete(rawMsg, key)
		case "policyId":
			err = unpopulate(val, "PolicyID", &a.PolicyID)
			delete(rawMsg, key)
		case "policyName":
			err = unpopulate(val, "PolicyName", &a.PolicyName)
			delete(rawMsg, key)
		case "protectedItemDataSourceId":
			err = unpopulate(val, "ProtectedItemDataSourceID", &a.ProtectedItemDataSourceID)
			delete(rawMsg, key)
		case "protectedItemHealthStatus":
			err = unpopulate(val, "ProtectedItemHealthStatus", &a.ProtectedItemHealthStatus)
			delete(rawMsg, key)
		case "protectedItemType":
			err = unpopulate(val, "ProtectedItemType", &a.ProtectedItemType)
			delete(rawMsg, key)
		case "protectionState":
			err = unpopulate(val, "ProtectionState", &a.ProtectionState)
			delete(rawMsg, key)
		case "protectionStatus":
			err = unpopulate(val, "ProtectionStatus", &a.ProtectionStatus)
			delete(rawMsg, key)
		case "resourceGuardOperationRequests":
			err = unpopulate(val, "ResourceGuardOperationRequests", &a.ResourceGuardOperationRequests)
			delete(rawMsg, key)
		case "serverName":
			err = unpopulate(val, "ServerName", &a.ServerName)
			delete(rawMsg, key)
		case "sourceResourceId":
			err = unpopulate(val, "SourceResourceID", &a.SourceResourceID)
			delete(rawMsg, key)
		case "workloadType":
			err = unpopulate(val, "WorkloadType", &a.WorkloadType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureVMWorkloadProtectedItemExtendedInfo.
func (a AzureVMWorkloadProtectedItemExtendedInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "oldestRecoveryPoint", a.OldestRecoveryPoint)
	populate(objectMap, "policyState", a.PolicyState)
	populate(objectMap, "recoveryModel", a.RecoveryModel)
	populate(objectMap, "recoveryPointCount", a.RecoveryPointCount)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureVMWorkloadProtectedItemExtendedInfo.
func (a *AzureVMWorkloadProtectedItemExtendedInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "oldestRecoveryPoint":
			err = unpopulateTimeRFC3339(val, "OldestRecoveryPoint", &a.OldestRecoveryPoint)
			delete(rawMsg, key)
		case "policyState":
			err = unpopulate(val, "PolicyState", &a.PolicyState)
			delete(rawMsg, key)
		case "recoveryModel":
			err = unpopulate(val, "RecoveryModel", &a.RecoveryModel)
			delete(rawMsg, key)
		case "recoveryPointCount":
			err = unpopulate(val, "RecoveryPointCount", &a.RecoveryPointCount)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureVMWorkloadProtectionPolicy.
func (a AzureVMWorkloadProtectionPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["backupManagementType"] = "AzureWorkload"
	populate(objectMap, "makePolicyConsistent", a.MakePolicyConsistent)
	populate(objectMap, "protectedItemsCount", a.ProtectedItemsCount)
	populate(objectMap, "resourceGuardOperationRequests", a.ResourceGuardOperationRequests)
	populate(objectMap, "settings", a.Settings)
	populate(objectMap, "subProtectionPolicy", a.SubProtectionPolicy)
	populate(objectMap, "workLoadType", a.WorkLoadType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureVMWorkloadProtectionPolicy.
func (a *AzureVMWorkloadProtectionPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupManagementType":
			err = unpopulate(val, "BackupManagementType", &a.BackupManagementType)
			delete(rawMsg, key)
		case "makePolicyConsistent":
			err = unpopulate(val, "MakePolicyConsistent", &a.MakePolicyConsistent)
			delete(rawMsg, key)
		case "protectedItemsCount":
			err = unpopulate(val, "ProtectedItemsCount", &a.ProtectedItemsCount)
			delete(rawMsg, key)
		case "resourceGuardOperationRequests":
			err = unpopulate(val, "ResourceGuardOperationRequests", &a.ResourceGuardOperationRequests)
			delete(rawMsg, key)
		case "settings":
			err = unpopulate(val, "Settings", &a.Settings)
			delete(rawMsg, key)
		case "subProtectionPolicy":
			err = unpopulate(val, "SubProtectionPolicy", &a.SubProtectionPolicy)
			delete(rawMsg, key)
		case "workLoadType":
			err = unpopulate(val, "WorkLoadType", &a.WorkLoadType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureVMWorkloadSAPAseDatabaseProtectedItem.
func (a AzureVMWorkloadSAPAseDatabaseProtectedItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "backupManagementType", a.BackupManagementType)
	populate(objectMap, "backupSetName", a.BackupSetName)
	populate(objectMap, "containerName", a.ContainerName)
	populate(objectMap, "createMode", a.CreateMode)
	populateTimeRFC3339(objectMap, "deferredDeleteTimeInUTC", a.DeferredDeleteTimeInUTC)
	populate(objectMap, "deferredDeleteTimeRemaining", a.DeferredDeleteTimeRemaining)
	populate(objectMap, "extendedInfo", a.ExtendedInfo)
	populate(objectMap, "friendlyName", a.FriendlyName)
	populate(objectMap, "isArchiveEnabled", a.IsArchiveEnabled)
	populate(objectMap, "isDeferredDeleteScheduleUpcoming", a.IsDeferredDeleteScheduleUpcoming)
	populate(objectMap, "isRehydrate", a.IsRehydrate)
	populate(objectMap, "isScheduledForDeferredDelete", a.IsScheduledForDeferredDelete)
	populate(objectMap, "kpisHealths", a.KpisHealths)
	populate(objectMap, "lastBackupErrorDetail", a.LastBackupErrorDetail)
	populate(objectMap, "lastBackupStatus", a.LastBackupStatus)
	populateTimeRFC3339(objectMap, "lastBackupTime", a.LastBackupTime)
	populateTimeRFC3339(objectMap, "lastRecoveryPoint", a.LastRecoveryPoint)
	populate(objectMap, "parentName", a.ParentName)
	populate(objectMap, "parentType", a.ParentType)
	populate(objectMap, "policyId", a.PolicyID)
	populate(objectMap, "policyName", a.PolicyName)
	populate(objectMap, "protectedItemDataSourceId", a.ProtectedItemDataSourceID)
	populate(objectMap, "protectedItemHealthStatus", a.ProtectedItemHealthStatus)
	objectMap["protectedItemType"] = "AzureVmWorkloadSAPAseDatabase"
	populate(objectMap, "protectionState", a.ProtectionState)
	populate(objectMap, "protectionStatus", a.ProtectionStatus)
	populate(objectMap, "resourceGuardOperationRequests", a.ResourceGuardOperationRequests)
	populate(objectMap, "serverName", a.ServerName)
	populate(objectMap, "sourceResourceId", a.SourceResourceID)
	populate(objectMap, "workloadType", a.WorkloadType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureVMWorkloadSAPAseDatabaseProtectedItem.
func (a *AzureVMWorkloadSAPAseDatabaseProtectedItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupManagementType":
			err = unpopulate(val, "BackupManagementType", &a.BackupManagementType)
			delete(rawMsg, key)
		case "backupSetName":
			err = unpopulate(val, "BackupSetName", &a.BackupSetName)
			delete(rawMsg, key)
		case "containerName":
			err = unpopulate(val, "ContainerName", &a.ContainerName)
			delete(rawMsg, key)
		case "createMode":
			err = unpopulate(val, "CreateMode", &a.CreateMode)
			delete(rawMsg, key)
		case "deferredDeleteTimeInUTC":
			err = unpopulateTimeRFC3339(val, "DeferredDeleteTimeInUTC", &a.DeferredDeleteTimeInUTC)
			delete(rawMsg, key)
		case "deferredDeleteTimeRemaining":
			err = unpopulate(val, "DeferredDeleteTimeRemaining", &a.DeferredDeleteTimeRemaining)
			delete(rawMsg, key)
		case "extendedInfo":
			err = unpopulate(val, "ExtendedInfo", &a.ExtendedInfo)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &a.FriendlyName)
			delete(rawMsg, key)
		case "isArchiveEnabled":
			err = unpopulate(val, "IsArchiveEnabled", &a.IsArchiveEnabled)
			delete(rawMsg, key)
		case "isDeferredDeleteScheduleUpcoming":
			err = unpopulate(val, "IsDeferredDeleteScheduleUpcoming", &a.IsDeferredDeleteScheduleUpcoming)
			delete(rawMsg, key)
		case "isRehydrate":
			err = unpopulate(val, "IsRehydrate", &a.IsRehydrate)
			delete(rawMsg, key)
		case "isScheduledForDeferredDelete":
			err = unpopulate(val, "IsScheduledForDeferredDelete", &a.IsScheduledForDeferredDelete)
			delete(rawMsg, key)
		case "kpisHealths":
			err = unpopulate(val, "KpisHealths", &a.KpisHealths)
			delete(rawMsg, key)
		case "lastBackupErrorDetail":
			err = unpopulate(val, "LastBackupErrorDetail", &a.LastBackupErrorDetail)
			delete(rawMsg, key)
		case "lastBackupStatus":
			err = unpopulate(val, "LastBackupStatus", &a.LastBackupStatus)
			delete(rawMsg, key)
		case "lastBackupTime":
			err = unpopulateTimeRFC3339(val, "LastBackupTime", &a.LastBackupTime)
			delete(rawMsg, key)
		case "lastRecoveryPoint":
			err = unpopulateTimeRFC3339(val, "LastRecoveryPoint", &a.LastRecoveryPoint)
			delete(rawMsg, key)
		case "parentName":
			err = unpopulate(val, "ParentName", &a.ParentName)
			delete(rawMsg, key)
		case "parentType":
			err = unpopulate(val, "ParentType", &a.ParentType)
			delete(rawMsg, key)
		case "policyId":
			err = unpopulate(val, "PolicyID", &a.PolicyID)
			delete(rawMsg, key)
		case "policyName":
			err = unpopulate(val, "PolicyName", &a.PolicyName)
			delete(rawMsg, key)
		case "protectedItemDataSourceId":
			err = unpopulate(val, "ProtectedItemDataSourceID", &a.ProtectedItemDataSourceID)
			delete(rawMsg, key)
		case "protectedItemHealthStatus":
			err = unpopulate(val, "ProtectedItemHealthStatus", &a.ProtectedItemHealthStatus)
			delete(rawMsg, key)
		case "protectedItemType":
			err = unpopulate(val, "ProtectedItemType", &a.ProtectedItemType)
			delete(rawMsg, key)
		case "protectionState":
			err = unpopulate(val, "ProtectionState", &a.ProtectionState)
			delete(rawMsg, key)
		case "protectionStatus":
			err = unpopulate(val, "ProtectionStatus", &a.ProtectionStatus)
			delete(rawMsg, key)
		case "resourceGuardOperationRequests":
			err = unpopulate(val, "ResourceGuardOperationRequests", &a.ResourceGuardOperationRequests)
			delete(rawMsg, key)
		case "serverName":
			err = unpopulate(val, "ServerName", &a.ServerName)
			delete(rawMsg, key)
		case "sourceResourceId":
			err = unpopulate(val, "SourceResourceID", &a.SourceResourceID)
			delete(rawMsg, key)
		case "workloadType":
			err = unpopulate(val, "WorkloadType", &a.WorkloadType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureVMWorkloadSAPAseDatabaseWorkloadItem.
func (a AzureVMWorkloadSAPAseDatabaseWorkloadItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "backupManagementType", a.BackupManagementType)
	populate(objectMap, "friendlyName", a.FriendlyName)
	populate(objectMap, "isAutoProtectable", a.IsAutoProtectable)
	populate(objectMap, "parentName", a.ParentName)
	populate(objectMap, "protectionState", a.ProtectionState)
	populate(objectMap, "serverName", a.ServerName)
	populate(objectMap, "subWorkloadItemCount", a.SubWorkloadItemCount)
	populate(objectMap, "subinquireditemcount", a.Subinquireditemcount)
	objectMap["workloadItemType"] = "SAPAseDatabase"
	populate(objectMap, "workloadType", a.WorkloadType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureVMWorkloadSAPAseDatabaseWorkloadItem.
func (a *AzureVMWorkloadSAPAseDatabaseWorkloadItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupManagementType":
			err = unpopulate(val, "BackupManagementType", &a.BackupManagementType)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &a.FriendlyName)
			delete(rawMsg, key)
		case "isAutoProtectable":
			err = unpopulate(val, "IsAutoProtectable", &a.IsAutoProtectable)
			delete(rawMsg, key)
		case "parentName":
			err = unpopulate(val, "ParentName", &a.ParentName)
			delete(rawMsg, key)
		case "protectionState":
			err = unpopulate(val, "ProtectionState", &a.ProtectionState)
			delete(rawMsg, key)
		case "serverName":
			err = unpopulate(val, "ServerName", &a.ServerName)
			delete(rawMsg, key)
		case "subWorkloadItemCount":
			err = unpopulate(val, "SubWorkloadItemCount", &a.SubWorkloadItemCount)
			delete(rawMsg, key)
		case "subinquireditemcount":
			err = unpopulate(val, "Subinquireditemcount", &a.Subinquireditemcount)
			delete(rawMsg, key)
		case "workloadItemType":
			err = unpopulate(val, "WorkloadItemType", &a.WorkloadItemType)
			delete(rawMsg, key)
		case "workloadType":
			err = unpopulate(val, "WorkloadType", &a.WorkloadType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureVMWorkloadSAPAseSystemProtectableItem.
func (a AzureVMWorkloadSAPAseSystemProtectableItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "backupManagementType", a.BackupManagementType)
	populate(objectMap, "friendlyName", a.FriendlyName)
	populate(objectMap, "isAutoProtectable", a.IsAutoProtectable)
	populate(objectMap, "isAutoProtected", a.IsAutoProtected)
	populate(objectMap, "parentName", a.ParentName)
	populate(objectMap, "parentUniqueName", a.ParentUniqueName)
	populate(objectMap, "prebackupvalidation", a.Prebackupvalidation)
	objectMap["protectableItemType"] = "SAPAseSystem"
	populate(objectMap, "protectionState", a.ProtectionState)
	populate(objectMap, "serverName", a.ServerName)
	populate(objectMap, "subinquireditemcount", a.Subinquireditemcount)
	populate(objectMap, "subprotectableitemcount", a.Subprotectableitemcount)
	populate(objectMap, "workloadType", a.WorkloadType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureVMWorkloadSAPAseSystemProtectableItem.
func (a *AzureVMWorkloadSAPAseSystemProtectableItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupManagementType":
			err = unpopulate(val, "BackupManagementType", &a.BackupManagementType)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &a.FriendlyName)
			delete(rawMsg, key)
		case "isAutoProtectable":
			err = unpopulate(val, "IsAutoProtectable", &a.IsAutoProtectable)
			delete(rawMsg, key)
		case "isAutoProtected":
			err = unpopulate(val, "IsAutoProtected", &a.IsAutoProtected)
			delete(rawMsg, key)
		case "parentName":
			err = unpopulate(val, "ParentName", &a.ParentName)
			delete(rawMsg, key)
		case "parentUniqueName":
			err = unpopulate(val, "ParentUniqueName", &a.ParentUniqueName)
			delete(rawMsg, key)
		case "prebackupvalidation":
			err = unpopulate(val, "Prebackupvalidation", &a.Prebackupvalidation)
			delete(rawMsg, key)
		case "protectableItemType":
			err = unpopulate(val, "ProtectableItemType", &a.ProtectableItemType)
			delete(rawMsg, key)
		case "protectionState":
			err = unpopulate(val, "ProtectionState", &a.ProtectionState)
			delete(rawMsg, key)
		case "serverName":
			err = unpopulate(val, "ServerName", &a.ServerName)
			delete(rawMsg, key)
		case "subinquireditemcount":
			err = unpopulate(val, "Subinquireditemcount", &a.Subinquireditemcount)
			delete(rawMsg, key)
		case "subprotectableitemcount":
			err = unpopulate(val, "Subprotectableitemcount", &a.Subprotectableitemcount)
			delete(rawMsg, key)
		case "workloadType":
			err = unpopulate(val, "WorkloadType", &a.WorkloadType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureVMWorkloadSAPAseSystemWorkloadItem.
func (a AzureVMWorkloadSAPAseSystemWorkloadItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "backupManagementType", a.BackupManagementType)
	populate(objectMap, "friendlyName", a.FriendlyName)
	populate(objectMap, "isAutoProtectable", a.IsAutoProtectable)
	populate(objectMap, "parentName", a.ParentName)
	populate(objectMap, "protectionState", a.ProtectionState)
	populate(objectMap, "serverName", a.ServerName)
	populate(objectMap, "subWorkloadItemCount", a.SubWorkloadItemCount)
	populate(objectMap, "subinquireditemcount", a.Subinquireditemcount)
	objectMap["workloadItemType"] = "SAPAseSystem"
	populate(objectMap, "workloadType", a.WorkloadType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureVMWorkloadSAPAseSystemWorkloadItem.
func (a *AzureVMWorkloadSAPAseSystemWorkloadItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupManagementType":
			err = unpopulate(val, "BackupManagementType", &a.BackupManagementType)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &a.FriendlyName)
			delete(rawMsg, key)
		case "isAutoProtectable":
			err = unpopulate(val, "IsAutoProtectable", &a.IsAutoProtectable)
			delete(rawMsg, key)
		case "parentName":
			err = unpopulate(val, "ParentName", &a.ParentName)
			delete(rawMsg, key)
		case "protectionState":
			err = unpopulate(val, "ProtectionState", &a.ProtectionState)
			delete(rawMsg, key)
		case "serverName":
			err = unpopulate(val, "ServerName", &a.ServerName)
			delete(rawMsg, key)
		case "subWorkloadItemCount":
			err = unpopulate(val, "SubWorkloadItemCount", &a.SubWorkloadItemCount)
			delete(rawMsg, key)
		case "subinquireditemcount":
			err = unpopulate(val, "Subinquireditemcount", &a.Subinquireditemcount)
			delete(rawMsg, key)
		case "workloadItemType":
			err = unpopulate(val, "WorkloadItemType", &a.WorkloadItemType)
			delete(rawMsg, key)
		case "workloadType":
			err = unpopulate(val, "WorkloadType", &a.WorkloadType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureVMWorkloadSAPHanaDatabaseProtectableItem.
func (a AzureVMWorkloadSAPHanaDatabaseProtectableItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "backupManagementType", a.BackupManagementType)
	populate(objectMap, "friendlyName", a.FriendlyName)
	populate(objectMap, "isAutoProtectable", a.IsAutoProtectable)
	populate(objectMap, "isAutoProtected", a.IsAutoProtected)
	populate(objectMap, "parentName", a.ParentName)
	populate(objectMap, "parentUniqueName", a.ParentUniqueName)
	populate(objectMap, "prebackupvalidation", a.Prebackupvalidation)
	objectMap["protectableItemType"] = "SAPHanaDatabase"
	populate(objectMap, "protectionState", a.ProtectionState)
	populate(objectMap, "serverName", a.ServerName)
	populate(objectMap, "subinquireditemcount", a.Subinquireditemcount)
	populate(objectMap, "subprotectableitemcount", a.Subprotectableitemcount)
	populate(objectMap, "workloadType", a.WorkloadType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureVMWorkloadSAPHanaDatabaseProtectableItem.
func (a *AzureVMWorkloadSAPHanaDatabaseProtectableItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupManagementType":
			err = unpopulate(val, "BackupManagementType", &a.BackupManagementType)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &a.FriendlyName)
			delete(rawMsg, key)
		case "isAutoProtectable":
			err = unpopulate(val, "IsAutoProtectable", &a.IsAutoProtectable)
			delete(rawMsg, key)
		case "isAutoProtected":
			err = unpopulate(val, "IsAutoProtected", &a.IsAutoProtected)
			delete(rawMsg, key)
		case "parentName":
			err = unpopulate(val, "ParentName", &a.ParentName)
			delete(rawMsg, key)
		case "parentUniqueName":
			err = unpopulate(val, "ParentUniqueName", &a.ParentUniqueName)
			delete(rawMsg, key)
		case "prebackupvalidation":
			err = unpopulate(val, "Prebackupvalidation", &a.Prebackupvalidation)
			delete(rawMsg, key)
		case "protectableItemType":
			err = unpopulate(val, "ProtectableItemType", &a.ProtectableItemType)
			delete(rawMsg, key)
		case "protectionState":
			err = unpopulate(val, "ProtectionState", &a.ProtectionState)
			delete(rawMsg, key)
		case "serverName":
			err = unpopulate(val, "ServerName", &a.ServerName)
			delete(rawMsg, key)
		case "subinquireditemcount":
			err = unpopulate(val, "Subinquireditemcount", &a.Subinquireditemcount)
			delete(rawMsg, key)
		case "subprotectableitemcount":
			err = unpopulate(val, "Subprotectableitemcount", &a.Subprotectableitemcount)
			delete(rawMsg, key)
		case "workloadType":
			err = unpopulate(val, "WorkloadType", &a.WorkloadType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureVMWorkloadSAPHanaDatabaseProtectedItem.
func (a AzureVMWorkloadSAPHanaDatabaseProtectedItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "backupManagementType", a.BackupManagementType)
	populate(objectMap, "backupSetName", a.BackupSetName)
	populate(objectMap, "containerName", a.ContainerName)
	populate(objectMap, "createMode", a.CreateMode)
	populateTimeRFC3339(objectMap, "deferredDeleteTimeInUTC", a.DeferredDeleteTimeInUTC)
	populate(objectMap, "deferredDeleteTimeRemaining", a.DeferredDeleteTimeRemaining)
	populate(objectMap, "extendedInfo", a.ExtendedInfo)
	populate(objectMap, "friendlyName", a.FriendlyName)
	populate(objectMap, "isArchiveEnabled", a.IsArchiveEnabled)
	populate(objectMap, "isDeferredDeleteScheduleUpcoming", a.IsDeferredDeleteScheduleUpcoming)
	populate(objectMap, "isRehydrate", a.IsRehydrate)
	populate(objectMap, "isScheduledForDeferredDelete", a.IsScheduledForDeferredDelete)
	populate(objectMap, "kpisHealths", a.KpisHealths)
	populate(objectMap, "lastBackupErrorDetail", a.LastBackupErrorDetail)
	populate(objectMap, "lastBackupStatus", a.LastBackupStatus)
	populateTimeRFC3339(objectMap, "lastBackupTime", a.LastBackupTime)
	populateTimeRFC3339(objectMap, "lastRecoveryPoint", a.LastRecoveryPoint)
	populate(objectMap, "parentName", a.ParentName)
	populate(objectMap, "parentType", a.ParentType)
	populate(objectMap, "policyId", a.PolicyID)
	populate(objectMap, "policyName", a.PolicyName)
	populate(objectMap, "protectedItemDataSourceId", a.ProtectedItemDataSourceID)
	populate(objectMap, "protectedItemHealthStatus", a.ProtectedItemHealthStatus)
	objectMap["protectedItemType"] = "AzureVmWorkloadSAPHanaDatabase"
	populate(objectMap, "protectionState", a.ProtectionState)
	populate(objectMap, "protectionStatus", a.ProtectionStatus)
	populate(objectMap, "resourceGuardOperationRequests", a.ResourceGuardOperationRequests)
	populate(objectMap, "serverName", a.ServerName)
	populate(objectMap, "sourceResourceId", a.SourceResourceID)
	populate(objectMap, "workloadType", a.WorkloadType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureVMWorkloadSAPHanaDatabaseProtectedItem.
func (a *AzureVMWorkloadSAPHanaDatabaseProtectedItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupManagementType":
			err = unpopulate(val, "BackupManagementType", &a.BackupManagementType)
			delete(rawMsg, key)
		case "backupSetName":
			err = unpopulate(val, "BackupSetName", &a.BackupSetName)
			delete(rawMsg, key)
		case "containerName":
			err = unpopulate(val, "ContainerName", &a.ContainerName)
			delete(rawMsg, key)
		case "createMode":
			err = unpopulate(val, "CreateMode", &a.CreateMode)
			delete(rawMsg, key)
		case "deferredDeleteTimeInUTC":
			err = unpopulateTimeRFC3339(val, "DeferredDeleteTimeInUTC", &a.DeferredDeleteTimeInUTC)
			delete(rawMsg, key)
		case "deferredDeleteTimeRemaining":
			err = unpopulate(val, "DeferredDeleteTimeRemaining", &a.DeferredDeleteTimeRemaining)
			delete(rawMsg, key)
		case "extendedInfo":
			err = unpopulate(val, "ExtendedInfo", &a.ExtendedInfo)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &a.FriendlyName)
			delete(rawMsg, key)
		case "isArchiveEnabled":
			err = unpopulate(val, "IsArchiveEnabled", &a.IsArchiveEnabled)
			delete(rawMsg, key)
		case "isDeferredDeleteScheduleUpcoming":
			err = unpopulate(val, "IsDeferredDeleteScheduleUpcoming", &a.IsDeferredDeleteScheduleUpcoming)
			delete(rawMsg, key)
		case "isRehydrate":
			err = unpopulate(val, "IsRehydrate", &a.IsRehydrate)
			delete(rawMsg, key)
		case "isScheduledForDeferredDelete":
			err = unpopulate(val, "IsScheduledForDeferredDelete", &a.IsScheduledForDeferredDelete)
			delete(rawMsg, key)
		case "kpisHealths":
			err = unpopulate(val, "KpisHealths", &a.KpisHealths)
			delete(rawMsg, key)
		case "lastBackupErrorDetail":
			err = unpopulate(val, "LastBackupErrorDetail", &a.LastBackupErrorDetail)
			delete(rawMsg, key)
		case "lastBackupStatus":
			err = unpopulate(val, "LastBackupStatus", &a.LastBackupStatus)
			delete(rawMsg, key)
		case "lastBackupTime":
			err = unpopulateTimeRFC3339(val, "LastBackupTime", &a.LastBackupTime)
			delete(rawMsg, key)
		case "lastRecoveryPoint":
			err = unpopulateTimeRFC3339(val, "LastRecoveryPoint", &a.LastRecoveryPoint)
			delete(rawMsg, key)
		case "parentName":
			err = unpopulate(val, "ParentName", &a.ParentName)
			delete(rawMsg, key)
		case "parentType":
			err = unpopulate(val, "ParentType", &a.ParentType)
			delete(rawMsg, key)
		case "policyId":
			err = unpopulate(val, "PolicyID", &a.PolicyID)
			delete(rawMsg, key)
		case "policyName":
			err = unpopulate(val, "PolicyName", &a.PolicyName)
			delete(rawMsg, key)
		case "protectedItemDataSourceId":
			err = unpopulate(val, "ProtectedItemDataSourceID", &a.ProtectedItemDataSourceID)
			delete(rawMsg, key)
		case "protectedItemHealthStatus":
			err = unpopulate(val, "ProtectedItemHealthStatus", &a.ProtectedItemHealthStatus)
			delete(rawMsg, key)
		case "protectedItemType":
			err = unpopulate(val, "ProtectedItemType", &a.ProtectedItemType)
			delete(rawMsg, key)
		case "protectionState":
			err = unpopulate(val, "ProtectionState", &a.ProtectionState)
			delete(rawMsg, key)
		case "protectionStatus":
			err = unpopulate(val, "ProtectionStatus", &a.ProtectionStatus)
			delete(rawMsg, key)
		case "resourceGuardOperationRequests":
			err = unpopulate(val, "ResourceGuardOperationRequests", &a.ResourceGuardOperationRequests)
			delete(rawMsg, key)
		case "serverName":
			err = unpopulate(val, "ServerName", &a.ServerName)
			delete(rawMsg, key)
		case "sourceResourceId":
			err = unpopulate(val, "SourceResourceID", &a.SourceResourceID)
			delete(rawMsg, key)
		case "workloadType":
			err = unpopulate(val, "WorkloadType", &a.WorkloadType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureVMWorkloadSAPHanaDatabaseWorkloadItem.
func (a AzureVMWorkloadSAPHanaDatabaseWorkloadItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "backupManagementType", a.BackupManagementType)
	populate(objectMap, "friendlyName", a.FriendlyName)
	populate(objectMap, "isAutoProtectable", a.IsAutoProtectable)
	populate(objectMap, "parentName", a.ParentName)
	populate(objectMap, "protectionState", a.ProtectionState)
	populate(objectMap, "serverName", a.ServerName)
	populate(objectMap, "subWorkloadItemCount", a.SubWorkloadItemCount)
	populate(objectMap, "subinquireditemcount", a.Subinquireditemcount)
	objectMap["workloadItemType"] = "SAPHanaDatabase"
	populate(objectMap, "workloadType", a.WorkloadType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureVMWorkloadSAPHanaDatabaseWorkloadItem.
func (a *AzureVMWorkloadSAPHanaDatabaseWorkloadItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupManagementType":
			err = unpopulate(val, "BackupManagementType", &a.BackupManagementType)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &a.FriendlyName)
			delete(rawMsg, key)
		case "isAutoProtectable":
			err = unpopulate(val, "IsAutoProtectable", &a.IsAutoProtectable)
			delete(rawMsg, key)
		case "parentName":
			err = unpopulate(val, "ParentName", &a.ParentName)
			delete(rawMsg, key)
		case "protectionState":
			err = unpopulate(val, "ProtectionState", &a.ProtectionState)
			delete(rawMsg, key)
		case "serverName":
			err = unpopulate(val, "ServerName", &a.ServerName)
			delete(rawMsg, key)
		case "subWorkloadItemCount":
			err = unpopulate(val, "SubWorkloadItemCount", &a.SubWorkloadItemCount)
			delete(rawMsg, key)
		case "subinquireditemcount":
			err = unpopulate(val, "Subinquireditemcount", &a.Subinquireditemcount)
			delete(rawMsg, key)
		case "workloadItemType":
			err = unpopulate(val, "WorkloadItemType", &a.WorkloadItemType)
			delete(rawMsg, key)
		case "workloadType":
			err = unpopulate(val, "WorkloadType", &a.WorkloadType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureVMWorkloadSAPHanaSystemProtectableItem.
func (a AzureVMWorkloadSAPHanaSystemProtectableItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "backupManagementType", a.BackupManagementType)
	populate(objectMap, "friendlyName", a.FriendlyName)
	populate(objectMap, "isAutoProtectable", a.IsAutoProtectable)
	populate(objectMap, "isAutoProtected", a.IsAutoProtected)
	populate(objectMap, "parentName", a.ParentName)
	populate(objectMap, "parentUniqueName", a.ParentUniqueName)
	populate(objectMap, "prebackupvalidation", a.Prebackupvalidation)
	objectMap["protectableItemType"] = "SAPHanaSystem"
	populate(objectMap, "protectionState", a.ProtectionState)
	populate(objectMap, "serverName", a.ServerName)
	populate(objectMap, "subinquireditemcount", a.Subinquireditemcount)
	populate(objectMap, "subprotectableitemcount", a.Subprotectableitemcount)
	populate(objectMap, "workloadType", a.WorkloadType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureVMWorkloadSAPHanaSystemProtectableItem.
func (a *AzureVMWorkloadSAPHanaSystemProtectableItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupManagementType":
			err = unpopulate(val, "BackupManagementType", &a.BackupManagementType)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &a.FriendlyName)
			delete(rawMsg, key)
		case "isAutoProtectable":
			err = unpopulate(val, "IsAutoProtectable", &a.IsAutoProtectable)
			delete(rawMsg, key)
		case "isAutoProtected":
			err = unpopulate(val, "IsAutoProtected", &a.IsAutoProtected)
			delete(rawMsg, key)
		case "parentName":
			err = unpopulate(val, "ParentName", &a.ParentName)
			delete(rawMsg, key)
		case "parentUniqueName":
			err = unpopulate(val, "ParentUniqueName", &a.ParentUniqueName)
			delete(rawMsg, key)
		case "prebackupvalidation":
			err = unpopulate(val, "Prebackupvalidation", &a.Prebackupvalidation)
			delete(rawMsg, key)
		case "protectableItemType":
			err = unpopulate(val, "ProtectableItemType", &a.ProtectableItemType)
			delete(rawMsg, key)
		case "protectionState":
			err = unpopulate(val, "ProtectionState", &a.ProtectionState)
			delete(rawMsg, key)
		case "serverName":
			err = unpopulate(val, "ServerName", &a.ServerName)
			delete(rawMsg, key)
		case "subinquireditemcount":
			err = unpopulate(val, "Subinquireditemcount", &a.Subinquireditemcount)
			delete(rawMsg, key)
		case "subprotectableitemcount":
			err = unpopulate(val, "Subprotectableitemcount", &a.Subprotectableitemcount)
			delete(rawMsg, key)
		case "workloadType":
			err = unpopulate(val, "WorkloadType", &a.WorkloadType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureVMWorkloadSAPHanaSystemWorkloadItem.
func (a AzureVMWorkloadSAPHanaSystemWorkloadItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "backupManagementType", a.BackupManagementType)
	populate(objectMap, "friendlyName", a.FriendlyName)
	populate(objectMap, "isAutoProtectable", a.IsAutoProtectable)
	populate(objectMap, "parentName", a.ParentName)
	populate(objectMap, "protectionState", a.ProtectionState)
	populate(objectMap, "serverName", a.ServerName)
	populate(objectMap, "subWorkloadItemCount", a.SubWorkloadItemCount)
	populate(objectMap, "subinquireditemcount", a.Subinquireditemcount)
	objectMap["workloadItemType"] = "SAPHanaSystem"
	populate(objectMap, "workloadType", a.WorkloadType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureVMWorkloadSAPHanaSystemWorkloadItem.
func (a *AzureVMWorkloadSAPHanaSystemWorkloadItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupManagementType":
			err = unpopulate(val, "BackupManagementType", &a.BackupManagementType)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &a.FriendlyName)
			delete(rawMsg, key)
		case "isAutoProtectable":
			err = unpopulate(val, "IsAutoProtectable", &a.IsAutoProtectable)
			delete(rawMsg, key)
		case "parentName":
			err = unpopulate(val, "ParentName", &a.ParentName)
			delete(rawMsg, key)
		case "protectionState":
			err = unpopulate(val, "ProtectionState", &a.ProtectionState)
			delete(rawMsg, key)
		case "serverName":
			err = unpopulate(val, "ServerName", &a.ServerName)
			delete(rawMsg, key)
		case "subWorkloadItemCount":
			err = unpopulate(val, "SubWorkloadItemCount", &a.SubWorkloadItemCount)
			delete(rawMsg, key)
		case "subinquireditemcount":
			err = unpopulate(val, "Subinquireditemcount", &a.Subinquireditemcount)
			delete(rawMsg, key)
		case "workloadItemType":
			err = unpopulate(val, "WorkloadItemType", &a.WorkloadItemType)
			delete(rawMsg, key)
		case "workloadType":
			err = unpopulate(val, "WorkloadType", &a.WorkloadType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureVMWorkloadSQLAvailabilityGroupProtectableItem.
func (a AzureVMWorkloadSQLAvailabilityGroupProtectableItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "backupManagementType", a.BackupManagementType)
	populate(objectMap, "friendlyName", a.FriendlyName)
	populate(objectMap, "isAutoProtectable", a.IsAutoProtectable)
	populate(objectMap, "isAutoProtected", a.IsAutoProtected)
	populate(objectMap, "parentName", a.ParentName)
	populate(objectMap, "parentUniqueName", a.ParentUniqueName)
	populate(objectMap, "prebackupvalidation", a.Prebackupvalidation)
	objectMap["protectableItemType"] = "SQLAvailabilityGroupContainer"
	populate(objectMap, "protectionState", a.ProtectionState)
	populate(objectMap, "serverName", a.ServerName)
	populate(objectMap, "subinquireditemcount", a.Subinquireditemcount)
	populate(objectMap, "subprotectableitemcount", a.Subprotectableitemcount)
	populate(objectMap, "workloadType", a.WorkloadType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureVMWorkloadSQLAvailabilityGroupProtectableItem.
func (a *AzureVMWorkloadSQLAvailabilityGroupProtectableItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupManagementType":
			err = unpopulate(val, "BackupManagementType", &a.BackupManagementType)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &a.FriendlyName)
			delete(rawMsg, key)
		case "isAutoProtectable":
			err = unpopulate(val, "IsAutoProtectable", &a.IsAutoProtectable)
			delete(rawMsg, key)
		case "isAutoProtected":
			err = unpopulate(val, "IsAutoProtected", &a.IsAutoProtected)
			delete(rawMsg, key)
		case "parentName":
			err = unpopulate(val, "ParentName", &a.ParentName)
			delete(rawMsg, key)
		case "parentUniqueName":
			err = unpopulate(val, "ParentUniqueName", &a.ParentUniqueName)
			delete(rawMsg, key)
		case "prebackupvalidation":
			err = unpopulate(val, "Prebackupvalidation", &a.Prebackupvalidation)
			delete(rawMsg, key)
		case "protectableItemType":
			err = unpopulate(val, "ProtectableItemType", &a.ProtectableItemType)
			delete(rawMsg, key)
		case "protectionState":
			err = unpopulate(val, "ProtectionState", &a.ProtectionState)
			delete(rawMsg, key)
		case "serverName":
			err = unpopulate(val, "ServerName", &a.ServerName)
			delete(rawMsg, key)
		case "subinquireditemcount":
			err = unpopulate(val, "Subinquireditemcount", &a.Subinquireditemcount)
			delete(rawMsg, key)
		case "subprotectableitemcount":
			err = unpopulate(val, "Subprotectableitemcount", &a.Subprotectableitemcount)
			delete(rawMsg, key)
		case "workloadType":
			err = unpopulate(val, "WorkloadType", &a.WorkloadType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureVMWorkloadSQLDatabaseProtectableItem.
func (a AzureVMWorkloadSQLDatabaseProtectableItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "backupManagementType", a.BackupManagementType)
	populate(objectMap, "friendlyName", a.FriendlyName)
	populate(objectMap, "isAutoProtectable", a.IsAutoProtectable)
	populate(objectMap, "isAutoProtected", a.IsAutoProtected)
	populate(objectMap, "parentName", a.ParentName)
	populate(objectMap, "parentUniqueName", a.ParentUniqueName)
	populate(objectMap, "prebackupvalidation", a.Prebackupvalidation)
	objectMap["protectableItemType"] = "SQLDataBase"
	populate(objectMap, "protectionState", a.ProtectionState)
	populate(objectMap, "serverName", a.ServerName)
	populate(objectMap, "subinquireditemcount", a.Subinquireditemcount)
	populate(objectMap, "subprotectableitemcount", a.Subprotectableitemcount)
	populate(objectMap, "workloadType", a.WorkloadType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureVMWorkloadSQLDatabaseProtectableItem.
func (a *AzureVMWorkloadSQLDatabaseProtectableItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupManagementType":
			err = unpopulate(val, "BackupManagementType", &a.BackupManagementType)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &a.FriendlyName)
			delete(rawMsg, key)
		case "isAutoProtectable":
			err = unpopulate(val, "IsAutoProtectable", &a.IsAutoProtectable)
			delete(rawMsg, key)
		case "isAutoProtected":
			err = unpopulate(val, "IsAutoProtected", &a.IsAutoProtected)
			delete(rawMsg, key)
		case "parentName":
			err = unpopulate(val, "ParentName", &a.ParentName)
			delete(rawMsg, key)
		case "parentUniqueName":
			err = unpopulate(val, "ParentUniqueName", &a.ParentUniqueName)
			delete(rawMsg, key)
		case "prebackupvalidation":
			err = unpopulate(val, "Prebackupvalidation", &a.Prebackupvalidation)
			delete(rawMsg, key)
		case "protectableItemType":
			err = unpopulate(val, "ProtectableItemType", &a.ProtectableItemType)
			delete(rawMsg, key)
		case "protectionState":
			err = unpopulate(val, "ProtectionState", &a.ProtectionState)
			delete(rawMsg, key)
		case "serverName":
			err = unpopulate(val, "ServerName", &a.ServerName)
			delete(rawMsg, key)
		case "subinquireditemcount":
			err = unpopulate(val, "Subinquireditemcount", &a.Subinquireditemcount)
			delete(rawMsg, key)
		case "subprotectableitemcount":
			err = unpopulate(val, "Subprotectableitemcount", &a.Subprotectableitemcount)
			delete(rawMsg, key)
		case "workloadType":
			err = unpopulate(val, "WorkloadType", &a.WorkloadType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureVMWorkloadSQLDatabaseProtectedItem.
func (a AzureVMWorkloadSQLDatabaseProtectedItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "backupManagementType", a.BackupManagementType)
	populate(objectMap, "backupSetName", a.BackupSetName)
	populate(objectMap, "containerName", a.ContainerName)
	populate(objectMap, "createMode", a.CreateMode)
	populateTimeRFC3339(objectMap, "deferredDeleteTimeInUTC", a.DeferredDeleteTimeInUTC)
	populate(objectMap, "deferredDeleteTimeRemaining", a.DeferredDeleteTimeRemaining)
	populate(objectMap, "extendedInfo", a.ExtendedInfo)
	populate(objectMap, "friendlyName", a.FriendlyName)
	populate(objectMap, "isArchiveEnabled", a.IsArchiveEnabled)
	populate(objectMap, "isDeferredDeleteScheduleUpcoming", a.IsDeferredDeleteScheduleUpcoming)
	populate(objectMap, "isRehydrate", a.IsRehydrate)
	populate(objectMap, "isScheduledForDeferredDelete", a.IsScheduledForDeferredDelete)
	populate(objectMap, "kpisHealths", a.KpisHealths)
	populate(objectMap, "lastBackupErrorDetail", a.LastBackupErrorDetail)
	populate(objectMap, "lastBackupStatus", a.LastBackupStatus)
	populateTimeRFC3339(objectMap, "lastBackupTime", a.LastBackupTime)
	populateTimeRFC3339(objectMap, "lastRecoveryPoint", a.LastRecoveryPoint)
	populate(objectMap, "parentName", a.ParentName)
	populate(objectMap, "parentType", a.ParentType)
	populate(objectMap, "policyId", a.PolicyID)
	populate(objectMap, "policyName", a.PolicyName)
	populate(objectMap, "protectedItemDataSourceId", a.ProtectedItemDataSourceID)
	populate(objectMap, "protectedItemHealthStatus", a.ProtectedItemHealthStatus)
	objectMap["protectedItemType"] = "AzureVmWorkloadSQLDatabase"
	populate(objectMap, "protectionState", a.ProtectionState)
	populate(objectMap, "protectionStatus", a.ProtectionStatus)
	populate(objectMap, "resourceGuardOperationRequests", a.ResourceGuardOperationRequests)
	populate(objectMap, "serverName", a.ServerName)
	populate(objectMap, "sourceResourceId", a.SourceResourceID)
	populate(objectMap, "workloadType", a.WorkloadType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureVMWorkloadSQLDatabaseProtectedItem.
func (a *AzureVMWorkloadSQLDatabaseProtectedItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupManagementType":
			err = unpopulate(val, "BackupManagementType", &a.BackupManagementType)
			delete(rawMsg, key)
		case "backupSetName":
			err = unpopulate(val, "BackupSetName", &a.BackupSetName)
			delete(rawMsg, key)
		case "containerName":
			err = unpopulate(val, "ContainerName", &a.ContainerName)
			delete(rawMsg, key)
		case "createMode":
			err = unpopulate(val, "CreateMode", &a.CreateMode)
			delete(rawMsg, key)
		case "deferredDeleteTimeInUTC":
			err = unpopulateTimeRFC3339(val, "DeferredDeleteTimeInUTC", &a.DeferredDeleteTimeInUTC)
			delete(rawMsg, key)
		case "deferredDeleteTimeRemaining":
			err = unpopulate(val, "DeferredDeleteTimeRemaining", &a.DeferredDeleteTimeRemaining)
			delete(rawMsg, key)
		case "extendedInfo":
			err = unpopulate(val, "ExtendedInfo", &a.ExtendedInfo)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &a.FriendlyName)
			delete(rawMsg, key)
		case "isArchiveEnabled":
			err = unpopulate(val, "IsArchiveEnabled", &a.IsArchiveEnabled)
			delete(rawMsg, key)
		case "isDeferredDeleteScheduleUpcoming":
			err = unpopulate(val, "IsDeferredDeleteScheduleUpcoming", &a.IsDeferredDeleteScheduleUpcoming)
			delete(rawMsg, key)
		case "isRehydrate":
			err = unpopulate(val, "IsRehydrate", &a.IsRehydrate)
			delete(rawMsg, key)
		case "isScheduledForDeferredDelete":
			err = unpopulate(val, "IsScheduledForDeferredDelete", &a.IsScheduledForDeferredDelete)
			delete(rawMsg, key)
		case "kpisHealths":
			err = unpopulate(val, "KpisHealths", &a.KpisHealths)
			delete(rawMsg, key)
		case "lastBackupErrorDetail":
			err = unpopulate(val, "LastBackupErrorDetail", &a.LastBackupErrorDetail)
			delete(rawMsg, key)
		case "lastBackupStatus":
			err = unpopulate(val, "LastBackupStatus", &a.LastBackupStatus)
			delete(rawMsg, key)
		case "lastBackupTime":
			err = unpopulateTimeRFC3339(val, "LastBackupTime", &a.LastBackupTime)
			delete(rawMsg, key)
		case "lastRecoveryPoint":
			err = unpopulateTimeRFC3339(val, "LastRecoveryPoint", &a.LastRecoveryPoint)
			delete(rawMsg, key)
		case "parentName":
			err = unpopulate(val, "ParentName", &a.ParentName)
			delete(rawMsg, key)
		case "parentType":
			err = unpopulate(val, "ParentType", &a.ParentType)
			delete(rawMsg, key)
		case "policyId":
			err = unpopulate(val, "PolicyID", &a.PolicyID)
			delete(rawMsg, key)
		case "policyName":
			err = unpopulate(val, "PolicyName", &a.PolicyName)
			delete(rawMsg, key)
		case "protectedItemDataSourceId":
			err = unpopulate(val, "ProtectedItemDataSourceID", &a.ProtectedItemDataSourceID)
			delete(rawMsg, key)
		case "protectedItemHealthStatus":
			err = unpopulate(val, "ProtectedItemHealthStatus", &a.ProtectedItemHealthStatus)
			delete(rawMsg, key)
		case "protectedItemType":
			err = unpopulate(val, "ProtectedItemType", &a.ProtectedItemType)
			delete(rawMsg, key)
		case "protectionState":
			err = unpopulate(val, "ProtectionState", &a.ProtectionState)
			delete(rawMsg, key)
		case "protectionStatus":
			err = unpopulate(val, "ProtectionStatus", &a.ProtectionStatus)
			delete(rawMsg, key)
		case "resourceGuardOperationRequests":
			err = unpopulate(val, "ResourceGuardOperationRequests", &a.ResourceGuardOperationRequests)
			delete(rawMsg, key)
		case "serverName":
			err = unpopulate(val, "ServerName", &a.ServerName)
			delete(rawMsg, key)
		case "sourceResourceId":
			err = unpopulate(val, "SourceResourceID", &a.SourceResourceID)
			delete(rawMsg, key)
		case "workloadType":
			err = unpopulate(val, "WorkloadType", &a.WorkloadType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureVMWorkloadSQLDatabaseWorkloadItem.
func (a AzureVMWorkloadSQLDatabaseWorkloadItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "backupManagementType", a.BackupManagementType)
	populate(objectMap, "friendlyName", a.FriendlyName)
	populate(objectMap, "isAutoProtectable", a.IsAutoProtectable)
	populate(objectMap, "parentName", a.ParentName)
	populate(objectMap, "protectionState", a.ProtectionState)
	populate(objectMap, "serverName", a.ServerName)
	populate(objectMap, "subWorkloadItemCount", a.SubWorkloadItemCount)
	populate(objectMap, "subinquireditemcount", a.Subinquireditemcount)
	objectMap["workloadItemType"] = "SQLDataBase"
	populate(objectMap, "workloadType", a.WorkloadType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureVMWorkloadSQLDatabaseWorkloadItem.
func (a *AzureVMWorkloadSQLDatabaseWorkloadItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupManagementType":
			err = unpopulate(val, "BackupManagementType", &a.BackupManagementType)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &a.FriendlyName)
			delete(rawMsg, key)
		case "isAutoProtectable":
			err = unpopulate(val, "IsAutoProtectable", &a.IsAutoProtectable)
			delete(rawMsg, key)
		case "parentName":
			err = unpopulate(val, "ParentName", &a.ParentName)
			delete(rawMsg, key)
		case "protectionState":
			err = unpopulate(val, "ProtectionState", &a.ProtectionState)
			delete(rawMsg, key)
		case "serverName":
			err = unpopulate(val, "ServerName", &a.ServerName)
			delete(rawMsg, key)
		case "subWorkloadItemCount":
			err = unpopulate(val, "SubWorkloadItemCount", &a.SubWorkloadItemCount)
			delete(rawMsg, key)
		case "subinquireditemcount":
			err = unpopulate(val, "Subinquireditemcount", &a.Subinquireditemcount)
			delete(rawMsg, key)
		case "workloadItemType":
			err = unpopulate(val, "WorkloadItemType", &a.WorkloadItemType)
			delete(rawMsg, key)
		case "workloadType":
			err = unpopulate(val, "WorkloadType", &a.WorkloadType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureVMWorkloadSQLInstanceProtectableItem.
func (a AzureVMWorkloadSQLInstanceProtectableItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "backupManagementType", a.BackupManagementType)
	populate(objectMap, "friendlyName", a.FriendlyName)
	populate(objectMap, "isAutoProtectable", a.IsAutoProtectable)
	populate(objectMap, "isAutoProtected", a.IsAutoProtected)
	populate(objectMap, "parentName", a.ParentName)
	populate(objectMap, "parentUniqueName", a.ParentUniqueName)
	populate(objectMap, "prebackupvalidation", a.Prebackupvalidation)
	objectMap["protectableItemType"] = "SQLInstance"
	populate(objectMap, "protectionState", a.ProtectionState)
	populate(objectMap, "serverName", a.ServerName)
	populate(objectMap, "subinquireditemcount", a.Subinquireditemcount)
	populate(objectMap, "subprotectableitemcount", a.Subprotectableitemcount)
	populate(objectMap, "workloadType", a.WorkloadType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureVMWorkloadSQLInstanceProtectableItem.
func (a *AzureVMWorkloadSQLInstanceProtectableItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupManagementType":
			err = unpopulate(val, "BackupManagementType", &a.BackupManagementType)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &a.FriendlyName)
			delete(rawMsg, key)
		case "isAutoProtectable":
			err = unpopulate(val, "IsAutoProtectable", &a.IsAutoProtectable)
			delete(rawMsg, key)
		case "isAutoProtected":
			err = unpopulate(val, "IsAutoProtected", &a.IsAutoProtected)
			delete(rawMsg, key)
		case "parentName":
			err = unpopulate(val, "ParentName", &a.ParentName)
			delete(rawMsg, key)
		case "parentUniqueName":
			err = unpopulate(val, "ParentUniqueName", &a.ParentUniqueName)
			delete(rawMsg, key)
		case "prebackupvalidation":
			err = unpopulate(val, "Prebackupvalidation", &a.Prebackupvalidation)
			delete(rawMsg, key)
		case "protectableItemType":
			err = unpopulate(val, "ProtectableItemType", &a.ProtectableItemType)
			delete(rawMsg, key)
		case "protectionState":
			err = unpopulate(val, "ProtectionState", &a.ProtectionState)
			delete(rawMsg, key)
		case "serverName":
			err = unpopulate(val, "ServerName", &a.ServerName)
			delete(rawMsg, key)
		case "subinquireditemcount":
			err = unpopulate(val, "Subinquireditemcount", &a.Subinquireditemcount)
			delete(rawMsg, key)
		case "subprotectableitemcount":
			err = unpopulate(val, "Subprotectableitemcount", &a.Subprotectableitemcount)
			delete(rawMsg, key)
		case "workloadType":
			err = unpopulate(val, "WorkloadType", &a.WorkloadType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureVMWorkloadSQLInstanceWorkloadItem.
func (a AzureVMWorkloadSQLInstanceWorkloadItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "backupManagementType", a.BackupManagementType)
	populate(objectMap, "dataDirectoryPaths", a.DataDirectoryPaths)
	populate(objectMap, "friendlyName", a.FriendlyName)
	populate(objectMap, "isAutoProtectable", a.IsAutoProtectable)
	populate(objectMap, "parentName", a.ParentName)
	populate(objectMap, "protectionState", a.ProtectionState)
	populate(objectMap, "serverName", a.ServerName)
	populate(objectMap, "subWorkloadItemCount", a.SubWorkloadItemCount)
	populate(objectMap, "subinquireditemcount", a.Subinquireditemcount)
	objectMap["workloadItemType"] = "SQLInstance"
	populate(objectMap, "workloadType", a.WorkloadType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureVMWorkloadSQLInstanceWorkloadItem.
func (a *AzureVMWorkloadSQLInstanceWorkloadItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupManagementType":
			err = unpopulate(val, "BackupManagementType", &a.BackupManagementType)
			delete(rawMsg, key)
		case "dataDirectoryPaths":
			err = unpopulate(val, "DataDirectoryPaths", &a.DataDirectoryPaths)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &a.FriendlyName)
			delete(rawMsg, key)
		case "isAutoProtectable":
			err = unpopulate(val, "IsAutoProtectable", &a.IsAutoProtectable)
			delete(rawMsg, key)
		case "parentName":
			err = unpopulate(val, "ParentName", &a.ParentName)
			delete(rawMsg, key)
		case "protectionState":
			err = unpopulate(val, "ProtectionState", &a.ProtectionState)
			delete(rawMsg, key)
		case "serverName":
			err = unpopulate(val, "ServerName", &a.ServerName)
			delete(rawMsg, key)
		case "subWorkloadItemCount":
			err = unpopulate(val, "SubWorkloadItemCount", &a.SubWorkloadItemCount)
			delete(rawMsg, key)
		case "subinquireditemcount":
			err = unpopulate(val, "Subinquireditemcount", &a.Subinquireditemcount)
			delete(rawMsg, key)
		case "workloadItemType":
			err = unpopulate(val, "WorkloadItemType", &a.WorkloadItemType)
			delete(rawMsg, key)
		case "workloadType":
			err = unpopulate(val, "WorkloadType", &a.WorkloadType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureWorkloadAutoProtectionIntent.
func (a AzureWorkloadAutoProtectionIntent) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "backupManagementType", a.BackupManagementType)
	populate(objectMap, "itemId", a.ItemID)
	populate(objectMap, "policyId", a.PolicyID)
	objectMap["protectionIntentItemType"] = "ProtectionIntentItemTypeAzureWorkloadAutoProtectionIntent"
	populate(objectMap, "protectionState", a.ProtectionState)
	populate(objectMap, "sourceResourceId", a.SourceResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureWorkloadAutoProtectionIntent.
func (a *AzureWorkloadAutoProtectionIntent) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupManagementType":
			err = unpopulate(val, "BackupManagementType", &a.BackupManagementType)
			delete(rawMsg, key)
		case "itemId":
			err = unpopulate(val, "ItemID", &a.ItemID)
			delete(rawMsg, key)
		case "policyId":
			err = unpopulate(val, "PolicyID", &a.PolicyID)
			delete(rawMsg, key)
		case "protectionIntentItemType":
			err = unpopulate(val, "ProtectionIntentItemType", &a.ProtectionIntentItemType)
			delete(rawMsg, key)
		case "protectionState":
			err = unpopulate(val, "ProtectionState", &a.ProtectionState)
			delete(rawMsg, key)
		case "sourceResourceId":
			err = unpopulate(val, "SourceResourceID", &a.SourceResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureWorkloadBackupRequest.
func (a AzureWorkloadBackupRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "backupType", a.BackupType)
	populate(objectMap, "enableCompression", a.EnableCompression)
	objectMap["objectType"] = "AzureWorkloadBackupRequest"
	populateTimeRFC3339(objectMap, "recoveryPointExpiryTimeInUTC", a.RecoveryPointExpiryTimeInUTC)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureWorkloadBackupRequest.
func (a *AzureWorkloadBackupRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupType":
			err = unpopulate(val, "BackupType", &a.BackupType)
			delete(rawMsg, key)
		case "enableCompression":
			err = unpopulate(val, "EnableCompression", &a.EnableCompression)
			delete(rawMsg, key)
		case "objectType":
			err = unpopulate(val, "ObjectType", &a.ObjectType)
			delete(rawMsg, key)
		case "recoveryPointExpiryTimeInUTC":
			err = unpopulateTimeRFC3339(val, "RecoveryPointExpiryTimeInUTC", &a.RecoveryPointExpiryTimeInUTC)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureWorkloadContainer.
func (a AzureWorkloadContainer) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "backupManagementType", a.BackupManagementType)
	objectMap["containerType"] = ContainerTypeAzureWorkloadContainer
	populate(objectMap, "extendedInfo", a.ExtendedInfo)
	populate(objectMap, "friendlyName", a.FriendlyName)
	populate(objectMap, "healthStatus", a.HealthStatus)
	populateTimeRFC3339(objectMap, "lastUpdatedTime", a.LastUpdatedTime)
	populate(objectMap, "operationType", a.OperationType)
	populate(objectMap, "protectableObjectType", a.ProtectableObjectType)
	populate(objectMap, "registrationStatus", a.RegistrationStatus)
	populate(objectMap, "sourceResourceId", a.SourceResourceID)
	populate(objectMap, "workloadType", a.WorkloadType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureWorkloadContainer.
func (a *AzureWorkloadContainer) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupManagementType":
			err = unpopulate(val, "BackupManagementType", &a.BackupManagementType)
			delete(rawMsg, key)
		case "containerType":
			err = unpopulate(val, "ContainerType", &a.ContainerType)
			delete(rawMsg, key)
		case "extendedInfo":
			err = unpopulate(val, "ExtendedInfo", &a.ExtendedInfo)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &a.FriendlyName)
			delete(rawMsg, key)
		case "healthStatus":
			err = unpopulate(val, "HealthStatus", &a.HealthStatus)
			delete(rawMsg, key)
		case "lastUpdatedTime":
			err = unpopulateTimeRFC3339(val, "LastUpdatedTime", &a.LastUpdatedTime)
			delete(rawMsg, key)
		case "operationType":
			err = unpopulate(val, "OperationType", &a.OperationType)
			delete(rawMsg, key)
		case "protectableObjectType":
			err = unpopulate(val, "ProtectableObjectType", &a.ProtectableObjectType)
			delete(rawMsg, key)
		case "registrationStatus":
			err = unpopulate(val, "RegistrationStatus", &a.RegistrationStatus)
			delete(rawMsg, key)
		case "sourceResourceId":
			err = unpopulate(val, "SourceResourceID", &a.SourceResourceID)
			delete(rawMsg, key)
		case "workloadType":
			err = unpopulate(val, "WorkloadType", &a.WorkloadType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureWorkloadContainerAutoProtectionIntent.
func (a AzureWorkloadContainerAutoProtectionIntent) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "backupManagementType", a.BackupManagementType)
	populate(objectMap, "itemId", a.ItemID)
	populate(objectMap, "policyId", a.PolicyID)
	objectMap["protectionIntentItemType"] = ProtectionIntentItemTypeAzureWorkloadContainerAutoProtectionIntent
	populate(objectMap, "protectionState", a.ProtectionState)
	populate(objectMap, "sourceResourceId", a.SourceResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureWorkloadContainerAutoProtectionIntent.
func (a *AzureWorkloadContainerAutoProtectionIntent) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupManagementType":
			err = unpopulate(val, "BackupManagementType", &a.BackupManagementType)
			delete(rawMsg, key)
		case "itemId":
			err = unpopulate(val, "ItemID", &a.ItemID)
			delete(rawMsg, key)
		case "policyId":
			err = unpopulate(val, "PolicyID", &a.PolicyID)
			delete(rawMsg, key)
		case "protectionIntentItemType":
			err = unpopulate(val, "ProtectionIntentItemType", &a.ProtectionIntentItemType)
			delete(rawMsg, key)
		case "protectionState":
			err = unpopulate(val, "ProtectionState", &a.ProtectionState)
			delete(rawMsg, key)
		case "sourceResourceId":
			err = unpopulate(val, "SourceResourceID", &a.SourceResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureWorkloadContainerExtendedInfo.
func (a AzureWorkloadContainerExtendedInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "hostServerName", a.HostServerName)
	populate(objectMap, "inquiryInfo", a.InquiryInfo)
	populate(objectMap, "nodesList", a.NodesList)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type AzureWorkloadErrorInfo.
func (a AzureWorkloadErrorInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "additionalDetails", a.AdditionalDetails)
	populate(objectMap, "errorCode", a.ErrorCode)
	populate(objectMap, "errorString", a.ErrorString)
	populate(objectMap, "errorTitle", a.ErrorTitle)
	populate(objectMap, "recommendations", a.Recommendations)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type AzureWorkloadJob.
func (a AzureWorkloadJob) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "actionsInfo", a.ActionsInfo)
	populate(objectMap, "activityId", a.ActivityID)
	populate(objectMap, "backupManagementType", a.BackupManagementType)
	populate(objectMap, "duration", a.Duration)
	populateTimeRFC3339(objectMap, "endTime", a.EndTime)
	populate(objectMap, "entityFriendlyName", a.EntityFriendlyName)
	populate(objectMap, "errorDetails", a.ErrorDetails)
	populate(objectMap, "extendedInfo", a.ExtendedInfo)
	objectMap["jobType"] = "AzureWorkloadJob"
	populate(objectMap, "operation", a.Operation)
	populateTimeRFC3339(objectMap, "startTime", a.StartTime)
	populate(objectMap, "status", a.Status)
	populate(objectMap, "workloadType", a.WorkloadType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureWorkloadJob.
func (a *AzureWorkloadJob) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actionsInfo":
			err = unpopulate(val, "ActionsInfo", &a.ActionsInfo)
			delete(rawMsg, key)
		case "activityId":
			err = unpopulate(val, "ActivityID", &a.ActivityID)
			delete(rawMsg, key)
		case "backupManagementType":
			err = unpopulate(val, "BackupManagementType", &a.BackupManagementType)
			delete(rawMsg, key)
		case "duration":
			err = unpopulate(val, "Duration", &a.Duration)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulateTimeRFC3339(val, "EndTime", &a.EndTime)
			delete(rawMsg, key)
		case "entityFriendlyName":
			err = unpopulate(val, "EntityFriendlyName", &a.EntityFriendlyName)
			delete(rawMsg, key)
		case "errorDetails":
			err = unpopulate(val, "ErrorDetails", &a.ErrorDetails)
			delete(rawMsg, key)
		case "extendedInfo":
			err = unpopulate(val, "ExtendedInfo", &a.ExtendedInfo)
			delete(rawMsg, key)
		case "jobType":
			err = unpopulate(val, "JobType", &a.JobType)
			delete(rawMsg, key)
		case "operation":
			err = unpopulate(val, "Operation", &a.Operation)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &a.StartTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &a.Status)
			delete(rawMsg, key)
		case "workloadType":
			err = unpopulate(val, "WorkloadType", &a.WorkloadType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureWorkloadJobExtendedInfo.
func (a AzureWorkloadJobExtendedInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "dynamicErrorMessage", a.DynamicErrorMessage)
	populate(objectMap, "propertyBag", a.PropertyBag)
	populate(objectMap, "tasksList", a.TasksList)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type AzureWorkloadPointInTimeRecoveryPoint.
func (a AzureWorkloadPointInTimeRecoveryPoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["objectType"] = "AzureWorkloadPointInTimeRecoveryPoint"
	populate(objectMap, "recoveryPointMoveReadinessInfo", a.RecoveryPointMoveReadinessInfo)
	populate(objectMap, "recoveryPointTierDetails", a.RecoveryPointTierDetails)
	populateTimeRFC3339(objectMap, "recoveryPointTimeInUTC", a.RecoveryPointTimeInUTC)
	populate(objectMap, "timeRanges", a.TimeRanges)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureWorkloadPointInTimeRecoveryPoint.
func (a *AzureWorkloadPointInTimeRecoveryPoint) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "objectType":
			err = unpopulate(val, "ObjectType", &a.ObjectType)
			delete(rawMsg, key)
		case "recoveryPointMoveReadinessInfo":
			err = unpopulate(val, "RecoveryPointMoveReadinessInfo", &a.RecoveryPointMoveReadinessInfo)
			delete(rawMsg, key)
		case "recoveryPointTierDetails":
			err = unpopulate(val, "RecoveryPointTierDetails", &a.RecoveryPointTierDetails)
			delete(rawMsg, key)
		case "recoveryPointTimeInUTC":
			err = unpopulateTimeRFC3339(val, "RecoveryPointTimeInUTC", &a.RecoveryPointTimeInUTC)
			delete(rawMsg, key)
		case "timeRanges":
			err = unpopulate(val, "TimeRanges", &a.TimeRanges)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureWorkloadPointInTimeRestoreRequest.
func (a AzureWorkloadPointInTimeRestoreRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["objectType"] = "AzureWorkloadPointInTimeRestoreRequest"
	populateTimeRFC3339(objectMap, "pointInTime", a.PointInTime)
	populate(objectMap, "propertyBag", a.PropertyBag)
	populate(objectMap, "recoveryMode", a.RecoveryMode)
	populate(objectMap, "recoveryType", a.RecoveryType)
	populate(objectMap, "sourceResourceId", a.SourceResourceID)
	populate(objectMap, "targetInfo", a.TargetInfo)
	populate(objectMap, "targetVirtualMachineId", a.TargetVirtualMachineID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureWorkloadPointInTimeRestoreRequest.
func (a *AzureWorkloadPointInTimeRestoreRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "objectType":
			err = unpopulate(val, "ObjectType", &a.ObjectType)
			delete(rawMsg, key)
		case "pointInTime":
			err = unpopulateTimeRFC3339(val, "PointInTime", &a.PointInTime)
			delete(rawMsg, key)
		case "propertyBag":
			err = unpopulate(val, "PropertyBag", &a.PropertyBag)
			delete(rawMsg, key)
		case "recoveryMode":
			err = unpopulate(val, "RecoveryMode", &a.RecoveryMode)
			delete(rawMsg, key)
		case "recoveryType":
			err = unpopulate(val, "RecoveryType", &a.RecoveryType)
			delete(rawMsg, key)
		case "sourceResourceId":
			err = unpopulate(val, "SourceResourceID", &a.SourceResourceID)
			delete(rawMsg, key)
		case "targetInfo":
			err = unpopulate(val, "TargetInfo", &a.TargetInfo)
			delete(rawMsg, key)
		case "targetVirtualMachineId":
			err = unpopulate(val, "TargetVirtualMachineID", &a.TargetVirtualMachineID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureWorkloadRecoveryPoint.
func (a AzureWorkloadRecoveryPoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["objectType"] = "AzureWorkloadRecoveryPoint"
	populate(objectMap, "recoveryPointMoveReadinessInfo", a.RecoveryPointMoveReadinessInfo)
	populate(objectMap, "recoveryPointTierDetails", a.RecoveryPointTierDetails)
	populateTimeRFC3339(objectMap, "recoveryPointTimeInUTC", a.RecoveryPointTimeInUTC)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureWorkloadRecoveryPoint.
func (a *AzureWorkloadRecoveryPoint) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "objectType":
			err = unpopulate(val, "ObjectType", &a.ObjectType)
			delete(rawMsg, key)
		case "recoveryPointMoveReadinessInfo":
			err = unpopulate(val, "RecoveryPointMoveReadinessInfo", &a.RecoveryPointMoveReadinessInfo)
			delete(rawMsg, key)
		case "recoveryPointTierDetails":
			err = unpopulate(val, "RecoveryPointTierDetails", &a.RecoveryPointTierDetails)
			delete(rawMsg, key)
		case "recoveryPointTimeInUTC":
			err = unpopulateTimeRFC3339(val, "RecoveryPointTimeInUTC", &a.RecoveryPointTimeInUTC)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureWorkloadRestoreRequest.
func (a AzureWorkloadRestoreRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["objectType"] = "AzureWorkloadRestoreRequest"
	populate(objectMap, "propertyBag", a.PropertyBag)
	populate(objectMap, "recoveryMode", a.RecoveryMode)
	populate(objectMap, "recoveryType", a.RecoveryType)
	populate(objectMap, "sourceResourceId", a.SourceResourceID)
	populate(objectMap, "targetInfo", a.TargetInfo)
	populate(objectMap, "targetVirtualMachineId", a.TargetVirtualMachineID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureWorkloadRestoreRequest.
func (a *AzureWorkloadRestoreRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "objectType":
			err = unpopulate(val, "ObjectType", &a.ObjectType)
			delete(rawMsg, key)
		case "propertyBag":
			err = unpopulate(val, "PropertyBag", &a.PropertyBag)
			delete(rawMsg, key)
		case "recoveryMode":
			err = unpopulate(val, "RecoveryMode", &a.RecoveryMode)
			delete(rawMsg, key)
		case "recoveryType":
			err = unpopulate(val, "RecoveryType", &a.RecoveryType)
			delete(rawMsg, key)
		case "sourceResourceId":
			err = unpopulate(val, "SourceResourceID", &a.SourceResourceID)
			delete(rawMsg, key)
		case "targetInfo":
			err = unpopulate(val, "TargetInfo", &a.TargetInfo)
			delete(rawMsg, key)
		case "targetVirtualMachineId":
			err = unpopulate(val, "TargetVirtualMachineID", &a.TargetVirtualMachineID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureWorkloadSAPHanaPointInTimeRecoveryPoint.
func (a AzureWorkloadSAPHanaPointInTimeRecoveryPoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["objectType"] = "AzureWorkloadSAPHanaPointInTimeRecoveryPoint"
	populate(objectMap, "recoveryPointMoveReadinessInfo", a.RecoveryPointMoveReadinessInfo)
	populate(objectMap, "recoveryPointTierDetails", a.RecoveryPointTierDetails)
	populateTimeRFC3339(objectMap, "recoveryPointTimeInUTC", a.RecoveryPointTimeInUTC)
	populate(objectMap, "timeRanges", a.TimeRanges)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureWorkloadSAPHanaPointInTimeRecoveryPoint.
func (a *AzureWorkloadSAPHanaPointInTimeRecoveryPoint) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "objectType":
			err = unpopulate(val, "ObjectType", &a.ObjectType)
			delete(rawMsg, key)
		case "recoveryPointMoveReadinessInfo":
			err = unpopulate(val, "RecoveryPointMoveReadinessInfo", &a.RecoveryPointMoveReadinessInfo)
			delete(rawMsg, key)
		case "recoveryPointTierDetails":
			err = unpopulate(val, "RecoveryPointTierDetails", &a.RecoveryPointTierDetails)
			delete(rawMsg, key)
		case "recoveryPointTimeInUTC":
			err = unpopulateTimeRFC3339(val, "RecoveryPointTimeInUTC", &a.RecoveryPointTimeInUTC)
			delete(rawMsg, key)
		case "timeRanges":
			err = unpopulate(val, "TimeRanges", &a.TimeRanges)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureWorkloadSAPHanaPointInTimeRestoreRequest.
func (a AzureWorkloadSAPHanaPointInTimeRestoreRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["objectType"] = "AzureWorkloadSAPHanaPointInTimeRestoreRequest"
	populateTimeRFC3339(objectMap, "pointInTime", a.PointInTime)
	populate(objectMap, "propertyBag", a.PropertyBag)
	populate(objectMap, "recoveryMode", a.RecoveryMode)
	populate(objectMap, "recoveryType", a.RecoveryType)
	populate(objectMap, "sourceResourceId", a.SourceResourceID)
	populate(objectMap, "targetInfo", a.TargetInfo)
	populate(objectMap, "targetVirtualMachineId", a.TargetVirtualMachineID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureWorkloadSAPHanaPointInTimeRestoreRequest.
func (a *AzureWorkloadSAPHanaPointInTimeRestoreRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "objectType":
			err = unpopulate(val, "ObjectType", &a.ObjectType)
			delete(rawMsg, key)
		case "pointInTime":
			err = unpopulateTimeRFC3339(val, "PointInTime", &a.PointInTime)
			delete(rawMsg, key)
		case "propertyBag":
			err = unpopulate(val, "PropertyBag", &a.PropertyBag)
			delete(rawMsg, key)
		case "recoveryMode":
			err = unpopulate(val, "RecoveryMode", &a.RecoveryMode)
			delete(rawMsg, key)
		case "recoveryType":
			err = unpopulate(val, "RecoveryType", &a.RecoveryType)
			delete(rawMsg, key)
		case "sourceResourceId":
			err = unpopulate(val, "SourceResourceID", &a.SourceResourceID)
			delete(rawMsg, key)
		case "targetInfo":
			err = unpopulate(val, "TargetInfo", &a.TargetInfo)
			delete(rawMsg, key)
		case "targetVirtualMachineId":
			err = unpopulate(val, "TargetVirtualMachineID", &a.TargetVirtualMachineID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureWorkloadSAPHanaPointInTimeRestoreWithRehydrateRequest.
func (a AzureWorkloadSAPHanaPointInTimeRestoreWithRehydrateRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["objectType"] = "AzureWorkloadSAPHanaPointInTimeRestoreWithRehydrateRequest"
	populateTimeRFC3339(objectMap, "pointInTime", a.PointInTime)
	populate(objectMap, "propertyBag", a.PropertyBag)
	populate(objectMap, "recoveryMode", a.RecoveryMode)
	populate(objectMap, "recoveryPointRehydrationInfo", a.RecoveryPointRehydrationInfo)
	populate(objectMap, "recoveryType", a.RecoveryType)
	populate(objectMap, "sourceResourceId", a.SourceResourceID)
	populate(objectMap, "targetInfo", a.TargetInfo)
	populate(objectMap, "targetVirtualMachineId", a.TargetVirtualMachineID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureWorkloadSAPHanaPointInTimeRestoreWithRehydrateRequest.
func (a *AzureWorkloadSAPHanaPointInTimeRestoreWithRehydrateRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "objectType":
			err = unpopulate(val, "ObjectType", &a.ObjectType)
			delete(rawMsg, key)
		case "pointInTime":
			err = unpopulateTimeRFC3339(val, "PointInTime", &a.PointInTime)
			delete(rawMsg, key)
		case "propertyBag":
			err = unpopulate(val, "PropertyBag", &a.PropertyBag)
			delete(rawMsg, key)
		case "recoveryMode":
			err = unpopulate(val, "RecoveryMode", &a.RecoveryMode)
			delete(rawMsg, key)
		case "recoveryPointRehydrationInfo":
			err = unpopulate(val, "RecoveryPointRehydrationInfo", &a.RecoveryPointRehydrationInfo)
			delete(rawMsg, key)
		case "recoveryType":
			err = unpopulate(val, "RecoveryType", &a.RecoveryType)
			delete(rawMsg, key)
		case "sourceResourceId":
			err = unpopulate(val, "SourceResourceID", &a.SourceResourceID)
			delete(rawMsg, key)
		case "targetInfo":
			err = unpopulate(val, "TargetInfo", &a.TargetInfo)
			delete(rawMsg, key)
		case "targetVirtualMachineId":
			err = unpopulate(val, "TargetVirtualMachineID", &a.TargetVirtualMachineID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureWorkloadSAPHanaRecoveryPoint.
func (a AzureWorkloadSAPHanaRecoveryPoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["objectType"] = "AzureWorkloadSAPHanaRecoveryPoint"
	populate(objectMap, "recoveryPointMoveReadinessInfo", a.RecoveryPointMoveReadinessInfo)
	populate(objectMap, "recoveryPointTierDetails", a.RecoveryPointTierDetails)
	populateTimeRFC3339(objectMap, "recoveryPointTimeInUTC", a.RecoveryPointTimeInUTC)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureWorkloadSAPHanaRecoveryPoint.
func (a *AzureWorkloadSAPHanaRecoveryPoint) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "objectType":
			err = unpopulate(val, "ObjectType", &a.ObjectType)
			delete(rawMsg, key)
		case "recoveryPointMoveReadinessInfo":
			err = unpopulate(val, "RecoveryPointMoveReadinessInfo", &a.RecoveryPointMoveReadinessInfo)
			delete(rawMsg, key)
		case "recoveryPointTierDetails":
			err = unpopulate(val, "RecoveryPointTierDetails", &a.RecoveryPointTierDetails)
			delete(rawMsg, key)
		case "recoveryPointTimeInUTC":
			err = unpopulateTimeRFC3339(val, "RecoveryPointTimeInUTC", &a.RecoveryPointTimeInUTC)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureWorkloadSAPHanaRestoreRequest.
func (a AzureWorkloadSAPHanaRestoreRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["objectType"] = "AzureWorkloadSAPHanaRestoreRequest"
	populate(objectMap, "propertyBag", a.PropertyBag)
	populate(objectMap, "recoveryMode", a.RecoveryMode)
	populate(objectMap, "recoveryType", a.RecoveryType)
	populate(objectMap, "sourceResourceId", a.SourceResourceID)
	populate(objectMap, "targetInfo", a.TargetInfo)
	populate(objectMap, "targetVirtualMachineId", a.TargetVirtualMachineID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureWorkloadSAPHanaRestoreRequest.
func (a *AzureWorkloadSAPHanaRestoreRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "objectType":
			err = unpopulate(val, "ObjectType", &a.ObjectType)
			delete(rawMsg, key)
		case "propertyBag":
			err = unpopulate(val, "PropertyBag", &a.PropertyBag)
			delete(rawMsg, key)
		case "recoveryMode":
			err = unpopulate(val, "RecoveryMode", &a.RecoveryMode)
			delete(rawMsg, key)
		case "recoveryType":
			err = unpopulate(val, "RecoveryType", &a.RecoveryType)
			delete(rawMsg, key)
		case "sourceResourceId":
			err = unpopulate(val, "SourceResourceID", &a.SourceResourceID)
			delete(rawMsg, key)
		case "targetInfo":
			err = unpopulate(val, "TargetInfo", &a.TargetInfo)
			delete(rawMsg, key)
		case "targetVirtualMachineId":
			err = unpopulate(val, "TargetVirtualMachineID", &a.TargetVirtualMachineID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureWorkloadSAPHanaRestoreWithRehydrateRequest.
func (a AzureWorkloadSAPHanaRestoreWithRehydrateRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["objectType"] = "AzureWorkloadSAPHanaRestoreWithRehydrateRequest"
	populate(objectMap, "propertyBag", a.PropertyBag)
	populate(objectMap, "recoveryMode", a.RecoveryMode)
	populate(objectMap, "recoveryPointRehydrationInfo", a.RecoveryPointRehydrationInfo)
	populate(objectMap, "recoveryType", a.RecoveryType)
	populate(objectMap, "sourceResourceId", a.SourceResourceID)
	populate(objectMap, "targetInfo", a.TargetInfo)
	populate(objectMap, "targetVirtualMachineId", a.TargetVirtualMachineID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureWorkloadSAPHanaRestoreWithRehydrateRequest.
func (a *AzureWorkloadSAPHanaRestoreWithRehydrateRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "objectType":
			err = unpopulate(val, "ObjectType", &a.ObjectType)
			delete(rawMsg, key)
		case "propertyBag":
			err = unpopulate(val, "PropertyBag", &a.PropertyBag)
			delete(rawMsg, key)
		case "recoveryMode":
			err = unpopulate(val, "RecoveryMode", &a.RecoveryMode)
			delete(rawMsg, key)
		case "recoveryPointRehydrationInfo":
			err = unpopulate(val, "RecoveryPointRehydrationInfo", &a.RecoveryPointRehydrationInfo)
			delete(rawMsg, key)
		case "recoveryType":
			err = unpopulate(val, "RecoveryType", &a.RecoveryType)
			delete(rawMsg, key)
		case "sourceResourceId":
			err = unpopulate(val, "SourceResourceID", &a.SourceResourceID)
			delete(rawMsg, key)
		case "targetInfo":
			err = unpopulate(val, "TargetInfo", &a.TargetInfo)
			delete(rawMsg, key)
		case "targetVirtualMachineId":
			err = unpopulate(val, "TargetVirtualMachineID", &a.TargetVirtualMachineID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureWorkloadSQLAutoProtectionIntent.
func (a AzureWorkloadSQLAutoProtectionIntent) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "backupManagementType", a.BackupManagementType)
	populate(objectMap, "itemId", a.ItemID)
	populate(objectMap, "policyId", a.PolicyID)
	objectMap["protectionIntentItemType"] = "ProtectionIntentItemTypeAzureWorkloadSQLAutoProtectionIntent"
	populate(objectMap, "protectionState", a.ProtectionState)
	populate(objectMap, "sourceResourceId", a.SourceResourceID)
	populate(objectMap, "workloadItemType", a.WorkloadItemType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureWorkloadSQLAutoProtectionIntent.
func (a *AzureWorkloadSQLAutoProtectionIntent) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupManagementType":
			err = unpopulate(val, "BackupManagementType", &a.BackupManagementType)
			delete(rawMsg, key)
		case "itemId":
			err = unpopulate(val, "ItemID", &a.ItemID)
			delete(rawMsg, key)
		case "policyId":
			err = unpopulate(val, "PolicyID", &a.PolicyID)
			delete(rawMsg, key)
		case "protectionIntentItemType":
			err = unpopulate(val, "ProtectionIntentItemType", &a.ProtectionIntentItemType)
			delete(rawMsg, key)
		case "protectionState":
			err = unpopulate(val, "ProtectionState", &a.ProtectionState)
			delete(rawMsg, key)
		case "sourceResourceId":
			err = unpopulate(val, "SourceResourceID", &a.SourceResourceID)
			delete(rawMsg, key)
		case "workloadItemType":
			err = unpopulate(val, "WorkloadItemType", &a.WorkloadItemType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureWorkloadSQLPointInTimeRecoveryPoint.
func (a AzureWorkloadSQLPointInTimeRecoveryPoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "extendedInfo", a.ExtendedInfo)
	objectMap["objectType"] = "AzureWorkloadSQLPointInTimeRecoveryPoint"
	populate(objectMap, "recoveryPointMoveReadinessInfo", a.RecoveryPointMoveReadinessInfo)
	populate(objectMap, "recoveryPointTierDetails", a.RecoveryPointTierDetails)
	populateTimeRFC3339(objectMap, "recoveryPointTimeInUTC", a.RecoveryPointTimeInUTC)
	populate(objectMap, "timeRanges", a.TimeRanges)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureWorkloadSQLPointInTimeRecoveryPoint.
func (a *AzureWorkloadSQLPointInTimeRecoveryPoint) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "extendedInfo":
			err = unpopulate(val, "ExtendedInfo", &a.ExtendedInfo)
			delete(rawMsg, key)
		case "objectType":
			err = unpopulate(val, "ObjectType", &a.ObjectType)
			delete(rawMsg, key)
		case "recoveryPointMoveReadinessInfo":
			err = unpopulate(val, "RecoveryPointMoveReadinessInfo", &a.RecoveryPointMoveReadinessInfo)
			delete(rawMsg, key)
		case "recoveryPointTierDetails":
			err = unpopulate(val, "RecoveryPointTierDetails", &a.RecoveryPointTierDetails)
			delete(rawMsg, key)
		case "recoveryPointTimeInUTC":
			err = unpopulateTimeRFC3339(val, "RecoveryPointTimeInUTC", &a.RecoveryPointTimeInUTC)
			delete(rawMsg, key)
		case "timeRanges":
			err = unpopulate(val, "TimeRanges", &a.TimeRanges)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureWorkloadSQLPointInTimeRestoreRequest.
func (a AzureWorkloadSQLPointInTimeRestoreRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "alternateDirectoryPaths", a.AlternateDirectoryPaths)
	populate(objectMap, "isNonRecoverable", a.IsNonRecoverable)
	objectMap["objectType"] = "AzureWorkloadSQLPointInTimeRestoreRequest"
	populateTimeRFC3339(objectMap, "pointInTime", a.PointInTime)
	populate(objectMap, "propertyBag", a.PropertyBag)
	populate(objectMap, "recoveryMode", a.RecoveryMode)
	populate(objectMap, "recoveryType", a.RecoveryType)
	populate(objectMap, "shouldUseAlternateTargetLocation", a.ShouldUseAlternateTargetLocation)
	populate(objectMap, "sourceResourceId", a.SourceResourceID)
	populate(objectMap, "targetInfo", a.TargetInfo)
	populate(objectMap, "targetVirtualMachineId", a.TargetVirtualMachineID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureWorkloadSQLPointInTimeRestoreRequest.
func (a *AzureWorkloadSQLPointInTimeRestoreRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "alternateDirectoryPaths":
			err = unpopulate(val, "AlternateDirectoryPaths", &a.AlternateDirectoryPaths)
			delete(rawMsg, key)
		case "isNonRecoverable":
			err = unpopulate(val, "IsNonRecoverable", &a.IsNonRecoverable)
			delete(rawMsg, key)
		case "objectType":
			err = unpopulate(val, "ObjectType", &a.ObjectType)
			delete(rawMsg, key)
		case "pointInTime":
			err = unpopulateTimeRFC3339(val, "PointInTime", &a.PointInTime)
			delete(rawMsg, key)
		case "propertyBag":
			err = unpopulate(val, "PropertyBag", &a.PropertyBag)
			delete(rawMsg, key)
		case "recoveryMode":
			err = unpopulate(val, "RecoveryMode", &a.RecoveryMode)
			delete(rawMsg, key)
		case "recoveryType":
			err = unpopulate(val, "RecoveryType", &a.RecoveryType)
			delete(rawMsg, key)
		case "shouldUseAlternateTargetLocation":
			err = unpopulate(val, "ShouldUseAlternateTargetLocation", &a.ShouldUseAlternateTargetLocation)
			delete(rawMsg, key)
		case "sourceResourceId":
			err = unpopulate(val, "SourceResourceID", &a.SourceResourceID)
			delete(rawMsg, key)
		case "targetInfo":
			err = unpopulate(val, "TargetInfo", &a.TargetInfo)
			delete(rawMsg, key)
		case "targetVirtualMachineId":
			err = unpopulate(val, "TargetVirtualMachineID", &a.TargetVirtualMachineID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureWorkloadSQLPointInTimeRestoreWithRehydrateRequest.
func (a AzureWorkloadSQLPointInTimeRestoreWithRehydrateRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "alternateDirectoryPaths", a.AlternateDirectoryPaths)
	populate(objectMap, "isNonRecoverable", a.IsNonRecoverable)
	objectMap["objectType"] = "AzureWorkloadSQLPointInTimeRestoreWithRehydrateRequest"
	populateTimeRFC3339(objectMap, "pointInTime", a.PointInTime)
	populate(objectMap, "propertyBag", a.PropertyBag)
	populate(objectMap, "recoveryMode", a.RecoveryMode)
	populate(objectMap, "recoveryPointRehydrationInfo", a.RecoveryPointRehydrationInfo)
	populate(objectMap, "recoveryType", a.RecoveryType)
	populate(objectMap, "shouldUseAlternateTargetLocation", a.ShouldUseAlternateTargetLocation)
	populate(objectMap, "sourceResourceId", a.SourceResourceID)
	populate(objectMap, "targetInfo", a.TargetInfo)
	populate(objectMap, "targetVirtualMachineId", a.TargetVirtualMachineID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureWorkloadSQLPointInTimeRestoreWithRehydrateRequest.
func (a *AzureWorkloadSQLPointInTimeRestoreWithRehydrateRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "alternateDirectoryPaths":
			err = unpopulate(val, "AlternateDirectoryPaths", &a.AlternateDirectoryPaths)
			delete(rawMsg, key)
		case "isNonRecoverable":
			err = unpopulate(val, "IsNonRecoverable", &a.IsNonRecoverable)
			delete(rawMsg, key)
		case "objectType":
			err = unpopulate(val, "ObjectType", &a.ObjectType)
			delete(rawMsg, key)
		case "pointInTime":
			err = unpopulateTimeRFC3339(val, "PointInTime", &a.PointInTime)
			delete(rawMsg, key)
		case "propertyBag":
			err = unpopulate(val, "PropertyBag", &a.PropertyBag)
			delete(rawMsg, key)
		case "recoveryMode":
			err = unpopulate(val, "RecoveryMode", &a.RecoveryMode)
			delete(rawMsg, key)
		case "recoveryPointRehydrationInfo":
			err = unpopulate(val, "RecoveryPointRehydrationInfo", &a.RecoveryPointRehydrationInfo)
			delete(rawMsg, key)
		case "recoveryType":
			err = unpopulate(val, "RecoveryType", &a.RecoveryType)
			delete(rawMsg, key)
		case "shouldUseAlternateTargetLocation":
			err = unpopulate(val, "ShouldUseAlternateTargetLocation", &a.ShouldUseAlternateTargetLocation)
			delete(rawMsg, key)
		case "sourceResourceId":
			err = unpopulate(val, "SourceResourceID", &a.SourceResourceID)
			delete(rawMsg, key)
		case "targetInfo":
			err = unpopulate(val, "TargetInfo", &a.TargetInfo)
			delete(rawMsg, key)
		case "targetVirtualMachineId":
			err = unpopulate(val, "TargetVirtualMachineID", &a.TargetVirtualMachineID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureWorkloadSQLRecoveryPoint.
func (a AzureWorkloadSQLRecoveryPoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "extendedInfo", a.ExtendedInfo)
	objectMap["objectType"] = "AzureWorkloadSQLRecoveryPoint"
	populate(objectMap, "recoveryPointMoveReadinessInfo", a.RecoveryPointMoveReadinessInfo)
	populate(objectMap, "recoveryPointTierDetails", a.RecoveryPointTierDetails)
	populateTimeRFC3339(objectMap, "recoveryPointTimeInUTC", a.RecoveryPointTimeInUTC)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureWorkloadSQLRecoveryPoint.
func (a *AzureWorkloadSQLRecoveryPoint) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "extendedInfo":
			err = unpopulate(val, "ExtendedInfo", &a.ExtendedInfo)
			delete(rawMsg, key)
		case "objectType":
			err = unpopulate(val, "ObjectType", &a.ObjectType)
			delete(rawMsg, key)
		case "recoveryPointMoveReadinessInfo":
			err = unpopulate(val, "RecoveryPointMoveReadinessInfo", &a.RecoveryPointMoveReadinessInfo)
			delete(rawMsg, key)
		case "recoveryPointTierDetails":
			err = unpopulate(val, "RecoveryPointTierDetails", &a.RecoveryPointTierDetails)
			delete(rawMsg, key)
		case "recoveryPointTimeInUTC":
			err = unpopulateTimeRFC3339(val, "RecoveryPointTimeInUTC", &a.RecoveryPointTimeInUTC)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureWorkloadSQLRecoveryPointExtendedInfo.
func (a AzureWorkloadSQLRecoveryPointExtendedInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "dataDirectoryPaths", a.DataDirectoryPaths)
	populateTimeRFC3339(objectMap, "dataDirectoryTimeInUTC", a.DataDirectoryTimeInUTC)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureWorkloadSQLRecoveryPointExtendedInfo.
func (a *AzureWorkloadSQLRecoveryPointExtendedInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataDirectoryPaths":
			err = unpopulate(val, "DataDirectoryPaths", &a.DataDirectoryPaths)
			delete(rawMsg, key)
		case "dataDirectoryTimeInUTC":
			err = unpopulateTimeRFC3339(val, "DataDirectoryTimeInUTC", &a.DataDirectoryTimeInUTC)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureWorkloadSQLRestoreRequest.
func (a AzureWorkloadSQLRestoreRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "alternateDirectoryPaths", a.AlternateDirectoryPaths)
	populate(objectMap, "isNonRecoverable", a.IsNonRecoverable)
	objectMap["objectType"] = "AzureWorkloadSQLRestoreRequest"
	populate(objectMap, "propertyBag", a.PropertyBag)
	populate(objectMap, "recoveryMode", a.RecoveryMode)
	populate(objectMap, "recoveryType", a.RecoveryType)
	populate(objectMap, "shouldUseAlternateTargetLocation", a.ShouldUseAlternateTargetLocation)
	populate(objectMap, "sourceResourceId", a.SourceResourceID)
	populate(objectMap, "targetInfo", a.TargetInfo)
	populate(objectMap, "targetVirtualMachineId", a.TargetVirtualMachineID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureWorkloadSQLRestoreRequest.
func (a *AzureWorkloadSQLRestoreRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "alternateDirectoryPaths":
			err = unpopulate(val, "AlternateDirectoryPaths", &a.AlternateDirectoryPaths)
			delete(rawMsg, key)
		case "isNonRecoverable":
			err = unpopulate(val, "IsNonRecoverable", &a.IsNonRecoverable)
			delete(rawMsg, key)
		case "objectType":
			err = unpopulate(val, "ObjectType", &a.ObjectType)
			delete(rawMsg, key)
		case "propertyBag":
			err = unpopulate(val, "PropertyBag", &a.PropertyBag)
			delete(rawMsg, key)
		case "recoveryMode":
			err = unpopulate(val, "RecoveryMode", &a.RecoveryMode)
			delete(rawMsg, key)
		case "recoveryType":
			err = unpopulate(val, "RecoveryType", &a.RecoveryType)
			delete(rawMsg, key)
		case "shouldUseAlternateTargetLocation":
			err = unpopulate(val, "ShouldUseAlternateTargetLocation", &a.ShouldUseAlternateTargetLocation)
			delete(rawMsg, key)
		case "sourceResourceId":
			err = unpopulate(val, "SourceResourceID", &a.SourceResourceID)
			delete(rawMsg, key)
		case "targetInfo":
			err = unpopulate(val, "TargetInfo", &a.TargetInfo)
			delete(rawMsg, key)
		case "targetVirtualMachineId":
			err = unpopulate(val, "TargetVirtualMachineID", &a.TargetVirtualMachineID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureWorkloadSQLRestoreWithRehydrateRequest.
func (a AzureWorkloadSQLRestoreWithRehydrateRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "alternateDirectoryPaths", a.AlternateDirectoryPaths)
	populate(objectMap, "isNonRecoverable", a.IsNonRecoverable)
	objectMap["objectType"] = "AzureWorkloadSQLRestoreWithRehydrateRequest"
	populate(objectMap, "propertyBag", a.PropertyBag)
	populate(objectMap, "recoveryMode", a.RecoveryMode)
	populate(objectMap, "recoveryPointRehydrationInfo", a.RecoveryPointRehydrationInfo)
	populate(objectMap, "recoveryType", a.RecoveryType)
	populate(objectMap, "shouldUseAlternateTargetLocation", a.ShouldUseAlternateTargetLocation)
	populate(objectMap, "sourceResourceId", a.SourceResourceID)
	populate(objectMap, "targetInfo", a.TargetInfo)
	populate(objectMap, "targetVirtualMachineId", a.TargetVirtualMachineID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureWorkloadSQLRestoreWithRehydrateRequest.
func (a *AzureWorkloadSQLRestoreWithRehydrateRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "alternateDirectoryPaths":
			err = unpopulate(val, "AlternateDirectoryPaths", &a.AlternateDirectoryPaths)
			delete(rawMsg, key)
		case "isNonRecoverable":
			err = unpopulate(val, "IsNonRecoverable", &a.IsNonRecoverable)
			delete(rawMsg, key)
		case "objectType":
			err = unpopulate(val, "ObjectType", &a.ObjectType)
			delete(rawMsg, key)
		case "propertyBag":
			err = unpopulate(val, "PropertyBag", &a.PropertyBag)
			delete(rawMsg, key)
		case "recoveryMode":
			err = unpopulate(val, "RecoveryMode", &a.RecoveryMode)
			delete(rawMsg, key)
		case "recoveryPointRehydrationInfo":
			err = unpopulate(val, "RecoveryPointRehydrationInfo", &a.RecoveryPointRehydrationInfo)
			delete(rawMsg, key)
		case "recoveryType":
			err = unpopulate(val, "RecoveryType", &a.RecoveryType)
			delete(rawMsg, key)
		case "shouldUseAlternateTargetLocation":
			err = unpopulate(val, "ShouldUseAlternateTargetLocation", &a.ShouldUseAlternateTargetLocation)
			delete(rawMsg, key)
		case "sourceResourceId":
			err = unpopulate(val, "SourceResourceID", &a.SourceResourceID)
			delete(rawMsg, key)
		case "targetInfo":
			err = unpopulate(val, "TargetInfo", &a.TargetInfo)
			delete(rawMsg, key)
		case "targetVirtualMachineId":
			err = unpopulate(val, "TargetVirtualMachineID", &a.TargetVirtualMachineID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BMSRPQueryObject.
func (b *BMSRPQueryObject) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endDate":
			err = unpopulateTimeRFC3339(val, "EndDate", &b.EndDate)
			delete(rawMsg, key)
		case "extendedInfo":
			err = unpopulate(val, "ExtendedInfo", &b.ExtendedInfo)
			delete(rawMsg, key)
		case "moveReadyRPOnly":
			err = unpopulate(val, "MoveReadyRPOnly", &b.MoveReadyRPOnly)
			delete(rawMsg, key)
		case "restorePointQueryType":
			err = unpopulate(val, "RestorePointQueryType", &b.RestorePointQueryType)
			delete(rawMsg, key)
		case "startDate":
			err = unpopulateTimeRFC3339(val, "StartDate", &b.StartDate)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BackupEngineBaseResource.
func (b BackupEngineBaseResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "eTag", b.ETag)
	populate(objectMap, "id", b.ID)
	populate(objectMap, "location", b.Location)
	populate(objectMap, "name", b.Name)
	populate(objectMap, "properties", b.Properties)
	populate(objectMap, "tags", b.Tags)
	populate(objectMap, "type", b.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BackupEngineBaseResource.
func (b *BackupEngineBaseResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "eTag":
			err = unpopulate(val, "ETag", &b.ETag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &b.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &b.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &b.Name)
			delete(rawMsg, key)
		case "properties":
			b.Properties, err = unmarshalBackupEngineBaseClassification(val)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &b.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &b.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BackupEngineExtendedInfo.
func (b BackupEngineExtendedInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "availableDiskSpace", b.AvailableDiskSpace)
	populate(objectMap, "azureProtectedInstances", b.AzureProtectedInstances)
	populate(objectMap, "databaseName", b.DatabaseName)
	populate(objectMap, "diskCount", b.DiskCount)
	populate(objectMap, "protectedItemsCount", b.ProtectedItemsCount)
	populate(objectMap, "protectedServersCount", b.ProtectedServersCount)
	populateTimeRFC3339(objectMap, "refreshedAt", b.RefreshedAt)
	populate(objectMap, "usedDiskSpace", b.UsedDiskSpace)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BackupEngineExtendedInfo.
func (b *BackupEngineExtendedInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "availableDiskSpace":
			err = unpopulate(val, "AvailableDiskSpace", &b.AvailableDiskSpace)
			delete(rawMsg, key)
		case "azureProtectedInstances":
			err = unpopulate(val, "AzureProtectedInstances", &b.AzureProtectedInstances)
			delete(rawMsg, key)
		case "databaseName":
			err = unpopulate(val, "DatabaseName", &b.DatabaseName)
			delete(rawMsg, key)
		case "diskCount":
			err = unpopulate(val, "DiskCount", &b.DiskCount)
			delete(rawMsg, key)
		case "protectedItemsCount":
			err = unpopulate(val, "ProtectedItemsCount", &b.ProtectedItemsCount)
			delete(rawMsg, key)
		case "protectedServersCount":
			err = unpopulate(val, "ProtectedServersCount", &b.ProtectedServersCount)
			delete(rawMsg, key)
		case "refreshedAt":
			err = unpopulateTimeRFC3339(val, "RefreshedAt", &b.RefreshedAt)
			delete(rawMsg, key)
		case "usedDiskSpace":
			err = unpopulate(val, "UsedDiskSpace", &b.UsedDiskSpace)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BackupManagementUsage.
func (b *BackupManagementUsage) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "currentValue":
			err = unpopulate(val, "CurrentValue", &b.CurrentValue)
			delete(rawMsg, key)
		case "limit":
			err = unpopulate(val, "Limit", &b.Limit)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &b.Name)
			delete(rawMsg, key)
		case "nextResetTime":
			err = unpopulateTimeRFC3339(val, "NextResetTime", &b.NextResetTime)
			delete(rawMsg, key)
		case "quotaPeriod":
			err = unpopulate(val, "QuotaPeriod", &b.QuotaPeriod)
			delete(rawMsg, key)
		case "unit":
			err = unpopulate(val, "Unit", &b.Unit)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BackupRequestResource.
func (b BackupRequestResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "eTag", b.ETag)
	populate(objectMap, "id", b.ID)
	populate(objectMap, "location", b.Location)
	populate(objectMap, "name", b.Name)
	populate(objectMap, "properties", b.Properties)
	populate(objectMap, "tags", b.Tags)
	populate(objectMap, "type", b.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BackupRequestResource.
func (b *BackupRequestResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "eTag":
			err = unpopulate(val, "ETag", &b.ETag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &b.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &b.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &b.Name)
			delete(rawMsg, key)
		case "properties":
			b.Properties, err = unmarshalBackupRequestClassification(val)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &b.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &b.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BackupResourceConfigResource.
func (b BackupResourceConfigResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "eTag", b.ETag)
	populate(objectMap, "id", b.ID)
	populate(objectMap, "location", b.Location)
	populate(objectMap, "name", b.Name)
	populate(objectMap, "properties", b.Properties)
	populate(objectMap, "tags", b.Tags)
	populate(objectMap, "type", b.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type BackupResourceEncryptionConfigExtendedResource.
func (b BackupResourceEncryptionConfigExtendedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "eTag", b.ETag)
	populate(objectMap, "id", b.ID)
	populate(objectMap, "location", b.Location)
	populate(objectMap, "name", b.Name)
	populate(objectMap, "properties", b.Properties)
	populate(objectMap, "tags", b.Tags)
	populate(objectMap, "type", b.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type BackupResourceEncryptionConfigResource.
func (b BackupResourceEncryptionConfigResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "eTag", b.ETag)
	populate(objectMap, "id", b.ID)
	populate(objectMap, "location", b.Location)
	populate(objectMap, "name", b.Name)
	populate(objectMap, "properties", b.Properties)
	populate(objectMap, "tags", b.Tags)
	populate(objectMap, "type", b.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type BackupResourceVaultConfig.
func (b BackupResourceVaultConfig) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "enhancedSecurityState", b.EnhancedSecurityState)
	populate(objectMap, "isSoftDeleteFeatureStateEditable", b.IsSoftDeleteFeatureStateEditable)
	populate(objectMap, "resourceGuardOperationRequests", b.ResourceGuardOperationRequests)
	populate(objectMap, "softDeleteFeatureState", b.SoftDeleteFeatureState)
	populate(objectMap, "storageModelType", b.StorageModelType)
	populate(objectMap, "storageType", b.StorageType)
	populate(objectMap, "storageTypeState", b.StorageTypeState)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type BackupResourceVaultConfigResource.
func (b BackupResourceVaultConfigResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "eTag", b.ETag)
	populate(objectMap, "id", b.ID)
	populate(objectMap, "location", b.Location)
	populate(objectMap, "name", b.Name)
	populate(objectMap, "properties", b.Properties)
	populate(objectMap, "tags", b.Tags)
	populate(objectMap, "type", b.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type DPMContainerExtendedInfo.
func (d DPMContainerExtendedInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "lastRefreshedAt", d.LastRefreshedAt)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DPMContainerExtendedInfo.
func (d *DPMContainerExtendedInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "lastRefreshedAt":
			err = unpopulateTimeRFC3339(val, "LastRefreshedAt", &d.LastRefreshedAt)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DPMProtectedItem.
func (d DPMProtectedItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "backupEngineName", d.BackupEngineName)
	populate(objectMap, "backupManagementType", d.BackupManagementType)
	populate(objectMap, "backupSetName", d.BackupSetName)
	populate(objectMap, "containerName", d.ContainerName)
	populate(objectMap, "createMode", d.CreateMode)
	populateTimeRFC3339(objectMap, "deferredDeleteTimeInUTC", d.DeferredDeleteTimeInUTC)
	populate(objectMap, "deferredDeleteTimeRemaining", d.DeferredDeleteTimeRemaining)
	populate(objectMap, "extendedInfo", d.ExtendedInfo)
	populate(objectMap, "friendlyName", d.FriendlyName)
	populate(objectMap, "isArchiveEnabled", d.IsArchiveEnabled)
	populate(objectMap, "isDeferredDeleteScheduleUpcoming", d.IsDeferredDeleteScheduleUpcoming)
	populate(objectMap, "isRehydrate", d.IsRehydrate)
	populate(objectMap, "isScheduledForDeferredDelete", d.IsScheduledForDeferredDelete)
	populateTimeRFC3339(objectMap, "lastRecoveryPoint", d.LastRecoveryPoint)
	populate(objectMap, "policyId", d.PolicyID)
	populate(objectMap, "policyName", d.PolicyName)
	objectMap["protectedItemType"] = "DPMProtectedItem"
	populate(objectMap, "protectionState", d.ProtectionState)
	populate(objectMap, "resourceGuardOperationRequests", d.ResourceGuardOperationRequests)
	populate(objectMap, "sourceResourceId", d.SourceResourceID)
	populate(objectMap, "workloadType", d.WorkloadType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DPMProtectedItem.
func (d *DPMProtectedItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupEngineName":
			err = unpopulate(val, "BackupEngineName", &d.BackupEngineName)
			delete(rawMsg, key)
		case "backupManagementType":
			err = unpopulate(val, "BackupManagementType", &d.BackupManagementType)
			delete(rawMsg, key)
		case "backupSetName":
			err = unpopulate(val, "BackupSetName", &d.BackupSetName)
			delete(rawMsg, key)
		case "containerName":
			err = unpopulate(val, "ContainerName", &d.ContainerName)
			delete(rawMsg, key)
		case "createMode":
			err = unpopulate(val, "CreateMode", &d.CreateMode)
			delete(rawMsg, key)
		case "deferredDeleteTimeInUTC":
			err = unpopulateTimeRFC3339(val, "DeferredDeleteTimeInUTC", &d.DeferredDeleteTimeInUTC)
			delete(rawMsg, key)
		case "deferredDeleteTimeRemaining":
			err = unpopulate(val, "DeferredDeleteTimeRemaining", &d.DeferredDeleteTimeRemaining)
			delete(rawMsg, key)
		case "extendedInfo":
			err = unpopulate(val, "ExtendedInfo", &d.ExtendedInfo)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &d.FriendlyName)
			delete(rawMsg, key)
		case "isArchiveEnabled":
			err = unpopulate(val, "IsArchiveEnabled", &d.IsArchiveEnabled)
			delete(rawMsg, key)
		case "isDeferredDeleteScheduleUpcoming":
			err = unpopulate(val, "IsDeferredDeleteScheduleUpcoming", &d.IsDeferredDeleteScheduleUpcoming)
			delete(rawMsg, key)
		case "isRehydrate":
			err = unpopulate(val, "IsRehydrate", &d.IsRehydrate)
			delete(rawMsg, key)
		case "isScheduledForDeferredDelete":
			err = unpopulate(val, "IsScheduledForDeferredDelete", &d.IsScheduledForDeferredDelete)
			delete(rawMsg, key)
		case "lastRecoveryPoint":
			err = unpopulateTimeRFC3339(val, "LastRecoveryPoint", &d.LastRecoveryPoint)
			delete(rawMsg, key)
		case "policyId":
			err = unpopulate(val, "PolicyID", &d.PolicyID)
			delete(rawMsg, key)
		case "policyName":
			err = unpopulate(val, "PolicyName", &d.PolicyName)
			delete(rawMsg, key)
		case "protectedItemType":
			err = unpopulate(val, "ProtectedItemType", &d.ProtectedItemType)
			delete(rawMsg, key)
		case "protectionState":
			err = unpopulate(val, "ProtectionState", &d.ProtectionState)
			delete(rawMsg, key)
		case "resourceGuardOperationRequests":
			err = unpopulate(val, "ResourceGuardOperationRequests", &d.ResourceGuardOperationRequests)
			delete(rawMsg, key)
		case "sourceResourceId":
			err = unpopulate(val, "SourceResourceID", &d.SourceResourceID)
			delete(rawMsg, key)
		case "workloadType":
			err = unpopulate(val, "WorkloadType", &d.WorkloadType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DPMProtectedItemExtendedInfo.
func (d DPMProtectedItemExtendedInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "diskStorageUsedInBytes", d.DiskStorageUsedInBytes)
	populate(objectMap, "isCollocated", d.IsCollocated)
	populate(objectMap, "isPresentOnCloud", d.IsPresentOnCloud)
	populate(objectMap, "lastBackupStatus", d.LastBackupStatus)
	populateTimeRFC3339(objectMap, "lastRefreshedAt", d.LastRefreshedAt)
	populateTimeRFC3339(objectMap, "oldestRecoveryPoint", d.OldestRecoveryPoint)
	populateTimeRFC3339(objectMap, "onPremiseLatestRecoveryPoint", d.OnPremiseLatestRecoveryPoint)
	populateTimeRFC3339(objectMap, "onPremiseOldestRecoveryPoint", d.OnPremiseOldestRecoveryPoint)
	populate(objectMap, "onPremiseRecoveryPointCount", d.OnPremiseRecoveryPointCount)
	populate(objectMap, "protectableObjectLoadPath", d.ProtectableObjectLoadPath)
	populate(objectMap, "protected", d.Protected)
	populate(objectMap, "protectionGroupName", d.ProtectionGroupName)
	populate(objectMap, "recoveryPointCount", d.RecoveryPointCount)
	populate(objectMap, "totalDiskStorageSizeInBytes", d.TotalDiskStorageSizeInBytes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DPMProtectedItemExtendedInfo.
func (d *DPMProtectedItemExtendedInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "diskStorageUsedInBytes":
			err = unpopulate(val, "DiskStorageUsedInBytes", &d.DiskStorageUsedInBytes)
			delete(rawMsg, key)
		case "isCollocated":
			err = unpopulate(val, "IsCollocated", &d.IsCollocated)
			delete(rawMsg, key)
		case "isPresentOnCloud":
			err = unpopulate(val, "IsPresentOnCloud", &d.IsPresentOnCloud)
			delete(rawMsg, key)
		case "lastBackupStatus":
			err = unpopulate(val, "LastBackupStatus", &d.LastBackupStatus)
			delete(rawMsg, key)
		case "lastRefreshedAt":
			err = unpopulateTimeRFC3339(val, "LastRefreshedAt", &d.LastRefreshedAt)
			delete(rawMsg, key)
		case "oldestRecoveryPoint":
			err = unpopulateTimeRFC3339(val, "OldestRecoveryPoint", &d.OldestRecoveryPoint)
			delete(rawMsg, key)
		case "onPremiseLatestRecoveryPoint":
			err = unpopulateTimeRFC3339(val, "OnPremiseLatestRecoveryPoint", &d.OnPremiseLatestRecoveryPoint)
			delete(rawMsg, key)
		case "onPremiseOldestRecoveryPoint":
			err = unpopulateTimeRFC3339(val, "OnPremiseOldestRecoveryPoint", &d.OnPremiseOldestRecoveryPoint)
			delete(rawMsg, key)
		case "onPremiseRecoveryPointCount":
			err = unpopulate(val, "OnPremiseRecoveryPointCount", &d.OnPremiseRecoveryPointCount)
			delete(rawMsg, key)
		case "protectableObjectLoadPath":
			err = unpopulate(val, "ProtectableObjectLoadPath", &d.ProtectableObjectLoadPath)
			delete(rawMsg, key)
		case "protected":
			err = unpopulate(val, "Protected", &d.Protected)
			delete(rawMsg, key)
		case "protectionGroupName":
			err = unpopulate(val, "ProtectionGroupName", &d.ProtectionGroupName)
			delete(rawMsg, key)
		case "recoveryPointCount":
			err = unpopulate(val, "RecoveryPointCount", &d.RecoveryPointCount)
			delete(rawMsg, key)
		case "totalDiskStorageSizeInBytes":
			err = unpopulate(val, "TotalDiskStorageSizeInBytes", &d.TotalDiskStorageSizeInBytes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DailyRetentionFormat.
func (d DailyRetentionFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "daysOfTheMonth", d.DaysOfTheMonth)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type DailyRetentionSchedule.
func (d DailyRetentionSchedule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "retentionDuration", d.RetentionDuration)
	aux := make([]*timeRFC3339, len(d.RetentionTimes), len(d.RetentionTimes))
	for i := 0; i < len(d.RetentionTimes); i++ {
		aux[i] = (*timeRFC3339)(d.RetentionTimes[i])
	}
	populate(objectMap, "retentionTimes", aux)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type DailySchedule.
func (d DailySchedule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	aux := make([]*timeRFC3339, len(d.ScheduleRunTimes), len(d.ScheduleRunTimes))
	for i := 0; i < len(d.ScheduleRunTimes); i++ {
		aux[i] = (*timeRFC3339)(d.ScheduleRunTimes[i])
	}
	populate(objectMap, "scheduleRunTimes", aux)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type DiskExclusionProperties.
func (d DiskExclusionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "diskLunList", d.DiskLunList)
	populate(objectMap, "isInclusionList", d.IsInclusionList)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type DpmBackupEngine.
func (d DpmBackupEngine) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "azureBackupAgentVersion", d.AzureBackupAgentVersion)
	populate(objectMap, "backupEngineId", d.BackupEngineID)
	populate(objectMap, "backupEngineState", d.BackupEngineState)
	objectMap["backupEngineType"] = BackupEngineTypeDpmBackupEngine
	populate(objectMap, "backupManagementType", d.BackupManagementType)
	populate(objectMap, "canReRegister", d.CanReRegister)
	populate(objectMap, "dpmVersion", d.DpmVersion)
	populate(objectMap, "extendedInfo", d.ExtendedInfo)
	populate(objectMap, "friendlyName", d.FriendlyName)
	populate(objectMap, "healthStatus", d.HealthStatus)
	populate(objectMap, "isAzureBackupAgentUpgradeAvailable", d.IsAzureBackupAgentUpgradeAvailable)
	populate(objectMap, "isDpmUpgradeAvailable", d.IsDpmUpgradeAvailable)
	populate(objectMap, "registrationStatus", d.RegistrationStatus)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DpmBackupEngine.
func (d *DpmBackupEngine) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "azureBackupAgentVersion":
			err = unpopulate(val, "AzureBackupAgentVersion", &d.AzureBackupAgentVersion)
			delete(rawMsg, key)
		case "backupEngineId":
			err = unpopulate(val, "BackupEngineID", &d.BackupEngineID)
			delete(rawMsg, key)
		case "backupEngineState":
			err = unpopulate(val, "BackupEngineState", &d.BackupEngineState)
			delete(rawMsg, key)
		case "backupEngineType":
			err = unpopulate(val, "BackupEngineType", &d.BackupEngineType)
			delete(rawMsg, key)
		case "backupManagementType":
			err = unpopulate(val, "BackupManagementType", &d.BackupManagementType)
			delete(rawMsg, key)
		case "canReRegister":
			err = unpopulate(val, "CanReRegister", &d.CanReRegister)
			delete(rawMsg, key)
		case "dpmVersion":
			err = unpopulate(val, "DpmVersion", &d.DpmVersion)
			delete(rawMsg, key)
		case "extendedInfo":
			err = unpopulate(val, "ExtendedInfo", &d.ExtendedInfo)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &d.FriendlyName)
			delete(rawMsg, key)
		case "healthStatus":
			err = unpopulate(val, "HealthStatus", &d.HealthStatus)
			delete(rawMsg, key)
		case "isAzureBackupAgentUpgradeAvailable":
			err = unpopulate(val, "IsAzureBackupAgentUpgradeAvailable", &d.IsAzureBackupAgentUpgradeAvailable)
			delete(rawMsg, key)
		case "isDpmUpgradeAvailable":
			err = unpopulate(val, "IsDpmUpgradeAvailable", &d.IsDpmUpgradeAvailable)
			delete(rawMsg, key)
		case "registrationStatus":
			err = unpopulate(val, "RegistrationStatus", &d.RegistrationStatus)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DpmContainer.
func (d DpmContainer) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "backupManagementType", d.BackupManagementType)
	populate(objectMap, "canReRegister", d.CanReRegister)
	populate(objectMap, "containerId", d.ContainerID)
	objectMap["containerType"] = ContainerTypeDPMContainer
	populate(objectMap, "dpmAgentVersion", d.DpmAgentVersion)
	populate(objectMap, "dpmServers", d.DpmServers)
	populate(objectMap, "extendedInfo", d.ExtendedInfo)
	populate(objectMap, "friendlyName", d.FriendlyName)
	populate(objectMap, "healthStatus", d.HealthStatus)
	populate(objectMap, "protectableObjectType", d.ProtectableObjectType)
	populate(objectMap, "protectedItemCount", d.ProtectedItemCount)
	populate(objectMap, "protectionStatus", d.ProtectionStatus)
	populate(objectMap, "registrationStatus", d.RegistrationStatus)
	populate(objectMap, "upgradeAvailable", d.UpgradeAvailable)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DpmContainer.
func (d *DpmContainer) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupManagementType":
			err = unpopulate(val, "BackupManagementType", &d.BackupManagementType)
			delete(rawMsg, key)
		case "canReRegister":
			err = unpopulate(val, "CanReRegister", &d.CanReRegister)
			delete(rawMsg, key)
		case "containerId":
			err = unpopulate(val, "ContainerID", &d.ContainerID)
			delete(rawMsg, key)
		case "containerType":
			err = unpopulate(val, "ContainerType", &d.ContainerType)
			delete(rawMsg, key)
		case "dpmAgentVersion":
			err = unpopulate(val, "DpmAgentVersion", &d.DpmAgentVersion)
			delete(rawMsg, key)
		case "dpmServers":
			err = unpopulate(val, "DpmServers", &d.DpmServers)
			delete(rawMsg, key)
		case "extendedInfo":
			err = unpopulate(val, "ExtendedInfo", &d.ExtendedInfo)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &d.FriendlyName)
			delete(rawMsg, key)
		case "healthStatus":
			err = unpopulate(val, "HealthStatus", &d.HealthStatus)
			delete(rawMsg, key)
		case "protectableObjectType":
			err = unpopulate(val, "ProtectableObjectType", &d.ProtectableObjectType)
			delete(rawMsg, key)
		case "protectedItemCount":
			err = unpopulate(val, "ProtectedItemCount", &d.ProtectedItemCount)
			delete(rawMsg, key)
		case "protectionStatus":
			err = unpopulate(val, "ProtectionStatus", &d.ProtectionStatus)
			delete(rawMsg, key)
		case "registrationStatus":
			err = unpopulate(val, "RegistrationStatus", &d.RegistrationStatus)
			delete(rawMsg, key)
		case "upgradeAvailable":
			err = unpopulate(val, "UpgradeAvailable", &d.UpgradeAvailable)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DpmErrorInfo.
func (d DpmErrorInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "errorString", d.ErrorString)
	populate(objectMap, "recommendations", d.Recommendations)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type DpmJob.
func (d DpmJob) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "actionsInfo", d.ActionsInfo)
	populate(objectMap, "activityId", d.ActivityID)
	populate(objectMap, "backupManagementType", d.BackupManagementType)
	populate(objectMap, "containerName", d.ContainerName)
	populate(objectMap, "containerType", d.ContainerType)
	populate(objectMap, "dpmServerName", d.DpmServerName)
	populate(objectMap, "duration", d.Duration)
	populateTimeRFC3339(objectMap, "endTime", d.EndTime)
	populate(objectMap, "entityFriendlyName", d.EntityFriendlyName)
	populate(objectMap, "errorDetails", d.ErrorDetails)
	populate(objectMap, "extendedInfo", d.ExtendedInfo)
	objectMap["jobType"] = "DpmJob"
	populate(objectMap, "operation", d.Operation)
	populateTimeRFC3339(objectMap, "startTime", d.StartTime)
	populate(objectMap, "status", d.Status)
	populate(objectMap, "workloadType", d.WorkloadType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DpmJob.
func (d *DpmJob) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actionsInfo":
			err = unpopulate(val, "ActionsInfo", &d.ActionsInfo)
			delete(rawMsg, key)
		case "activityId":
			err = unpopulate(val, "ActivityID", &d.ActivityID)
			delete(rawMsg, key)
		case "backupManagementType":
			err = unpopulate(val, "BackupManagementType", &d.BackupManagementType)
			delete(rawMsg, key)
		case "containerName":
			err = unpopulate(val, "ContainerName", &d.ContainerName)
			delete(rawMsg, key)
		case "containerType":
			err = unpopulate(val, "ContainerType", &d.ContainerType)
			delete(rawMsg, key)
		case "dpmServerName":
			err = unpopulate(val, "DpmServerName", &d.DpmServerName)
			delete(rawMsg, key)
		case "duration":
			err = unpopulate(val, "Duration", &d.Duration)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulateTimeRFC3339(val, "EndTime", &d.EndTime)
			delete(rawMsg, key)
		case "entityFriendlyName":
			err = unpopulate(val, "EntityFriendlyName", &d.EntityFriendlyName)
			delete(rawMsg, key)
		case "errorDetails":
			err = unpopulate(val, "ErrorDetails", &d.ErrorDetails)
			delete(rawMsg, key)
		case "extendedInfo":
			err = unpopulate(val, "ExtendedInfo", &d.ExtendedInfo)
			delete(rawMsg, key)
		case "jobType":
			err = unpopulate(val, "JobType", &d.JobType)
			delete(rawMsg, key)
		case "operation":
			err = unpopulate(val, "Operation", &d.Operation)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &d.StartTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &d.Status)
			delete(rawMsg, key)
		case "workloadType":
			err = unpopulate(val, "WorkloadType", &d.WorkloadType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DpmJobExtendedInfo.
func (d DpmJobExtendedInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "dynamicErrorMessage", d.DynamicErrorMessage)
	populate(objectMap, "propertyBag", d.PropertyBag)
	populate(objectMap, "tasksList", d.TasksList)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type DpmJobTaskDetails.
func (d DpmJobTaskDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "duration", d.Duration)
	populateTimeRFC3339(objectMap, "endTime", d.EndTime)
	populateTimeRFC3339(objectMap, "startTime", d.StartTime)
	populate(objectMap, "status", d.Status)
	populate(objectMap, "taskId", d.TaskID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DpmJobTaskDetails.
func (d *DpmJobTaskDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "duration":
			err = unpopulate(val, "Duration", &d.Duration)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulateTimeRFC3339(val, "EndTime", &d.EndTime)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &d.StartTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &d.Status)
			delete(rawMsg, key)
		case "taskId":
			err = unpopulate(val, "TaskID", &d.TaskID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorDetail.
func (e ErrorDetail) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "code", e.Code)
	populate(objectMap, "message", e.Message)
	populate(objectMap, "recommendations", e.Recommendations)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExportJobsOperationResultInfo.
func (e *ExportJobsOperationResultInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "blobSasKey":
			err = unpopulate(val, "BlobSasKey", &e.BlobSasKey)
			delete(rawMsg, key)
		case "blobUrl":
			err = unpopulate(val, "BlobURL", &e.BlobURL)
			delete(rawMsg, key)
		case "excelFileBlobSasKey":
			err = unpopulate(val, "ExcelFileBlobSasKey", &e.ExcelFileBlobSasKey)
			delete(rawMsg, key)
		case "excelFileBlobUrl":
			err = unpopulate(val, "ExcelFileBlobURL", &e.ExcelFileBlobURL)
			delete(rawMsg, key)
		case "objectType":
			err = unpopulate(val, "ObjectType", &e.ObjectType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GenericContainer.
func (g GenericContainer) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "backupManagementType", g.BackupManagementType)
	objectMap["containerType"] = ContainerTypeGenericContainer
	populate(objectMap, "extendedInformation", g.ExtendedInformation)
	populate(objectMap, "fabricName", g.FabricName)
	populate(objectMap, "friendlyName", g.FriendlyName)
	populate(objectMap, "healthStatus", g.HealthStatus)
	populate(objectMap, "protectableObjectType", g.ProtectableObjectType)
	populate(objectMap, "registrationStatus", g.RegistrationStatus)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GenericContainer.
func (g *GenericContainer) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupManagementType":
			err = unpopulate(val, "BackupManagementType", &g.BackupManagementType)
			delete(rawMsg, key)
		case "containerType":
			err = unpopulate(val, "ContainerType", &g.ContainerType)
			delete(rawMsg, key)
		case "extendedInformation":
			err = unpopulate(val, "ExtendedInformation", &g.ExtendedInformation)
			delete(rawMsg, key)
		case "fabricName":
			err = unpopulate(val, "FabricName", &g.FabricName)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &g.FriendlyName)
			delete(rawMsg, key)
		case "healthStatus":
			err = unpopulate(val, "HealthStatus", &g.HealthStatus)
			delete(rawMsg, key)
		case "protectableObjectType":
			err = unpopulate(val, "ProtectableObjectType", &g.ProtectableObjectType)
			delete(rawMsg, key)
		case "registrationStatus":
			err = unpopulate(val, "RegistrationStatus", &g.RegistrationStatus)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GenericContainerExtendedInfo.
func (g GenericContainerExtendedInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "containerIdentityInfo", g.ContainerIdentityInfo)
	populate(objectMap, "rawCertData", g.RawCertData)
	populate(objectMap, "serviceEndpoints", g.ServiceEndpoints)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type GenericProtectedItem.
func (g GenericProtectedItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "backupManagementType", g.BackupManagementType)
	populate(objectMap, "backupSetName", g.BackupSetName)
	populate(objectMap, "containerName", g.ContainerName)
	populate(objectMap, "createMode", g.CreateMode)
	populateTimeRFC3339(objectMap, "deferredDeleteTimeInUTC", g.DeferredDeleteTimeInUTC)
	populate(objectMap, "deferredDeleteTimeRemaining", g.DeferredDeleteTimeRemaining)
	populate(objectMap, "fabricName", g.FabricName)
	populate(objectMap, "friendlyName", g.FriendlyName)
	populate(objectMap, "isArchiveEnabled", g.IsArchiveEnabled)
	populate(objectMap, "isDeferredDeleteScheduleUpcoming", g.IsDeferredDeleteScheduleUpcoming)
	populate(objectMap, "isRehydrate", g.IsRehydrate)
	populate(objectMap, "isScheduledForDeferredDelete", g.IsScheduledForDeferredDelete)
	populateTimeRFC3339(objectMap, "lastRecoveryPoint", g.LastRecoveryPoint)
	populate(objectMap, "policyId", g.PolicyID)
	populate(objectMap, "policyName", g.PolicyName)
	populate(objectMap, "policyState", g.PolicyState)
	populate(objectMap, "protectedItemId", g.ProtectedItemID)
	objectMap["protectedItemType"] = "GenericProtectedItem"
	populate(objectMap, "protectionState", g.ProtectionState)
	populate(objectMap, "resourceGuardOperationRequests", g.ResourceGuardOperationRequests)
	populate(objectMap, "sourceAssociations", g.SourceAssociations)
	populate(objectMap, "sourceResourceId", g.SourceResourceID)
	populate(objectMap, "workloadType", g.WorkloadType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GenericProtectedItem.
func (g *GenericProtectedItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupManagementType":
			err = unpopulate(val, "BackupManagementType", &g.BackupManagementType)
			delete(rawMsg, key)
		case "backupSetName":
			err = unpopulate(val, "BackupSetName", &g.BackupSetName)
			delete(rawMsg, key)
		case "containerName":
			err = unpopulate(val, "ContainerName", &g.ContainerName)
			delete(rawMsg, key)
		case "createMode":
			err = unpopulate(val, "CreateMode", &g.CreateMode)
			delete(rawMsg, key)
		case "deferredDeleteTimeInUTC":
			err = unpopulateTimeRFC3339(val, "DeferredDeleteTimeInUTC", &g.DeferredDeleteTimeInUTC)
			delete(rawMsg, key)
		case "deferredDeleteTimeRemaining":
			err = unpopulate(val, "DeferredDeleteTimeRemaining", &g.DeferredDeleteTimeRemaining)
			delete(rawMsg, key)
		case "fabricName":
			err = unpopulate(val, "FabricName", &g.FabricName)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &g.FriendlyName)
			delete(rawMsg, key)
		case "isArchiveEnabled":
			err = unpopulate(val, "IsArchiveEnabled", &g.IsArchiveEnabled)
			delete(rawMsg, key)
		case "isDeferredDeleteScheduleUpcoming":
			err = unpopulate(val, "IsDeferredDeleteScheduleUpcoming", &g.IsDeferredDeleteScheduleUpcoming)
			delete(rawMsg, key)
		case "isRehydrate":
			err = unpopulate(val, "IsRehydrate", &g.IsRehydrate)
			delete(rawMsg, key)
		case "isScheduledForDeferredDelete":
			err = unpopulate(val, "IsScheduledForDeferredDelete", &g.IsScheduledForDeferredDelete)
			delete(rawMsg, key)
		case "lastRecoveryPoint":
			err = unpopulateTimeRFC3339(val, "LastRecoveryPoint", &g.LastRecoveryPoint)
			delete(rawMsg, key)
		case "policyId":
			err = unpopulate(val, "PolicyID", &g.PolicyID)
			delete(rawMsg, key)
		case "policyName":
			err = unpopulate(val, "PolicyName", &g.PolicyName)
			delete(rawMsg, key)
		case "policyState":
			err = unpopulate(val, "PolicyState", &g.PolicyState)
			delete(rawMsg, key)
		case "protectedItemId":
			err = unpopulate(val, "ProtectedItemID", &g.ProtectedItemID)
			delete(rawMsg, key)
		case "protectedItemType":
			err = unpopulate(val, "ProtectedItemType", &g.ProtectedItemType)
			delete(rawMsg, key)
		case "protectionState":
			err = unpopulate(val, "ProtectionState", &g.ProtectionState)
			delete(rawMsg, key)
		case "resourceGuardOperationRequests":
			err = unpopulate(val, "ResourceGuardOperationRequests", &g.ResourceGuardOperationRequests)
			delete(rawMsg, key)
		case "sourceAssociations":
			err = unpopulate(val, "SourceAssociations", &g.SourceAssociations)
			delete(rawMsg, key)
		case "sourceResourceId":
			err = unpopulate(val, "SourceResourceID", &g.SourceResourceID)
			delete(rawMsg, key)
		case "workloadType":
			err = unpopulate(val, "WorkloadType", &g.WorkloadType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GenericProtectionPolicy.
func (g GenericProtectionPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["backupManagementType"] = "GenericProtectionPolicy"
	populate(objectMap, "fabricName", g.FabricName)
	populate(objectMap, "protectedItemsCount", g.ProtectedItemsCount)
	populate(objectMap, "resourceGuardOperationRequests", g.ResourceGuardOperationRequests)
	populate(objectMap, "subProtectionPolicy", g.SubProtectionPolicy)
	populate(objectMap, "timeZone", g.TimeZone)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GenericProtectionPolicy.
func (g *GenericProtectionPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupManagementType":
			err = unpopulate(val, "BackupManagementType", &g.BackupManagementType)
			delete(rawMsg, key)
		case "fabricName":
			err = unpopulate(val, "FabricName", &g.FabricName)
			delete(rawMsg, key)
		case "protectedItemsCount":
			err = unpopulate(val, "ProtectedItemsCount", &g.ProtectedItemsCount)
			delete(rawMsg, key)
		case "resourceGuardOperationRequests":
			err = unpopulate(val, "ResourceGuardOperationRequests", &g.ResourceGuardOperationRequests)
			delete(rawMsg, key)
		case "subProtectionPolicy":
			err = unpopulate(val, "SubProtectionPolicy", &g.SubProtectionPolicy)
			delete(rawMsg, key)
		case "timeZone":
			err = unpopulate(val, "TimeZone", &g.TimeZone)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GenericRecoveryPoint.
func (g GenericRecoveryPoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "friendlyName", g.FriendlyName)
	objectMap["objectType"] = "GenericRecoveryPoint"
	populate(objectMap, "recoveryPointAdditionalInfo", g.RecoveryPointAdditionalInfo)
	populateTimeRFC3339(objectMap, "recoveryPointTime", g.RecoveryPointTime)
	populate(objectMap, "recoveryPointType", g.RecoveryPointType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GenericRecoveryPoint.
func (g *GenericRecoveryPoint) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &g.FriendlyName)
			delete(rawMsg, key)
		case "objectType":
			err = unpopulate(val, "ObjectType", &g.ObjectType)
			delete(rawMsg, key)
		case "recoveryPointAdditionalInfo":
			err = unpopulate(val, "RecoveryPointAdditionalInfo", &g.RecoveryPointAdditionalInfo)
			delete(rawMsg, key)
		case "recoveryPointTime":
			err = unpopulateTimeRFC3339(val, "RecoveryPointTime", &g.RecoveryPointTime)
			delete(rawMsg, key)
		case "recoveryPointType":
			err = unpopulate(val, "RecoveryPointType", &g.RecoveryPointType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HourlySchedule.
func (h HourlySchedule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "interval", h.Interval)
	populate(objectMap, "scheduleWindowDuration", h.ScheduleWindowDuration)
	populateTimeRFC3339(objectMap, "scheduleWindowStartTime", h.ScheduleWindowStartTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HourlySchedule.
func (h *HourlySchedule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "interval":
			err = unpopulate(val, "Interval", &h.Interval)
			delete(rawMsg, key)
		case "scheduleWindowDuration":
			err = unpopulate(val, "ScheduleWindowDuration", &h.ScheduleWindowDuration)
			delete(rawMsg, key)
		case "scheduleWindowStartTime":
			err = unpopulateTimeRFC3339(val, "ScheduleWindowStartTime", &h.ScheduleWindowStartTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ILRRequestResource.
func (i ILRRequestResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "eTag", i.ETag)
	populate(objectMap, "id", i.ID)
	populate(objectMap, "location", i.Location)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "properties", i.Properties)
	populate(objectMap, "tags", i.Tags)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ILRRequestResource.
func (i *ILRRequestResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "eTag":
			err = unpopulate(val, "ETag", &i.ETag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &i.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &i.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "properties":
			i.Properties, err = unmarshalILRRequestClassification(val)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &i.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IaaSVMContainer.
func (i IaaSVMContainer) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "backupManagementType", i.BackupManagementType)
	objectMap["containerType"] = ContainerTypeIaasVMContainer
	populate(objectMap, "friendlyName", i.FriendlyName)
	populate(objectMap, "healthStatus", i.HealthStatus)
	populate(objectMap, "protectableObjectType", i.ProtectableObjectType)
	populate(objectMap, "registrationStatus", i.RegistrationStatus)
	populate(objectMap, "resourceGroup", i.ResourceGroup)
	populate(objectMap, "virtualMachineId", i.VirtualMachineID)
	populate(objectMap, "virtualMachineVersion", i.VirtualMachineVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IaaSVMContainer.
func (i *IaaSVMContainer) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupManagementType":
			err = unpopulate(val, "BackupManagementType", &i.BackupManagementType)
			delete(rawMsg, key)
		case "containerType":
			err = unpopulate(val, "ContainerType", &i.ContainerType)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &i.FriendlyName)
			delete(rawMsg, key)
		case "healthStatus":
			err = unpopulate(val, "HealthStatus", &i.HealthStatus)
			delete(rawMsg, key)
		case "protectableObjectType":
			err = unpopulate(val, "ProtectableObjectType", &i.ProtectableObjectType)
			delete(rawMsg, key)
		case "registrationStatus":
			err = unpopulate(val, "RegistrationStatus", &i.RegistrationStatus)
			delete(rawMsg, key)
		case "resourceGroup":
			err = unpopulate(val, "ResourceGroup", &i.ResourceGroup)
			delete(rawMsg, key)
		case "virtualMachineId":
			err = unpopulate(val, "VirtualMachineID", &i.VirtualMachineID)
			delete(rawMsg, key)
		case "virtualMachineVersion":
			err = unpopulate(val, "VirtualMachineVersion", &i.VirtualMachineVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IaaSVMProtectableItem.
func (i IaaSVMProtectableItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "backupManagementType", i.BackupManagementType)
	populate(objectMap, "friendlyName", i.FriendlyName)
	objectMap["protectableItemType"] = "IaaSVMProtectableItem"
	populate(objectMap, "protectionState", i.ProtectionState)
	populate(objectMap, "resourceGroup", i.ResourceGroup)
	populate(objectMap, "virtualMachineId", i.VirtualMachineID)
	populate(objectMap, "virtualMachineVersion", i.VirtualMachineVersion)
	populate(objectMap, "workloadType", i.WorkloadType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IaaSVMProtectableItem.
func (i *IaaSVMProtectableItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupManagementType":
			err = unpopulate(val, "BackupManagementType", &i.BackupManagementType)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &i.FriendlyName)
			delete(rawMsg, key)
		case "protectableItemType":
			err = unpopulate(val, "ProtectableItemType", &i.ProtectableItemType)
			delete(rawMsg, key)
		case "protectionState":
			err = unpopulate(val, "ProtectionState", &i.ProtectionState)
			delete(rawMsg, key)
		case "resourceGroup":
			err = unpopulate(val, "ResourceGroup", &i.ResourceGroup)
			delete(rawMsg, key)
		case "virtualMachineId":
			err = unpopulate(val, "VirtualMachineID", &i.VirtualMachineID)
			delete(rawMsg, key)
		case "virtualMachineVersion":
			err = unpopulate(val, "VirtualMachineVersion", &i.VirtualMachineVersion)
			delete(rawMsg, key)
		case "workloadType":
			err = unpopulate(val, "WorkloadType", &i.WorkloadType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IaasVMBackupRequest.
func (i IaasVMBackupRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["objectType"] = "IaasVMBackupRequest"
	populateTimeRFC3339(objectMap, "recoveryPointExpiryTimeInUTC", i.RecoveryPointExpiryTimeInUTC)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IaasVMBackupRequest.
func (i *IaasVMBackupRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "objectType":
			err = unpopulate(val, "ObjectType", &i.ObjectType)
			delete(rawMsg, key)
		case "recoveryPointExpiryTimeInUTC":
			err = unpopulateTimeRFC3339(val, "RecoveryPointExpiryTimeInUTC", &i.RecoveryPointExpiryTimeInUTC)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IaasVMILRRegistrationRequest.
func (i IaasVMILRRegistrationRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "initiatorName", i.InitiatorName)
	objectMap["objectType"] = "IaasVMILRRegistrationRequest"
	populate(objectMap, "recoveryPointId", i.RecoveryPointID)
	populate(objectMap, "renewExistingRegistration", i.RenewExistingRegistration)
	populate(objectMap, "virtualMachineId", i.VirtualMachineID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IaasVMILRRegistrationRequest.
func (i *IaasVMILRRegistrationRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "initiatorName":
			err = unpopulate(val, "InitiatorName", &i.InitiatorName)
			delete(rawMsg, key)
		case "objectType":
			err = unpopulate(val, "ObjectType", &i.ObjectType)
			delete(rawMsg, key)
		case "recoveryPointId":
			err = unpopulate(val, "RecoveryPointID", &i.RecoveryPointID)
			delete(rawMsg, key)
		case "renewExistingRegistration":
			err = unpopulate(val, "RenewExistingRegistration", &i.RenewExistingRegistration)
			delete(rawMsg, key)
		case "virtualMachineId":
			err = unpopulate(val, "VirtualMachineID", &i.VirtualMachineID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IaasVMRecoveryPoint.
func (i IaasVMRecoveryPoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "isInstantIlrSessionActive", i.IsInstantIlrSessionActive)
	populate(objectMap, "isManagedVirtualMachine", i.IsManagedVirtualMachine)
	populate(objectMap, "isSourceVMEncrypted", i.IsSourceVMEncrypted)
	populate(objectMap, "keyAndSecret", i.KeyAndSecret)
	populate(objectMap, "osType", i.OSType)
	objectMap["objectType"] = "IaasVMRecoveryPoint"
	populate(objectMap, "originalStorageAccountOption", i.OriginalStorageAccountOption)
	populate(objectMap, "recoveryPointAdditionalInfo", i.RecoveryPointAdditionalInfo)
	populate(objectMap, "recoveryPointDiskConfiguration", i.RecoveryPointDiskConfiguration)
	populate(objectMap, "recoveryPointMoveReadinessInfo", i.RecoveryPointMoveReadinessInfo)
	populate(objectMap, "recoveryPointTierDetails", i.RecoveryPointTierDetails)
	populateTimeRFC3339(objectMap, "recoveryPointTime", i.RecoveryPointTime)
	populate(objectMap, "recoveryPointType", i.RecoveryPointType)
	populate(objectMap, "sourceVMStorageType", i.SourceVMStorageType)
	populate(objectMap, "virtualMachineSize", i.VirtualMachineSize)
	populate(objectMap, "zones", i.Zones)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IaasVMRecoveryPoint.
func (i *IaasVMRecoveryPoint) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "isInstantIlrSessionActive":
			err = unpopulate(val, "IsInstantIlrSessionActive", &i.IsInstantIlrSessionActive)
			delete(rawMsg, key)
		case "isManagedVirtualMachine":
			err = unpopulate(val, "IsManagedVirtualMachine", &i.IsManagedVirtualMachine)
			delete(rawMsg, key)
		case "isSourceVMEncrypted":
			err = unpopulate(val, "IsSourceVMEncrypted", &i.IsSourceVMEncrypted)
			delete(rawMsg, key)
		case "keyAndSecret":
			err = unpopulate(val, "KeyAndSecret", &i.KeyAndSecret)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &i.OSType)
			delete(rawMsg, key)
		case "objectType":
			err = unpopulate(val, "ObjectType", &i.ObjectType)
			delete(rawMsg, key)
		case "originalStorageAccountOption":
			err = unpopulate(val, "OriginalStorageAccountOption", &i.OriginalStorageAccountOption)
			delete(rawMsg, key)
		case "recoveryPointAdditionalInfo":
			err = unpopulate(val, "RecoveryPointAdditionalInfo", &i.RecoveryPointAdditionalInfo)
			delete(rawMsg, key)
		case "recoveryPointDiskConfiguration":
			err = unpopulate(val, "RecoveryPointDiskConfiguration", &i.RecoveryPointDiskConfiguration)
			delete(rawMsg, key)
		case "recoveryPointMoveReadinessInfo":
			err = unpopulate(val, "RecoveryPointMoveReadinessInfo", &i.RecoveryPointMoveReadinessInfo)
			delete(rawMsg, key)
		case "recoveryPointTierDetails":
			err = unpopulate(val, "RecoveryPointTierDetails", &i.RecoveryPointTierDetails)
			delete(rawMsg, key)
		case "recoveryPointTime":
			err = unpopulateTimeRFC3339(val, "RecoveryPointTime", &i.RecoveryPointTime)
			delete(rawMsg, key)
		case "recoveryPointType":
			err = unpopulate(val, "RecoveryPointType", &i.RecoveryPointType)
			delete(rawMsg, key)
		case "sourceVMStorageType":
			err = unpopulate(val, "SourceVMStorageType", &i.SourceVMStorageType)
			delete(rawMsg, key)
		case "virtualMachineSize":
			err = unpopulate(val, "VirtualMachineSize", &i.VirtualMachineSize)
			delete(rawMsg, key)
		case "zones":
			err = unpopulate(val, "Zones", &i.Zones)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IaasVMRestoreRequest.
func (i IaasVMRestoreRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "affinityGroup", i.AffinityGroup)
	populate(objectMap, "createNewCloudService", i.CreateNewCloudService)
	populate(objectMap, "diskEncryptionSetId", i.DiskEncryptionSetID)
	populate(objectMap, "encryptionDetails", i.EncryptionDetails)
	populate(objectMap, "identityBasedRestoreDetails", i.IdentityBasedRestoreDetails)
	populate(objectMap, "identityInfo", i.IdentityInfo)
	objectMap["objectType"] = "IaasVMRestoreRequest"
	populate(objectMap, "originalStorageAccountOption", i.OriginalStorageAccountOption)
	populate(objectMap, "recoveryPointId", i.RecoveryPointID)
	populate(objectMap, "recoveryType", i.RecoveryType)
	populate(objectMap, "region", i.Region)
	populate(objectMap, "restoreDiskLunList", i.RestoreDiskLunList)
	populate(objectMap, "restoreWithManagedDisks", i.RestoreWithManagedDisks)
	populate(objectMap, "sourceResourceId", i.SourceResourceID)
	populate(objectMap, "storageAccountId", i.StorageAccountID)
	populate(objectMap, "subnetId", i.SubnetID)
	populate(objectMap, "targetDomainNameId", i.TargetDomainNameID)
	populate(objectMap, "targetResourceGroupId", i.TargetResourceGroupID)
	populate(objectMap, "targetVirtualMachineId", i.TargetVirtualMachineID)
	populate(objectMap, "virtualNetworkId", i.VirtualNetworkID)
	populate(objectMap, "zones", i.Zones)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IaasVMRestoreRequest.
func (i *IaasVMRestoreRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "affinityGroup":
			err = unpopulate(val, "AffinityGroup", &i.AffinityGroup)
			delete(rawMsg, key)
		case "createNewCloudService":
			err = unpopulate(val, "CreateNewCloudService", &i.CreateNewCloudService)
			delete(rawMsg, key)
		case "diskEncryptionSetId":
			err = unpopulate(val, "DiskEncryptionSetID", &i.DiskEncryptionSetID)
			delete(rawMsg, key)
		case "encryptionDetails":
			err = unpopulate(val, "EncryptionDetails", &i.EncryptionDetails)
			delete(rawMsg, key)
		case "identityBasedRestoreDetails":
			err = unpopulate(val, "IdentityBasedRestoreDetails", &i.IdentityBasedRestoreDetails)
			delete(rawMsg, key)
		case "identityInfo":
			err = unpopulate(val, "IdentityInfo", &i.IdentityInfo)
			delete(rawMsg, key)
		case "objectType":
			err = unpopulate(val, "ObjectType", &i.ObjectType)
			delete(rawMsg, key)
		case "originalStorageAccountOption":
			err = unpopulate(val, "OriginalStorageAccountOption", &i.OriginalStorageAccountOption)
			delete(rawMsg, key)
		case "recoveryPointId":
			err = unpopulate(val, "RecoveryPointID", &i.RecoveryPointID)
			delete(rawMsg, key)
		case "recoveryType":
			err = unpopulate(val, "RecoveryType", &i.RecoveryType)
			delete(rawMsg, key)
		case "region":
			err = unpopulate(val, "Region", &i.Region)
			delete(rawMsg, key)
		case "restoreDiskLunList":
			err = unpopulate(val, "RestoreDiskLunList", &i.RestoreDiskLunList)
			delete(rawMsg, key)
		case "restoreWithManagedDisks":
			err = unpopulate(val, "RestoreWithManagedDisks", &i.RestoreWithManagedDisks)
			delete(rawMsg, key)
		case "sourceResourceId":
			err = unpopulate(val, "SourceResourceID", &i.SourceResourceID)
			delete(rawMsg, key)
		case "storageAccountId":
			err = unpopulate(val, "StorageAccountID", &i.StorageAccountID)
			delete(rawMsg, key)
		case "subnetId":
			err = unpopulate(val, "SubnetID", &i.SubnetID)
			delete(rawMsg, key)
		case "targetDomainNameId":
			err = unpopulate(val, "TargetDomainNameID", &i.TargetDomainNameID)
			delete(rawMsg, key)
		case "targetResourceGroupId":
			err = unpopulate(val, "TargetResourceGroupID", &i.TargetResourceGroupID)
			delete(rawMsg, key)
		case "targetVirtualMachineId":
			err = unpopulate(val, "TargetVirtualMachineID", &i.TargetVirtualMachineID)
			delete(rawMsg, key)
		case "virtualNetworkId":
			err = unpopulate(val, "VirtualNetworkID", &i.VirtualNetworkID)
			delete(rawMsg, key)
		case "zones":
			err = unpopulate(val, "Zones", &i.Zones)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IaasVMRestoreWithRehydrationRequest.
func (i IaasVMRestoreWithRehydrationRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "affinityGroup", i.AffinityGroup)
	populate(objectMap, "createNewCloudService", i.CreateNewCloudService)
	populate(objectMap, "diskEncryptionSetId", i.DiskEncryptionSetID)
	populate(objectMap, "encryptionDetails", i.EncryptionDetails)
	populate(objectMap, "identityBasedRestoreDetails", i.IdentityBasedRestoreDetails)
	populate(objectMap, "identityInfo", i.IdentityInfo)
	objectMap["objectType"] = "IaasVMRestoreWithRehydrationRequest"
	populate(objectMap, "originalStorageAccountOption", i.OriginalStorageAccountOption)
	populate(objectMap, "recoveryPointId", i.RecoveryPointID)
	populate(objectMap, "recoveryPointRehydrationInfo", i.RecoveryPointRehydrationInfo)
	populate(objectMap, "recoveryType", i.RecoveryType)
	populate(objectMap, "region", i.Region)
	populate(objectMap, "restoreDiskLunList", i.RestoreDiskLunList)
	populate(objectMap, "restoreWithManagedDisks", i.RestoreWithManagedDisks)
	populate(objectMap, "sourceResourceId", i.SourceResourceID)
	populate(objectMap, "storageAccountId", i.StorageAccountID)
	populate(objectMap, "subnetId", i.SubnetID)
	populate(objectMap, "targetDomainNameId", i.TargetDomainNameID)
	populate(objectMap, "targetResourceGroupId", i.TargetResourceGroupID)
	populate(objectMap, "targetVirtualMachineId", i.TargetVirtualMachineID)
	populate(objectMap, "virtualNetworkId", i.VirtualNetworkID)
	populate(objectMap, "zones", i.Zones)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IaasVMRestoreWithRehydrationRequest.
func (i *IaasVMRestoreWithRehydrationRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "affinityGroup":
			err = unpopulate(val, "AffinityGroup", &i.AffinityGroup)
			delete(rawMsg, key)
		case "createNewCloudService":
			err = unpopulate(val, "CreateNewCloudService", &i.CreateNewCloudService)
			delete(rawMsg, key)
		case "diskEncryptionSetId":
			err = unpopulate(val, "DiskEncryptionSetID", &i.DiskEncryptionSetID)
			delete(rawMsg, key)
		case "encryptionDetails":
			err = unpopulate(val, "EncryptionDetails", &i.EncryptionDetails)
			delete(rawMsg, key)
		case "identityBasedRestoreDetails":
			err = unpopulate(val, "IdentityBasedRestoreDetails", &i.IdentityBasedRestoreDetails)
			delete(rawMsg, key)
		case "identityInfo":
			err = unpopulate(val, "IdentityInfo", &i.IdentityInfo)
			delete(rawMsg, key)
		case "objectType":
			err = unpopulate(val, "ObjectType", &i.ObjectType)
			delete(rawMsg, key)
		case "originalStorageAccountOption":
			err = unpopulate(val, "OriginalStorageAccountOption", &i.OriginalStorageAccountOption)
			delete(rawMsg, key)
		case "recoveryPointId":
			err = unpopulate(val, "RecoveryPointID", &i.RecoveryPointID)
			delete(rawMsg, key)
		case "recoveryPointRehydrationInfo":
			err = unpopulate(val, "RecoveryPointRehydrationInfo", &i.RecoveryPointRehydrationInfo)
			delete(rawMsg, key)
		case "recoveryType":
			err = unpopulate(val, "RecoveryType", &i.RecoveryType)
			delete(rawMsg, key)
		case "region":
			err = unpopulate(val, "Region", &i.Region)
			delete(rawMsg, key)
		case "restoreDiskLunList":
			err = unpopulate(val, "RestoreDiskLunList", &i.RestoreDiskLunList)
			delete(rawMsg, key)
		case "restoreWithManagedDisks":
			err = unpopulate(val, "RestoreWithManagedDisks", &i.RestoreWithManagedDisks)
			delete(rawMsg, key)
		case "sourceResourceId":
			err = unpopulate(val, "SourceResourceID", &i.SourceResourceID)
			delete(rawMsg, key)
		case "storageAccountId":
			err = unpopulate(val, "StorageAccountID", &i.StorageAccountID)
			delete(rawMsg, key)
		case "subnetId":
			err = unpopulate(val, "SubnetID", &i.SubnetID)
			delete(rawMsg, key)
		case "targetDomainNameId":
			err = unpopulate(val, "TargetDomainNameID", &i.TargetDomainNameID)
			delete(rawMsg, key)
		case "targetResourceGroupId":
			err = unpopulate(val, "TargetResourceGroupID", &i.TargetResourceGroupID)
			delete(rawMsg, key)
		case "targetVirtualMachineId":
			err = unpopulate(val, "TargetVirtualMachineID", &i.TargetVirtualMachineID)
			delete(rawMsg, key)
		case "virtualNetworkId":
			err = unpopulate(val, "VirtualNetworkID", &i.VirtualNetworkID)
			delete(rawMsg, key)
		case "zones":
			err = unpopulate(val, "Zones", &i.Zones)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InquiryInfo.
func (i InquiryInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "errorDetail", i.ErrorDetail)
	populate(objectMap, "inquiryDetails", i.InquiryDetails)
	populate(objectMap, "status", i.Status)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type Job.
func (j Job) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "activityId", j.ActivityID)
	populate(objectMap, "backupManagementType", j.BackupManagementType)
	populateTimeRFC3339(objectMap, "endTime", j.EndTime)
	populate(objectMap, "entityFriendlyName", j.EntityFriendlyName)
	objectMap["jobType"] = j.JobType
	populate(objectMap, "operation", j.Operation)
	populateTimeRFC3339(objectMap, "startTime", j.StartTime)
	populate(objectMap, "status", j.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Job.
func (j *Job) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "activityId":
			err = unpopulate(val, "ActivityID", &j.ActivityID)
			delete(rawMsg, key)
		case "backupManagementType":
			err = unpopulate(val, "BackupManagementType", &j.BackupManagementType)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulateTimeRFC3339(val, "EndTime", &j.EndTime)
			delete(rawMsg, key)
		case "entityFriendlyName":
			err = unpopulate(val, "EntityFriendlyName", &j.EntityFriendlyName)
			delete(rawMsg, key)
		case "jobType":
			err = unpopulate(val, "JobType", &j.JobType)
			delete(rawMsg, key)
		case "operation":
			err = unpopulate(val, "Operation", &j.Operation)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &j.StartTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &j.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobQueryObject.
func (j *JobQueryObject) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupManagementType":
			err = unpopulate(val, "BackupManagementType", &j.BackupManagementType)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulateTimeRFC3339(val, "EndTime", &j.EndTime)
			delete(rawMsg, key)
		case "jobId":
			err = unpopulate(val, "JobID", &j.JobID)
			delete(rawMsg, key)
		case "operation":
			err = unpopulate(val, "Operation", &j.Operation)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &j.StartTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &j.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobResource.
func (j JobResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "eTag", j.ETag)
	populate(objectMap, "id", j.ID)
	populate(objectMap, "location", j.Location)
	populate(objectMap, "name", j.Name)
	populate(objectMap, "properties", j.Properties)
	populate(objectMap, "tags", j.Tags)
	populate(objectMap, "type", j.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobResource.
func (j *JobResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "eTag":
			err = unpopulate(val, "ETag", &j.ETag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &j.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &j.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &j.Name)
			delete(rawMsg, key)
		case "properties":
			j.Properties, err = unmarshalJobClassification(val)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &j.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &j.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KPIResourceHealthDetails.
func (k KPIResourceHealthDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "resourceHealthDetails", k.ResourceHealthDetails)
	populate(objectMap, "resourceHealthStatus", k.ResourceHealthStatus)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ListRecoveryPointsRecommendedForMoveRequest.
func (l ListRecoveryPointsRecommendedForMoveRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "excludedRPList", l.ExcludedRPList)
	populate(objectMap, "objectType", l.ObjectType)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type LogSchedulePolicy.
func (l LogSchedulePolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "scheduleFrequencyInMins", l.ScheduleFrequencyInMins)
	objectMap["schedulePolicyType"] = "LogSchedulePolicy"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LogSchedulePolicy.
func (l *LogSchedulePolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "scheduleFrequencyInMins":
			err = unpopulate(val, "ScheduleFrequencyInMins", &l.ScheduleFrequencyInMins)
			delete(rawMsg, key)
		case "schedulePolicyType":
			err = unpopulate(val, "SchedulePolicyType", &l.SchedulePolicyType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LongTermRetentionPolicy.
func (l LongTermRetentionPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "dailySchedule", l.DailySchedule)
	populate(objectMap, "monthlySchedule", l.MonthlySchedule)
	objectMap["retentionPolicyType"] = "LongTermRetentionPolicy"
	populate(objectMap, "weeklySchedule", l.WeeklySchedule)
	populate(objectMap, "yearlySchedule", l.YearlySchedule)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LongTermRetentionPolicy.
func (l *LongTermRetentionPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dailySchedule":
			err = unpopulate(val, "DailySchedule", &l.DailySchedule)
			delete(rawMsg, key)
		case "monthlySchedule":
			err = unpopulate(val, "MonthlySchedule", &l.MonthlySchedule)
			delete(rawMsg, key)
		case "retentionPolicyType":
			err = unpopulate(val, "RetentionPolicyType", &l.RetentionPolicyType)
			delete(rawMsg, key)
		case "weeklySchedule":
			err = unpopulate(val, "WeeklySchedule", &l.WeeklySchedule)
			delete(rawMsg, key)
		case "yearlySchedule":
			err = unpopulate(val, "YearlySchedule", &l.YearlySchedule)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LongTermSchedulePolicy.
func (l LongTermSchedulePolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["schedulePolicyType"] = "LongTermSchedulePolicy"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LongTermSchedulePolicy.
func (l *LongTermSchedulePolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "schedulePolicyType":
			err = unpopulate(val, "SchedulePolicyType", &l.SchedulePolicyType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MABContainerHealthDetails.
func (m MABContainerHealthDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "code", m.Code)
	populate(objectMap, "message", m.Message)
	populate(objectMap, "recommendations", m.Recommendations)
	populate(objectMap, "title", m.Title)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type MabContainer.
func (m MabContainer) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "agentVersion", m.AgentVersion)
	populate(objectMap, "backupManagementType", m.BackupManagementType)
	populate(objectMap, "canReRegister", m.CanReRegister)
	populate(objectMap, "containerHealthState", m.ContainerHealthState)
	populate(objectMap, "containerId", m.ContainerID)
	objectMap["containerType"] = ContainerTypeWindows
	populate(objectMap, "extendedInfo", m.ExtendedInfo)
	populate(objectMap, "friendlyName", m.FriendlyName)
	populate(objectMap, "healthStatus", m.HealthStatus)
	populate(objectMap, "mabContainerHealthDetails", m.MabContainerHealthDetails)
	populate(objectMap, "protectableObjectType", m.ProtectableObjectType)
	populate(objectMap, "protectedItemCount", m.ProtectedItemCount)
	populate(objectMap, "registrationStatus", m.RegistrationStatus)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MabContainer.
func (m *MabContainer) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "agentVersion":
			err = unpopulate(val, "AgentVersion", &m.AgentVersion)
			delete(rawMsg, key)
		case "backupManagementType":
			err = unpopulate(val, "BackupManagementType", &m.BackupManagementType)
			delete(rawMsg, key)
		case "canReRegister":
			err = unpopulate(val, "CanReRegister", &m.CanReRegister)
			delete(rawMsg, key)
		case "containerHealthState":
			err = unpopulate(val, "ContainerHealthState", &m.ContainerHealthState)
			delete(rawMsg, key)
		case "containerId":
			err = unpopulate(val, "ContainerID", &m.ContainerID)
			delete(rawMsg, key)
		case "containerType":
			err = unpopulate(val, "ContainerType", &m.ContainerType)
			delete(rawMsg, key)
		case "extendedInfo":
			err = unpopulate(val, "ExtendedInfo", &m.ExtendedInfo)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &m.FriendlyName)
			delete(rawMsg, key)
		case "healthStatus":
			err = unpopulate(val, "HealthStatus", &m.HealthStatus)
			delete(rawMsg, key)
		case "mabContainerHealthDetails":
			err = unpopulate(val, "MabContainerHealthDetails", &m.MabContainerHealthDetails)
			delete(rawMsg, key)
		case "protectableObjectType":
			err = unpopulate(val, "ProtectableObjectType", &m.ProtectableObjectType)
			delete(rawMsg, key)
		case "protectedItemCount":
			err = unpopulate(val, "ProtectedItemCount", &m.ProtectedItemCount)
			delete(rawMsg, key)
		case "registrationStatus":
			err = unpopulate(val, "RegistrationStatus", &m.RegistrationStatus)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MabContainerExtendedInfo.
func (m MabContainerExtendedInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "backupItemType", m.BackupItemType)
	populate(objectMap, "backupItems", m.BackupItems)
	populate(objectMap, "lastBackupStatus", m.LastBackupStatus)
	populateTimeRFC3339(objectMap, "lastRefreshedAt", m.LastRefreshedAt)
	populate(objectMap, "policyName", m.PolicyName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MabContainerExtendedInfo.
func (m *MabContainerExtendedInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupItemType":
			err = unpopulate(val, "BackupItemType", &m.BackupItemType)
			delete(rawMsg, key)
		case "backupItems":
			err = unpopulate(val, "BackupItems", &m.BackupItems)
			delete(rawMsg, key)
		case "lastBackupStatus":
			err = unpopulate(val, "LastBackupStatus", &m.LastBackupStatus)
			delete(rawMsg, key)
		case "lastRefreshedAt":
			err = unpopulateTimeRFC3339(val, "LastRefreshedAt", &m.LastRefreshedAt)
			delete(rawMsg, key)
		case "policyName":
			err = unpopulate(val, "PolicyName", &m.PolicyName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MabErrorInfo.
func (m MabErrorInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "errorString", m.ErrorString)
	populate(objectMap, "recommendations", m.Recommendations)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type MabFileFolderProtectedItem.
func (m MabFileFolderProtectedItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "backupManagementType", m.BackupManagementType)
	populate(objectMap, "backupSetName", m.BackupSetName)
	populate(objectMap, "computerName", m.ComputerName)
	populate(objectMap, "containerName", m.ContainerName)
	populate(objectMap, "createMode", m.CreateMode)
	populate(objectMap, "deferredDeleteSyncTimeInUTC", m.DeferredDeleteSyncTimeInUTC)
	populateTimeRFC3339(objectMap, "deferredDeleteTimeInUTC", m.DeferredDeleteTimeInUTC)
	populate(objectMap, "deferredDeleteTimeRemaining", m.DeferredDeleteTimeRemaining)
	populate(objectMap, "extendedInfo", m.ExtendedInfo)
	populate(objectMap, "friendlyName", m.FriendlyName)
	populate(objectMap, "isArchiveEnabled", m.IsArchiveEnabled)
	populate(objectMap, "isDeferredDeleteScheduleUpcoming", m.IsDeferredDeleteScheduleUpcoming)
	populate(objectMap, "isRehydrate", m.IsRehydrate)
	populate(objectMap, "isScheduledForDeferredDelete", m.IsScheduledForDeferredDelete)
	populate(objectMap, "lastBackupStatus", m.LastBackupStatus)
	populateTimeRFC3339(objectMap, "lastBackupTime", m.LastBackupTime)
	populateTimeRFC3339(objectMap, "lastRecoveryPoint", m.LastRecoveryPoint)
	populate(objectMap, "policyId", m.PolicyID)
	populate(objectMap, "policyName", m.PolicyName)
	objectMap["protectedItemType"] = "MabFileFolderProtectedItem"
	populate(objectMap, "protectionState", m.ProtectionState)
	populate(objectMap, "resourceGuardOperationRequests", m.ResourceGuardOperationRequests)
	populate(objectMap, "sourceResourceId", m.SourceResourceID)
	populate(objectMap, "workloadType", m.WorkloadType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MabFileFolderProtectedItem.
func (m *MabFileFolderProtectedItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupManagementType":
			err = unpopulate(val, "BackupManagementType", &m.BackupManagementType)
			delete(rawMsg, key)
		case "backupSetName":
			err = unpopulate(val, "BackupSetName", &m.BackupSetName)
			delete(rawMsg, key)
		case "computerName":
			err = unpopulate(val, "ComputerName", &m.ComputerName)
			delete(rawMsg, key)
		case "containerName":
			err = unpopulate(val, "ContainerName", &m.ContainerName)
			delete(rawMsg, key)
		case "createMode":
			err = unpopulate(val, "CreateMode", &m.CreateMode)
			delete(rawMsg, key)
		case "deferredDeleteSyncTimeInUTC":
			err = unpopulate(val, "DeferredDeleteSyncTimeInUTC", &m.DeferredDeleteSyncTimeInUTC)
			delete(rawMsg, key)
		case "deferredDeleteTimeInUTC":
			err = unpopulateTimeRFC3339(val, "DeferredDeleteTimeInUTC", &m.DeferredDeleteTimeInUTC)
			delete(rawMsg, key)
		case "deferredDeleteTimeRemaining":
			err = unpopulate(val, "DeferredDeleteTimeRemaining", &m.DeferredDeleteTimeRemaining)
			delete(rawMsg, key)
		case "extendedInfo":
			err = unpopulate(val, "ExtendedInfo", &m.ExtendedInfo)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &m.FriendlyName)
			delete(rawMsg, key)
		case "isArchiveEnabled":
			err = unpopulate(val, "IsArchiveEnabled", &m.IsArchiveEnabled)
			delete(rawMsg, key)
		case "isDeferredDeleteScheduleUpcoming":
			err = unpopulate(val, "IsDeferredDeleteScheduleUpcoming", &m.IsDeferredDeleteScheduleUpcoming)
			delete(rawMsg, key)
		case "isRehydrate":
			err = unpopulate(val, "IsRehydrate", &m.IsRehydrate)
			delete(rawMsg, key)
		case "isScheduledForDeferredDelete":
			err = unpopulate(val, "IsScheduledForDeferredDelete", &m.IsScheduledForDeferredDelete)
			delete(rawMsg, key)
		case "lastBackupStatus":
			err = unpopulate(val, "LastBackupStatus", &m.LastBackupStatus)
			delete(rawMsg, key)
		case "lastBackupTime":
			err = unpopulateTimeRFC3339(val, "LastBackupTime", &m.LastBackupTime)
			delete(rawMsg, key)
		case "lastRecoveryPoint":
			err = unpopulateTimeRFC3339(val, "LastRecoveryPoint", &m.LastRecoveryPoint)
			delete(rawMsg, key)
		case "policyId":
			err = unpopulate(val, "PolicyID", &m.PolicyID)
			delete(rawMsg, key)
		case "policyName":
			err = unpopulate(val, "PolicyName", &m.PolicyName)
			delete(rawMsg, key)
		case "protectedItemType":
			err = unpopulate(val, "ProtectedItemType", &m.ProtectedItemType)
			delete(rawMsg, key)
		case "protectionState":
			err = unpopulate(val, "ProtectionState", &m.ProtectionState)
			delete(rawMsg, key)
		case "resourceGuardOperationRequests":
			err = unpopulate(val, "ResourceGuardOperationRequests", &m.ResourceGuardOperationRequests)
			delete(rawMsg, key)
		case "sourceResourceId":
			err = unpopulate(val, "SourceResourceID", &m.SourceResourceID)
			delete(rawMsg, key)
		case "workloadType":
			err = unpopulate(val, "WorkloadType", &m.WorkloadType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MabFileFolderProtectedItemExtendedInfo.
func (m MabFileFolderProtectedItemExtendedInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "lastRefreshedAt", m.LastRefreshedAt)
	populateTimeRFC3339(objectMap, "oldestRecoveryPoint", m.OldestRecoveryPoint)
	populate(objectMap, "recoveryPointCount", m.RecoveryPointCount)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MabFileFolderProtectedItemExtendedInfo.
func (m *MabFileFolderProtectedItemExtendedInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "lastRefreshedAt":
			err = unpopulateTimeRFC3339(val, "LastRefreshedAt", &m.LastRefreshedAt)
			delete(rawMsg, key)
		case "oldestRecoveryPoint":
			err = unpopulateTimeRFC3339(val, "OldestRecoveryPoint", &m.OldestRecoveryPoint)
			delete(rawMsg, key)
		case "recoveryPointCount":
			err = unpopulate(val, "RecoveryPointCount", &m.RecoveryPointCount)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MabJob.
func (m MabJob) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "actionsInfo", m.ActionsInfo)
	populate(objectMap, "activityId", m.ActivityID)
	populate(objectMap, "backupManagementType", m.BackupManagementType)
	populate(objectMap, "duration", m.Duration)
	populateTimeRFC3339(objectMap, "endTime", m.EndTime)
	populate(objectMap, "entityFriendlyName", m.EntityFriendlyName)
	populate(objectMap, "errorDetails", m.ErrorDetails)
	populate(objectMap, "extendedInfo", m.ExtendedInfo)
	objectMap["jobType"] = "MabJob"
	populate(objectMap, "mabServerName", m.MabServerName)
	populate(objectMap, "mabServerType", m.MabServerType)
	populate(objectMap, "operation", m.Operation)
	populateTimeRFC3339(objectMap, "startTime", m.StartTime)
	populate(objectMap, "status", m.Status)
	populate(objectMap, "workloadType", m.WorkloadType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MabJob.
func (m *MabJob) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actionsInfo":
			err = unpopulate(val, "ActionsInfo", &m.ActionsInfo)
			delete(rawMsg, key)
		case "activityId":
			err = unpopulate(val, "ActivityID", &m.ActivityID)
			delete(rawMsg, key)
		case "backupManagementType":
			err = unpopulate(val, "BackupManagementType", &m.BackupManagementType)
			delete(rawMsg, key)
		case "duration":
			err = unpopulate(val, "Duration", &m.Duration)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulateTimeRFC3339(val, "EndTime", &m.EndTime)
			delete(rawMsg, key)
		case "entityFriendlyName":
			err = unpopulate(val, "EntityFriendlyName", &m.EntityFriendlyName)
			delete(rawMsg, key)
		case "errorDetails":
			err = unpopulate(val, "ErrorDetails", &m.ErrorDetails)
			delete(rawMsg, key)
		case "extendedInfo":
			err = unpopulate(val, "ExtendedInfo", &m.ExtendedInfo)
			delete(rawMsg, key)
		case "jobType":
			err = unpopulate(val, "JobType", &m.JobType)
			delete(rawMsg, key)
		case "mabServerName":
			err = unpopulate(val, "MabServerName", &m.MabServerName)
			delete(rawMsg, key)
		case "mabServerType":
			err = unpopulate(val, "MabServerType", &m.MabServerType)
			delete(rawMsg, key)
		case "operation":
			err = unpopulate(val, "Operation", &m.Operation)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &m.StartTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &m.Status)
			delete(rawMsg, key)
		case "workloadType":
			err = unpopulate(val, "WorkloadType", &m.WorkloadType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MabJobExtendedInfo.
func (m MabJobExtendedInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "dynamicErrorMessage", m.DynamicErrorMessage)
	populate(objectMap, "propertyBag", m.PropertyBag)
	populate(objectMap, "tasksList", m.TasksList)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type MabJobTaskDetails.
func (m MabJobTaskDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "duration", m.Duration)
	populateTimeRFC3339(objectMap, "endTime", m.EndTime)
	populateTimeRFC3339(objectMap, "startTime", m.StartTime)
	populate(objectMap, "status", m.Status)
	populate(objectMap, "taskId", m.TaskID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MabJobTaskDetails.
func (m *MabJobTaskDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "duration":
			err = unpopulate(val, "Duration", &m.Duration)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulateTimeRFC3339(val, "EndTime", &m.EndTime)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &m.StartTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &m.Status)
			delete(rawMsg, key)
		case "taskId":
			err = unpopulate(val, "TaskID", &m.TaskID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MabProtectionPolicy.
func (m MabProtectionPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["backupManagementType"] = "MAB"
	populate(objectMap, "protectedItemsCount", m.ProtectedItemsCount)
	populate(objectMap, "resourceGuardOperationRequests", m.ResourceGuardOperationRequests)
	populate(objectMap, "retentionPolicy", m.RetentionPolicy)
	populate(objectMap, "schedulePolicy", m.SchedulePolicy)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MabProtectionPolicy.
func (m *MabProtectionPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupManagementType":
			err = unpopulate(val, "BackupManagementType", &m.BackupManagementType)
			delete(rawMsg, key)
		case "protectedItemsCount":
			err = unpopulate(val, "ProtectedItemsCount", &m.ProtectedItemsCount)
			delete(rawMsg, key)
		case "resourceGuardOperationRequests":
			err = unpopulate(val, "ResourceGuardOperationRequests", &m.ResourceGuardOperationRequests)
			delete(rawMsg, key)
		case "retentionPolicy":
			m.RetentionPolicy, err = unmarshalRetentionPolicyClassification(val)
			delete(rawMsg, key)
		case "schedulePolicy":
			m.SchedulePolicy, err = unmarshalSchedulePolicyClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MonthlyRetentionSchedule.
func (m MonthlyRetentionSchedule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "retentionDuration", m.RetentionDuration)
	populate(objectMap, "retentionScheduleDaily", m.RetentionScheduleDaily)
	populate(objectMap, "retentionScheduleFormatType", m.RetentionScheduleFormatType)
	populate(objectMap, "retentionScheduleWeekly", m.RetentionScheduleWeekly)
	aux := make([]*timeRFC3339, len(m.RetentionTimes), len(m.RetentionTimes))
	for i := 0; i < len(m.RetentionTimes); i++ {
		aux[i] = (*timeRFC3339)(m.RetentionTimes[i])
	}
	populate(objectMap, "retentionTimes", aux)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationResultInfo.
func (o *OperationResultInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "jobList":
			err = unpopulate(val, "JobList", &o.JobList)
			delete(rawMsg, key)
		case "objectType":
			err = unpopulate(val, "ObjectType", &o.ObjectType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationResultInfoBaseResource.
func (o *OperationResultInfoBaseResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "headers":
			err = unpopulate(val, "Headers", &o.Headers)
			delete(rawMsg, key)
		case "operation":
			o.Operation, err = unmarshalOperationResultInfoBaseClassification(val)
			delete(rawMsg, key)
		case "statusCode":
			err = unpopulate(val, "StatusCode", &o.StatusCode)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationStatus.
func (o *OperationStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endTime":
			err = unpopulateTimeRFC3339(val, "EndTime", &o.EndTime)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &o.Error)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &o.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "properties":
			o.Properties, err = unmarshalOperationStatusExtendedInfoClassification(val)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &o.StartTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &o.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationStatusJobExtendedInfo.
func (o *OperationStatusJobExtendedInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "jobId":
			err = unpopulate(val, "JobID", &o.JobID)
			delete(rawMsg, key)
		case "objectType":
			err = unpopulate(val, "ObjectType", &o.ObjectType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationStatusJobsExtendedInfo.
func (o *OperationStatusJobsExtendedInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "failedJobsError":
			err = unpopulate(val, "FailedJobsError", &o.FailedJobsError)
			delete(rawMsg, key)
		case "jobIds":
			err = unpopulate(val, "JobIDs", &o.JobIDs)
			delete(rawMsg, key)
		case "objectType":
			err = unpopulate(val, "ObjectType", &o.ObjectType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationStatusProvisionILRExtendedInfo.
func (o *OperationStatusProvisionILRExtendedInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "objectType":
			err = unpopulate(val, "ObjectType", &o.ObjectType)
			delete(rawMsg, key)
		case "recoveryTarget":
			err = unpopulate(val, "RecoveryTarget", &o.RecoveryTarget)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationStatusValidateOperationExtendedInfo.
func (o *OperationStatusValidateOperationExtendedInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "objectType":
			err = unpopulate(val, "ObjectType", &o.ObjectType)
			delete(rawMsg, key)
		case "validateOperationResponse":
			err = unpopulate(val, "ValidateOperationResponse", &o.ValidateOperationResponse)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PointInTimeRange.
func (p PointInTimeRange) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "endTime", p.EndTime)
	populateTimeRFC3339(objectMap, "startTime", p.StartTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PointInTimeRange.
func (p *PointInTimeRange) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endTime":
			err = unpopulateTimeRFC3339(val, "EndTime", &p.EndTime)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &p.StartTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrepareDataMoveRequest.
func (p PrepareDataMoveRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "dataMoveLevel", p.DataMoveLevel)
	populate(objectMap, "ignoreMoved", p.IgnoreMoved)
	populate(objectMap, "sourceContainerArmIds", p.SourceContainerArmIDs)
	populate(objectMap, "targetRegion", p.TargetRegion)
	populate(objectMap, "targetResourceId", p.TargetResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrepareDataMoveResponse.
func (p *PrepareDataMoveResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "correlationId":
			err = unpopulate(val, "CorrelationID", &p.CorrelationID)
			delete(rawMsg, key)
		case "objectType":
			err = unpopulate(val, "ObjectType", &p.ObjectType)
			delete(rawMsg, key)
		case "sourceVaultProperties":
			err = unpopulate(val, "SourceVaultProperties", &p.SourceVaultProperties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateEndpointConnectionResource.
func (p PrivateEndpointConnectionResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "eTag", p.ETag)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "location", p.Location)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "tags", p.Tags)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ProtectableContainerResource.
func (p ProtectableContainerResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "eTag", p.ETag)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "location", p.Location)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "tags", p.Tags)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProtectableContainerResource.
func (p *ProtectableContainerResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "eTag":
			err = unpopulate(val, "ETag", &p.ETag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &p.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			p.Properties, err = unmarshalProtectableContainerClassification(val)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &p.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProtectedItem.
func (p ProtectedItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "backupManagementType", p.BackupManagementType)
	populate(objectMap, "backupSetName", p.BackupSetName)
	populate(objectMap, "containerName", p.ContainerName)
	populate(objectMap, "createMode", p.CreateMode)
	populateTimeRFC3339(objectMap, "deferredDeleteTimeInUTC", p.DeferredDeleteTimeInUTC)
	populate(objectMap, "deferredDeleteTimeRemaining", p.DeferredDeleteTimeRemaining)
	populate(objectMap, "isArchiveEnabled", p.IsArchiveEnabled)
	populate(objectMap, "isDeferredDeleteScheduleUpcoming", p.IsDeferredDeleteScheduleUpcoming)
	populate(objectMap, "isRehydrate", p.IsRehydrate)
	populate(objectMap, "isScheduledForDeferredDelete", p.IsScheduledForDeferredDelete)
	populateTimeRFC3339(objectMap, "lastRecoveryPoint", p.LastRecoveryPoint)
	populate(objectMap, "policyId", p.PolicyID)
	populate(objectMap, "policyName", p.PolicyName)
	objectMap["protectedItemType"] = p.ProtectedItemType
	populate(objectMap, "resourceGuardOperationRequests", p.ResourceGuardOperationRequests)
	populate(objectMap, "sourceResourceId", p.SourceResourceID)
	populate(objectMap, "workloadType", p.WorkloadType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProtectedItem.
func (p *ProtectedItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupManagementType":
			err = unpopulate(val, "BackupManagementType", &p.BackupManagementType)
			delete(rawMsg, key)
		case "backupSetName":
			err = unpopulate(val, "BackupSetName", &p.BackupSetName)
			delete(rawMsg, key)
		case "containerName":
			err = unpopulate(val, "ContainerName", &p.ContainerName)
			delete(rawMsg, key)
		case "createMode":
			err = unpopulate(val, "CreateMode", &p.CreateMode)
			delete(rawMsg, key)
		case "deferredDeleteTimeInUTC":
			err = unpopulateTimeRFC3339(val, "DeferredDeleteTimeInUTC", &p.DeferredDeleteTimeInUTC)
			delete(rawMsg, key)
		case "deferredDeleteTimeRemaining":
			err = unpopulate(val, "DeferredDeleteTimeRemaining", &p.DeferredDeleteTimeRemaining)
			delete(rawMsg, key)
		case "isArchiveEnabled":
			err = unpopulate(val, "IsArchiveEnabled", &p.IsArchiveEnabled)
			delete(rawMsg, key)
		case "isDeferredDeleteScheduleUpcoming":
			err = unpopulate(val, "IsDeferredDeleteScheduleUpcoming", &p.IsDeferredDeleteScheduleUpcoming)
			delete(rawMsg, key)
		case "isRehydrate":
			err = unpopulate(val, "IsRehydrate", &p.IsRehydrate)
			delete(rawMsg, key)
		case "isScheduledForDeferredDelete":
			err = unpopulate(val, "IsScheduledForDeferredDelete", &p.IsScheduledForDeferredDelete)
			delete(rawMsg, key)
		case "lastRecoveryPoint":
			err = unpopulateTimeRFC3339(val, "LastRecoveryPoint", &p.LastRecoveryPoint)
			delete(rawMsg, key)
		case "policyId":
			err = unpopulate(val, "PolicyID", &p.PolicyID)
			delete(rawMsg, key)
		case "policyName":
			err = unpopulate(val, "PolicyName", &p.PolicyName)
			delete(rawMsg, key)
		case "protectedItemType":
			err = unpopulate(val, "ProtectedItemType", &p.ProtectedItemType)
			delete(rawMsg, key)
		case "resourceGuardOperationRequests":
			err = unpopulate(val, "ResourceGuardOperationRequests", &p.ResourceGuardOperationRequests)
			delete(rawMsg, key)
		case "sourceResourceId":
			err = unpopulate(val, "SourceResourceID", &p.SourceResourceID)
			delete(rawMsg, key)
		case "workloadType":
			err = unpopulate(val, "WorkloadType", &p.WorkloadType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProtectedItemResource.
func (p ProtectedItemResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "eTag", p.ETag)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "location", p.Location)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "tags", p.Tags)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProtectedItemResource.
func (p *ProtectedItemResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "eTag":
			err = unpopulate(val, "ETag", &p.ETag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &p.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			p.Properties, err = unmarshalProtectedItemClassification(val)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &p.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProtectionContainerResource.
func (p ProtectionContainerResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "eTag", p.ETag)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "location", p.Location)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "tags", p.Tags)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProtectionContainerResource.
func (p *ProtectionContainerResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "eTag":
			err = unpopulate(val, "ETag", &p.ETag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &p.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			p.Properties, err = unmarshalProtectionContainerClassification(val)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &p.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProtectionIntentResource.
func (p ProtectionIntentResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "eTag", p.ETag)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "location", p.Location)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "tags", p.Tags)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProtectionIntentResource.
func (p *ProtectionIntentResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "eTag":
			err = unpopulate(val, "ETag", &p.ETag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &p.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			p.Properties, err = unmarshalProtectionIntentClassification(val)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &p.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProtectionPolicy.
func (p ProtectionPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["backupManagementType"] = p.BackupManagementType
	populate(objectMap, "protectedItemsCount", p.ProtectedItemsCount)
	populate(objectMap, "resourceGuardOperationRequests", p.ResourceGuardOperationRequests)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ProtectionPolicyResource.
func (p ProtectionPolicyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "eTag", p.ETag)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "location", p.Location)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "tags", p.Tags)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProtectionPolicyResource.
func (p *ProtectionPolicyResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "eTag":
			err = unpopulate(val, "ETag", &p.ETag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &p.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			p.Properties, err = unmarshalProtectionPolicyClassification(val)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &p.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecoveryPointDiskConfiguration.
func (r RecoveryPointDiskConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "excludedDiskList", r.ExcludedDiskList)
	populate(objectMap, "includedDiskList", r.IncludedDiskList)
	populate(objectMap, "numberOfDisksAttachedToVm", r.NumberOfDisksAttachedToVM)
	populate(objectMap, "numberOfDisksIncludedInBackup", r.NumberOfDisksIncludedInBackup)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type RecoveryPointResource.
func (r RecoveryPointResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "eTag", r.ETag)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "location", r.Location)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "tags", r.Tags)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecoveryPointResource.
func (r *RecoveryPointResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "eTag":
			err = unpopulate(val, "ETag", &r.ETag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &r.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			r.Properties, err = unmarshalRecoveryPointClassification(val)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &r.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecoveryPointTierInformation.
func (r RecoveryPointTierInformation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "extendedInfo", r.ExtendedInfo)
	populate(objectMap, "status", r.Status)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type RecoveryPointTierInformationV2.
func (r RecoveryPointTierInformationV2) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "extendedInfo", r.ExtendedInfo)
	populate(objectMap, "status", r.Status)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "eTag", r.ETag)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "location", r.Location)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "tags", r.Tags)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ResourceGuardProxyBase.
func (r ResourceGuardProxyBase) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "description", r.Description)
	populate(objectMap, "lastUpdatedTime", r.LastUpdatedTime)
	populate(objectMap, "resourceGuardOperationDetails", r.ResourceGuardOperationDetails)
	populate(objectMap, "resourceGuardResourceId", r.ResourceGuardResourceID)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ResourceGuardProxyBaseResource.
func (r ResourceGuardProxyBaseResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "eTag", r.ETag)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "location", r.Location)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "tags", r.Tags)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ResourceHealthDetails.
func (r ResourceHealthDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "code", r.Code)
	populate(objectMap, "message", r.Message)
	populate(objectMap, "recommendations", r.Recommendations)
	populate(objectMap, "title", r.Title)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type RestoreRequestResource.
func (r RestoreRequestResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "eTag", r.ETag)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "location", r.Location)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "tags", r.Tags)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RestoreRequestResource.
func (r *RestoreRequestResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "eTag":
			err = unpopulate(val, "ETag", &r.ETag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &r.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			r.Properties, err = unmarshalRestoreRequestClassification(val)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &r.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecurityPinBase.
func (s SecurityPinBase) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "resourceGuardOperationRequests", s.ResourceGuardOperationRequests)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type SimpleRetentionPolicy.
func (s SimpleRetentionPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "retentionDuration", s.RetentionDuration)
	objectMap["retentionPolicyType"] = "SimpleRetentionPolicy"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SimpleRetentionPolicy.
func (s *SimpleRetentionPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "retentionDuration":
			err = unpopulate(val, "RetentionDuration", &s.RetentionDuration)
			delete(rawMsg, key)
		case "retentionPolicyType":
			err = unpopulate(val, "RetentionPolicyType", &s.RetentionPolicyType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SimpleSchedulePolicy.
func (s SimpleSchedulePolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "hourlySchedule", s.HourlySchedule)
	objectMap["schedulePolicyType"] = "SimpleSchedulePolicy"
	populate(objectMap, "scheduleRunDays", s.ScheduleRunDays)
	populate(objectMap, "scheduleRunFrequency", s.ScheduleRunFrequency)
	aux := make([]*timeRFC3339, len(s.ScheduleRunTimes), len(s.ScheduleRunTimes))
	for i := 0; i < len(s.ScheduleRunTimes); i++ {
		aux[i] = (*timeRFC3339)(s.ScheduleRunTimes[i])
	}
	populate(objectMap, "scheduleRunTimes", aux)
	populate(objectMap, "scheduleWeeklyFrequency", s.ScheduleWeeklyFrequency)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SimpleSchedulePolicy.
func (s *SimpleSchedulePolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "hourlySchedule":
			err = unpopulate(val, "HourlySchedule", &s.HourlySchedule)
			delete(rawMsg, key)
		case "schedulePolicyType":
			err = unpopulate(val, "SchedulePolicyType", &s.SchedulePolicyType)
			delete(rawMsg, key)
		case "scheduleRunDays":
			err = unpopulate(val, "ScheduleRunDays", &s.ScheduleRunDays)
			delete(rawMsg, key)
		case "scheduleRunFrequency":
			err = unpopulate(val, "ScheduleRunFrequency", &s.ScheduleRunFrequency)
			delete(rawMsg, key)
		case "scheduleRunTimes":
			var aux []*timeRFC3339
			err = unpopulate(val, "ScheduleRunTimes", &aux)
			for _, au := range aux {
				s.ScheduleRunTimes = append(s.ScheduleRunTimes, (*time.Time)(au))
			}
			delete(rawMsg, key)
		case "scheduleWeeklyFrequency":
			err = unpopulate(val, "ScheduleWeeklyFrequency", &s.ScheduleWeeklyFrequency)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SimpleSchedulePolicyV2.
func (s SimpleSchedulePolicyV2) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "dailySchedule", s.DailySchedule)
	populate(objectMap, "hourlySchedule", s.HourlySchedule)
	objectMap["schedulePolicyType"] = "SimpleSchedulePolicyV2"
	populate(objectMap, "scheduleRunFrequency", s.ScheduleRunFrequency)
	populate(objectMap, "weeklySchedule", s.WeeklySchedule)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SimpleSchedulePolicyV2.
func (s *SimpleSchedulePolicyV2) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dailySchedule":
			err = unpopulate(val, "DailySchedule", &s.DailySchedule)
			delete(rawMsg, key)
		case "hourlySchedule":
			err = unpopulate(val, "HourlySchedule", &s.HourlySchedule)
			delete(rawMsg, key)
		case "schedulePolicyType":
			err = unpopulate(val, "SchedulePolicyType", &s.SchedulePolicyType)
			delete(rawMsg, key)
		case "scheduleRunFrequency":
			err = unpopulate(val, "ScheduleRunFrequency", &s.ScheduleRunFrequency)
			delete(rawMsg, key)
		case "weeklySchedule":
			err = unpopulate(val, "WeeklySchedule", &s.WeeklySchedule)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SubProtectionPolicy.
func (s SubProtectionPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "policyType", s.PolicyType)
	populate(objectMap, "retentionPolicy", s.RetentionPolicy)
	populate(objectMap, "schedulePolicy", s.SchedulePolicy)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SubProtectionPolicy.
func (s *SubProtectionPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "policyType":
			err = unpopulate(val, "PolicyType", &s.PolicyType)
			delete(rawMsg, key)
		case "retentionPolicy":
			s.RetentionPolicy, err = unmarshalRetentionPolicyClassification(val)
			delete(rawMsg, key)
		case "schedulePolicy":
			s.SchedulePolicy, err = unmarshalSchedulePolicyClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TriggerDataMoveRequest.
func (t TriggerDataMoveRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "correlationId", t.CorrelationID)
	populate(objectMap, "dataMoveLevel", t.DataMoveLevel)
	populate(objectMap, "pauseGC", t.PauseGC)
	populate(objectMap, "sourceContainerArmIds", t.SourceContainerArmIDs)
	populate(objectMap, "sourceRegion", t.SourceRegion)
	populate(objectMap, "sourceResourceId", t.SourceResourceID)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type UnlockDeleteRequest.
func (u UnlockDeleteRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "resourceGuardOperationRequests", u.ResourceGuardOperationRequests)
	populate(objectMap, "resourceToBeDeleted", u.ResourceToBeDeleted)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ValidateIaasVMRestoreOperationRequest.
func (v ValidateIaasVMRestoreOperationRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["objectType"] = "ValidateIaasVMRestoreOperationRequest"
	populate(objectMap, "restoreRequest", v.RestoreRequest)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ValidateIaasVMRestoreOperationRequest.
func (v *ValidateIaasVMRestoreOperationRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "objectType":
			err = unpopulate(val, "ObjectType", &v.ObjectType)
			delete(rawMsg, key)
		case "restoreRequest":
			v.RestoreRequest, err = unmarshalRestoreRequestClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ValidateRestoreOperationRequest.
func (v ValidateRestoreOperationRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["objectType"] = "ValidateRestoreOperationRequest"
	populate(objectMap, "restoreRequest", v.RestoreRequest)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ValidateRestoreOperationRequest.
func (v *ValidateRestoreOperationRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "objectType":
			err = unpopulate(val, "ObjectType", &v.ObjectType)
			delete(rawMsg, key)
		case "restoreRequest":
			v.RestoreRequest, err = unmarshalRestoreRequestClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VaultJob.
func (v VaultJob) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "actionsInfo", v.ActionsInfo)
	populate(objectMap, "activityId", v.ActivityID)
	populate(objectMap, "backupManagementType", v.BackupManagementType)
	populate(objectMap, "duration", v.Duration)
	populateTimeRFC3339(objectMap, "endTime", v.EndTime)
	populate(objectMap, "entityFriendlyName", v.EntityFriendlyName)
	populate(objectMap, "errorDetails", v.ErrorDetails)
	populate(objectMap, "extendedInfo", v.ExtendedInfo)
	objectMap["jobType"] = "VaultJob"
	populate(objectMap, "operation", v.Operation)
	populateTimeRFC3339(objectMap, "startTime", v.StartTime)
	populate(objectMap, "status", v.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VaultJob.
func (v *VaultJob) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actionsInfo":
			err = unpopulate(val, "ActionsInfo", &v.ActionsInfo)
			delete(rawMsg, key)
		case "activityId":
			err = unpopulate(val, "ActivityID", &v.ActivityID)
			delete(rawMsg, key)
		case "backupManagementType":
			err = unpopulate(val, "BackupManagementType", &v.BackupManagementType)
			delete(rawMsg, key)
		case "duration":
			err = unpopulate(val, "Duration", &v.Duration)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulateTimeRFC3339(val, "EndTime", &v.EndTime)
			delete(rawMsg, key)
		case "entityFriendlyName":
			err = unpopulate(val, "EntityFriendlyName", &v.EntityFriendlyName)
			delete(rawMsg, key)
		case "errorDetails":
			err = unpopulate(val, "ErrorDetails", &v.ErrorDetails)
			delete(rawMsg, key)
		case "extendedInfo":
			err = unpopulate(val, "ExtendedInfo", &v.ExtendedInfo)
			delete(rawMsg, key)
		case "jobType":
			err = unpopulate(val, "JobType", &v.JobType)
			delete(rawMsg, key)
		case "operation":
			err = unpopulate(val, "Operation", &v.Operation)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &v.StartTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &v.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VaultJobErrorInfo.
func (v VaultJobErrorInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "errorCode", v.ErrorCode)
	populate(objectMap, "errorString", v.ErrorString)
	populate(objectMap, "recommendations", v.Recommendations)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type VaultJobExtendedInfo.
func (v VaultJobExtendedInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "propertyBag", v.PropertyBag)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type WeeklyRetentionFormat.
func (w WeeklyRetentionFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "daysOfTheWeek", w.DaysOfTheWeek)
	populate(objectMap, "weeksOfTheMonth", w.WeeksOfTheMonth)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type WeeklyRetentionSchedule.
func (w WeeklyRetentionSchedule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "daysOfTheWeek", w.DaysOfTheWeek)
	populate(objectMap, "retentionDuration", w.RetentionDuration)
	aux := make([]*timeRFC3339, len(w.RetentionTimes), len(w.RetentionTimes))
	for i := 0; i < len(w.RetentionTimes); i++ {
		aux[i] = (*timeRFC3339)(w.RetentionTimes[i])
	}
	populate(objectMap, "retentionTimes", aux)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type WeeklySchedule.
func (w WeeklySchedule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "scheduleRunDays", w.ScheduleRunDays)
	aux := make([]*timeRFC3339, len(w.ScheduleRunTimes), len(w.ScheduleRunTimes))
	for i := 0; i < len(w.ScheduleRunTimes); i++ {
		aux[i] = (*timeRFC3339)(w.ScheduleRunTimes[i])
	}
	populate(objectMap, "scheduleRunTimes", aux)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type WorkloadItemResource.
func (w WorkloadItemResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "eTag", w.ETag)
	populate(objectMap, "id", w.ID)
	populate(objectMap, "location", w.Location)
	populate(objectMap, "name", w.Name)
	populate(objectMap, "properties", w.Properties)
	populate(objectMap, "tags", w.Tags)
	populate(objectMap, "type", w.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkloadItemResource.
func (w *WorkloadItemResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "eTag":
			err = unpopulate(val, "ETag", &w.ETag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &w.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &w.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &w.Name)
			delete(rawMsg, key)
		case "properties":
			w.Properties, err = unmarshalWorkloadItemClassification(val)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &w.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &w.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkloadProtectableItemResource.
func (w WorkloadProtectableItemResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "eTag", w.ETag)
	populate(objectMap, "id", w.ID)
	populate(objectMap, "location", w.Location)
	populate(objectMap, "name", w.Name)
	populate(objectMap, "properties", w.Properties)
	populate(objectMap, "tags", w.Tags)
	populate(objectMap, "type", w.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkloadProtectableItemResource.
func (w *WorkloadProtectableItemResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "eTag":
			err = unpopulate(val, "ETag", &w.ETag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &w.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &w.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &w.Name)
			delete(rawMsg, key)
		case "properties":
			w.Properties, err = unmarshalWorkloadProtectableItemClassification(val)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &w.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &w.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type YearlyRetentionSchedule.
func (y YearlyRetentionSchedule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "monthsOfYear", y.MonthsOfYear)
	populate(objectMap, "retentionDuration", y.RetentionDuration)
	populate(objectMap, "retentionScheduleDaily", y.RetentionScheduleDaily)
	populate(objectMap, "retentionScheduleFormatType", y.RetentionScheduleFormatType)
	populate(objectMap, "retentionScheduleWeekly", y.RetentionScheduleWeekly)
	aux := make([]*timeRFC3339, len(y.RetentionTimes), len(y.RetentionTimes))
	for i := 0; i < len(y.RetentionTimes); i++ {
		aux[i] = (*timeRFC3339)(y.RetentionTimes[i])
	}
	populate(objectMap, "retentionTimes", aux)
	return json.Marshal(objectMap)
}

func populate(m map[string]interface{}, k string, v interface{}) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v interface{}) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
