//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armoperationalinsights

import "time"

// AssociatedWorkspace - The list of Log Analytics workspaces associated with the cluster.
type AssociatedWorkspace struct {
	// READ-ONLY; The time of workspace association.
	AssociateDate *string `json:"associateDate,omitempty" azure:"ro"`

	// READ-ONLY; The ResourceId id the assigned workspace.
	ResourceID *string `json:"resourceId,omitempty" azure:"ro"`

	// READ-ONLY; The id of the assigned workspace.
	WorkspaceID *string `json:"workspaceId,omitempty" azure:"ro"`

	// READ-ONLY; The name id the assigned workspace.
	WorkspaceName *string `json:"workspaceName,omitempty" azure:"ro"`
}

// AvailableServiceTier - Service Tier details.
type AvailableServiceTier struct {
	// READ-ONLY; The capacity reservation level in GB per day. Returned for the Capacity Reservation Service Tier.
	CapacityReservationLevel *int64 `json:"capacityReservationLevel,omitempty" azure:"ro"`

	// READ-ONLY; The default retention for the Service Tier, in days.
	DefaultRetention *int64 `json:"defaultRetention,omitempty" azure:"ro"`

	// READ-ONLY; True if the Service Tier is enabled for the workspace.
	Enabled *bool `json:"enabled,omitempty" azure:"ro"`

	// READ-ONLY; Time when the sku was last updated for the workspace. Returned for the Capacity Reservation Service Tier.
	LastSKUUpdate *string `json:"lastSkuUpdate,omitempty" azure:"ro"`

	// READ-ONLY; The maximum retention for the Service Tier, in days.
	MaximumRetention *int64 `json:"maximumRetention,omitempty" azure:"ro"`

	// READ-ONLY; The minimum retention for the Service Tier, in days.
	MinimumRetention *int64 `json:"minimumRetention,omitempty" azure:"ro"`

	// READ-ONLY; The name of the Service Tier.
	ServiceTier *SKUNameEnum `json:"serviceTier,omitempty" azure:"ro"`
}

// AvailableServiceTiersClientListByWorkspaceOptions contains the optional parameters for the AvailableServiceTiersClient.ListByWorkspace
// method.
type AvailableServiceTiersClientListByWorkspaceOptions struct {
	// placeholder for future optional parameters
}

// AzureEntityResource - The resource model definition for an Azure Resource Manager resource with an etag.
type AzureEntityResource struct {
	// READ-ONLY; Resource Etag.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AzureResourceProperties - An Azure resource QueryPack-Query object
type AzureResourceProperties struct {
	// READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Read only system data
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// CapacityReservationProperties - The Capacity Reservation properties.
type CapacityReservationProperties struct {
	// READ-ONLY; The last time Sku was updated.
	LastSKUUpdate *string `json:"lastSkuUpdate,omitempty" azure:"ro"`

	// READ-ONLY; Minimum CapacityReservation value in GB.
	MinCapacity *int64 `json:"minCapacity,omitempty" azure:"ro"`
}

// Cluster - The top level Log Analytics cluster resource container.
type Cluster struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// The identity of the resource.
	Identity *Identity `json:"identity,omitempty"`

	// Log Analytics cluster properties.
	Properties *ClusterProperties `json:"properties,omitempty"`

	// The sku properties.
	SKU *ClusterSKU `json:"sku,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ClusterListResult - The list clusters operation response.
type ClusterListResult struct {
	// The link used to get the next page of recommendations.
	NextLink *string `json:"nextLink,omitempty"`

	// A list of Log Analytics clusters.
	Value []*Cluster `json:"value,omitempty"`
}

// ClusterPatch - The top level Log Analytics cluster resource container.
type ClusterPatch struct {
	// The identity of the resource.
	Identity *Identity `json:"identity,omitempty"`

	// Log Analytics cluster properties.
	Properties *ClusterPatchProperties `json:"properties,omitempty"`

	// The sku properties.
	SKU *ClusterSKU `json:"sku,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`
}

// ClusterPatchProperties - Log Analytics cluster patch properties.
type ClusterPatchProperties struct {
	// The cluster's billing type.
	BillingType *BillingType `json:"billingType,omitempty"`

	// The associated key properties.
	KeyVaultProperties *KeyVaultProperties `json:"keyVaultProperties,omitempty"`
}

// ClusterProperties - Cluster properties.
type ClusterProperties struct {
	// The list of Log Analytics workspaces associated with the cluster
	AssociatedWorkspaces []*AssociatedWorkspace `json:"associatedWorkspaces,omitempty"`

	// The cluster's billing type.
	BillingType *BillingType `json:"billingType,omitempty"`

	// Additional properties for capacity reservation
	CapacityReservationProperties *CapacityReservationProperties `json:"capacityReservationProperties,omitempty"`

	// Sets whether the cluster will support availability zones. This can be set as true only in regions where Azure Data Explorer
	// support Availability Zones. This Property can not be modified after cluster
	// creation. Default value is 'true' if region supports Availability Zones.
	IsAvailabilityZonesEnabled *bool `json:"isAvailabilityZonesEnabled,omitempty"`

	// Configures whether cluster will use double encryption. This Property can not be modified after cluster creation. Default
	// value is 'true'
	IsDoubleEncryptionEnabled *bool `json:"isDoubleEncryptionEnabled,omitempty"`

	// The associated key properties.
	KeyVaultProperties *KeyVaultProperties `json:"keyVaultProperties,omitempty"`

	// READ-ONLY; The ID associated with the cluster.
	ClusterID *string `json:"clusterId,omitempty" azure:"ro"`

	// READ-ONLY; The cluster creation time
	CreatedDate *string `json:"createdDate,omitempty" azure:"ro"`

	// READ-ONLY; The last time the cluster was updated.
	LastModifiedDate *string `json:"lastModifiedDate,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the cluster.
	ProvisioningState *ClusterEntityStatus `json:"provisioningState,omitempty" azure:"ro"`
}

// ClusterSKU - The cluster sku definition.
type ClusterSKU struct {
	// The capacity value
	Capacity *Capacity `json:"capacity,omitempty"`

	// The name of the SKU.
	Name *ClusterSKUNameEnum `json:"name,omitempty"`
}

// ClustersClientBeginCreateOrUpdateOptions contains the optional parameters for the ClustersClient.BeginCreateOrUpdate method.
type ClustersClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ClustersClientBeginDeleteOptions contains the optional parameters for the ClustersClient.BeginDelete method.
type ClustersClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ClustersClientBeginUpdateOptions contains the optional parameters for the ClustersClient.BeginUpdate method.
type ClustersClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ClustersClientGetOptions contains the optional parameters for the ClustersClient.Get method.
type ClustersClientGetOptions struct {
	// placeholder for future optional parameters
}

// ClustersClientListByResourceGroupOptions contains the optional parameters for the ClustersClient.ListByResourceGroup method.
type ClustersClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// ClustersClientListOptions contains the optional parameters for the ClustersClient.List method.
type ClustersClientListOptions struct {
	// placeholder for future optional parameters
}

// Column - Table column.
type Column struct {
	// Column data type logical hint.
	DataTypeHint *ColumnDataTypeHintEnum `json:"dataTypeHint,omitempty"`

	// Column description.
	Description *string `json:"description,omitempty"`

	// Column display name.
	DisplayName *string `json:"displayName,omitempty"`

	// Column name.
	Name *string `json:"name,omitempty"`

	// Column data type.
	Type *ColumnTypeEnum `json:"type,omitempty"`

	// READ-ONLY; Is displayed by default.
	IsDefaultDisplay *bool `json:"isDefaultDisplay,omitempty" azure:"ro"`

	// READ-ONLY; Is column hidden.
	IsHidden *bool `json:"isHidden,omitempty" azure:"ro"`
}

// CoreSummary - The core summary of a search.
type CoreSummary struct {
	// REQUIRED; The number of documents of a core summary.
	NumberOfDocuments *int64 `json:"numberOfDocuments,omitempty"`

	// The status of a core summary.
	Status *string `json:"status,omitempty"`
}

// DataExport - The top level data export resource container.
type DataExport struct {
	// data export properties.
	Properties *DataExportProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DataExportListResult - Result of the request to list data exports.
type DataExportListResult struct {
	// List of data export instances within a workspace..
	Value []*DataExport `json:"value,omitempty"`
}

// DataExportProperties - Data Export properties.
type DataExportProperties struct {
	// REQUIRED; An array of tables to export, for example: [“Heartbeat, SecurityEvent”].
	TableNames []*string `json:"tableNames,omitempty"`

	// The latest data export rule modification time.
	CreatedDate *string `json:"createdDate,omitempty"`

	// The data export rule ID.
	DataExportID *string `json:"dataExportId,omitempty"`

	// destination properties.
	Destination *Destination `json:"destination,omitempty"`

	// Active when enabled.
	Enable *bool `json:"enable,omitempty"`

	// Date and time when the export was last modified.
	LastModifiedDate *string `json:"lastModifiedDate,omitempty"`
}

// DataExportsClientCreateOrUpdateOptions contains the optional parameters for the DataExportsClient.CreateOrUpdate method.
type DataExportsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// DataExportsClientDeleteOptions contains the optional parameters for the DataExportsClient.Delete method.
type DataExportsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// DataExportsClientGetOptions contains the optional parameters for the DataExportsClient.Get method.
type DataExportsClientGetOptions struct {
	// placeholder for future optional parameters
}

// DataExportsClientListByWorkspaceOptions contains the optional parameters for the DataExportsClient.ListByWorkspace method.
type DataExportsClientListByWorkspaceOptions struct {
	// placeholder for future optional parameters
}

// DataSource - Datasources under OMS Workspace.
type DataSource struct {
	// REQUIRED; The kind of the DataSource.
	Kind *DataSourceKind `json:"kind,omitempty"`

	// REQUIRED; The data source properties in raw json format, each kind of data source have it's own schema.
	Properties interface{} `json:"properties,omitempty"`

	// The ETag of the data source.
	Etag *string `json:"etag,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DataSourceFilter - DataSource filter. Right now, only filter by kind is supported.
type DataSourceFilter struct {
	// The kind of the DataSource.
	Kind *DataSourceKind `json:"kind,omitempty"`
}

// DataSourceListResult - The list data source by workspace operation response.
type DataSourceListResult struct {
	// The link (url) to the next page of datasources.
	NextLink *string `json:"nextLink,omitempty"`

	// A list of datasources.
	Value []*DataSource `json:"value,omitempty"`
}

// DataSourcesClientCreateOrUpdateOptions contains the optional parameters for the DataSourcesClient.CreateOrUpdate method.
type DataSourcesClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// DataSourcesClientDeleteOptions contains the optional parameters for the DataSourcesClient.Delete method.
type DataSourcesClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// DataSourcesClientGetOptions contains the optional parameters for the DataSourcesClient.Get method.
type DataSourcesClientGetOptions struct {
	// placeholder for future optional parameters
}

// DataSourcesClientListByWorkspaceOptions contains the optional parameters for the DataSourcesClient.ListByWorkspace method.
type DataSourcesClientListByWorkspaceOptions struct {
	// Starting point of the collection of data source instances.
	Skiptoken *string
}

// DeletedWorkspacesClientListByResourceGroupOptions contains the optional parameters for the DeletedWorkspacesClient.ListByResourceGroup
// method.
type DeletedWorkspacesClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// DeletedWorkspacesClientListOptions contains the optional parameters for the DeletedWorkspacesClient.List method.
type DeletedWorkspacesClientListOptions struct {
	// placeholder for future optional parameters
}

// Destination properties.
type Destination struct {
	// REQUIRED; The destination resource ID. This can be copied from the Properties entry of the destination resource in Azure.
	ResourceID *string `json:"resourceId,omitempty"`

	// destination meta data.
	MetaData *DestinationMetaData `json:"metaData,omitempty"`

	// READ-ONLY; The type of the destination resource
	Type *Type `json:"type,omitempty" azure:"ro"`
}

// DestinationMetaData - Destination meta data.
type DestinationMetaData struct {
	// Optional. Allows to define an Event Hub name. Not applicable when destination is Storage Account.
	EventHubName *string `json:"eventHubName,omitempty"`
}

// ErrorAdditionalInfo - The resource management error additional info.
type ErrorAdditionalInfo struct {
	// READ-ONLY; The additional info.
	Info interface{} `json:"info,omitempty" azure:"ro"`

	// READ-ONLY; The additional info type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ErrorDetail - The error detail.
type ErrorDetail struct {
	// READ-ONLY; The error additional info.
	AdditionalInfo []*ErrorAdditionalInfo `json:"additionalInfo,omitempty" azure:"ro"`

	// READ-ONLY; The error code.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; The error details.
	Details []*ErrorDetail `json:"details,omitempty" azure:"ro"`

	// READ-ONLY; The error message.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; The error target.
	Target *string `json:"target,omitempty" azure:"ro"`
}

// ErrorResponse - Common error response for all Azure Resource Manager APIs to return error details for failed operations.
// (This also follows the OData error response format.).
type ErrorResponse struct {
	// The error object.
	Error *ErrorDetail `json:"error,omitempty"`
}

// GatewaysClientDeleteOptions contains the optional parameters for the GatewaysClient.Delete method.
type GatewaysClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// Identity for the resource.
type Identity struct {
	// REQUIRED; Type of managed service identity.
	Type *IdentityType `json:"type,omitempty"`

	// The list of user identities associated with the resource. The user identity dictionary key references will be ARM resource
	// ids in the form:
	// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
	UserAssignedIdentities map[string]*UserIdentityProperties `json:"userAssignedIdentities,omitempty"`

	// READ-ONLY; The principal ID of resource identity.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`

	// READ-ONLY; The tenant ID of resource.
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

// IntelligencePack - Intelligence Pack containing a string name and boolean indicating if it's enabled.
type IntelligencePack struct {
	// The display name of the intelligence pack.
	DisplayName *string `json:"displayName,omitempty"`

	// The enabled boolean for the intelligence pack.
	Enabled *bool `json:"enabled,omitempty"`

	// The name of the intelligence pack.
	Name *string `json:"name,omitempty"`
}

// IntelligencePacksClientDisableOptions contains the optional parameters for the IntelligencePacksClient.Disable method.
type IntelligencePacksClientDisableOptions struct {
	// placeholder for future optional parameters
}

// IntelligencePacksClientEnableOptions contains the optional parameters for the IntelligencePacksClient.Enable method.
type IntelligencePacksClientEnableOptions struct {
	// placeholder for future optional parameters
}

// IntelligencePacksClientListOptions contains the optional parameters for the IntelligencePacksClient.List method.
type IntelligencePacksClientListOptions struct {
	// placeholder for future optional parameters
}

// KeyVaultProperties - The key vault properties.
type KeyVaultProperties struct {
	// The name of the key associated with the Log Analytics cluster.
	KeyName *string `json:"keyName,omitempty"`

	// Selected key minimum required size.
	KeyRsaSize *int32 `json:"keyRsaSize,omitempty"`

	// The Key Vault uri which holds they key associated with the Log Analytics cluster.
	KeyVaultURI *string `json:"keyVaultUri,omitempty"`

	// The version of the key associated with the Log Analytics cluster.
	KeyVersion *string `json:"keyVersion,omitempty"`
}

// LinkedService - The top level Linked service resource container.
type LinkedService struct {
	// REQUIRED; The properties of the linked service.
	Properties *LinkedServiceProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// LinkedServiceListResult - The list linked service operation response.
type LinkedServiceListResult struct {
	// The list of linked service instances
	Value []*LinkedService `json:"value,omitempty"`
}

// LinkedServiceProperties - Linked service properties.
type LinkedServiceProperties struct {
	// The provisioning state of the linked service.
	ProvisioningState *LinkedServiceEntityStatus `json:"provisioningState,omitempty"`

	// The resource id of the resource that will be linked to the workspace. This should be used for linking resources which require
	// read access
	ResourceID *string `json:"resourceId,omitempty"`

	// The resource id of the resource that will be linked to the workspace. This should be used for linking resources which require
	// write access
	WriteAccessResourceID *string `json:"writeAccessResourceId,omitempty"`
}

// LinkedServicesClientBeginCreateOrUpdateOptions contains the optional parameters for the LinkedServicesClient.BeginCreateOrUpdate
// method.
type LinkedServicesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// LinkedServicesClientBeginDeleteOptions contains the optional parameters for the LinkedServicesClient.BeginDelete method.
type LinkedServicesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// LinkedServicesClientGetOptions contains the optional parameters for the LinkedServicesClient.Get method.
type LinkedServicesClientGetOptions struct {
	// placeholder for future optional parameters
}

// LinkedServicesClientListByWorkspaceOptions contains the optional parameters for the LinkedServicesClient.ListByWorkspace
// method.
type LinkedServicesClientListByWorkspaceOptions struct {
	// placeholder for future optional parameters
}

// LinkedStorageAccountsClientCreateOrUpdateOptions contains the optional parameters for the LinkedStorageAccountsClient.CreateOrUpdate
// method.
type LinkedStorageAccountsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// LinkedStorageAccountsClientDeleteOptions contains the optional parameters for the LinkedStorageAccountsClient.Delete method.
type LinkedStorageAccountsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// LinkedStorageAccountsClientGetOptions contains the optional parameters for the LinkedStorageAccountsClient.Get method.
type LinkedStorageAccountsClientGetOptions struct {
	// placeholder for future optional parameters
}

// LinkedStorageAccountsClientListByWorkspaceOptions contains the optional parameters for the LinkedStorageAccountsClient.ListByWorkspace
// method.
type LinkedStorageAccountsClientListByWorkspaceOptions struct {
	// placeholder for future optional parameters
}

// LinkedStorageAccountsListResult - The list linked storage accounts service operation response.
type LinkedStorageAccountsListResult struct {
	// A list of linked storage accounts instances.
	Value []*LinkedStorageAccountsResource `json:"value,omitempty"`
}

// LinkedStorageAccountsProperties - Linked storage accounts properties.
type LinkedStorageAccountsProperties struct {
	// Linked storage accounts resources ids.
	StorageAccountIDs []*string `json:"storageAccountIds,omitempty"`

	// READ-ONLY; Linked storage accounts type.
	DataSourceType *DataSourceType `json:"dataSourceType,omitempty" azure:"ro"`
}

// LinkedStorageAccountsResource - Linked storage accounts top level resource container.
type LinkedStorageAccountsResource struct {
	// REQUIRED; Linked storage accounts properties.
	Properties *LinkedStorageAccountsProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// LogAnalyticsQueryPack - An Log Analytics QueryPack definition.
type LogAnalyticsQueryPack struct {
	// REQUIRED; Resource location
	Location *string `json:"location,omitempty"`

	// REQUIRED; Properties that define a Log Analytics QueryPack resource.
	Properties *LogAnalyticsQueryPackProperties `json:"properties,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// LogAnalyticsQueryPackListResult - Describes the list of Log Analytics QueryPack resources.
type LogAnalyticsQueryPackListResult struct {
	// REQUIRED; List of Log Analytics QueryPack definitions.
	Value []*LogAnalyticsQueryPack `json:"value,omitempty"`

	// The URI to get the next set of Log Analytics QueryPack definitions if too many QueryPacks where returned in the result
	// set.
	NextLink *string `json:"nextLink,omitempty"`
}

// LogAnalyticsQueryPackProperties - Properties that define a Log Analytics QueryPack resource.
type LogAnalyticsQueryPackProperties struct {
	// READ-ONLY; Current state of this QueryPack: whether or not is has been provisioned within the resource group it is defined.
	// Users cannot change this value but are able to read from it. Values will include
	// Succeeded, Deploying, Canceled, and Failed.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The unique ID of your application. This field cannot be changed.
	QueryPackID *string `json:"queryPackId,omitempty" azure:"ro"`

	// READ-ONLY; Creation Date for the Log Analytics QueryPack, in ISO 8601 format.
	TimeCreated *time.Time `json:"timeCreated,omitempty" azure:"ro"`

	// READ-ONLY; Last modified date of the Log Analytics QueryPack, in ISO 8601 format.
	TimeModified *time.Time `json:"timeModified,omitempty" azure:"ro"`
}

// LogAnalyticsQueryPackQuery - A Log Analytics QueryPack-Query definition.
type LogAnalyticsQueryPackQuery struct {
	// Properties that define an Log Analytics QueryPack-Query resource.
	Properties *LogAnalyticsQueryPackQueryProperties `json:"properties,omitempty"`

	// READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Read only system data
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// LogAnalyticsQueryPackQueryListResult - Describes the list of Log Analytics QueryPack-Query resources.
type LogAnalyticsQueryPackQueryListResult struct {
	// REQUIRED; List of Log Analytics QueryPack Query definitions.
	Value []*LogAnalyticsQueryPackQuery `json:"value,omitempty"`

	// The URI to get the next set of Log Analytics QueryPack definitions if too many QueryPack-Queries where returned in the
	// result set.
	NextLink *string `json:"nextLink,omitempty"`
}

// LogAnalyticsQueryPackQueryProperties - Properties that define an Log Analytics QueryPack-Query resource.
type LogAnalyticsQueryPackQueryProperties struct {
	// REQUIRED; Body of the query.
	Body *string `json:"body,omitempty"`

	// REQUIRED; Unique display name for your query within the Query Pack.
	DisplayName *string `json:"displayName,omitempty"`

	// Description of the query.
	Description *string `json:"description,omitempty"`

	// Additional properties that can be set for the query.
	Properties interface{} `json:"properties,omitempty"`

	// The related metadata items for the function.
	Related *LogAnalyticsQueryPackQueryPropertiesRelated `json:"related,omitempty"`

	// Tags associated with the query.
	Tags map[string][]*string `json:"tags,omitempty"`

	// READ-ONLY; Object Id of user creating the query.
	Author *string `json:"author,omitempty" azure:"ro"`

	// READ-ONLY; The unique ID of your application. This field cannot be changed.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Creation Date for the Log Analytics Query, in ISO 8601 format.
	TimeCreated *time.Time `json:"timeCreated,omitempty" azure:"ro"`

	// READ-ONLY; Last modified date of the Log Analytics Query, in ISO 8601 format.
	TimeModified *time.Time `json:"timeModified,omitempty" azure:"ro"`
}

// LogAnalyticsQueryPackQueryPropertiesRelated - The related metadata items for the function.
type LogAnalyticsQueryPackQueryPropertiesRelated struct {
	// The related categories for the function.
	Categories []*string `json:"categories,omitempty"`

	// The related resource types for the function.
	ResourceTypes []*string `json:"resourceTypes,omitempty"`

	// The related Log Analytics solutions for the function.
	Solutions []*string `json:"solutions,omitempty"`
}

// LogAnalyticsQueryPackQuerySearchProperties - Properties that define an Log Analytics QueryPack-Query search properties.
type LogAnalyticsQueryPackQuerySearchProperties struct {
	// The related metadata items for the function.
	Related *LogAnalyticsQueryPackQuerySearchPropertiesRelated `json:"related,omitempty"`

	// Tags associated with the query.
	Tags map[string][]*string `json:"tags,omitempty"`
}

// LogAnalyticsQueryPackQuerySearchPropertiesRelated - The related metadata items for the function.
type LogAnalyticsQueryPackQuerySearchPropertiesRelated struct {
	// The related categories for the function.
	Categories []*string `json:"categories,omitempty"`

	// The related resource types for the function.
	ResourceTypes []*string `json:"resourceTypes,omitempty"`

	// The related Log Analytics solutions for the function.
	Solutions []*string `json:"solutions,omitempty"`
}

// ManagementGroup - A management group that is connected to a workspace
type ManagementGroup struct {
	// The properties of the management group.
	Properties *ManagementGroupProperties `json:"properties,omitempty"`
}

// ManagementGroupProperties - Management group properties.
type ManagementGroupProperties struct {
	// The datetime that the management group was created.
	Created *time.Time `json:"created,omitempty"`

	// The last datetime that the management group received data.
	DataReceived *time.Time `json:"dataReceived,omitempty"`

	// The unique ID of the management group.
	ID *string `json:"id,omitempty"`

	// Gets or sets a value indicating whether the management group is a gateway.
	IsGateway *bool `json:"isGateway,omitempty"`

	// The name of the management group.
	Name *string `json:"name,omitempty"`

	// The SKU of System Center that is managing the management group.
	SKU *string `json:"sku,omitempty"`

	// The number of servers connected to the management group.
	ServerCount *int32 `json:"serverCount,omitempty"`

	// The version of System Center that is managing the management group.
	Version *string `json:"version,omitempty"`
}

// ManagementGroupsClientListOptions contains the optional parameters for the ManagementGroupsClient.List method.
type ManagementGroupsClientListOptions struct {
	// placeholder for future optional parameters
}

// MetricName - The name of a metric.
type MetricName struct {
	// The localized name of the metric.
	LocalizedValue *string `json:"localizedValue,omitempty"`

	// The system name of the metric.
	Value *string `json:"value,omitempty"`
}

// Operation - Supported operation of OperationalInsights resource provider.
type Operation struct {
	// Display metadata associated with the operation.
	Display *OperationDisplay `json:"display,omitempty"`

	// Operation name: {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`
}

// OperationDisplay - Display metadata associated with the operation.
type OperationDisplay struct {
	// Description of operation
	Description *string `json:"description,omitempty"`

	// Type of operation: get, read, delete, etc.
	Operation *string `json:"operation,omitempty"`

	// Service provider: Microsoft OperationsManagement.
	Provider *string `json:"provider,omitempty"`

	// Resource on which the operation is performed etc.
	Resource *string `json:"resource,omitempty"`
}

// OperationListResult - Result of the request to list solution operations.
type OperationListResult struct {
	// List of solution operations supported by the OperationsManagement resource provider.
	Value []*Operation `json:"value,omitempty"`

	// READ-ONLY; URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// OperationStatus - The status of operation.
type OperationStatus struct {
	// The end time of the operation.
	EndTime *string `json:"endTime,omitempty"`

	// The error detail of the operation if any.
	Error *ErrorResponse `json:"error,omitempty"`

	// The operation Id.
	ID *string `json:"id,omitempty"`

	// The operation name.
	Name *string `json:"name,omitempty"`

	// The start time of the operation.
	StartTime *string `json:"startTime,omitempty"`

	// The status of the operation.
	Status *string `json:"status,omitempty"`
}

// OperationStatusesClientGetOptions contains the optional parameters for the OperationStatusesClient.Get method.
type OperationStatusesClientGetOptions struct {
	// placeholder for future optional parameters
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkScopedResource - The private link scope resource reference.
type PrivateLinkScopedResource struct {
	// The full resource Id of the private link scope resource.
	ResourceID *string `json:"resourceId,omitempty"`

	// The private link scope unique Identifier.
	ScopeID *string `json:"scopeId,omitempty"`
}

// ProxyResource - The resource model definition for a Azure Resource Manager proxy resource. It will not have tags and a
// location
type ProxyResource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// QueriesClientDeleteOptions contains the optional parameters for the QueriesClient.Delete method.
type QueriesClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// QueriesClientGetOptions contains the optional parameters for the QueriesClient.Get method.
type QueriesClientGetOptions struct {
	// placeholder for future optional parameters
}

// QueriesClientListOptions contains the optional parameters for the QueriesClient.List method.
type QueriesClientListOptions struct {
	// Flag indicating whether or not to return the body of each applicable query. If false, only return the query information.
	IncludeBody *bool
	// Base64 encoded token used to fetch the next page of items. Default is null.
	SkipToken *string
	// Maximum items returned in page.
	Top *int64
}

// QueriesClientPutOptions contains the optional parameters for the QueriesClient.Put method.
type QueriesClientPutOptions struct {
	// placeholder for future optional parameters
}

// QueriesClientSearchOptions contains the optional parameters for the QueriesClient.Search method.
type QueriesClientSearchOptions struct {
	// Flag indicating whether or not to return the body of each applicable query. If false, only return the query information.
	IncludeBody *bool
	// Base64 encoded token used to fetch the next page of items. Default is null.
	SkipToken *string
	// Maximum items returned in page.
	Top *int64
}

// QueriesClientUpdateOptions contains the optional parameters for the QueriesClient.Update method.
type QueriesClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// QueryPacksClientCreateOrUpdateOptions contains the optional parameters for the QueryPacksClient.CreateOrUpdate method.
type QueryPacksClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// QueryPacksClientDeleteOptions contains the optional parameters for the QueryPacksClient.Delete method.
type QueryPacksClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// QueryPacksClientGetOptions contains the optional parameters for the QueryPacksClient.Get method.
type QueryPacksClientGetOptions struct {
	// placeholder for future optional parameters
}

// QueryPacksClientListByResourceGroupOptions contains the optional parameters for the QueryPacksClient.ListByResourceGroup
// method.
type QueryPacksClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// QueryPacksClientListOptions contains the optional parameters for the QueryPacksClient.List method.
type QueryPacksClientListOptions struct {
	// placeholder for future optional parameters
}

// QueryPacksClientUpdateTagsOptions contains the optional parameters for the QueryPacksClient.UpdateTags method.
type QueryPacksClientUpdateTagsOptions struct {
	// placeholder for future optional parameters
}

// QueryPacksResource - An azure resource object
type QueryPacksResource struct {
	// REQUIRED; Resource location
	Location *string `json:"location,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// Resource - Common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RestoredLogs - Restore parameters.
type RestoredLogs struct {
	// The timestamp to end the restore by (UTC).
	EndRestoreTime *time.Time `json:"endRestoreTime,omitempty"`

	// The table to restore data from.
	SourceTable *string `json:"sourceTable,omitempty"`

	// The timestamp to start the restore from (UTC).
	StartRestoreTime *time.Time `json:"startRestoreTime,omitempty"`
}

// ResultStatistics - Search job execution statistics.
type ResultStatistics struct {
	// READ-ONLY; The number of rows that were returned by the search job.
	IngestedRecords *int32 `json:"ingestedRecords,omitempty" azure:"ro"`

	// READ-ONLY; Search job completion percentage.
	Progress *float32 `json:"progress,omitempty" azure:"ro"`
}

// SavedSearch - Value object for saved search results.
type SavedSearch struct {
	// REQUIRED; The properties of the saved search.
	Properties *SavedSearchProperties `json:"properties,omitempty"`

	// The ETag of the saved search. To override an existing saved search, use "*" or specify the current Etag
	Etag *string `json:"etag,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SavedSearchProperties - Value object for saved search results.
type SavedSearchProperties struct {
	// REQUIRED; The category of the saved search. This helps the user to find a saved search faster.
	Category *string `json:"category,omitempty"`

	// REQUIRED; Saved search display name.
	DisplayName *string `json:"displayName,omitempty"`

	// REQUIRED; The query expression for the saved search.
	Query *string `json:"query,omitempty"`

	// The function alias if query serves as a function.
	FunctionAlias *string `json:"functionAlias,omitempty"`

	// The optional function parameters if query serves as a function. Value should be in the following format: 'param-name1:type1
	// = defaultvalue1, param-name2:type2 = defaultvalue2'. For more examples and
	// proper syntax please refer to https://docs.microsoft.com/en-us/azure/kusto/query/functions/user-defined-functions.
	FunctionParameters *string `json:"functionParameters,omitempty"`

	// The tags attached to the saved search.
	Tags []*Tag `json:"tags,omitempty"`

	// The version number of the query language. The current version is 2 and is the default.
	Version *int64 `json:"version,omitempty"`
}

// SavedSearchesClientCreateOrUpdateOptions contains the optional parameters for the SavedSearchesClient.CreateOrUpdate method.
type SavedSearchesClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// SavedSearchesClientDeleteOptions contains the optional parameters for the SavedSearchesClient.Delete method.
type SavedSearchesClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// SavedSearchesClientGetOptions contains the optional parameters for the SavedSearchesClient.Get method.
type SavedSearchesClientGetOptions struct {
	// placeholder for future optional parameters
}

// SavedSearchesClientListByWorkspaceOptions contains the optional parameters for the SavedSearchesClient.ListByWorkspace
// method.
type SavedSearchesClientListByWorkspaceOptions struct {
	// placeholder for future optional parameters
}

// SavedSearchesListResult - The saved search list operation response.
type SavedSearchesListResult struct {
	// The array of result values.
	Value []*SavedSearch `json:"value,omitempty"`
}

// Schema - Table's schema.
type Schema struct {
	// A list of table custom columns.
	Columns []*Column `json:"columns,omitempty"`

	// Table description.
	Description *string `json:"description,omitempty"`

	// Table display name.
	DisplayName *string `json:"displayName,omitempty"`

	// Table name.
	Name *string `json:"name,omitempty"`

	// READ-ONLY; Table category.
	Categories []*string `json:"categories,omitempty" azure:"ro"`

	// READ-ONLY; Table labels.
	Labels []*string `json:"labels,omitempty" azure:"ro"`

	// READ-ONLY; Parameters of the restore operation that initiated this table.
	RestoredLogs *RestoredLogs `json:"restoredLogs,omitempty" azure:"ro"`

	// READ-ONLY; Parameters of the search job that initiated this table.
	SearchResults *SearchResults `json:"searchResults,omitempty" azure:"ro"`

	// READ-ONLY; List of solutions the table is affiliated with
	Solutions []*string `json:"solutions,omitempty" azure:"ro"`

	// READ-ONLY; Table's creator.
	Source *SourceEnum `json:"source,omitempty" azure:"ro"`

	// READ-ONLY; A list of table standard columns.
	StandardColumns []*Column `json:"standardColumns,omitempty" azure:"ro"`

	// READ-ONLY; The subtype describes what APIs can be used to interact with the table, and what features are available against
	// it.
	TableSubType *TableSubTypeEnum `json:"tableSubType,omitempty" azure:"ro"`

	// READ-ONLY; Table's creator.
	TableType *TableTypeEnum `json:"tableType,omitempty" azure:"ro"`
}

// SchemaClientGetOptions contains the optional parameters for the SchemaClient.Get method.
type SchemaClientGetOptions struct {
	// placeholder for future optional parameters
}

// SearchGetSchemaResponse - The get schema operation response.
type SearchGetSchemaResponse struct {
	// The metadata from search results.
	Metadata *SearchMetadata `json:"metadata,omitempty"`

	// The array of result values.
	Value []*SearchSchemaValue `json:"value,omitempty"`
}

// SearchMetadata - Metadata for search results.
type SearchMetadata struct {
	// The aggregated grouping fields.
	AggregatedGroupingFields *string `json:"aggregatedGroupingFields,omitempty"`

	// The aggregated value field.
	AggregatedValueField *string `json:"aggregatedValueField,omitempty"`

	// The core summaries.
	CoreSummaries []*CoreSummary `json:"coreSummaries,omitempty"`

	// The ETag of the search results.
	ETag *string `json:"eTag,omitempty"`

	// The id of the search results request.
	ID *string `json:"id,omitempty"`

	// The time of last update.
	LastUpdated *time.Time `json:"lastUpdated,omitempty"`

	// The max of all aggregates returned in the result set.
	Max *int64 `json:"max,omitempty"`

	// The request time.
	RequestTime *int64 `json:"requestTime,omitempty"`

	// The search result type.
	ResultType *string `json:"resultType,omitempty"`

	// The schema.
	Schema *SearchMetadataSchema `json:"schema,omitempty"`

	// The request id of the search.
	SearchID *string `json:"requestId,omitempty"`

	// How the results are sorted.
	Sort []*SearchSort `json:"sort,omitempty"`

	// The start time for the search.
	StartTime *time.Time `json:"startTime,omitempty"`

	// The status of the search results.
	Status *string `json:"status,omitempty"`

	// The sum of all aggregates returned in the result set.
	Sum *int64 `json:"sum,omitempty"`

	// The number of top search results.
	Top *int64 `json:"top,omitempty"`

	// The total number of search results.
	Total *int64 `json:"total,omitempty"`
}

// SearchMetadataSchema - Schema metadata for search.
type SearchMetadataSchema struct {
	// The name of the metadata schema.
	Name *string `json:"name,omitempty"`

	// The version of the metadata schema.
	Version *int32 `json:"version,omitempty"`
}

// SearchResults - Parameters of the search job that initiated this table.
type SearchResults struct {
	// Search job Description.
	Description *string `json:"description,omitempty"`

	// The timestamp to end the search by (UTC)
	EndSearchTime *time.Time `json:"endSearchTime,omitempty"`

	// Limit the search job to return up to specified number of rows.
	Limit *int32 `json:"limit,omitempty"`

	// Search job query.
	Query *string `json:"query,omitempty"`

	// The timestamp to start the search from (UTC)
	StartSearchTime *time.Time `json:"startSearchTime,omitempty"`

	// READ-ONLY; The table used in the search job.
	SourceTable *string `json:"sourceTable,omitempty" azure:"ro"`
}

// SearchSchemaValue - Value object for schema results.
type SearchSchemaValue struct {
	// REQUIRED; The boolean that indicates whether or not the field is a facet.
	Facet *bool `json:"facet,omitempty"`

	// REQUIRED; The boolean that indicates the field is searchable as free text.
	Indexed *bool `json:"indexed,omitempty"`

	// REQUIRED; The boolean that indicates whether or not the field is stored.
	Stored *bool `json:"stored,omitempty"`

	// The display name of the schema.
	DisplayName *string `json:"displayName,omitempty"`

	// The name of the schema.
	Name *string `json:"name,omitempty"`

	// The array of workflows containing the field.
	OwnerType []*string `json:"ownerType,omitempty"`

	// The type.
	Type *string `json:"type,omitempty"`
}

// SearchSort - The sort parameters for search.
type SearchSort struct {
	// The name of the field the search query is sorted on.
	Name *string `json:"name,omitempty"`

	// The sort order of the search.
	Order *SearchSortEnum `json:"order,omitempty"`
}

// SharedKeys - The shared keys for a workspace.
type SharedKeys struct {
	// The primary shared key of a workspace.
	PrimarySharedKey *string `json:"primarySharedKey,omitempty"`

	// The secondary shared key of a workspace.
	SecondarySharedKey *string `json:"secondarySharedKey,omitempty"`
}

// SharedKeysClientGetSharedKeysOptions contains the optional parameters for the SharedKeysClient.GetSharedKeys method.
type SharedKeysClientGetSharedKeysOptions struct {
	// placeholder for future optional parameters
}

// SharedKeysClientRegenerateOptions contains the optional parameters for the SharedKeysClient.Regenerate method.
type SharedKeysClientRegenerateOptions struct {
	// placeholder for future optional parameters
}

// StorageAccount - Describes a storage account connection.
type StorageAccount struct {
	// REQUIRED; The Azure Resource Manager ID of the storage account resource.
	ID *string `json:"id,omitempty"`

	// REQUIRED; The storage account key.
	Key *string `json:"key,omitempty"`
}

// StorageInsight - The top level storage insight resource container.
type StorageInsight struct {
	// The ETag of the storage insight.
	ETag *string `json:"eTag,omitempty"`

	// Storage insight properties.
	Properties *StorageInsightProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// StorageInsightConfigsClientCreateOrUpdateOptions contains the optional parameters for the StorageInsightConfigsClient.CreateOrUpdate
// method.
type StorageInsightConfigsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// StorageInsightConfigsClientDeleteOptions contains the optional parameters for the StorageInsightConfigsClient.Delete method.
type StorageInsightConfigsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// StorageInsightConfigsClientGetOptions contains the optional parameters for the StorageInsightConfigsClient.Get method.
type StorageInsightConfigsClientGetOptions struct {
	// placeholder for future optional parameters
}

// StorageInsightConfigsClientListByWorkspaceOptions contains the optional parameters for the StorageInsightConfigsClient.ListByWorkspace
// method.
type StorageInsightConfigsClientListByWorkspaceOptions struct {
	// placeholder for future optional parameters
}

// StorageInsightListResult - The list storage insights operation response.
type StorageInsightListResult struct {
	// The link (url) to the next page of results.
	ODataNextLink *string `json:"@odata.nextLink,omitempty"`

	// A list of storage insight items.
	Value []*StorageInsight `json:"value,omitempty"`
}

// StorageInsightProperties - Storage insight properties.
type StorageInsightProperties struct {
	// REQUIRED; The storage account connection details
	StorageAccount *StorageAccount `json:"storageAccount,omitempty"`

	// The names of the blob containers that the workspace should read
	Containers []*string `json:"containers,omitempty"`

	// The names of the Azure tables that the workspace should read
	Tables []*string `json:"tables,omitempty"`

	// READ-ONLY; The status of the storage insight
	Status *StorageInsightStatus `json:"status,omitempty" azure:"ro"`
}

// StorageInsightStatus - The status of the storage insight.
type StorageInsightStatus struct {
	// REQUIRED; The state of the storage insight connection to the workspace
	State *StorageInsightState `json:"state,omitempty"`

	// Description of the state of the storage insight.
	Description *string `json:"description,omitempty"`
}

// SystemData - Read only system data
type SystemData struct {
	// The timestamp of resource creation (UTC)
	CreatedAt *time.Time `json:"createdAt,omitempty"`

	// An identifier for the identity that created the resource
	CreatedBy *string `json:"createdBy,omitempty"`

	// The type of identity that created the resource
	CreatedByType *IdentityType `json:"createdByType,omitempty"`

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time `json:"lastModifiedAt,omitempty"`

	// An identifier for the identity that last modified the resource
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`

	// The type of identity that last modified the resource
	LastModifiedByType *IdentityType `json:"lastModifiedByType,omitempty"`
}

// SystemDataAutoGenerated - Metadata pertaining to creation and last modification of the resource.
type SystemDataAutoGenerated struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time `json:"createdAt,omitempty"`

	// The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`

	// The type of identity that created the resource.
	CreatedByType *CreatedByType `json:"createdByType,omitempty"`

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time `json:"lastModifiedAt,omitempty"`

	// The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType `json:"lastModifiedByType,omitempty"`
}

// Table - Workspace data table definition.
type Table struct {
	// Table's properties.
	Properties *TableProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemDataAutoGenerated `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// TableProperties - Table properties.
type TableProperties struct {
	// Instruct the system how to handle and charge the logs ingested to this table.
	Plan *TablePlanEnum `json:"plan,omitempty"`

	// Parameters of the restore operation that initiated this table.
	RestoredLogs *RestoredLogs `json:"restoredLogs,omitempty"`

	// Search job execution statistics.
	ResultStatistics *ResultStatistics `json:"resultStatistics,omitempty"`

	// The table retention in days, between 4 and 730. Setting this property to -1 will default to the workspace retention.
	RetentionInDays *int32 `json:"retentionInDays,omitempty"`

	// Table schema.
	Schema *Schema `json:"schema,omitempty"`

	// Parameters of the search job that initiated this table.
	SearchResults *SearchResults `json:"searchResults,omitempty"`

	// The table total retention in days, between 4 and 2555. Setting this property to -1 will default to table retention.
	TotalRetentionInDays *int32 `json:"totalRetentionInDays,omitempty"`

	// READ-ONLY; The table data archive retention in days. Calculated as (totalRetentionInDays-retentionInDays)
	ArchiveRetentionInDays *int32 `json:"archiveRetentionInDays,omitempty" azure:"ro"`

	// READ-ONLY; The timestamp that table plan was last modified (UTC).
	LastPlanModifiedDate *string `json:"lastPlanModifiedDate,omitempty" azure:"ro"`

	// READ-ONLY; Table's current provisioning state. If set to 'updating', indicates a resource lock due to ongoing operation,
	// forbidding any update to the table until the ongoing operation is concluded.
	ProvisioningState *ProvisioningStateEnum `json:"provisioningState,omitempty" azure:"ro"`
}

// TablesClientBeginCreateOrUpdateOptions contains the optional parameters for the TablesClient.BeginCreateOrUpdate method.
type TablesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// TablesClientBeginDeleteOptions contains the optional parameters for the TablesClient.BeginDelete method.
type TablesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// TablesClientBeginUpdateOptions contains the optional parameters for the TablesClient.BeginUpdate method.
type TablesClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// TablesClientGetOptions contains the optional parameters for the TablesClient.Get method.
type TablesClientGetOptions struct {
	// placeholder for future optional parameters
}

// TablesClientListByWorkspaceOptions contains the optional parameters for the TablesClient.ListByWorkspace method.
type TablesClientListByWorkspaceOptions struct {
	// placeholder for future optional parameters
}

// TablesClientMigrateOptions contains the optional parameters for the TablesClient.Migrate method.
type TablesClientMigrateOptions struct {
	// placeholder for future optional parameters
}

// TablesListResult - The list tables operation response.
type TablesListResult struct {
	// A list of data tables.
	Value []*Table `json:"value,omitempty"`
}

// Tag - A tag of a saved search.
type Tag struct {
	// REQUIRED; The tag name.
	Name *string `json:"name,omitempty"`

	// REQUIRED; The tag value.
	Value *string `json:"value,omitempty"`
}

// TagsResource - A container holding only the Tags for a resource, allowing the user to update the tags on a QueryPack instance.
type TagsResource struct {
	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`
}

// TrackedResource - The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags'
// and a 'location'
type TrackedResource struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// UsageMetric - A metric describing the usage of a resource.
type UsageMetric struct {
	// The current value of the metric.
	CurrentValue *float64 `json:"currentValue,omitempty"`

	// The quota limit for the metric.
	Limit *float64 `json:"limit,omitempty"`

	// The name of the metric.
	Name *MetricName `json:"name,omitempty"`

	// The time that the metric's value will reset.
	NextResetTime *time.Time `json:"nextResetTime,omitempty"`

	// The quota period that determines the length of time between value resets.
	QuotaPeriod *string `json:"quotaPeriod,omitempty"`

	// The units used for the metric.
	Unit *string `json:"unit,omitempty"`
}

// UsagesClientListOptions contains the optional parameters for the UsagesClient.List method.
type UsagesClientListOptions struct {
	// placeholder for future optional parameters
}

// UserIdentityProperties - User assigned identity properties.
type UserIdentityProperties struct {
	// READ-ONLY; The client id of user assigned identity.
	ClientID *string `json:"clientId,omitempty" azure:"ro"`

	// READ-ONLY; The principal id of user assigned identity.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`
}

// Workspace - The top level Workspace resource container.
type Workspace struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// The ETag of the workspace.
	ETag *string `json:"eTag,omitempty"`

	// Workspace properties.
	Properties *WorkspaceProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemDataAutoGenerated `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// WorkspaceCapping - The daily volume cap for ingestion.
type WorkspaceCapping struct {
	// The workspace daily quota for ingestion.
	DailyQuotaGb *float64 `json:"dailyQuotaGb,omitempty"`

	// READ-ONLY; The status of data ingestion for this workspace.
	DataIngestionStatus *DataIngestionStatus `json:"dataIngestionStatus,omitempty" azure:"ro"`

	// READ-ONLY; The time when the quota will be rest.
	QuotaNextResetTime *string `json:"quotaNextResetTime,omitempty" azure:"ro"`
}

// WorkspaceFeatures - Workspace features.
type WorkspaceFeatures struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Dedicated LA cluster resourceId that is linked to the workspaces.
	ClusterResourceID *string `json:"clusterResourceId,omitempty"`

	// Disable Non-AAD based Auth.
	DisableLocalAuth *bool `json:"disableLocalAuth,omitempty"`

	// Flag that indicate if data should be exported.
	EnableDataExport *bool `json:"enableDataExport,omitempty"`

	// Flag that indicate which permission to use - resource or workspace or both.
	EnableLogAccessUsingOnlyResourcePermissions *bool `json:"enableLogAccessUsingOnlyResourcePermissions,omitempty"`

	// Flag that describes if we want to remove the data after 30 days.
	ImmediatePurgeDataOn30Days *bool `json:"immediatePurgeDataOn30Days,omitempty"`
}

// WorkspaceListManagementGroupsResult - The list workspace management groups operation response.
type WorkspaceListManagementGroupsResult struct {
	// Gets or sets a list of management groups attached to the workspace.
	Value []*ManagementGroup `json:"value,omitempty"`
}

// WorkspaceListResult - The list workspaces operation response.
type WorkspaceListResult struct {
	// A list of workspaces.
	Value []*Workspace `json:"value,omitempty"`
}

// WorkspaceListUsagesResult - The list workspace usages operation response.
type WorkspaceListUsagesResult struct {
	// Gets or sets a list of usage metrics for a workspace.
	Value []*UsageMetric `json:"value,omitempty"`
}

// WorkspacePatch - The top level Workspace resource container.
type WorkspacePatch struct {
	// Workspace properties.
	Properties *WorkspaceProperties `json:"properties,omitempty"`

	// Resource tags. Optional.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Etag.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// WorkspaceProperties - Workspace properties.
type WorkspaceProperties struct {
	// The resource ID of the default Data Collection Rule to use for this workspace. Expected format is -
	// /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/dataCollectionRules/{dcrName}.
	DefaultDataCollectionRuleResourceID *string `json:"defaultDataCollectionRuleResourceId,omitempty"`

	// Workspace features.
	Features *WorkspaceFeatures `json:"features,omitempty"`

	// Indicates whether customer managed storage is mandatory for query management.
	ForceCmkForQuery *bool `json:"forceCmkForQuery,omitempty"`

	// The network access type for accessing Log Analytics ingestion.
	PublicNetworkAccessForIngestion *PublicNetworkAccessType `json:"publicNetworkAccessForIngestion,omitempty"`

	// The network access type for accessing Log Analytics query.
	PublicNetworkAccessForQuery *PublicNetworkAccessType `json:"publicNetworkAccessForQuery,omitempty"`

	// The workspace data retention in days. Allowed values are per pricing plan. See pricing tiers documentation for details.
	RetentionInDays *int32 `json:"retentionInDays,omitempty"`

	// The SKU of the workspace.
	SKU *WorkspaceSKU `json:"sku,omitempty"`

	// The daily volume cap for ingestion.
	WorkspaceCapping *WorkspaceCapping `json:"workspaceCapping,omitempty"`

	// READ-ONLY; Workspace creation date.
	CreatedDate *string `json:"createdDate,omitempty" azure:"ro"`

	// READ-ONLY; This is a read-only property. Represents the ID associated with the workspace.
	CustomerID *string `json:"customerId,omitempty" azure:"ro"`

	// READ-ONLY; Workspace modification date.
	ModifiedDate *string `json:"modifiedDate,omitempty" azure:"ro"`

	// READ-ONLY; List of linked private link scope resources.
	PrivateLinkScopedResources []*PrivateLinkScopedResource `json:"privateLinkScopedResources,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the workspace.
	ProvisioningState *WorkspaceEntityStatus `json:"provisioningState,omitempty" azure:"ro"`
}

// WorkspacePurgeBody - Describes the body of a purge request for an App Insights Workspace
type WorkspacePurgeBody struct {
	// REQUIRED; The set of columns and filters (queries) to run over them to purge the resulting data.
	Filters []*WorkspacePurgeBodyFilters `json:"filters,omitempty"`

	// REQUIRED; Table from which to purge data.
	Table *string `json:"table,omitempty"`
}

// WorkspacePurgeBodyFilters - User-defined filters to return data which will be purged from the table.
type WorkspacePurgeBodyFilters struct {
	// The column of the table over which the given query should run
	Column *string `json:"column,omitempty"`

	// When filtering over custom dimensions, this key will be used as the name of the custom dimension.
	Key *string `json:"key,omitempty"`

	// A query operator to evaluate over the provided column and value(s). Supported operators are ==, =~, in, in~, >, >=, <,
	// <=, between, and have the same behavior as they would in a KQL query.
	Operator *string `json:"operator,omitempty"`

	// the value for the operator to function over. This can be a number (e.g., > 100), a string (timestamp >= '2017-09-01') or
	// array of values.
	Value interface{} `json:"value,omitempty"`
}

// WorkspacePurgeClientGetPurgeStatusOptions contains the optional parameters for the WorkspacePurgeClient.GetPurgeStatus
// method.
type WorkspacePurgeClientGetPurgeStatusOptions struct {
	// placeholder for future optional parameters
}

// WorkspacePurgeClientPurgeOptions contains the optional parameters for the WorkspacePurgeClient.Purge method.
type WorkspacePurgeClientPurgeOptions struct {
	// placeholder for future optional parameters
}

// WorkspacePurgeResponse - Response containing operationId for a specific purge action.
type WorkspacePurgeResponse struct {
	// REQUIRED; Id to use when querying for status for a particular purge operation.
	OperationID *string `json:"operationId,omitempty"`
}

// WorkspacePurgeStatusResponse - Response containing status for a specific purge operation.
type WorkspacePurgeStatusResponse struct {
	// REQUIRED; Status of the operation represented by the requested Id.
	Status *PurgeState `json:"status,omitempty"`
}

// WorkspaceSKU - The SKU (tier) of a workspace.
type WorkspaceSKU struct {
	// REQUIRED; The name of the SKU.
	Name *WorkspaceSKUNameEnum `json:"name,omitempty"`

	// The capacity reservation level in GB for this workspace, when CapacityReservation sku is selected.
	CapacityReservationLevel *CapacityReservationLevel `json:"capacityReservationLevel,omitempty"`

	// READ-ONLY; The last time when the sku was updated.
	LastSKUUpdate *string `json:"lastSkuUpdate,omitempty" azure:"ro"`
}

// WorkspacesClientBeginCreateOrUpdateOptions contains the optional parameters for the WorkspacesClient.BeginCreateOrUpdate
// method.
type WorkspacesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WorkspacesClientBeginDeleteOptions contains the optional parameters for the WorkspacesClient.BeginDelete method.
type WorkspacesClientBeginDeleteOptions struct {
	// Deletes the workspace without the recovery option. A workspace that was deleted with this flag cannot be recovered.
	Force *bool
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WorkspacesClientGetOptions contains the optional parameters for the WorkspacesClient.Get method.
type WorkspacesClientGetOptions struct {
	// placeholder for future optional parameters
}

// WorkspacesClientListByResourceGroupOptions contains the optional parameters for the WorkspacesClient.ListByResourceGroup
// method.
type WorkspacesClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// WorkspacesClientListOptions contains the optional parameters for the WorkspacesClient.List method.
type WorkspacesClientListOptions struct {
	// placeholder for future optional parameters
}

// WorkspacesClientUpdateOptions contains the optional parameters for the WorkspacesClient.Update method.
type WorkspacesClientUpdateOptions struct {
	// placeholder for future optional parameters
}
