//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armmonitor

import "time"

// AccessModeSettings - Properties that define the scope private link mode settings.
type AccessModeSettings struct {
	// REQUIRED; Specifies the default access mode of ingestion through associated private endpoints in scope. If not specified
	// default value is 'Open'. You can override this default setting for a specific private
	// endpoint connection by adding an exclusion in the 'exclusions' array.
	IngestionAccessMode *AccessMode `json:"ingestionAccessMode,omitempty"`

	// REQUIRED; Specifies the default access mode of queries through associated private endpoints in scope. If not specified
	// default value is 'Open'. You can override this default setting for a specific private
	// endpoint connection by adding an exclusion in the 'exclusions' array.
	QueryAccessMode *AccessMode `json:"queryAccessMode,omitempty"`

	// List of exclusions that override the default access mode settings for specific private endpoint connections.
	Exclusions []*AccessModeSettingsExclusion `json:"exclusions,omitempty"`
}

// AccessModeSettingsExclusion - Properties that define the scope private link mode settings exclusion item. This setting
// applies to a specific private endpoint connection and overrides the default settings for that private endpoint
// connection.
type AccessModeSettingsExclusion struct {
	// Specifies the access mode of ingestion through the specified private endpoint connection in the exclusion.
	IngestionAccessMode *AccessMode `json:"ingestionAccessMode,omitempty"`

	// The private endpoint connection name associated to the private endpoint on which we want to apply the specific access mode
	// settings.
	PrivateEndpointConnectionName *string `json:"privateEndpointConnectionName,omitempty"`

	// Specifies the access mode of queries through the specified private endpoint connection in the exclusion.
	QueryAccessMode *AccessMode `json:"queryAccessMode,omitempty"`
}

// ActionDetail - The action detail
type ActionDetail struct {
	// The detail of the friendly error message
	Detail *string `json:"Detail,omitempty"`

	// The mechanism type
	MechanismType *string `json:"MechanismType,omitempty"`

	// The name of the action
	Name *string `json:"Name,omitempty"`

	// The send time
	SendTime *string `json:"SendTime,omitempty"`

	// The status of the action
	Status *string `json:"Status,omitempty"`

	// The substatus of the action
	SubState *string `json:"SubState,omitempty"`
}

// ActionGroup - An Azure action group.
type ActionGroup struct {
	// REQUIRED; Indicates whether this action group is enabled. If an action group is not enabled, then none of its receivers
	// will receive communications.
	Enabled *bool `json:"enabled,omitempty"`

	// REQUIRED; The short name of the action group. This will be used in SMS messages.
	GroupShortName *string `json:"groupShortName,omitempty"`

	// The list of ARM role receivers that are part of this action group. Roles are Azure RBAC roles and only built-in roles are
	// supported.
	ArmRoleReceivers []*ArmRoleReceiver `json:"armRoleReceivers,omitempty"`

	// The list of AutomationRunbook receivers that are part of this action group.
	AutomationRunbookReceivers []*AutomationRunbookReceiver `json:"automationRunbookReceivers,omitempty"`

	// The list of AzureAppPush receivers that are part of this action group.
	AzureAppPushReceivers []*AzureAppPushReceiver `json:"azureAppPushReceivers,omitempty"`

	// The list of azure function receivers that are part of this action group.
	AzureFunctionReceivers []*AzureFunctionReceiver `json:"azureFunctionReceivers,omitempty"`

	// The list of email receivers that are part of this action group.
	EmailReceivers []*EmailReceiver `json:"emailReceivers,omitempty"`

	// The list of event hub receivers that are part of this action group.
	EventHubReceivers []*EventHubReceiver `json:"eventHubReceivers,omitempty"`

	// The list of ITSM receivers that are part of this action group.
	ItsmReceivers []*ItsmReceiver `json:"itsmReceivers,omitempty"`

	// The list of logic app receivers that are part of this action group.
	LogicAppReceivers []*LogicAppReceiver `json:"logicAppReceivers,omitempty"`

	// The list of SMS receivers that are part of this action group.
	SmsReceivers []*SmsReceiver `json:"smsReceivers,omitempty"`

	// The list of voice receivers that are part of this action group.
	VoiceReceivers []*VoiceReceiver `json:"voiceReceivers,omitempty"`

	// The list of webhook receivers that are part of this action group.
	WebhookReceivers []*WebhookReceiver `json:"webhookReceivers,omitempty"`
}

// ActionGroupAutoGenerated - A pointer to an Azure Action Group.
type ActionGroupAutoGenerated struct {
	// REQUIRED; The resource ID of the Action Group. This cannot be null or empty.
	ActionGroupID *string `json:"actionGroupId,omitempty"`

	// the dictionary of custom properties to include with the post operation. These data are appended to the webhook payload.
	WebhookProperties map[string]*string `json:"webhookProperties,omitempty"`
}

// ActionGroupList - A list of action groups.
type ActionGroupList struct {
	// Provides the link to retrieve the next set of elements.
	NextLink *string `json:"nextLink,omitempty"`

	// The list of action groups.
	Value []*ActionGroupResource `json:"value,omitempty"`
}

// ActionGroupPatch - An Azure action group for patch operations.
type ActionGroupPatch struct {
	// Indicates whether this action group is enabled. If an action group is not enabled, then none of its actions will be activated.
	Enabled *bool `json:"enabled,omitempty"`
}

// ActionGroupPatchBody - An action group object for the body of patch operations.
type ActionGroupPatchBody struct {
	// The action group settings for an update operation.
	Properties *ActionGroupPatch `json:"properties,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`
}

// ActionGroupResource - An action group resource.
type ActionGroupResource struct {
	// REQUIRED; Resource location
	Location *string `json:"location,omitempty"`

	// The action groups properties of the resource.
	Properties *ActionGroup `json:"properties,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ActionGroupsClientBeginCreateNotificationsAtActionGroupResourceLevelOptions contains the optional parameters for the ActionGroupsClient.BeginCreateNotificationsAtActionGroupResourceLevel
// method.
type ActionGroupsClientBeginCreateNotificationsAtActionGroupResourceLevelOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ActionGroupsClientBeginCreateNotificationsAtResourceGroupLevelOptions contains the optional parameters for the ActionGroupsClient.BeginCreateNotificationsAtResourceGroupLevel
// method.
type ActionGroupsClientBeginCreateNotificationsAtResourceGroupLevelOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ActionGroupsClientBeginPostTestNotificationsOptions contains the optional parameters for the ActionGroupsClient.BeginPostTestNotifications
// method.
type ActionGroupsClientBeginPostTestNotificationsOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ActionGroupsClientCreateOrUpdateOptions contains the optional parameters for the ActionGroupsClient.CreateOrUpdate method.
type ActionGroupsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// ActionGroupsClientDeleteOptions contains the optional parameters for the ActionGroupsClient.Delete method.
type ActionGroupsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ActionGroupsClientEnableReceiverOptions contains the optional parameters for the ActionGroupsClient.EnableReceiver method.
type ActionGroupsClientEnableReceiverOptions struct {
	// placeholder for future optional parameters
}

// ActionGroupsClientGetOptions contains the optional parameters for the ActionGroupsClient.Get method.
type ActionGroupsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ActionGroupsClientGetTestNotificationsAtActionGroupResourceLevelOptions contains the optional parameters for the ActionGroupsClient.GetTestNotificationsAtActionGroupResourceLevel
// method.
type ActionGroupsClientGetTestNotificationsAtActionGroupResourceLevelOptions struct {
	// placeholder for future optional parameters
}

// ActionGroupsClientGetTestNotificationsAtResourceGroupLevelOptions contains the optional parameters for the ActionGroupsClient.GetTestNotificationsAtResourceGroupLevel
// method.
type ActionGroupsClientGetTestNotificationsAtResourceGroupLevelOptions struct {
	// placeholder for future optional parameters
}

// ActionGroupsClientGetTestNotificationsOptions contains the optional parameters for the ActionGroupsClient.GetTestNotifications
// method.
type ActionGroupsClientGetTestNotificationsOptions struct {
	// placeholder for future optional parameters
}

// ActionGroupsClientListByResourceGroupOptions contains the optional parameters for the ActionGroupsClient.ListByResourceGroup
// method.
type ActionGroupsClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// ActionGroupsClientListBySubscriptionIDOptions contains the optional parameters for the ActionGroupsClient.ListBySubscriptionID
// method.
type ActionGroupsClientListBySubscriptionIDOptions struct {
	// placeholder for future optional parameters
}

// ActionGroupsClientUpdateOptions contains the optional parameters for the ActionGroupsClient.Update method.
type ActionGroupsClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// ActionList - A list of Activity Log Alert rule actions.
type ActionList struct {
	// The list of the Action Groups.
	ActionGroups []*ActionGroupAutoGenerated `json:"actionGroups,omitempty"`
}

// Actions to invoke when the alert fires.
type Actions struct {
	// Action Group resource Ids to invoke when the alert fires.
	ActionGroups []*string `json:"actionGroups,omitempty"`

	// The properties of an alert payload.
	CustomProperties map[string]*string `json:"customProperties,omitempty"`
}

// ActivityLogAlertResource - An Activity Log Alert rule resource.
type ActivityLogAlertResource struct {
	// The location of the resource. Since Azure Activity Log Alerts is a global service, the location of the rules should always
	// be 'global'.
	Location *string `json:"location,omitempty"`

	// The Activity Log Alert rule properties of the resource.
	Properties *AlertRuleProperties `json:"properties,omitempty"`

	// The tags of the resource.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ActivityLogAlertsClientCreateOrUpdateOptions contains the optional parameters for the ActivityLogAlertsClient.CreateOrUpdate
// method.
type ActivityLogAlertsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// ActivityLogAlertsClientDeleteOptions contains the optional parameters for the ActivityLogAlertsClient.Delete method.
type ActivityLogAlertsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ActivityLogAlertsClientGetOptions contains the optional parameters for the ActivityLogAlertsClient.Get method.
type ActivityLogAlertsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ActivityLogAlertsClientListByResourceGroupOptions contains the optional parameters for the ActivityLogAlertsClient.ListByResourceGroup
// method.
type ActivityLogAlertsClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// ActivityLogAlertsClientListBySubscriptionIDOptions contains the optional parameters for the ActivityLogAlertsClient.ListBySubscriptionID
// method.
type ActivityLogAlertsClientListBySubscriptionIDOptions struct {
	// placeholder for future optional parameters
}

// ActivityLogAlertsClientUpdateOptions contains the optional parameters for the ActivityLogAlertsClient.Update method.
type ActivityLogAlertsClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// ActivityLogsClientListOptions contains the optional parameters for the ActivityLogsClient.List method.
type ActivityLogsClientListOptions struct {
	// Used to fetch events with only the given properties.
	// The $select argument is a comma separated list of property names to be returned. Possible values are: authorization, claims,
	// correlationId, description, eventDataId, eventName, eventTimestamp,
	// httpRequest, level, operationId, operationName, properties, resourceGroupName, resourceProviderName, resourceId, status,
	// submissionTimestamp, subStatus, subscriptionId
	Select *string
}

// AlertRule - An alert rule.
type AlertRule struct {
	// REQUIRED; the condition that results in the alert rule being activated.
	Condition RuleConditionClassification `json:"condition,omitempty"`

	// REQUIRED; the flag that indicates whether the alert rule is enabled.
	IsEnabled *bool `json:"isEnabled,omitempty"`

	// REQUIRED; the name of the alert rule.
	Name *string `json:"name,omitempty"`

	// action that is performed when the alert rule becomes active, and when an alert condition is resolved.
	Action RuleActionClassification `json:"action,omitempty"`

	// the array of actions that are performed when the alert rule becomes active, and when an alert condition is resolved.
	Actions []RuleActionClassification `json:"actions,omitempty"`

	// the description of the alert rule that will be included in the alert email.
	Description *string `json:"description,omitempty"`

	// the provisioning state.
	ProvisioningState *string `json:"provisioningState,omitempty"`

	// READ-ONLY; Last time the rule was updated in ISO8601 format.
	LastUpdatedTime *time.Time `json:"lastUpdatedTime,omitempty" azure:"ro"`
}

// AlertRuleAllOfCondition - An Activity Log Alert rule condition that is met when all its member conditions are met.
type AlertRuleAllOfCondition struct {
	// REQUIRED; The list of Activity Log Alert rule conditions.
	AllOf []*AlertRuleAnyOfOrLeafCondition `json:"allOf,omitempty"`
}

// AlertRuleAnyOfOrLeafCondition - An Activity Log Alert rule condition that is met when all its member conditions are met.
// Each condition can be of one of the following types:Important: Each type has its unique subset of properties.
// Properties from different types CANNOT exist in one condition.
// * Leaf Condition - must contain 'field' and either 'equals' or 'containsAny'.Please note, 'anyOf' should not be set in
// a Leaf Condition.
// * AnyOf Condition - must contain only 'anyOf' (which is an array of Leaf Conditions).Please note, 'field', 'equals' and
// 'containsAny' should not be set in an AnyOf Condition.
type AlertRuleAnyOfOrLeafCondition struct {
	// An Activity Log Alert rule condition that is met when at least one of its member leaf conditions are met.
	AnyOf []*AlertRuleLeafCondition `json:"anyOf,omitempty"`

	// The value of the event's field will be compared to the values in this array (case-insensitive) to determine if the condition
	// is met.
	ContainsAny []*string `json:"containsAny,omitempty"`

	// The value of the event's field will be compared to this value (case-insensitive) to determine if the condition is met.
	Equals *string `json:"equals,omitempty"`

	// The name of the Activity Log event's field that this condition will examine. The possible values for this field are (case-insensitive):
	// 'resourceId', 'category', 'caller', 'level', 'operationName',
	// 'resourceGroup', 'resourceProvider', 'status', 'subStatus', 'resourceType', or anything beginning with 'properties'.
	Field *string `json:"field,omitempty"`
}

// AlertRuleIncidentsClientGetOptions contains the optional parameters for the AlertRuleIncidentsClient.Get method.
type AlertRuleIncidentsClientGetOptions struct {
	// placeholder for future optional parameters
}

// AlertRuleIncidentsClientListByAlertRuleOptions contains the optional parameters for the AlertRuleIncidentsClient.ListByAlertRule
// method.
type AlertRuleIncidentsClientListByAlertRuleOptions struct {
	// placeholder for future optional parameters
}

// AlertRuleLeafCondition - An Activity Log Alert rule condition that is met by comparing the field and value of an Activity
// Log event. This condition must contain 'field' and either 'equals' or 'containsAny'.
type AlertRuleLeafCondition struct {
	// The value of the event's field will be compared to the values in this array (case-insensitive) to determine if the condition
	// is met.
	ContainsAny []*string `json:"containsAny,omitempty"`

	// The value of the event's field will be compared to this value (case-insensitive) to determine if the condition is met.
	Equals *string `json:"equals,omitempty"`

	// The name of the Activity Log event's field that this condition will examine. The possible values for this field are (case-insensitive):
	// 'resourceId', 'category', 'caller', 'level', 'operationName',
	// 'resourceGroup', 'resourceProvider', 'status', 'subStatus', 'resourceType', or anything beginning with 'properties'.
	Field *string `json:"field,omitempty"`
}

// AlertRuleList - A list of Activity Log Alert rules.
type AlertRuleList struct {
	// Provides the link to retrieve the next set of elements.
	NextLink *string `json:"nextLink,omitempty"`

	// The list of Activity Log Alert rules.
	Value []*ActivityLogAlertResource `json:"value,omitempty"`
}

// AlertRulePatchObject - An Activity Log Alert rule object for the body of patch operations.
type AlertRulePatchObject struct {
	// The activity log alert settings for an update operation.
	Properties *AlertRulePatchProperties `json:"properties,omitempty"`

	// The resource tags
	Tags map[string]*string `json:"tags,omitempty"`
}

// AlertRulePatchProperties - An Activity Log Alert rule properties for patch operations.
type AlertRulePatchProperties struct {
	// Indicates whether this Activity Log Alert rule is enabled. If an Activity Log Alert rule is not enabled, then none of its
	// actions will be activated.
	Enabled *bool `json:"enabled,omitempty"`
}

// AlertRuleProperties - An Azure Activity Log Alert rule.
type AlertRuleProperties struct {
	// REQUIRED; The actions that will activate when the condition is met.
	Actions *ActionList `json:"actions,omitempty"`

	// REQUIRED; The condition that will cause this alert to activate.
	Condition *AlertRuleAllOfCondition `json:"condition,omitempty"`

	// REQUIRED; A list of resource IDs that will be used as prefixes. The alert will only apply to Activity Log events with resource
	// IDs that fall under one of these prefixes. This list must include at least one
	// item.
	Scopes []*string `json:"scopes,omitempty"`

	// A description of this Activity Log Alert rule.
	Description *string `json:"description,omitempty"`

	// Indicates whether this Activity Log Alert rule is enabled. If an Activity Log Alert rule is not enabled, then none of its
	// actions will be activated.
	Enabled *bool `json:"enabled,omitempty"`
}

// AlertRuleResource - The alert rule resource.
type AlertRuleResource struct {
	// REQUIRED; Resource location
	Location *string `json:"location,omitempty"`

	// REQUIRED; The alert rule properties of the resource.
	Properties *AlertRule `json:"properties,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AlertRuleResourceCollection - Represents a collection of alert rule resources.
type AlertRuleResourceCollection struct {
	// the values for the alert rule resources.
	Value []*AlertRuleResource `json:"value,omitempty"`
}

// AlertRuleResourcePatch - The alert rule object for patch operations.
type AlertRuleResourcePatch struct {
	// The properties of an alert rule.
	Properties *AlertRule `json:"properties,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`
}

// AlertRulesClientCreateOrUpdateOptions contains the optional parameters for the AlertRulesClient.CreateOrUpdate method.
type AlertRulesClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// AlertRulesClientDeleteOptions contains the optional parameters for the AlertRulesClient.Delete method.
type AlertRulesClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// AlertRulesClientGetOptions contains the optional parameters for the AlertRulesClient.Get method.
type AlertRulesClientGetOptions struct {
	// placeholder for future optional parameters
}

// AlertRulesClientListByResourceGroupOptions contains the optional parameters for the AlertRulesClient.ListByResourceGroup
// method.
type AlertRulesClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// AlertRulesClientListBySubscriptionOptions contains the optional parameters for the AlertRulesClient.ListBySubscription
// method.
type AlertRulesClientListBySubscriptionOptions struct {
	// placeholder for future optional parameters
}

// AlertRulesClientUpdateOptions contains the optional parameters for the AlertRulesClient.Update method.
type AlertRulesClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// ArmRoleReceiver - An arm role receiver.
type ArmRoleReceiver struct {
	// REQUIRED; The name of the arm role receiver. Names must be unique across all receivers within an action group.
	Name *string `json:"name,omitempty"`

	// REQUIRED; The arm role id.
	RoleID *string `json:"roleId,omitempty"`

	// Indicates whether to use common alert schema.
	UseCommonAlertSchema *bool `json:"useCommonAlertSchema,omitempty"`
}

// AutomationRunbookReceiver - The Azure Automation Runbook notification receiver.
type AutomationRunbookReceiver struct {
	// REQUIRED; The Azure automation account Id which holds this runbook and authenticate to Azure resource.
	AutomationAccountID *string `json:"automationAccountId,omitempty"`

	// REQUIRED; Indicates whether this instance is global runbook.
	IsGlobalRunbook *bool `json:"isGlobalRunbook,omitempty"`

	// REQUIRED; The name for this runbook.
	RunbookName *string `json:"runbookName,omitempty"`

	// REQUIRED; The resource id for webhook linked to this runbook.
	WebhookResourceID *string `json:"webhookResourceId,omitempty"`

	// Indicates name of the webhook.
	Name *string `json:"name,omitempty"`

	// The URI where webhooks should be sent.
	ServiceURI *string `json:"serviceUri,omitempty"`

	// Indicates whether to use common alert schema.
	UseCommonAlertSchema *bool `json:"useCommonAlertSchema,omitempty"`
}

// AutoscaleErrorResponse - Describes the format of Error response.
type AutoscaleErrorResponse struct {
	// The error object.
	Error *AutoscaleErrorResponseError `json:"error,omitempty"`

	// READ-ONLY; The system metadata related to the response.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`
}

// AutoscaleErrorResponseError - The error object.
type AutoscaleErrorResponseError struct {
	// One of a server-defined set of error codes.
	Code *string `json:"code,omitempty"`

	// A human-readable representation of the error's details.
	Details *string `json:"details,omitempty"`

	// A human-readable representation of the error.
	Message *string `json:"message,omitempty"`

	// The target of the particular error.
	Target *string `json:"target,omitempty"`
}

// AutoscaleNotification - Autoscale notification.
type AutoscaleNotification struct {
	// CONSTANT; the operation associated with the notification and its value must be "scale"
	// Field has constant value "Scale", any specified value is ignored.
	Operation *string `json:"operation,omitempty"`

	// the email notification.
	Email *EmailNotification `json:"email,omitempty"`

	// the collection of webhook notifications.
	Webhooks []*WebhookNotification `json:"webhooks,omitempty"`
}

// AutoscaleProfile - Autoscale profile.
type AutoscaleProfile struct {
	// REQUIRED; the number of instances that can be used during this profile.
	Capacity *ScaleCapacity `json:"capacity,omitempty"`

	// REQUIRED; the name of the profile.
	Name *string `json:"name,omitempty"`

	// REQUIRED; the collection of rules that provide the triggers and parameters for the scaling action. A maximum of 10 rules
	// can be specified.
	Rules []*ScaleRule `json:"rules,omitempty"`

	// the specific date-time for the profile. This element is not used if the Recurrence element is used.
	FixedDate *TimeWindow `json:"fixedDate,omitempty"`

	// the repeating times at which this profile begins. This element is not used if the FixedDate element is used.
	Recurrence *Recurrence `json:"recurrence,omitempty"`
}

// AutoscaleSetting - A setting that contains all of the configuration for the automatic scaling of a resource.
type AutoscaleSetting struct {
	// REQUIRED; the collection of automatic scaling profiles that specify different scaling parameters for different time periods.
	// A maximum of 20 profiles can be specified.
	Profiles []*AutoscaleProfile `json:"profiles,omitempty"`

	// the enabled flag. Specifies whether automatic scaling is enabled for the resource. The default value is 'false'.
	Enabled *bool `json:"enabled,omitempty"`

	// the name of the autoscale setting.
	Name *string `json:"name,omitempty"`

	// the collection of notifications.
	Notifications []*AutoscaleNotification `json:"notifications,omitempty"`

	// the predictive autoscale policy mode.
	PredictiveAutoscalePolicy *PredictiveAutoscalePolicy `json:"predictiveAutoscalePolicy,omitempty"`

	// the location of the resource that the autoscale setting should be added to.
	TargetResourceLocation *string `json:"targetResourceLocation,omitempty"`

	// the resource identifier of the resource that the autoscale setting should be added to.
	TargetResourceURI *string `json:"targetResourceUri,omitempty"`
}

// AutoscaleSettingResource - The autoscale setting resource.
type AutoscaleSettingResource struct {
	// REQUIRED; Resource location
	Location *string `json:"location,omitempty"`

	// REQUIRED; The autoscale setting of the resource.
	Properties *AutoscaleSetting `json:"properties,omitempty"`

	// Gets or sets a list of key value pairs that describe the resource. These tags can be used in viewing and grouping this
	// resource (across resource groups). A maximum of 15 tags can be provided for a
	// resource. Each tag must have a key no greater in length than 128 characters and a value no greater in length than 256 characters.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system metadata related to the response.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AutoscaleSettingResourceCollection - Represents a collection of autoscale setting resources.
type AutoscaleSettingResourceCollection struct {
	// REQUIRED; the values for the autoscale setting resources.
	Value []*AutoscaleSettingResource `json:"value,omitempty"`

	// URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// AutoscaleSettingResourcePatch - The autoscale setting object for patch operations.
type AutoscaleSettingResourcePatch struct {
	// The autoscale setting properties of the update operation.
	Properties *AutoscaleSetting `json:"properties,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`
}

// AutoscaleSettingsClientCreateOrUpdateOptions contains the optional parameters for the AutoscaleSettingsClient.CreateOrUpdate
// method.
type AutoscaleSettingsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// AutoscaleSettingsClientDeleteOptions contains the optional parameters for the AutoscaleSettingsClient.Delete method.
type AutoscaleSettingsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// AutoscaleSettingsClientGetOptions contains the optional parameters for the AutoscaleSettingsClient.Get method.
type AutoscaleSettingsClientGetOptions struct {
	// placeholder for future optional parameters
}

// AutoscaleSettingsClientListByResourceGroupOptions contains the optional parameters for the AutoscaleSettingsClient.ListByResourceGroup
// method.
type AutoscaleSettingsClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// AutoscaleSettingsClientListBySubscriptionOptions contains the optional parameters for the AutoscaleSettingsClient.ListBySubscription
// method.
type AutoscaleSettingsClientListBySubscriptionOptions struct {
	// placeholder for future optional parameters
}

// AutoscaleSettingsClientUpdateOptions contains the optional parameters for the AutoscaleSettingsClient.Update method.
type AutoscaleSettingsClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// AzureAppPushReceiver - The Azure mobile App push notification receiver.
type AzureAppPushReceiver struct {
	// REQUIRED; The email address registered for the Azure mobile app.
	EmailAddress *string `json:"emailAddress,omitempty"`

	// REQUIRED; The name of the Azure mobile app push receiver. Names must be unique across all receivers within an action group.
	Name *string `json:"name,omitempty"`
}

// AzureFunctionReceiver - An azure function receiver.
type AzureFunctionReceiver struct {
	// REQUIRED; The azure resource id of the function app.
	FunctionAppResourceID *string `json:"functionAppResourceId,omitempty"`

	// REQUIRED; The function name in the function app.
	FunctionName *string `json:"functionName,omitempty"`

	// REQUIRED; The http trigger url where http request sent to.
	HTTPTriggerURL *string `json:"httpTriggerUrl,omitempty"`

	// REQUIRED; The name of the azure function receiver. Names must be unique across all receivers within an action group.
	Name *string `json:"name,omitempty"`

	// Indicates whether to use common alert schema.
	UseCommonAlertSchema *bool `json:"useCommonAlertSchema,omitempty"`
}

// AzureMonitorMetricsDestination - Azure Monitor Metrics destination.
type AzureMonitorMetricsDestination struct {
	// A friendly name for the destination. This name should be unique across all destinations (regardless of type) within the
	// data collection rule.
	Name *string `json:"name,omitempty"`
}

// AzureMonitorPrivateLinkScope - An Azure Monitor PrivateLinkScope definition.
type AzureMonitorPrivateLinkScope struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// REQUIRED; Properties that define a Azure Monitor PrivateLinkScope resource.
	Properties *AzureMonitorPrivateLinkScopeProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; System data
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AzureMonitorPrivateLinkScopeListResult - Describes the list of Azure Monitor PrivateLinkScope resources.
type AzureMonitorPrivateLinkScopeListResult struct {
	// REQUIRED; List of Azure Monitor PrivateLinkScope definitions.
	Value []*AzureMonitorPrivateLinkScope `json:"value,omitempty"`

	// The URI to get the next set of Azure Monitor PrivateLinkScope definitions if too many PrivateLinkScopes where returned
	// in the result set.
	NextLink *string `json:"nextLink,omitempty"`
}

// AzureMonitorPrivateLinkScopeProperties - Properties that define a Azure Monitor PrivateLinkScope resource.
type AzureMonitorPrivateLinkScopeProperties struct {
	// REQUIRED; Access mode settings
	AccessModeSettings *AccessModeSettings `json:"accessModeSettings,omitempty"`

	// READ-ONLY; List of private endpoint connections.
	PrivateEndpointConnections []*PrivateEndpointConnection `json:"privateEndpointConnections,omitempty" azure:"ro"`

	// READ-ONLY; Current state of this PrivateLinkScope: whether or not is has been provisioned within the resource group it
	// is defined. Users cannot change this value but are able to read from it. Values will include
	// Provisioning ,Succeeded, Canceled and Failed.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// AzureResource - An azure resource object
type AzureResource struct {
	// REQUIRED; Resource location
	Location *string `json:"location,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AzureResourceAutoGenerated - An Azure resource object.
type AzureResourceAutoGenerated struct {
	// The location of the resource. Since Azure Activity Log Alerts is a global service, the location of the rules should always
	// be 'global'.
	Location *string `json:"location,omitempty"`

	// The tags of the resource.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// BaselineMetadata - Represents a baseline metadata value.
type BaselineMetadata struct {
	// REQUIRED; Name of the baseline metadata.
	Name *string `json:"name,omitempty"`

	// REQUIRED; Value of the baseline metadata.
	Value *string `json:"value,omitempty"`
}

// BaselinesClientListOptions contains the optional parameters for the BaselinesClient.List method.
type BaselinesClientListOptions struct {
	// The list of aggregation types (comma separated) to retrieve.
	Aggregation *string
	// The $filter is used to reduce the set of metric data returned. Example: Metric contains metadata A, B and C. - Return all
	// time series of C where A = a1 and B = b1 or b2 $filter=A eq 'a1' and B eq 'b1'
	// or B eq 'b2' and C eq '' - Invalid variant: $filter=A eq 'a1' and B eq 'b1' and C eq '' or B = 'b2' This is invalid because
	// the logical or operator cannot separate two different metadata names. -
	// Return all time series where A = a1, B = b1 and C = c1: $filter=A eq 'a1' and B eq 'b1' and C eq 'c1' - Return all time
	// series where A = a1 $filter=A eq 'a1' and B eq '' and C eq ''. Special case:
	// When dimension name or dimension value uses round brackets. Eg: When dimension name is dim (test) 1 Instead of using $filter=
	// "dim (test) 1 eq '' " use $filter= "dim %2528test%2529 1 eq '' " When
	// dimension name is dim (test) 3 and dimension value is dim3 (test) val Instead of using $filter= "dim (test) 3 eq 'dim3
	// (test) val' " use $filter= "dim %2528test%2529 3 eq 'dim3 %2528test%2529 val' "
	Filter *string
	// The interval (i.e. timegrain) of the query.
	Interval *string
	// The names of the metrics (comma separated) to retrieve. Special case: If a metricname itself has a comma in it then use
	// %2 to indicate it. Eg: 'Metric,Name1' should be 'Metric%2Name1'
	Metricnames *string
	// Metric namespace to query metric definitions for.
	Metricnamespace *string
	// Allows retrieving only metadata of the baseline. On data request all information is retrieved.
	ResultType *ResultType
	// The list of sensitivities (comma separated) to retrieve.
	Sensitivities *string
	// The timespan of the query. It is a string with the following format 'startDateTimeISO/endDateTimeISO'.
	Timespan *string
}

// ColumnDefinition - Definition of custom data column.
type ColumnDefinition struct {
	// The name of the column.
	Name *string `json:"name,omitempty"`

	// The type of the column data.
	Type *KnownColumnDefinitionType `json:"type,omitempty"`
}

// Condition - A condition of the scheduled query rule.
type Condition struct {
	// List of Dimensions conditions
	Dimensions []*Dimension `json:"dimensions,omitempty"`

	// The minimum number of violations required within the selected lookback time window required to raise an alert. Relevant
	// only for rules of the kind LogAlert.
	FailingPeriods *ConditionFailingPeriods `json:"failingPeriods,omitempty"`

	// The column containing the metric measure number. Relevant only for rules of the kind LogAlert.
	MetricMeasureColumn *string `json:"metricMeasureColumn,omitempty"`

	// The name of the metric to be sent. Relevant and required only for rules of the kind LogToMetric.
	MetricName *string `json:"metricName,omitempty"`

	// The criteria operator. Relevant and required only for rules of the kind LogAlert.
	Operator *ConditionOperator `json:"operator,omitempty"`

	// Log query alert
	Query *string `json:"query,omitempty"`

	// The column containing the resource id. The content of the column must be a uri formatted as resource id. Relevant only
	// for rules of the kind LogAlert.
	ResourceIDColumn *string `json:"resourceIdColumn,omitempty"`

	// the criteria threshold value that activates the alert. Relevant and required only for rules of the kind LogAlert.
	Threshold *float64 `json:"threshold,omitempty"`

	// Aggregation type. Relevant and required only for rules of the kind LogAlert.
	TimeAggregation *TimeAggregation `json:"timeAggregation,omitempty"`
}

// ConditionFailingPeriods - The minimum number of violations required within the selected lookback time window required to
// raise an alert. Relevant only for rules of the kind LogAlert.
type ConditionFailingPeriods struct {
	// The number of violations to trigger an alert. Should be smaller or equal to numberOfEvaluationPeriods. Default value is
	// 1
	MinFailingPeriodsToAlert *int64 `json:"minFailingPeriodsToAlert,omitempty"`

	// The number of aggregated lookback points. The lookback time window is calculated based on the aggregation granularity (windowSize)
	// and the selected number of aggregated points. Default value is 1
	NumberOfEvaluationPeriods *int64 `json:"numberOfEvaluationPeriods,omitempty"`
}

// ConfigurationAccessEndpointSpec - Definition of the endpoint used for accessing configuration.
type ConfigurationAccessEndpointSpec struct {
	// READ-ONLY; The endpoint. This property is READ-ONLY.
	Endpoint *string `json:"endpoint,omitempty" azure:"ro"`
}

// Context - The context info
type Context struct {
	// The context id type
	ContextType *string `json:"contextType,omitempty"`

	// The source of the notification request
	NotificationSource *string `json:"notificationSource,omitempty"`
}

// DataCollectionEndpoint - Definition of data collection endpoint.
type DataCollectionEndpoint struct {
	// The endpoint used by clients to access their configuration.
	ConfigurationAccess *DataCollectionEndpointConfigurationAccess `json:"configurationAccess,omitempty"`

	// Description of the data collection endpoint.
	Description *string `json:"description,omitempty"`

	// The immutable ID of this data collection endpoint resource. This property is READ-ONLY.
	ImmutableID *string `json:"immutableId,omitempty"`

	// The endpoint used by clients to ingest logs.
	LogsIngestion *DataCollectionEndpointLogsIngestion `json:"logsIngestion,omitempty"`

	// Network access control rules for the endpoints.
	NetworkACLs *DataCollectionEndpointNetworkACLs `json:"networkAcls,omitempty"`

	// READ-ONLY; The resource provisioning state. This property is READ-ONLY.
	ProvisioningState *KnownDataCollectionEndpointProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// DataCollectionEndpointConfigurationAccess - The endpoint used by clients to access their configuration.
type DataCollectionEndpointConfigurationAccess struct {
	// READ-ONLY; The endpoint. This property is READ-ONLY.
	Endpoint *string `json:"endpoint,omitempty" azure:"ro"`
}

// DataCollectionEndpointLogsIngestion - The endpoint used by clients to ingest logs.
type DataCollectionEndpointLogsIngestion struct {
	// READ-ONLY; The endpoint. This property is READ-ONLY.
	Endpoint *string `json:"endpoint,omitempty" azure:"ro"`
}

// DataCollectionEndpointNetworkACLs - Network access control rules for the endpoints.
type DataCollectionEndpointNetworkACLs struct {
	// The configuration to set whether network access from public internet to the endpoints are allowed.
	PublicNetworkAccess *KnownPublicNetworkAccessOptions `json:"publicNetworkAccess,omitempty"`
}

// DataCollectionEndpointResource - Definition of ARM tracked top level resource.
type DataCollectionEndpointResource struct {
	// REQUIRED; The geo-location where the resource lives.
	Location *string `json:"location,omitempty"`

	// The kind of the resource.
	Kind *KnownDataCollectionEndpointResourceKind `json:"kind,omitempty"`

	// Resource properties.
	Properties *DataCollectionEndpointResourceProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource entity tag (ETag).
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Fully qualified ID of the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *DataCollectionEndpointResourceSystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DataCollectionEndpointResourceListResult - A pageable list of resources.
type DataCollectionEndpointResourceListResult struct {
	// REQUIRED; A list of resources.
	Value []*DataCollectionEndpointResource `json:"value,omitempty"`

	// The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// DataCollectionEndpointResourceProperties - Resource properties.
type DataCollectionEndpointResourceProperties struct {
	// The endpoint used by clients to access their configuration.
	ConfigurationAccess *DataCollectionEndpointConfigurationAccess `json:"configurationAccess,omitempty"`

	// Description of the data collection endpoint.
	Description *string `json:"description,omitempty"`

	// The immutable ID of this data collection endpoint resource. This property is READ-ONLY.
	ImmutableID *string `json:"immutableId,omitempty"`

	// The endpoint used by clients to ingest logs.
	LogsIngestion *DataCollectionEndpointLogsIngestion `json:"logsIngestion,omitempty"`

	// Network access control rules for the endpoints.
	NetworkACLs *DataCollectionEndpointNetworkACLs `json:"networkAcls,omitempty"`

	// READ-ONLY; The resource provisioning state. This property is READ-ONLY.
	ProvisioningState *KnownDataCollectionEndpointProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// DataCollectionEndpointResourceSystemData - Metadata pertaining to creation and last modification of the resource.
type DataCollectionEndpointResourceSystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time `json:"createdAt,omitempty"`

	// The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`

	// The type of identity that created the resource.
	CreatedByType *CreatedByType `json:"createdByType,omitempty"`

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time `json:"lastModifiedAt,omitempty"`

	// The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType `json:"lastModifiedByType,omitempty"`
}

// DataCollectionEndpointsClientCreateOptions contains the optional parameters for the DataCollectionEndpointsClient.Create
// method.
type DataCollectionEndpointsClientCreateOptions struct {
	// The payload
	Body *DataCollectionEndpointResource
}

// DataCollectionEndpointsClientDeleteOptions contains the optional parameters for the DataCollectionEndpointsClient.Delete
// method.
type DataCollectionEndpointsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// DataCollectionEndpointsClientGetOptions contains the optional parameters for the DataCollectionEndpointsClient.Get method.
type DataCollectionEndpointsClientGetOptions struct {
	// placeholder for future optional parameters
}

// DataCollectionEndpointsClientListByResourceGroupOptions contains the optional parameters for the DataCollectionEndpointsClient.ListByResourceGroup
// method.
type DataCollectionEndpointsClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// DataCollectionEndpointsClientListBySubscriptionOptions contains the optional parameters for the DataCollectionEndpointsClient.ListBySubscription
// method.
type DataCollectionEndpointsClientListBySubscriptionOptions struct {
	// placeholder for future optional parameters
}

// DataCollectionEndpointsClientUpdateOptions contains the optional parameters for the DataCollectionEndpointsClient.Update
// method.
type DataCollectionEndpointsClientUpdateOptions struct {
	// The payload
	Body *ResourceForUpdate
}

// DataCollectionRule - Definition of what monitoring data to collect and where that data should be sent.
type DataCollectionRule struct {
	// The resource ID of the data collection endpoint that this rule can be used with.
	DataCollectionEndpointID *string `json:"dataCollectionEndpointId,omitempty"`

	// The specification of data flows.
	DataFlows []*DataFlow `json:"dataFlows,omitempty"`

	// The specification of data sources. This property is optional and can be omitted if the rule is meant to be used via direct
	// calls to the provisioned endpoint.
	DataSources *DataCollectionRuleDataSources `json:"dataSources,omitempty"`

	// Description of the data collection rule.
	Description *string `json:"description,omitempty"`

	// The specification of destinations.
	Destinations *DataCollectionRuleDestinations `json:"destinations,omitempty"`

	// Declaration of custom streams used in this rule.
	StreamDeclarations map[string]*StreamDeclaration `json:"streamDeclarations,omitempty"`

	// READ-ONLY; The immutable ID of this data collection rule. This property is READ-ONLY.
	ImmutableID *string `json:"immutableId,omitempty" azure:"ro"`

	// READ-ONLY; Metadata about the resource
	Metadata *DataCollectionRuleMetadata `json:"metadata,omitempty" azure:"ro"`

	// READ-ONLY; The resource provisioning state.
	ProvisioningState *KnownDataCollectionRuleProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// DataCollectionRuleAssociation - Definition of association of a data collection rule with a monitored Azure resource.
type DataCollectionRuleAssociation struct {
	// The resource ID of the data collection endpoint that is to be associated.
	DataCollectionEndpointID *string `json:"dataCollectionEndpointId,omitempty"`

	// The resource ID of the data collection rule that is to be associated.
	DataCollectionRuleID *string `json:"dataCollectionRuleId,omitempty"`

	// Description of the association.
	Description *string `json:"description,omitempty"`

	// READ-ONLY; Metadata about the resource
	Metadata *DataCollectionRuleAssociationMetadata `json:"metadata,omitempty" azure:"ro"`

	// READ-ONLY; The resource provisioning state.
	ProvisioningState *KnownDataCollectionRuleAssociationProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// DataCollectionRuleAssociationMetadata - Metadata about the resource
type DataCollectionRuleAssociationMetadata struct {
	// READ-ONLY; Azure offering managing this resource on-behalf-of customer.
	ProvisionedBy *string `json:"provisionedBy,omitempty" azure:"ro"`
}

// DataCollectionRuleAssociationProxyOnlyResource - Definition of generic ARM proxy resource.
type DataCollectionRuleAssociationProxyOnlyResource struct {
	// Resource properties.
	Properties *DataCollectionRuleAssociationProxyOnlyResourceProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource entity tag (ETag).
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Fully qualified ID of the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *DataCollectionRuleAssociationProxyOnlyResourceSystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DataCollectionRuleAssociationProxyOnlyResourceListResult - A pageable list of resources.
type DataCollectionRuleAssociationProxyOnlyResourceListResult struct {
	// REQUIRED; A list of resources.
	Value []*DataCollectionRuleAssociationProxyOnlyResource `json:"value,omitempty"`

	// The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// DataCollectionRuleAssociationProxyOnlyResourceProperties - Resource properties.
type DataCollectionRuleAssociationProxyOnlyResourceProperties struct {
	// The resource ID of the data collection endpoint that is to be associated.
	DataCollectionEndpointID *string `json:"dataCollectionEndpointId,omitempty"`

	// The resource ID of the data collection rule that is to be associated.
	DataCollectionRuleID *string `json:"dataCollectionRuleId,omitempty"`

	// Description of the association.
	Description *string `json:"description,omitempty"`

	// READ-ONLY; Metadata about the resource
	Metadata *DataCollectionRuleAssociationMetadata `json:"metadata,omitempty" azure:"ro"`

	// READ-ONLY; The resource provisioning state.
	ProvisioningState *KnownDataCollectionRuleAssociationProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// DataCollectionRuleAssociationProxyOnlyResourceSystemData - Metadata pertaining to creation and last modification of the
// resource.
type DataCollectionRuleAssociationProxyOnlyResourceSystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time `json:"createdAt,omitempty"`

	// The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`

	// The type of identity that created the resource.
	CreatedByType *CreatedByType `json:"createdByType,omitempty"`

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time `json:"lastModifiedAt,omitempty"`

	// The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType `json:"lastModifiedByType,omitempty"`
}

// DataCollectionRuleAssociationsClientCreateOptions contains the optional parameters for the DataCollectionRuleAssociationsClient.Create
// method.
type DataCollectionRuleAssociationsClientCreateOptions struct {
	// The payload
	Body *DataCollectionRuleAssociationProxyOnlyResource
}

// DataCollectionRuleAssociationsClientDeleteOptions contains the optional parameters for the DataCollectionRuleAssociationsClient.Delete
// method.
type DataCollectionRuleAssociationsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// DataCollectionRuleAssociationsClientGetOptions contains the optional parameters for the DataCollectionRuleAssociationsClient.Get
// method.
type DataCollectionRuleAssociationsClientGetOptions struct {
	// placeholder for future optional parameters
}

// DataCollectionRuleAssociationsClientListByDataCollectionEndpointOptions contains the optional parameters for the DataCollectionRuleAssociationsClient.ListByDataCollectionEndpoint
// method.
type DataCollectionRuleAssociationsClientListByDataCollectionEndpointOptions struct {
	// placeholder for future optional parameters
}

// DataCollectionRuleAssociationsClientListByResourceOptions contains the optional parameters for the DataCollectionRuleAssociationsClient.ListByResource
// method.
type DataCollectionRuleAssociationsClientListByResourceOptions struct {
	// placeholder for future optional parameters
}

// DataCollectionRuleAssociationsClientListByRuleOptions contains the optional parameters for the DataCollectionRuleAssociationsClient.ListByRule
// method.
type DataCollectionRuleAssociationsClientListByRuleOptions struct {
	// placeholder for future optional parameters
}

// DataCollectionRuleDataSources - The specification of data sources. This property is optional and can be omitted if the
// rule is meant to be used via direct calls to the provisioned endpoint.
type DataCollectionRuleDataSources struct {
	// The list of Azure VM extension data source configurations.
	Extensions []*ExtensionDataSource `json:"extensions,omitempty"`

	// The list of IIS logs source configurations.
	IisLogs []*IisLogsDataSource `json:"iisLogs,omitempty"`

	// The list of Log files source configurations.
	LogFiles []*LogFilesDataSource `json:"logFiles,omitempty"`

	// The list of performance counter data source configurations.
	PerformanceCounters []*PerfCounterDataSource `json:"performanceCounters,omitempty"`

	// The list of Syslog data source configurations.
	Syslog []*SyslogDataSource `json:"syslog,omitempty"`

	// The list of Windows Event Log data source configurations.
	WindowsEventLogs []*WindowsEventLogDataSource `json:"windowsEventLogs,omitempty"`
}

// DataCollectionRuleDestinations - The specification of destinations.
type DataCollectionRuleDestinations struct {
	// Azure Monitor Metrics destination.
	AzureMonitorMetrics *DestinationsSpecAzureMonitorMetrics `json:"azureMonitorMetrics,omitempty"`

	// List of Log Analytics destinations.
	LogAnalytics []*LogAnalyticsDestination `json:"logAnalytics,omitempty"`
}

// DataCollectionRuleMetadata - Metadata about the resource
type DataCollectionRuleMetadata struct {
	// READ-ONLY; Azure offering managing this resource on-behalf-of customer.
	ProvisionedBy *string `json:"provisionedBy,omitempty" azure:"ro"`
}

// DataCollectionRuleResource - Definition of ARM tracked top level resource.
type DataCollectionRuleResource struct {
	// REQUIRED; The geo-location where the resource lives.
	Location *string `json:"location,omitempty"`

	// The kind of the resource.
	Kind *KnownDataCollectionRuleResourceKind `json:"kind,omitempty"`

	// Resource properties.
	Properties *DataCollectionRuleResourceProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource entity tag (ETag).
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Fully qualified ID of the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *DataCollectionRuleResourceSystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DataCollectionRuleResourceListResult - A pageable list of resources.
type DataCollectionRuleResourceListResult struct {
	// REQUIRED; A list of resources.
	Value []*DataCollectionRuleResource `json:"value,omitempty"`

	// The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// DataCollectionRuleResourceProperties - Resource properties.
type DataCollectionRuleResourceProperties struct {
	// The resource ID of the data collection endpoint that this rule can be used with.
	DataCollectionEndpointID *string `json:"dataCollectionEndpointId,omitempty"`

	// The specification of data flows.
	DataFlows []*DataFlow `json:"dataFlows,omitempty"`

	// The specification of data sources. This property is optional and can be omitted if the rule is meant to be used via direct
	// calls to the provisioned endpoint.
	DataSources *DataCollectionRuleDataSources `json:"dataSources,omitempty"`

	// Description of the data collection rule.
	Description *string `json:"description,omitempty"`

	// The specification of destinations.
	Destinations *DataCollectionRuleDestinations `json:"destinations,omitempty"`

	// Declaration of custom streams used in this rule.
	StreamDeclarations map[string]*StreamDeclaration `json:"streamDeclarations,omitempty"`

	// READ-ONLY; The immutable ID of this data collection rule. This property is READ-ONLY.
	ImmutableID *string `json:"immutableId,omitempty" azure:"ro"`

	// READ-ONLY; Metadata about the resource
	Metadata *DataCollectionRuleMetadata `json:"metadata,omitempty" azure:"ro"`

	// READ-ONLY; The resource provisioning state.
	ProvisioningState *KnownDataCollectionRuleProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// DataCollectionRuleResourceSystemData - Metadata pertaining to creation and last modification of the resource.
type DataCollectionRuleResourceSystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time `json:"createdAt,omitempty"`

	// The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`

	// The type of identity that created the resource.
	CreatedByType *CreatedByType `json:"createdByType,omitempty"`

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time `json:"lastModifiedAt,omitempty"`

	// The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType `json:"lastModifiedByType,omitempty"`
}

// DataCollectionRulesClientCreateOptions contains the optional parameters for the DataCollectionRulesClient.Create method.
type DataCollectionRulesClientCreateOptions struct {
	// The payload
	Body *DataCollectionRuleResource
}

// DataCollectionRulesClientDeleteOptions contains the optional parameters for the DataCollectionRulesClient.Delete method.
type DataCollectionRulesClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// DataCollectionRulesClientGetOptions contains the optional parameters for the DataCollectionRulesClient.Get method.
type DataCollectionRulesClientGetOptions struct {
	// placeholder for future optional parameters
}

// DataCollectionRulesClientListByResourceGroupOptions contains the optional parameters for the DataCollectionRulesClient.ListByResourceGroup
// method.
type DataCollectionRulesClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// DataCollectionRulesClientListBySubscriptionOptions contains the optional parameters for the DataCollectionRulesClient.ListBySubscription
// method.
type DataCollectionRulesClientListBySubscriptionOptions struct {
	// placeholder for future optional parameters
}

// DataCollectionRulesClientUpdateOptions contains the optional parameters for the DataCollectionRulesClient.Update method.
type DataCollectionRulesClientUpdateOptions struct {
	// The payload
	Body *ResourceForUpdate
}

// DataContainer - Information about a container with data for a given resource.
type DataContainer struct {
	// REQUIRED; Log Analytics workspace information.
	Workspace *WorkspaceInfo `json:"workspace,omitempty"`
}

// DataFlow - Definition of which streams are sent to which destinations.
type DataFlow struct {
	// List of destinations for this data flow.
	Destinations []*string `json:"destinations,omitempty"`

	// The output stream of the transform. Only required if the transform changes data to a different stream.
	OutputStream *string `json:"outputStream,omitempty"`

	// List of streams for this data flow.
	Streams []*KnownDataFlowStreams `json:"streams,omitempty"`

	// The KQL query to transform stream data.
	TransformKql *string `json:"transformKql,omitempty"`
}

// DataSourcesSpec - Specification of data sources that will be collected.
type DataSourcesSpec struct {
	// The list of Azure VM extension data source configurations.
	Extensions []*ExtensionDataSource `json:"extensions,omitempty"`

	// The list of IIS logs source configurations.
	IisLogs []*IisLogsDataSource `json:"iisLogs,omitempty"`

	// The list of Log files source configurations.
	LogFiles []*LogFilesDataSource `json:"logFiles,omitempty"`

	// The list of performance counter data source configurations.
	PerformanceCounters []*PerfCounterDataSource `json:"performanceCounters,omitempty"`

	// The list of Syslog data source configurations.
	Syslog []*SyslogDataSource `json:"syslog,omitempty"`

	// The list of Windows Event Log data source configurations.
	WindowsEventLogs []*WindowsEventLogDataSource `json:"windowsEventLogs,omitempty"`
}

// DefaultErrorResponse - Common error response for all Azure Resource Manager APIs to return error details for failed operations.
// (This also follows the OData error response format.).
type DefaultErrorResponse struct {
	// The error object.
	Error *ErrorDetail `json:"error,omitempty"`
}

// DestinationsSpec - Specification of destinations that can be used in data flows.
type DestinationsSpec struct {
	// Azure Monitor Metrics destination.
	AzureMonitorMetrics *DestinationsSpecAzureMonitorMetrics `json:"azureMonitorMetrics,omitempty"`

	// List of Log Analytics destinations.
	LogAnalytics []*LogAnalyticsDestination `json:"logAnalytics,omitempty"`
}

// DestinationsSpecAzureMonitorMetrics - Azure Monitor Metrics destination.
type DestinationsSpecAzureMonitorMetrics struct {
	// A friendly name for the destination. This name should be unique across all destinations (regardless of type) within the
	// data collection rule.
	Name *string `json:"name,omitempty"`
}

// DiagnosticSettings - The diagnostic settings.
type DiagnosticSettings struct {
	// The resource Id for the event hub authorization rule.
	EventHubAuthorizationRuleID *string `json:"eventHubAuthorizationRuleId,omitempty"`

	// The name of the event hub. If none is specified, the default event hub will be selected.
	EventHubName *string `json:"eventHubName,omitempty"`

	// A string indicating whether the export to Log Analytics should use the default destination type, i.e. AzureDiagnostics,
	// or use a destination type constructed as follows: _. Possible values are:
	// Dedicated and null (null is default.)
	LogAnalyticsDestinationType *string `json:"logAnalyticsDestinationType,omitempty"`

	// The list of logs settings.
	Logs []*LogSettings `json:"logs,omitempty"`

	// The full ARM resource ID of the Marketplace resource to which you would like to send Diagnostic Logs.
	MarketplacePartnerID *string `json:"marketplacePartnerId,omitempty"`

	// The list of metric settings.
	Metrics []*MetricSettings `json:"metrics,omitempty"`

	// The service bus rule Id of the diagnostic setting. This is here to maintain backwards compatibility.
	ServiceBusRuleID *string `json:"serviceBusRuleId,omitempty"`

	// The resource ID of the storage account to which you would like to send Diagnostic Logs.
	StorageAccountID *string `json:"storageAccountId,omitempty"`

	// The full ARM resource ID of the Log Analytics workspace to which you would like to send Diagnostic Logs. Example:
	// /subscriptions/4b9e8510-67ab-4e9a-95a9-e2f1e570ea9c/resourceGroups/insights-integration/providers/Microsoft.OperationalInsights/workspaces/viruela2
	WorkspaceID *string `json:"workspaceId,omitempty"`
}

// DiagnosticSettingsCategory - The diagnostic settings Category.
type DiagnosticSettingsCategory struct {
	// the collection of what category groups are supported.
	CategoryGroups []*string `json:"categoryGroups,omitempty"`

	// The type of the diagnostic settings category.
	CategoryType *CategoryType `json:"categoryType,omitempty"`
}

// DiagnosticSettingsCategoryClientGetOptions contains the optional parameters for the DiagnosticSettingsCategoryClient.Get
// method.
type DiagnosticSettingsCategoryClientGetOptions struct {
	// placeholder for future optional parameters
}

// DiagnosticSettingsCategoryClientListOptions contains the optional parameters for the DiagnosticSettingsCategoryClient.List
// method.
type DiagnosticSettingsCategoryClientListOptions struct {
	// placeholder for future optional parameters
}

// DiagnosticSettingsCategoryResource - The diagnostic settings category resource.
type DiagnosticSettingsCategoryResource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The properties of a Diagnostic Settings Category.
	Properties *DiagnosticSettingsCategory `json:"properties,omitempty" azure:"ro"`

	// READ-ONLY; The system metadata related to this resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DiagnosticSettingsCategoryResourceCollection - Represents a collection of diagnostic setting category resources.
type DiagnosticSettingsCategoryResourceCollection struct {
	// The collection of diagnostic settings category resources.
	Value []*DiagnosticSettingsCategoryResource `json:"value,omitempty"`
}

// DiagnosticSettingsClientCreateOrUpdateOptions contains the optional parameters for the DiagnosticSettingsClient.CreateOrUpdate
// method.
type DiagnosticSettingsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// DiagnosticSettingsClientDeleteOptions contains the optional parameters for the DiagnosticSettingsClient.Delete method.
type DiagnosticSettingsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// DiagnosticSettingsClientGetOptions contains the optional parameters for the DiagnosticSettingsClient.Get method.
type DiagnosticSettingsClientGetOptions struct {
	// placeholder for future optional parameters
}

// DiagnosticSettingsClientListOptions contains the optional parameters for the DiagnosticSettingsClient.List method.
type DiagnosticSettingsClientListOptions struct {
	// placeholder for future optional parameters
}

// DiagnosticSettingsResource - The diagnostic setting resource.
type DiagnosticSettingsResource struct {
	// Properties of a Diagnostic Settings Resource.
	Properties *DiagnosticSettings `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system metadata related to this resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DiagnosticSettingsResourceCollection - Represents a collection of alert rule resources.
type DiagnosticSettingsResourceCollection struct {
	// The collection of diagnostic settings resources;.
	Value []*DiagnosticSettingsResource `json:"value,omitempty"`
}

// Dimension splitting and filtering definition
type Dimension struct {
	// REQUIRED; Name of the dimension
	Name *string `json:"name,omitempty"`

	// REQUIRED; Operator for dimension values
	Operator *DimensionOperator `json:"operator,omitempty"`

	// REQUIRED; List of dimension values
	Values []*string `json:"values,omitempty"`
}

// DynamicMetricCriteria - Criterion for dynamic threshold.
type DynamicMetricCriteria struct {
	// REQUIRED; The extent of deviation required to trigger an alert. This will affect how tight the threshold is to the metric
	// series pattern.
	AlertSensitivity *DynamicThresholdSensitivity `json:"alertSensitivity,omitempty"`

	// REQUIRED; Specifies the type of threshold criteria
	CriterionType *CriterionType `json:"criterionType,omitempty"`

	// REQUIRED; The minimum number of violations required within the selected lookback time window required to raise an alert.
	FailingPeriods *DynamicThresholdFailingPeriods `json:"failingPeriods,omitempty"`

	// REQUIRED; Name of the metric.
	MetricName *string `json:"metricName,omitempty"`

	// REQUIRED; Name of the criteria.
	Name *string `json:"name,omitempty"`

	// REQUIRED; The operator used to compare the metric value against the threshold.
	Operator *DynamicThresholdOperator `json:"operator,omitempty"`

	// REQUIRED; the criteria time aggregation types.
	TimeAggregation *AggregationTypeEnum `json:"timeAggregation,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of dimension conditions.
	Dimensions []*MetricDimension `json:"dimensions,omitempty"`

	// Use this option to set the date from which to start learning the metric historical data and calculate the dynamic thresholds
	// (in ISO8601 format)
	IgnoreDataBefore *time.Time `json:"ignoreDataBefore,omitempty"`

	// Namespace of the metric.
	MetricNamespace *string `json:"metricNamespace,omitempty"`

	// Allows creating an alert rule on a custom metric that isn't yet emitted, by causing the metric validation to be skipped.
	SkipMetricValidation *bool `json:"skipMetricValidation,omitempty"`
}

// GetMultiMetricCriteria implements the MultiMetricCriteriaClassification interface for type DynamicMetricCriteria.
func (d *DynamicMetricCriteria) GetMultiMetricCriteria() *MultiMetricCriteria {
	return &MultiMetricCriteria{
		CriterionType:        d.CriterionType,
		Name:                 d.Name,
		MetricName:           d.MetricName,
		MetricNamespace:      d.MetricNamespace,
		TimeAggregation:      d.TimeAggregation,
		Dimensions:           d.Dimensions,
		SkipMetricValidation: d.SkipMetricValidation,
		AdditionalProperties: d.AdditionalProperties,
	}
}

// DynamicThresholdFailingPeriods - The minimum number of violations required within the selected lookback time window required
// to raise an alert.
type DynamicThresholdFailingPeriods struct {
	// REQUIRED; The number of violations to trigger an alert. Should be smaller or equal to numberOfEvaluationPeriods.
	MinFailingPeriodsToAlert *float32 `json:"minFailingPeriodsToAlert,omitempty"`

	// REQUIRED; The number of aggregated lookback points. The lookback time window is calculated based on the aggregation granularity
	// (windowSize) and the selected number of aggregated points.
	NumberOfEvaluationPeriods *float32 `json:"numberOfEvaluationPeriods,omitempty"`
}

// EmailNotification - Email notification of an autoscale event.
type EmailNotification struct {
	// the custom e-mails list. This value can be null or empty, in which case this attribute will be ignored.
	CustomEmails []*string `json:"customEmails,omitempty"`

	// a value indicating whether to send email to subscription administrator.
	SendToSubscriptionAdministrator *bool `json:"sendToSubscriptionAdministrator,omitempty"`

	// a value indicating whether to send email to subscription co-administrators.
	SendToSubscriptionCoAdministrators *bool `json:"sendToSubscriptionCoAdministrators,omitempty"`
}

// EmailReceiver - An email receiver.
type EmailReceiver struct {
	// REQUIRED; The email address of this receiver.
	EmailAddress *string `json:"emailAddress,omitempty"`

	// REQUIRED; The name of the email receiver. Names must be unique across all receivers within an action group.
	Name *string `json:"name,omitempty"`

	// Indicates whether to use common alert schema.
	UseCommonAlertSchema *bool `json:"useCommonAlertSchema,omitempty"`

	// READ-ONLY; The receiver status of the e-mail.
	Status *ReceiverStatus `json:"status,omitempty" azure:"ro"`
}

// EnableRequest - Describes a receiver that should be resubscribed.
type EnableRequest struct {
	// REQUIRED; The name of the receiver to resubscribe.
	ReceiverName *string `json:"receiverName,omitempty"`
}

// Error details.
type Error struct {
	// REQUIRED; Error code identifying the specific error.
	Code *string `json:"code,omitempty"`

	// Error message in the caller's locale.
	Message *string `json:"message,omitempty"`
}

// ErrorAdditionalInfo - The resource management error additional info.
type ErrorAdditionalInfo struct {
	// READ-ONLY; The additional info.
	Info interface{} `json:"info,omitempty" azure:"ro"`

	// READ-ONLY; The additional info type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ErrorContract - Describes the format of Error response.
type ErrorContract struct {
	// The error details.
	Error *ErrorResponseDetails `json:"error,omitempty"`
}

// ErrorDetail - The error detail.
type ErrorDetail struct {
	// READ-ONLY; The error additional info.
	AdditionalInfo []*ErrorAdditionalInfo `json:"additionalInfo,omitempty" azure:"ro"`

	// READ-ONLY; The error code.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; The error details.
	Details []*ErrorDetail `json:"details,omitempty" azure:"ro"`

	// READ-ONLY; The error message.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; The error target.
	Target *string `json:"target,omitempty" azure:"ro"`
}

// ErrorResponse - Describes the format of Error response.
type ErrorResponse struct {
	// Error code
	Code *string `json:"code,omitempty"`

	// Error message indicating why the operation failed.
	Message *string `json:"message,omitempty"`
}

// ErrorResponseAdditionalInfo - The resource management error additional info.
type ErrorResponseAdditionalInfo struct {
	// READ-ONLY; The additional info.
	Info interface{} `json:"info,omitempty" azure:"ro"`

	// READ-ONLY; The additional info type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ErrorResponseAutoGenerated - The error response.
type ErrorResponseAutoGenerated struct {
	// READ-ONLY; The error code.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; The error message indicating why the operation failed.
	Message *string `json:"message,omitempty" azure:"ro"`
}

// ErrorResponseCommonV2 - Common error response for all Azure Resource Manager APIs to return error details for failed operations.
// (This also follows the OData error response format.).
type ErrorResponseCommonV2 struct {
	// The error object.
	Error *ErrorDetail `json:"error,omitempty"`
}

// ErrorResponseDetails - Common error response for all Azure Resource Manager APIs to return error details for failed operations.
// (This also follows the OData error response format.)
type ErrorResponseDetails struct {
	// READ-ONLY; The error additional info.
	AdditionalInfo []*ErrorResponseAdditionalInfo `json:"additionalInfo,omitempty" azure:"ro"`

	// READ-ONLY; The error code.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; The error details.
	Details []*ErrorResponseDetails `json:"details,omitempty" azure:"ro"`

	// READ-ONLY; The error message.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; The error target.
	Target *string `json:"target,omitempty" azure:"ro"`
}

// EventCategoriesClientListOptions contains the optional parameters for the EventCategoriesClient.List method.
type EventCategoriesClientListOptions struct {
	// placeholder for future optional parameters
}

// EventCategoryCollection - A collection of event categories. Currently possible values are: Administrative, Security, ServiceHealth,
// Alert, Recommendation, Policy.
type EventCategoryCollection struct {
	// REQUIRED; the list that includes the Azure event categories.
	Value []*LocalizableString `json:"value,omitempty"`
}

// EventData - The Azure event log entries are of type EventData
type EventData struct {
	// READ-ONLY; The sender authorization information.
	Authorization *SenderAuthorization `json:"authorization,omitempty" azure:"ro"`

	// READ-ONLY; the email address of the user who has performed the operation, the UPN claim or SPN claim based on availability.
	Caller *string `json:"caller,omitempty" azure:"ro"`

	// READ-ONLY; the event category.
	Category *LocalizableString `json:"category,omitempty" azure:"ro"`

	// READ-ONLY; key value pairs to identify ARM permissions.
	Claims map[string]*string `json:"claims,omitempty" azure:"ro"`

	// READ-ONLY; the correlation Id, usually a GUID in the string format. The correlation Id is shared among the events that
	// belong to the same uber operation.
	CorrelationID *string `json:"correlationId,omitempty" azure:"ro"`

	// READ-ONLY; the description of the event.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; the event data Id. This is a unique identifier for an event.
	EventDataID *string `json:"eventDataId,omitempty" azure:"ro"`

	// READ-ONLY; the event name. This value should not be confused with OperationName. For practical purposes, OperationName
	// might be more appealing to end users.
	EventName *LocalizableString `json:"eventName,omitempty" azure:"ro"`

	// READ-ONLY; the timestamp of when the event was generated by the Azure service processing the request corresponding the
	// event. It in ISO 8601 format.
	EventTimestamp *time.Time `json:"eventTimestamp,omitempty" azure:"ro"`

	// READ-ONLY; the HTTP request info. Usually includes the 'clientRequestId', 'clientIpAddress' (IP address of the user who
	// initiated the event) and 'method' (HTTP method e.g. PUT).
	HTTPRequest *HTTPRequestInfo `json:"httpRequest,omitempty" azure:"ro"`

	// READ-ONLY; the Id of this event as required by ARM for RBAC. It contains the EventDataID and a timestamp information.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; the event level
	Level *EventLevel `json:"level,omitempty" azure:"ro"`

	// READ-ONLY; It is usually a GUID shared among the events corresponding to single operation. This value should not be confused
	// with EventName.
	OperationID *string `json:"operationId,omitempty" azure:"ro"`

	// READ-ONLY; the operation name.
	OperationName *LocalizableString `json:"operationName,omitempty" azure:"ro"`

	// READ-ONLY; the set of pairs (usually a Dictionary) that includes details about the event.
	Properties map[string]*string `json:"properties,omitempty" azure:"ro"`

	// READ-ONLY; the resource group name of the impacted resource.
	ResourceGroupName *string `json:"resourceGroupName,omitempty" azure:"ro"`

	// READ-ONLY; the resource uri that uniquely identifies the resource that caused this event.
	ResourceID *string `json:"resourceId,omitempty" azure:"ro"`

	// READ-ONLY; the resource provider name of the impacted resource.
	ResourceProviderName *LocalizableString `json:"resourceProviderName,omitempty" azure:"ro"`

	// READ-ONLY; the resource type
	ResourceType *LocalizableString `json:"resourceType,omitempty" azure:"ro"`

	// READ-ONLY; a string describing the status of the operation. Some typical values are: Started, In progress, Succeeded, Failed,
	// Resolved.
	Status *LocalizableString `json:"status,omitempty" azure:"ro"`

	// READ-ONLY; the event sub status. Most of the time, when included, this captures the HTTP status code of the REST call.
	// Common values are: OK (HTTP Status Code: 200), Created (HTTP Status Code: 201), Accepted
	// (HTTP Status Code: 202), No Content (HTTP Status Code: 204), Bad Request(HTTP Status Code: 400), Not Found (HTTP Status
	// Code: 404), Conflict (HTTP Status Code: 409), Internal Server Error (HTTP Status
	// Code: 500), Service Unavailable (HTTP Status Code:503), Gateway Timeout (HTTP Status Code: 504)
	SubStatus *LocalizableString `json:"subStatus,omitempty" azure:"ro"`

	// READ-ONLY; the timestamp of when the event became available for querying via this API. It is in ISO 8601 format. This value
	// should not be confused eventTimestamp. As there might be a delay between the occurrence
	// time of the event, and the time that the event is submitted to the Azure logging infrastructure.
	SubmissionTimestamp *time.Time `json:"submissionTimestamp,omitempty" azure:"ro"`

	// READ-ONLY; the Azure subscription Id usually a GUID.
	SubscriptionID *string `json:"subscriptionId,omitempty" azure:"ro"`

	// READ-ONLY; the Azure tenant Id
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

// EventDataCollection - Represents collection of events.
type EventDataCollection struct {
	// REQUIRED; this list that includes the Azure audit logs.
	Value []*EventData `json:"value,omitempty"`

	// Provides the link to retrieve the next set of events.
	NextLink *string `json:"nextLink,omitempty"`
}

// EventHubReceiver - An Event hub receiver.
type EventHubReceiver struct {
	// REQUIRED; The name of the specific Event Hub queue
	EventHubName *string `json:"eventHubName,omitempty"`

	// REQUIRED; The Event Hub namespace
	EventHubNameSpace *string `json:"eventHubNameSpace,omitempty"`

	// REQUIRED; The name of the Event hub receiver. Names must be unique across all receivers within an action group.
	Name *string `json:"name,omitempty"`

	// REQUIRED; The Id for the subscription containing this event hub
	SubscriptionID *string `json:"subscriptionId,omitempty"`

	// The tenant Id for the subscription containing this event hub
	TenantID *string `json:"tenantId,omitempty"`

	// Indicates whether to use common alert schema.
	UseCommonAlertSchema *bool `json:"useCommonAlertSchema,omitempty"`
}

// ExtensionDataSource - Definition of which data will be collected from a separate VM extension that integrates with the
// Azure Monitor Agent. Collected from either Windows and Linux machines, depending on which extension is
// defined.
type ExtensionDataSource struct {
	// REQUIRED; The name of the VM extension.
	ExtensionName *string `json:"extensionName,omitempty"`

	// The extension settings. The format is specific for particular extension.
	ExtensionSettings interface{} `json:"extensionSettings,omitempty"`

	// The list of data sources this extension needs data from.
	InputDataSources []*string `json:"inputDataSources,omitempty"`

	// A friendly name for the data source. This name should be unique across all data sources (regardless of type) within the
	// data collection rule.
	Name *string `json:"name,omitempty"`

	// List of streams that this data source will be sent to. A stream indicates what schema will be used for this data and usually
	// what table in Log Analytics the data will be sent to.
	Streams []*KnownExtensionDataSourceStreams `json:"streams,omitempty"`
}

// HTTPRequestInfo - The Http request info.
type HTTPRequestInfo struct {
	// the client Ip Address
	ClientIPAddress *string `json:"clientIpAddress,omitempty"`

	// the client request id.
	ClientRequestID *string `json:"clientRequestId,omitempty"`

	// the Http request method.
	Method *string `json:"method,omitempty"`

	// the Uri.
	URI *string `json:"uri,omitempty"`
}

// IisLogsDataSource - Enables IIS logs to be collected by this data collection rule.
type IisLogsDataSource struct {
	// REQUIRED; IIS streams
	Streams []*string `json:"streams,omitempty"`

	// Absolute paths file location
	LogDirectories []*string `json:"logDirectories,omitempty"`

	// A friendly name for the data source. This name should be unique across all data sources (regardless of type) within the
	// data collection rule.
	Name *string `json:"name,omitempty"`
}

// Incident - An alert incident indicates the activation status of an alert rule.
type Incident struct {
	// READ-ONLY; The time at which the incident was activated in ISO8601 format.
	ActivatedTime *time.Time `json:"activatedTime,omitempty" azure:"ro"`

	// READ-ONLY; A boolean to indicate whether the incident is active or resolved.
	IsActive *bool `json:"isActive,omitempty" azure:"ro"`

	// READ-ONLY; Incident name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The time at which the incident was resolved in ISO8601 format. If null, it means the incident is still active.
	ResolvedTime *time.Time `json:"resolvedTime,omitempty" azure:"ro"`

	// READ-ONLY; Rule name that is associated with the incident.
	RuleName *string `json:"ruleName,omitempty" azure:"ro"`
}

// IncidentListResult - The List incidents operation response.
type IncidentListResult struct {
	// the incident collection.
	Value []*Incident `json:"value,omitempty"`
}

// ItsmReceiver - An Itsm receiver.
type ItsmReceiver struct {
	// REQUIRED; Unique identification of ITSM connection among multiple defined in above workspace.
	ConnectionID *string `json:"connectionId,omitempty"`

	// REQUIRED; The name of the Itsm receiver. Names must be unique across all receivers within an action group.
	Name *string `json:"name,omitempty"`

	// REQUIRED; Region in which workspace resides. Supported values:'centralindia','japaneast','southeastasia','australiasoutheast','uksouth','westcentralus','canadacentral','eastus','westeurope'
	Region *string `json:"region,omitempty"`

	// REQUIRED; JSON blob for the configurations of the ITSM action. CreateMultipleWorkItems option will be part of this blob
	// as well.
	TicketConfiguration *string `json:"ticketConfiguration,omitempty"`

	// REQUIRED; OMS LA instance identifier.
	WorkspaceID *string `json:"workspaceId,omitempty"`
}

// LocalizableString - The localizable string class.
type LocalizableString struct {
	// REQUIRED; the invariant value.
	Value *string `json:"value,omitempty"`

	// the locale specific value.
	LocalizedValue *string `json:"localizedValue,omitempty"`
}

// LocationThresholdRuleCondition - A rule condition based on a certain number of locations failing.
type LocationThresholdRuleCondition struct {
	// REQUIRED; the number of locations that must fail to activate the alert.
	FailedLocationCount *int32 `json:"failedLocationCount,omitempty"`

	// REQUIRED; specifies the type of condition. This can be one of three types: ManagementEventRuleCondition (occurrences of
	// management events), LocationThresholdRuleCondition (based on the number of failures of a
	// web test), and ThresholdRuleCondition (based on the threshold of a metric).
	ODataType *string `json:"odata.type,omitempty"`

	// the resource from which the rule collects its data. For this type dataSource will always be of type RuleMetricDataSource.
	DataSource RuleDataSourceClassification `json:"dataSource,omitempty"`

	// the period of time (in ISO 8601 duration format) that is used to monitor alert activity based on the threshold. If specified
	// then it must be between 5 minutes and 1 day.
	WindowSize *string `json:"windowSize,omitempty"`
}

// GetRuleCondition implements the RuleConditionClassification interface for type LocationThresholdRuleCondition.
func (l *LocationThresholdRuleCondition) GetRuleCondition() *RuleCondition {
	return &RuleCondition{
		ODataType:  l.ODataType,
		DataSource: l.DataSource,
	}
}

// LogAnalyticsDestination - Log Analytics destination.
type LogAnalyticsDestination struct {
	// A friendly name for the destination. This name should be unique across all destinations (regardless of type) within the
	// data collection rule.
	Name *string `json:"name,omitempty"`

	// The resource ID of the Log Analytics workspace.
	WorkspaceResourceID *string `json:"workspaceResourceId,omitempty"`

	// READ-ONLY; The Customer ID of the Log Analytics workspace.
	WorkspaceID *string `json:"workspaceId,omitempty" azure:"ro"`
}

// LogFileSettings - Settings for different log file formats
type LogFileSettings struct {
	// Text settings
	Text *LogFileSettingsText `json:"text,omitempty"`
}

// LogFileSettingsText - Text settings
type LogFileSettingsText struct {
	// REQUIRED; One of the supported timestamp formats
	RecordStartTimestampFormat *KnownLogFileTextSettingsRecordStartTimestampFormat `json:"recordStartTimestampFormat,omitempty"`
}

// LogFileTextSettings - Settings for text log files
type LogFileTextSettings struct {
	// REQUIRED; One of the supported timestamp formats
	RecordStartTimestampFormat *KnownLogFileTextSettingsRecordStartTimestampFormat `json:"recordStartTimestampFormat,omitempty"`
}

// LogFilesDataSource - Definition of which custom log files will be collected by this data collection rule
type LogFilesDataSource struct {
	// REQUIRED; File Patterns where the log files are located
	FilePatterns []*string `json:"filePatterns,omitempty"`

	// REQUIRED; The data format of the log files
	Format *KnownLogFilesDataSourceFormat `json:"format,omitempty"`

	// REQUIRED; List of streams that this data source will be sent to. A stream indicates what schema will be used for this data
	// source
	Streams []*string `json:"streams,omitempty"`

	// A friendly name for the data source. This name should be unique across all data sources (regardless of type) within the
	// data collection rule.
	Name *string `json:"name,omitempty"`

	// The log files specific settings.
	Settings *LogFilesDataSourceSettings `json:"settings,omitempty"`
}

// LogFilesDataSourceSettings - The log files specific settings.
type LogFilesDataSourceSettings struct {
	// Text settings
	Text *LogFileSettingsText `json:"text,omitempty"`
}

// LogProfileCollection - Represents a collection of log profiles.
type LogProfileCollection struct {
	// REQUIRED; the values of the log profiles.
	Value []*LogProfileResource `json:"value,omitempty"`
}

// LogProfileProperties - The log profile properties.
type LogProfileProperties struct {
	// REQUIRED; the categories of the logs. These categories are created as is convenient to the user. Some values are: 'Write',
	// 'Delete', and/or 'Action.'
	Categories []*string `json:"categories,omitempty"`

	// REQUIRED; List of regions for which Activity Log events should be stored or streamed. It is a comma separated list of valid
	// ARM locations including the 'global' location.
	Locations []*string `json:"locations,omitempty"`

	// REQUIRED; the retention policy for the events in the log.
	RetentionPolicy *RetentionPolicy `json:"retentionPolicy,omitempty"`

	// The service bus rule ID of the service bus namespace in which you would like to have Event Hubs created for streaming the
	// Activity Log. The rule ID is of the format: '{service bus resource
	// ID}/authorizationrules/{key name}'.
	ServiceBusRuleID *string `json:"serviceBusRuleId,omitempty"`

	// the resource id of the storage account to which you would like to send the Activity Log.
	StorageAccountID *string `json:"storageAccountId,omitempty"`
}

// LogProfileResource - The log profile resource.
type LogProfileResource struct {
	// REQUIRED; Resource location
	Location *string `json:"location,omitempty"`

	// REQUIRED; The log profile properties of the resource.
	Properties *LogProfileProperties `json:"properties,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// LogProfileResourcePatch - The log profile resource for patch operations.
type LogProfileResourcePatch struct {
	// The log profile properties for an update operation.
	Properties *LogProfileProperties `json:"properties,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`
}

// LogProfilesClientCreateOrUpdateOptions contains the optional parameters for the LogProfilesClient.CreateOrUpdate method.
type LogProfilesClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// LogProfilesClientDeleteOptions contains the optional parameters for the LogProfilesClient.Delete method.
type LogProfilesClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// LogProfilesClientGetOptions contains the optional parameters for the LogProfilesClient.Get method.
type LogProfilesClientGetOptions struct {
	// placeholder for future optional parameters
}

// LogProfilesClientListOptions contains the optional parameters for the LogProfilesClient.List method.
type LogProfilesClientListOptions struct {
	// placeholder for future optional parameters
}

// LogProfilesClientUpdateOptions contains the optional parameters for the LogProfilesClient.Update method.
type LogProfilesClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// LogSettings - Part of MultiTenantDiagnosticSettings. Specifies the settings for a particular log.
type LogSettings struct {
	// REQUIRED; a value indicating whether this log is enabled.
	Enabled *bool `json:"enabled,omitempty"`

	// Name of a Diagnostic Log category for a resource type this setting is applied to. To obtain the list of Diagnostic Log
	// categories for a resource, first perform a GET diagnostic settings operation.
	Category *string `json:"category,omitempty"`

	// Name of a Diagnostic Log category group for a resource type this setting is applied to. To obtain the list of Diagnostic
	// Log categories for a resource, first perform a GET diagnostic settings
	// operation.
	CategoryGroup *string `json:"categoryGroup,omitempty"`

	// the retention policy for this log.
	RetentionPolicy *RetentionPolicy `json:"retentionPolicy,omitempty"`
}

// LogicAppReceiver - A logic app receiver.
type LogicAppReceiver struct {
	// REQUIRED; The callback url where http request sent to.
	CallbackURL *string `json:"callbackUrl,omitempty"`

	// REQUIRED; The name of the logic app receiver. Names must be unique across all receivers within an action group.
	Name *string `json:"name,omitempty"`

	// REQUIRED; The azure resource id of the logic app receiver.
	ResourceID *string `json:"resourceId,omitempty"`

	// Indicates whether to use common alert schema.
	UseCommonAlertSchema *bool `json:"useCommonAlertSchema,omitempty"`
}

// LogsIngestionEndpointSpec - Definition of the endpoint used for ingesting logs.
type LogsIngestionEndpointSpec struct {
	// READ-ONLY; The endpoint. This property is READ-ONLY.
	Endpoint *string `json:"endpoint,omitempty" azure:"ro"`
}

// ManagementEventAggregationCondition - How the data that is collected should be combined over time.
type ManagementEventAggregationCondition struct {
	// the condition operator.
	Operator *ConditionOperator `json:"operator,omitempty"`

	// The threshold value that activates the alert.
	Threshold *float64 `json:"threshold,omitempty"`

	// the period of time (in ISO 8601 duration format) that is used to monitor alert activity based on the threshold. If specified
	// then it must be between 5 minutes and 1 day.
	WindowSize *string `json:"windowSize,omitempty"`
}

// ManagementEventRuleCondition - A management event rule condition.
type ManagementEventRuleCondition struct {
	// REQUIRED; specifies the type of condition. This can be one of three types: ManagementEventRuleCondition (occurrences of
	// management events), LocationThresholdRuleCondition (based on the number of failures of a
	// web test), and ThresholdRuleCondition (based on the threshold of a metric).
	ODataType *string `json:"odata.type,omitempty"`

	// How the data that is collected should be combined over time and when the alert is activated. Note that for management event
	// alerts aggregation is optional – if it is not provided then any event will
	// cause the alert to activate.
	Aggregation *ManagementEventAggregationCondition `json:"aggregation,omitempty"`

	// the resource from which the rule collects its data. For this type dataSource will always be of type RuleMetricDataSource.
	DataSource RuleDataSourceClassification `json:"dataSource,omitempty"`
}

// GetRuleCondition implements the RuleConditionClassification interface for type ManagementEventRuleCondition.
func (m *ManagementEventRuleCondition) GetRuleCondition() *RuleCondition {
	return &RuleCondition{
		ODataType:  m.ODataType,
		DataSource: m.DataSource,
	}
}

// Metadata about the resource
type Metadata struct {
	// READ-ONLY; Azure offering managing this resource on-behalf-of customer.
	ProvisionedBy *string `json:"provisionedBy,omitempty" azure:"ro"`
}

// MetadataValue - Represents a metric metadata value.
type MetadataValue struct {
	// the name of the metadata.
	Name *LocalizableString `json:"name,omitempty"`

	// the value of the metadata.
	Value *string `json:"value,omitempty"`
}

// Metric - The result data of a query.
type Metric struct {
	// REQUIRED; the metric Id.
	ID *string `json:"id,omitempty"`

	// REQUIRED; the name and the display name of the metric, i.e. it is localizable string.
	Name *LocalizableString `json:"name,omitempty"`

	// REQUIRED; the time series returned when a data query is performed.
	Timeseries []*TimeSeriesElement `json:"timeseries,omitempty"`

	// REQUIRED; the resource type of the metric resource.
	Type *string `json:"type,omitempty"`

	// REQUIRED; The unit of the metric.
	Unit *MetricUnit `json:"unit,omitempty"`

	// Detailed description of this metric.
	DisplayDescription *string `json:"displayDescription,omitempty"`

	// 'Success' or the error details on query failures for this metric.
	ErrorCode *string `json:"errorCode,omitempty"`

	// Error message encountered querying this specific metric.
	ErrorMessage *string `json:"errorMessage,omitempty"`
}

// MetricAlertAction - An alert action.
type MetricAlertAction struct {
	// the id of the action group to use.
	ActionGroupID *string `json:"actionGroupId,omitempty"`

	// This field allows specifying custom properties, which would be appended to the alert payload sent as input to the webhook.
	WebHookProperties map[string]*string `json:"webHookProperties,omitempty"`
}

// MetricAlertCriteriaClassification provides polymorphic access to related types.
// Call the interface's GetMetricAlertCriteria() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *MetricAlertCriteria, *MetricAlertMultipleResourceMultipleMetricCriteria, *MetricAlertSingleResourceMultipleMetricCriteria,
// - *WebtestLocationAvailabilityCriteria
type MetricAlertCriteriaClassification interface {
	// GetMetricAlertCriteria returns the MetricAlertCriteria content of the underlying type.
	GetMetricAlertCriteria() *MetricAlertCriteria
}

// MetricAlertCriteria - The rule criteria that defines the conditions of the alert rule.
type MetricAlertCriteria struct {
	// REQUIRED; specifies the type of the alert criteria.
	ODataType *Odatatype `json:"odata.type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}
}

// GetMetricAlertCriteria implements the MetricAlertCriteriaClassification interface for type MetricAlertCriteria.
func (m *MetricAlertCriteria) GetMetricAlertCriteria() *MetricAlertCriteria { return m }

// MetricAlertMultipleResourceMultipleMetricCriteria - Specifies the metric alert criteria for multiple resource that has
// multiple metric criteria.
type MetricAlertMultipleResourceMultipleMetricCriteria struct {
	// REQUIRED; specifies the type of the alert criteria.
	ODataType *Odatatype `json:"odata.type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// the list of multiple metric criteria for this 'all of' operation.
	AllOf []MultiMetricCriteriaClassification `json:"allOf,omitempty"`
}

// GetMetricAlertCriteria implements the MetricAlertCriteriaClassification interface for type MetricAlertMultipleResourceMultipleMetricCriteria.
func (m *MetricAlertMultipleResourceMultipleMetricCriteria) GetMetricAlertCriteria() *MetricAlertCriteria {
	return &MetricAlertCriteria{
		ODataType:            m.ODataType,
		AdditionalProperties: m.AdditionalProperties,
	}
}

// MetricAlertProperties - An alert rule.
type MetricAlertProperties struct {
	// REQUIRED; defines the specific alert criteria information.
	Criteria MetricAlertCriteriaClassification `json:"criteria,omitempty"`

	// REQUIRED; the flag that indicates whether the metric alert is enabled.
	Enabled *bool `json:"enabled,omitempty"`

	// REQUIRED; how often the metric alert is evaluated represented in ISO 8601 duration format.
	EvaluationFrequency *string `json:"evaluationFrequency,omitempty"`

	// REQUIRED; the list of resource id's that this metric alert is scoped to.
	Scopes []*string `json:"scopes,omitempty"`

	// REQUIRED; Alert severity {0, 1, 2, 3, 4}
	Severity *int32 `json:"severity,omitempty"`

	// REQUIRED; the period of time (in ISO 8601 duration format) that is used to monitor alert activity based on the threshold.
	WindowSize *string `json:"windowSize,omitempty"`

	// the array of actions that are performed when the alert rule becomes active, and when an alert condition is resolved.
	Actions []*MetricAlertAction `json:"actions,omitempty"`

	// the flag that indicates whether the alert should be auto resolved or not. The default is true.
	AutoMitigate *bool `json:"autoMitigate,omitempty"`

	// the description of the metric alert that will be included in the alert email.
	Description *string `json:"description,omitempty"`

	// the region of the target resource(s) on which the alert is created/updated. Mandatory if the scope contains a subscription,
	// resource group, or more than one resource.
	TargetResourceRegion *string `json:"targetResourceRegion,omitempty"`

	// the resource type of the target resource(s) on which the alert is created/updated. Mandatory if the scope contains a subscription,
	// resource group, or more than one resource.
	TargetResourceType *string `json:"targetResourceType,omitempty"`

	// READ-ONLY; the value indicating whether this alert rule is migrated.
	IsMigrated *bool `json:"isMigrated,omitempty" azure:"ro"`

	// READ-ONLY; Last time the rule was updated in ISO8601 format.
	LastUpdatedTime *time.Time `json:"lastUpdatedTime,omitempty" azure:"ro"`
}

// MetricAlertPropertiesPatch - An alert rule properties for patch.
type MetricAlertPropertiesPatch struct {
	// the array of actions that are performed when the alert rule becomes active, and when an alert condition is resolved.
	Actions []*MetricAlertAction `json:"actions,omitempty"`

	// the flag that indicates whether the alert should be auto resolved or not. The default is true.
	AutoMitigate *bool `json:"autoMitigate,omitempty"`

	// defines the specific alert criteria information.
	Criteria MetricAlertCriteriaClassification `json:"criteria,omitempty"`

	// the description of the metric alert that will be included in the alert email.
	Description *string `json:"description,omitempty"`

	// the flag that indicates whether the metric alert is enabled.
	Enabled *bool `json:"enabled,omitempty"`

	// how often the metric alert is evaluated represented in ISO 8601 duration format.
	EvaluationFrequency *string `json:"evaluationFrequency,omitempty"`

	// the list of resource id's that this metric alert is scoped to.
	Scopes []*string `json:"scopes,omitempty"`

	// Alert severity {0, 1, 2, 3, 4}
	Severity *int32 `json:"severity,omitempty"`

	// the region of the target resource(s) on which the alert is created/updated. Mandatory for MultipleResourceMultipleMetricCriteria.
	TargetResourceRegion *string `json:"targetResourceRegion,omitempty"`

	// the resource type of the target resource(s) on which the alert is created/updated. Mandatory for MultipleResourceMultipleMetricCriteria.
	TargetResourceType *string `json:"targetResourceType,omitempty"`

	// the period of time (in ISO 8601 duration format) that is used to monitor alert activity based on the threshold.
	WindowSize *string `json:"windowSize,omitempty"`

	// READ-ONLY; the value indicating whether this alert rule is migrated.
	IsMigrated *bool `json:"isMigrated,omitempty" azure:"ro"`

	// READ-ONLY; Last time the rule was updated in ISO8601 format.
	LastUpdatedTime *time.Time `json:"lastUpdatedTime,omitempty" azure:"ro"`
}

// MetricAlertResource - The metric alert resource.
type MetricAlertResource struct {
	// REQUIRED; Resource location
	Location *string `json:"location,omitempty"`

	// REQUIRED; The alert rule properties of the resource.
	Properties *MetricAlertProperties `json:"properties,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// MetricAlertResourceCollection - Represents a collection of alert rule resources.
type MetricAlertResourceCollection struct {
	// the values for the alert rule resources.
	Value []*MetricAlertResource `json:"value,omitempty"`
}

// MetricAlertResourcePatch - The metric alert resource for patch operations.
type MetricAlertResourcePatch struct {
	// The alert rule properties of the resource.
	Properties *MetricAlertPropertiesPatch `json:"properties,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`
}

// MetricAlertSingleResourceMultipleMetricCriteria - Specifies the metric alert criteria for a single resource that has multiple
// metric criteria.
type MetricAlertSingleResourceMultipleMetricCriteria struct {
	// REQUIRED; specifies the type of the alert criteria.
	ODataType *Odatatype `json:"odata.type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// The list of metric criteria for this 'all of' operation.
	AllOf []*MetricCriteria `json:"allOf,omitempty"`
}

// GetMetricAlertCriteria implements the MetricAlertCriteriaClassification interface for type MetricAlertSingleResourceMultipleMetricCriteria.
func (m *MetricAlertSingleResourceMultipleMetricCriteria) GetMetricAlertCriteria() *MetricAlertCriteria {
	return &MetricAlertCriteria{
		ODataType:            m.ODataType,
		AdditionalProperties: m.AdditionalProperties,
	}
}

// MetricAlertStatus - An alert status.
type MetricAlertStatus struct {
	// The alert rule arm id.
	ID *string `json:"id,omitempty"`

	// The status name.
	Name *string `json:"name,omitempty"`

	// The alert status properties of the metric alert status.
	Properties *MetricAlertStatusProperties `json:"properties,omitempty"`

	// The extended resource type name.
	Type *string `json:"type,omitempty"`
}

// MetricAlertStatusCollection - Represents a collection of alert rule resources.
type MetricAlertStatusCollection struct {
	// the values for the alert rule resources.
	Value []*MetricAlertStatus `json:"value,omitempty"`
}

// MetricAlertStatusProperties - An alert status properties.
type MetricAlertStatusProperties struct {
	// An object describing the type of the dimensions.
	Dimensions map[string]*string `json:"dimensions,omitempty"`

	// status value
	Status *string `json:"status,omitempty"`

	// UTC time when the status was checked.
	Timestamp *time.Time `json:"timestamp,omitempty"`
}

// MetricAlertsClientCreateOrUpdateOptions contains the optional parameters for the MetricAlertsClient.CreateOrUpdate method.
type MetricAlertsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// MetricAlertsClientDeleteOptions contains the optional parameters for the MetricAlertsClient.Delete method.
type MetricAlertsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// MetricAlertsClientGetOptions contains the optional parameters for the MetricAlertsClient.Get method.
type MetricAlertsClientGetOptions struct {
	// placeholder for future optional parameters
}

// MetricAlertsClientListByResourceGroupOptions contains the optional parameters for the MetricAlertsClient.ListByResourceGroup
// method.
type MetricAlertsClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// MetricAlertsClientListBySubscriptionOptions contains the optional parameters for the MetricAlertsClient.ListBySubscription
// method.
type MetricAlertsClientListBySubscriptionOptions struct {
	// placeholder for future optional parameters
}

// MetricAlertsClientUpdateOptions contains the optional parameters for the MetricAlertsClient.Update method.
type MetricAlertsClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// MetricAlertsStatusClientListByNameOptions contains the optional parameters for the MetricAlertsStatusClient.ListByName
// method.
type MetricAlertsStatusClientListByNameOptions struct {
	// placeholder for future optional parameters
}

// MetricAlertsStatusClientListOptions contains the optional parameters for the MetricAlertsStatusClient.List method.
type MetricAlertsStatusClientListOptions struct {
	// placeholder for future optional parameters
}

// MetricAvailability - Metric availability specifies the time grain (aggregation interval or frequency) and the retention
// period for that time grain.
type MetricAvailability struct {
	// the retention period for the metric at the specified timegrain. Expressed as a duration 'PT1M', 'P1D', etc.
	Retention *string `json:"retention,omitempty"`

	// the time grain specifies the aggregation interval for the metric. Expressed as a duration 'PT1M', 'P1D', etc.
	TimeGrain *string `json:"timeGrain,omitempty"`
}

// MetricBaselinesProperties - The response to a metric baselines query.
type MetricBaselinesProperties struct {
	// REQUIRED; The baseline for each time series that was queried.
	Baselines []*TimeSeriesBaseline `json:"baselines,omitempty"`

	// REQUIRED; The interval (window size) for which the metric data was returned in. This may be adjusted in the future and
	// returned back from what was originally requested. This is not present if a metadata request
	// was made.
	Interval *string `json:"interval,omitempty"`

	// REQUIRED; The timespan for which the data was retrieved. Its value consists of two datetimes concatenated, separated by
	// '/'. This may be adjusted in the future and returned back from what was originally
	// requested.
	Timespan *string `json:"timespan,omitempty"`

	// The namespace of the metrics been queried.
	Namespace *string `json:"namespace,omitempty"`
}

// MetricBaselinesResponse - A list of metric baselines.
type MetricBaselinesResponse struct {
	// The list of metric baselines.
	Value []*SingleMetricBaseline `json:"value,omitempty"`
}

// MetricCriteria - Criterion to filter metrics.
type MetricCriteria struct {
	// REQUIRED; Specifies the type of threshold criteria
	CriterionType *CriterionType `json:"criterionType,omitempty"`

	// REQUIRED; Name of the metric.
	MetricName *string `json:"metricName,omitempty"`

	// REQUIRED; Name of the criteria.
	Name *string `json:"name,omitempty"`

	// REQUIRED; the criteria operator.
	Operator *Operator `json:"operator,omitempty"`

	// REQUIRED; the criteria threshold value that activates the alert.
	Threshold *float64 `json:"threshold,omitempty"`

	// REQUIRED; the criteria time aggregation types.
	TimeAggregation *AggregationTypeEnum `json:"timeAggregation,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of dimension conditions.
	Dimensions []*MetricDimension `json:"dimensions,omitempty"`

	// Namespace of the metric.
	MetricNamespace *string `json:"metricNamespace,omitempty"`

	// Allows creating an alert rule on a custom metric that isn't yet emitted, by causing the metric validation to be skipped.
	SkipMetricValidation *bool `json:"skipMetricValidation,omitempty"`
}

// GetMultiMetricCriteria implements the MultiMetricCriteriaClassification interface for type MetricCriteria.
func (m *MetricCriteria) GetMultiMetricCriteria() *MultiMetricCriteria {
	return &MultiMetricCriteria{
		CriterionType:        m.CriterionType,
		Name:                 m.Name,
		MetricName:           m.MetricName,
		MetricNamespace:      m.MetricNamespace,
		TimeAggregation:      m.TimeAggregation,
		Dimensions:           m.Dimensions,
		SkipMetricValidation: m.SkipMetricValidation,
		AdditionalProperties: m.AdditionalProperties,
	}
}

// MetricDefinition - Metric definition class specifies the metadata for a metric.
type MetricDefinition struct {
	// Custom category name for this metric.
	Category *string `json:"category,omitempty"`

	// the name and the display name of the dimension, i.e. it is a localizable string.
	Dimensions []*LocalizableString `json:"dimensions,omitempty"`

	// Detailed description of this metric.
	DisplayDescription *string `json:"displayDescription,omitempty"`

	// the resource identifier of the metric definition.
	ID *string `json:"id,omitempty"`

	// Flag to indicate whether the dimension is required.
	IsDimensionRequired *bool `json:"isDimensionRequired,omitempty"`

	// the collection of what aggregation intervals are available to be queried.
	MetricAvailabilities []*MetricAvailability `json:"metricAvailabilities,omitempty"`

	// The class of the metric.
	MetricClass *MetricClass `json:"metricClass,omitempty"`

	// the name and the display name of the metric, i.e. it is a localizable string.
	Name *LocalizableString `json:"name,omitempty"`

	// the namespace the metric belongs to.
	Namespace *string `json:"namespace,omitempty"`

	// the primary aggregation type value defining how to use the values for display.
	PrimaryAggregationType *AggregationType `json:"primaryAggregationType,omitempty"`

	// the resource identifier of the resource that emitted the metric.
	ResourceID *string `json:"resourceId,omitempty"`

	// the collection of what aggregation types are supported.
	SupportedAggregationTypes []*AggregationType `json:"supportedAggregationTypes,omitempty"`

	// The unit of the metric.
	Unit *MetricUnit `json:"unit,omitempty"`
}

// MetricDefinitionCollection - Represents collection of metric definitions.
type MetricDefinitionCollection struct {
	// REQUIRED; the values for the metric definitions.
	Value []*MetricDefinition `json:"value,omitempty"`
}

// MetricDefinitionsClientListOptions contains the optional parameters for the MetricDefinitionsClient.List method.
type MetricDefinitionsClientListOptions struct {
	// Metric namespace to query metric definitions for.
	Metricnamespace *string
}

// MetricDimension - Specifies a metric dimension.
type MetricDimension struct {
	// REQUIRED; Name of the dimension.
	Name *string `json:"name,omitempty"`

	// REQUIRED; the dimension operator. Only 'Include' and 'Exclude' are supported
	Operator *string `json:"operator,omitempty"`

	// REQUIRED; list of dimension values.
	Values []*string `json:"values,omitempty"`
}

// MetricNamespace - Metric namespace class specifies the metadata for a metric namespace.
type MetricNamespace struct {
	// Kind of namespace
	Classification *NamespaceClassification `json:"classification,omitempty"`

	// The ID of the metric namespace.
	ID *string `json:"id,omitempty"`

	// The escaped name of the namespace.
	Name *string `json:"name,omitempty"`

	// Properties which include the fully qualified namespace name.
	Properties *MetricNamespaceName `json:"properties,omitempty"`

	// The type of the namespace.
	Type *string `json:"type,omitempty"`
}

// MetricNamespaceCollection - Represents collection of metric namespaces.
type MetricNamespaceCollection struct {
	// REQUIRED; The values for the metric namespaces.
	Value []*MetricNamespace `json:"value,omitempty"`
}

// MetricNamespaceName - The fully qualified metric namespace name.
type MetricNamespaceName struct {
	// The metric namespace name.
	MetricNamespaceName *string `json:"metricNamespaceName,omitempty"`
}

// MetricNamespacesClientListOptions contains the optional parameters for the MetricNamespacesClient.List method.
type MetricNamespacesClientListOptions struct {
	// The ISO 8601 conform Date start time from which to query for metric namespaces.
	StartTime *string
}

// MetricSettings - Part of MultiTenantDiagnosticSettings. Specifies the settings for a particular metric.
type MetricSettings struct {
	// REQUIRED; a value indicating whether this category is enabled.
	Enabled *bool `json:"enabled,omitempty"`

	// Name of a Diagnostic Metric category for a resource type this setting is applied to. To obtain the list of Diagnostic metric
	// categories for a resource, first perform a GET diagnostic settings
	// operation.
	Category *string `json:"category,omitempty"`

	// the retention policy for this category.
	RetentionPolicy *RetentionPolicy `json:"retentionPolicy,omitempty"`

	// the timegrain of the metric in ISO8601 format.
	TimeGrain *string `json:"timeGrain,omitempty"`
}

// MetricSingleDimension - The metric dimension name and value.
type MetricSingleDimension struct {
	// REQUIRED; Name of the dimension.
	Name *string `json:"name,omitempty"`

	// REQUIRED; Value of the dimension.
	Value *string `json:"value,omitempty"`
}

// MetricTrigger - The trigger that results in a scaling action.
type MetricTrigger struct {
	// REQUIRED; the name of the metric that defines what the rule monitors.
	MetricName *string `json:"metricName,omitempty"`

	// REQUIRED; the resource identifier of the resource the rule monitors.
	MetricResourceURI *string `json:"metricResourceUri,omitempty"`

	// REQUIRED; the operator that is used to compare the metric data and the threshold.
	Operator *ComparisonOperationType `json:"operator,omitempty"`

	// REQUIRED; the metric statistic type. How the metrics from multiple instances are combined.
	Statistic *MetricStatisticType `json:"statistic,omitempty"`

	// REQUIRED; the threshold of the metric that triggers the scale action.
	Threshold *float64 `json:"threshold,omitempty"`

	// REQUIRED; time aggregation type. How the data that is collected should be combined over time. The default value is Average.
	TimeAggregation *TimeAggregationType `json:"timeAggregation,omitempty"`

	// REQUIRED; the granularity of metrics the rule monitors. Must be one of the predefined values returned from metric definitions
	// for the metric. Must be between 12 hours and 1 minute.
	TimeGrain *string `json:"timeGrain,omitempty"`

	// REQUIRED; the range of time in which instance data is collected. This value must be greater than the delay in metric collection,
	// which can vary from resource-to-resource. Must be between 12 hours and 5 minutes.
	TimeWindow *string `json:"timeWindow,omitempty"`

	// List of dimension conditions. For example: [{"DimensionName":"AppName","Operator":"Equals","Values":["App1"]},{"DimensionName":"Deployment","Operator":"Equals","Values":["default"]}].
	Dimensions []*ScaleRuleMetricDimension `json:"dimensions,omitempty"`

	// a value indicating whether metric should divide per instance.
	DividePerInstance *bool `json:"dividePerInstance,omitempty"`

	// the namespace of the metric that defines what the rule monitors.
	MetricNamespace *string `json:"metricNamespace,omitempty"`

	// the location of the resource the rule monitors.
	MetricResourceLocation *string `json:"metricResourceLocation,omitempty"`
}

// MetricValue - Represents a metric value.
type MetricValue struct {
	// REQUIRED; the timestamp for the metric value in ISO 8601 format.
	TimeStamp *time.Time `json:"timeStamp,omitempty"`

	// the average value in the time range.
	Average *float64 `json:"average,omitempty"`

	// the number of samples in the time range. Can be used to determine the number of values that contributed to the average
	// value.
	Count *float64 `json:"count,omitempty"`

	// the greatest value in the time range.
	Maximum *float64 `json:"maximum,omitempty"`

	// the least value in the time range.
	Minimum *float64 `json:"minimum,omitempty"`

	// the sum of all of the values in the time range.
	Total *float64 `json:"total,omitempty"`
}

// MetricsClientListOptions contains the optional parameters for the MetricsClient.List method.
type MetricsClientListOptions struct {
	// The list of aggregation types (comma separated) to retrieve.
	Aggregation *string
	// The $filter is used to reduce the set of metric data returned. Example: Metric contains metadata A, B and C. - Return all
	// time series of C where A = a1 and B = b1 or b2 $filter=A eq 'a1' and B eq 'b1'
	// or B eq 'b2' and C eq '' - Invalid variant: $filter=A eq 'a1' and B eq 'b1' and C eq '' or B = 'b2' This is invalid because
	// the logical or operator cannot separate two different metadata names. -
	// Return all time series where A = a1, B = b1 and C = c1: $filter=A eq 'a1' and B eq 'b1' and C eq 'c1' - Return all time
	// series where A = a1 $filter=A eq 'a1' and B eq '' and C eq ''. Special case:
	// When dimension name or dimension value uses round brackets. Eg: When dimension name is dim (test) 1 Instead of using $filter=
	// "dim (test) 1 eq '' " use $filter= "dim %2528test%2529 1 eq '' " When
	// dimension name is dim (test) 3 and dimension value is dim3 (test) val Instead of using $filter= "dim (test) 3 eq 'dim3
	// (test) val' " use $filter= "dim %2528test%2529 3 eq 'dim3 %2528test%2529 val' "
	Filter *string
	// The interval (i.e. timegrain) of the query.
	Interval *string
	// The names of the metrics (comma separated) to retrieve. Special case: If a metricname itself has a comma in it then use
	// %2 to indicate it. Eg: 'Metric,Name1' should be 'Metric%2Name1'
	Metricnames *string
	// Metric namespace to query metric definitions for.
	Metricnamespace *string
	// The aggregation to use for sorting results and the direction of the sort. Only one order can be specified. Examples: sum
	// asc.
	Orderby *string
	// Reduces the set of data collected. The syntax allowed depends on the operation. See the operation's description for details.
	ResultType *ResultType
	// The timespan of the query. It is a string with the following format 'startDateTimeISO/endDateTimeISO'.
	Timespan *string
	// The maximum number of records to retrieve. Valid only if $filter is specified. Defaults to 10.
	Top *int32
}

// MultiMetricCriteriaClassification provides polymorphic access to related types.
// Call the interface's GetMultiMetricCriteria() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *DynamicMetricCriteria, *MetricCriteria, *MultiMetricCriteria
type MultiMetricCriteriaClassification interface {
	// GetMultiMetricCriteria returns the MultiMetricCriteria content of the underlying type.
	GetMultiMetricCriteria() *MultiMetricCriteria
}

// MultiMetricCriteria - The types of conditions for a multi resource alert.
type MultiMetricCriteria struct {
	// REQUIRED; Specifies the type of threshold criteria
	CriterionType *CriterionType `json:"criterionType,omitempty"`

	// REQUIRED; Name of the metric.
	MetricName *string `json:"metricName,omitempty"`

	// REQUIRED; Name of the criteria.
	Name *string `json:"name,omitempty"`

	// REQUIRED; the criteria time aggregation types.
	TimeAggregation *AggregationTypeEnum `json:"timeAggregation,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of dimension conditions.
	Dimensions []*MetricDimension `json:"dimensions,omitempty"`

	// Namespace of the metric.
	MetricNamespace *string `json:"metricNamespace,omitempty"`

	// Allows creating an alert rule on a custom metric that isn't yet emitted, by causing the metric validation to be skipped.
	SkipMetricValidation *bool `json:"skipMetricValidation,omitempty"`
}

// GetMultiMetricCriteria implements the MultiMetricCriteriaClassification interface for type MultiMetricCriteria.
func (m *MultiMetricCriteria) GetMultiMetricCriteria() *MultiMetricCriteria { return m }

// NetworkRuleSet - Definition of the network rules.
type NetworkRuleSet struct {
	// The configuration to set whether network access from public internet to the endpoints are allowed.
	PublicNetworkAccess *KnownPublicNetworkAccessOptions `json:"publicNetworkAccess,omitempty"`
}

// NotificationRequestBody - The request body which contain contact detail metadata
type NotificationRequestBody struct {
	// REQUIRED; The value of the supported alert type. Supported alert type values are: servicehealth, metricstaticthreshold,
	// metricsdynamicthreshold, logalertv2, smartalert, webtestalert, logalertv1numresult,
	// logalertv1metricmeasurement, resourcehealth, activitylog, budget
	AlertType *string `json:"alertType,omitempty"`

	// The list of ARM role receivers that are part of this action group. Roles are Azure RBAC roles and only built-in roles are
	// supported.
	ArmRoleReceivers []*ArmRoleReceiver `json:"armRoleReceivers,omitempty"`

	// The list of AutomationRunbook receivers that are part of this action group.
	AutomationRunbookReceivers []*AutomationRunbookReceiver `json:"automationRunbookReceivers,omitempty"`

	// The list of AzureAppPush receivers that are part of this action group.
	AzureAppPushReceivers []*AzureAppPushReceiver `json:"azureAppPushReceivers,omitempty"`

	// The list of azure function receivers that are part of this action group.
	AzureFunctionReceivers []*AzureFunctionReceiver `json:"azureFunctionReceivers,omitempty"`

	// The list of email receivers that are part of this action group.
	EmailReceivers []*EmailReceiver `json:"emailReceivers,omitempty"`

	// The list of event hub receivers that are part of this action group.
	EventHubReceivers []*EventHubReceiver `json:"eventHubReceivers,omitempty"`

	// The list of ITSM receivers that are part of this action group.
	ItsmReceivers []*ItsmReceiver `json:"itsmReceivers,omitempty"`

	// The list of logic app receivers that are part of this action group.
	LogicAppReceivers []*LogicAppReceiver `json:"logicAppReceivers,omitempty"`

	// The list of SMS receivers that are part of this action group.
	SmsReceivers []*SmsReceiver `json:"smsReceivers,omitempty"`

	// The list of voice receivers that are part of this action group.
	VoiceReceivers []*VoiceReceiver `json:"voiceReceivers,omitempty"`

	// The list of webhook receivers that are part of this action group.
	WebhookReceivers []*WebhookReceiver `json:"webhookReceivers,omitempty"`
}

// Operation - Microsoft Insights API operation definition.
type Operation struct {
	// Display metadata associated with the operation.
	Display *OperationDisplay `json:"display,omitempty"`

	// Operation name: {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`
}

// OperationDisplay - Display metadata associated with the operation.
type OperationDisplay struct {
	// Operation type: Read, write, delete, etc.
	Operation *string `json:"operation,omitempty"`

	// Service provider: Microsoft.Insights
	Provider *string `json:"provider,omitempty"`

	// Resource on which the operation is performed: AlertRules, Autoscale, etc.
	Resource *string `json:"resource,omitempty"`
}

// OperationListResult - Result of the request to list Microsoft.Insights operations. It contains a list of operations and
// a URL link to get the next set of results.
type OperationListResult struct {
	// URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`

	// List of operations supported by the Microsoft.Insights provider.
	Value []*Operation `json:"value,omitempty"`
}

// OperationStatus - The status of operation.
type OperationStatus struct {
	// End time of the job in standard ISO8601 format.
	EndTime *time.Time `json:"endTime,omitempty"`

	// The error detail of the operation if any.
	Error *ErrorDetail `json:"error,omitempty"`

	// The operation Id.
	ID *string `json:"id,omitempty"`

	// The operation name.
	Name *string `json:"name,omitempty"`

	// Start time of the job in standard ISO8601 format.
	StartTime *time.Time `json:"startTime,omitempty"`

	// The status of the operation.
	Status *string `json:"status,omitempty"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// PerfCounterDataSource - Definition of which performance counters will be collected and how they will be collected by this
// data collection rule. Collected from both Windows and Linux machines where the counter is present.
type PerfCounterDataSource struct {
	// A list of specifier names of the performance counters you want to collect. Use a wildcard (*) to collect a counter for
	// all instances. To get a list of performance counters on Windows, run the command
	// 'typeperf'.
	CounterSpecifiers []*string `json:"counterSpecifiers,omitempty"`

	// A friendly name for the data source. This name should be unique across all data sources (regardless of type) within the
	// data collection rule.
	Name *string `json:"name,omitempty"`

	// The number of seconds between consecutive counter measurements (samples).
	SamplingFrequencyInSeconds *int32 `json:"samplingFrequencyInSeconds,omitempty"`

	// List of streams that this data source will be sent to. A stream indicates what schema will be used for this data and usually
	// what table in Log Analytics the data will be sent to.
	Streams []*KnownPerfCounterDataSourceStreams `json:"streams,omitempty"`
}

// PredictiveAutoscalePolicy - The parameters for enabling predictive autoscale.
type PredictiveAutoscalePolicy struct {
	// REQUIRED; the predictive autoscale mode
	ScaleMode *PredictiveAutoscalePolicyScaleMode `json:"scaleMode,omitempty"`

	// the amount of time to specify by which instances are launched in advance. It must be between 1 minute and 60 minutes in
	// ISO 8601 format.
	ScaleLookAheadTime *string `json:"scaleLookAheadTime,omitempty"`
}

// PredictiveMetricClientGetOptions contains the optional parameters for the PredictiveMetricClient.Get method.
type PredictiveMetricClientGetOptions struct {
	// placeholder for future optional parameters
}

// PredictiveResponse - The response to a metrics query.
type PredictiveResponse struct {
	// the value of the collection.
	Data []*PredictiveValue `json:"data,omitempty"`

	// The interval (window size) for which the metric data was returned in. This may be adjusted in the future and returned back
	// from what was originally requested. This is not present if a metadata request
	// was made.
	Interval *string `json:"interval,omitempty"`

	// The metrics being queried
	MetricName *string `json:"metricName,omitempty"`

	// resource of the predictive metric.
	TargetResourceID *string `json:"targetResourceId,omitempty"`

	// The timespan for which the data was retrieved. Its value consists of two datetimes concatenated, separated by '/'. This
	// may be adjusted in the future and returned back from what was originally
	// requested.
	Timespan *string `json:"timespan,omitempty"`
}

// PredictiveValue - Represents a predictive metric value in the given bucket.
type PredictiveValue struct {
	// REQUIRED; the timestamp for the metric value in ISO 8601 format.
	TimeStamp *time.Time `json:"timeStamp,omitempty"`

	// REQUIRED; Predictive value in this time bucket.
	Value *float64 `json:"value,omitempty"`
}

// PrivateEndpoint - The Private Endpoint resource.
type PrivateEndpoint struct {
	// READ-ONLY; The ARM identifier for Private Endpoint
	ID *string `json:"id,omitempty" azure:"ro"`
}

// PrivateEndpointConnection - The Private Endpoint Connection resource.
type PrivateEndpointConnection struct {
	// Resource properties.
	Properties *PrivateEndpointConnectionProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PrivateEndpointConnectionListResult - List of private endpoint connection associated with the specified storage account
type PrivateEndpointConnectionListResult struct {
	// Array of private endpoint connections
	Value []*PrivateEndpointConnection `json:"value,omitempty"`
}

// PrivateEndpointConnectionProperties - Properties of the PrivateEndpointConnectProperties.
type PrivateEndpointConnectionProperties struct {
	// REQUIRED; A collection of information about the state of the connection between service consumer and provider.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionState `json:"privateLinkServiceConnectionState,omitempty"`

	// The resource of private end point.
	PrivateEndpoint *PrivateEndpoint `json:"privateEndpoint,omitempty"`

	// READ-ONLY; The provisioning state of the private endpoint connection resource.
	ProvisioningState *PrivateEndpointConnectionProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// PrivateEndpointConnectionsClientBeginCreateOrUpdateOptions contains the optional parameters for the PrivateEndpointConnectionsClient.BeginCreateOrUpdate
// method.
type PrivateEndpointConnectionsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateEndpointConnectionsClientBeginDeleteOptions contains the optional parameters for the PrivateEndpointConnectionsClient.BeginDelete
// method.
type PrivateEndpointConnectionsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateEndpointConnectionsClientGetOptions contains the optional parameters for the PrivateEndpointConnectionsClient.Get
// method.
type PrivateEndpointConnectionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnectionsClientListByPrivateLinkScopeOptions contains the optional parameters for the PrivateEndpointConnectionsClient.ListByPrivateLinkScope
// method.
type PrivateEndpointConnectionsClientListByPrivateLinkScopeOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkResource - A private link resource
type PrivateLinkResource struct {
	// Resource properties.
	Properties *PrivateLinkResourceProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PrivateLinkResourceListResult - A list of private link resources
type PrivateLinkResourceListResult struct {
	// Array of private link resources
	Value []*PrivateLinkResource `json:"value,omitempty"`
}

// PrivateLinkResourceProperties - Properties of a private link resource.
type PrivateLinkResourceProperties struct {
	// The private link resource Private link DNS zone name.
	RequiredZoneNames []*string `json:"requiredZoneNames,omitempty"`

	// READ-ONLY; The private link resource group id.
	GroupID *string `json:"groupId,omitempty" azure:"ro"`

	// READ-ONLY; The private link resource required member names.
	RequiredMembers []*string `json:"requiredMembers,omitempty" azure:"ro"`
}

// PrivateLinkResourcesClientGetOptions contains the optional parameters for the PrivateLinkResourcesClient.Get method.
type PrivateLinkResourcesClientGetOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkResourcesClientListByPrivateLinkScopeOptions contains the optional parameters for the PrivateLinkResourcesClient.ListByPrivateLinkScope
// method.
type PrivateLinkResourcesClientListByPrivateLinkScopeOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkScopeOperationStatusClientGetOptions contains the optional parameters for the PrivateLinkScopeOperationStatusClient.Get
// method.
type PrivateLinkScopeOperationStatusClientGetOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkScopedResourcesClientBeginCreateOrUpdateOptions contains the optional parameters for the PrivateLinkScopedResourcesClient.BeginCreateOrUpdate
// method.
type PrivateLinkScopedResourcesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateLinkScopedResourcesClientBeginDeleteOptions contains the optional parameters for the PrivateLinkScopedResourcesClient.BeginDelete
// method.
type PrivateLinkScopedResourcesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateLinkScopedResourcesClientGetOptions contains the optional parameters for the PrivateLinkScopedResourcesClient.Get
// method.
type PrivateLinkScopedResourcesClientGetOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkScopedResourcesClientListByPrivateLinkScopeOptions contains the optional parameters for the PrivateLinkScopedResourcesClient.ListByPrivateLinkScope
// method.
type PrivateLinkScopedResourcesClientListByPrivateLinkScopeOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkScopesClientBeginDeleteOptions contains the optional parameters for the PrivateLinkScopesClient.BeginDelete
// method.
type PrivateLinkScopesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateLinkScopesClientCreateOrUpdateOptions contains the optional parameters for the PrivateLinkScopesClient.CreateOrUpdate
// method.
type PrivateLinkScopesClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkScopesClientGetOptions contains the optional parameters for the PrivateLinkScopesClient.Get method.
type PrivateLinkScopesClientGetOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkScopesClientListByResourceGroupOptions contains the optional parameters for the PrivateLinkScopesClient.ListByResourceGroup
// method.
type PrivateLinkScopesClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkScopesClientListOptions contains the optional parameters for the PrivateLinkScopesClient.List method.
type PrivateLinkScopesClientListOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkScopesClientUpdateTagsOptions contains the optional parameters for the PrivateLinkScopesClient.UpdateTags method.
type PrivateLinkScopesClientUpdateTagsOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkServiceConnectionState - A collection of information about the state of the connection between service consumer
// and provider.
type PrivateLinkServiceConnectionState struct {
	// A message indicating if changes on the service provider require any updates on the consumer.
	ActionsRequired *string `json:"actionsRequired,omitempty"`

	// The reason for approval/rejection of the connection.
	Description *string `json:"description,omitempty"`

	// Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
	Status *PrivateEndpointServiceConnectionStatus `json:"status,omitempty"`
}

// ProxyResource - An azure resource object
type ProxyResource struct {
	// READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ProxyResourceAutoGenerated - The resource model definition for a Azure Resource Manager proxy resource. It will not have
// tags and a location
type ProxyResourceAutoGenerated struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// Recurrence - The repeating times at which this profile begins. This element is not used if the FixedDate element is used.
type Recurrence struct {
	// REQUIRED; the recurrence frequency. How often the schedule profile should take effect. This value must be Week, meaning
	// each week will have the same set of profiles. For example, to set a daily schedule, set
	// schedule to every day of the week. The frequency property specifies that the schedule is repeated weekly.
	Frequency *RecurrenceFrequency `json:"frequency,omitempty"`

	// REQUIRED; the scheduling constraints for when the profile begins.
	Schedule *RecurrentSchedule `json:"schedule,omitempty"`
}

// RecurrentSchedule - The scheduling constraints for when the profile begins.
type RecurrentSchedule struct {
	// REQUIRED; the collection of days that the profile takes effect on. Possible values are Sunday through Saturday.
	Days []*string `json:"days,omitempty"`

	// REQUIRED; A collection of hours that the profile takes effect on. Values supported are 0 to 23 on the 24-hour clock (AM/PM
	// times are not supported).
	Hours []*int32 `json:"hours,omitempty"`

	// REQUIRED; A collection of minutes at which the profile takes effect at.
	Minutes []*int32 `json:"minutes,omitempty"`

	// REQUIRED; the timezone for the hours of the profile. Some examples of valid time zones are: Dateline Standard Time, UTC-11,
	// Hawaiian Standard Time, Alaskan Standard Time, Pacific Standard Time (Mexico), Pacific
	// Standard Time, US Mountain Standard Time, Mountain Standard Time (Mexico), Mountain Standard Time, Central America Standard
	// Time, Central Standard Time, Central Standard Time (Mexico), Canada Central
	// Standard Time, SA Pacific Standard Time, Eastern Standard Time, US Eastern Standard Time, Venezuela Standard Time, Paraguay
	// Standard Time, Atlantic Standard Time, Central Brazilian Standard Time, SA
	// Western Standard Time, Pacific SA Standard Time, Newfoundland Standard Time, E. South America Standard Time, Argentina
	// Standard Time, SA Eastern Standard Time, Greenland Standard Time, Montevideo
	// Standard Time, Bahia Standard Time, UTC-02, Mid-Atlantic Standard Time, Azores Standard Time, Cape Verde Standard Time,
	// Morocco Standard Time, UTC, GMT Standard Time, Greenwich Standard Time, W.
	// Europe Standard Time, Central Europe Standard Time, Romance Standard Time, Central European Standard Time, W. Central Africa
	// Standard Time, Namibia Standard Time, Jordan Standard Time, GTB Standard
	// Time, Middle East Standard Time, Egypt Standard Time, Syria Standard Time, E. Europe Standard Time, South Africa Standard
	// Time, FLE Standard Time, Turkey Standard Time, Israel Standard Time,
	// Kaliningrad Standard Time, Libya Standard Time, Arabic Standard Time, Arab Standard Time, Belarus Standard Time, Russian
	// Standard Time, E. Africa Standard Time, Iran Standard Time, Arabian Standard
	// Time, Azerbaijan Standard Time, Russia Time Zone 3, Mauritius Standard Time, Georgian Standard Time, Caucasus Standard
	// Time, Afghanistan Standard Time, West Asia Standard Time, Ekaterinburg Standard
	// Time, Pakistan Standard Time, India Standard Time, Sri Lanka Standard Time, Nepal Standard Time, Central Asia Standard
	// Time, Bangladesh Standard Time, N. Central Asia Standard Time, Myanmar Standard
	// Time, SE Asia Standard Time, North Asia Standard Time, China Standard Time, North Asia East Standard Time, Singapore Standard
	// Time, W. Australia Standard Time, Taipei Standard Time, Ulaanbaatar
	// Standard Time, Tokyo Standard Time, Korea Standard Time, Yakutsk Standard Time, Cen. Australia Standard Time, AUS Central
	// Standard Time, E. Australia Standard Time, AUS Eastern Standard Time, West
	// Pacific Standard Time, Tasmania Standard Time, Magadan Standard Time, Vladivostok Standard Time, Russia Time Zone 10, Central
	// Pacific Standard Time, Russia Time Zone 11, New Zealand Standard Time,
	// UTC+12, Fiji Standard Time, Kamchatka Standard Time, Tonga Standard Time, Samoa Standard Time, Line Islands Standard Time
	TimeZone *string `json:"timeZone,omitempty"`
}

// Resource - The autoscale setting resource.
type Resource struct {
	// REQUIRED; Resource location
	Location *string `json:"location,omitempty"`

	// Gets or sets a list of key value pairs that describe the resource. These tags can be used in viewing and grouping this
	// resource (across resource groups). A maximum of 15 tags can be provided for a
	// resource. Each tag must have a key no greater in length than 128 characters and a value no greater in length than 256 characters.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system metadata related to the response.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ResourceAutoGenerated - An azure resource object
type ResourceAutoGenerated struct {
	// REQUIRED; Resource location
	Location *string `json:"location,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ResourceAutoGenerated2 - An azure resource object
type ResourceAutoGenerated2 struct {
	// REQUIRED; Resource location
	Location *string `json:"location,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ResourceAutoGenerated3 - Common fields that are returned in the response for all Azure Resource Manager resources
type ResourceAutoGenerated3 struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ResourceAutoGenerated4 - An azure resource object
type ResourceAutoGenerated4 struct {
	// REQUIRED; Resource location
	Location *string `json:"location,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ResourceForUpdate - Definition of ARM tracked top level resource properties for update operation.
type ResourceForUpdate struct {
	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`
}

// Response - The response to a metrics query.
type Response struct {
	// REQUIRED; The timespan for which the data was retrieved. Its value consists of two datetimes concatenated, separated by
	// '/'. This may be adjusted in the future and returned back from what was originally
	// requested.
	Timespan *string `json:"timespan,omitempty"`

	// REQUIRED; the value of the collection.
	Value []*Metric `json:"value,omitempty"`

	// The integer value representing the relative cost of the query.
	Cost *int32 `json:"cost,omitempty"`

	// The interval (window size) for which the metric data was returned in. This may be adjusted in the future and returned back
	// from what was originally requested. This is not present if a metadata request
	// was made.
	Interval *string `json:"interval,omitempty"`

	// The namespace of the metrics being queried
	Namespace *string `json:"namespace,omitempty"`

	// The region of the resource being queried for metrics.
	Resourceregion *string `json:"resourceregion,omitempty"`
}

// ResponseWithError - An error response from the API.
type ResponseWithError struct {
	// REQUIRED; Error information.
	Error *Error `json:"error,omitempty"`
}

// RetentionPolicy - Specifies the retention policy for the log.
type RetentionPolicy struct {
	// REQUIRED; the number of days for the retention in days. A value of 0 will retain the events indefinitely.
	Days *int32 `json:"days,omitempty"`

	// REQUIRED; a value indicating whether the retention policy is enabled.
	Enabled *bool `json:"enabled,omitempty"`
}

// RuleActionClassification provides polymorphic access to related types.
// Call the interface's GetRuleAction() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *RuleAction, *RuleEmailAction, *RuleWebhookAction
type RuleActionClassification interface {
	// GetRuleAction returns the RuleAction content of the underlying type.
	GetRuleAction() *RuleAction
}

// RuleAction - The action that is performed when the alert rule becomes active, and when an alert condition is resolved.
type RuleAction struct {
	// REQUIRED; specifies the type of the action. There are two types of actions: RuleEmailAction and RuleWebhookAction.
	ODataType *string `json:"odata.type,omitempty"`
}

// GetRuleAction implements the RuleActionClassification interface for type RuleAction.
func (r *RuleAction) GetRuleAction() *RuleAction { return r }

// RuleConditionClassification provides polymorphic access to related types.
// Call the interface's GetRuleCondition() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *LocationThresholdRuleCondition, *ManagementEventRuleCondition, *RuleCondition, *ThresholdRuleCondition
type RuleConditionClassification interface {
	// GetRuleCondition returns the RuleCondition content of the underlying type.
	GetRuleCondition() *RuleCondition
}

// RuleCondition - The condition that results in the alert rule being activated.
type RuleCondition struct {
	// REQUIRED; specifies the type of condition. This can be one of three types: ManagementEventRuleCondition (occurrences of
	// management events), LocationThresholdRuleCondition (based on the number of failures of a
	// web test), and ThresholdRuleCondition (based on the threshold of a metric).
	ODataType *string `json:"odata.type,omitempty"`

	// the resource from which the rule collects its data. For this type dataSource will always be of type RuleMetricDataSource.
	DataSource RuleDataSourceClassification `json:"dataSource,omitempty"`
}

// GetRuleCondition implements the RuleConditionClassification interface for type RuleCondition.
func (r *RuleCondition) GetRuleCondition() *RuleCondition { return r }

// RuleDataSourceClassification provides polymorphic access to related types.
// Call the interface's GetRuleDataSource() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *RuleDataSource, *RuleManagementEventDataSource, *RuleMetricDataSource
type RuleDataSourceClassification interface {
	// GetRuleDataSource returns the RuleDataSource content of the underlying type.
	GetRuleDataSource() *RuleDataSource
}

// RuleDataSource - The resource from which the rule collects its data.
type RuleDataSource struct {
	// REQUIRED; specifies the type of data source. There are two types of rule data sources: RuleMetricDataSource and RuleManagementEventDataSource
	ODataType *string `json:"odata.type,omitempty"`

	// the legacy resource identifier of the resource the rule monitors. NOTE: this property cannot be updated for an existing
	// rule.
	LegacyResourceID *string `json:"legacyResourceId,omitempty"`

	// the namespace of the metric.
	MetricNamespace *string `json:"metricNamespace,omitempty"`

	// the location of the resource.
	ResourceLocation *string `json:"resourceLocation,omitempty"`

	// the resource identifier of the resource the rule monitors. NOTE: this property cannot be updated for an existing rule.
	ResourceURI *string `json:"resourceUri,omitempty"`
}

// GetRuleDataSource implements the RuleDataSourceClassification interface for type RuleDataSource.
func (r *RuleDataSource) GetRuleDataSource() *RuleDataSource { return r }

// RuleEmailAction - Specifies the action to send email when the rule condition is evaluated. The discriminator is always
// RuleEmailAction in this case.
type RuleEmailAction struct {
	// REQUIRED; specifies the type of the action. There are two types of actions: RuleEmailAction and RuleWebhookAction.
	ODataType *string `json:"odata.type,omitempty"`

	// the list of administrator's custom email addresses to notify of the activation of the alert.
	CustomEmails []*string `json:"customEmails,omitempty"`

	// Whether the administrators (service and co-administrators) of the service should be notified when the alert is activated.
	SendToServiceOwners *bool `json:"sendToServiceOwners,omitempty"`
}

// GetRuleAction implements the RuleActionClassification interface for type RuleEmailAction.
func (r *RuleEmailAction) GetRuleAction() *RuleAction {
	return &RuleAction{
		ODataType: r.ODataType,
	}
}

// RuleManagementEventClaimsDataSource - The claims for a rule management event data source.
type RuleManagementEventClaimsDataSource struct {
	// the email address.
	EmailAddress *string `json:"emailAddress,omitempty"`
}

// RuleManagementEventDataSource - A rule management event data source. The discriminator fields is always RuleManagementEventDataSource
// in this case.
type RuleManagementEventDataSource struct {
	// REQUIRED; specifies the type of data source. There are two types of rule data sources: RuleMetricDataSource and RuleManagementEventDataSource
	ODataType *string `json:"odata.type,omitempty"`

	// the claims.
	Claims *RuleManagementEventClaimsDataSource `json:"claims,omitempty"`

	// the event name.
	EventName *string `json:"eventName,omitempty"`

	// the event source.
	EventSource *string `json:"eventSource,omitempty"`

	// the legacy resource identifier of the resource the rule monitors. NOTE: this property cannot be updated for an existing
	// rule.
	LegacyResourceID *string `json:"legacyResourceId,omitempty"`

	// the level.
	Level *string `json:"level,omitempty"`

	// the namespace of the metric.
	MetricNamespace *string `json:"metricNamespace,omitempty"`

	// The name of the operation that should be checked for. If no name is provided, any operation will match.
	OperationName *string `json:"operationName,omitempty"`

	// the resource group name.
	ResourceGroupName *string `json:"resourceGroupName,omitempty"`

	// the location of the resource.
	ResourceLocation *string `json:"resourceLocation,omitempty"`

	// the resource provider name.
	ResourceProviderName *string `json:"resourceProviderName,omitempty"`

	// the resource identifier of the resource the rule monitors. NOTE: this property cannot be updated for an existing rule.
	ResourceURI *string `json:"resourceUri,omitempty"`

	// The status of the operation that should be checked for. If no status is provided, any status will match.
	Status *string `json:"status,omitempty"`

	// the substatus.
	SubStatus *string `json:"subStatus,omitempty"`
}

// GetRuleDataSource implements the RuleDataSourceClassification interface for type RuleManagementEventDataSource.
func (r *RuleManagementEventDataSource) GetRuleDataSource() *RuleDataSource {
	return &RuleDataSource{
		ODataType:        r.ODataType,
		ResourceURI:      r.ResourceURI,
		LegacyResourceID: r.LegacyResourceID,
		ResourceLocation: r.ResourceLocation,
		MetricNamespace:  r.MetricNamespace,
	}
}

// RuleMetricDataSource - A rule metric data source. The discriminator value is always RuleMetricDataSource in this case.
type RuleMetricDataSource struct {
	// REQUIRED; specifies the type of data source. There are two types of rule data sources: RuleMetricDataSource and RuleManagementEventDataSource
	ODataType *string `json:"odata.type,omitempty"`

	// the legacy resource identifier of the resource the rule monitors. NOTE: this property cannot be updated for an existing
	// rule.
	LegacyResourceID *string `json:"legacyResourceId,omitempty"`

	// the name of the metric that defines what the rule monitors.
	MetricName *string `json:"metricName,omitempty"`

	// the namespace of the metric.
	MetricNamespace *string `json:"metricNamespace,omitempty"`

	// the location of the resource.
	ResourceLocation *string `json:"resourceLocation,omitempty"`

	// the resource identifier of the resource the rule monitors. NOTE: this property cannot be updated for an existing rule.
	ResourceURI *string `json:"resourceUri,omitempty"`
}

// GetRuleDataSource implements the RuleDataSourceClassification interface for type RuleMetricDataSource.
func (r *RuleMetricDataSource) GetRuleDataSource() *RuleDataSource {
	return &RuleDataSource{
		ODataType:        r.ODataType,
		ResourceURI:      r.ResourceURI,
		LegacyResourceID: r.LegacyResourceID,
		ResourceLocation: r.ResourceLocation,
		MetricNamespace:  r.MetricNamespace,
	}
}

// RuleWebhookAction - Specifies the action to post to service when the rule condition is evaluated. The discriminator is
// always RuleWebhookAction in this case.
type RuleWebhookAction struct {
	// REQUIRED; specifies the type of the action. There are two types of actions: RuleEmailAction and RuleWebhookAction.
	ODataType *string `json:"odata.type,omitempty"`

	// the dictionary of custom properties to include with the post operation. These data are appended to the webhook payload.
	Properties map[string]*string `json:"properties,omitempty"`

	// the service uri to Post the notification when the alert activates or resolves.
	ServiceURI *string `json:"serviceUri,omitempty"`
}

// GetRuleAction implements the RuleActionClassification interface for type RuleWebhookAction.
func (r *RuleWebhookAction) GetRuleAction() *RuleAction {
	return &RuleAction{
		ODataType: r.ODataType,
	}
}

// ScaleAction - The parameters for the scaling action.
type ScaleAction struct {
	// REQUIRED; the amount of time to wait since the last scaling action before this action occurs. It must be between 1 week
	// and 1 minute in ISO 8601 format.
	Cooldown *string `json:"cooldown,omitempty"`

	// REQUIRED; the scale direction. Whether the scaling action increases or decreases the number of instances.
	Direction *ScaleDirection `json:"direction,omitempty"`

	// REQUIRED; the type of action that should occur when the scale rule fires.
	Type *ScaleType `json:"type,omitempty"`

	// the number of instances that are involved in the scaling action. This value must be 1 or greater. The default value is
	// 1.
	Value *string `json:"value,omitempty"`
}

// ScaleCapacity - The number of instances that can be used during this profile.
type ScaleCapacity struct {
	// REQUIRED; the number of instances that will be set if metrics are not available for evaluation. The default is only used
	// if the current instance count is lower than the default.
	Default *string `json:"default,omitempty"`

	// REQUIRED; the maximum number of instances for the resource. The actual maximum number of instances is limited by the cores
	// that are available in the subscription.
	Maximum *string `json:"maximum,omitempty"`

	// REQUIRED; the minimum number of instances for the resource.
	Minimum *string `json:"minimum,omitempty"`
}

// ScaleRule - A rule that provide the triggers and parameters for the scaling action.
type ScaleRule struct {
	// REQUIRED; the trigger that results in a scaling action.
	MetricTrigger *MetricTrigger `json:"metricTrigger,omitempty"`

	// REQUIRED; the parameters for the scaling action.
	ScaleAction *ScaleAction `json:"scaleAction,omitempty"`
}

// ScaleRuleMetricDimension - Specifies an auto scale rule metric dimension.
type ScaleRuleMetricDimension struct {
	// REQUIRED; Name of the dimension.
	DimensionName *string `json:"DimensionName,omitempty"`

	// REQUIRED; the dimension operator. Only 'Equals' and 'NotEquals' are supported. 'Equals' being equal to any of the values.
	// 'NotEquals' being not equal to all of the values
	Operator *ScaleRuleMetricDimensionOperationType `json:"Operator,omitempty"`

	// REQUIRED; list of dimension values. For example: ["App1","App2"].
	Values []*string `json:"Values,omitempty"`
}

// ScheduledQueryRuleCriteria - The rule criteria that defines the conditions of the scheduled query rule.
type ScheduledQueryRuleCriteria struct {
	// A list of conditions to evaluate against the specified scopes
	AllOf []*Condition `json:"allOf,omitempty"`
}

// ScheduledQueryRuleProperties - scheduled query rule Definition
type ScheduledQueryRuleProperties struct {
	// Actions to invoke when the alert fires.
	Actions *Actions `json:"actions,omitempty"`

	// The flag that indicates whether the alert should be automatically resolved or not. The default is true. Relevant only for
	// rules of the kind LogAlert.
	AutoMitigate *bool `json:"autoMitigate,omitempty"`

	// The flag which indicates whether this scheduled query rule should be stored in the customer's storage. The default is false.
	// Relevant only for rules of the kind LogAlert.
	CheckWorkspaceAlertsStorageConfigured *bool `json:"checkWorkspaceAlertsStorageConfigured,omitempty"`

	// The rule criteria that defines the conditions of the scheduled query rule.
	Criteria *ScheduledQueryRuleCriteria `json:"criteria,omitempty"`

	// The description of the scheduled query rule.
	Description *string `json:"description,omitempty"`

	// The display name of the alert rule
	DisplayName *string `json:"displayName,omitempty"`

	// The flag which indicates whether this scheduled query rule is enabled. Value should be true or false
	Enabled *bool `json:"enabled,omitempty"`

	// How often the scheduled query rule is evaluated represented in ISO 8601 duration format. Relevant and required only for
	// rules of the kind LogAlert.
	EvaluationFrequency *string `json:"evaluationFrequency,omitempty"`

	// Mute actions for the chosen period of time (in ISO 8601 duration format) after the alert is fired. Relevant only for rules
	// of the kind LogAlert.
	MuteActionsDuration *string `json:"muteActionsDuration,omitempty"`

	// If specified then overrides the query time range (default is WindowSize*NumberOfEvaluationPeriods). Relevant only for rules
	// of the kind LogAlert.
	OverrideQueryTimeRange *string `json:"overrideQueryTimeRange,omitempty"`

	// The list of resource id's that this scheduled query rule is scoped to.
	Scopes []*string `json:"scopes,omitempty"`

	// Severity of the alert. Should be an integer between [0-4]. Value of 0 is severest. Relevant and required only for rules
	// of the kind LogAlert.
	Severity *AlertSeverity `json:"severity,omitempty"`

	// The flag which indicates whether the provided query should be validated or not. The default is false. Relevant only for
	// rules of the kind LogAlert.
	SkipQueryValidation *bool `json:"skipQueryValidation,omitempty"`

	// List of resource type of the target resource(s) on which the alert is created/updated. For example if the scope is a resource
	// group and targetResourceTypes is Microsoft.Compute/virtualMachines, then a
	// different alert will be fired for each virtual machine in the resource group which meet the alert criteria. Relevant only
	// for rules of the kind LogAlert
	TargetResourceTypes []*string `json:"targetResourceTypes,omitempty"`

	// The period of time (in ISO 8601 duration format) on which the Alert query will be executed (bin size). Relevant and required
	// only for rules of the kind LogAlert.
	WindowSize *string `json:"windowSize,omitempty"`

	// READ-ONLY; The api-version used when creating this alert rule
	CreatedWithAPIVersion *string `json:"createdWithApiVersion,omitempty" azure:"ro"`

	// READ-ONLY; True if alert rule is legacy Log Analytic rule
	IsLegacyLogAnalyticsRule *bool `json:"isLegacyLogAnalyticsRule,omitempty" azure:"ro"`

	// READ-ONLY; The flag which indicates whether this scheduled query rule has been configured to be stored in the customer's
	// storage. The default is false.
	IsWorkspaceAlertsStorageConfigured *bool `json:"isWorkspaceAlertsStorageConfigured,omitempty" azure:"ro"`
}

// ScheduledQueryRuleResource - The scheduled query rule resource.
type ScheduledQueryRuleResource struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// REQUIRED; The rule properties of the resource.
	Properties *ScheduledQueryRuleProperties `json:"properties,omitempty"`

	// Indicates the type of scheduled query rule. The default is LogAlert.
	Kind *Kind `json:"kind,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The etag field is not required. If it is provided in the response body, it must also be provided as a header
	// per the normal etag convention. Entity tags are used for comparing two or more entities
	// from the same requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match (section 14.24), If-None-Match
	// (section 14.26), and If-Range (section 14.27) header fields.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; SystemData of ScheduledQueryRule.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ScheduledQueryRuleResourceCollection - Represents a collection of scheduled query rule resources.
type ScheduledQueryRuleResourceCollection struct {
	// The values for the scheduled query rule resources.
	Value []*ScheduledQueryRuleResource `json:"value,omitempty"`

	// READ-ONLY; Provides the link to retrieve the next set of elements.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// ScheduledQueryRuleResourcePatch - The scheduled query rule resource for patch operations.
type ScheduledQueryRuleResourcePatch struct {
	// The scheduled query rule properties of the resource.
	Properties *ScheduledQueryRuleProperties `json:"properties,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`
}

// ScheduledQueryRulesClientCreateOrUpdateOptions contains the optional parameters for the ScheduledQueryRulesClient.CreateOrUpdate
// method.
type ScheduledQueryRulesClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// ScheduledQueryRulesClientDeleteOptions contains the optional parameters for the ScheduledQueryRulesClient.Delete method.
type ScheduledQueryRulesClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ScheduledQueryRulesClientGetOptions contains the optional parameters for the ScheduledQueryRulesClient.Get method.
type ScheduledQueryRulesClientGetOptions struct {
	// placeholder for future optional parameters
}

// ScheduledQueryRulesClientListByResourceGroupOptions contains the optional parameters for the ScheduledQueryRulesClient.ListByResourceGroup
// method.
type ScheduledQueryRulesClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// ScheduledQueryRulesClientListBySubscriptionOptions contains the optional parameters for the ScheduledQueryRulesClient.ListBySubscription
// method.
type ScheduledQueryRulesClientListBySubscriptionOptions struct {
	// placeholder for future optional parameters
}

// ScheduledQueryRulesClientUpdateOptions contains the optional parameters for the ScheduledQueryRulesClient.Update method.
type ScheduledQueryRulesClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// ScopedResource - A private link scoped resource
type ScopedResource struct {
	// Resource properties.
	Properties *ScopedResourceProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; System data
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ScopedResourceListResult - A list of scoped resources in a private link scope.
type ScopedResourceListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*ScopedResource `json:"value,omitempty" azure:"ro"`
}

// ScopedResourceProperties - Properties of a private link scoped resource.
type ScopedResourceProperties struct {
	// The resource id of the scoped Azure monitor resource.
	LinkedResourceID *string `json:"linkedResourceId,omitempty"`

	// READ-ONLY; State of the private endpoint connection.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// SenderAuthorization - the authorization used by the user who has performed the operation that led to this event. This captures
// the RBAC properties of the event. These usually include the 'action', 'role' and the 'scope'
type SenderAuthorization struct {
	// the permissible actions. For instance: microsoft.support/supporttickets/write
	Action *string `json:"action,omitempty"`

	// the role of the user. For instance: Subscription Admin
	Role *string `json:"role,omitempty"`

	// the scope.
	Scope *string `json:"scope,omitempty"`
}

// SingleBaseline - The baseline values for a single sensitivity value.
type SingleBaseline struct {
	// REQUIRED; The high thresholds of the baseline.
	HighThresholds []*float64 `json:"highThresholds,omitempty"`

	// REQUIRED; The low thresholds of the baseline.
	LowThresholds []*float64 `json:"lowThresholds,omitempty"`

	// REQUIRED; the sensitivity of the baseline.
	Sensitivity *BaselineSensitivity `json:"sensitivity,omitempty"`
}

// SingleMetricBaseline - The baseline results of a single metric.
type SingleMetricBaseline struct {
	// REQUIRED; The metric baseline Id.
	ID *string `json:"id,omitempty"`

	// REQUIRED; The name of the metric for which the baselines were retrieved.
	Name *string `json:"name,omitempty"`

	// REQUIRED; The metric baseline properties of the metric.
	Properties *MetricBaselinesProperties `json:"properties,omitempty"`

	// REQUIRED; The resource type of the metric baseline resource.
	Type *string `json:"type,omitempty"`
}

// SmsReceiver - An SMS receiver.
type SmsReceiver struct {
	// REQUIRED; The country code of the SMS receiver.
	CountryCode *string `json:"countryCode,omitempty"`

	// REQUIRED; The name of the SMS receiver. Names must be unique across all receivers within an action group.
	Name *string `json:"name,omitempty"`

	// REQUIRED; The phone number of the SMS receiver.
	PhoneNumber *string `json:"phoneNumber,omitempty"`

	// READ-ONLY; The status of the receiver.
	Status *ReceiverStatus `json:"status,omitempty" azure:"ro"`
}

// StreamDeclaration - Declaration of a custom stream.
type StreamDeclaration struct {
	// List of columns used by data in this stream.
	Columns []*ColumnDefinition `json:"columns,omitempty"`
}

// SyslogDataSource - Definition of which syslog data will be collected and how it will be collected. Only collected from
// Linux machines.
type SyslogDataSource struct {
	// The list of facility names.
	FacilityNames []*KnownSyslogDataSourceFacilityNames `json:"facilityNames,omitempty"`

	// The log levels to collect.
	LogLevels []*KnownSyslogDataSourceLogLevels `json:"logLevels,omitempty"`

	// A friendly name for the data source. This name should be unique across all data sources (regardless of type) within the
	// data collection rule.
	Name *string `json:"name,omitempty"`

	// List of streams that this data source will be sent to. A stream indicates what schema will be used for this data and usually
	// what table in Log Analytics the data will be sent to.
	Streams []*KnownSyslogDataSourceStreams `json:"streams,omitempty"`
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time `json:"createdAt,omitempty"`

	// The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`

	// The type of identity that created the resource.
	CreatedByType *CreatedByType `json:"createdByType,omitempty"`

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time `json:"lastModifiedAt,omitempty"`

	// The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType `json:"lastModifiedByType,omitempty"`
}

// TagsResource - A container holding only the Tags for a resource, allowing the user to update the tags on a PrivateLinkScope
// instance.
type TagsResource struct {
	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`
}

// TenantActivityLogsClientListOptions contains the optional parameters for the TenantActivityLogsClient.List method.
type TenantActivityLogsClientListOptions struct {
	// Reduces the set of data collected.
	// The $filter is very restricted and allows only the following patterns.
	// - List events for a resource group: $filter=eventTimestamp ge '' and eventTimestamp le '' and eventChannels eq 'Admin,
	// Operation' and resourceGroupName eq ''.
	// - List events for resource: $filter=eventTimestamp ge '' and eventTimestamp le '' and eventChannels eq 'Admin, Operation'
	// and resourceUri eq ''.
	// - List events for a subscription: $filter=eventTimestamp ge '' and eventTimestamp le '' and eventChannels eq 'Admin, Operation'.
	// - List events for a resource provider: $filter=eventTimestamp ge '' and eventTimestamp le '' and eventChannels eq 'Admin,
	// Operation' and resourceProvider eq ''.
	// - List events for a correlation Id: api-version=2014-04-01&$filter=eventTimestamp ge '2014-07-16T04:36:37.6407898Z' and
	// eventTimestamp le '2014-07-20T04:36:37.6407898Z' and eventChannels eq 'Admin,
	// Operation' and correlationId eq ''.
	// NOTE: No other syntax is allowed.
	Filter *string
	// Used to fetch events with only the given properties.
	// The $select argument is a comma separated list of property names to be returned. Possible values are: authorization, claims,
	// correlationId, description, eventDataId, eventName, eventTimestamp,
	// httpRequest, level, operationId, operationName, properties, resourceGroupName, resourceProviderName, resourceId, status,
	// submissionTimestamp, subStatus, subscriptionId
	Select *string
}

// TestNotificationDetailsResponse - The details of the test notification results.
type TestNotificationDetailsResponse struct {
	// REQUIRED; The overall state
	State *string `json:"state,omitempty"`

	// The list of action detail
	ActionDetails []*ActionDetail `json:"actionDetails,omitempty"`

	// The completed time
	CompletedTime *string `json:"completedTime,omitempty"`

	// The context info
	Context *Context `json:"context,omitempty"`

	// The created time
	CreatedTime *string `json:"createdTime,omitempty"`
}

// ThresholdRuleCondition - A rule condition based on a metric crossing a threshold.
type ThresholdRuleCondition struct {
	// REQUIRED; specifies the type of condition. This can be one of three types: ManagementEventRuleCondition (occurrences of
	// management events), LocationThresholdRuleCondition (based on the number of failures of a
	// web test), and ThresholdRuleCondition (based on the threshold of a metric).
	ODataType *string `json:"odata.type,omitempty"`

	// REQUIRED; the operator used to compare the data and the threshold.
	Operator *ConditionOperator `json:"operator,omitempty"`

	// REQUIRED; the threshold value that activates the alert.
	Threshold *float64 `json:"threshold,omitempty"`

	// the resource from which the rule collects its data. For this type dataSource will always be of type RuleMetricDataSource.
	DataSource RuleDataSourceClassification `json:"dataSource,omitempty"`

	// the time aggregation operator. How the data that are collected should be combined over time. The default value is the PrimaryAggregationType
	// of the Metric.
	TimeAggregation *TimeAggregationOperator `json:"timeAggregation,omitempty"`

	// the period of time (in ISO 8601 duration format) that is used to monitor alert activity based on the threshold. If specified
	// then it must be between 5 minutes and 1 day.
	WindowSize *string `json:"windowSize,omitempty"`
}

// GetRuleCondition implements the RuleConditionClassification interface for type ThresholdRuleCondition.
func (t *ThresholdRuleCondition) GetRuleCondition() *RuleCondition {
	return &RuleCondition{
		ODataType:  t.ODataType,
		DataSource: t.DataSource,
	}
}

// TimeSeriesBaseline - The baseline values for a single time series.
type TimeSeriesBaseline struct {
	// REQUIRED; The aggregation type of the metric.
	Aggregation *string `json:"aggregation,omitempty"`

	// REQUIRED; The baseline values for each sensitivity.
	Data []*SingleBaseline `json:"data,omitempty"`

	// REQUIRED; The list of timestamps of the baselines.
	Timestamps []*time.Time `json:"timestamps,omitempty"`

	// The dimensions of this time series.
	Dimensions []*MetricSingleDimension `json:"dimensions,omitempty"`

	// The baseline metadata values.
	MetadataValues []*BaselineMetadata `json:"metadataValues,omitempty"`
}

// TimeSeriesElement - A time series result type. The discriminator value is always TimeSeries in this case.
type TimeSeriesElement struct {
	// An array of data points representing the metric values. This is only returned if a result type of data is specified.
	Data []*MetricValue `json:"data,omitempty"`

	// the metadata values returned if $filter was specified in the call.
	Metadatavalues []*MetadataValue `json:"metadatavalues,omitempty"`
}

// TimeWindow - A specific date-time for the profile.
type TimeWindow struct {
	// REQUIRED; the end time for the profile in ISO 8601 format.
	End *time.Time `json:"end,omitempty"`

	// REQUIRED; the start time for the profile in ISO 8601 format.
	Start *time.Time `json:"start,omitempty"`

	// the timezone of the start and end times for the profile. Some examples of valid time zones are: Dateline Standard Time,
	// UTC-11, Hawaiian Standard Time, Alaskan Standard Time, Pacific Standard Time
	// (Mexico), Pacific Standard Time, US Mountain Standard Time, Mountain Standard Time (Mexico), Mountain Standard Time, Central
	// America Standard Time, Central Standard Time, Central Standard Time
	// (Mexico), Canada Central Standard Time, SA Pacific Standard Time, Eastern Standard Time, US Eastern Standard Time, Venezuela
	// Standard Time, Paraguay Standard Time, Atlantic Standard Time, Central
	// Brazilian Standard Time, SA Western Standard Time, Pacific SA Standard Time, Newfoundland Standard Time, E. South America
	// Standard Time, Argentina Standard Time, SA Eastern Standard Time, Greenland
	// Standard Time, Montevideo Standard Time, Bahia Standard Time, UTC-02, Mid-Atlantic Standard Time, Azores Standard Time,
	// Cape Verde Standard Time, Morocco Standard Time, UTC, GMT Standard Time,
	// Greenwich Standard Time, W. Europe Standard Time, Central Europe Standard Time, Romance Standard Time, Central European
	// Standard Time, W. Central Africa Standard Time, Namibia Standard Time, Jordan
	// Standard Time, GTB Standard Time, Middle East Standard Time, Egypt Standard Time, Syria Standard Time, E. Europe Standard
	// Time, South Africa Standard Time, FLE Standard Time, Turkey Standard Time,
	// Israel Standard Time, Kaliningrad Standard Time, Libya Standard Time, Arabic Standard Time, Arab Standard Time, Belarus
	// Standard Time, Russian Standard Time, E. Africa Standard Time, Iran Standard
	// Time, Arabian Standard Time, Azerbaijan Standard Time, Russia Time Zone 3, Mauritius Standard Time, Georgian Standard Time,
	// Caucasus Standard Time, Afghanistan Standard Time, West Asia Standard Time,
	// Ekaterinburg Standard Time, Pakistan Standard Time, India Standard Time, Sri Lanka Standard Time, Nepal Standard Time,
	// Central Asia Standard Time, Bangladesh Standard Time, N. Central Asia Standard
	// Time, Myanmar Standard Time, SE Asia Standard Time, North Asia Standard Time, China Standard Time, North Asia East Standard
	// Time, Singapore Standard Time, W. Australia Standard Time, Taipei Standard
	// Time, Ulaanbaatar Standard Time, Tokyo Standard Time, Korea Standard Time, Yakutsk Standard Time, Cen. Australia Standard
	// Time, AUS Central Standard Time, E. Australia Standard Time, AUS Eastern
	// Standard Time, West Pacific Standard Time, Tasmania Standard Time, Magadan Standard Time, Vladivostok Standard Time, Russia
	// Time Zone 10, Central Pacific Standard Time, Russia Time Zone 11, New
	// Zealand Standard Time, UTC+12, Fiji Standard Time, Kamchatka Standard Time, Tonga Standard Time, Samoa Standard Time, Line
	// Islands Standard Time
	TimeZone *string `json:"timeZone,omitempty"`
}

// TrackedResource - The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags'
// and a 'location'
type TrackedResource struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VMInsightsClientGetOnboardingStatusOptions contains the optional parameters for the VMInsightsClient.GetOnboardingStatus
// method.
type VMInsightsClientGetOnboardingStatusOptions struct {
	// placeholder for future optional parameters
}

// VMInsightsOnboardingStatus - VM Insights onboarding status for a resource.
type VMInsightsOnboardingStatus struct {
	// Resource properties.
	Properties *VMInsightsOnboardingStatusProperties `json:"properties,omitempty"`

	// READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VMInsightsOnboardingStatusProperties - Resource properties.
type VMInsightsOnboardingStatusProperties struct {
	// REQUIRED; The status of VM Insights data from the resource. When reported as present the data array will contain information
	// about the data containers to which data for the specified resource is being routed.
	DataStatus *DataStatus `json:"dataStatus,omitempty"`

	// REQUIRED; The onboarding status for the resource. Note that, a higher level scope, e.g., resource group or subscription,
	// is considered onboarded if at least one resource under it is onboarded.
	OnboardingStatus *OnboardingStatus `json:"onboardingStatus,omitempty"`

	// REQUIRED; Azure Resource Manager identifier of the resource whose onboarding status is being represented.
	ResourceID *string `json:"resourceId,omitempty"`

	// Containers that currently store VM Insights data for the specified resource.
	Data []*DataContainer `json:"data,omitempty"`
}

// VoiceReceiver - A voice receiver.
type VoiceReceiver struct {
	// REQUIRED; The country code of the voice receiver.
	CountryCode *string `json:"countryCode,omitempty"`

	// REQUIRED; The name of the voice receiver. Names must be unique across all receivers within an action group.
	Name *string `json:"name,omitempty"`

	// REQUIRED; The phone number of the voice receiver.
	PhoneNumber *string `json:"phoneNumber,omitempty"`
}

// WebhookNotification - Webhook notification of an autoscale event.
type WebhookNotification struct {
	// a property bag of settings. This value can be empty.
	Properties map[string]*string `json:"properties,omitempty"`

	// the service address to receive the notification.
	ServiceURI *string `json:"serviceUri,omitempty"`
}

// WebhookReceiver - A webhook receiver.
type WebhookReceiver struct {
	// REQUIRED; The name of the webhook receiver. Names must be unique across all receivers within an action group.
	Name *string `json:"name,omitempty"`

	// REQUIRED; The URI where webhooks should be sent.
	ServiceURI *string `json:"serviceUri,omitempty"`

	// Indicates the identifier uri for aad auth.
	IdentifierURI *string `json:"identifierUri,omitempty"`

	// Indicates the webhook app object Id for aad auth.
	ObjectID *string `json:"objectId,omitempty"`

	// Indicates the tenant id for aad auth.
	TenantID *string `json:"tenantId,omitempty"`

	// Indicates whether or not use AAD authentication.
	UseAADAuth *bool `json:"useAadAuth,omitempty"`

	// Indicates whether to use common alert schema.
	UseCommonAlertSchema *bool `json:"useCommonAlertSchema,omitempty"`
}

// WebtestLocationAvailabilityCriteria - Specifies the metric alert rule criteria for a web test resource.
type WebtestLocationAvailabilityCriteria struct {
	// REQUIRED; The Application Insights resource Id.
	ComponentID *string `json:"componentId,omitempty"`

	// REQUIRED; The number of failed locations.
	FailedLocationCount *float32 `json:"failedLocationCount,omitempty"`

	// REQUIRED; specifies the type of the alert criteria.
	ODataType *Odatatype `json:"odata.type,omitempty"`

	// REQUIRED; The Application Insights web test Id.
	WebTestID *string `json:"webTestId,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}
}

// GetMetricAlertCriteria implements the MetricAlertCriteriaClassification interface for type WebtestLocationAvailabilityCriteria.
func (w *WebtestLocationAvailabilityCriteria) GetMetricAlertCriteria() *MetricAlertCriteria {
	return &MetricAlertCriteria{
		ODataType:            w.ODataType,
		AdditionalProperties: w.AdditionalProperties,
	}
}

// WindowsEventLogDataSource - Definition of which Windows Event Log events will be collected and how they will be collected.
// Only collected from Windows machines.
type WindowsEventLogDataSource struct {
	// A friendly name for the data source. This name should be unique across all data sources (regardless of type) within the
	// data collection rule.
	Name *string `json:"name,omitempty"`

	// List of streams that this data source will be sent to. A stream indicates what schema will be used for this data and usually
	// what table in Log Analytics the data will be sent to.
	Streams []*KnownWindowsEventLogDataSourceStreams `json:"streams,omitempty"`

	// A list of Windows Event Log queries in XPATH format.
	XPathQueries []*string `json:"xPathQueries,omitempty"`
}

// WorkspaceInfo - Information about a Log Analytics Workspace.
type WorkspaceInfo struct {
	// REQUIRED; Azure Resource Manager identifier of the Log Analytics Workspace.
	ID *string `json:"id,omitempty"`

	// REQUIRED; Location of the Log Analytics workspace.
	Location *string `json:"location,omitempty"`

	// REQUIRED; Resource properties.
	Properties *WorkspaceInfoProperties `json:"properties,omitempty"`
}

// WorkspaceInfoProperties - Resource properties.
type WorkspaceInfoProperties struct {
	// REQUIRED; Log Analytics workspace identifier.
	CustomerID *string `json:"customerId,omitempty"`
}
