//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armlogz

import "time"

// ErrorAdditionalInfo - The resource management error additional info.
type ErrorAdditionalInfo struct {
	// READ-ONLY; The additional info.
	Info interface{} `json:"info,omitempty" azure:"ro"`

	// READ-ONLY; The additional info type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ErrorDetail - The error detail.
type ErrorDetail struct {
	// READ-ONLY; The error additional info.
	AdditionalInfo []*ErrorAdditionalInfo `json:"additionalInfo,omitempty" azure:"ro"`

	// READ-ONLY; The error code.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; The error details.
	Details []*ErrorDetail `json:"details,omitempty" azure:"ro"`

	// READ-ONLY; The error message.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; The error target.
	Target *string `json:"target,omitempty" azure:"ro"`
}

// ErrorResponse - Common error response for all Azure Resource Manager APIs to return error details for failed operations.
// (This also follows the OData error response format.).
type ErrorResponse struct {
	// The error object.
	Error *ErrorDetail `json:"error,omitempty"`
}

// FilteringTag - The definition of a filtering tag. Filtering tags are used for capturing resources and include/exclude them
// from being monitored.
type FilteringTag struct {
	// Valid actions for a filtering tag. Exclusion takes priority over inclusion.
	Action *TagAction `json:"action,omitempty"`

	// The name (also known as the key) of the tag.
	Name *string `json:"name,omitempty"`

	// The value of the tag.
	Value *string `json:"value,omitempty"`
}

type IdentityProperties struct {
	Type *ManagedIdentityTypes `json:"type,omitempty"`

	// READ-ONLY; The identity ID.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`

	// READ-ONLY; The tenant ID of resource.
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

// LogRules - Set of rules for sending logs for the Monitor resource.
type LogRules struct {
	// List of filtering tags to be used for capturing logs. This only takes effect if SendActivityLogs flag is enabled. If empty,
	// all resources will be captured. If only Exclude action is specified, the
	// rules will apply to the list of all available resources. If Include actions are specified, the rules will only include
	// resources with the associated tags.
	FilteringTags []*FilteringTag `json:"filteringTags,omitempty"`

	// Flag specifying if AAD logs should be sent for the Monitor resource.
	SendAADLogs *bool `json:"sendAadLogs,omitempty"`

	// Flag specifying if activity logs from Azure resources should be sent for the Monitor resource.
	SendActivityLogs *bool `json:"sendActivityLogs,omitempty"`

	// Flag specifying if subscription logs should be sent for the Monitor resource.
	SendSubscriptionLogs *bool `json:"sendSubscriptionLogs,omitempty"`
}

// MonitorClientListVMHostUpdateOptions contains the optional parameters for the MonitorClient.ListVMHostUpdate method.
type MonitorClientListVMHostUpdateOptions struct {
	// Request body to update the collection for agent installed in the given monitor.
	Body *VMHostUpdateRequest
}

// MonitorClientListVMHostsOptions contains the optional parameters for the MonitorClient.ListVMHosts method.
type MonitorClientListVMHostsOptions struct {
	// placeholder for future optional parameters
}

// MonitorClientVMHostPayloadOptions contains the optional parameters for the MonitorClient.VMHostPayload method.
type MonitorClientVMHostPayloadOptions struct {
	// placeholder for future optional parameters
}

// MonitorProperties - Properties specific to the monitor resource.
type MonitorProperties struct {
	LogzOrganizationProperties *OrganizationProperties `json:"logzOrganizationProperties,omitempty"`

	// Flag specifying the Marketplace Subscription Status of the resource. If payment is not made in time, the resource will
	// go in Suspended state.
	MarketplaceSubscriptionStatus *MarketplaceSubscriptionStatus `json:"marketplaceSubscriptionStatus,omitempty"`

	// Flag specifying if the resource monitoring is enabled or disabled.
	MonitoringStatus *MonitoringStatus `json:"monitoringStatus,omitempty"`
	PlanData         *PlanData         `json:"planData,omitempty"`
	UserInfo         *UserInfo         `json:"userInfo,omitempty"`

	// READ-ONLY
	LiftrResourceCategory *LiftrResourceCategories `json:"liftrResourceCategory,omitempty" azure:"ro"`

	// READ-ONLY; The priority of the resource.
	LiftrResourcePreference *int32 `json:"liftrResourcePreference,omitempty" azure:"ro"`

	// READ-ONLY; Flag specifying if the resource provisioning state as tracked by ARM.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

type MonitorResource struct {
	// REQUIRED
	Location *string             `json:"location,omitempty"`
	Identity *IdentityProperties `json:"identity,omitempty"`

	// Properties specific to the monitor resource.
	Properties *MonitorProperties `json:"properties,omitempty"`

	// Dictionary of
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; ARM id of the monitor resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of the monitor resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system metadata relating to this resource
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the monitor resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// MonitorResourceListResponse - Response of a list operation.
type MonitorResourceListResponse struct {
	// Link to the next set of results, if any.
	NextLink *string `json:"nextLink,omitempty"`

	// Results of a list operation.
	Value []*MonitorResource `json:"value,omitempty"`
}

// MonitorResourceUpdateParameters - The parameters for a PATCH request to a monitor resource.
type MonitorResourceUpdateParameters struct {
	// The set of properties that can be update in a PATCH request to a monitor resource.
	Properties *MonitorUpdateProperties `json:"properties,omitempty"`

	// The new tags of the monitor resource.
	Tags map[string]*string `json:"tags,omitempty"`
}

// MonitorUpdateProperties - The set of properties that can be update in a PATCH request to a monitor resource.
type MonitorUpdateProperties struct {
	// Flag specifying if the resource monitoring is enabled or disabled.
	MonitoringStatus *MonitoringStatus `json:"monitoringStatus,omitempty"`
}

// MonitoredResource - The properties of a resource currently being monitored by the Logz monitor resource.
type MonitoredResource struct {
	// The ARM id of the resource.
	ID *string `json:"id,omitempty"`

	// Reason for why the resource is sending logs (or why it is not sending).
	ReasonForLogsStatus *string `json:"reasonForLogsStatus,omitempty"`

	// Reason for why the resource is sending metrics (or why it is not sending).
	ReasonForMetricsStatus *string `json:"reasonForMetricsStatus,omitempty"`

	// Flag indicating if resource is sending logs to Logz.
	SendingLogs *bool `json:"sendingLogs,omitempty"`

	// Flag indicating if resource is sending metrics to Logz.
	SendingMetrics *bool `json:"sendingMetrics,omitempty"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`
}

// MonitoredResourceListResponse - Response of a list operation.
type MonitoredResourceListResponse struct {
	// Link to the next set of results, if any.
	NextLink *string `json:"nextLink,omitempty"`

	// Results of a list operation.
	Value []*MonitoredResource `json:"value,omitempty"`
}

// MonitoringTagRules - Capture logs and metrics of Azure resources based on ARM tags.
type MonitoringTagRules struct {
	// Definition of the properties for a TagRules resource.
	Properties *MonitoringTagRulesProperties `json:"properties,omitempty"`

	// READ-ONLY; The id of the rule set.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of the rule set.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system metadata relating to this resource
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the rule set.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// MonitoringTagRulesListResponse - Response of a list operation.
type MonitoringTagRulesListResponse struct {
	// Link to the next set of results, if any.
	NextLink *string `json:"nextLink,omitempty"`

	// Results of a list operation.
	Value []*MonitoringTagRules `json:"value,omitempty"`
}

// MonitoringTagRulesProperties - Definition of the properties for a TagRules resource.
type MonitoringTagRulesProperties struct {
	// Set of rules for sending logs for the Monitor resource.
	LogRules *LogRules `json:"logRules,omitempty"`

	// READ-ONLY; Flag specifying if the resource provisioning state as tracked by ARM.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`
}

// MonitorsClientBeginCreateOptions contains the optional parameters for the MonitorsClient.BeginCreate method.
type MonitorsClientBeginCreateOptions struct {
	Body *MonitorResource
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// MonitorsClientBeginDeleteOptions contains the optional parameters for the MonitorsClient.BeginDelete method.
type MonitorsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// MonitorsClientGetOptions contains the optional parameters for the MonitorsClient.Get method.
type MonitorsClientGetOptions struct {
	// placeholder for future optional parameters
}

// MonitorsClientListByResourceGroupOptions contains the optional parameters for the MonitorsClient.ListByResourceGroup method.
type MonitorsClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// MonitorsClientListBySubscriptionOptions contains the optional parameters for the MonitorsClient.ListBySubscription method.
type MonitorsClientListBySubscriptionOptions struct {
	// placeholder for future optional parameters
}

// MonitorsClientListMonitoredResourcesOptions contains the optional parameters for the MonitorsClient.ListMonitoredResources
// method.
type MonitorsClientListMonitoredResourcesOptions struct {
	// placeholder for future optional parameters
}

// MonitorsClientListUserRolesOptions contains the optional parameters for the MonitorsClient.ListUserRoles method.
type MonitorsClientListUserRolesOptions struct {
	Body *UserRoleRequest
}

// MonitorsClientUpdateOptions contains the optional parameters for the MonitorsClient.Update method.
type MonitorsClientUpdateOptions struct {
	Body *MonitorResourceUpdateParameters
}

// OperationDisplay - The object that represents the operation.
type OperationDisplay struct {
	// Description of the operation, e.g., 'Write monitors'.
	Description *string `json:"description,omitempty"`

	// Operation type, e.g., read, write, delete, etc.
	Operation *string `json:"operation,omitempty"`

	// Service provider, i.e., Microsoft.Logz.
	Provider *string `json:"provider,omitempty"`

	// Type on which the operation is performed, e.g., 'monitors'.
	Resource *string `json:"resource,omitempty"`
}

// OperationListResult - Result of GET request to list the Microsoft.Logz operations.
type OperationListResult struct {
	// URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`

	// List of operations supported by the Microsoft.Logz provider.
	Value []*OperationResult `json:"value,omitempty"`
}

// OperationResult - A Microsoft.Logz REST API operation.
type OperationResult struct {
	// The object that represents the operation.
	Display *OperationDisplay `json:"display,omitempty"`

	// Indicates whether the operation is a data action
	IsDataAction *bool `json:"isDataAction,omitempty"`

	// Operation name, i.e., {provider}/{resource}/{operation}.
	Name *string `json:"name,omitempty"`

	// Origin of the operation
	Origin *string `json:"origin,omitempty"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

type OrganizationProperties struct {
	// Name of the Logz organization.
	CompanyName *string `json:"companyName,omitempty"`

	// The Id of the Enterprise App used for Single sign on.
	EnterpriseAppID *string `json:"enterpriseAppId,omitempty"`

	// The login URL specific to this Logz Organization.
	SingleSignOnURL *string `json:"singleSignOnUrl,omitempty"`

	// READ-ONLY; Id of the Logz organization.
	ID *string `json:"id,omitempty" azure:"ro"`
}

type PlanData struct {
	// different billing cycles like MONTHLY/WEEKLY. this could be enum
	BillingCycle *string `json:"billingCycle,omitempty"`

	// date when plan was applied
	EffectiveDate *time.Time `json:"effectiveDate,omitempty"`

	// plan id as published by Logz
	PlanDetails *string `json:"planDetails,omitempty"`

	// different usage type like PAYG/COMMITTED. this could be enum
	UsageType *string `json:"usageType,omitempty"`
}

// SingleSignOnClientBeginCreateOrUpdateOptions contains the optional parameters for the SingleSignOnClient.BeginCreateOrUpdate
// method.
type SingleSignOnClientBeginCreateOrUpdateOptions struct {
	Body *SingleSignOnResource
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SingleSignOnClientGetOptions contains the optional parameters for the SingleSignOnClient.Get method.
type SingleSignOnClientGetOptions struct {
	// placeholder for future optional parameters
}

// SingleSignOnClientListOptions contains the optional parameters for the SingleSignOnClient.List method.
type SingleSignOnClientListOptions struct {
	// placeholder for future optional parameters
}

type SingleSignOnProperties struct {
	// The Id of the Enterprise App used for Single sign-on.
	EnterpriseAppID *string `json:"enterpriseAppId,omitempty"`

	// Various states of the SSO resource
	SingleSignOnState *SingleSignOnStates `json:"singleSignOnState,omitempty"`

	// The login URL specific to this Logz Organization.
	SingleSignOnURL *string `json:"singleSignOnUrl,omitempty"`

	// READ-ONLY; Flag specifying if the resource provisioning state as tracked by ARM.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

type SingleSignOnResource struct {
	Properties *SingleSignOnProperties `json:"properties,omitempty"`

	// READ-ONLY; ARM id of the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of the configuration.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SingleSignOnResourceListResponse - Response of a list operation.
type SingleSignOnResourceListResponse struct {
	// Link to the next set of results, if any.
	NextLink *string `json:"nextLink,omitempty"`

	// Results of a list operation.
	Value []*SingleSignOnResource `json:"value,omitempty"`
}

// SubAccountClientBeginCreateOptions contains the optional parameters for the SubAccountClient.BeginCreate method.
type SubAccountClientBeginCreateOptions struct {
	Body *MonitorResource
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SubAccountClientBeginDeleteOptions contains the optional parameters for the SubAccountClient.BeginDelete method.
type SubAccountClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SubAccountClientGetOptions contains the optional parameters for the SubAccountClient.Get method.
type SubAccountClientGetOptions struct {
	// placeholder for future optional parameters
}

// SubAccountClientListMonitoredResourcesOptions contains the optional parameters for the SubAccountClient.ListMonitoredResources
// method.
type SubAccountClientListMonitoredResourcesOptions struct {
	// placeholder for future optional parameters
}

// SubAccountClientListOptions contains the optional parameters for the SubAccountClient.List method.
type SubAccountClientListOptions struct {
	// placeholder for future optional parameters
}

// SubAccountClientListVMHostUpdateOptions contains the optional parameters for the SubAccountClient.ListVMHostUpdate method.
type SubAccountClientListVMHostUpdateOptions struct {
	// Request body to update the collection for agent installed in the given monitor.
	Body *VMHostUpdateRequest
}

// SubAccountClientListVMHostsOptions contains the optional parameters for the SubAccountClient.ListVMHosts method.
type SubAccountClientListVMHostsOptions struct {
	// placeholder for future optional parameters
}

// SubAccountClientUpdateOptions contains the optional parameters for the SubAccountClient.Update method.
type SubAccountClientUpdateOptions struct {
	Body *MonitorResourceUpdateParameters
}

// SubAccountClientVMHostPayloadOptions contains the optional parameters for the SubAccountClient.VMHostPayload method.
type SubAccountClientVMHostPayloadOptions struct {
	// placeholder for future optional parameters
}

// SubAccountTagRulesClientCreateOrUpdateOptions contains the optional parameters for the SubAccountTagRulesClient.CreateOrUpdate
// method.
type SubAccountTagRulesClientCreateOrUpdateOptions struct {
	Body *MonitoringTagRules
}

// SubAccountTagRulesClientDeleteOptions contains the optional parameters for the SubAccountTagRulesClient.Delete method.
type SubAccountTagRulesClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// SubAccountTagRulesClientGetOptions contains the optional parameters for the SubAccountTagRulesClient.Get method.
type SubAccountTagRulesClientGetOptions struct {
	// placeholder for future optional parameters
}

// SubAccountTagRulesClientListOptions contains the optional parameters for the SubAccountTagRulesClient.List method.
type SubAccountTagRulesClientListOptions struct {
	// placeholder for future optional parameters
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time `json:"createdAt,omitempty"`

	// The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`

	// The type of identity that created the resource.
	CreatedByType *CreatedByType `json:"createdByType,omitempty"`

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time `json:"lastModifiedAt,omitempty"`

	// The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType `json:"lastModifiedByType,omitempty"`
}

// TagRulesClientCreateOrUpdateOptions contains the optional parameters for the TagRulesClient.CreateOrUpdate method.
type TagRulesClientCreateOrUpdateOptions struct {
	Body *MonitoringTagRules
}

// TagRulesClientDeleteOptions contains the optional parameters for the TagRulesClient.Delete method.
type TagRulesClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// TagRulesClientGetOptions contains the optional parameters for the TagRulesClient.Get method.
type TagRulesClientGetOptions struct {
	// placeholder for future optional parameters
}

// TagRulesClientListOptions contains the optional parameters for the TagRulesClient.List method.
type TagRulesClientListOptions struct {
	// placeholder for future optional parameters
}

type UserInfo struct {
	// Email of the user used by Logz for contacting them if needed
	EmailAddress *string `json:"emailAddress,omitempty"`

	// First Name of the user
	FirstName *string `json:"firstName,omitempty"`

	// Last Name of the user
	LastName *string `json:"lastName,omitempty"`

	// Phone number of the user used by Logz for contacting them if needed
	PhoneNumber *string `json:"phoneNumber,omitempty"`
}

// UserRoleListResponse - Response for list of user's role for Logz.io account.
type UserRoleListResponse struct {
	// Link to the next set of results, if any.
	NextLink *string `json:"nextLink,omitempty"`

	// List of user roles for Logz.io account.
	Value []*UserRoleResponse `json:"value,omitempty"`
}

// UserRoleRequest - Request for checking user's role for Logz.io account.
type UserRoleRequest struct {
	// Email of the user used by Logz for contacting them if needed
	EmailAddress *string `json:"emailAddress,omitempty"`
}

// UserRoleResponse - Response for checking user's role for Logz.io account.
type UserRoleResponse struct {
	// User roles on configured in Logz.io account.
	Role *UserRole `json:"role,omitempty"`
}

// VMExtensionPayload - Response of payload to be passed while installing VM agent.
type VMExtensionPayload struct {
	// API Key corresponding to the resource.
	APIKey *string `json:"apiKey,omitempty"`

	// Logz.io region where the resource has been created.
	Region *string `json:"region,omitempty"`
}

// VMHostUpdateRequest - Request of a list VM Host Update Operation.
type VMHostUpdateRequest struct {
	// Specifies the state of the operation - install/ delete.
	State *VMHostUpdateStates `json:"state,omitempty"`

	// Request of a list vm host update operation.
	VMResourceIDs []*VMResources `json:"vmResourceIds,omitempty"`
}

// VMResources - VM Resource Ids
type VMResources struct {
	// Version of the Logz agent installed on the VM.
	AgentVersion *string `json:"agentVersion,omitempty"`

	// Request of a list vm host update operation.
	ID *string `json:"id,omitempty"`
}

// VMResourcesListResponse - Response of a list VM Host Update Operation.
type VMResourcesListResponse struct {
	// Link to the next set of results, if any.
	NextLink *string `json:"nextLink,omitempty"`

	// Response of a list vm host update operation.
	Value []*VMResources `json:"value,omitempty"`
}
