//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armedgeorder

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type AddressResource.
func (a AddressResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", a.ID)
	populate(objectMap, "location", a.Location)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "systemData", a.SystemData)
	populate(objectMap, "tags", a.Tags)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type AddressUpdateParameter.
func (a AddressUpdateParameter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "tags", a.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BillingMeterDetails.
func (b *BillingMeterDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "frequency":
			err = unpopulate(val, "Frequency", &b.Frequency)
			delete(rawMsg, key)
		case "meterDetails":
			b.MeterDetails, err = unmarshalMeterDetailsClassification(val)
			delete(rawMsg, key)
		case "meteringType":
			err = unpopulate(val, "MeteringType", &b.MeteringType)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &b.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConfigurationFilters.
func (c ConfigurationFilters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "filterableProperty", c.FilterableProperty)
	populate(objectMap, "hierarchyInformation", c.HierarchyInformation)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ConfigurationsRequest.
func (c ConfigurationsRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "configurationFilters", c.ConfigurationFilters)
	populate(objectMap, "customerSubscriptionDetails", c.CustomerSubscriptionDetails)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ContactDetails.
func (c ContactDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "contactName", c.ContactName)
	populate(objectMap, "emailList", c.EmailList)
	populate(objectMap, "mobile", c.Mobile)
	populate(objectMap, "phone", c.Phone)
	populate(objectMap, "phoneExtension", c.PhoneExtension)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type CustomerSubscriptionDetails.
func (c CustomerSubscriptionDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "locationPlacementId", c.LocationPlacementID)
	populate(objectMap, "quotaId", c.QuotaID)
	populate(objectMap, "registeredFeatures", c.RegisteredFeatures)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ErrorDetail.
func (e ErrorDetail) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "additionalInfo", e.AdditionalInfo)
	populate(objectMap, "code", e.Code)
	populate(objectMap, "details", e.Details)
	populate(objectMap, "message", e.Message)
	populate(objectMap, "target", e.Target)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type FilterableProperty.
func (f FilterableProperty) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "supportedValues", f.SupportedValues)
	populate(objectMap, "type", f.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type OrderItemDetails.
func (o OrderItemDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "cancellationReason", o.CancellationReason)
	populate(objectMap, "cancellationStatus", o.CancellationStatus)
	populate(objectMap, "currentStage", o.CurrentStage)
	populate(objectMap, "deletionStatus", o.DeletionStatus)
	populate(objectMap, "error", o.Error)
	populate(objectMap, "forwardShippingDetails", o.ForwardShippingDetails)
	populate(objectMap, "managementRpDetails", o.ManagementRpDetails)
	populate(objectMap, "managementRpDetailsList", o.ManagementRpDetailsList)
	populate(objectMap, "notificationEmailList", o.NotificationEmailList)
	populate(objectMap, "orderItemStageHistory", o.OrderItemStageHistory)
	populate(objectMap, "orderItemType", o.OrderItemType)
	populate(objectMap, "preferences", o.Preferences)
	populate(objectMap, "productDetails", o.ProductDetails)
	populate(objectMap, "returnReason", o.ReturnReason)
	populate(objectMap, "returnStatus", o.ReturnStatus)
	populate(objectMap, "reverseShippingDetails", o.ReverseShippingDetails)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type OrderItemProperties.
func (o OrderItemProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "addressDetails", o.AddressDetails)
	populate(objectMap, "orderId", o.OrderID)
	populate(objectMap, "orderItemDetails", o.OrderItemDetails)
	populateTimeRFC3339(objectMap, "startTime", o.StartTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OrderItemProperties.
func (o *OrderItemProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "addressDetails":
			err = unpopulate(val, "AddressDetails", &o.AddressDetails)
			delete(rawMsg, key)
		case "orderId":
			err = unpopulate(val, "OrderID", &o.OrderID)
			delete(rawMsg, key)
		case "orderItemDetails":
			err = unpopulate(val, "OrderItemDetails", &o.OrderItemDetails)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &o.StartTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OrderItemResource.
func (o OrderItemResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", o.ID)
	populate(objectMap, "location", o.Location)
	populate(objectMap, "name", o.Name)
	populate(objectMap, "properties", o.Properties)
	populate(objectMap, "systemData", o.SystemData)
	populate(objectMap, "tags", o.Tags)
	populate(objectMap, "type", o.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type OrderItemUpdateParameter.
func (o OrderItemUpdateParameter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", o.Properties)
	populate(objectMap, "tags", o.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type OrderItemUpdateProperties.
func (o OrderItemUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "forwardAddress", o.ForwardAddress)
	populate(objectMap, "notificationEmailList", o.NotificationEmailList)
	populate(objectMap, "preferences", o.Preferences)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type OrderProperties.
func (o OrderProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "currentStage", o.CurrentStage)
	populate(objectMap, "orderItemIds", o.OrderItemIDs)
	populate(objectMap, "orderStageHistory", o.OrderStageHistory)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Pav2MeterDetails.
func (p *Pav2MeterDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "billingType":
			err = unpopulate(val, "BillingType", &p.BillingType)
			delete(rawMsg, key)
		case "chargingType":
			err = unpopulate(val, "ChargingType", &p.ChargingType)
			delete(rawMsg, key)
		case "meterGuid":
			err = unpopulate(val, "MeterGUID", &p.MeterGUID)
			delete(rawMsg, key)
		case "multiplier":
			err = unpopulate(val, "Multiplier", &p.Multiplier)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Preferences.
func (p Preferences) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "encryptionPreferences", p.EncryptionPreferences)
	populate(objectMap, "managementResourcePreferences", p.ManagementResourcePreferences)
	populate(objectMap, "notificationPreferences", p.NotificationPreferences)
	populate(objectMap, "transportPreferences", p.TransportPreferences)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ProductDetails.
func (p ProductDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "count", p.Count)
	populate(objectMap, "deviceDetails", p.DeviceDetails)
	populate(objectMap, "displayInfo", p.DisplayInfo)
	populate(objectMap, "hierarchyInformation", p.HierarchyInformation)
	populate(objectMap, "productDoubleEncryptionStatus", p.ProductDoubleEncryptionStatus)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ProductFamiliesRequest.
func (p ProductFamiliesRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "customerSubscriptionDetails", p.CustomerSubscriptionDetails)
	populate(objectMap, "filterableProperties", p.FilterableProperties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PurchaseMeterDetails.
func (p *PurchaseMeterDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "billingType":
			err = unpopulate(val, "BillingType", &p.BillingType)
			delete(rawMsg, key)
		case "chargingType":
			err = unpopulate(val, "ChargingType", &p.ChargingType)
			delete(rawMsg, key)
		case "multiplier":
			err = unpopulate(val, "Multiplier", &p.Multiplier)
			delete(rawMsg, key)
		case "productId":
			err = unpopulate(val, "ProductID", &p.ProductID)
			delete(rawMsg, key)
		case "skuId":
			err = unpopulate(val, "SKUID", &p.SKUID)
			delete(rawMsg, key)
		case "termId":
			err = unpopulate(val, "TermID", &p.TermID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StageDetails.
func (s StageDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "displayName", s.DisplayName)
	populate(objectMap, "stageName", s.StageName)
	populate(objectMap, "stageStatus", s.StageStatus)
	populateTimeRFC3339(objectMap, "startTime", s.StartTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StageDetails.
func (s *StageDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "displayName":
			err = unpopulate(val, "DisplayName", &s.DisplayName)
			delete(rawMsg, key)
		case "stageName":
			err = unpopulate(val, "StageName", &s.StageName)
			delete(rawMsg, key)
		case "stageStatus":
			err = unpopulate(val, "StageStatus", &s.StageStatus)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &s.StartTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SystemData.
func (s SystemData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "createdAt", s.CreatedAt)
	populate(objectMap, "createdBy", s.CreatedBy)
	populate(objectMap, "createdByType", s.CreatedByType)
	populateTimeRFC3339(objectMap, "lastModifiedAt", s.LastModifiedAt)
	populate(objectMap, "lastModifiedBy", s.LastModifiedBy)
	populate(objectMap, "lastModifiedByType", s.LastModifiedByType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SystemData.
func (s *SystemData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdAt":
			err = unpopulateTimeRFC3339(val, "CreatedAt", &s.CreatedAt)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &s.CreatedBy)
			delete(rawMsg, key)
		case "createdByType":
			err = unpopulate(val, "CreatedByType", &s.CreatedByType)
			delete(rawMsg, key)
		case "lastModifiedAt":
			err = unpopulateTimeRFC3339(val, "LastModifiedAt", &s.LastModifiedAt)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, "LastModifiedBy", &s.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedByType":
			err = unpopulate(val, "LastModifiedByType", &s.LastModifiedByType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TrackedResource.
func (t TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", t.ID)
	populate(objectMap, "location", t.Location)
	populate(objectMap, "name", t.Name)
	populate(objectMap, "tags", t.Tags)
	populate(objectMap, "type", t.Type)
	return json.Marshal(objectMap)
}

func populate(m map[string]interface{}, k string, v interface{}) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v interface{}) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
