#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2025 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Wanderlust series:
# - Wanderlust: Travel Stories
# - Wanderlust: Transsiberian
# send your bug reports to vv221@dotslashplay.it
###

script_version=20250909.2

PLAYIT_COMPATIBILITY_LEVEL='2.33'

GAME_ID_TRAVELSTORIES='wanderlust-travel-stories'
GAME_NAME_TRAVELSTORIES='Wanderlust: Travel Stories'

GAME_ID_TRANSSIBERIAN='wanderlust-transsiberian'
GAME_NAME_TRANSSIBERIAN='Wanderlust: Transsiberian'

ARCHIVE_BASE_TRAVELSTORIES_0_NAME='wanderlust_travel_stories_1_5_34189.sh'
ARCHIVE_BASE_TRAVELSTORIES_0_MD5='af68a7b1d7b595d2f0548dc847b13ec8'
ARCHIVE_BASE_TRAVELSTORIES_0_SIZE='1334994'
ARCHIVE_BASE_TRAVELSTORIES_0_VERSION='1.5-gog34189'
ARCHIVE_BASE_TRAVELSTORIES_0_URL='https://www.gog.com/game/wanderlust_travel_stories'

ARCHIVE_BASE_TRANSSIBERIAN_0_NAME='wanderlust_transsiberian_1_1_13_2003271410_37232.sh'
ARCHIVE_BASE_TRANSSIBERIAN_0_MD5='bc70174132aa81a5f858e40812e4aa9c'
ARCHIVE_BASE_TRANSSIBERIAN_0_SIZE='493581'
ARCHIVE_BASE_TRANSSIBERIAN_0_VERSION='1.1.13-gog37232'
ARCHIVE_BASE_TRANSSIBERIAN_0_URL='https://www.gog.com/game/wanderlust_transsiberian'

UNITY3D_NAME_TRAVELSTORIES='Wanderlust'
UNITY3D_NAME_TRANSSIBERIAN='Transsiberian'
UNITY3D_PLUGINS='
libfmod.so
libfmodL.so
libfmodstudio.so
libfmodstudioL.so
libgvraudio.so
libresonanceaudio.so
ScreenSelector.so'

CONTENT_PATH_DEFAULT='data/noarch/game'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='64'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
PKG_BIN_DEPENDENCIES_LIBRARIES='
libatk-1.0.so.0
libcairo.so.2
libc.so.6
libdl.so.2
libfontconfig.so.1
libfreetype.so.6
libgcc_s.so.1
libgdk_pixbuf-2.0.so.0
libgdk-x11-2.0.so.0
libgio-2.0.so.0
libglib-2.0.so.0
libgobject-2.0.so.0
libgtk-x11-2.0.so.0
libm.so.6
libpango-1.0.so.0
libpangocairo-1.0.so.0
libpangoft2-1.0.so.0
libpthread.so.0
librt.so.1
libstdc++.so.6'

PKG_DATA_ID_TRAVELSTORIES="${GAME_ID_TRAVELSTORIES}-data"
PKG_DATA_ID_TRANSSIBERIAN="${GAME_ID_TRANSSIBERIAN}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions.

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run default initialisation actions.

initialization_default "$@"

# Extract game data.

archive_extraction_default

# Include game data.

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers.

## Thes games expect an executable stack through dynamically loaded libraries.
game_exec_line() {
	local application
	application="$1"

	local application_exe
	application_exe=$(application_exe "$application")
	cat <<- EOF
	GLIBC_TUNABLES=glibc.rtld.execstack=2 "./${application_exe}" "\$@"
	EOF
}

launchers_generation

# Build packages.

packages_generation
print_instructions

# Clean up.

working_directory_cleanup

exit 0
